/* DUPLICATOR-LITE (PHP BUILD MODE) MYSQL SCRIPT CREATED ON : 2024-11-04 01:08:03 */

/*!40101 SET @OLD_SQL_MODE=@@SQL_MODE, SQL_MODE='NO_AUTO_VALUE_ON_ZERO' */;

SET FOREIGN_KEY_CHECKS = 0;

CREATE TABLE `wp_actionscheduler_actions` (
  `action_id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `hook` varchar(191) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `status` varchar(20) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `scheduled_date_gmt` datetime DEFAULT '0000-00-00 00:00:00',
  `scheduled_date_local` datetime DEFAULT '0000-00-00 00:00:00',
  `priority` tinyint unsigned NOT NULL DEFAULT '10',
  `args` varchar(191) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `schedule` longtext COLLATE utf8mb4_unicode_520_ci,
  `group_id` bigint unsigned NOT NULL DEFAULT '0',
  `attempts` int NOT NULL DEFAULT '0',
  `last_attempt_gmt` datetime DEFAULT '0000-00-00 00:00:00',
  `last_attempt_local` datetime DEFAULT '0000-00-00 00:00:00',
  `claim_id` bigint unsigned NOT NULL DEFAULT '0',
  `extended_args` varchar(8000) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  PRIMARY KEY (`action_id`),
  KEY `hook` (`hook`),
  KEY `status` (`status`),
  KEY `scheduled_date_gmt` (`scheduled_date_gmt`),
  KEY `args` (`args`),
  KEY `group_id` (`group_id`),
  KEY `last_attempt_gmt` (`last_attempt_gmt`),
  KEY `claim_id_status_scheduled_date_gmt` (`claim_id`,`status`,`scheduled_date_gmt`)
) ENGINE=MyISAM AUTO_INCREMENT=4224 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_actionscheduler_claims` (
  `claim_id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `date_created_gmt` datetime DEFAULT '0000-00-00 00:00:00',
  PRIMARY KEY (`claim_id`),
  KEY `date_created_gmt` (`date_created_gmt`)
) ENGINE=MyISAM AUTO_INCREMENT=5969 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_actionscheduler_groups` (
  `group_id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `slug` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  PRIMARY KEY (`group_id`),
  KEY `slug` (`slug`(191))
) ENGINE=MyISAM AUTO_INCREMENT=3 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_actionscheduler_logs` (
  `log_id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `action_id` bigint unsigned NOT NULL,
  `message` text COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `log_date_gmt` datetime DEFAULT '0000-00-00 00:00:00',
  `log_date_local` datetime DEFAULT '0000-00-00 00:00:00',
  PRIMARY KEY (`log_id`),
  KEY `action_id` (`action_id`),
  KEY `log_date_gmt` (`log_date_gmt`)
) ENGINE=MyISAM AUTO_INCREMENT=12660 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_commentmeta` (
  `meta_id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `comment_id` bigint unsigned NOT NULL DEFAULT '0',
  `meta_key` varchar(255) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `meta_value` longtext COLLATE utf8mb4_unicode_520_ci,
  PRIMARY KEY (`meta_id`),
  KEY `comment_id` (`comment_id`),
  KEY `meta_key` (`meta_key`(191))
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_comments` (
  `comment_ID` bigint unsigned NOT NULL AUTO_INCREMENT,
  `comment_post_ID` bigint unsigned NOT NULL DEFAULT '0',
  `comment_author` tinytext COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `comment_author_email` varchar(100) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `comment_author_url` varchar(200) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `comment_author_IP` varchar(100) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `comment_date` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `comment_date_gmt` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `comment_content` text COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `comment_karma` int NOT NULL DEFAULT '0',
  `comment_approved` varchar(20) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '1',
  `comment_agent` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `comment_type` varchar(20) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT 'comment',
  `comment_parent` bigint unsigned NOT NULL DEFAULT '0',
  `user_id` bigint unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`comment_ID`),
  KEY `comment_post_ID` (`comment_post_ID`),
  KEY `comment_approved_date_gmt` (`comment_approved`,`comment_date_gmt`),
  KEY `comment_date_gmt` (`comment_date_gmt`),
  KEY `comment_parent` (`comment_parent`),
  KEY `comment_author_email` (`comment_author_email`(10))
) ENGINE=MyISAM AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_duplicator_packages` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(250) NOT NULL,
  `hash` varchar(50) NOT NULL,
  `status` int NOT NULL,
  `created` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `owner` varchar(60) NOT NULL,
  `package` longtext NOT NULL,
  PRIMARY KEY (`id`),
  KEY `hash` (`hash`)
) ENGINE=MyISAM AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci;

CREATE TABLE `wp_frmt_form_entry` (
  `entry_id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `entry_type` varchar(191) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `draft_id` varchar(12) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `form_id` bigint unsigned NOT NULL,
  `is_spam` tinyint(1) NOT NULL DEFAULT '0',
  `date_created` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  PRIMARY KEY (`entry_id`),
  KEY `entry_is_spam` (`is_spam`),
  KEY `entry_type` (`entry_type`),
  KEY `entry_form_id` (`form_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_frmt_form_entry_meta` (
  `meta_id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `entry_id` bigint unsigned NOT NULL,
  `meta_key` varchar(191) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `meta_value` longtext COLLATE utf8mb4_unicode_520_ci,
  `date_created` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `date_updated` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  PRIMARY KEY (`meta_id`),
  KEY `meta_key` (`meta_key`),
  KEY `meta_entry_id` (`entry_id`),
  KEY `meta_key_object` (`entry_id`,`meta_key`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_frmt_form_reports` (
  `report_id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `report_value` longtext COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `status` varchar(200) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `date_created` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `date_updated` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  PRIMARY KEY (`report_id`)
) ENGINE=MyISAM AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_frmt_form_views` (
  `view_id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `form_id` bigint unsigned NOT NULL,
  `page_id` bigint unsigned NOT NULL,
  `ip` varchar(191) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `count` mediumint unsigned NOT NULL DEFAULT '1',
  `date_created` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `date_updated` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  PRIMARY KEY (`view_id`),
  KEY `view_form_id` (`form_id`),
  KEY `view_ip` (`ip`),
  KEY `view_form_object` (`form_id`,`view_id`),
  KEY `view_form_object_ip` (`form_id`,`view_id`,`ip`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_links` (
  `link_id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `link_url` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `link_name` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `link_image` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `link_target` varchar(25) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `link_description` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `link_visible` varchar(20) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT 'Y',
  `link_owner` bigint unsigned NOT NULL DEFAULT '1',
  `link_rating` int NOT NULL DEFAULT '0',
  `link_updated` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `link_rel` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `link_notes` mediumtext COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `link_rss` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  PRIMARY KEY (`link_id`),
  KEY `link_visible` (`link_visible`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_options` (
  `option_id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `option_name` varchar(191) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `option_value` longtext COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `autoload` varchar(20) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT 'yes',
  PRIMARY KEY (`option_id`),
  UNIQUE KEY `option_name` (`option_name`),
  KEY `autoload` (`autoload`)
) ENGINE=MyISAM AUTO_INCREMENT=3489 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_postmeta` (
  `meta_id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `post_id` bigint unsigned NOT NULL DEFAULT '0',
  `meta_key` varchar(255) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `meta_value` longtext COLLATE utf8mb4_unicode_520_ci,
  PRIMARY KEY (`meta_id`),
  KEY `post_id` (`post_id`),
  KEY `meta_key` (`meta_key`(191))
) ENGINE=MyISAM AUTO_INCREMENT=1717 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_posts` (
  `ID` bigint unsigned NOT NULL AUTO_INCREMENT,
  `post_author` bigint unsigned NOT NULL DEFAULT '0',
  `post_date` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `post_date_gmt` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `post_content` longtext COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `post_title` text COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `post_excerpt` text COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `post_status` varchar(20) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT 'publish',
  `comment_status` varchar(20) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT 'open',
  `ping_status` varchar(20) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT 'open',
  `post_password` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `post_name` varchar(200) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `to_ping` text COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `pinged` text COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `post_modified` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `post_modified_gmt` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `post_content_filtered` longtext COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `post_parent` bigint unsigned NOT NULL DEFAULT '0',
  `guid` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `menu_order` int NOT NULL DEFAULT '0',
  `post_type` varchar(20) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT 'post',
  `post_mime_type` varchar(100) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `comment_count` bigint NOT NULL DEFAULT '0',
  PRIMARY KEY (`ID`),
  KEY `post_name` (`post_name`(191)),
  KEY `type_status_date` (`post_type`,`post_status`,`post_date`,`ID`),
  KEY `post_parent` (`post_parent`),
  KEY `post_author` (`post_author`)
) ENGINE=MyISAM AUTO_INCREMENT=1576 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_swpm_members_tbl` (
  `member_id` int NOT NULL AUTO_INCREMENT,
  `user_name` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `first_name` varchar(64) COLLATE utf8mb4_unicode_520_ci DEFAULT '',
  `last_name` varchar(64) COLLATE utf8mb4_unicode_520_ci DEFAULT '',
  `password` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `member_since` date NOT NULL DEFAULT '0000-00-00',
  `membership_level` smallint NOT NULL,
  `more_membership_levels` varchar(100) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `account_state` enum('active','inactive','activation_required','expired','pending','unsubscribed') COLLATE utf8mb4_unicode_520_ci DEFAULT 'pending',
  `last_accessed` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `last_accessed_from_ip` varchar(128) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `email` varchar(255) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `phone` varchar(64) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `address_street` varchar(255) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `address_city` varchar(255) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `address_state` varchar(255) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `address_zipcode` varchar(255) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `home_page` varchar(255) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `country` varchar(255) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `gender` enum('male','female','not specified') COLLATE utf8mb4_unicode_520_ci DEFAULT 'not specified',
  `referrer` varchar(255) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `extra_info` text COLLATE utf8mb4_unicode_520_ci,
  `reg_code` varchar(255) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `subscription_starts` date DEFAULT NULL,
  `initial_membership_level` smallint DEFAULT NULL,
  `txn_id` varchar(255) COLLATE utf8mb4_unicode_520_ci DEFAULT '',
  `subscr_id` varchar(255) COLLATE utf8mb4_unicode_520_ci DEFAULT '',
  `company_name` varchar(255) COLLATE utf8mb4_unicode_520_ci DEFAULT '',
  `notes` text COLLATE utf8mb4_unicode_520_ci,
  `flags` int DEFAULT '0',
  `profile_image` varchar(255) COLLATE utf8mb4_unicode_520_ci DEFAULT '',
  PRIMARY KEY (`member_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_swpm_membership_meta_tbl` (
  `id` int NOT NULL AUTO_INCREMENT,
  `level_id` int NOT NULL,
  `meta_key` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `meta_label` varchar(255) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `meta_value` text COLLATE utf8mb4_unicode_520_ci,
  `meta_type` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT 'text',
  `meta_default` text COLLATE utf8mb4_unicode_520_ci,
  `meta_context` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT 'default',
  PRIMARY KEY (`id`),
  KEY `level_id` (`level_id`)
) ENGINE=MyISAM AUTO_INCREMENT=3 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_swpm_membership_tbl` (
  `id` int NOT NULL AUTO_INCREMENT,
  `alias` varchar(127) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `role` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT 'subscriber',
  `permissions` tinyint NOT NULL DEFAULT '0',
  `subscription_period` varchar(11) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '-1',
  `subscription_duration_type` tinyint NOT NULL DEFAULT '0',
  `subscription_unit` varchar(20) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `loginredirect_page` text COLLATE utf8mb4_unicode_520_ci,
  `category_list` longtext COLLATE utf8mb4_unicode_520_ci,
  `page_list` longtext COLLATE utf8mb4_unicode_520_ci,
  `post_list` longtext COLLATE utf8mb4_unicode_520_ci,
  `comment_list` longtext COLLATE utf8mb4_unicode_520_ci,
  `attachment_list` longtext COLLATE utf8mb4_unicode_520_ci,
  `custom_post_list` longtext COLLATE utf8mb4_unicode_520_ci,
  `disable_bookmark_list` longtext COLLATE utf8mb4_unicode_520_ci,
  `options` longtext COLLATE utf8mb4_unicode_520_ci,
  `protect_older_posts` tinyint(1) NOT NULL DEFAULT '0',
  `campaign_name` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=3 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_swpm_payments_tbl` (
  `id` int NOT NULL AUTO_INCREMENT,
  `email` varchar(255) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `first_name` varchar(64) COLLATE utf8mb4_unicode_520_ci DEFAULT '',
  `last_name` varchar(64) COLLATE utf8mb4_unicode_520_ci DEFAULT '',
  `member_id` varchar(16) COLLATE utf8mb4_unicode_520_ci DEFAULT '',
  `membership_level` varchar(64) COLLATE utf8mb4_unicode_520_ci DEFAULT '',
  `txn_date` date NOT NULL DEFAULT '0000-00-00',
  `txn_id` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `subscr_id` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `reference` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `payment_amount` varchar(32) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `gateway` varchar(32) COLLATE utf8mb4_unicode_520_ci DEFAULT '',
  `status` varchar(255) COLLATE utf8mb4_unicode_520_ci DEFAULT '',
  `ip_address` varchar(128) COLLATE utf8mb4_unicode_520_ci DEFAULT '',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_term_relationships` (
  `object_id` bigint unsigned NOT NULL DEFAULT '0',
  `term_taxonomy_id` bigint unsigned NOT NULL DEFAULT '0',
  `term_order` int NOT NULL DEFAULT '0',
  PRIMARY KEY (`object_id`,`term_taxonomy_id`),
  KEY `term_taxonomy_id` (`term_taxonomy_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_term_taxonomy` (
  `term_taxonomy_id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `term_id` bigint unsigned NOT NULL DEFAULT '0',
  `taxonomy` varchar(32) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `description` longtext COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `parent` bigint unsigned NOT NULL DEFAULT '0',
  `count` bigint NOT NULL DEFAULT '0',
  PRIMARY KEY (`term_taxonomy_id`),
  UNIQUE KEY `term_id_taxonomy` (`term_id`,`taxonomy`),
  KEY `taxonomy` (`taxonomy`)
) ENGINE=MyISAM AUTO_INCREMENT=3 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_termmeta` (
  `meta_id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `term_id` bigint unsigned NOT NULL DEFAULT '0',
  `meta_key` varchar(255) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `meta_value` longtext COLLATE utf8mb4_unicode_520_ci,
  PRIMARY KEY (`meta_id`),
  KEY `term_id` (`term_id`),
  KEY `meta_key` (`meta_key`(191))
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_terms` (
  `term_id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(200) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `slug` varchar(200) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `term_group` bigint NOT NULL DEFAULT '0',
  PRIMARY KEY (`term_id`),
  KEY `slug` (`slug`(191)),
  KEY `name` (`name`(191))
) ENGINE=MyISAM AUTO_INCREMENT=3 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_usermeta` (
  `umeta_id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `user_id` bigint unsigned NOT NULL DEFAULT '0',
  `meta_key` varchar(255) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `meta_value` longtext COLLATE utf8mb4_unicode_520_ci,
  PRIMARY KEY (`umeta_id`),
  KEY `user_id` (`user_id`),
  KEY `meta_key` (`meta_key`(191))
) ENGINE=MyISAM AUTO_INCREMENT=27 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_users` (
  `ID` bigint unsigned NOT NULL AUTO_INCREMENT,
  `user_login` varchar(60) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `user_pass` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `user_nicename` varchar(50) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `user_email` varchar(100) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `user_url` varchar(100) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `user_registered` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `user_activation_key` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `user_status` int NOT NULL DEFAULT '0',
  `display_name` varchar(250) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  PRIMARY KEY (`ID`),
  KEY `user_login_key` (`user_login`),
  KEY `user_nicename` (`user_nicename`),
  KEY `user_email` (`user_email`)
) ENGINE=MyISAM AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

/***** TABLE CREATION END *****/


/* INSERT TABLE DATA: wp_actionscheduler_actions */
INSERT INTO `wp_actionscheduler_actions` VALUES("4213", "forminator_send_export", "complete", "2024-11-04 01:04:10", "2024-11-04 02:04:10", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1730682250;s:18:\"\0*\0first_timestamp\";i:1726934689;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1730682250;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2024-11-04 01:04:16", "2024-11-04 02:04:16", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("4163", "forminator_send_export", "complete", "2024-11-03 23:27:22", "2024-11-04 00:27:22", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1730676442;s:18:\"\0*\0first_timestamp\";i:1726934689;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1730676442;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2024-11-03 23:28:22", "2024-11-04 00:28:22", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("4160", "forminator_general_data_protection_cleanup", "complete", "2024-11-04 00:24:23", "2024-11-04 01:24:23", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1730679863;s:18:\"\0*\0first_timestamp\";i:1726934679;s:13:\"\0*\0recurrence\";i:3600;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1730679863;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:3600;}", "1", "1", "2024-11-04 01:03:10", "2024-11-04 02:03:10", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("4214", "forminator_process_report", "complete", "2024-11-04 01:04:10", "2024-11-04 02:04:10", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1730682250;s:18:\"\0*\0first_timestamp\";i:1726934699;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1730682250;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2024-11-04 01:04:16", "2024-11-04 02:04:16", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("4215", "forminator_general_data_protection_cleanup", "pending", "2024-11-04 02:03:10", "2024-11-04 03:03:10", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1730685790;s:18:\"\0*\0first_timestamp\";i:1726934679;s:13:\"\0*\0recurrence\";i:3600;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1730685790;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:3600;}", "1", "0", "0000-00-00 00:00:00", "0000-00-00 00:00:00", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("4216", "forminator_send_export", "complete", "2024-11-04 01:05:16", "2024-11-04 02:05:16", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1730682316;s:18:\"\0*\0first_timestamp\";i:1726934689;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1730682316;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2024-11-04 01:05:47", "2024-11-04 02:05:47", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("4217", "forminator_process_report", "complete", "2024-11-04 01:05:16", "2024-11-04 02:05:16", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1730682316;s:18:\"\0*\0first_timestamp\";i:1726934699;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1730682316;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2024-11-04 01:05:47", "2024-11-04 02:05:47", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("4218", "forminator_send_export", "complete", "2024-11-04 01:06:47", "2024-11-04 02:06:47", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1730682407;s:18:\"\0*\0first_timestamp\";i:1726934689;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1730682407;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2024-11-04 01:07:01", "2024-11-04 02:07:01", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("4219", "forminator_process_report", "complete", "2024-11-04 01:06:47", "2024-11-04 02:06:47", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1730682407;s:18:\"\0*\0first_timestamp\";i:1726934699;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1730682407;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2024-11-04 01:07:01", "2024-11-04 02:07:01", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("4220", "forminator_send_export", "complete", "2024-11-04 01:08:01", "2024-11-04 02:08:01", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1730682481;s:18:\"\0*\0first_timestamp\";i:1726934689;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1730682481;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2024-11-04 01:08:02", "2024-11-04 02:08:02", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("4221", "forminator_process_report", "complete", "2024-11-04 01:08:01", "2024-11-04 02:08:01", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1730682481;s:18:\"\0*\0first_timestamp\";i:1726934699;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1730682481;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2024-11-04 01:08:02", "2024-11-04 02:08:02", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("4222", "forminator_send_export", "pending", "2024-11-04 01:09:02", "2024-11-04 02:09:02", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1730682542;s:18:\"\0*\0first_timestamp\";i:1726934689;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1730682542;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "0", "0000-00-00 00:00:00", "0000-00-00 00:00:00", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("4223", "forminator_process_report", "pending", "2024-11-04 01:09:02", "2024-11-04 02:09:02", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1730682542;s:18:\"\0*\0first_timestamp\";i:1726934699;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1730682542;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "0", "0000-00-00 00:00:00", "0000-00-00 00:00:00", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("4212", "forminator_process_report", "complete", "2024-11-04 00:15:39", "2024-11-04 01:15:39", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1730679339;s:18:\"\0*\0first_timestamp\";i:1726934699;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1730679339;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2024-11-04 01:03:10", "2024-11-04 02:03:10", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("4211", "forminator_send_export", "complete", "2024-11-04 00:15:39", "2024-11-04 01:15:39", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1730679339;s:18:\"\0*\0first_timestamp\";i:1726934689;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1730679339;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2024-11-04 01:03:10", "2024-11-04 02:03:10", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("4210", "forminator_process_report", "complete", "2024-11-04 00:13:38", "2024-11-04 01:13:38", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1730679218;s:18:\"\0*\0first_timestamp\";i:1726934699;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1730679218;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2024-11-04 00:14:39", "2024-11-04 01:14:39", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("4158", "forminator_send_export", "complete", "2024-11-03 23:25:23", "2024-11-04 00:25:23", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1730676323;s:18:\"\0*\0first_timestamp\";i:1726934689;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1730676323;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2024-11-03 23:26:22", "2024-11-04 00:26:22", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("4159", "forminator_process_report", "complete", "2024-11-03 23:25:23", "2024-11-04 00:25:23", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1730676323;s:18:\"\0*\0first_timestamp\";i:1726934699;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1730676323;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2024-11-03 23:26:22", "2024-11-04 00:26:22", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("4164", "forminator_process_report", "complete", "2024-11-03 23:27:22", "2024-11-04 00:27:22", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1730676442;s:18:\"\0*\0first_timestamp\";i:1726934699;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1730676442;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2024-11-03 23:28:22", "2024-11-04 00:28:22", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("4113", "forminator_action_scheduler_cleanup", "complete", "2024-11-03 18:06:57", "2024-11-03 19:06:57", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1730657217;s:18:\"\0*\0first_timestamp\";i:1726934679;s:13:\"\0*\0recurrence\";i:7200;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1730657217;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:7200;}", "1", "1", "2024-11-03 23:24:23", "2024-11-04 00:24:23", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("4209", "forminator_send_export", "complete", "2024-11-04 00:13:38", "2024-11-04 01:13:38", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1730679218;s:18:\"\0*\0first_timestamp\";i:1726934689;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1730679218;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2024-11-04 00:14:39", "2024-11-04 01:14:39", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("4208", "forminator_process_report", "complete", "2024-11-04 00:11:37", "2024-11-04 01:11:37", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1730679097;s:18:\"\0*\0first_timestamp\";i:1726934699;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1730679097;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2024-11-04 00:12:38", "2024-11-04 01:12:38", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("4161", "forminator_action_scheduler_cleanup", "pending", "2024-11-04 01:24:23", "2024-11-04 02:24:23", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1730683463;s:18:\"\0*\0first_timestamp\";i:1726934679;s:13:\"\0*\0recurrence\";i:7200;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1730683463;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:7200;}", "1", "0", "0000-00-00 00:00:00", "0000-00-00 00:00:00", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("4162", "forminator_daily_cron", "pending", "2024-11-05 00:26:22", "2024-11-05 01:26:22", "10", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1730766382;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1730766382;}", "1", "0", "0000-00-00 00:00:00", "0000-00-00 00:00:00", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("4165", "forminator_send_export", "complete", "2024-11-03 23:29:22", "2024-11-04 00:29:22", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1730676562;s:18:\"\0*\0first_timestamp\";i:1726934689;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1730676562;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2024-11-03 23:30:23", "2024-11-04 00:30:23", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("4166", "forminator_process_report", "complete", "2024-11-03 23:29:22", "2024-11-04 00:29:22", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1730676562;s:18:\"\0*\0first_timestamp\";i:1726934699;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1730676562;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2024-11-03 23:30:23", "2024-11-04 00:30:23", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("4167", "forminator_send_export", "complete", "2024-11-03 23:31:23", "2024-11-04 00:31:23", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1730676683;s:18:\"\0*\0first_timestamp\";i:1726934689;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1730676683;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2024-11-03 23:32:19", "2024-11-04 00:32:19", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("4168", "forminator_process_report", "complete", "2024-11-03 23:31:23", "2024-11-04 00:31:23", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1730676683;s:18:\"\0*\0first_timestamp\";i:1726934699;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1730676683;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2024-11-03 23:32:19", "2024-11-04 00:32:19", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("4169", "forminator_send_export", "complete", "2024-11-03 23:33:19", "2024-11-04 00:33:19", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1730676799;s:18:\"\0*\0first_timestamp\";i:1726934689;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1730676799;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2024-11-03 23:34:19", "2024-11-04 00:34:19", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("4170", "forminator_process_report", "complete", "2024-11-03 23:33:19", "2024-11-04 00:33:19", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1730676799;s:18:\"\0*\0first_timestamp\";i:1726934699;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1730676799;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2024-11-03 23:34:19", "2024-11-04 00:34:19", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("4171", "forminator_send_export", "complete", "2024-11-03 23:35:19", "2024-11-04 00:35:19", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1730676919;s:18:\"\0*\0first_timestamp\";i:1726934689;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1730676919;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2024-11-03 23:36:19", "2024-11-04 00:36:19", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("4172", "forminator_process_report", "complete", "2024-11-03 23:35:19", "2024-11-04 00:35:19", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1730676919;s:18:\"\0*\0first_timestamp\";i:1726934699;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1730676919;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2024-11-03 23:36:19", "2024-11-04 00:36:19", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("4173", "forminator_send_export", "complete", "2024-11-03 23:37:19", "2024-11-04 00:37:19", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1730677039;s:18:\"\0*\0first_timestamp\";i:1726934689;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1730677039;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2024-11-03 23:38:21", "2024-11-04 00:38:21", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("4174", "forminator_process_report", "complete", "2024-11-03 23:37:19", "2024-11-04 00:37:19", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1730677039;s:18:\"\0*\0first_timestamp\";i:1726934699;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1730677039;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2024-11-03 23:38:21", "2024-11-04 00:38:21", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("4175", "forminator_send_export", "complete", "2024-11-03 23:39:21", "2024-11-04 00:39:21", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1730677161;s:18:\"\0*\0first_timestamp\";i:1726934689;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1730677161;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2024-11-03 23:40:22", "2024-11-04 00:40:22", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("4176", "forminator_process_report", "complete", "2024-11-03 23:39:21", "2024-11-04 00:39:21", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1730677161;s:18:\"\0*\0first_timestamp\";i:1726934699;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1730677161;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2024-11-03 23:40:22", "2024-11-04 00:40:22", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("4177", "forminator_send_export", "complete", "2024-11-03 23:41:22", "2024-11-04 00:41:22", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1730677282;s:18:\"\0*\0first_timestamp\";i:1726934689;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1730677282;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2024-11-03 23:42:23", "2024-11-04 00:42:23", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("4178", "forminator_process_report", "complete", "2024-11-03 23:41:22", "2024-11-04 00:41:22", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1730677282;s:18:\"\0*\0first_timestamp\";i:1726934699;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1730677282;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2024-11-03 23:42:23", "2024-11-04 00:42:23", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("4179", "forminator_send_export", "complete", "2024-11-03 23:43:23", "2024-11-04 00:43:23", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1730677403;s:18:\"\0*\0first_timestamp\";i:1726934689;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1730677403;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2024-11-03 23:44:24", "2024-11-04 00:44:24", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("4180", "forminator_process_report", "complete", "2024-11-03 23:43:23", "2024-11-04 00:43:23", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1730677403;s:18:\"\0*\0first_timestamp\";i:1726934699;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1730677403;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2024-11-03 23:44:24", "2024-11-04 00:44:24", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("4181", "forminator_send_export", "complete", "2024-11-03 23:45:24", "2024-11-04 00:45:24", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1730677524;s:18:\"\0*\0first_timestamp\";i:1726934689;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1730677524;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2024-11-03 23:46:26", "2024-11-04 00:46:26", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("4182", "forminator_process_report", "complete", "2024-11-03 23:45:24", "2024-11-04 00:45:24", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1730677524;s:18:\"\0*\0first_timestamp\";i:1726934699;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1730677524;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2024-11-03 23:46:26", "2024-11-04 00:46:26", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("4183", "forminator_send_export", "complete", "2024-11-03 23:47:26", "2024-11-04 00:47:26", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1730677646;s:18:\"\0*\0first_timestamp\";i:1726934689;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1730677646;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2024-11-03 23:48:26", "2024-11-04 00:48:26", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("4184", "forminator_process_report", "complete", "2024-11-03 23:47:26", "2024-11-04 00:47:26", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1730677646;s:18:\"\0*\0first_timestamp\";i:1726934699;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1730677646;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2024-11-03 23:48:26", "2024-11-04 00:48:26", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("4185", "forminator_send_export", "complete", "2024-11-03 23:49:26", "2024-11-04 00:49:26", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1730677766;s:18:\"\0*\0first_timestamp\";i:1726934689;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1730677766;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2024-11-03 23:50:27", "2024-11-04 00:50:27", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("4186", "forminator_process_report", "complete", "2024-11-03 23:49:26", "2024-11-04 00:49:26", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1730677766;s:18:\"\0*\0first_timestamp\";i:1726934699;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1730677766;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2024-11-03 23:50:27", "2024-11-04 00:50:27", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("4187", "forminator_send_export", "complete", "2024-11-03 23:51:27", "2024-11-04 00:51:27", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1730677887;s:18:\"\0*\0first_timestamp\";i:1726934689;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1730677887;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2024-11-03 23:52:28", "2024-11-04 00:52:28", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("4188", "forminator_process_report", "complete", "2024-11-03 23:51:27", "2024-11-04 00:51:27", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1730677887;s:18:\"\0*\0first_timestamp\";i:1726934699;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1730677887;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2024-11-03 23:52:28", "2024-11-04 00:52:28", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("4189", "forminator_send_export", "complete", "2024-11-03 23:53:28", "2024-11-04 00:53:28", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1730678008;s:18:\"\0*\0first_timestamp\";i:1726934689;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1730678008;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2024-11-03 23:54:29", "2024-11-04 00:54:29", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("4190", "forminator_process_report", "complete", "2024-11-03 23:53:28", "2024-11-04 00:53:28", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1730678008;s:18:\"\0*\0first_timestamp\";i:1726934699;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1730678008;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2024-11-03 23:54:29", "2024-11-04 00:54:29", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("4191", "forminator_send_export", "complete", "2024-11-03 23:55:29", "2024-11-04 00:55:29", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1730678129;s:18:\"\0*\0first_timestamp\";i:1726934689;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1730678129;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2024-11-03 23:56:30", "2024-11-04 00:56:30", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("4192", "forminator_process_report", "complete", "2024-11-03 23:55:29", "2024-11-04 00:55:29", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1730678129;s:18:\"\0*\0first_timestamp\";i:1726934699;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1730678129;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2024-11-03 23:56:30", "2024-11-04 00:56:30", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("4193", "forminator_send_export", "complete", "2024-11-03 23:57:30", "2024-11-04 00:57:30", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1730678250;s:18:\"\0*\0first_timestamp\";i:1726934689;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1730678250;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2024-11-03 23:58:31", "2024-11-04 00:58:31", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("4194", "forminator_process_report", "complete", "2024-11-03 23:57:30", "2024-11-04 00:57:30", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1730678250;s:18:\"\0*\0first_timestamp\";i:1726934699;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1730678250;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2024-11-03 23:58:31", "2024-11-04 00:58:31", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("4195", "forminator_send_export", "complete", "2024-11-03 23:59:31", "2024-11-04 00:59:31", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1730678371;s:18:\"\0*\0first_timestamp\";i:1726934689;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1730678371;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2024-11-04 00:00:32", "2024-11-04 01:00:32", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("4196", "forminator_process_report", "complete", "2024-11-03 23:59:31", "2024-11-04 00:59:31", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1730678371;s:18:\"\0*\0first_timestamp\";i:1726934699;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1730678371;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2024-11-04 00:00:32", "2024-11-04 01:00:32", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("4197", "forminator_send_export", "complete", "2024-11-04 00:01:32", "2024-11-04 01:01:32", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1730678492;s:18:\"\0*\0first_timestamp\";i:1726934689;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1730678492;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2024-11-04 00:02:33", "2024-11-04 01:02:33", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("4198", "forminator_process_report", "complete", "2024-11-04 00:01:32", "2024-11-04 01:01:32", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1730678492;s:18:\"\0*\0first_timestamp\";i:1726934699;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1730678492;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2024-11-04 00:02:33", "2024-11-04 01:02:33", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("4199", "forminator_send_export", "complete", "2024-11-04 00:03:33", "2024-11-04 01:03:33", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1730678613;s:18:\"\0*\0first_timestamp\";i:1726934689;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1730678613;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2024-11-04 00:04:34", "2024-11-04 01:04:34", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("4200", "forminator_process_report", "complete", "2024-11-04 00:03:33", "2024-11-04 01:03:33", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1730678613;s:18:\"\0*\0first_timestamp\";i:1726934699;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1730678613;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2024-11-04 00:04:34", "2024-11-04 01:04:34", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("4201", "forminator_send_export", "complete", "2024-11-04 00:05:34", "2024-11-04 01:05:34", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1730678734;s:18:\"\0*\0first_timestamp\";i:1726934689;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1730678734;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2024-11-04 00:06:35", "2024-11-04 01:06:35", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("4202", "forminator_process_report", "complete", "2024-11-04 00:05:34", "2024-11-04 01:05:34", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1730678734;s:18:\"\0*\0first_timestamp\";i:1726934699;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1730678734;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2024-11-04 00:06:35", "2024-11-04 01:06:35", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("4203", "forminator_send_export", "complete", "2024-11-04 00:07:35", "2024-11-04 01:07:35", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1730678855;s:18:\"\0*\0first_timestamp\";i:1726934689;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1730678855;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2024-11-04 00:08:36", "2024-11-04 01:08:36", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("4204", "forminator_process_report", "complete", "2024-11-04 00:07:35", "2024-11-04 01:07:35", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1730678855;s:18:\"\0*\0first_timestamp\";i:1726934699;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1730678855;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2024-11-04 00:08:36", "2024-11-04 01:08:36", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("4205", "forminator_send_export", "complete", "2024-11-04 00:09:36", "2024-11-04 01:09:36", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1730678976;s:18:\"\0*\0first_timestamp\";i:1726934689;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1730678976;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2024-11-04 00:10:37", "2024-11-04 01:10:37", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("4206", "forminator_process_report", "complete", "2024-11-04 00:09:36", "2024-11-04 01:09:36", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1730678976;s:18:\"\0*\0first_timestamp\";i:1726934699;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1730678976;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2024-11-04 00:10:37", "2024-11-04 01:10:37", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("4207", "forminator_send_export", "complete", "2024-11-04 00:11:37", "2024-11-04 01:11:37", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1730679097;s:18:\"\0*\0first_timestamp\";i:1726934689;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1730679097;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2024-11-04 00:12:38", "2024-11-04 01:12:38", "0", NULL);

/* INSERT TABLE DATA: wp_actionscheduler_groups */
INSERT INTO `wp_actionscheduler_groups` VALUES("1", "forminator");
INSERT INTO `wp_actionscheduler_groups` VALUES("2", "action-scheduler-migration");

/* INSERT TABLE DATA: wp_actionscheduler_logs */
INSERT INTO `wp_actionscheduler_logs` VALUES("12619", "4208", "action complete via WP Cron", "2024-11-04 00:12:38", "2024-11-04 01:12:38");
INSERT INTO `wp_actionscheduler_logs` VALUES("12620", "4210", "action created", "2024-11-04 00:12:38", "2024-11-04 01:12:38");
INSERT INTO `wp_actionscheduler_logs` VALUES("12621", "4209", "action started via WP Cron", "2024-11-04 00:14:39", "2024-11-04 01:14:39");
INSERT INTO `wp_actionscheduler_logs` VALUES("12622", "4209", "action complete via WP Cron", "2024-11-04 00:14:39", "2024-11-04 01:14:39");
INSERT INTO `wp_actionscheduler_logs` VALUES("12623", "4211", "action created", "2024-11-04 00:14:39", "2024-11-04 01:14:39");
INSERT INTO `wp_actionscheduler_logs` VALUES("12624", "4210", "action started via WP Cron", "2024-11-04 00:14:39", "2024-11-04 01:14:39");
INSERT INTO `wp_actionscheduler_logs` VALUES("12625", "4210", "action complete via WP Cron", "2024-11-04 00:14:39", "2024-11-04 01:14:39");
INSERT INTO `wp_actionscheduler_logs` VALUES("12626", "4212", "action created", "2024-11-04 00:14:39", "2024-11-04 01:14:39");
INSERT INTO `wp_actionscheduler_logs` VALUES("12627", "4211", "action started via WP Cron", "2024-11-04 01:03:10", "2024-11-04 02:03:10");
INSERT INTO `wp_actionscheduler_logs` VALUES("12628", "4211", "action complete via WP Cron", "2024-11-04 01:03:10", "2024-11-04 02:03:10");
INSERT INTO `wp_actionscheduler_logs` VALUES("12629", "4213", "action created", "2024-11-04 01:03:10", "2024-11-04 02:03:10");
INSERT INTO `wp_actionscheduler_logs` VALUES("12630", "4212", "action started via WP Cron", "2024-11-04 01:03:10", "2024-11-04 02:03:10");
INSERT INTO `wp_actionscheduler_logs` VALUES("12631", "4212", "action complete via WP Cron", "2024-11-04 01:03:10", "2024-11-04 02:03:10");
INSERT INTO `wp_actionscheduler_logs` VALUES("12632", "4214", "action created", "2024-11-04 01:03:10", "2024-11-04 02:03:10");
INSERT INTO `wp_actionscheduler_logs` VALUES("12633", "4160", "action started via WP Cron", "2024-11-04 01:03:10", "2024-11-04 02:03:10");
INSERT INTO `wp_actionscheduler_logs` VALUES("12634", "4160", "action complete via WP Cron", "2024-11-04 01:03:10", "2024-11-04 02:03:10");
INSERT INTO `wp_actionscheduler_logs` VALUES("12635", "4215", "action created", "2024-11-04 01:03:10", "2024-11-04 02:03:10");
INSERT INTO `wp_actionscheduler_logs` VALUES("12636", "4213", "action started via Async Request", "2024-11-04 01:04:16", "2024-11-04 02:04:16");
INSERT INTO `wp_actionscheduler_logs` VALUES("12637", "4213", "action complete via Async Request", "2024-11-04 01:04:16", "2024-11-04 02:04:16");
INSERT INTO `wp_actionscheduler_logs` VALUES("12638", "4216", "action created", "2024-11-04 01:04:16", "2024-11-04 02:04:16");
INSERT INTO `wp_actionscheduler_logs` VALUES("12639", "4214", "action started via Async Request", "2024-11-04 01:04:16", "2024-11-04 02:04:16");
INSERT INTO `wp_actionscheduler_logs` VALUES("12640", "4214", "action complete via Async Request", "2024-11-04 01:04:16", "2024-11-04 02:04:16");
INSERT INTO `wp_actionscheduler_logs` VALUES("12641", "4217", "action created", "2024-11-04 01:04:16", "2024-11-04 02:04:16");
INSERT INTO `wp_actionscheduler_logs` VALUES("12642", "4216", "action started via WP Cron", "2024-11-04 01:05:47", "2024-11-04 02:05:47");
INSERT INTO `wp_actionscheduler_logs` VALUES("12643", "4216", "action complete via WP Cron", "2024-11-04 01:05:47", "2024-11-04 02:05:47");
INSERT INTO `wp_actionscheduler_logs` VALUES("12644", "4218", "action created", "2024-11-04 01:05:47", "2024-11-04 02:05:47");
INSERT INTO `wp_actionscheduler_logs` VALUES("12645", "4217", "action started via WP Cron", "2024-11-04 01:05:47", "2024-11-04 02:05:47");
INSERT INTO `wp_actionscheduler_logs` VALUES("12646", "4217", "action complete via WP Cron", "2024-11-04 01:05:47", "2024-11-04 02:05:47");
INSERT INTO `wp_actionscheduler_logs` VALUES("12647", "4219", "action created", "2024-11-04 01:05:47", "2024-11-04 02:05:47");
INSERT INTO `wp_actionscheduler_logs` VALUES("12648", "4218", "action started via Async Request", "2024-11-04 01:07:01", "2024-11-04 02:07:01");
INSERT INTO `wp_actionscheduler_logs` VALUES("12649", "4218", "action complete via Async Request", "2024-11-04 01:07:01", "2024-11-04 02:07:01");
INSERT INTO `wp_actionscheduler_logs` VALUES("12650", "4220", "action created", "2024-11-04 01:07:01", "2024-11-04 02:07:01");
INSERT INTO `wp_actionscheduler_logs` VALUES("12651", "4219", "action started via Async Request", "2024-11-04 01:07:01", "2024-11-04 02:07:01");
INSERT INTO `wp_actionscheduler_logs` VALUES("12652", "4219", "action complete via Async Request", "2024-11-04 01:07:01", "2024-11-04 02:07:01");
INSERT INTO `wp_actionscheduler_logs` VALUES("12653", "4221", "action created", "2024-11-04 01:07:01", "2024-11-04 02:07:01");
INSERT INTO `wp_actionscheduler_logs` VALUES("12654", "4220", "action started via WP Cron", "2024-11-04 01:08:02", "2024-11-04 02:08:02");
INSERT INTO `wp_actionscheduler_logs` VALUES("12655", "4220", "action complete via WP Cron", "2024-11-04 01:08:02", "2024-11-04 02:08:02");
INSERT INTO `wp_actionscheduler_logs` VALUES("12656", "4222", "action created", "2024-11-04 01:08:02", "2024-11-04 02:08:02");
INSERT INTO `wp_actionscheduler_logs` VALUES("12657", "4221", "action started via WP Cron", "2024-11-04 01:08:02", "2024-11-04 02:08:02");
INSERT INTO `wp_actionscheduler_logs` VALUES("12658", "4221", "action complete via WP Cron", "2024-11-04 01:08:02", "2024-11-04 02:08:02");
INSERT INTO `wp_actionscheduler_logs` VALUES("12659", "4223", "action created", "2024-11-04 01:08:02", "2024-11-04 02:08:02");
INSERT INTO `wp_actionscheduler_logs` VALUES("12618", "4208", "action started via WP Cron", "2024-11-04 00:12:38", "2024-11-04 01:12:38");
INSERT INTO `wp_actionscheduler_logs` VALUES("12617", "4209", "action created", "2024-11-04 00:12:38", "2024-11-04 01:12:38");
INSERT INTO `wp_actionscheduler_logs` VALUES("12616", "4207", "action complete via WP Cron", "2024-11-04 00:12:38", "2024-11-04 01:12:38");
INSERT INTO `wp_actionscheduler_logs` VALUES("12615", "4207", "action started via WP Cron", "2024-11-04 00:12:38", "2024-11-04 01:12:38");
INSERT INTO `wp_actionscheduler_logs` VALUES("12614", "4208", "action created", "2024-11-04 00:10:37", "2024-11-04 01:10:37");
INSERT INTO `wp_actionscheduler_logs` VALUES("12613", "4206", "action complete via WP Cron", "2024-11-04 00:10:37", "2024-11-04 01:10:37");
INSERT INTO `wp_actionscheduler_logs` VALUES("12612", "4206", "action started via WP Cron", "2024-11-04 00:10:37", "2024-11-04 01:10:37");
INSERT INTO `wp_actionscheduler_logs` VALUES("12611", "4207", "action created", "2024-11-04 00:10:37", "2024-11-04 01:10:37");
INSERT INTO `wp_actionscheduler_logs` VALUES("12610", "4205", "action complete via WP Cron", "2024-11-04 00:10:37", "2024-11-04 01:10:37");
INSERT INTO `wp_actionscheduler_logs` VALUES("12609", "4205", "action started via WP Cron", "2024-11-04 00:10:37", "2024-11-04 01:10:37");
INSERT INTO `wp_actionscheduler_logs` VALUES("12608", "4206", "action created", "2024-11-04 00:08:36", "2024-11-04 01:08:36");
INSERT INTO `wp_actionscheduler_logs` VALUES("12607", "4204", "action complete via WP Cron", "2024-11-04 00:08:36", "2024-11-04 01:08:36");
INSERT INTO `wp_actionscheduler_logs` VALUES("12606", "4204", "action started via WP Cron", "2024-11-04 00:08:36", "2024-11-04 01:08:36");
INSERT INTO `wp_actionscheduler_logs` VALUES("12605", "4205", "action created", "2024-11-04 00:08:36", "2024-11-04 01:08:36");
INSERT INTO `wp_actionscheduler_logs` VALUES("12604", "4203", "action complete via WP Cron", "2024-11-04 00:08:36", "2024-11-04 01:08:36");
INSERT INTO `wp_actionscheduler_logs` VALUES("12603", "4203", "action started via WP Cron", "2024-11-04 00:08:36", "2024-11-04 01:08:36");
INSERT INTO `wp_actionscheduler_logs` VALUES("12602", "4204", "action created", "2024-11-04 00:06:35", "2024-11-04 01:06:35");
INSERT INTO `wp_actionscheduler_logs` VALUES("12601", "4202", "action complete via WP Cron", "2024-11-04 00:06:35", "2024-11-04 01:06:35");
INSERT INTO `wp_actionscheduler_logs` VALUES("12600", "4202", "action started via WP Cron", "2024-11-04 00:06:35", "2024-11-04 01:06:35");
INSERT INTO `wp_actionscheduler_logs` VALUES("12599", "4203", "action created", "2024-11-04 00:06:35", "2024-11-04 01:06:35");
INSERT INTO `wp_actionscheduler_logs` VALUES("12598", "4201", "action complete via WP Cron", "2024-11-04 00:06:35", "2024-11-04 01:06:35");
INSERT INTO `wp_actionscheduler_logs` VALUES("12597", "4201", "action started via WP Cron", "2024-11-04 00:06:35", "2024-11-04 01:06:35");
INSERT INTO `wp_actionscheduler_logs` VALUES("12596", "4202", "action created", "2024-11-04 00:04:34", "2024-11-04 01:04:34");
INSERT INTO `wp_actionscheduler_logs` VALUES("12595", "4200", "action complete via WP Cron", "2024-11-04 00:04:34", "2024-11-04 01:04:34");
INSERT INTO `wp_actionscheduler_logs` VALUES("12594", "4200", "action started via WP Cron", "2024-11-04 00:04:34", "2024-11-04 01:04:34");
INSERT INTO `wp_actionscheduler_logs` VALUES("12593", "4201", "action created", "2024-11-04 00:04:34", "2024-11-04 01:04:34");
INSERT INTO `wp_actionscheduler_logs` VALUES("12592", "4199", "action complete via WP Cron", "2024-11-04 00:04:34", "2024-11-04 01:04:34");
INSERT INTO `wp_actionscheduler_logs` VALUES("12591", "4199", "action started via WP Cron", "2024-11-04 00:04:34", "2024-11-04 01:04:34");
INSERT INTO `wp_actionscheduler_logs` VALUES("12590", "4200", "action created", "2024-11-04 00:02:33", "2024-11-04 01:02:33");
INSERT INTO `wp_actionscheduler_logs` VALUES("12589", "4198", "action complete via WP Cron", "2024-11-04 00:02:33", "2024-11-04 01:02:33");
INSERT INTO `wp_actionscheduler_logs` VALUES("12588", "4198", "action started via WP Cron", "2024-11-04 00:02:33", "2024-11-04 01:02:33");
INSERT INTO `wp_actionscheduler_logs` VALUES("12587", "4199", "action created", "2024-11-04 00:02:33", "2024-11-04 01:02:33");
INSERT INTO `wp_actionscheduler_logs` VALUES("12586", "4197", "action complete via WP Cron", "2024-11-04 00:02:33", "2024-11-04 01:02:33");
INSERT INTO `wp_actionscheduler_logs` VALUES("12585", "4197", "action started via WP Cron", "2024-11-04 00:02:33", "2024-11-04 01:02:33");
INSERT INTO `wp_actionscheduler_logs` VALUES("12584", "4198", "action created", "2024-11-04 00:00:32", "2024-11-04 01:00:32");
INSERT INTO `wp_actionscheduler_logs` VALUES("12583", "4196", "action complete via WP Cron", "2024-11-04 00:00:32", "2024-11-04 01:00:32");
INSERT INTO `wp_actionscheduler_logs` VALUES("12582", "4196", "action started via WP Cron", "2024-11-04 00:00:32", "2024-11-04 01:00:32");
INSERT INTO `wp_actionscheduler_logs` VALUES("12581", "4197", "action created", "2024-11-04 00:00:32", "2024-11-04 01:00:32");
INSERT INTO `wp_actionscheduler_logs` VALUES("12580", "4195", "action complete via WP Cron", "2024-11-04 00:00:32", "2024-11-04 01:00:32");
INSERT INTO `wp_actionscheduler_logs` VALUES("12579", "4195", "action started via WP Cron", "2024-11-04 00:00:32", "2024-11-04 01:00:32");
INSERT INTO `wp_actionscheduler_logs` VALUES("12578", "4196", "action created", "2024-11-03 23:58:31", "2024-11-04 00:58:31");
INSERT INTO `wp_actionscheduler_logs` VALUES("12577", "4194", "action complete via WP Cron", "2024-11-03 23:58:31", "2024-11-04 00:58:31");
INSERT INTO `wp_actionscheduler_logs` VALUES("12576", "4194", "action started via WP Cron", "2024-11-03 23:58:31", "2024-11-04 00:58:31");
INSERT INTO `wp_actionscheduler_logs` VALUES("12575", "4195", "action created", "2024-11-03 23:58:31", "2024-11-04 00:58:31");
INSERT INTO `wp_actionscheduler_logs` VALUES("12574", "4193", "action complete via WP Cron", "2024-11-03 23:58:31", "2024-11-04 00:58:31");
INSERT INTO `wp_actionscheduler_logs` VALUES("12573", "4193", "action started via WP Cron", "2024-11-03 23:58:31", "2024-11-04 00:58:31");
INSERT INTO `wp_actionscheduler_logs` VALUES("12572", "4194", "action created", "2024-11-03 23:56:30", "2024-11-04 00:56:30");
INSERT INTO `wp_actionscheduler_logs` VALUES("12571", "4192", "action complete via WP Cron", "2024-11-03 23:56:30", "2024-11-04 00:56:30");
INSERT INTO `wp_actionscheduler_logs` VALUES("12570", "4192", "action started via WP Cron", "2024-11-03 23:56:30", "2024-11-04 00:56:30");
INSERT INTO `wp_actionscheduler_logs` VALUES("12569", "4193", "action created", "2024-11-03 23:56:30", "2024-11-04 00:56:30");
INSERT INTO `wp_actionscheduler_logs` VALUES("12568", "4191", "action complete via WP Cron", "2024-11-03 23:56:30", "2024-11-04 00:56:30");
INSERT INTO `wp_actionscheduler_logs` VALUES("12464", "4158", "action created", "2024-11-03 23:24:23", "2024-11-04 00:24:23");
INSERT INTO `wp_actionscheduler_logs` VALUES("12567", "4191", "action started via WP Cron", "2024-11-03 23:56:30", "2024-11-04 00:56:30");
INSERT INTO `wp_actionscheduler_logs` VALUES("12566", "4192", "action created", "2024-11-03 23:54:29", "2024-11-04 00:54:29");
INSERT INTO `wp_actionscheduler_logs` VALUES("12467", "4159", "action created", "2024-11-03 23:24:23", "2024-11-04 00:24:23");
INSERT INTO `wp_actionscheduler_logs` VALUES("12565", "4190", "action complete via WP Cron", "2024-11-03 23:54:29", "2024-11-04 00:54:29");
INSERT INTO `wp_actionscheduler_logs` VALUES("12564", "4190", "action started via WP Cron", "2024-11-03 23:54:29", "2024-11-04 00:54:29");
INSERT INTO `wp_actionscheduler_logs` VALUES("12470", "4160", "action created", "2024-11-03 23:24:23", "2024-11-04 00:24:23");
INSERT INTO `wp_actionscheduler_logs` VALUES("12563", "4191", "action created", "2024-11-03 23:54:29", "2024-11-04 00:54:29");
INSERT INTO `wp_actionscheduler_logs` VALUES("12562", "4189", "action complete via WP Cron", "2024-11-03 23:54:29", "2024-11-04 00:54:29");
INSERT INTO `wp_actionscheduler_logs` VALUES("12473", "4113", "action started via WP Cron", "2024-11-03 23:24:23", "2024-11-04 00:24:23");
INSERT INTO `wp_actionscheduler_logs` VALUES("12561", "4189", "action started via WP Cron", "2024-11-03 23:54:29", "2024-11-04 00:54:29");
INSERT INTO `wp_actionscheduler_logs` VALUES("12560", "4190", "action created", "2024-11-03 23:52:28", "2024-11-04 00:52:28");
INSERT INTO `wp_actionscheduler_logs` VALUES("12559", "4188", "action complete via WP Cron", "2024-11-03 23:52:28", "2024-11-04 00:52:28");
INSERT INTO `wp_actionscheduler_logs` VALUES("12558", "4188", "action started via WP Cron", "2024-11-03 23:52:28", "2024-11-04 00:52:28");
INSERT INTO `wp_actionscheduler_logs` VALUES("12557", "4189", "action created", "2024-11-03 23:52:28", "2024-11-04 00:52:28");
INSERT INTO `wp_actionscheduler_logs` VALUES("12556", "4187", "action complete via WP Cron", "2024-11-03 23:52:28", "2024-11-04 00:52:28");
INSERT INTO `wp_actionscheduler_logs` VALUES("12555", "4187", "action started via WP Cron", "2024-11-03 23:52:28", "2024-11-04 00:52:28");
INSERT INTO `wp_actionscheduler_logs` VALUES("12554", "4188", "action created", "2024-11-03 23:50:27", "2024-11-04 00:50:27");
INSERT INTO `wp_actionscheduler_logs` VALUES("12553", "4186", "action complete via WP Cron", "2024-11-03 23:50:27", "2024-11-04 00:50:27");
INSERT INTO `wp_actionscheduler_logs` VALUES("12552", "4186", "action started via WP Cron", "2024-11-03 23:50:27", "2024-11-04 00:50:27");
INSERT INTO `wp_actionscheduler_logs` VALUES("12551", "4187", "action created", "2024-11-03 23:50:27", "2024-11-04 00:50:27");
INSERT INTO `wp_actionscheduler_logs` VALUES("12550", "4185", "action complete via WP Cron", "2024-11-03 23:50:27", "2024-11-04 00:50:27");
INSERT INTO `wp_actionscheduler_logs` VALUES("12549", "4185", "action started via WP Cron", "2024-11-03 23:50:27", "2024-11-04 00:50:27");
INSERT INTO `wp_actionscheduler_logs` VALUES("12548", "4186", "action created", "2024-11-03 23:48:26", "2024-11-04 00:48:26");
INSERT INTO `wp_actionscheduler_logs` VALUES("12547", "4184", "action complete via WP Cron", "2024-11-03 23:48:26", "2024-11-04 00:48:26");
INSERT INTO `wp_actionscheduler_logs` VALUES("12546", "4184", "action started via WP Cron", "2024-11-03 23:48:26", "2024-11-04 00:48:26");
INSERT INTO `wp_actionscheduler_logs` VALUES("12545", "4185", "action created", "2024-11-03 23:48:26", "2024-11-04 00:48:26");
INSERT INTO `wp_actionscheduler_logs` VALUES("12544", "4183", "action complete via WP Cron", "2024-11-03 23:48:26", "2024-11-04 00:48:26");
INSERT INTO `wp_actionscheduler_logs` VALUES("12543", "4183", "action started via WP Cron", "2024-11-03 23:48:26", "2024-11-04 00:48:26");
INSERT INTO `wp_actionscheduler_logs` VALUES("12542", "4184", "action created", "2024-11-03 23:46:26", "2024-11-04 00:46:26");
INSERT INTO `wp_actionscheduler_logs` VALUES("12541", "4182", "action complete via WP Cron", "2024-11-03 23:46:26", "2024-11-04 00:46:26");
INSERT INTO `wp_actionscheduler_logs` VALUES("12540", "4182", "action started via WP Cron", "2024-11-03 23:46:26", "2024-11-04 00:46:26");
INSERT INTO `wp_actionscheduler_logs` VALUES("12539", "4183", "action created", "2024-11-03 23:46:26", "2024-11-04 00:46:26");
INSERT INTO `wp_actionscheduler_logs` VALUES("12538", "4181", "action complete via WP Cron", "2024-11-03 23:46:26", "2024-11-04 00:46:26");
INSERT INTO `wp_actionscheduler_logs` VALUES("12537", "4181", "action started via WP Cron", "2024-11-03 23:46:26", "2024-11-04 00:46:26");
INSERT INTO `wp_actionscheduler_logs` VALUES("12536", "4182", "action created", "2024-11-03 23:44:24", "2024-11-04 00:44:24");
INSERT INTO `wp_actionscheduler_logs` VALUES("12535", "4180", "action complete via WP Cron", "2024-11-03 23:44:24", "2024-11-04 00:44:24");
INSERT INTO `wp_actionscheduler_logs` VALUES("12534", "4180", "action started via WP Cron", "2024-11-03 23:44:24", "2024-11-04 00:44:24");
INSERT INTO `wp_actionscheduler_logs` VALUES("12533", "4181", "action created", "2024-11-03 23:44:24", "2024-11-04 00:44:24");
INSERT INTO `wp_actionscheduler_logs` VALUES("12532", "4179", "action complete via WP Cron", "2024-11-03 23:44:24", "2024-11-04 00:44:24");
INSERT INTO `wp_actionscheduler_logs` VALUES("12531", "4179", "action started via WP Cron", "2024-11-03 23:44:24", "2024-11-04 00:44:24");
INSERT INTO `wp_actionscheduler_logs` VALUES("12530", "4180", "action created", "2024-11-03 23:42:23", "2024-11-04 00:42:23");
INSERT INTO `wp_actionscheduler_logs` VALUES("12529", "4178", "action complete via WP Cron", "2024-11-03 23:42:23", "2024-11-04 00:42:23");
INSERT INTO `wp_actionscheduler_logs` VALUES("12528", "4178", "action started via WP Cron", "2024-11-03 23:42:23", "2024-11-04 00:42:23");
INSERT INTO `wp_actionscheduler_logs` VALUES("12527", "4179", "action created", "2024-11-03 23:42:23", "2024-11-04 00:42:23");
INSERT INTO `wp_actionscheduler_logs` VALUES("12526", "4177", "action complete via WP Cron", "2024-11-03 23:42:22", "2024-11-04 00:42:22");
INSERT INTO `wp_actionscheduler_logs` VALUES("12523", "4176", "action complete via WP Cron", "2024-11-03 23:40:22", "2024-11-04 00:40:22");
INSERT INTO `wp_actionscheduler_logs` VALUES("12525", "4177", "action started via WP Cron", "2024-11-03 23:42:22", "2024-11-04 00:42:22");
INSERT INTO `wp_actionscheduler_logs` VALUES("12524", "4178", "action created", "2024-11-03 23:40:22", "2024-11-04 00:40:22");
INSERT INTO `wp_actionscheduler_logs` VALUES("12522", "4176", "action started via WP Cron", "2024-11-03 23:40:22", "2024-11-04 00:40:22");
INSERT INTO `wp_actionscheduler_logs` VALUES("12521", "4177", "action created", "2024-11-03 23:40:22", "2024-11-04 00:40:22");
INSERT INTO `wp_actionscheduler_logs` VALUES("12520", "4175", "action complete via WP Cron", "2024-11-03 23:40:21", "2024-11-04 00:40:21");
INSERT INTO `wp_actionscheduler_logs` VALUES("12519", "4175", "action started via WP Cron", "2024-11-03 23:40:21", "2024-11-04 00:40:21");
INSERT INTO `wp_actionscheduler_logs` VALUES("12518", "4176", "action created", "2024-11-03 23:38:21", "2024-11-04 00:38:21");
INSERT INTO `wp_actionscheduler_logs` VALUES("12517", "4174", "action complete via WP Cron", "2024-11-03 23:38:21", "2024-11-04 00:38:21");
INSERT INTO `wp_actionscheduler_logs` VALUES("12516", "4174", "action started via WP Cron", "2024-11-03 23:38:21", "2024-11-04 00:38:21");
INSERT INTO `wp_actionscheduler_logs` VALUES("12515", "4175", "action created", "2024-11-03 23:38:21", "2024-11-04 00:38:21");
INSERT INTO `wp_actionscheduler_logs` VALUES("12514", "4173", "action complete via WP Cron", "2024-11-03 23:38:21", "2024-11-04 00:38:21");
INSERT INTO `wp_actionscheduler_logs` VALUES("12513", "4173", "action started via WP Cron", "2024-11-03 23:38:21", "2024-11-04 00:38:21");
INSERT INTO `wp_actionscheduler_logs` VALUES("12512", "4174", "action created", "2024-11-03 23:36:19", "2024-11-04 00:36:19");
INSERT INTO `wp_actionscheduler_logs` VALUES("12511", "4172", "action complete via WP Cron", "2024-11-03 23:36:19", "2024-11-04 00:36:19");
INSERT INTO `wp_actionscheduler_logs` VALUES("12510", "4172", "action started via WP Cron", "2024-11-03 23:36:19", "2024-11-04 00:36:19");
INSERT INTO `wp_actionscheduler_logs` VALUES("12509", "4173", "action created", "2024-11-03 23:36:19", "2024-11-04 00:36:19");
INSERT INTO `wp_actionscheduler_logs` VALUES("12508", "4171", "action complete via WP Cron", "2024-11-03 23:36:19", "2024-11-04 00:36:19");
INSERT INTO `wp_actionscheduler_logs` VALUES("12507", "4171", "action started via WP Cron", "2024-11-03 23:36:19", "2024-11-04 00:36:19");
INSERT INTO `wp_actionscheduler_logs` VALUES("12506", "4172", "action created", "2024-11-03 23:34:19", "2024-11-04 00:34:19");
INSERT INTO `wp_actionscheduler_logs` VALUES("12505", "4170", "action complete via WP Cron", "2024-11-03 23:34:19", "2024-11-04 00:34:19");
INSERT INTO `wp_actionscheduler_logs` VALUES("12504", "4170", "action started via WP Cron", "2024-11-03 23:34:19", "2024-11-04 00:34:19");
INSERT INTO `wp_actionscheduler_logs` VALUES("12503", "4171", "action created", "2024-11-03 23:34:19", "2024-11-04 00:34:19");
INSERT INTO `wp_actionscheduler_logs` VALUES("12502", "4169", "action complete via WP Cron", "2024-11-03 23:34:19", "2024-11-04 00:34:19");
INSERT INTO `wp_actionscheduler_logs` VALUES("12501", "4169", "action started via WP Cron", "2024-11-03 23:34:19", "2024-11-04 00:34:19");
INSERT INTO `wp_actionscheduler_logs` VALUES("12500", "4170", "action created", "2024-11-03 23:32:19", "2024-11-04 00:32:19");
INSERT INTO `wp_actionscheduler_logs` VALUES("12499", "4168", "action complete via WP Cron", "2024-11-03 23:32:19", "2024-11-04 00:32:19");
INSERT INTO `wp_actionscheduler_logs` VALUES("12498", "4168", "action started via WP Cron", "2024-11-03 23:32:19", "2024-11-04 00:32:19");
INSERT INTO `wp_actionscheduler_logs` VALUES("12497", "4169", "action created", "2024-11-03 23:32:19", "2024-11-04 00:32:19");
INSERT INTO `wp_actionscheduler_logs` VALUES("12496", "4167", "action complete via WP Cron", "2024-11-03 23:32:19", "2024-11-04 00:32:19");
INSERT INTO `wp_actionscheduler_logs` VALUES("12495", "4167", "action started via WP Cron", "2024-11-03 23:32:19", "2024-11-04 00:32:19");
INSERT INTO `wp_actionscheduler_logs` VALUES("12494", "4168", "action created", "2024-11-03 23:30:23", "2024-11-04 00:30:23");
INSERT INTO `wp_actionscheduler_logs` VALUES("12493", "4166", "action complete via WP Cron", "2024-11-03 23:30:23", "2024-11-04 00:30:23");
INSERT INTO `wp_actionscheduler_logs` VALUES("12492", "4166", "action started via WP Cron", "2024-11-03 23:30:23", "2024-11-04 00:30:23");
INSERT INTO `wp_actionscheduler_logs` VALUES("12491", "4167", "action created", "2024-11-03 23:30:23", "2024-11-04 00:30:23");
INSERT INTO `wp_actionscheduler_logs` VALUES("12490", "4165", "action complete via WP Cron", "2024-11-03 23:30:23", "2024-11-04 00:30:23");
INSERT INTO `wp_actionscheduler_logs` VALUES("12489", "4165", "action started via WP Cron", "2024-11-03 23:30:23", "2024-11-04 00:30:23");
INSERT INTO `wp_actionscheduler_logs` VALUES("12488", "4166", "action created", "2024-11-03 23:28:22", "2024-11-04 00:28:22");
INSERT INTO `wp_actionscheduler_logs` VALUES("12487", "4164", "action complete via WP Cron", "2024-11-03 23:28:22", "2024-11-04 00:28:22");
INSERT INTO `wp_actionscheduler_logs` VALUES("12486", "4164", "action started via WP Cron", "2024-11-03 23:28:22", "2024-11-04 00:28:22");
INSERT INTO `wp_actionscheduler_logs` VALUES("12485", "4165", "action created", "2024-11-03 23:28:22", "2024-11-04 00:28:22");
INSERT INTO `wp_actionscheduler_logs` VALUES("12484", "4163", "action complete via WP Cron", "2024-11-03 23:28:22", "2024-11-04 00:28:22");
INSERT INTO `wp_actionscheduler_logs` VALUES("12481", "4159", "action complete via WP Cron", "2024-11-03 23:26:22", "2024-11-04 00:26:22");
INSERT INTO `wp_actionscheduler_logs` VALUES("12482", "4164", "action created", "2024-11-03 23:26:22", "2024-11-04 00:26:22");
INSERT INTO `wp_actionscheduler_logs` VALUES("12483", "4163", "action started via WP Cron", "2024-11-03 23:28:22", "2024-11-04 00:28:22");
INSERT INTO `wp_actionscheduler_logs` VALUES("12480", "4159", "action started via WP Cron", "2024-11-03 23:26:22", "2024-11-04 00:26:22");
INSERT INTO `wp_actionscheduler_logs` VALUES("12476", "4162", "action created", "2024-11-03 23:26:22", "2024-11-04 00:26:22");
INSERT INTO `wp_actionscheduler_logs` VALUES("12477", "4158", "action started via WP Cron", "2024-11-03 23:26:22", "2024-11-04 00:26:22");
INSERT INTO `wp_actionscheduler_logs` VALUES("12478", "4158", "action complete via WP Cron", "2024-11-03 23:26:22", "2024-11-04 00:26:22");
INSERT INTO `wp_actionscheduler_logs` VALUES("12479", "4163", "action created", "2024-11-03 23:26:22", "2024-11-04 00:26:22");
INSERT INTO `wp_actionscheduler_logs` VALUES("12475", "4161", "action created", "2024-11-03 23:24:23", "2024-11-04 00:24:23");
INSERT INTO `wp_actionscheduler_logs` VALUES("12329", "4113", "action created", "2024-11-03 16:06:57", "2024-11-03 17:06:57");
INSERT INTO `wp_actionscheduler_logs` VALUES("12474", "4113", "action complete via WP Cron", "2024-11-03 23:24:23", "2024-11-04 00:24:23");

/* INSERT TABLE DATA: wp_comments */
INSERT INTO `wp_comments` VALUES("1", "1", "Un commentateur WordPress", "wapuu@wordpress.example", "https://wordpress.org/", "", "2023-06-22 23:33:15", "2023-06-22 21:33:15", "Bonjour, ceci est un commentaire.\nPour débuter avec la modération, la modification et la suppression de commentaires, veuillez visiter l’écran des Commentaires dans le Tableau de bord.\nLes avatars des personnes qui commentent arrivent depuis <a href=\"https://gravatar.com\">Gravatar</a>.", "0", "1", "", "comment", "0", "0");

/* INSERT TABLE DATA: wp_duplicator_packages */
INSERT INTO `wp_duplicator_packages` VALUES("1", "KARIBEA", "70adcb0909cc471c5365_20241104010722", "22", "2024-11-04 01:08:02", "devoksy", "O:11:\"DUP_Package\":23:{s:7:\"Created\";s:19:\"2024-11-04 01:07:22\";s:7:\"Version\";s:8:\"1.5.11.1\";s:9:\"VersionWP\";s:5:\"6.6.2\";s:9:\"VersionDB\";s:6:\"8.0.27\";s:10:\"VersionPHP\";s:6:\"7.4.26\";s:9:\"VersionOS\";s:5:\"WINNT\";s:2:\"ID\";i:1;s:4:\"Name\";s:7:\"KARIBEA\";s:4:\"Hash\";s:35:\"70adcb0909cc471c5365_20241104010722\";s:8:\"NameHash\";s:43:\"KARIBEA_70adcb0909cc471c5365_20241104010722\";s:4:\"Type\";i:0;s:5:\"Notes\";s:0:\"\";s:8:\"ScanFile\";s:53:\"KARIBEA_70adcb0909cc471c5365_20241104010722_scan.json\";s:10:\"TimerStart\";i:-1;s:7:\"Runtime\";N;s:7:\"ExeSize\";N;s:7:\"ZipSize\";N;s:6:\"Status\";s:4:\"22.4\";s:6:\"WPUser\";s:7:\"devoksy\";s:7:\"Archive\";O:11:\"DUP_Archive\":26:{s:10:\"FilterDirs\";s:0:\"\";s:11:\"FilterFiles\";s:0:\"\";s:10:\"FilterExts\";s:0:\"\";s:13:\"FilterDirsAll\";a:0:{}s:14:\"FilterFilesAll\";a:0:{}s:13:\"FilterExtsAll\";a:0:{}s:8:\"FilterOn\";i:0;s:12:\"ExportOnlyDB\";i:0;s:4:\"File\";s:55:\"KARIBEA_70adcb0909cc471c5365_20241104010722_archive.zip\";s:6:\"Format\";s:3:\"ZIP\";s:7:\"PackDir\";s:23:\"C:/wamp64/www/wordpress\";s:4:\"Size\";i:0;s:4:\"Dirs\";a:0:{}s:9:\"dirsCount\";i:1504;s:5:\"Files\";a:0:{}s:10:\"filesCount\";i:9263;s:10:\"FilterInfo\";O:23:\"DUP_Archive_Filter_Info\":8:{s:4:\"Dirs\";O:34:\"DUP_Archive_Filter_Scope_Directory\":6:{s:7:\"Warning\";a:0:{}s:10:\"Unreadable\";a:0:{}s:10:\"AddonSites\";a:0:{}s:4:\"Core\";a:0:{}s:6:\"Global\";a:0:{}s:8:\"Instance\";a:0:{}}s:5:\"Files\";O:29:\"DUP_Archive_Filter_Scope_File\":7:{s:4:\"Size\";a:0:{}s:7:\"Warning\";a:0:{}s:10:\"Unreadable\";a:0:{}s:10:\"AddonSites\";a:0:{}s:4:\"Core\";a:0:{}s:6:\"Global\";a:0:{}s:8:\"Instance\";a:0:{}}s:4:\"Exts\";O:29:\"DUP_Archive_Filter_Scope_Base\":3:{s:4:\"Core\";a:0:{}s:6:\"Global\";a:0:{}s:8:\"Instance\";a:0:{}}s:9:\"UDirCount\";i:0;s:10:\"UFileCount\";i:0;s:9:\"UExtCount\";i:0;s:8:\"TreeSize\";a:0:{}s:11:\"TreeWarning\";a:0:{}}s:14:\"RecursiveLinks\";a:0:{}s:10:\"file_count\";i:-1;s:10:\"\0*\0Package\";O:11:\"DUP_Package\":23:{s:7:\"Created\";s:19:\"2024-11-04 01:07:22\";s:7:\"Version\";s:8:\"1.5.11.1\";s:9:\"VersionWP\";s:5:\"6.6.2\";s:9:\"VersionDB\";s:6:\"8.0.27\";s:10:\"VersionPHP\";s:6:\"7.4.26\";s:9:\"VersionOS\";s:5:\"WINNT\";s:2:\"ID\";N;s:4:\"Name\";s:7:\"KARIBEA\";s:4:\"Hash\";s:35:\"70adcb0909cc471c5365_20241104010722\";s:8:\"NameHash\";s:43:\"KARIBEA_70adcb0909cc471c5365_20241104010722\";s:4:\"Type\";i:0;s:5:\"Notes\";s:0:\"\";s:8:\"ScanFile\";N;s:10:\"TimerStart\";i:-1;s:7:\"Runtime\";N;s:7:\"ExeSize\";N;s:7:\"ZipSize\";N;s:6:\"Status\";i:0;s:6:\"WPUser\";N;s:7:\"Archive\";r:21;s:9:\"Installer\";O:13:\"DUP_Installer\":15:{s:4:\"File\";s:61:\"KARIBEA_70adcb0909cc471c5365_20241104010722_installer.php.bak\";s:4:\"Size\";i:0;s:10:\"OptsDBHost\";s:0:\"\";s:10:\"OptsDBPort\";s:0:\"\";s:10:\"OptsDBName\";s:0:\"\";s:10:\"OptsDBUser\";s:0:\"\";s:13:\"OptsDBCharset\";s:0:\"\";s:15:\"OptsDBCollation\";s:0:\"\";s:12:\"OptsSecureOn\";i:0;s:14:\"OptsSecurePass\";s:0:\"\";s:13:\"numFilesAdded\";i:0;s:12:\"numDirsAdded\";i:0;s:10:\"\0*\0Package\";r:65;s:17:\"\0*\0origFileManger\";N;s:32:\"\0DUP_Installer\0configTransformer\";O:44:\"Duplicator\\Libs\\WpConfig\\WPConfigTransformer\":3:{s:17:\"\0*\0wp_config_path\";s:37:\"C:/wamp64/www/wordpress/wp-config.php\";s:16:\"\0*\0wp_config_src\";N;s:13:\"\0*\0wp_configs\";a:0:{}}}s:8:\"Database\";O:12:\"DUP_Database\":15:{s:4:\"Type\";s:5:\"MySQL\";s:4:\"Size\";N;s:4:\"File\";s:56:\"KARIBEA_70adcb0909cc471c5365_20241104010722_database.sql\";s:4:\"Path\";N;s:12:\"FilterTables\";s:0:\"\";s:8:\"FilterOn\";i:0;s:4:\"Name\";N;s:10:\"Compatible\";s:0:\"\";s:8:\"Comments\";s:28:\"MySQL Community Server - GPL\";s:19:\"sameNameTableExists\";b:0;s:4:\"info\";O:16:\"DUP_DatabaseInfo\":23:{s:9:\"buildMode\";s:3:\"PHP\";s:11:\"charSetList\";a:0:{}s:13:\"collationList\";a:0:{}s:10:\"engineList\";a:0:{}s:17:\"isTablesUpperCase\";b:0;s:15:\"isNameUpperCase\";b:0;s:4:\"name\";s:0:\"\";s:15:\"tablesBaseCount\";i:0;s:16:\"tablesFinalCount\";i:0;s:20:\"muFilteredTableCount\";i:0;s:14:\"tablesRowCount\";i:0;s:16:\"tablesSizeOnDisk\";i:0;s:10:\"tablesList\";a:0:{}s:19:\"lowerCaseTableNames\";i:0;s:8:\"dbEngine\";s:0:\"\";s:7:\"version\";i:0;s:14:\"versionComment\";i:0;s:9:\"viewCount\";i:0;s:9:\"procCount\";i:0;s:9:\"funcCount\";i:0;s:11:\"triggerList\";a:0:{}s:33:\"\0DUP_DatabaseInfo\0intFieldsStruct\";a:0:{}s:42:\"\0DUP_DatabaseInfo\0indexProcessedSchemaSize\";a:0:{}}s:10:\"\0*\0Package\";r:1;s:24:\"\0DUP_Database\0tempDbPath\";s:112:\"C:/wamp64/www/wordpress/wp-content/backups-dup-lite/tmp/KARIBEA_70adcb0909cc471c5365_20241104010722_database.sql\";s:23:\"\0DUP_Database\0EOFMarker\";s:0:\"\";s:26:\"\0DUP_Database\0networkFlush\";b:0;}s:13:\"BuildProgress\";O:18:\"DUP_Build_Progress\":12:{s:17:\"thread_start_time\";N;s:11:\"initialized\";b:0;s:15:\"installer_built\";b:0;s:15:\"archive_started\";b:0;s:20:\"archive_has_database\";b:0;s:13:\"archive_built\";b:0;s:21:\"database_script_built\";b:0;s:6:\"failed\";b:0;s:7:\"retries\";i:0;s:14:\"build_failures\";a:0:{}s:19:\"validation_failures\";a:0:{}s:27:\"\0DUP_Build_Progress\0package\";r:65;}}s:29:\"\0DUP_Archive\0tmpFilterDirsAll\";a:0:{}s:24:\"\0DUP_Archive\0wpCorePaths\";a:3:{i:0;s:32:\"C:/wamp64/www/wordpress/wp-admin\";i:1;s:35:\"C:/wamp64/www/wordpress/wp-includes\";i:2;s:44:\"C:/wamp64/www/wordpress/wp-content/languages\";}s:29:\"\0DUP_Archive\0wpCoreExactPaths\";a:7:{i:0;s:23:\"C:/wamp64/www/wordpress\";i:1;s:23:\"C:/wamp64/www/wordpress\";i:2;s:34:\"C:/wamp64/www/wordpress/wp-content\";i:3;s:42:\"C:/wamp64/www/wordpress/wp-content/uploads\";i:4;s:42:\"C:/wamp64/www/wordpress/wp-content/plugins\";i:5;s:45:\"C:/wamp64/www/wordpress/wp-content/mu-plugins\";i:6;s:41:\"C:/wamp64/www/wordpress/wp-content/themes\";}s:31:\"\0DUP_Archive\0relativeFiltersDir\";a:2:{i:0;s:55:\"C:/wamp64/www/wordpress/wp-content/backups-dup-lite/tmp\";i:1;s:15:\"backups-dup-pro\";}s:24:\"\0DUP_Archive\0listFileObj\";N;s:23:\"\0DUP_Archive\0listDirObj\";N;}s:9:\"Installer\";r:86;s:8:\"Database\";r:105;s:13:\"BuildProgress\";r:144;}");

/* INSERT TABLE DATA: wp_frmt_form_reports */
INSERT INTO `wp_frmt_form_reports` VALUES("1", "a:5:{s:7:\"exclude\";a:1:{i:0;i:1;}s:8:\"settings\";a:3:{s:5:\"label\";s:12:\"Form reports\";s:6:\"module\";s:5:\"forms\";s:10:\"forms_type\";s:3:\"all\";}s:8:\"schedule\";a:3:{s:9:\"frequency\";s:7:\"monthly\";s:8:\"monthDay\";s:1:\"4\";s:9:\"monthTime\";s:8:\"04:00 AM\";}s:13:\"report_status\";s:8:\"inactive\";s:10:\"recipients\";a:1:{i:0;a:5:{s:2:\"id\";i:1;s:4:\"name\";s:7:\"devoksy\";s:5:\"email\";s:19:\"devoksy@outlook.com\";s:4:\"role\";s:13:\"Administrator\";s:6:\"avatar\";s:75:\"http://1.gravatar.com/avatar/a0766185acf3f4e17b14df97e258894d?s=96&d=mm&r=g\";}}}", "inactive", "2024-09-21 18:04:38", "2024-09-21 18:04:38");

/* INSERT TABLE DATA: wp_options */
INSERT INTO `wp_options` VALUES("1", "siteurl", "http://localhost/wordpress", "yes");
INSERT INTO `wp_options` VALUES("2", "home", "http://localhost/wordpress", "yes");
INSERT INTO `wp_options` VALUES("3", "blogname", "DevOksy", "yes");
INSERT INTO `wp_options` VALUES("4", "blogdescription", "Un accompagnement digital de qualité", "yes");
INSERT INTO `wp_options` VALUES("5", "users_can_register", "0", "yes");
INSERT INTO `wp_options` VALUES("6", "admin_email", "devoksy@outlook.com", "yes");
INSERT INTO `wp_options` VALUES("7", "start_of_week", "1", "yes");
INSERT INTO `wp_options` VALUES("8", "use_balanceTags", "0", "yes");
INSERT INTO `wp_options` VALUES("9", "use_smilies", "1", "yes");
INSERT INTO `wp_options` VALUES("10", "require_name_email", "1", "yes");
INSERT INTO `wp_options` VALUES("11", "comments_notify", "1", "yes");
INSERT INTO `wp_options` VALUES("12", "posts_per_rss", "10", "yes");
INSERT INTO `wp_options` VALUES("13", "rss_use_excerpt", "0", "yes");
INSERT INTO `wp_options` VALUES("14", "mailserver_url", "mail.example.com", "yes");
INSERT INTO `wp_options` VALUES("15", "mailserver_login", "login@example.com", "yes");
INSERT INTO `wp_options` VALUES("16", "mailserver_pass", "password", "yes");
INSERT INTO `wp_options` VALUES("17", "mailserver_port", "110", "yes");
INSERT INTO `wp_options` VALUES("18", "default_category", "1", "yes");
INSERT INTO `wp_options` VALUES("19", "default_comment_status", "open", "yes");
INSERT INTO `wp_options` VALUES("20", "default_ping_status", "open", "yes");
INSERT INTO `wp_options` VALUES("21", "default_pingback_flag", "1", "yes");
INSERT INTO `wp_options` VALUES("22", "posts_per_page", "10", "yes");
INSERT INTO `wp_options` VALUES("23", "date_format", "j F Y", "yes");
INSERT INTO `wp_options` VALUES("24", "time_format", "G\\hi", "yes");
INSERT INTO `wp_options` VALUES("25", "links_updated_date_format", "d F Y G\\hi", "yes");
INSERT INTO `wp_options` VALUES("26", "comment_moderation", "0", "yes");
INSERT INTO `wp_options` VALUES("27", "moderation_notify", "1", "yes");
INSERT INTO `wp_options` VALUES("28", "permalink_structure", "/%year%/%monthnum%/%day%/%postname%/", "yes");
INSERT INTO `wp_options` VALUES("29", "rewrite_rules", "a:101:{s:11:\"^wp-json/?$\";s:22:\"index.php?rest_route=/\";s:14:\"^wp-json/(.*)?\";s:33:\"index.php?rest_route=/$matches[1]\";s:21:\"^index.php/wp-json/?$\";s:22:\"index.php?rest_route=/\";s:24:\"^index.php/wp-json/(.*)?\";s:33:\"index.php?rest_route=/$matches[1]\";s:17:\"^wp-sitemap\\.xml$\";s:23:\"index.php?sitemap=index\";s:17:\"^wp-sitemap\\.xsl$\";s:36:\"index.php?sitemap-stylesheet=sitemap\";s:23:\"^wp-sitemap-index\\.xsl$\";s:34:\"index.php?sitemap-stylesheet=index\";s:48:\"^wp-sitemap-([a-z]+?)-([a-z\\d_-]+?)-(\\d+?)\\.xml$\";s:75:\"index.php?sitemap=$matches[1]&sitemap-subtype=$matches[2]&paged=$matches[3]\";s:34:\"^wp-sitemap-([a-z]+?)-(\\d+?)\\.xml$\";s:47:\"index.php?sitemap=$matches[1]&paged=$matches[2]\";s:18:\"^entries/([^/]+)/?\";s:29:\"index.php?entries=$matches[1]\";s:42:\"archives/(\\d+)(?:/(\\d+))?/entries/(\\d+)/?$\";s:60:\"index.php?p=$matches[1]&page=$matches[2]&entries=$matches[3]\";s:38:\"(.?.+?)(?:/([0-9]+))?/entries/(\\d+)/?$\";s:67:\"index.php?pagename=$matches[1]&page=$matches[2]&entries=$matches[3]\";s:62:\"([0-9]{4})/([0-9]{1,2})/([^/]+)(?:/([0-9]+))?/entries/(\\d+)/?$\";s:101:\"index.php?year=$matches[1]&monthnum=$matches[2]&name=$matches[3]&page=$matches[4]&entries=$matches[5]\";s:75:\"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/([^/]+)(?:/([0-9]+))?/entries/(\\d+)/?$\";s:117:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&name=$matches[4]&page=$matches[5]&entries=$matches[6]\";s:26:\"(.?.+?)/entries(/(.*))?/?$\";s:50:\"index.php?pagename=$matches[1]&entries=$matches[3]\";s:47:\"category/(.+?)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:52:\"index.php?category_name=$matches[1]&feed=$matches[2]\";s:42:\"category/(.+?)/(feed|rdf|rss|rss2|atom)/?$\";s:52:\"index.php?category_name=$matches[1]&feed=$matches[2]\";s:23:\"category/(.+?)/embed/?$\";s:46:\"index.php?category_name=$matches[1]&embed=true\";s:35:\"category/(.+?)/page/?([0-9]{1,})/?$\";s:53:\"index.php?category_name=$matches[1]&paged=$matches[2]\";s:17:\"category/(.+?)/?$\";s:35:\"index.php?category_name=$matches[1]\";s:44:\"tag/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:42:\"index.php?tag=$matches[1]&feed=$matches[2]\";s:39:\"tag/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:42:\"index.php?tag=$matches[1]&feed=$matches[2]\";s:20:\"tag/([^/]+)/embed/?$\";s:36:\"index.php?tag=$matches[1]&embed=true\";s:32:\"tag/([^/]+)/page/?([0-9]{1,})/?$\";s:43:\"index.php?tag=$matches[1]&paged=$matches[2]\";s:14:\"tag/([^/]+)/?$\";s:25:\"index.php?tag=$matches[1]\";s:45:\"type/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:50:\"index.php?post_format=$matches[1]&feed=$matches[2]\";s:40:\"type/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:50:\"index.php?post_format=$matches[1]&feed=$matches[2]\";s:21:\"type/([^/]+)/embed/?$\";s:44:\"index.php?post_format=$matches[1]&embed=true\";s:33:\"type/([^/]+)/page/?([0-9]{1,})/?$\";s:51:\"index.php?post_format=$matches[1]&paged=$matches[2]\";s:15:\"type/([^/]+)/?$\";s:33:\"index.php?post_format=$matches[1]\";s:48:\".*wp-(atom|rdf|rss|rss2|feed|commentsrss2)\\.php$\";s:18:\"index.php?feed=old\";s:20:\".*wp-app\\.php(/.*)?$\";s:19:\"index.php?error=403\";s:18:\".*wp-register.php$\";s:23:\"index.php?register=true\";s:32:\"feed/(feed|rdf|rss|rss2|atom)/?$\";s:27:\"index.php?&feed=$matches[1]\";s:27:\"(feed|rdf|rss|rss2|atom)/?$\";s:27:\"index.php?&feed=$matches[1]\";s:8:\"embed/?$\";s:21:\"index.php?&embed=true\";s:20:\"page/?([0-9]{1,})/?$\";s:28:\"index.php?&paged=$matches[1]\";s:27:\"comment-page-([0-9]{1,})/?$\";s:39:\"index.php?&page_id=16&cpage=$matches[1]\";s:41:\"comments/feed/(feed|rdf|rss|rss2|atom)/?$\";s:42:\"index.php?&feed=$matches[1]&withcomments=1\";s:36:\"comments/(feed|rdf|rss|rss2|atom)/?$\";s:42:\"index.php?&feed=$matches[1]&withcomments=1\";s:17:\"comments/embed/?$\";s:21:\"index.php?&embed=true\";s:44:\"search/(.+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:40:\"index.php?s=$matches[1]&feed=$matches[2]\";s:39:\"search/(.+)/(feed|rdf|rss|rss2|atom)/?$\";s:40:\"index.php?s=$matches[1]&feed=$matches[2]\";s:20:\"search/(.+)/embed/?$\";s:34:\"index.php?s=$matches[1]&embed=true\";s:32:\"search/(.+)/page/?([0-9]{1,})/?$\";s:41:\"index.php?s=$matches[1]&paged=$matches[2]\";s:14:\"search/(.+)/?$\";s:23:\"index.php?s=$matches[1]\";s:47:\"author/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:50:\"index.php?author_name=$matches[1]&feed=$matches[2]\";s:42:\"author/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:50:\"index.php?author_name=$matches[1]&feed=$matches[2]\";s:23:\"author/([^/]+)/embed/?$\";s:44:\"index.php?author_name=$matches[1]&embed=true\";s:35:\"author/([^/]+)/page/?([0-9]{1,})/?$\";s:51:\"index.php?author_name=$matches[1]&paged=$matches[2]\";s:17:\"author/([^/]+)/?$\";s:33:\"index.php?author_name=$matches[1]\";s:69:\"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/feed/(feed|rdf|rss|rss2|atom)/?$\";s:80:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&feed=$matches[4]\";s:64:\"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/(feed|rdf|rss|rss2|atom)/?$\";s:80:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&feed=$matches[4]\";s:45:\"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/embed/?$\";s:74:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&embed=true\";s:57:\"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/page/?([0-9]{1,})/?$\";s:81:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&paged=$matches[4]\";s:39:\"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/?$\";s:63:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]\";s:56:\"([0-9]{4})/([0-9]{1,2})/feed/(feed|rdf|rss|rss2|atom)/?$\";s:64:\"index.php?year=$matches[1]&monthnum=$matches[2]&feed=$matches[3]\";s:51:\"([0-9]{4})/([0-9]{1,2})/(feed|rdf|rss|rss2|atom)/?$\";s:64:\"index.php?year=$matches[1]&monthnum=$matches[2]&feed=$matches[3]\";s:32:\"([0-9]{4})/([0-9]{1,2})/embed/?$\";s:58:\"index.php?year=$matches[1]&monthnum=$matches[2]&embed=true\";s:44:\"([0-9]{4})/([0-9]{1,2})/page/?([0-9]{1,})/?$\";s:65:\"index.php?year=$matches[1]&monthnum=$matches[2]&paged=$matches[3]\";s:26:\"([0-9]{4})/([0-9]{1,2})/?$\";s:47:\"index.php?year=$matches[1]&monthnum=$matches[2]\";s:43:\"([0-9]{4})/feed/(feed|rdf|rss|rss2|atom)/?$\";s:43:\"index.php?year=$matches[1]&feed=$matches[2]\";s:38:\"([0-9]{4})/(feed|rdf|rss|rss2|atom)/?$\";s:43:\"index.php?year=$matches[1]&feed=$matches[2]\";s:19:\"([0-9]{4})/embed/?$\";s:37:\"index.php?year=$matches[1]&embed=true\";s:31:\"([0-9]{4})/page/?([0-9]{1,})/?$\";s:44:\"index.php?year=$matches[1]&paged=$matches[2]\";s:13:\"([0-9]{4})/?$\";s:26:\"index.php?year=$matches[1]\";s:58:\"[0-9]{4}/[0-9]{1,2}/[0-9]{1,2}/[^/]+/attachment/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:68:\"[0-9]{4}/[0-9]{1,2}/[0-9]{1,2}/[^/]+/attachment/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:88:\"[0-9]{4}/[0-9]{1,2}/[0-9]{1,2}/[^/]+/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:83:\"[0-9]{4}/[0-9]{1,2}/[0-9]{1,2}/[^/]+/attachment/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:83:\"[0-9]{4}/[0-9]{1,2}/[0-9]{1,2}/[^/]+/attachment/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:64:\"[0-9]{4}/[0-9]{1,2}/[0-9]{1,2}/[^/]+/attachment/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:53:\"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/([^/]+)/embed/?$\";s:91:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&name=$matches[4]&embed=true\";s:57:\"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/([^/]+)/trackback/?$\";s:85:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&name=$matches[4]&tb=1\";s:77:\"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:97:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&name=$matches[4]&feed=$matches[5]\";s:72:\"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:97:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&name=$matches[4]&feed=$matches[5]\";s:65:\"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/([^/]+)/page/?([0-9]{1,})/?$\";s:98:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&name=$matches[4]&paged=$matches[5]\";s:72:\"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/([^/]+)/comment-page-([0-9]{1,})/?$\";s:98:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&name=$matches[4]&cpage=$matches[5]\";s:61:\"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/([^/]+)(?:/([0-9]+))?/?$\";s:97:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&name=$matches[4]&page=$matches[5]\";s:47:\"[0-9]{4}/[0-9]{1,2}/[0-9]{1,2}/[^/]+/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:57:\"[0-9]{4}/[0-9]{1,2}/[0-9]{1,2}/[^/]+/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:77:\"[0-9]{4}/[0-9]{1,2}/[0-9]{1,2}/[^/]+/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:72:\"[0-9]{4}/[0-9]{1,2}/[0-9]{1,2}/[^/]+/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:72:\"[0-9]{4}/[0-9]{1,2}/[0-9]{1,2}/[^/]+/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:53:\"[0-9]{4}/[0-9]{1,2}/[0-9]{1,2}/[^/]+/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:64:\"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/comment-page-([0-9]{1,})/?$\";s:81:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&cpage=$matches[4]\";s:51:\"([0-9]{4})/([0-9]{1,2})/comment-page-([0-9]{1,})/?$\";s:65:\"index.php?year=$matches[1]&monthnum=$matches[2]&cpage=$matches[3]\";s:38:\"([0-9]{4})/comment-page-([0-9]{1,})/?$\";s:44:\"index.php?year=$matches[1]&cpage=$matches[2]\";s:27:\".?.+?/attachment/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:37:\".?.+?/attachment/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:57:\".?.+?/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:52:\".?.+?/attachment/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:52:\".?.+?/attachment/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:33:\".?.+?/attachment/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:16:\"(.?.+?)/embed/?$\";s:41:\"index.php?pagename=$matches[1]&embed=true\";s:20:\"(.?.+?)/trackback/?$\";s:35:\"index.php?pagename=$matches[1]&tb=1\";s:40:\"(.?.+?)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:47:\"index.php?pagename=$matches[1]&feed=$matches[2]\";s:35:\"(.?.+?)/(feed|rdf|rss|rss2|atom)/?$\";s:47:\"index.php?pagename=$matches[1]&feed=$matches[2]\";s:28:\"(.?.+?)/page/?([0-9]{1,})/?$\";s:48:\"index.php?pagename=$matches[1]&paged=$matches[2]\";s:35:\"(.?.+?)/comment-page-([0-9]{1,})/?$\";s:48:\"index.php?pagename=$matches[1]&cpage=$matches[2]\";s:24:\"(.?.+?)(?:/([0-9]+))?/?$\";s:47:\"index.php?pagename=$matches[1]&page=$matches[2]\";}", "yes");
INSERT INTO `wp_options` VALUES("30", "hack_file", "0", "yes");
INSERT INTO `wp_options` VALUES("31", "blog_charset", "UTF-8", "yes");
INSERT INTO `wp_options` VALUES("32", "moderation_keys", "", "no");
INSERT INTO `wp_options` VALUES("33", "active_plugins", "a:5:{i:0;s:45:\"colibri-page-builder/colibri-page-builder.php\";i:1;s:25:\"duplicator/duplicator.php\";i:2;s:25:\"forminator/forminator.php\";i:3;s:39:\"olivewp-companion/olivewp-companion.php\";i:4;s:42:\"simple-membership/simple-wp-membership.php\";}", "yes");
INSERT INTO `wp_options` VALUES("34", "category_base", "", "yes");
INSERT INTO `wp_options` VALUES("35", "ping_sites", "http://rpc.pingomatic.com/", "yes");
INSERT INTO `wp_options` VALUES("36", "comment_max_links", "2", "yes");
INSERT INTO `wp_options` VALUES("37", "gmt_offset", "0", "yes");
INSERT INTO `wp_options` VALUES("38", "default_email_category", "1", "yes");
INSERT INTO `wp_options` VALUES("39", "recently_edited", "", "no");
INSERT INTO `wp_options` VALUES("40", "template", "brite", "yes");
INSERT INTO `wp_options` VALUES("41", "stylesheet", "brite", "yes");
INSERT INTO `wp_options` VALUES("42", "comment_registration", "0", "yes");
INSERT INTO `wp_options` VALUES("43", "html_type", "text/html", "yes");
INSERT INTO `wp_options` VALUES("44", "use_trackback", "0", "yes");
INSERT INTO `wp_options` VALUES("45", "default_role", "subscriber", "yes");
INSERT INTO `wp_options` VALUES("46", "db_version", "57155", "yes");
INSERT INTO `wp_options` VALUES("47", "uploads_use_yearmonth_folders", "1", "yes");
INSERT INTO `wp_options` VALUES("48", "upload_path", "", "yes");
INSERT INTO `wp_options` VALUES("49", "blog_public", "1", "yes");
INSERT INTO `wp_options` VALUES("50", "default_link_category", "2", "yes");
INSERT INTO `wp_options` VALUES("51", "show_on_front", "page", "yes");
INSERT INTO `wp_options` VALUES("52", "tag_base", "", "yes");
INSERT INTO `wp_options` VALUES("53", "show_avatars", "1", "yes");
INSERT INTO `wp_options` VALUES("54", "avatar_rating", "G", "yes");
INSERT INTO `wp_options` VALUES("55", "upload_url_path", "", "yes");
INSERT INTO `wp_options` VALUES("56", "thumbnail_size_w", "150", "yes");
INSERT INTO `wp_options` VALUES("57", "thumbnail_size_h", "150", "yes");
INSERT INTO `wp_options` VALUES("58", "thumbnail_crop", "1", "yes");
INSERT INTO `wp_options` VALUES("59", "medium_size_w", "300", "yes");
INSERT INTO `wp_options` VALUES("60", "medium_size_h", "300", "yes");
INSERT INTO `wp_options` VALUES("61", "avatar_default", "mystery", "yes");
INSERT INTO `wp_options` VALUES("62", "large_size_w", "1024", "yes");
INSERT INTO `wp_options` VALUES("63", "large_size_h", "1024", "yes");
INSERT INTO `wp_options` VALUES("64", "image_default_link_type", "none", "yes");
INSERT INTO `wp_options` VALUES("65", "image_default_size", "", "yes");
INSERT INTO `wp_options` VALUES("66", "image_default_align", "", "yes");
INSERT INTO `wp_options` VALUES("67", "close_comments_for_old_posts", "0", "yes");
INSERT INTO `wp_options` VALUES("68", "close_comments_days_old", "14", "yes");
INSERT INTO `wp_options` VALUES("69", "thread_comments", "1", "yes");
INSERT INTO `wp_options` VALUES("70", "thread_comments_depth", "5", "yes");
INSERT INTO `wp_options` VALUES("71", "page_comments", "0", "yes");
INSERT INTO `wp_options` VALUES("72", "comments_per_page", "50", "yes");
INSERT INTO `wp_options` VALUES("73", "default_comments_page", "newest", "yes");
INSERT INTO `wp_options` VALUES("74", "comment_order", "asc", "yes");
INSERT INTO `wp_options` VALUES("75", "sticky_posts", "a:0:{}", "yes");
INSERT INTO `wp_options` VALUES("76", "widget_categories", "a:2:{i:1;a:0:{}s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("77", "widget_text", "a:2:{i:1;a:0:{}s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("78", "widget_rss", "a:2:{i:1;a:0:{}s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("79", "uninstall_plugins", "a:0:{}", "no");
INSERT INTO `wp_options` VALUES("80", "timezone_string", "Europe/Paris", "yes");
INSERT INTO `wp_options` VALUES("81", "page_for_posts", "17", "yes");
INSERT INTO `wp_options` VALUES("82", "page_on_front", "16", "yes");
INSERT INTO `wp_options` VALUES("83", "default_post_format", "0", "yes");
INSERT INTO `wp_options` VALUES("84", "link_manager_enabled", "0", "yes");
INSERT INTO `wp_options` VALUES("85", "finished_splitting_shared_terms", "1", "yes");
INSERT INTO `wp_options` VALUES("86", "site_icon", "0", "yes");
INSERT INTO `wp_options` VALUES("87", "medium_large_size_w", "768", "yes");
INSERT INTO `wp_options` VALUES("88", "medium_large_size_h", "0", "yes");
INSERT INTO `wp_options` VALUES("89", "wp_page_for_privacy_policy", "3", "yes");
INSERT INTO `wp_options` VALUES("90", "show_comments_cookies_opt_in", "1", "yes");
INSERT INTO `wp_options` VALUES("91", "admin_email_lifespan", "1741937341", "yes");
INSERT INTO `wp_options` VALUES("92", "disallowed_keys", "", "no");
INSERT INTO `wp_options` VALUES("93", "comment_previously_approved", "1", "yes");
INSERT INTO `wp_options` VALUES("94", "auto_plugin_theme_update_emails", "a:0:{}", "no");
INSERT INTO `wp_options` VALUES("95", "auto_update_core_dev", "enabled", "yes");
INSERT INTO `wp_options` VALUES("96", "auto_update_core_minor", "enabled", "yes");
INSERT INTO `wp_options` VALUES("97", "auto_update_core_major", "enabled", "yes");
INSERT INTO `wp_options` VALUES("98", "wp_force_deactivated_plugins", "a:0:{}", "yes");
INSERT INTO `wp_options` VALUES("99", "initial_db_version", "51917", "yes");
INSERT INTO `wp_options` VALUES("100", "wp_user_roles", "a:6:{s:13:\"administrator\";a:2:{s:4:\"name\";s:13:\"Administrator\";s:12:\"capabilities\";a:62:{s:13:\"switch_themes\";b:1;s:11:\"edit_themes\";b:1;s:16:\"activate_plugins\";b:1;s:12:\"edit_plugins\";b:1;s:10:\"edit_users\";b:1;s:10:\"edit_files\";b:1;s:14:\"manage_options\";b:1;s:17:\"moderate_comments\";b:1;s:17:\"manage_categories\";b:1;s:12:\"manage_links\";b:1;s:12:\"upload_files\";b:1;s:6:\"import\";b:1;s:15:\"unfiltered_html\";b:1;s:10:\"edit_posts\";b:1;s:17:\"edit_others_posts\";b:1;s:20:\"edit_published_posts\";b:1;s:13:\"publish_posts\";b:1;s:10:\"edit_pages\";b:1;s:4:\"read\";b:1;s:8:\"level_10\";b:1;s:7:\"level_9\";b:1;s:7:\"level_8\";b:1;s:7:\"level_7\";b:1;s:7:\"level_6\";b:1;s:7:\"level_5\";b:1;s:7:\"level_4\";b:1;s:7:\"level_3\";b:1;s:7:\"level_2\";b:1;s:7:\"level_1\";b:1;s:7:\"level_0\";b:1;s:17:\"edit_others_pages\";b:1;s:20:\"edit_published_pages\";b:1;s:13:\"publish_pages\";b:1;s:12:\"delete_pages\";b:1;s:19:\"delete_others_pages\";b:1;s:22:\"delete_published_pages\";b:1;s:12:\"delete_posts\";b:1;s:19:\"delete_others_posts\";b:1;s:22:\"delete_published_posts\";b:1;s:20:\"delete_private_posts\";b:1;s:18:\"edit_private_posts\";b:1;s:18:\"read_private_posts\";b:1;s:20:\"delete_private_pages\";b:1;s:18:\"edit_private_pages\";b:1;s:18:\"read_private_pages\";b:1;s:12:\"delete_users\";b:1;s:12:\"create_users\";b:1;s:17:\"unfiltered_upload\";b:1;s:14:\"edit_dashboard\";b:1;s:14:\"update_plugins\";b:1;s:14:\"delete_plugins\";b:1;s:15:\"install_plugins\";b:1;s:13:\"update_themes\";b:1;s:14:\"install_themes\";b:1;s:11:\"update_core\";b:1;s:10:\"list_users\";b:1;s:12:\"remove_users\";b:1;s:13:\"promote_users\";b:1;s:18:\"edit_theme_options\";b:1;s:13:\"delete_themes\";b:1;s:6:\"export\";b:1;s:17:\"manage_forminator\";b:1;}}s:6:\"editor\";a:2:{s:4:\"name\";s:6:\"Editor\";s:12:\"capabilities\";a:34:{s:17:\"moderate_comments\";b:1;s:17:\"manage_categories\";b:1;s:12:\"manage_links\";b:1;s:12:\"upload_files\";b:1;s:15:\"unfiltered_html\";b:1;s:10:\"edit_posts\";b:1;s:17:\"edit_others_posts\";b:1;s:20:\"edit_published_posts\";b:1;s:13:\"publish_posts\";b:1;s:10:\"edit_pages\";b:1;s:4:\"read\";b:1;s:7:\"level_7\";b:1;s:7:\"level_6\";b:1;s:7:\"level_5\";b:1;s:7:\"level_4\";b:1;s:7:\"level_3\";b:1;s:7:\"level_2\";b:1;s:7:\"level_1\";b:1;s:7:\"level_0\";b:1;s:17:\"edit_others_pages\";b:1;s:20:\"edit_published_pages\";b:1;s:13:\"publish_pages\";b:1;s:12:\"delete_pages\";b:1;s:19:\"delete_others_pages\";b:1;s:22:\"delete_published_pages\";b:1;s:12:\"delete_posts\";b:1;s:19:\"delete_others_posts\";b:1;s:22:\"delete_published_posts\";b:1;s:20:\"delete_private_posts\";b:1;s:18:\"edit_private_posts\";b:1;s:18:\"read_private_posts\";b:1;s:20:\"delete_private_pages\";b:1;s:18:\"edit_private_pages\";b:1;s:18:\"read_private_pages\";b:1;}}s:6:\"author\";a:2:{s:4:\"name\";s:6:\"Author\";s:12:\"capabilities\";a:10:{s:12:\"upload_files\";b:1;s:10:\"edit_posts\";b:1;s:20:\"edit_published_posts\";b:1;s:13:\"publish_posts\";b:1;s:4:\"read\";b:1;s:7:\"level_2\";b:1;s:7:\"level_1\";b:1;s:7:\"level_0\";b:1;s:12:\"delete_posts\";b:1;s:22:\"delete_published_posts\";b:1;}}s:11:\"contributor\";a:2:{s:4:\"name\";s:11:\"Contributor\";s:12:\"capabilities\";a:5:{s:10:\"edit_posts\";b:1;s:4:\"read\";b:1;s:7:\"level_1\";b:1;s:7:\"level_0\";b:1;s:12:\"delete_posts\";b:1;}}s:10:\"subscriber\";a:2:{s:4:\"name\";s:10:\"Subscriber\";s:12:\"capabilities\";a:2:{s:4:\"read\";b:1;s:7:\"level_0\";b:1;}}s:22:\"colibri_content_editor\";a:2:{s:4:\"name\";s:14:\"Content Editor\";s:12:\"capabilities\";a:36:{s:17:\"moderate_comments\";b:1;s:17:\"manage_categories\";b:1;s:12:\"manage_links\";b:1;s:12:\"upload_files\";b:1;s:15:\"unfiltered_html\";b:1;s:10:\"edit_posts\";b:1;s:17:\"edit_others_posts\";b:1;s:20:\"edit_published_posts\";b:1;s:13:\"publish_posts\";b:1;s:10:\"edit_pages\";b:1;s:4:\"read\";b:1;s:7:\"level_7\";b:1;s:7:\"level_6\";b:1;s:7:\"level_5\";b:1;s:7:\"level_4\";b:1;s:7:\"level_3\";b:1;s:7:\"level_2\";b:1;s:7:\"level_1\";b:1;s:7:\"level_0\";b:1;s:17:\"edit_others_pages\";b:1;s:20:\"edit_published_pages\";b:1;s:13:\"publish_pages\";b:1;s:12:\"delete_pages\";b:1;s:19:\"delete_others_pages\";b:1;s:22:\"delete_published_pages\";b:1;s:12:\"delete_posts\";b:1;s:19:\"delete_others_posts\";b:1;s:22:\"delete_published_posts\";b:1;s:20:\"delete_private_posts\";b:1;s:18:\"edit_private_posts\";b:1;s:18:\"read_private_posts\";b:1;s:20:\"delete_private_pages\";b:1;s:18:\"edit_private_pages\";b:1;s:18:\"read_private_pages\";b:1;s:18:\"edit_theme_options\";b:1;s:9:\"customize\";b:1;}}}", "yes");
INSERT INTO `wp_options` VALUES("101", "fresh_site", "0", "yes");
INSERT INTO `wp_options` VALUES("102", "WPLANG", "fr_FR", "yes");
INSERT INTO `wp_options` VALUES("103", "widget_block", "a:6:{i:2;a:1:{s:7:\"content\";s:60:\"<!-- wp:search {\"showLabel\":false,\"buttonUseIcon\":true} /-->\";}i:3;a:1:{s:7:\"content\";s:159:\"<!-- wp:group --><div class=\"wp-block-group\"><!-- wp:heading --><h2>Articles récents</h2><!-- /wp:heading --><!-- wp:latest-posts /--></div><!-- /wp:group -->\";}i:4;a:1:{s:7:\"content\";s:233:\"<!-- wp:group --><div class=\"wp-block-group\"><!-- wp:heading --><h2>Commentaires récents</h2><!-- /wp:heading --><!-- wp:latest-comments {\"displayAvatar\":false,\"displayDate\":false,\"displayExcerpt\":false} /--></div><!-- /wp:group -->\";}i:5;a:1:{s:7:\"content\";s:146:\"<!-- wp:group --><div class=\"wp-block-group\"><!-- wp:heading --><h2>Archives</h2><!-- /wp:heading --><!-- wp:archives /--></div><!-- /wp:group -->\";}i:6;a:1:{s:7:\"content\";s:151:\"<!-- wp:group --><div class=\"wp-block-group\"><!-- wp:heading --><h2>Catégories</h2><!-- /wp:heading --><!-- wp:categories /--></div><!-- /wp:group -->\";}s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("104", "sidebars_widgets", "a:14:{s:19:\"wp_inactive_widgets\";a:0:{}s:22:\"colibri-ecommerce-left\";a:0:{}s:17:\"colibri-sidebar-1\";a:5:{i:0;s:7:\"block-2\";i:1;s:7:\"block-3\";i:2;s:7:\"block-4\";i:3;s:7:\"block-5\";i:4;s:7:\"block-6\";}s:28:\"colibri-header-widget-area-1\";a:0:{}s:28:\"colibri-header-widget-area-2\";a:0:{}s:28:\"colibri-header-widget-area-3\";a:0:{}s:29:\"colibri-content-widget-area-1\";a:0:{}s:29:\"colibri-content-widget-area-2\";a:0:{}s:29:\"colibri-content-widget-area-3\";a:0:{}s:28:\"colibri-footer-widget-area-1\";a:0:{}s:28:\"colibri-footer-widget-area-2\";a:0:{}s:28:\"colibri-footer-widget-area-3\";a:0:{}s:28:\"colibri-footer-widget-area-4\";a:0:{}s:13:\"array_version\";i:3;}", "yes");
INSERT INTO `wp_options` VALUES("105", "cron", "a:14:{i:1730682519;a:1:{s:26:\"action_scheduler_run_queue\";a:1:{s:32:\"0d04ed39571b55704c122d726248bbac\";a:3:{s:8:\"schedule\";s:12:\"every_minute\";s:4:\"args\";a:1:{i:0;s:7:\"WP Cron\";}s:8:\"interval\";i:60;}}}i:1730683997;a:1:{s:34:\"wp_privacy_delete_old_export_files\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:6:\"hourly\";s:4:\"args\";a:0:{}s:8:\"interval\";i:3600;}}}i:1730692949;a:1:{s:73:\"ColibriWP\\PageBuilder\\Notify\\NotificationsManager::getRemoteNotifications\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:10:\"twicedaily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:43200;}}}i:1730712797;a:3:{s:16:\"wp_version_check\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:10:\"twicedaily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:43200;}}s:17:\"wp_update_plugins\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:10:\"twicedaily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:43200;}}s:16:\"wp_update_themes\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:10:\"twicedaily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:43200;}}}i:1730712888;a:1:{s:21:\"wp_update_user_counts\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:10:\"twicedaily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:43200;}}}i:1730737326;a:2:{s:25:\"swpm_account_status_event\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}s:33:\"swpm_delete_pending_account_event\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}}i:1730755995;a:1:{s:32:\"recovery_mode_clean_expired_keys\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}}i:1730756023;a:2:{s:19:\"wp_scheduled_delete\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}s:25:\"delete_expired_transients\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}}i:1730756027;a:1:{s:30:\"wp_scheduled_auto_draft_delete\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}}i:1731101595;a:1:{s:30:\"wp_site_health_scheduled_check\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:6:\"weekly\";s:4:\"args\";a:0:{}s:8:\"interval\";i:604800;}}}i:1731167806;a:1:{s:30:\"wp_delete_temp_updater_backups\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:6:\"weekly\";s:4:\"args\";a:0:{}s:8:\"interval\";i:604800;}}}i:1731291425;a:1:{s:30:\"duplicator_usage_tracking_cron\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:22:\"duplicator_weekly_cron\";s:4:\"args\";a:0:{}s:8:\"interval\";i:604800;}}}i:1731330000;a:1:{s:29:\"duplicator_email_summary_cron\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:22:\"duplicator_weekly_cron\";s:4:\"args\";a:0:{}s:8:\"interval\";i:604800;}}}s:7:\"version\";i:2;}", "yes");
INSERT INTO `wp_options` VALUES("106", "widget_pages", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("107", "widget_calendar", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("108", "widget_archives", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("109", "widget_media_audio", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("110", "widget_media_image", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("111", "widget_media_gallery", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("112", "widget_media_video", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("113", "widget_meta", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("114", "widget_search", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("115", "widget_tag_cloud", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("116", "widget_nav_menu", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("117", "widget_custom_html", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("119", "recovery_keys", "a:0:{}", "yes");
INSERT INTO `wp_options` VALUES("122", "theme_mods_twentytwentytwo", "a:2:{s:18:\"custom_css_post_id\";i:-1;s:16:\"sidebars_widgets\";a:2:{s:4:\"time\";i:1687470405;s:4:\"data\";a:3:{s:19:\"wp_inactive_widgets\";a:0:{}s:9:\"sidebar-1\";a:3:{i:0;s:7:\"block-2\";i:1;s:7:\"block-3\";i:2;s:7:\"block-4\";}s:9:\"sidebar-2\";a:2:{i:0;s:7:\"block-5\";i:1;s:7:\"block-6\";}}}}", "off");
INSERT INTO `wp_options` VALUES("156", "user_count", "1", "no");
INSERT INTO `wp_options` VALUES("157", "db_upgraded", "", "yes");
INSERT INTO `wp_options` VALUES("3464", "_site_transient_timeout_poptags_40cd750bba9870f18aada2478b24840a", "1730693047", "off");
INSERT INTO `wp_options` VALUES("3465", "_site_transient_poptags_40cd750bba9870f18aada2478b24840a", "O:8:\"stdClass\":100:{s:11:\"woocommerce\";a:3:{s:4:\"name\";s:11:\"woocommerce\";s:4:\"slug\";s:11:\"woocommerce\";s:5:\"count\";i:6586;}s:6:\"widget\";a:3:{s:4:\"name\";s:6:\"widget\";s:4:\"slug\";s:6:\"widget\";s:5:\"count\";i:4852;}s:4:\"post\";a:3:{s:4:\"name\";s:4:\"post\";s:4:\"slug\";s:4:\"post\";s:5:\"count\";i:2793;}s:5:\"admin\";a:3:{s:4:\"name\";s:5:\"admin\";s:4:\"slug\";s:5:\"admin\";s:5:\"count\";i:2683;}s:5:\"posts\";a:3:{s:4:\"name\";s:5:\"posts\";s:4:\"slug\";s:5:\"posts\";s:5:\"count\";i:2084;}s:9:\"shortcode\";a:3:{s:4:\"name\";s:9:\"shortcode\";s:4:\"slug\";s:9:\"shortcode\";s:5:\"count\";i:1980;}s:8:\"comments\";a:3:{s:4:\"name\";s:8:\"comments\";s:4:\"slug\";s:8:\"comments\";s:5:\"count\";i:1928;}s:3:\"seo\";a:3:{s:4:\"name\";s:3:\"seo\";s:4:\"slug\";s:3:\"seo\";s:5:\"count\";i:1773;}s:6:\"images\";a:3:{s:4:\"name\";s:6:\"images\";s:4:\"slug\";s:6:\"images\";s:5:\"count\";i:1587;}s:5:\"image\";a:3:{s:4:\"name\";s:5:\"image\";s:4:\"slug\";s:5:\"image\";s:5:\"count\";i:1586;}s:6:\"google\";a:3:{s:4:\"name\";s:6:\"google\";s:4:\"slug\";s:6:\"google\";s:5:\"count\";i:1548;}s:9:\"ecommerce\";a:3:{s:4:\"name\";s:9:\"ecommerce\";s:4:\"slug\";s:9:\"ecommerce\";s:5:\"count\";i:1544;}s:7:\"twitter\";a:3:{s:4:\"name\";s:7:\"twitter\";s:4:\"slug\";s:7:\"twitter\";s:5:\"count\";i:1513;}s:8:\"facebook\";a:3:{s:4:\"name\";s:8:\"facebook\";s:4:\"slug\";s:8:\"facebook\";s:5:\"count\";i:1503;}s:5:\"email\";a:3:{s:4:\"name\";s:5:\"email\";s:4:\"slug\";s:5:\"email\";s:5:\"count\";i:1435;}s:7:\"sidebar\";a:3:{s:4:\"name\";s:7:\"sidebar\";s:4:\"slug\";s:7:\"sidebar\";s:5:\"count\";i:1316;}s:7:\"gallery\";a:3:{s:4:\"name\";s:7:\"gallery\";s:4:\"slug\";s:7:\"gallery\";s:5:\"count\";i:1311;}s:5:\"login\";a:3:{s:4:\"name\";s:5:\"login\";s:4:\"slug\";s:5:\"login\";s:5:\"count\";i:1179;}s:6:\"social\";a:3:{s:4:\"name\";s:6:\"social\";s:4:\"slug\";s:6:\"social\";s:5:\"count\";i:1170;}s:4:\"page\";a:3:{s:4:\"name\";s:4:\"page\";s:4:\"slug\";s:4:\"page\";s:5:\"count\";i:1162;}s:8:\"security\";a:3:{s:4:\"name\";s:8:\"security\";s:4:\"slug\";s:8:\"security\";s:5:\"count\";i:1150;}s:10:\"e-commerce\";a:3:{s:4:\"name\";s:10:\"e-commerce\";s:4:\"slug\";s:10:\"e-commerce\";s:5:\"count\";i:1029;}s:5:\"video\";a:3:{s:4:\"name\";s:5:\"video\";s:4:\"slug\";s:5:\"video\";s:5:\"count\";i:1020;}s:7:\"widgets\";a:3:{s:4:\"name\";s:7:\"widgets\";s:4:\"slug\";s:7:\"widgets\";s:5:\"count\";i:992;}s:7:\"payment\";a:3:{s:4:\"name\";s:7:\"payment\";s:4:\"slug\";s:7:\"payment\";s:5:\"count\";i:983;}s:9:\"analytics\";a:3:{s:4:\"name\";s:9:\"analytics\";s:4:\"slug\";s:9:\"analytics\";s:5:\"count\";i:948;}s:5:\"block\";a:3:{s:4:\"name\";s:5:\"block\";s:4:\"slug\";s:5:\"block\";s:5:\"count\";i:936;}s:9:\"gutenberg\";a:3:{s:4:\"name\";s:9:\"gutenberg\";s:4:\"slug\";s:9:\"gutenberg\";s:5:\"count\";i:918;}s:5:\"links\";a:3:{s:4:\"name\";s:5:\"links\";s:4:\"slug\";s:5:\"links\";s:5:\"count\";i:907;}s:4:\"form\";a:3:{s:4:\"name\";s:4:\"form\";s:4:\"slug\";s:4:\"form\";s:5:\"count\";i:900;}s:7:\"content\";a:3:{s:4:\"name\";s:7:\"content\";s:4:\"slug\";s:7:\"content\";s:5:\"count\";i:898;}s:4:\"spam\";a:3:{s:4:\"name\";s:4:\"spam\";s:4:\"slug\";s:4:\"spam\";s:5:\"count\";i:897;}s:6:\"slider\";a:3:{s:4:\"name\";s:6:\"slider\";s:4:\"slug\";s:6:\"slider\";s:5:\"count\";i:896;}s:15:\"payment-gateway\";a:3:{s:4:\"name\";s:15:\"payment gateway\";s:4:\"slug\";s:15:\"payment-gateway\";s:5:\"count\";i:844;}s:9:\"elementor\";a:3:{s:4:\"name\";s:9:\"elementor\";s:4:\"slug\";s:9:\"elementor\";s:5:\"count\";i:829;}s:5:\"media\";a:3:{s:4:\"name\";s:5:\"media\";s:4:\"slug\";s:5:\"media\";s:5:\"count\";i:816;}s:6:\"search\";a:3:{s:4:\"name\";s:6:\"search\";s:4:\"slug\";s:6:\"search\";s:5:\"count\";i:809;}s:6:\"editor\";a:3:{s:4:\"name\";s:6:\"editor\";s:4:\"slug\";s:6:\"editor\";s:5:\"count\";i:779;}s:10:\"buddypress\";a:3:{s:4:\"name\";s:10:\"buddypress\";s:4:\"slug\";s:10:\"buddypress\";s:5:\"count\";i:778;}s:12:\"contact-form\";a:3:{s:4:\"name\";s:12:\"contact form\";s:4:\"slug\";s:12:\"contact-form\";s:5:\"count\";i:757;}s:4:\"menu\";a:3:{s:4:\"name\";s:4:\"menu\";s:4:\"slug\";s:4:\"menu\";s:5:\"count\";i:757;}s:3:\"rss\";a:3:{s:4:\"name\";s:3:\"rss\";s:4:\"slug\";s:3:\"rss\";s:5:\"count\";i:754;}s:5:\"pages\";a:3:{s:4:\"name\";s:5:\"pages\";s:4:\"slug\";s:5:\"pages\";s:5:\"count\";i:733;}s:5:\"embed\";a:3:{s:4:\"name\";s:5:\"embed\";s:4:\"slug\";s:5:\"embed\";s:5:\"count\";i:717;}s:8:\"category\";a:3:{s:4:\"name\";s:8:\"category\";s:4:\"slug\";s:8:\"category\";s:5:\"count\";i:702;}s:4:\"feed\";a:3:{s:4:\"name\";s:4:\"feed\";s:4:\"slug\";s:4:\"feed\";s:5:\"count\";i:698;}s:4:\"ajax\";a:3:{s:4:\"name\";s:4:\"ajax\";s:4:\"slug\";s:4:\"ajax\";s:5:\"count\";i:673;}s:6:\"jquery\";a:3:{s:4:\"name\";s:6:\"jquery\";s:4:\"slug\";s:6:\"jquery\";s:5:\"count\";i:663;}s:7:\"youtube\";a:3:{s:4:\"name\";s:7:\"youtube\";s:4:\"slug\";s:7:\"youtube\";s:5:\"count\";i:657;}s:9:\"affiliate\";a:3:{s:4:\"name\";s:9:\"affiliate\";s:4:\"slug\";s:9:\"affiliate\";s:5:\"count\";i:633;}s:3:\"css\";a:3:{s:4:\"name\";s:3:\"css\";s:4:\"slug\";s:3:\"css\";s:5:\"count\";i:632;}s:3:\"api\";a:3:{s:4:\"name\";s:3:\"api\";s:4:\"slug\";s:3:\"api\";s:5:\"count\";i:631;}s:4:\"link\";a:3:{s:4:\"name\";s:4:\"link\";s:4:\"slug\";s:4:\"link\";s:5:\"count\";i:613;}s:10:\"javascript\";a:3:{s:4:\"name\";s:10:\"javascript\";s:4:\"slug\";s:10:\"javascript\";s:5:\"count\";i:612;}s:9:\"dashboard\";a:3:{s:4:\"name\";s:9:\"dashboard\";s:4:\"slug\";s:9:\"dashboard\";s:5:\"count\";i:606;}s:5:\"share\";a:3:{s:4:\"name\";s:5:\"share\";s:4:\"slug\";s:5:\"share\";s:5:\"count\";i:603;}s:9:\"marketing\";a:3:{s:4:\"name\";s:9:\"marketing\";s:4:\"slug\";s:9:\"marketing\";s:5:\"count\";i:601;}s:10:\"responsive\";a:3:{s:4:\"name\";s:10:\"responsive\";s:4:\"slug\";s:10:\"responsive\";s:5:\"count\";i:601;}s:8:\"shipping\";a:3:{s:4:\"name\";s:8:\"shipping\";s:4:\"slug\";s:8:\"shipping\";s:5:\"count\";i:598;}s:4:\"chat\";a:3:{s:4:\"name\";s:4:\"chat\";s:4:\"slug\";s:4:\"chat\";s:5:\"count\";i:597;}s:7:\"contact\";a:3:{s:4:\"name\";s:7:\"contact\";s:4:\"slug\";s:7:\"contact\";s:5:\"count\";i:592;}s:3:\"ads\";a:3:{s:4:\"name\";s:3:\"ads\";s:4:\"slug\";s:3:\"ads\";s:5:\"count\";i:582;}s:7:\"comment\";a:3:{s:4:\"name\";s:7:\"comment\";s:4:\"slug\";s:7:\"comment\";s:5:\"count\";i:577;}s:6:\"custom\";a:3:{s:4:\"name\";s:6:\"custom\";s:4:\"slug\";s:6:\"custom\";s:5:\"count\";i:576;}s:5:\"theme\";a:3:{s:4:\"name\";s:5:\"theme\";s:4:\"slug\";s:5:\"theme\";s:5:\"count\";i:574;}s:14:\"contact-form-7\";a:3:{s:4:\"name\";s:14:\"contact form 7\";s:4:\"slug\";s:14:\"contact-form-7\";s:5:\"count\";i:574;}s:6:\"events\";a:3:{s:4:\"name\";s:6:\"events\";s:4:\"slug\";s:6:\"events\";s:5:\"count\";i:568;}s:11:\"performance\";a:3:{s:4:\"name\";s:11:\"performance\";s:4:\"slug\";s:11:\"performance\";s:5:\"count\";i:566;}s:5:\"forms\";a:3:{s:4:\"name\";s:5:\"forms\";s:4:\"slug\";s:5:\"forms\";s:5:\"count\";i:555;}s:10:\"categories\";a:3:{s:4:\"name\";s:10:\"categories\";s:4:\"slug\";s:10:\"categories\";s:5:\"count\";i:551;}s:6:\"button\";a:3:{s:4:\"name\";s:6:\"button\";s:4:\"slug\";s:6:\"button\";s:5:\"count\";i:542;}s:5:\"popup\";a:3:{s:4:\"name\";s:5:\"popup\";s:4:\"slug\";s:5:\"popup\";s:5:\"count\";i:539;}s:6:\"blocks\";a:3:{s:4:\"name\";s:6:\"blocks\";s:4:\"slug\";s:6:\"blocks\";s:5:\"count\";i:533;}s:4:\"user\";a:3:{s:4:\"name\";s:4:\"user\";s:4:\"slug\";s:4:\"user\";s:5:\"count\";i:528;}s:8:\"calendar\";a:3:{s:4:\"name\";s:8:\"calendar\";s:4:\"slug\";s:8:\"calendar\";s:5:\"count\";i:524;}s:5:\"users\";a:3:{s:4:\"name\";s:5:\"users\";s:4:\"slug\";s:5:\"users\";s:5:\"count\";i:521;}s:4:\"tags\";a:3:{s:4:\"name\";s:4:\"tags\";s:4:\"slug\";s:4:\"tags\";s:5:\"count\";i:515;}s:6:\"mobile\";a:3:{s:4:\"name\";s:6:\"mobile\";s:4:\"slug\";s:6:\"mobile\";s:5:\"count\";i:509;}s:10:\"newsletter\";a:3:{s:4:\"name\";s:10:\"newsletter\";s:4:\"slug\";s:10:\"newsletter\";s:5:\"count\";i:501;}s:10:\"navigation\";a:3:{s:4:\"name\";s:10:\"navigation\";s:4:\"slug\";s:10:\"navigation\";s:5:\"count\";i:492;}s:8:\"payments\";a:3:{s:4:\"name\";s:8:\"payments\";s:4:\"slug\";s:8:\"payments\";s:5:\"count\";i:486;}s:12:\"social-media\";a:3:{s:4:\"name\";s:12:\"social media\";s:4:\"slug\";s:12:\"social-media\";s:5:\"count\";i:459;}s:5:\"stats\";a:3:{s:4:\"name\";s:5:\"stats\";s:4:\"slug\";s:5:\"stats\";s:5:\"count\";i:459;}s:9:\"slideshow\";a:3:{s:4:\"name\";s:9:\"slideshow\";s:4:\"slug\";s:9:\"slideshow\";s:5:\"count\";i:452;}s:7:\"gateway\";a:3:{s:4:\"name\";s:7:\"gateway\";s:4:\"slug\";s:7:\"gateway\";s:5:\"count\";i:452;}s:10:\"statistics\";a:3:{s:4:\"name\";s:10:\"statistics\";s:4:\"slug\";s:10:\"statistics\";s:5:\"count\";i:450;}s:12:\"notification\";a:3:{s:4:\"name\";s:12:\"notification\";s:4:\"slug\";s:12:\"notification\";s:5:\"count\";i:450;}s:5:\"photo\";a:3:{s:4:\"name\";s:5:\"photo\";s:4:\"slug\";s:5:\"photo\";s:5:\"count\";i:449;}s:8:\"tracking\";a:3:{s:4:\"name\";s:8:\"tracking\";s:4:\"slug\";s:8:\"tracking\";s:5:\"count\";i:444;}s:8:\"redirect\";a:3:{s:4:\"name\";s:8:\"redirect\";s:4:\"slug\";s:8:\"redirect\";s:5:\"count\";i:438;}s:8:\"checkout\";a:3:{s:4:\"name\";s:8:\"checkout\";s:4:\"slug\";s:8:\"checkout\";s:5:\"count\";i:436;}s:6:\"import\";a:3:{s:4:\"name\";s:6:\"import\";s:4:\"slug\";s:6:\"import\";s:5:\"count\";i:433;}s:6:\"photos\";a:3:{s:4:\"name\";s:6:\"photos\";s:4:\"slug\";s:6:\"photos\";s:5:\"count\";i:430;}s:4:\"news\";a:3:{s:4:\"name\";s:4:\"news\";s:4:\"slug\";s:4:\"news\";s:5:\"count\";i:430;}s:4:\"code\";a:3:{s:4:\"name\";s:4:\"code\";s:4:\"slug\";s:4:\"code\";s:5:\"count\";i:419;}s:5:\"cache\";a:3:{s:4:\"name\";s:5:\"cache\";s:4:\"slug\";s:5:\"cache\";s:5:\"count\";i:417;}s:10:\"shortcodes\";a:3:{s:4:\"name\";s:10:\"shortcodes\";s:4:\"slug\";s:10:\"shortcodes\";s:5:\"count\";i:415;}s:7:\"plugins\";a:3:{s:4:\"name\";s:7:\"plugins\";s:4:\"slug\";s:7:\"plugins\";s:5:\"count\";i:404;}s:9:\"multisite\";a:3:{s:4:\"name\";s:9:\"multisite\";s:4:\"slug\";s:9:\"multisite\";s:5:\"count\";i:397;}s:3:\"map\";a:3:{s:4:\"name\";s:3:\"map\";s:4:\"slug\";s:3:\"map\";s:5:\"count\";i:393;}}", "off");
INSERT INTO `wp_options` VALUES("197", "current_theme", "Brite", "yes");
INSERT INTO `wp_options` VALUES("198", "theme_mods_olivewp", "a:18:{i:0;b:0;s:18:\"nav_menu_locations\";a:0:{}s:18:\"custom_css_post_id\";i:-1;s:16:\"background_image\";s:0:\"\";s:21:\"background_position_x\";s:4:\"left\";s:21:\"background_position_y\";s:3:\"top\";s:17:\"background_preset\";s:6:\"custom\";s:15:\"background_size\";s:5:\"cover\";s:17:\"background_repeat\";s:9:\"no-repeat\";s:21:\"background_attachment\";s:5:\"fixed\";s:19:\"enable_header_color\";b:1;s:17:\"enable_menu_color\";b:1;s:16:\"background_color\";s:6:\"282828\";s:27:\"site_title_link_hover_color\";s:7:\"#eded61\";s:18:\"tagline_text_color\";s:7:\"#ffffff\";s:21:\"menu_link_hover_color\";s:7:\"#f9ff93\";s:22:\"menu_active_link_color\";s:7:\"#eeee22\";s:16:\"sidebars_widgets\";a:2:{s:4:\"time\";i:1687472421;s:4:\"data\";a:7:{s:19:\"wp_inactive_widgets\";a:0:{}s:9:\"sidebar-1\";a:5:{i:0;s:7:\"block-2\";i:1;s:7:\"block-3\";i:2;s:7:\"block-4\";i:3;s:7:\"block-5\";i:4;s:7:\"block-6\";}s:16:\"footer-sidebar-1\";a:0:{}s:16:\"footer-sidebar-2\";a:0:{}s:16:\"footer-sidebar-3\";a:0:{}s:16:\"footer-sidebar-4\";a:0:{}s:11:\"woocommerce\";a:0:{}}}}", "off");
INSERT INTO `wp_options` VALUES("199", "theme_switched", "", "yes");
INSERT INTO `wp_options` VALUES("200", "olivewp_single_post_ordering", "old", "yes");
INSERT INTO `wp_options` VALUES("204", "fs_debug_mode", "", "yes");
INSERT INTO `wp_options` VALUES("205", "fs_accounts", "a:7:{s:21:\"id_slug_type_path_map\";a:1:{i:10330;a:3:{s:4:\"slug\";s:7:\"olivewp\";s:4:\"type\";s:5:\"theme\";s:4:\"path\";s:21:\"olivewp/functions.php\";}}s:10:\"theme_data\";a:1:{s:7:\"olivewp\";a:17:{s:16:\"plugin_main_file\";O:8:\"stdClass\":1:{s:4:\"path\";s:21:\"olivewp/functions.php\";}s:20:\"is_network_activated\";b:0;s:17:\"install_timestamp\";i:1687470422;s:17:\"was_plugin_loaded\";b:1;s:16:\"sdk_last_version\";N;s:11:\"sdk_version\";s:5:\"2.4.3\";s:16:\"sdk_upgrade_mode\";b:1;s:18:\"sdk_downgrade_mode\";b:0;s:19:\"plugin_last_version\";N;s:14:\"plugin_version\";s:5:\"1.1.3\";s:19:\"plugin_upgrade_mode\";b:1;s:21:\"plugin_downgrade_mode\";b:0;s:17:\"connectivity_test\";a:6:{s:12:\"is_connected\";b:1;s:4:\"host\";s:9:\"localhost\";s:9:\"server_ip\";s:3:\"::1\";s:9:\"is_active\";b:1;s:9:\"timestamp\";i:1687470424;s:7:\"version\";s:5:\"1.1.3\";}s:15:\"prev_is_premium\";b:0;s:18:\"sticky_optin_added\";b:1;s:12:\"is_anonymous\";a:3:{s:2:\"is\";b:1;s:9:\"timestamp\";i:1687470437;s:7:\"version\";s:5:\"1.1.3\";}s:16:\"uninstall_reason\";O:8:\"stdClass\":3:{s:2:\"id\";s:2:\"10\";s:4:\"info\";s:0:\"\";s:12:\"is_anonymous\";b:0;}}}s:13:\"file_slug_map\";a:1:{s:7:\"olivewp\";s:7:\"olivewp\";}s:6:\"themes\";a:1:{s:7:\"olivewp\";O:9:\"FS_Plugin\":23:{s:16:\"parent_plugin_id\";N;s:5:\"title\";s:7:\"OliveWP\";s:4:\"slug\";s:7:\"olivewp\";s:12:\"premium_slug\";s:12:\"olivewp_plan\";s:4:\"type\";s:5:\"theme\";s:20:\"affiliate_moderation\";b:0;s:19:\"is_wp_org_compliant\";b:1;s:22:\"premium_releases_count\";N;s:4:\"file\";s:7:\"olivewp\";s:7:\"version\";s:5:\"1.1.3\";s:11:\"auto_update\";N;s:4:\"info\";N;s:10:\"is_premium\";b:0;s:14:\"premium_suffix\";s:9:\"(Premium)\";s:7:\"is_live\";b:1;s:9:\"bundle_id\";s:4:\"9961\";s:17:\"bundle_public_key\";s:32:\"pk_d4762792d77b81b0c31bd815b4739\";s:10:\"public_key\";s:32:\"pk_d9c2bea1c4f0cad4798c85c485901\";s:10:\"secret_key\";N;s:2:\"id\";s:5:\"10330\";s:7:\"updated\";N;s:7:\"created\";N;s:22:\"\0FS_Entity\0_is_updated\";b:0;}}s:9:\"unique_id\";s:32:\"90380f61d3627eae1a3987405775361f\";s:13:\"admin_notices\";a:1:{s:13:\"olivewp:theme\";a:0:{}}s:6:\"addons\";a:1:{i:10330;a:12:{i:0;O:9:\"FS_Plugin\":23:{s:16:\"parent_plugin_id\";s:5:\"10330\";s:5:\"title\";s:18:\"Spice Social Share\";s:4:\"slug\";s:18:\"spice-social-share\";s:12:\"premium_slug\";s:26:\"spice-social-share-premium\";s:4:\"type\";s:6:\"plugin\";s:20:\"affiliate_moderation\";N;s:19:\"is_wp_org_compliant\";b:1;s:22:\"premium_releases_count\";i:0;s:4:\"file\";N;s:7:\"version\";N;s:11:\"auto_update\";N;s:4:\"info\";O:14:\"FS_Plugin_Info\":13:{s:9:\"plugin_id\";s:5:\"10571\";s:11:\"description\";s:331:\"<h2>About Social Share</h2><p>This plugin allows you to add the social icons on the single posts.</p><ul><li>Add social icons on the posts.</li><li>Change the position of the heading</li><li>Change the colors of the heading and icons.</li><li>Share the posts on social media.</li><li>Change the typography of the heading.</li></ul>\";s:17:\"short_description\";s:67:\"Add the social icons on the single posts like Facebook and Twitter.\";s:10:\"banner_url\";s:68:\"https://s3-us-west-2.amazonaws.com/freemius/plugins/10571/banner.jpg\";s:15:\"card_banner_url\";s:73:\"https://s3-us-west-2.amazonaws.com/freemius/plugins/10571/card_banner.jpg\";s:15:\"selling_point_0\";s:30:\"Add social icons on the posts.\";s:15:\"selling_point_1\";s:42:\"Change the colors of the heading and icons\";s:15:\"selling_point_2\";s:35:\"Change the position of the heading.\";s:11:\"screenshots\";O:8:\"stdClass\":2:{s:12:\"screenshot_0\";s:75:\"https://s3-us-west-2.amazonaws.com/freemius/plugins/10571/screenshots/0.png\";s:12:\"screenshot_1\";s:75:\"https://s3-us-west-2.amazonaws.com/freemius/plugins/10571/screenshots/1.png\";}s:2:\"id\";s:4:\"2880\";s:7:\"updated\";s:19:\"2022-06-28 15:28:47\";s:7:\"created\";s:19:\"2022-06-27 13:05:31\";s:22:\"\0FS_Entity\0_is_updated\";b:0;}s:10:\"is_premium\";b:0;s:14:\"premium_suffix\";s:9:\"(Premium)\";s:7:\"is_live\";b:1;s:9:\"bundle_id\";N;s:17:\"bundle_public_key\";N;s:10:\"public_key\";s:32:\"pk_8f3da04d32b1612b775baef8bd2af\";s:10:\"secret_key\";N;s:2:\"id\";s:5:\"10571\";s:7:\"updated\";s:19:\"2022-06-27 13:05:31\";s:7:\"created\";s:19:\"2022-06-27 12:53:03\";s:22:\"\0FS_Entity\0_is_updated\";b:0;}i:1;O:9:\"FS_Plugin\":23:{s:16:\"parent_plugin_id\";s:5:\"10330\";s:5:\"title\";s:15:\"Spice Portfolio\";s:4:\"slug\";s:15:\"spice-portfolio\";s:12:\"premium_slug\";s:15:\"spice-portfolio\";s:4:\"type\";s:6:\"plugin\";s:20:\"affiliate_moderation\";N;s:19:\"is_wp_org_compliant\";b:0;s:22:\"premium_releases_count\";i:3;s:4:\"file\";N;s:7:\"version\";N;s:11:\"auto_update\";N;s:4:\"info\";O:14:\"FS_Plugin_Info\":13:{s:9:\"plugin_id\";s:5:\"10572\";s:11:\"description\";s:374:\"<p>This plugin allows you to showcase your projects in a beautiful portfolio with multiple options.</p><ul><li>Choose number of columns</li><li>Enable/Disable project title and category</li><li>Sort the order in ascending and descending order</li><li>Enable/Disable filter bar</li><li>Change the colors of the content</li><li>Display items by categories and author</li></ul>\";s:17:\"short_description\";s:67:\"Showcase the portfolio anywhere on your website in a beautiful way.\";s:10:\"banner_url\";s:68:\"https://s3-us-west-2.amazonaws.com/freemius/plugins/10572/banner.jpg\";s:15:\"card_banner_url\";s:73:\"https://s3-us-west-2.amazonaws.com/freemius/plugins/10572/card_banner.jpg\";s:15:\"selling_point_0\";s:59:\"Display the portfolio anywhere you want by using shortcode.\";s:15:\"selling_point_1\";s:39:\"Enter the number of projects to display\";s:15:\"selling_point_2\";s:68:\"Change the typography of the content. More features mentioned below.\";s:11:\"screenshots\";O:8:\"stdClass\":2:{s:12:\"screenshot_0\";s:75:\"https://s3-us-west-2.amazonaws.com/freemius/plugins/10572/screenshots/0.png\";s:12:\"screenshot_1\";s:75:\"https://s3-us-west-2.amazonaws.com/freemius/plugins/10572/screenshots/1.png\";}s:2:\"id\";s:4:\"2886\";s:7:\"updated\";s:19:\"2022-06-28 14:50:29\";s:7:\"created\";s:19:\"2022-06-28 09:07:30\";s:22:\"\0FS_Entity\0_is_updated\";b:0;}s:10:\"is_premium\";b:0;s:14:\"premium_suffix\";s:9:\"(Premium)\";s:7:\"is_live\";b:1;s:9:\"bundle_id\";N;s:17:\"bundle_public_key\";N;s:10:\"public_key\";s:32:\"pk_0381788ca1e2cd246fd2f8921eb93\";s:10:\"secret_key\";N;s:2:\"id\";s:5:\"10572\";s:7:\"updated\";s:19:\"2023-08-15 01:10:36\";s:7:\"created\";s:19:\"2022-06-27 13:13:55\";s:22:\"\0FS_Entity\0_is_updated\";b:0;}i:2;O:9:\"FS_Plugin\":23:{s:16:\"parent_plugin_id\";s:5:\"10330\";s:5:\"title\";s:17:\"Spice White Label\";s:4:\"slug\";s:17:\"spice-white-label\";s:12:\"premium_slug\";s:17:\"spice-white-label\";s:4:\"type\";s:6:\"plugin\";s:20:\"affiliate_moderation\";N;s:19:\"is_wp_org_compliant\";b:0;s:22:\"premium_releases_count\";i:2;s:4:\"file\";N;s:7:\"version\";N;s:11:\"auto_update\";N;s:4:\"info\";O:14:\"FS_Plugin_Info\":13:{s:9:\"plugin_id\";s:5:\"10573\";s:11:\"description\";s:409:\"<h2>About White Label</h2><p>This plugin allows you to replace the theme details like name, description, author name, etc by your own brand name.</p><ul><li>Hide the theme section in customizer.</li><li>Change the theme description.</li><li>Change the theme author name.</li><li>Change the theme screenshot.</li><li>Change the theme author URL.</li><li>Replace the theme name by your own brand name.</li></ul>\";s:17:\"short_description\";s:75:\"The clients can change the theme details like name by their own brand name.\";s:10:\"banner_url\";s:68:\"https://s3-us-west-2.amazonaws.com/freemius/plugins/10573/banner.jpg\";s:15:\"card_banner_url\";s:73:\"https://s3-us-west-2.amazonaws.com/freemius/plugins/10573/card_banner.jpg\";s:15:\"selling_point_0\";s:46:\"Replace the theme name by your own brand name.\";s:15:\"selling_point_1\";s:28:\"Change the theme author URL.\";s:15:\"selling_point_2\";s:29:\"Change the theme author name.\";s:11:\"screenshots\";O:8:\"stdClass\":1:{s:12:\"screenshot_0\";s:75:\"https://s3-us-west-2.amazonaws.com/freemius/plugins/10573/screenshots/0.png\";}s:2:\"id\";s:4:\"2890\";s:7:\"updated\";s:19:\"2022-06-28 15:39:05\";s:7:\"created\";s:19:\"2022-06-28 09:12:58\";s:22:\"\0FS_Entity\0_is_updated\";b:0;}s:10:\"is_premium\";b:0;s:14:\"premium_suffix\";s:9:\"(Premium)\";s:7:\"is_live\";b:1;s:9:\"bundle_id\";N;s:17:\"bundle_public_key\";N;s:10:\"public_key\";s:32:\"pk_6a6aa7643a2adc4d19e6d1eb1f2a3\";s:10:\"secret_key\";N;s:2:\"id\";s:5:\"10573\";s:7:\"updated\";s:19:\"2023-10-13 14:38:44\";s:7:\"created\";s:19:\"2022-06-27 13:15:50\";s:22:\"\0FS_Entity\0_is_updated\";b:0;}i:3;O:9:\"FS_Plugin\":23:{s:16:\"parent_plugin_id\";s:5:\"10330\";s:5:\"title\";s:13:\"Spice Cookies\";s:4:\"slug\";s:13:\"spice-cookies\";s:12:\"premium_slug\";s:13:\"spice-cookies\";s:4:\"type\";s:6:\"plugin\";s:20:\"affiliate_moderation\";N;s:19:\"is_wp_org_compliant\";b:0;s:22:\"premium_releases_count\";i:1;s:4:\"file\";N;s:7:\"version\";N;s:11:\"auto_update\";N;s:4:\"info\";O:14:\"FS_Plugin_Info\":13:{s:9:\"plugin_id\";s:5:\"10574\";s:11:\"description\";s:332:\"<h2>About Cookies</h2><p>This plugin allows you to show the cookie notice in your website and inform users that the site uses cookies.</p><ul><li>Enter your own content</li><li>Enter the cookie expire time</li><li>Change the colors of the content</li><li>Enter your button text</li><li>Change the typography of the content</li></ul>\";s:17:\"short_description\";s:65:\"Display the cookie notice in your website with the accept button.\";s:10:\"banner_url\";s:68:\"https://s3-us-west-2.amazonaws.com/freemius/plugins/10574/banner.jpg\";s:15:\"card_banner_url\";s:73:\"https://s3-us-west-2.amazonaws.com/freemius/plugins/10574/card_banner.jpg\";s:15:\"selling_point_0\";s:29:\"Enter the cookie expire time.\";s:15:\"selling_point_1\";s:33:\"Change the colors of the content.\";s:15:\"selling_point_2\";s:37:\"Change the typography of the content.\";s:11:\"screenshots\";O:8:\"stdClass\":2:{s:12:\"screenshot_0\";s:75:\"https://s3-us-west-2.amazonaws.com/freemius/plugins/10574/screenshots/0.png\";s:12:\"screenshot_1\";s:75:\"https://s3-us-west-2.amazonaws.com/freemius/plugins/10574/screenshots/1.png\";}s:2:\"id\";s:4:\"2883\";s:7:\"updated\";s:19:\"2022-06-28 15:07:22\";s:7:\"created\";s:19:\"2022-06-28 08:57:53\";s:22:\"\0FS_Entity\0_is_updated\";b:0;}s:10:\"is_premium\";b:0;s:14:\"premium_suffix\";s:9:\"(Premium)\";s:7:\"is_live\";b:1;s:9:\"bundle_id\";N;s:17:\"bundle_public_key\";N;s:10:\"public_key\";s:32:\"pk_bd8fd588af45f7d46543f8a297c04\";s:10:\"secret_key\";N;s:2:\"id\";s:5:\"10574\";s:7:\"updated\";s:19:\"2023-02-18 16:18:36\";s:7:\"created\";s:19:\"2022-06-27 13:16:47\";s:22:\"\0FS_Entity\0_is_updated\";b:0;}i:4;O:9:\"FS_Plugin\":23:{s:16:\"parent_plugin_id\";s:5:\"10330\";s:5:\"title\";s:19:\"Spice Sticky Footer\";s:4:\"slug\";s:19:\"spice-sticky-footer\";s:12:\"premium_slug\";s:19:\"spice-sticky-footer\";s:4:\"type\";s:6:\"plugin\";s:20:\"affiliate_moderation\";N;s:19:\"is_wp_org_compliant\";b:0;s:22:\"premium_releases_count\";i:1;s:4:\"file\";N;s:7:\"version\";N;s:11:\"auto_update\";N;s:4:\"info\";O:14:\"FS_Plugin_Info\":13:{s:9:\"plugin_id\";s:5:\"10575\";s:11:\"description\";s:372:\"<h2>About Sticky Footer</h2><p>This plugin allows you to stick the footer at the bottom of the screen while scrolling the pages.</p><ul><li>Enter your custom text.</li><li>Set the footer opacity.</li><li>Change the typography of the content.</li><li>Change the icon of your choice.</li><li>Enable/Disable text on mobile.</li><li>Change the colors of the content.</li></ul>\";s:17:\"short_description\";s:60:\"Stick your footer to the bottom of the screen during scroll.\";s:10:\"banner_url\";s:68:\"https://s3-us-west-2.amazonaws.com/freemius/plugins/10575/banner.jpg\";s:15:\"card_banner_url\";s:73:\"https://s3-us-west-2.amazonaws.com/freemius/plugins/10575/card_banner.jpg\";s:15:\"selling_point_0\";s:30:\"Enable/Disable text on mobile.\";s:15:\"selling_point_1\";s:31:\"Change the icon of your choice.\";s:15:\"selling_point_2\";s:23:\"Set the footer opacity.\";s:11:\"screenshots\";O:8:\"stdClass\":4:{s:12:\"screenshot_0\";s:75:\"https://s3-us-west-2.amazonaws.com/freemius/plugins/10575/screenshots/0.png\";s:12:\"screenshot_1\";s:75:\"https://s3-us-west-2.amazonaws.com/freemius/plugins/10575/screenshots/1.png\";s:12:\"screenshot_2\";s:75:\"https://s3-us-west-2.amazonaws.com/freemius/plugins/10575/screenshots/2.png\";s:12:\"screenshot_3\";s:75:\"https://s3-us-west-2.amazonaws.com/freemius/plugins/10575/screenshots/3.png\";}s:2:\"id\";s:4:\"2882\";s:7:\"updated\";s:19:\"2022-06-28 15:31:54\";s:7:\"created\";s:19:\"2022-06-28 07:21:27\";s:22:\"\0FS_Entity\0_is_updated\";b:0;}s:10:\"is_premium\";b:0;s:14:\"premium_suffix\";s:9:\"(Premium)\";s:7:\"is_live\";b:1;s:9:\"bundle_id\";N;s:17:\"bundle_public_key\";N;s:10:\"public_key\";s:32:\"pk_685ef2986180072080d00dc761a43\";s:10:\"secret_key\";N;s:2:\"id\";s:5:\"10575\";s:7:\"updated\";s:19:\"2023-10-13 14:40:02\";s:7:\"created\";s:19:\"2022-06-27 13:17:29\";s:22:\"\0FS_Entity\0_is_updated\";b:0;}i:5;O:9:\"FS_Plugin\":23:{s:16:\"parent_plugin_id\";s:5:\"10330\";s:5:\"title\";s:19:\"Spice Sticky Header\";s:4:\"slug\";s:19:\"spice-sticky-header\";s:12:\"premium_slug\";s:19:\"spice-sticky-header\";s:4:\"type\";s:6:\"plugin\";s:20:\"affiliate_moderation\";N;s:19:\"is_wp_org_compliant\";b:0;s:22:\"premium_releases_count\";i:1;s:4:\"file\";N;s:7:\"version\";N;s:11:\"auto_update\";N;s:4:\"info\";O:14:\"FS_Plugin_Info\":13:{s:9:\"plugin_id\";s:5:\"10576\";s:11:\"description\";s:487:\"<h2>About Sticky Header</h2><p>This plugin allows you to stick the header at the top of the screen during scrolling the pages.</p><ul><li>Choose to enable on the desktop or mobile or both.</li><li>Choose animation effect like shrink.</li><li>Set the header height during scroll.</li><li>Change the colors of the content.</li><li>Set different logo for desktop and mobile during scroll.</li><li>Set the header opacity during scroll.</li><li>Change the typography of the content.</li></ul>\";s:17:\"short_description\";s:57:\"Stick your header on the top of the screen during scroll.\";s:10:\"banner_url\";s:68:\"https://s3-us-west-2.amazonaws.com/freemius/plugins/10576/banner.jpg\";s:15:\"card_banner_url\";s:73:\"https://s3-us-west-2.amazonaws.com/freemius/plugins/10576/card_banner.jpg\";s:15:\"selling_point_0\";s:35:\"Manage sticky header as per device.\";s:15:\"selling_point_1\";s:37:\"Set the header opacity during scroll.\";s:15:\"selling_point_2\";s:57:\"Add different logo for different devices while scrolling.\";s:11:\"screenshots\";O:8:\"stdClass\":2:{s:12:\"screenshot_0\";s:75:\"https://s3-us-west-2.amazonaws.com/freemius/plugins/10576/screenshots/0.png\";s:12:\"screenshot_1\";s:75:\"https://s3-us-west-2.amazonaws.com/freemius/plugins/10576/screenshots/1.png\";}s:2:\"id\";s:4:\"2889\";s:7:\"updated\";s:19:\"2022-06-28 15:36:25\";s:7:\"created\";s:19:\"2022-06-28 09:12:01\";s:22:\"\0FS_Entity\0_is_updated\";b:0;}s:10:\"is_premium\";b:0;s:14:\"premium_suffix\";s:9:\"(Premium)\";s:7:\"is_live\";b:1;s:9:\"bundle_id\";N;s:17:\"bundle_public_key\";N;s:10:\"public_key\";s:32:\"pk_4c4751fb21516e4900bdcdd17d01a\";s:10:\"secret_key\";N;s:2:\"id\";s:5:\"10576\";s:7:\"updated\";s:19:\"2023-10-13 14:40:21\";s:7:\"created\";s:19:\"2022-06-27 13:18:41\";s:22:\"\0FS_Entity\0_is_updated\";b:0;}i:6;O:9:\"FS_Plugin\":23:{s:16:\"parent_plugin_id\";s:5:\"10330\";s:5:\"title\";s:16:\"Spice Side Panel\";s:4:\"slug\";s:16:\"spice-side-panel\";s:12:\"premium_slug\";s:16:\"spice-side-panel\";s:4:\"type\";s:6:\"plugin\";s:20:\"affiliate_moderation\";N;s:19:\"is_wp_org_compliant\";b:0;s:22:\"premium_releases_count\";i:3;s:4:\"file\";N;s:7:\"version\";N;s:11:\"auto_update\";N;s:4:\"info\";O:14:\"FS_Plugin_Info\":13:{s:9:\"plugin_id\";s:5:\"10577\";s:11:\"description\";s:423:\"<h2>About Side Panel</h2><p>Add useful content in the side panel with the help of widgets. Plugin have many configuration settings to manage the Side Panel.</p><h2>More Features</h2><ul><li>Change the icon button position.</li><li>Change the side panel width.</li><li>Add your own typography & color.</li><li>Add text for closing button.</li><li>Add padding for side panel</li><li>Set overlay when panel is opened</li></ul>\";s:17:\"short_description\";s:62:\"Add useful content in the side panel with the help of widgets.\";s:10:\"banner_url\";s:68:\"https://s3-us-west-2.amazonaws.com/freemius/plugins/10577/banner.jpg\";s:15:\"card_banner_url\";s:73:\"https://s3-us-west-2.amazonaws.com/freemius/plugins/10577/card_banner.jpg\";s:15:\"selling_point_0\";s:33:\"Add widgets in side panel sidebar\";s:15:\"selling_point_1\";s:40:\"Set panel width according to screen size\";s:15:\"selling_point_2\";s:67:\"Dispaly panel on left and right side. More features mentioned below\";s:11:\"screenshots\";O:8:\"stdClass\":3:{s:12:\"screenshot_0\";s:75:\"https://s3-us-west-2.amazonaws.com/freemius/plugins/10577/screenshots/0.png\";s:12:\"screenshot_1\";s:75:\"https://s3-us-west-2.amazonaws.com/freemius/plugins/10577/screenshots/1.png\";s:12:\"screenshot_2\";s:75:\"https://s3-us-west-2.amazonaws.com/freemius/plugins/10577/screenshots/2.png\";}s:2:\"id\";s:4:\"2888\";s:7:\"updated\";s:19:\"2022-06-28 15:26:32\";s:7:\"created\";s:19:\"2022-06-28 09:09:51\";s:22:\"\0FS_Entity\0_is_updated\";b:0;}s:10:\"is_premium\";b:0;s:14:\"premium_suffix\";s:9:\"(Premium)\";s:7:\"is_live\";b:1;s:9:\"bundle_id\";N;s:17:\"bundle_public_key\";N;s:10:\"public_key\";s:32:\"pk_ff197f154e1830cbcdf26314f2af3\";s:10:\"secret_key\";N;s:2:\"id\";s:5:\"10577\";s:7:\"updated\";s:19:\"2024-08-14 14:47:40\";s:7:\"created\";s:19:\"2022-06-27 13:19:35\";s:22:\"\0FS_Entity\0_is_updated\";b:0;}i:7;O:9:\"FS_Plugin\":23:{s:16:\"parent_plugin_id\";s:5:\"10330\";s:5:\"title\";s:15:\"Spice Instagram\";s:4:\"slug\";s:15:\"spice-instagram\";s:12:\"premium_slug\";s:15:\"spice-instagram\";s:4:\"type\";s:6:\"plugin\";s:20:\"affiliate_moderation\";N;s:19:\"is_wp_org_compliant\";b:0;s:22:\"premium_releases_count\";i:2;s:4:\"file\";N;s:7:\"version\";N;s:11:\"auto_update\";N;s:4:\"info\";O:14:\"FS_Plugin_Info\":13:{s:9:\"plugin_id\";s:5:\"10578\";s:11:\"description\";s:350:\"<h2>About Spice Instagram</h2><p>Display your instagram feeds with multiple customization options.</p>><ul><li>Display your instagram feeds</li><li>Change the caption</li><li>Set image overlay opacity</li><li>Show instagram photos in different column layout</li><li>Show number posts photos like 4, 8, etc.</li><li>Change color & typography</li></ul>\";s:17:\"short_description\";s:65:\"Display your instagram feeds with multiple customization options.\";s:10:\"banner_url\";s:68:\"https://s3-us-west-2.amazonaws.com/freemius/plugins/10578/banner.jpg\";s:15:\"card_banner_url\";s:73:\"https://s3-us-west-2.amazonaws.com/freemius/plugins/10578/card_banner.jpg\";s:15:\"selling_point_0\";s:29:\"Display your instagram feeds.\";s:15:\"selling_point_1\";s:49:\"Show instagram photos in different column layout.\";s:15:\"selling_point_2\";s:25:\"Change color & typography\";s:11:\"screenshots\";O:8:\"stdClass\":2:{s:12:\"screenshot_0\";s:75:\"https://s3-us-west-2.amazonaws.com/freemius/plugins/10578/screenshots/0.png\";s:12:\"screenshot_1\";s:75:\"https://s3-us-west-2.amazonaws.com/freemius/plugins/10578/screenshots/1.png\";}s:2:\"id\";s:4:\"2884\";s:7:\"updated\";s:19:\"2022-06-28 15:17:38\";s:7:\"created\";s:19:\"2022-06-28 09:04:56\";s:22:\"\0FS_Entity\0_is_updated\";b:0;}s:10:\"is_premium\";b:0;s:14:\"premium_suffix\";s:9:\"(Premium)\";s:7:\"is_live\";b:1;s:9:\"bundle_id\";N;s:17:\"bundle_public_key\";N;s:10:\"public_key\";s:32:\"pk_f35f3c631a98c50b3202ddfaff702\";s:10:\"secret_key\";N;s:2:\"id\";s:5:\"10578\";s:7:\"updated\";s:19:\"2024-08-14 14:42:53\";s:7:\"created\";s:19:\"2022-06-27 13:20:35\";s:22:\"\0FS_Entity\0_is_updated\";b:0;}i:8;O:9:\"FS_Plugin\":23:{s:16:\"parent_plugin_id\";s:5:\"10330\";s:5:\"title\";s:17:\"Spice Popup Login\";s:4:\"slug\";s:17:\"spice-popup-login\";s:12:\"premium_slug\";s:17:\"spice-popup-login\";s:4:\"type\";s:6:\"plugin\";s:20:\"affiliate_moderation\";N;s:19:\"is_wp_org_compliant\";b:0;s:22:\"premium_releases_count\";i:3;s:4:\"file\";N;s:7:\"version\";N;s:11:\"auto_update\";N;s:4:\"info\";O:14:\"FS_Plugin_Info\":13:{s:9:\"plugin_id\";s:5:\"10579\";s:11:\"description\";s:374:\"<h2>About Popup Login/h2><p>This plugin offers popup forms for login, register and lost password utilities from where you want it to popup.</p><ul><li>Add the login / register link in the menu.</li><li>Change the content of the login / register form.</li><li>Forget the password using WordPress utility.</li><li>Change the color & typography of login/register form</li></ul>\";s:17:\"short_description\";s:52:\"This plugin to add the popup login or register form.\";s:10:\"banner_url\";s:68:\"https://s3-us-west-2.amazonaws.com/freemius/plugins/10579/banner.jpg\";s:15:\"card_banner_url\";s:73:\"https://s3-us-west-2.amazonaws.com/freemius/plugins/10579/card_banner.jpg\";s:15:\"selling_point_0\";s:42:\"Add the login / register link in the menu.\";s:15:\"selling_point_1\";s:48:\"Change the content of the login / register form.\";s:15:\"selling_point_2\";s:44:\"Forget the password using WordPress utility.\";s:11:\"screenshots\";O:8:\"stdClass\":4:{s:12:\"screenshot_0\";s:75:\"https://s3-us-west-2.amazonaws.com/freemius/plugins/10579/screenshots/0.png\";s:12:\"screenshot_1\";s:75:\"https://s3-us-west-2.amazonaws.com/freemius/plugins/10579/screenshots/1.png\";s:12:\"screenshot_2\";s:75:\"https://s3-us-west-2.amazonaws.com/freemius/plugins/10579/screenshots/2.png\";s:12:\"screenshot_3\";s:75:\"https://s3-us-west-2.amazonaws.com/freemius/plugins/10579/screenshots/3.png\";}s:2:\"id\";s:4:\"2885\";s:7:\"updated\";s:19:\"2022-06-28 15:20:12\";s:7:\"created\";s:19:\"2022-06-28 09:06:07\";s:22:\"\0FS_Entity\0_is_updated\";b:0;}s:10:\"is_premium\";b:0;s:14:\"premium_suffix\";s:9:\"(Premium)\";s:7:\"is_live\";b:1;s:9:\"bundle_id\";N;s:17:\"bundle_public_key\";N;s:10:\"public_key\";s:32:\"pk_9921cccbf237a475d17add6d50b32\";s:10:\"secret_key\";N;s:2:\"id\";s:5:\"10579\";s:7:\"updated\";s:19:\"2024-08-14 14:45:37\";s:7:\"created\";s:19:\"2022-06-27 13:21:24\";s:22:\"\0FS_Entity\0_is_updated\";b:0;}i:9;O:9:\"FS_Plugin\":23:{s:16:\"parent_plugin_id\";s:5:\"10330\";s:5:\"title\";s:17:\"Spice Adobe Fonts\";s:4:\"slug\";s:17:\"spice-adobe-fonts\";s:12:\"premium_slug\";s:17:\"spice-adobe-fonts\";s:4:\"type\";s:6:\"plugin\";s:20:\"affiliate_moderation\";N;s:19:\"is_wp_org_compliant\";b:0;s:22:\"premium_releases_count\";i:2;s:4:\"file\";N;s:7:\"version\";N;s:11:\"auto_update\";N;s:4:\"info\";O:14:\"FS_Plugin_Info\":13:{s:9:\"plugin_id\";s:5:\"10592\";s:11:\"description\";s:232:\"<h2>About Adobe Fonts</h2><p>Add your favorite font collections on your website with the help of the Adobe Fonts Integration.</p><ul><li>Add adobe font collections</li><li>Easily integrate adobe fonts by adding  project ID</li></ul>\";s:17:\"short_description\";s:51:\"Add your favorite font collections on your website.\";s:10:\"banner_url\";s:68:\"https://s3-us-west-2.amazonaws.com/freemius/plugins/10592/banner.jpg\";s:15:\"card_banner_url\";s:73:\"https://s3-us-west-2.amazonaws.com/freemius/plugins/10592/card_banner.jpg\";s:15:\"selling_point_0\";s:26:\"Add adobe font collections\";s:15:\"selling_point_1\";s:32:\"Easily integrate with project ID\";s:15:\"selling_point_2\";s:102:\"Once you specify project ID , specified fonts collection will be added in all the typography settings.\";s:11:\"screenshots\";O:8:\"stdClass\":2:{s:12:\"screenshot_0\";s:75:\"https://s3-us-west-2.amazonaws.com/freemius/plugins/10592/screenshots/0.png\";s:12:\"screenshot_1\";s:75:\"https://s3-us-west-2.amazonaws.com/freemius/plugins/10592/screenshots/1.png\";}s:2:\"id\";s:4:\"2900\";s:7:\"updated\";s:19:\"2022-07-05 11:32:23\";s:7:\"created\";s:19:\"2022-06-30 14:22:16\";s:22:\"\0FS_Entity\0_is_updated\";b:0;}s:10:\"is_premium\";b:0;s:14:\"premium_suffix\";s:9:\"(Premium)\";s:7:\"is_live\";b:1;s:9:\"bundle_id\";N;s:17:\"bundle_public_key\";N;s:10:\"public_key\";s:32:\"pk_1ca4b6b65349ceffd5aab5eb0e287\";s:10:\"secret_key\";N;s:2:\"id\";s:5:\"10592\";s:7:\"updated\";s:19:\"2023-10-22 07:49:53\";s:7:\"created\";s:19:\"2022-06-28 15:39:48\";s:22:\"\0FS_Entity\0_is_updated\";b:0;}i:10;O:9:\"FS_Plugin\":23:{s:16:\"parent_plugin_id\";s:5:\"10330\";s:5:\"title\";s:12:\"OliveWP Plus\";s:4:\"slug\";s:12:\"olivewp-plus\";s:12:\"premium_slug\";s:12:\"olivewp-plus\";s:4:\"type\";s:6:\"plugin\";s:20:\"affiliate_moderation\";N;s:19:\"is_wp_org_compliant\";b:0;s:22:\"premium_releases_count\";i:3;s:4:\"file\";N;s:7:\"version\";N;s:11:\"auto_update\";N;s:4:\"info\";O:14:\"FS_Plugin_Info\":13:{s:9:\"plugin_id\";s:5:\"10605\";s:11:\"description\";s:470:\"<h2>About OliveWP Plus</h2><p>Add useful features like - preloader layouts, header presets, footer widgets & footer bar layouts, search effects, post navigation style, and many more.</p><h2>More Features</h2><ul><li>Choose among multiple header variations.</li><li>Select desired effect from multiple search effects</li><li>Manage post styles options like Background color, margin padding and border.</li><li>Adjust banner section padding.</li><li>Many more...</li></ul>\";s:17:\"short_description\";s:77:\"This add-on super charges OliveWP theme by adding many useful features to it.\";s:10:\"banner_url\";s:68:\"https://s3-us-west-2.amazonaws.com/freemius/plugins/10605/banner.jpg\";s:15:\"card_banner_url\";s:73:\"https://s3-us-west-2.amazonaws.com/freemius/plugins/10605/card_banner.jpg\";s:15:\"selling_point_0\";s:36:\"Beautifully designed blog templates.\";s:15:\"selling_point_1\";s:29:\"Typography and color features\";s:15:\"selling_point_2\";s:25:\"Grid and masonry layouts.\";s:11:\"screenshots\";O:8:\"stdClass\":3:{s:12:\"screenshot_0\";s:75:\"https://s3-us-west-2.amazonaws.com/freemius/plugins/10605/screenshots/0.png\";s:12:\"screenshot_1\";s:75:\"https://s3-us-west-2.amazonaws.com/freemius/plugins/10605/screenshots/1.png\";s:12:\"screenshot_2\";s:75:\"https://s3-us-west-2.amazonaws.com/freemius/plugins/10605/screenshots/2.png\";}s:2:\"id\";s:4:\"2901\";s:7:\"updated\";s:19:\"2022-07-05 11:57:56\";s:7:\"created\";s:19:\"2022-07-01 06:15:36\";s:22:\"\0FS_Entity\0_is_updated\";b:0;}s:10:\"is_premium\";b:0;s:14:\"premium_suffix\";s:9:\"(Premium)\";s:7:\"is_live\";b:1;s:9:\"bundle_id\";N;s:17:\"bundle_public_key\";N;s:10:\"public_key\";s:32:\"pk_7c81273c35f58df9dc63736356468\";s:10:\"secret_key\";N;s:2:\"id\";s:5:\"10605\";s:7:\"updated\";s:19:\"2023-10-22 07:48:05\";s:7:\"created\";s:19:\"2022-06-30 15:50:11\";s:22:\"\0FS_Entity\0_is_updated\";b:0;}i:11;O:9:\"FS_Plugin\":23:{s:16:\"parent_plugin_id\";s:5:\"10330\";s:5:\"title\";s:24:\"Spice Starter Sites Plus\";s:4:\"slug\";s:24:\"spice-starter-sites-plus\";s:12:\"premium_slug\";s:24:\"spice-starter-sites-plus\";s:4:\"type\";s:6:\"plugin\";s:20:\"affiliate_moderation\";N;s:19:\"is_wp_org_compliant\";b:0;s:22:\"premium_releases_count\";i:5;s:4:\"file\";N;s:7:\"version\";N;s:11:\"auto_update\";N;s:4:\"info\";O:14:\"FS_Plugin_Info\":13:{s:9:\"plugin_id\";s:5:\"10626\";s:11:\"description\";s:165:\"<p>Already having starter site for every niche and constantly developing new desings every month. You just need to import and get exact replica of our demo site.</p>\";s:17:\"short_description\";s:58:\"This add-on helps you to add read to import starter sites.\";s:10:\"banner_url\";s:68:\"https://s3-us-west-2.amazonaws.com/freemius/plugins/10626/banner.jpg\";s:15:\"card_banner_url\";s:73:\"https://s3-us-west-2.amazonaws.com/freemius/plugins/10626/card_banner.jpg\";s:15:\"selling_point_0\";s:71:\"You just a click away to start importing ready to import starter sites.\";s:15:\"selling_point_1\";s:78:\"Browse all starter sites <a href=\"https://olivewp.org/starter-sites/\">here</a>\";s:15:\"selling_point_2\";N;s:11:\"screenshots\";N;s:2:\"id\";s:4:\"2905\";s:7:\"updated\";s:19:\"2022-07-05 12:36:38\";s:7:\"created\";s:19:\"2022-07-05 12:14:46\";s:22:\"\0FS_Entity\0_is_updated\";b:0;}s:10:\"is_premium\";b:0;s:14:\"premium_suffix\";s:9:\"(Premium)\";s:7:\"is_live\";b:1;s:9:\"bundle_id\";N;s:17:\"bundle_public_key\";N;s:10:\"public_key\";s:32:\"pk_90c30f60d64aaa76bc5407af43c7b\";s:10:\"secret_key\";N;s:2:\"id\";s:5:\"10626\";s:7:\"updated\";s:19:\"2023-10-20 08:28:49\";s:7:\"created\";s:19:\"2022-07-05 11:19:04\";s:22:\"\0FS_Entity\0_is_updated\";b:0;}}}}", "yes");
INSERT INTO `wp_options` VALUES("206", "fs_gdpr", "a:1:{s:2:\"u1\";a:1:{s:8:\"required\";b:0;}}", "yes");
INSERT INTO `wp_options` VALUES("208", "fs_api_cache", "a:2:{s:56:\"get:/v1/plugins/10330/addons.json?enriched=true&count=50\";O:8:\"stdClass\":3:{s:6:\"result\";O:8:\"stdClass\":1:{s:7:\"plugins\";a:12:{i:0;O:8:\"stdClass\":34:{s:16:\"parent_plugin_id\";s:5:\"10330\";s:12:\"developer_id\";s:5:\"11810\";s:8:\"store_id\";s:4:\"3780\";s:10:\"install_id\";s:7:\"9841986\";s:4:\"slug\";s:18:\"spice-social-share\";s:5:\"title\";s:18:\"Spice Social Share\";s:11:\"environment\";i:0;s:4:\"icon\";s:48:\"//img.freemius.com/plugin-icon-blue-noshadow.png\";s:15:\"default_plan_id\";s:5:\"17882\";s:5:\"plans\";i:17882;s:8:\"features\";N;s:17:\"money_back_period\";N;s:13:\"refund_policy\";N;s:24:\"annual_renewals_discount\";N;s:22:\"renewals_discount_type\";s:10:\"percentage\";s:11:\"is_released\";b:1;s:15:\"is_sdk_required\";b:1;s:18:\"is_pricing_visible\";b:0;s:19:\"is_wp_org_compliant\";b:1;s:6:\"is_off\";b:0;s:24:\"is_only_for_new_installs\";b:0;s:14:\"installs_limit\";N;s:19:\"free_releases_count\";i:0;s:22:\"premium_releases_count\";i:0;s:17:\"accepted_payments\";i:0;s:7:\"plan_id\";s:1:\"0\";s:4:\"type\";s:6:\"plugin\";s:9:\"is_static\";b:0;s:10:\"public_key\";s:32:\"pk_8f3da04d32b1612b775baef8bd2af\";s:2:\"id\";s:5:\"10571\";s:7:\"created\";s:19:\"2022-06-27 12:53:03\";s:7:\"updated\";s:19:\"2022-06-27 13:05:31\";s:4:\"info\";O:8:\"stdClass\":13:{s:9:\"plugin_id\";s:5:\"10571\";s:3:\"url\";N;s:11:\"description\";s:331:\"<h2>About Social Share</h2><p>This plugin allows you to add the social icons on the single posts.</p><ul><li>Add social icons on the posts.</li><li>Change the position of the heading</li><li>Change the colors of the heading and icons.</li><li>Share the posts on social media.</li><li>Change the typography of the heading.</li></ul>\";s:17:\"short_description\";s:67:\"Add the social icons on the single posts like Facebook and Twitter.\";s:10:\"banner_url\";s:68:\"https://s3-us-west-2.amazonaws.com/freemius/plugins/10571/banner.jpg\";s:15:\"card_banner_url\";s:73:\"https://s3-us-west-2.amazonaws.com/freemius/plugins/10571/card_banner.jpg\";s:15:\"selling_point_0\";s:30:\"Add social icons on the posts.\";s:15:\"selling_point_1\";s:42:\"Change the colors of the heading and icons\";s:15:\"selling_point_2\";s:35:\"Change the position of the heading.\";s:11:\"screenshots\";O:8:\"stdClass\":2:{s:12:\"screenshot_0\";s:75:\"https://s3-us-west-2.amazonaws.com/freemius/plugins/10571/screenshots/0.png\";s:12:\"screenshot_1\";s:75:\"https://s3-us-west-2.amazonaws.com/freemius/plugins/10571/screenshots/1.png\";}s:2:\"id\";s:4:\"2880\";s:7:\"created\";s:19:\"2022-06-27 13:05:31\";s:7:\"updated\";s:19:\"2022-06-28 15:28:47\";}s:12:\"premium_slug\";s:26:\"spice-social-share-premium\";}i:1;O:8:\"stdClass\":34:{s:16:\"parent_plugin_id\";s:5:\"10330\";s:12:\"developer_id\";s:5:\"11810\";s:8:\"store_id\";s:4:\"3780\";s:10:\"install_id\";s:7:\"9842145\";s:4:\"slug\";s:15:\"spice-portfolio\";s:5:\"title\";s:15:\"Spice Portfolio\";s:11:\"environment\";i:0;s:4:\"icon\";s:48:\"//img.freemius.com/plugin-icon-blue-noshadow.png\";s:15:\"default_plan_id\";s:5:\"17884\";s:5:\"plans\";i:17884;s:8:\"features\";N;s:17:\"money_back_period\";N;s:13:\"refund_policy\";N;s:24:\"annual_renewals_discount\";N;s:22:\"renewals_discount_type\";s:10:\"percentage\";s:11:\"is_released\";b:1;s:15:\"is_sdk_required\";b:1;s:18:\"is_pricing_visible\";b:1;s:19:\"is_wp_org_compliant\";b:0;s:6:\"is_off\";b:0;s:24:\"is_only_for_new_installs\";b:0;s:14:\"installs_limit\";N;s:19:\"free_releases_count\";i:0;s:22:\"premium_releases_count\";i:3;s:17:\"accepted_payments\";i:0;s:7:\"plan_id\";s:1:\"0\";s:4:\"type\";s:6:\"plugin\";s:9:\"is_static\";b:0;s:10:\"public_key\";s:32:\"pk_0381788ca1e2cd246fd2f8921eb93\";s:2:\"id\";s:5:\"10572\";s:7:\"created\";s:19:\"2022-06-27 13:13:55\";s:7:\"updated\";s:19:\"2023-08-15 01:10:36\";s:4:\"info\";O:8:\"stdClass\":13:{s:9:\"plugin_id\";s:5:\"10572\";s:3:\"url\";N;s:11:\"description\";s:374:\"<p>This plugin allows you to showcase your projects in a beautiful portfolio with multiple options.</p><ul><li>Choose number of columns</li><li>Enable/Disable project title and category</li><li>Sort the order in ascending and descending order</li><li>Enable/Disable filter bar</li><li>Change the colors of the content</li><li>Display items by categories and author</li></ul>\";s:17:\"short_description\";s:67:\"Showcase the portfolio anywhere on your website in a beautiful way.\";s:10:\"banner_url\";s:68:\"https://s3-us-west-2.amazonaws.com/freemius/plugins/10572/banner.jpg\";s:15:\"card_banner_url\";s:73:\"https://s3-us-west-2.amazonaws.com/freemius/plugins/10572/card_banner.jpg\";s:15:\"selling_point_0\";s:59:\"Display the portfolio anywhere you want by using shortcode.\";s:15:\"selling_point_1\";s:39:\"Enter the number of projects to display\";s:15:\"selling_point_2\";s:68:\"Change the typography of the content. More features mentioned below.\";s:11:\"screenshots\";O:8:\"stdClass\":2:{s:12:\"screenshot_0\";s:75:\"https://s3-us-west-2.amazonaws.com/freemius/plugins/10572/screenshots/0.png\";s:12:\"screenshot_1\";s:75:\"https://s3-us-west-2.amazonaws.com/freemius/plugins/10572/screenshots/1.png\";}s:2:\"id\";s:4:\"2886\";s:7:\"created\";s:19:\"2022-06-28 09:07:30\";s:7:\"updated\";s:19:\"2022-06-28 14:50:29\";}s:12:\"premium_slug\";s:15:\"spice-portfolio\";}i:2;O:8:\"stdClass\":34:{s:16:\"parent_plugin_id\";s:5:\"10330\";s:12:\"developer_id\";s:5:\"11810\";s:8:\"store_id\";s:4:\"3780\";s:10:\"install_id\";s:7:\"9842157\";s:4:\"slug\";s:17:\"spice-white-label\";s:5:\"title\";s:17:\"Spice White Label\";s:11:\"environment\";i:0;s:4:\"icon\";s:48:\"//img.freemius.com/plugin-icon-blue-noshadow.png\";s:15:\"default_plan_id\";s:5:\"17886\";s:5:\"plans\";i:17886;s:8:\"features\";N;s:17:\"money_back_period\";N;s:13:\"refund_policy\";N;s:24:\"annual_renewals_discount\";N;s:22:\"renewals_discount_type\";s:10:\"percentage\";s:11:\"is_released\";b:1;s:15:\"is_sdk_required\";b:1;s:18:\"is_pricing_visible\";b:1;s:19:\"is_wp_org_compliant\";b:0;s:6:\"is_off\";b:0;s:24:\"is_only_for_new_installs\";b:0;s:14:\"installs_limit\";N;s:19:\"free_releases_count\";i:0;s:22:\"premium_releases_count\";i:2;s:17:\"accepted_payments\";i:0;s:7:\"plan_id\";s:1:\"0\";s:4:\"type\";s:6:\"plugin\";s:9:\"is_static\";b:0;s:10:\"public_key\";s:32:\"pk_6a6aa7643a2adc4d19e6d1eb1f2a3\";s:2:\"id\";s:5:\"10573\";s:7:\"created\";s:19:\"2022-06-27 13:15:50\";s:7:\"updated\";s:19:\"2023-10-13 14:38:44\";s:4:\"info\";O:8:\"stdClass\":13:{s:9:\"plugin_id\";s:5:\"10573\";s:3:\"url\";N;s:11:\"description\";s:409:\"<h2>About White Label</h2><p>This plugin allows you to replace the theme details like name, description, author name, etc by your own brand name.</p><ul><li>Hide the theme section in customizer.</li><li>Change the theme description.</li><li>Change the theme author name.</li><li>Change the theme screenshot.</li><li>Change the theme author URL.</li><li>Replace the theme name by your own brand name.</li></ul>\";s:17:\"short_description\";s:75:\"The clients can change the theme details like name by their own brand name.\";s:10:\"banner_url\";s:68:\"https://s3-us-west-2.amazonaws.com/freemius/plugins/10573/banner.jpg\";s:15:\"card_banner_url\";s:73:\"https://s3-us-west-2.amazonaws.com/freemius/plugins/10573/card_banner.jpg\";s:15:\"selling_point_0\";s:46:\"Replace the theme name by your own brand name.\";s:15:\"selling_point_1\";s:28:\"Change the theme author URL.\";s:15:\"selling_point_2\";s:29:\"Change the theme author name.\";s:11:\"screenshots\";O:8:\"stdClass\":1:{s:12:\"screenshot_0\";s:75:\"https://s3-us-west-2.amazonaws.com/freemius/plugins/10573/screenshots/0.png\";}s:2:\"id\";s:4:\"2890\";s:7:\"created\";s:19:\"2022-06-28 09:12:58\";s:7:\"updated\";s:19:\"2022-06-28 15:39:05\";}s:12:\"premium_slug\";s:17:\"spice-white-label\";}i:3;O:8:\"stdClass\":34:{s:16:\"parent_plugin_id\";s:5:\"10330\";s:12:\"developer_id\";s:5:\"11810\";s:8:\"store_id\";s:4:\"3780\";s:10:\"install_id\";s:7:\"9842164\";s:4:\"slug\";s:13:\"spice-cookies\";s:5:\"title\";s:13:\"Spice Cookies\";s:11:\"environment\";i:0;s:4:\"icon\";s:48:\"//img.freemius.com/plugin-icon-blue-noshadow.png\";s:15:\"default_plan_id\";s:5:\"17888\";s:5:\"plans\";i:17888;s:8:\"features\";N;s:17:\"money_back_period\";N;s:13:\"refund_policy\";N;s:24:\"annual_renewals_discount\";N;s:22:\"renewals_discount_type\";s:10:\"percentage\";s:11:\"is_released\";b:1;s:15:\"is_sdk_required\";b:1;s:18:\"is_pricing_visible\";b:1;s:19:\"is_wp_org_compliant\";b:0;s:6:\"is_off\";b:0;s:24:\"is_only_for_new_installs\";b:0;s:14:\"installs_limit\";N;s:19:\"free_releases_count\";i:0;s:22:\"premium_releases_count\";i:1;s:17:\"accepted_payments\";i:0;s:7:\"plan_id\";s:1:\"0\";s:4:\"type\";s:6:\"plugin\";s:9:\"is_static\";b:0;s:10:\"public_key\";s:32:\"pk_bd8fd588af45f7d46543f8a297c04\";s:2:\"id\";s:5:\"10574\";s:7:\"created\";s:19:\"2022-06-27 13:16:47\";s:7:\"updated\";s:19:\"2023-02-18 16:18:36\";s:4:\"info\";O:8:\"stdClass\":13:{s:9:\"plugin_id\";s:5:\"10574\";s:3:\"url\";N;s:11:\"description\";s:332:\"<h2>About Cookies</h2><p>This plugin allows you to show the cookie notice in your website and inform users that the site uses cookies.</p><ul><li>Enter your own content</li><li>Enter the cookie expire time</li><li>Change the colors of the content</li><li>Enter your button text</li><li>Change the typography of the content</li></ul>\";s:17:\"short_description\";s:65:\"Display the cookie notice in your website with the accept button.\";s:10:\"banner_url\";s:68:\"https://s3-us-west-2.amazonaws.com/freemius/plugins/10574/banner.jpg\";s:15:\"card_banner_url\";s:73:\"https://s3-us-west-2.amazonaws.com/freemius/plugins/10574/card_banner.jpg\";s:15:\"selling_point_0\";s:29:\"Enter the cookie expire time.\";s:15:\"selling_point_1\";s:33:\"Change the colors of the content.\";s:15:\"selling_point_2\";s:37:\"Change the typography of the content.\";s:11:\"screenshots\";O:8:\"stdClass\":2:{s:12:\"screenshot_0\";s:75:\"https://s3-us-west-2.amazonaws.com/freemius/plugins/10574/screenshots/0.png\";s:12:\"screenshot_1\";s:75:\"https://s3-us-west-2.amazonaws.com/freemius/plugins/10574/screenshots/1.png\";}s:2:\"id\";s:4:\"2883\";s:7:\"created\";s:19:\"2022-06-28 08:57:53\";s:7:\"updated\";s:19:\"2022-06-28 15:07:22\";}s:12:\"premium_slug\";s:13:\"spice-cookies\";}i:4;O:8:\"stdClass\":34:{s:16:\"parent_plugin_id\";s:5:\"10330\";s:12:\"developer_id\";s:5:\"11810\";s:8:\"store_id\";s:4:\"3780\";s:10:\"install_id\";s:7:\"9842170\";s:4:\"slug\";s:19:\"spice-sticky-footer\";s:5:\"title\";s:19:\"Spice Sticky Footer\";s:11:\"environment\";i:0;s:4:\"icon\";s:48:\"//img.freemius.com/plugin-icon-blue-noshadow.png\";s:15:\"default_plan_id\";s:5:\"17890\";s:5:\"plans\";i:17890;s:8:\"features\";N;s:17:\"money_back_period\";N;s:13:\"refund_policy\";N;s:24:\"annual_renewals_discount\";N;s:22:\"renewals_discount_type\";s:10:\"percentage\";s:11:\"is_released\";b:1;s:15:\"is_sdk_required\";b:1;s:18:\"is_pricing_visible\";b:1;s:19:\"is_wp_org_compliant\";b:0;s:6:\"is_off\";b:0;s:24:\"is_only_for_new_installs\";b:0;s:14:\"installs_limit\";N;s:19:\"free_releases_count\";i:0;s:22:\"premium_releases_count\";i:1;s:17:\"accepted_payments\";i:0;s:7:\"plan_id\";s:1:\"0\";s:4:\"type\";s:6:\"plugin\";s:9:\"is_static\";b:0;s:10:\"public_key\";s:32:\"pk_685ef2986180072080d00dc761a43\";s:2:\"id\";s:5:\"10575\";s:7:\"created\";s:19:\"2022-06-27 13:17:29\";s:7:\"updated\";s:19:\"2023-10-13 14:40:02\";s:4:\"info\";O:8:\"stdClass\":13:{s:9:\"plugin_id\";s:5:\"10575\";s:3:\"url\";N;s:11:\"description\";s:372:\"<h2>About Sticky Footer</h2><p>This plugin allows you to stick the footer at the bottom of the screen while scrolling the pages.</p><ul><li>Enter your custom text.</li><li>Set the footer opacity.</li><li>Change the typography of the content.</li><li>Change the icon of your choice.</li><li>Enable/Disable text on mobile.</li><li>Change the colors of the content.</li></ul>\";s:17:\"short_description\";s:60:\"Stick your footer to the bottom of the screen during scroll.\";s:10:\"banner_url\";s:68:\"https://s3-us-west-2.amazonaws.com/freemius/plugins/10575/banner.jpg\";s:15:\"card_banner_url\";s:73:\"https://s3-us-west-2.amazonaws.com/freemius/plugins/10575/card_banner.jpg\";s:15:\"selling_point_0\";s:30:\"Enable/Disable text on mobile.\";s:15:\"selling_point_1\";s:31:\"Change the icon of your choice.\";s:15:\"selling_point_2\";s:23:\"Set the footer opacity.\";s:11:\"screenshots\";O:8:\"stdClass\":4:{s:12:\"screenshot_0\";s:75:\"https://s3-us-west-2.amazonaws.com/freemius/plugins/10575/screenshots/0.png\";s:12:\"screenshot_1\";s:75:\"https://s3-us-west-2.amazonaws.com/freemius/plugins/10575/screenshots/1.png\";s:12:\"screenshot_2\";s:75:\"https://s3-us-west-2.amazonaws.com/freemius/plugins/10575/screenshots/2.png\";s:12:\"screenshot_3\";s:75:\"https://s3-us-west-2.amazonaws.com/freemius/plugins/10575/screenshots/3.png\";}s:2:\"id\";s:4:\"2882\";s:7:\"created\";s:19:\"2022-06-28 07:21:27\";s:7:\"updated\";s:19:\"2022-06-28 15:31:54\";}s:12:\"premium_slug\";s:19:\"spice-sticky-footer\";}i:5;O:8:\"stdClass\":34:{s:16:\"parent_plugin_id\";s:5:\"10330\";s:12:\"developer_id\";s:5:\"11810\";s:8:\"store_id\";s:4:\"3780\";s:10:\"install_id\";s:7:\"9842175\";s:4:\"slug\";s:19:\"spice-sticky-header\";s:5:\"title\";s:19:\"Spice Sticky Header\";s:11:\"environment\";i:0;s:4:\"icon\";s:48:\"//img.freemius.com/plugin-icon-blue-noshadow.png\";s:15:\"default_plan_id\";s:5:\"17892\";s:5:\"plans\";i:17892;s:8:\"features\";N;s:17:\"money_back_period\";N;s:13:\"refund_policy\";N;s:24:\"annual_renewals_discount\";N;s:22:\"renewals_discount_type\";s:10:\"percentage\";s:11:\"is_released\";b:1;s:15:\"is_sdk_required\";b:1;s:18:\"is_pricing_visible\";b:1;s:19:\"is_wp_org_compliant\";b:0;s:6:\"is_off\";b:0;s:24:\"is_only_for_new_installs\";b:0;s:14:\"installs_limit\";N;s:19:\"free_releases_count\";i:0;s:22:\"premium_releases_count\";i:1;s:17:\"accepted_payments\";i:0;s:7:\"plan_id\";s:1:\"0\";s:4:\"type\";s:6:\"plugin\";s:9:\"is_static\";b:0;s:10:\"public_key\";s:32:\"pk_4c4751fb21516e4900bdcdd17d01a\";s:2:\"id\";s:5:\"10576\";s:7:\"created\";s:19:\"2022-06-27 13:18:41\";s:7:\"updated\";s:19:\"2023-10-13 14:40:21\";s:4:\"info\";O:8:\"stdClass\":13:{s:9:\"plugin_id\";s:5:\"10576\";s:3:\"url\";N;s:11:\"description\";s:487:\"<h2>About Sticky Header</h2><p>This plugin allows you to stick the header at the top of the screen during scrolling the pages.</p><ul><li>Choose to enable on the desktop or mobile or both.</li><li>Choose animation effect like shrink.</li><li>Set the header height during scroll.</li><li>Change the colors of the content.</li><li>Set different logo for desktop and mobile during scroll.</li><li>Set the header opacity during scroll.</li><li>Change the typography of the content.</li></ul>\";s:17:\"short_description\";s:57:\"Stick your header on the top of the screen during scroll.\";s:10:\"banner_url\";s:68:\"https://s3-us-west-2.amazonaws.com/freemius/plugins/10576/banner.jpg\";s:15:\"card_banner_url\";s:73:\"https://s3-us-west-2.amazonaws.com/freemius/plugins/10576/card_banner.jpg\";s:15:\"selling_point_0\";s:35:\"Manage sticky header as per device.\";s:15:\"selling_point_1\";s:37:\"Set the header opacity during scroll.\";s:15:\"selling_point_2\";s:57:\"Add different logo for different devices while scrolling.\";s:11:\"screenshots\";O:8:\"stdClass\":2:{s:12:\"screenshot_0\";s:75:\"https://s3-us-west-2.amazonaws.com/freemius/plugins/10576/screenshots/0.png\";s:12:\"screenshot_1\";s:75:\"https://s3-us-west-2.amazonaws.com/freemius/plugins/10576/screenshots/1.png\";}s:2:\"id\";s:4:\"2889\";s:7:\"created\";s:19:\"2022-06-28 09:12:01\";s:7:\"updated\";s:19:\"2022-06-28 15:36:25\";}s:12:\"premium_slug\";s:19:\"spice-sticky-header\";}i:6;O:8:\"stdClass\":34:{s:16:\"parent_plugin_id\";s:5:\"10330\";s:12:\"developer_id\";s:5:\"11810\";s:8:\"store_id\";s:4:\"3780\";s:10:\"install_id\";s:7:\"9842181\";s:4:\"slug\";s:16:\"spice-side-panel\";s:5:\"title\";s:16:\"Spice Side Panel\";s:11:\"environment\";i:0;s:4:\"icon\";s:48:\"//img.freemius.com/plugin-icon-blue-noshadow.png\";s:15:\"default_plan_id\";s:5:\"17894\";s:5:\"plans\";i:17894;s:8:\"features\";N;s:17:\"money_back_period\";N;s:13:\"refund_policy\";N;s:24:\"annual_renewals_discount\";N;s:22:\"renewals_discount_type\";s:10:\"percentage\";s:11:\"is_released\";b:1;s:15:\"is_sdk_required\";b:1;s:18:\"is_pricing_visible\";b:1;s:19:\"is_wp_org_compliant\";b:0;s:6:\"is_off\";b:0;s:24:\"is_only_for_new_installs\";b:0;s:14:\"installs_limit\";N;s:19:\"free_releases_count\";i:0;s:22:\"premium_releases_count\";i:3;s:17:\"accepted_payments\";i:0;s:7:\"plan_id\";s:1:\"0\";s:4:\"type\";s:6:\"plugin\";s:9:\"is_static\";b:0;s:10:\"public_key\";s:32:\"pk_ff197f154e1830cbcdf26314f2af3\";s:2:\"id\";s:5:\"10577\";s:7:\"created\";s:19:\"2022-06-27 13:19:35\";s:7:\"updated\";s:19:\"2024-08-14 14:47:40\";s:4:\"info\";O:8:\"stdClass\":13:{s:9:\"plugin_id\";s:5:\"10577\";s:3:\"url\";N;s:11:\"description\";s:423:\"<h2>About Side Panel</h2><p>Add useful content in the side panel with the help of widgets. Plugin have many configuration settings to manage the Side Panel.</p><h2>More Features</h2><ul><li>Change the icon button position.</li><li>Change the side panel width.</li><li>Add your own typography & color.</li><li>Add text for closing button.</li><li>Add padding for side panel</li><li>Set overlay when panel is opened</li></ul>\";s:17:\"short_description\";s:62:\"Add useful content in the side panel with the help of widgets.\";s:10:\"banner_url\";s:68:\"https://s3-us-west-2.amazonaws.com/freemius/plugins/10577/banner.jpg\";s:15:\"card_banner_url\";s:73:\"https://s3-us-west-2.amazonaws.com/freemius/plugins/10577/card_banner.jpg\";s:15:\"selling_point_0\";s:33:\"Add widgets in side panel sidebar\";s:15:\"selling_point_1\";s:40:\"Set panel width according to screen size\";s:15:\"selling_point_2\";s:67:\"Dispaly panel on left and right side. More features mentioned below\";s:11:\"screenshots\";O:8:\"stdClass\":3:{s:12:\"screenshot_0\";s:75:\"https://s3-us-west-2.amazonaws.com/freemius/plugins/10577/screenshots/0.png\";s:12:\"screenshot_1\";s:75:\"https://s3-us-west-2.amazonaws.com/freemius/plugins/10577/screenshots/1.png\";s:12:\"screenshot_2\";s:75:\"https://s3-us-west-2.amazonaws.com/freemius/plugins/10577/screenshots/2.png\";}s:2:\"id\";s:4:\"2888\";s:7:\"created\";s:19:\"2022-06-28 09:09:51\";s:7:\"updated\";s:19:\"2022-06-28 15:26:32\";}s:12:\"premium_slug\";s:16:\"spice-side-panel\";}i:7;O:8:\"stdClass\":34:{s:16:\"parent_plugin_id\";s:5:\"10330\";s:12:\"developer_id\";s:5:\"11810\";s:8:\"store_id\";s:4:\"3780\";s:10:\"install_id\";s:7:\"9842200\";s:4:\"slug\";s:15:\"spice-instagram\";s:5:\"title\";s:15:\"Spice Instagram\";s:11:\"environment\";i:0;s:4:\"icon\";s:48:\"//img.freemius.com/plugin-icon-blue-noshadow.png\";s:15:\"default_plan_id\";s:5:\"17896\";s:5:\"plans\";i:17896;s:8:\"features\";N;s:17:\"money_back_period\";N;s:13:\"refund_policy\";N;s:24:\"annual_renewals_discount\";N;s:22:\"renewals_discount_type\";s:10:\"percentage\";s:11:\"is_released\";b:1;s:15:\"is_sdk_required\";b:1;s:18:\"is_pricing_visible\";b:1;s:19:\"is_wp_org_compliant\";b:0;s:6:\"is_off\";b:0;s:24:\"is_only_for_new_installs\";b:0;s:14:\"installs_limit\";N;s:19:\"free_releases_count\";i:0;s:22:\"premium_releases_count\";i:2;s:17:\"accepted_payments\";i:0;s:7:\"plan_id\";s:1:\"0\";s:4:\"type\";s:6:\"plugin\";s:9:\"is_static\";b:0;s:10:\"public_key\";s:32:\"pk_f35f3c631a98c50b3202ddfaff702\";s:2:\"id\";s:5:\"10578\";s:7:\"created\";s:19:\"2022-06-27 13:20:35\";s:7:\"updated\";s:19:\"2024-08-14 14:42:53\";s:4:\"info\";O:8:\"stdClass\":13:{s:9:\"plugin_id\";s:5:\"10578\";s:3:\"url\";N;s:11:\"description\";s:350:\"<h2>About Spice Instagram</h2><p>Display your instagram feeds with multiple customization options.</p>><ul><li>Display your instagram feeds</li><li>Change the caption</li><li>Set image overlay opacity</li><li>Show instagram photos in different column layout</li><li>Show number posts photos like 4, 8, etc.</li><li>Change color & typography</li></ul>\";s:17:\"short_description\";s:65:\"Display your instagram feeds with multiple customization options.\";s:10:\"banner_url\";s:68:\"https://s3-us-west-2.amazonaws.com/freemius/plugins/10578/banner.jpg\";s:15:\"card_banner_url\";s:73:\"https://s3-us-west-2.amazonaws.com/freemius/plugins/10578/card_banner.jpg\";s:15:\"selling_point_0\";s:29:\"Display your instagram feeds.\";s:15:\"selling_point_1\";s:49:\"Show instagram photos in different column layout.\";s:15:\"selling_point_2\";s:25:\"Change color & typography\";s:11:\"screenshots\";O:8:\"stdClass\":2:{s:12:\"screenshot_0\";s:75:\"https://s3-us-west-2.amazonaws.com/freemius/plugins/10578/screenshots/0.png\";s:12:\"screenshot_1\";s:75:\"https://s3-us-west-2.amazonaws.com/freemius/plugins/10578/screenshots/1.png\";}s:2:\"id\";s:4:\"2884\";s:7:\"created\";s:19:\"2022-06-28 09:04:56\";s:7:\"updated\";s:19:\"2022-06-28 15:17:38\";}s:12:\"premium_slug\";s:15:\"spice-instagram\";}i:8;O:8:\"stdClass\":34:{s:16:\"parent_plugin_id\";s:5:\"10330\";s:12:\"developer_id\";s:5:\"11810\";s:8:\"store_id\";s:4:\"3780\";s:10:\"install_id\";s:7:\"9842211\";s:4:\"slug\";s:17:\"spice-popup-login\";s:5:\"title\";s:17:\"Spice Popup Login\";s:11:\"environment\";i:0;s:4:\"icon\";s:48:\"//img.freemius.com/plugin-icon-blue-noshadow.png\";s:15:\"default_plan_id\";s:5:\"17898\";s:5:\"plans\";i:17898;s:8:\"features\";N;s:17:\"money_back_period\";N;s:13:\"refund_policy\";N;s:24:\"annual_renewals_discount\";N;s:22:\"renewals_discount_type\";s:10:\"percentage\";s:11:\"is_released\";b:1;s:15:\"is_sdk_required\";b:1;s:18:\"is_pricing_visible\";b:1;s:19:\"is_wp_org_compliant\";b:0;s:6:\"is_off\";b:0;s:24:\"is_only_for_new_installs\";b:0;s:14:\"installs_limit\";N;s:19:\"free_releases_count\";i:0;s:22:\"premium_releases_count\";i:3;s:17:\"accepted_payments\";i:0;s:7:\"plan_id\";s:1:\"0\";s:4:\"type\";s:6:\"plugin\";s:9:\"is_static\";b:0;s:10:\"public_key\";s:32:\"pk_9921cccbf237a475d17add6d50b32\";s:2:\"id\";s:5:\"10579\";s:7:\"created\";s:19:\"2022-06-27 13:21:24\";s:7:\"updated\";s:19:\"2024-08-14 14:45:37\";s:4:\"info\";O:8:\"stdClass\":13:{s:9:\"plugin_id\";s:5:\"10579\";s:3:\"url\";N;s:11:\"description\";s:374:\"<h2>About Popup Login/h2><p>This plugin offers popup forms for login, register and lost password utilities from where you want it to popup.</p><ul><li>Add the login / register link in the menu.</li><li>Change the content of the login / register form.</li><li>Forget the password using WordPress utility.</li><li>Change the color & typography of login/register form</li></ul>\";s:17:\"short_description\";s:52:\"This plugin to add the popup login or register form.\";s:10:\"banner_url\";s:68:\"https://s3-us-west-2.amazonaws.com/freemius/plugins/10579/banner.jpg\";s:15:\"card_banner_url\";s:73:\"https://s3-us-west-2.amazonaws.com/freemius/plugins/10579/card_banner.jpg\";s:15:\"selling_point_0\";s:42:\"Add the login / register link in the menu.\";s:15:\"selling_point_1\";s:48:\"Change the content of the login / register form.\";s:15:\"selling_point_2\";s:44:\"Forget the password using WordPress utility.\";s:11:\"screenshots\";O:8:\"stdClass\":4:{s:12:\"screenshot_0\";s:75:\"https://s3-us-west-2.amazonaws.com/freemius/plugins/10579/screenshots/0.png\";s:12:\"screenshot_1\";s:75:\"https://s3-us-west-2.amazonaws.com/freemius/plugins/10579/screenshots/1.png\";s:12:\"screenshot_2\";s:75:\"https://s3-us-west-2.amazonaws.com/freemius/plugins/10579/screenshots/2.png\";s:12:\"screenshot_3\";s:75:\"https://s3-us-west-2.amazonaws.com/freemius/plugins/10579/screenshots/3.png\";}s:2:\"id\";s:4:\"2885\";s:7:\"created\";s:19:\"2022-06-28 09:06:07\";s:7:\"updated\";s:19:\"2022-06-28 15:20:12\";}s:12:\"premium_slug\";s:17:\"spice-popup-login\";}i:9;O:8:\"stdClass\":34:{s:16:\"parent_plugin_id\";s:5:\"10330\";s:12:\"developer_id\";s:5:\"11810\";s:8:\"store_id\";s:4:\"3780\";s:10:\"install_id\";s:7:\"9849811\";s:4:\"slug\";s:17:\"spice-adobe-fonts\";s:5:\"title\";s:17:\"Spice Adobe Fonts\";s:11:\"environment\";i:0;s:4:\"icon\";s:48:\"//img.freemius.com/plugin-icon-blue-noshadow.png\";s:15:\"default_plan_id\";s:5:\"17928\";s:5:\"plans\";i:17928;s:8:\"features\";N;s:17:\"money_back_period\";N;s:13:\"refund_policy\";N;s:24:\"annual_renewals_discount\";N;s:22:\"renewals_discount_type\";s:10:\"percentage\";s:11:\"is_released\";b:1;s:15:\"is_sdk_required\";b:1;s:18:\"is_pricing_visible\";b:1;s:19:\"is_wp_org_compliant\";b:0;s:6:\"is_off\";b:0;s:24:\"is_only_for_new_installs\";b:0;s:14:\"installs_limit\";N;s:19:\"free_releases_count\";i:0;s:22:\"premium_releases_count\";i:2;s:17:\"accepted_payments\";i:0;s:7:\"plan_id\";s:1:\"0\";s:4:\"type\";s:6:\"plugin\";s:9:\"is_static\";b:0;s:10:\"public_key\";s:32:\"pk_1ca4b6b65349ceffd5aab5eb0e287\";s:2:\"id\";s:5:\"10592\";s:7:\"created\";s:19:\"2022-06-28 15:39:48\";s:7:\"updated\";s:19:\"2023-10-22 07:49:53\";s:4:\"info\";O:8:\"stdClass\":13:{s:9:\"plugin_id\";s:5:\"10592\";s:3:\"url\";N;s:11:\"description\";s:232:\"<h2>About Adobe Fonts</h2><p>Add your favorite font collections on your website with the help of the Adobe Fonts Integration.</p><ul><li>Add adobe font collections</li><li>Easily integrate adobe fonts by adding  project ID</li></ul>\";s:17:\"short_description\";s:51:\"Add your favorite font collections on your website.\";s:10:\"banner_url\";s:68:\"https://s3-us-west-2.amazonaws.com/freemius/plugins/10592/banner.jpg\";s:15:\"card_banner_url\";s:73:\"https://s3-us-west-2.amazonaws.com/freemius/plugins/10592/card_banner.jpg\";s:15:\"selling_point_0\";s:26:\"Add adobe font collections\";s:15:\"selling_point_1\";s:32:\"Easily integrate with project ID\";s:15:\"selling_point_2\";s:102:\"Once you specify project ID , specified fonts collection will be added in all the typography settings.\";s:11:\"screenshots\";O:8:\"stdClass\":2:{s:12:\"screenshot_0\";s:75:\"https://s3-us-west-2.amazonaws.com/freemius/plugins/10592/screenshots/0.png\";s:12:\"screenshot_1\";s:75:\"https://s3-us-west-2.amazonaws.com/freemius/plugins/10592/screenshots/1.png\";}s:2:\"id\";s:4:\"2900\";s:7:\"created\";s:19:\"2022-06-30 14:22:16\";s:7:\"updated\";s:19:\"2022-07-05 11:32:23\";}s:12:\"premium_slug\";s:17:\"spice-adobe-fonts\";}i:10;O:8:\"stdClass\":34:{s:16:\"parent_plugin_id\";s:5:\"10330\";s:12:\"developer_id\";s:5:\"11810\";s:8:\"store_id\";s:4:\"3780\";s:10:\"install_id\";s:7:\"9863325\";s:4:\"slug\";s:12:\"olivewp-plus\";s:5:\"title\";s:12:\"OliveWP Plus\";s:11:\"environment\";i:0;s:4:\"icon\";s:48:\"//img.freemius.com/plugin-icon-blue-noshadow.png\";s:15:\"default_plan_id\";s:5:\"17957\";s:5:\"plans\";i:17957;s:8:\"features\";N;s:17:\"money_back_period\";N;s:13:\"refund_policy\";N;s:24:\"annual_renewals_discount\";N;s:22:\"renewals_discount_type\";s:10:\"percentage\";s:11:\"is_released\";b:1;s:15:\"is_sdk_required\";b:1;s:18:\"is_pricing_visible\";b:1;s:19:\"is_wp_org_compliant\";b:0;s:6:\"is_off\";b:0;s:24:\"is_only_for_new_installs\";b:0;s:14:\"installs_limit\";N;s:19:\"free_releases_count\";i:0;s:22:\"premium_releases_count\";i:3;s:17:\"accepted_payments\";i:0;s:7:\"plan_id\";s:1:\"0\";s:4:\"type\";s:6:\"plugin\";s:9:\"is_static\";b:0;s:10:\"public_key\";s:32:\"pk_7c81273c35f58df9dc63736356468\";s:2:\"id\";s:5:\"10605\";s:7:\"created\";s:19:\"2022-06-30 15:50:11\";s:7:\"updated\";s:19:\"2023-10-22 07:48:05\";s:4:\"info\";O:8:\"stdClass\":13:{s:9:\"plugin_id\";s:5:\"10605\";s:3:\"url\";N;s:11:\"description\";s:470:\"<h2>About OliveWP Plus</h2><p>Add useful features like - preloader layouts, header presets, footer widgets & footer bar layouts, search effects, post navigation style, and many more.</p><h2>More Features</h2><ul><li>Choose among multiple header variations.</li><li>Select desired effect from multiple search effects</li><li>Manage post styles options like Background color, margin padding and border.</li><li>Adjust banner section padding.</li><li>Many more...</li></ul>\";s:17:\"short_description\";s:77:\"This add-on super charges OliveWP theme by adding many useful features to it.\";s:10:\"banner_url\";s:68:\"https://s3-us-west-2.amazonaws.com/freemius/plugins/10605/banner.jpg\";s:15:\"card_banner_url\";s:73:\"https://s3-us-west-2.amazonaws.com/freemius/plugins/10605/card_banner.jpg\";s:15:\"selling_point_0\";s:36:\"Beautifully designed blog templates.\";s:15:\"selling_point_1\";s:29:\"Typography and color features\";s:15:\"selling_point_2\";s:25:\"Grid and masonry layouts.\";s:11:\"screenshots\";O:8:\"stdClass\":3:{s:12:\"screenshot_0\";s:75:\"https://s3-us-west-2.amazonaws.com/freemius/plugins/10605/screenshots/0.png\";s:12:\"screenshot_1\";s:75:\"https://s3-us-west-2.amazonaws.com/freemius/plugins/10605/screenshots/1.png\";s:12:\"screenshot_2\";s:75:\"https://s3-us-west-2.amazonaws.com/freemius/plugins/10605/screenshots/2.png\";}s:2:\"id\";s:4:\"2901\";s:7:\"created\";s:19:\"2022-07-01 06:15:36\";s:7:\"updated\";s:19:\"2022-07-05 11:57:56\";}s:12:\"premium_slug\";s:12:\"olivewp-plus\";}i:11;O:8:\"stdClass\":34:{s:16:\"parent_plugin_id\";s:5:\"10330\";s:12:\"developer_id\";s:5:\"11810\";s:8:\"store_id\";s:4:\"3780\";s:10:\"install_id\";s:7:\"9889241\";s:4:\"slug\";s:24:\"spice-starter-sites-plus\";s:5:\"title\";s:24:\"Spice Starter Sites Plus\";s:11:\"environment\";i:0;s:4:\"icon\";s:48:\"//img.freemius.com/plugin-icon-blue-noshadow.png\";s:15:\"default_plan_id\";s:5:\"18000\";s:5:\"plans\";i:18000;s:8:\"features\";N;s:17:\"money_back_period\";N;s:13:\"refund_policy\";N;s:24:\"annual_renewals_discount\";N;s:22:\"renewals_discount_type\";s:10:\"percentage\";s:11:\"is_released\";b:1;s:15:\"is_sdk_required\";b:1;s:18:\"is_pricing_visible\";b:1;s:19:\"is_wp_org_compliant\";b:0;s:6:\"is_off\";b:0;s:24:\"is_only_for_new_installs\";b:0;s:14:\"installs_limit\";N;s:19:\"free_releases_count\";i:1;s:22:\"premium_releases_count\";i:5;s:17:\"accepted_payments\";i:0;s:7:\"plan_id\";s:1:\"0\";s:4:\"type\";s:6:\"plugin\";s:9:\"is_static\";b:0;s:10:\"public_key\";s:32:\"pk_90c30f60d64aaa76bc5407af43c7b\";s:2:\"id\";s:5:\"10626\";s:7:\"created\";s:19:\"2022-07-05 11:19:04\";s:7:\"updated\";s:19:\"2023-10-20 08:28:49\";s:4:\"info\";O:8:\"stdClass\":13:{s:9:\"plugin_id\";s:5:\"10626\";s:3:\"url\";N;s:11:\"description\";s:165:\"<p>Already having starter site for every niche and constantly developing new desings every month. You just need to import and get exact replica of our demo site.</p>\";s:17:\"short_description\";s:58:\"This add-on helps you to add read to import starter sites.\";s:10:\"banner_url\";s:68:\"https://s3-us-west-2.amazonaws.com/freemius/plugins/10626/banner.jpg\";s:15:\"card_banner_url\";s:73:\"https://s3-us-west-2.amazonaws.com/freemius/plugins/10626/card_banner.jpg\";s:15:\"selling_point_0\";s:71:\"You just a click away to start importing ready to import starter sites.\";s:15:\"selling_point_1\";s:78:\"Browse all starter sites <a href=\"https://olivewp.org/starter-sites/\">here</a>\";s:15:\"selling_point_2\";N;s:11:\"screenshots\";N;s:2:\"id\";s:4:\"2905\";s:7:\"created\";s:19:\"2022-07-05 12:14:46\";s:7:\"updated\";s:19:\"2022-07-05 12:36:38\";}s:12:\"premium_slug\";s:24:\"spice-starter-sites-plus\";}}}s:7:\"created\";i:1727307549;s:9:\"timestamp\";i:1727393949;}s:33:\"get:/v1/plugins/9961/pricing.json\";O:8:\"stdClass\":3:{s:6:\"result\";O:8:\"stdClass\":1:{s:5:\"plans\";a:4:{i:0;O:8:\"stdClass\":27:{s:14:\"bundle_plan_id\";s:3:\"629\";s:9:\"bundle_id\";N;s:12:\"plugin_plans\";i:16750;s:12:\"is_inherited\";b:1;s:9:\"plugin_id\";s:4:\"9961\";s:4:\"name\";s:8:\"business\";s:5:\"title\";s:8:\"Business\";s:11:\"description\";N;s:17:\"is_free_localhost\";b:1;s:17:\"is_block_features\";b:1;s:25:\"is_block_features_monthly\";b:1;s:12:\"license_type\";i:0;s:16:\"is_https_support\";b:0;s:12:\"trial_period\";N;s:23:\"is_require_subscription\";b:0;s:10:\"support_kb\";N;s:13:\"support_forum\";N;s:13:\"support_email\";N;s:13:\"support_phone\";N;s:13:\"support_skype\";N;s:18:\"is_success_manager\";b:0;s:11:\"is_featured\";b:1;s:9:\"is_hidden\";b:1;s:2:\"id\";s:5:\"16750\";s:7:\"created\";s:19:\"2022-03-01 17:24:21\";s:7:\"updated\";s:19:\"2022-06-23 19:28:14\";s:7:\"pricing\";a:3:{i:0;O:8:\"stdClass\":11:{s:7:\"plan_id\";s:5:\"16750\";s:8:\"licenses\";i:1;s:13:\"monthly_price\";N;s:12:\"annual_price\";i:59;s:14:\"lifetime_price\";i:177;s:15:\"is_whitelabeled\";b:0;s:9:\"is_hidden\";b:0;s:2:\"id\";s:5:\"18769\";s:7:\"created\";s:19:\"2022-03-01 18:13:04\";s:7:\"updated\";s:19:\"2022-03-01 19:26:19\";s:8:\"currency\";s:3:\"usd\";}i:1;O:8:\"stdClass\":11:{s:7:\"plan_id\";s:5:\"16750\";s:8:\"licenses\";i:3;s:13:\"monthly_price\";N;s:12:\"annual_price\";i:79;s:14:\"lifetime_price\";i:237;s:15:\"is_whitelabeled\";b:0;s:9:\"is_hidden\";b:0;s:2:\"id\";s:5:\"18772\";s:7:\"created\";s:19:\"2022-03-01 18:15:15\";s:7:\"updated\";s:19:\"2022-03-01 18:15:21\";s:8:\"currency\";s:3:\"usd\";}i:2;O:8:\"stdClass\":11:{s:7:\"plan_id\";s:5:\"16750\";s:8:\"licenses\";i:50;s:13:\"monthly_price\";N;s:12:\"annual_price\";i:119;s:14:\"lifetime_price\";i:397;s:15:\"is_whitelabeled\";b:0;s:9:\"is_hidden\";b:0;s:2:\"id\";s:5:\"18784\";s:7:\"created\";s:19:\"2022-03-01 19:24:11\";s:7:\"updated\";s:19:\"2022-03-01 19:24:18\";s:8:\"currency\";s:3:\"usd\";}}}i:1;O:8:\"stdClass\":27:{s:14:\"bundle_plan_id\";s:3:\"630\";s:9:\"bundle_id\";N;s:12:\"plugin_plans\";O:8:\"stdClass\":2:{s:4:\"9962\";s:5:\"16751\";s:4:\"9963\";s:5:\"16753\";}s:12:\"is_inherited\";b:1;s:9:\"plugin_id\";s:4:\"9961\";s:4:\"name\";s:6:\"agency\";s:5:\"title\";s:6:\"Agency\";s:11:\"description\";N;s:17:\"is_free_localhost\";b:1;s:17:\"is_block_features\";b:1;s:25:\"is_block_features_monthly\";b:1;s:12:\"license_type\";i:0;s:16:\"is_https_support\";b:0;s:12:\"trial_period\";N;s:23:\"is_require_subscription\";b:0;s:10:\"support_kb\";N;s:13:\"support_forum\";N;s:13:\"support_email\";N;s:13:\"support_phone\";N;s:13:\"support_skype\";N;s:18:\"is_success_manager\";b:0;s:11:\"is_featured\";b:0;s:9:\"is_hidden\";b:1;s:2:\"id\";s:5:\"16754\";s:7:\"created\";s:19:\"2022-03-01 18:13:20\";s:7:\"updated\";s:19:\"2022-06-23 19:28:15\";s:7:\"pricing\";a:2:{i:0;O:8:\"stdClass\":11:{s:7:\"plan_id\";s:5:\"16754\";s:8:\"licenses\";i:1;s:13:\"monthly_price\";N;s:12:\"annual_price\";i:119;s:14:\"lifetime_price\";i:357;s:15:\"is_whitelabeled\";b:0;s:9:\"is_hidden\";b:1;s:2:\"id\";s:5:\"18770\";s:7:\"created\";s:19:\"2022-03-01 18:13:47\";s:7:\"updated\";s:19:\"2022-03-01 18:14:34\";s:8:\"currency\";s:3:\"usd\";}i:1;O:8:\"stdClass\":11:{s:7:\"plan_id\";s:5:\"16754\";s:8:\"licenses\";N;s:13:\"monthly_price\";N;s:12:\"annual_price\";i:119;s:14:\"lifetime_price\";i:357;s:15:\"is_whitelabeled\";b:0;s:9:\"is_hidden\";b:0;s:2:\"id\";s:5:\"18773\";s:7:\"created\";s:19:\"2022-03-01 18:15:34\";s:7:\"updated\";s:19:\"2022-03-01 18:15:40\";s:8:\"currency\";s:3:\"usd\";}}}i:2;O:8:\"stdClass\":27:{s:14:\"bundle_plan_id\";s:3:\"713\";s:9:\"bundle_id\";N;s:12:\"plugin_plans\";O:8:\"stdClass\":3:{s:5:\"10330\";s:5:\"17436\";s:5:\"10559\";s:5:\"17855\";s:5:\"10571\";s:5:\"17882\";}s:12:\"is_inherited\";b:1;s:9:\"plugin_id\";s:4:\"9961\";s:4:\"name\";s:4:\"free\";s:5:\"title\";s:4:\"Free\";s:11:\"description\";N;s:17:\"is_free_localhost\";b:1;s:17:\"is_block_features\";b:1;s:25:\"is_block_features_monthly\";b:1;s:12:\"license_type\";i:0;s:16:\"is_https_support\";b:0;s:12:\"trial_period\";N;s:23:\"is_require_subscription\";b:0;s:10:\"support_kb\";N;s:13:\"support_forum\";N;s:13:\"support_email\";N;s:13:\"support_phone\";N;s:13:\"support_skype\";N;s:18:\"is_success_manager\";b:0;s:11:\"is_featured\";b:0;s:9:\"is_hidden\";b:0;s:2:\"id\";s:5:\"17854\";s:7:\"created\";s:19:\"2022-06-23 19:28:55\";s:7:\"updated\";N;s:8:\"features\";a:12:{i:0;O:8:\"stdClass\":9:{s:5:\"value\";N;s:7:\"plan_id\";s:5:\"17854\";s:9:\"plugin_id\";s:4:\"9961\";s:5:\"title\";s:22:\"Basic General Features\";s:11:\"description\";s:79:\"Woo-Commerce and page builder support, translation ready , RTL and WPML support\";s:11:\"is_featured\";b:1;s:2:\"id\";s:5:\"12014\";s:7:\"created\";s:19:\"2022-07-05 14:09:50\";s:7:\"updated\";N;}i:1;O:8:\"stdClass\":9:{s:5:\"value\";N;s:7:\"plan_id\";s:5:\"17854\";s:9:\"plugin_id\";s:4:\"9961\";s:5:\"title\";s:15:\"Banner Features\";s:11:\"description\";s:50:\"Basic banner image, breadcrumb and header options.\";s:11:\"is_featured\";b:1;s:2:\"id\";s:5:\"12015\";s:7:\"created\";s:19:\"2022-07-05 17:16:37\";s:7:\"updated\";N;}i:2;O:8:\"stdClass\":9:{s:5:\"value\";s:0:\"\";s:7:\"plan_id\";s:5:\"17854\";s:9:\"plugin_id\";s:4:\"9961\";s:5:\"title\";s:13:\"Sticky Header\";s:11:\"description\";s:72:\"Basic sticky header, toggle search icon, add button and HTML after menu.\";s:11:\"is_featured\";b:1;s:2:\"id\";s:5:\"12016\";s:7:\"created\";s:19:\"2022-07-05 17:18:09\";s:7:\"updated\";N;}i:3;O:8:\"stdClass\":9:{s:5:\"value\";s:0:\"\";s:7:\"plan_id\";s:5:\"17854\";s:9:\"plugin_id\";s:4:\"9961\";s:5:\"title\";s:17:\"Container Layouts\";s:11:\"description\";s:99:\"Wide and boxed with container layout , content and sidebar width and basic container width options.\";s:11:\"is_featured\";b:1;s:2:\"id\";s:5:\"12017\";s:7:\"created\";s:19:\"2022-07-05 17:20:04\";s:7:\"updated\";N;}i:4;O:8:\"stdClass\":9:{s:5:\"value\";s:0:\"\";s:7:\"plan_id\";s:5:\"17854\";s:9:\"plugin_id\";s:4:\"9961\";s:5:\"title\";s:15:\"Footer Features\";s:11:\"description\";s:70:\"Widget area, 3 widget layouts, basic scroll to top and footer options.\";s:11:\"is_featured\";b:1;s:2:\"id\";s:5:\"12018\";s:7:\"created\";s:19:\"2022-07-05 17:21:04\";s:7:\"updated\";N;}i:5;O:8:\"stdClass\":9:{s:5:\"value\";s:0:\"\";s:7:\"plan_id\";s:5:\"17854\";s:9:\"plugin_id\";s:4:\"9961\";s:5:\"title\";s:13:\"Blog Features\";s:11:\"description\";s:135:\"Excerpt and full length content , read more button positioning,  simple post pagination style, reordering and basic post meta settings.\";s:11:\"is_featured\";b:1;s:2:\"id\";s:5:\"12019\";s:7:\"created\";s:19:\"2022-07-05 17:22:54\";s:7:\"updated\";N;}i:6;O:8:\"stdClass\":9:{s:5:\"value\";s:0:\"\";s:7:\"plan_id\";s:5:\"17854\";s:9:\"plugin_id\";s:4:\"9961\";s:5:\"title\";s:14:\"Sidebar Layout\";s:11:\"description\";s:0:\"\";s:11:\"is_featured\";b:1;s:2:\"id\";s:5:\"12020\";s:7:\"created\";s:19:\"2022-07-05 17:23:24\";s:7:\"updated\";N;}i:7;O:8:\"stdClass\":9:{s:5:\"value\";s:0:\"\";s:7:\"plan_id\";s:5:\"17854\";s:9:\"plugin_id\";s:4:\"9961\";s:5:\"title\";s:17:\"Basic Typrography\";s:11:\"description\";s:84:\"Header, shop pages, sidebar and footer widgets and basic content typography options.\";s:11:\"is_featured\";b:1;s:2:\"id\";s:5:\"12021\";s:7:\"created\";s:19:\"2022-07-05 17:24:45\";s:7:\"updated\";N;}i:8;O:8:\"stdClass\":9:{s:5:\"value\";s:0:\"\";s:7:\"plan_id\";s:5:\"17854\";s:9:\"plugin_id\";s:4:\"9961\";s:5:\"title\";s:30:\"Colors and Backgrounds Feature\";s:11:\"description\";s:73:\"Header, menu, sidebar and footer widgets and basic content color options.\";s:11:\"is_featured\";b:1;s:2:\"id\";s:5:\"12022\";s:7:\"created\";s:19:\"2022-07-05 17:25:43\";s:7:\"updated\";N;}i:9;O:8:\"stdClass\":9:{s:5:\"value\";s:0:\"\";s:7:\"plan_id\";s:5:\"17854\";s:9:\"plugin_id\";s:4:\"9961\";s:5:\"title\";s:27:\"Spice Post Slider Extension\";s:11:\"description\";s:45:\"Add post slider with the help of this add-on.\";s:11:\"is_featured\";b:1;s:2:\"id\";s:5:\"12023\";s:7:\"created\";s:19:\"2022-07-05 17:26:15\";s:7:\"updated\";N;}i:10;O:8:\"stdClass\":9:{s:5:\"value\";s:0:\"\";s:7:\"plan_id\";s:5:\"17854\";s:9:\"plugin_id\";s:4:\"9961\";s:5:\"title\";s:28:\"Spice Social Share Extension\";s:11:\"description\";s:58:\"This add-on add social sharing options to your blog posts.\";s:11:\"is_featured\";b:1;s:2:\"id\";s:5:\"12024\";s:7:\"created\";s:19:\"2022-07-05 17:26:54\";s:7:\"updated\";N;}i:11;O:8:\"stdClass\":9:{s:5:\"value\";s:0:\"\";s:7:\"plan_id\";s:5:\"17854\";s:9:\"plugin_id\";s:4:\"9961\";s:5:\"title\";s:28:\"Access to free starter sites\";s:11:\"description\";s:100:\"After activating olivewp companion plugin you will get access to beautifully designed starter sites.\";s:11:\"is_featured\";b:1;s:2:\"id\";s:5:\"12025\";s:7:\"created\";s:19:\"2022-07-05 17:28:07\";s:7:\"updated\";N;}}}i:3;O:8:\"stdClass\":28:{s:14:\"bundle_plan_id\";s:3:\"628\";s:9:\"bundle_id\";N;s:12:\"plugin_plans\";O:8:\"stdClass\":14:{s:5:\"10330\";s:5:\"17436\";s:5:\"10559\";s:5:\"17855\";s:5:\"10571\";s:5:\"17882\";s:5:\"10572\";s:5:\"17884\";s:5:\"10573\";s:5:\"17886\";s:5:\"10574\";s:5:\"17888\";s:5:\"10575\";s:5:\"17890\";s:5:\"10576\";s:5:\"17892\";s:5:\"10577\";s:5:\"17894\";s:5:\"10578\";s:5:\"17896\";s:5:\"10579\";s:5:\"17898\";s:5:\"10592\";s:5:\"17928\";s:5:\"10605\";s:5:\"17957\";s:5:\"10626\";s:5:\"18000\";}s:12:\"is_inherited\";b:1;s:9:\"plugin_id\";s:4:\"9961\";s:4:\"name\";s:3:\"pro\";s:5:\"title\";s:3:\"Pro\";s:11:\"description\";N;s:17:\"is_free_localhost\";b:1;s:17:\"is_block_features\";b:1;s:25:\"is_block_features_monthly\";b:1;s:12:\"license_type\";i:0;s:16:\"is_https_support\";b:0;s:12:\"trial_period\";N;s:23:\"is_require_subscription\";b:0;s:10:\"support_kb\";N;s:13:\"support_forum\";N;s:13:\"support_email\";N;s:13:\"support_phone\";N;s:13:\"support_skype\";N;s:18:\"is_success_manager\";b:0;s:11:\"is_featured\";b:0;s:9:\"is_hidden\";b:0;s:2:\"id\";s:5:\"16749\";s:7:\"created\";s:19:\"2022-03-01 17:14:42\";s:7:\"updated\";s:19:\"2022-03-11 11:53:37\";s:7:\"pricing\";a:6:{i:0;O:8:\"stdClass\":11:{s:7:\"plan_id\";s:5:\"16749\";s:8:\"licenses\";i:1;s:13:\"monthly_price\";N;s:12:\"annual_price\";i:59;s:14:\"lifetime_price\";i:177;s:15:\"is_whitelabeled\";b:0;s:9:\"is_hidden\";b:0;s:2:\"id\";s:5:\"18765\";s:7:\"created\";s:19:\"2022-03-01 17:23:18\";s:7:\"updated\";s:19:\"2022-03-01 17:23:34\";s:8:\"currency\";s:3:\"usd\";}i:1;O:8:\"stdClass\":11:{s:7:\"plan_id\";s:5:\"16749\";s:8:\"licenses\";i:1;s:13:\"monthly_price\";N;s:12:\"annual_price\";i:55;s:14:\"lifetime_price\";i:159;s:15:\"is_whitelabeled\";b:0;s:9:\"is_hidden\";b:0;s:2:\"id\";s:5:\"18798\";s:7:\"created\";s:19:\"2022-03-02 17:34:55\";s:7:\"updated\";s:19:\"2022-03-02 17:38:51\";s:8:\"currency\";s:3:\"eur\";}i:2;O:8:\"stdClass\":11:{s:7:\"plan_id\";s:5:\"16749\";s:8:\"licenses\";i:3;s:13:\"monthly_price\";N;s:12:\"annual_price\";i:79;s:14:\"lifetime_price\";i:237;s:15:\"is_whitelabeled\";b:0;s:9:\"is_hidden\";b:0;s:2:\"id\";s:5:\"18778\";s:7:\"created\";s:19:\"2022-03-01 18:36:10\";s:7:\"updated\";s:19:\"2022-03-01 18:36:15\";s:8:\"currency\";s:3:\"usd\";}i:3;O:8:\"stdClass\":11:{s:7:\"plan_id\";s:5:\"16749\";s:8:\"licenses\";i:3;s:13:\"monthly_price\";N;s:12:\"annual_price\";i:72;s:14:\"lifetime_price\";i:214;s:15:\"is_whitelabeled\";b:0;s:9:\"is_hidden\";b:0;s:2:\"id\";s:5:\"18799\";s:7:\"created\";s:19:\"2022-03-02 17:34:55\";s:7:\"updated\";s:19:\"2022-03-02 17:39:17\";s:8:\"currency\";s:3:\"eur\";}i:4;O:8:\"stdClass\":11:{s:7:\"plan_id\";s:5:\"16749\";s:8:\"licenses\";i:50;s:13:\"monthly_price\";N;s:12:\"annual_price\";i:119;s:14:\"lifetime_price\";i:397;s:15:\"is_whitelabeled\";b:0;s:9:\"is_hidden\";b:0;s:2:\"id\";s:5:\"18779\";s:7:\"created\";s:19:\"2022-03-01 18:38:06\";s:7:\"updated\";s:19:\"2022-03-01 18:39:11\";s:8:\"currency\";s:3:\"usd\";}i:5;O:8:\"stdClass\":11:{s:7:\"plan_id\";s:5:\"16749\";s:8:\"licenses\";i:50;s:13:\"monthly_price\";N;s:12:\"annual_price\";i:107;s:14:\"lifetime_price\";i:358;s:15:\"is_whitelabeled\";b:0;s:9:\"is_hidden\";b:0;s:2:\"id\";s:5:\"18800\";s:7:\"created\";s:19:\"2022-03-02 17:34:55\";s:7:\"updated\";s:19:\"2022-03-02 17:39:42\";s:8:\"currency\";s:3:\"eur\";}}s:8:\"features\";a:19:{i:0;O:8:\"stdClass\":9:{s:5:\"value\";s:0:\"\";s:7:\"plan_id\";s:5:\"16749\";s:9:\"plugin_id\";s:4:\"9961\";s:5:\"title\";s:25:\"Advanced General Features\";s:11:\"description\";s:27:\"6 preloader design options.\";s:11:\"is_featured\";b:1;s:2:\"id\";s:5:\"11969\";s:7:\"created\";s:19:\"2022-06-25 14:02:31\";s:7:\"updated\";s:19:\"2022-07-05 13:51:56\";}i:1;O:8:\"stdClass\":9:{s:5:\"value\";s:0:\"\";s:7:\"plan_id\";s:5:\"16749\";s:9:\"plugin_id\";s:4:\"9961\";s:5:\"title\";s:26:\"Additional Banner Features\";s:11:\"description\";s:102:\"Advance options for managing image overlay color, padding, banner image,  breadcrumb and page headers.\";s:11:\"is_featured\";b:1;s:2:\"id\";s:5:\"11996\";s:7:\"created\";s:19:\"2022-07-05 13:38:40\";s:7:\"updated\";s:19:\"2022-07-05 13:54:25\";}i:2;O:8:\"stdClass\":9:{s:5:\"value\";s:0:\"\";s:7:\"plan_id\";s:5:\"16749\";s:9:\"plugin_id\";s:4:\"9961\";s:5:\"title\";s:20:\"Top  Header Features\";s:11:\"description\";s:124:\"7 header presets, top header widgets, light and dark popup search effects, additional options for adding widgets after menu.\";s:11:\"is_featured\";b:1;s:2:\"id\";s:5:\"11997\";s:7:\"created\";s:19:\"2022-07-05 13:40:57\";s:7:\"updated\";s:19:\"2022-07-05 13:56:30\";}i:3;O:8:\"stdClass\":9:{s:5:\"value\";s:0:\"\";s:7:\"plan_id\";s:5:\"16749\";s:9:\"plugin_id\";s:4:\"9961\";s:5:\"title\";s:26:\"Advanced Container options\";s:11:\"description\";s:45:\"Advance options for managing container width.\";s:11:\"is_featured\";b:1;s:2:\"id\";s:5:\"11998\";s:7:\"created\";s:19:\"2022-07-05 13:42:24\";s:7:\"updated\";s:19:\"2022-07-05 13:57:11\";}i:4;O:8:\"stdClass\":9:{s:5:\"value\";s:0:\"\";s:7:\"plan_id\";s:5:\"16749\";s:9:\"plugin_id\";s:4:\"9961\";s:5:\"title\";s:26:\"Additional Footer Features\";s:11:\"description\";s:101:\"9 premium widget layouts, additional settings for manage scroll to top feature and footer bar layout.\";s:11:\"is_featured\";b:1;s:2:\"id\";s:5:\"11999\";s:7:\"created\";s:19:\"2022-07-05 13:43:49\";s:7:\"updated\";s:19:\"2022-07-05 13:58:30\";}i:5;O:8:\"stdClass\":9:{s:5:\"value\";s:0:\"\";s:7:\"plan_id\";s:5:\"16749\";s:9:\"plugin_id\";s:4:\"9961\";s:5:\"title\";s:21:\"Advance Blog Features\";s:11:\"description\";s:159:\"Grid layout, masonry layout, post styling options, thumbnail images sizes, editable read more button, various post pagination styles and advance meta settings.\";s:11:\"is_featured\";b:1;s:2:\"id\";s:5:\"12000\";s:7:\"created\";s:19:\"2022-07-05 13:46:27\";s:7:\"updated\";s:19:\"2022-07-05 14:00:31\";}i:6;O:8:\"stdClass\":9:{s:5:\"value\";s:0:\"\";s:7:\"plan_id\";s:5:\"16749\";s:9:\"plugin_id\";s:4:\"9961\";s:5:\"title\";s:14:\"Sidebar Layout\";s:11:\"description\";s:0:\"\";s:11:\"is_featured\";b:1;s:2:\"id\";s:5:\"12001\";s:7:\"created\";s:19:\"2022-07-05 13:46:58\";s:7:\"updated\";N;}i:7;O:8:\"stdClass\":9:{s:5:\"value\";s:0:\"\";s:7:\"plan_id\";s:5:\"16749\";s:9:\"plugin_id\";s:4:\"9961\";s:5:\"title\";s:26:\"Advance typography options\";s:11:\"description\";s:0:\"\";s:11:\"is_featured\";b:1;s:2:\"id\";s:5:\"12002\";s:7:\"created\";s:19:\"2022-07-05 13:48:31\";s:7:\"updated\";s:19:\"2022-07-05 14:01:01\";}i:8;O:8:\"stdClass\":9:{s:5:\"value\";s:0:\"\";s:7:\"plan_id\";s:5:\"16749\";s:9:\"plugin_id\";s:4:\"9961\";s:5:\"title\";s:37:\"Advance  Color and Background Options\";s:11:\"description\";s:0:\"\";s:11:\"is_featured\";b:1;s:2:\"id\";s:5:\"12003\";s:7:\"created\";s:19:\"2022-07-05 13:50:18\";s:7:\"updated\";s:19:\"2022-07-05 14:01:16\";}i:9;O:8:\"stdClass\":9:{s:5:\"value\";N;s:7:\"plan_id\";s:5:\"16749\";s:9:\"plugin_id\";s:4:\"9961\";s:5:\"title\";s:22:\"OliveWP Plus Extension\";s:11:\"description\";s:0:\"\";s:11:\"is_featured\";b:1;s:2:\"id\";s:5:\"12004\";s:7:\"created\";s:19:\"2022-07-05 14:01:51\";s:7:\"updated\";s:19:\"2022-07-05 14:02:34\";}i:10;O:8:\"stdClass\":9:{s:5:\"value\";s:0:\"\";s:7:\"plan_id\";s:5:\"16749\";s:9:\"plugin_id\";s:4:\"9961\";s:5:\"title\";s:25:\"Spice Portfolio Extension\";s:11:\"description\";s:0:\"\";s:11:\"is_featured\";b:1;s:2:\"id\";s:5:\"12005\";s:7:\"created\";s:19:\"2022-07-05 14:02:06\";s:7:\"updated\";s:19:\"2022-07-05 14:02:26\";}i:11;O:8:\"stdClass\":9:{s:5:\"value\";s:0:\"\";s:7:\"plan_id\";s:5:\"16749\";s:9:\"plugin_id\";s:4:\"9961\";s:5:\"title\";s:27:\"Spice White Label Extension\";s:11:\"description\";s:0:\"\";s:11:\"is_featured\";b:1;s:2:\"id\";s:5:\"12006\";s:7:\"created\";s:19:\"2022-07-05 14:02:33\";s:7:\"updated\";N;}i:12;O:8:\"stdClass\":9:{s:5:\"value\";s:0:\"\";s:7:\"plan_id\";s:5:\"16749\";s:9:\"plugin_id\";s:4:\"9961\";s:5:\"title\";s:23:\"Spice Cookies Extension\";s:11:\"description\";s:0:\"\";s:11:\"is_featured\";b:1;s:2:\"id\";s:5:\"12007\";s:7:\"created\";s:19:\"2022-07-05 14:02:46\";s:7:\"updated\";s:19:\"2022-07-05 14:02:52\";}i:13;O:8:\"stdClass\":9:{s:5:\"value\";s:0:\"\";s:7:\"plan_id\";s:5:\"16749\";s:9:\"plugin_id\";s:4:\"9961\";s:5:\"title\";s:29:\"Spice Sticky Header Extension\";s:11:\"description\";s:45:\"This add-on provide option for sticky header.\";s:11:\"is_featured\";b:1;s:2:\"id\";s:5:\"12008\";s:7:\"created\";s:19:\"2022-07-05 14:03:01\";s:7:\"updated\";s:19:\"2022-07-05 14:06:41\";}i:14;O:8:\"stdClass\":9:{s:5:\"value\";s:0:\"\";s:7:\"plan_id\";s:5:\"16749\";s:9:\"plugin_id\";s:4:\"9961\";s:5:\"title\";s:29:\"Spice Sticky Footer Extension\";s:11:\"description\";s:45:\"This add-on provide option for sticky footer.\";s:11:\"is_featured\";b:1;s:2:\"id\";s:5:\"12009\";s:7:\"created\";s:19:\"2022-07-05 14:03:15\";s:7:\"updated\";s:19:\"2022-07-05 14:06:32\";}i:15;O:8:\"stdClass\":9:{s:5:\"value\";s:0:\"\";s:7:\"plan_id\";s:5:\"16749\";s:9:\"plugin_id\";s:4:\"9961\";s:5:\"title\";s:16:\"Spice Side Panel\";s:11:\"description\";s:66:\"Add anything to the side of your website with the help of widgets.\";s:11:\"is_featured\";b:1;s:2:\"id\";s:5:\"12010\";s:7:\"created\";s:19:\"2022-07-05 14:03:28\";s:7:\"updated\";s:19:\"2022-07-05 14:06:05\";}i:16;O:8:\"stdClass\":9:{s:5:\"value\";s:0:\"\";s:7:\"plan_id\";s:5:\"16749\";s:9:\"plugin_id\";s:4:\"9961\";s:5:\"title\";s:17:\"Spice Popup Login\";s:11:\"description\";s:68:\"This add-on will have popup form for login and registration purpose.\";s:11:\"is_featured\";b:1;s:2:\"id\";s:5:\"12011\";s:7:\"created\";s:19:\"2022-07-05 14:03:38\";s:7:\"updated\";s:19:\"2022-07-05 14:05:40\";}i:17;O:8:\"stdClass\":9:{s:5:\"value\";s:0:\"\";s:7:\"plan_id\";s:5:\"16749\";s:9:\"plugin_id\";s:4:\"9961\";s:5:\"title\";s:25:\"Spice Instagram Extension\";s:11:\"description\";s:47:\"Fetch and display instagram feeds on your site.\";s:11:\"is_featured\";b:1;s:2:\"id\";s:5:\"12012\";s:7:\"created\";s:19:\"2022-07-05 14:03:52\";s:7:\"updated\";s:19:\"2022-07-05 14:04:59\";}i:18;O:8:\"stdClass\":9:{s:5:\"value\";s:0:\"\";s:7:\"plan_id\";s:5:\"16749\";s:9:\"plugin_id\";s:4:\"9961\";s:5:\"title\";s:27:\"Spice Adobe Fonts Extension\";s:11:\"description\";s:72:\"This add-on will helps you to add adobe fonts collection of your choice.\";s:11:\"is_featured\";b:1;s:2:\"id\";s:5:\"12013\";s:7:\"created\";s:19:\"2022-07-05 14:04:28\";s:7:\"updated\";N;}}}}}s:7:\"created\";i:1727307549;s:9:\"timestamp\";i:1727393949;}}", "off");
INSERT INTO `wp_options` VALUES("207", "downloaded_font_files", "a:54:{s:76:\"https://fonts.gstatic.com/s/poppins/v20/pxiAyp8kv8JHgFVrJJLmE0tDMPKzSQ.woff2\";s:86:\"C:/wamp64/www/wordpress/wp-content//fonts/poppins/pxiAyp8kv8JHgFVrJJLmE0tDMPKzSQ.woff2\";s:76:\"https://fonts.gstatic.com/s/poppins/v20/pxiAyp8kv8JHgFVrJJLmE0tMMPKzSQ.woff2\";s:86:\"C:/wamp64/www/wordpress/wp-content//fonts/poppins/pxiAyp8kv8JHgFVrJJLmE0tMMPKzSQ.woff2\";s:73:\"https://fonts.gstatic.com/s/poppins/v20/pxiAyp8kv8JHgFVrJJLmE0tCMPI.woff2\";s:83:\"C:/wamp64/www/wordpress/wp-content//fonts/poppins/pxiAyp8kv8JHgFVrJJLmE0tCMPI.woff2\";s:77:\"https://fonts.gstatic.com/s/poppins/v20/pxiDyp8kv8JHgFVrJJLmv1pVFteOcEg.woff2\";s:87:\"C:/wamp64/www/wordpress/wp-content//fonts/poppins/pxiDyp8kv8JHgFVrJJLmv1pVFteOcEg.woff2\";s:77:\"https://fonts.gstatic.com/s/poppins/v20/pxiDyp8kv8JHgFVrJJLmv1pVGdeOcEg.woff2\";s:87:\"C:/wamp64/www/wordpress/wp-content//fonts/poppins/pxiDyp8kv8JHgFVrJJLmv1pVGdeOcEg.woff2\";s:74:\"https://fonts.gstatic.com/s/poppins/v20/pxiDyp8kv8JHgFVrJJLmv1pVF9eO.woff2\";s:84:\"C:/wamp64/www/wordpress/wp-content//fonts/poppins/pxiDyp8kv8JHgFVrJJLmv1pVF9eO.woff2\";s:77:\"https://fonts.gstatic.com/s/poppins/v20/pxiDyp8kv8JHgFVrJJLm21lVFteOcEg.woff2\";s:87:\"C:/wamp64/www/wordpress/wp-content//fonts/poppins/pxiDyp8kv8JHgFVrJJLm21lVFteOcEg.woff2\";s:77:\"https://fonts.gstatic.com/s/poppins/v20/pxiDyp8kv8JHgFVrJJLm21lVGdeOcEg.woff2\";s:87:\"C:/wamp64/www/wordpress/wp-content//fonts/poppins/pxiDyp8kv8JHgFVrJJLm21lVGdeOcEg.woff2\";s:74:\"https://fonts.gstatic.com/s/poppins/v20/pxiDyp8kv8JHgFVrJJLm21lVF9eO.woff2\";s:84:\"C:/wamp64/www/wordpress/wp-content//fonts/poppins/pxiDyp8kv8JHgFVrJJLm21lVF9eO.woff2\";s:73:\"https://fonts.gstatic.com/s/poppins/v20/pxiGyp8kv8JHgFVrJJLucXtAKPY.woff2\";s:83:\"C:/wamp64/www/wordpress/wp-content//fonts/poppins/pxiGyp8kv8JHgFVrJJLucXtAKPY.woff2\";s:73:\"https://fonts.gstatic.com/s/poppins/v20/pxiGyp8kv8JHgFVrJJLufntAKPY.woff2\";s:83:\"C:/wamp64/www/wordpress/wp-content//fonts/poppins/pxiGyp8kv8JHgFVrJJLufntAKPY.woff2\";s:70:\"https://fonts.gstatic.com/s/poppins/v20/pxiGyp8kv8JHgFVrJJLucHtA.woff2\";s:80:\"C:/wamp64/www/wordpress/wp-content//fonts/poppins/pxiGyp8kv8JHgFVrJJLucHtA.woff2\";s:77:\"https://fonts.gstatic.com/s/poppins/v20/pxiDyp8kv8JHgFVrJJLmg1hVFteOcEg.woff2\";s:87:\"C:/wamp64/www/wordpress/wp-content//fonts/poppins/pxiDyp8kv8JHgFVrJJLmg1hVFteOcEg.woff2\";s:77:\"https://fonts.gstatic.com/s/poppins/v20/pxiDyp8kv8JHgFVrJJLmg1hVGdeOcEg.woff2\";s:87:\"C:/wamp64/www/wordpress/wp-content//fonts/poppins/pxiDyp8kv8JHgFVrJJLmg1hVGdeOcEg.woff2\";s:74:\"https://fonts.gstatic.com/s/poppins/v20/pxiDyp8kv8JHgFVrJJLmg1hVF9eO.woff2\";s:84:\"C:/wamp64/www/wordpress/wp-content//fonts/poppins/pxiDyp8kv8JHgFVrJJLmg1hVF9eO.woff2\";s:77:\"https://fonts.gstatic.com/s/poppins/v20/pxiDyp8kv8JHgFVrJJLmr19VFteOcEg.woff2\";s:87:\"C:/wamp64/www/wordpress/wp-content//fonts/poppins/pxiDyp8kv8JHgFVrJJLmr19VFteOcEg.woff2\";s:77:\"https://fonts.gstatic.com/s/poppins/v20/pxiDyp8kv8JHgFVrJJLmr19VGdeOcEg.woff2\";s:87:\"C:/wamp64/www/wordpress/wp-content//fonts/poppins/pxiDyp8kv8JHgFVrJJLmr19VGdeOcEg.woff2\";s:74:\"https://fonts.gstatic.com/s/poppins/v20/pxiDyp8kv8JHgFVrJJLmr19VF9eO.woff2\";s:84:\"C:/wamp64/www/wordpress/wp-content//fonts/poppins/pxiDyp8kv8JHgFVrJJLmr19VF9eO.woff2\";s:77:\"https://fonts.gstatic.com/s/poppins/v20/pxiDyp8kv8JHgFVrJJLmy15VFteOcEg.woff2\";s:87:\"C:/wamp64/www/wordpress/wp-content//fonts/poppins/pxiDyp8kv8JHgFVrJJLmy15VFteOcEg.woff2\";s:77:\"https://fonts.gstatic.com/s/poppins/v20/pxiDyp8kv8JHgFVrJJLmy15VGdeOcEg.woff2\";s:87:\"C:/wamp64/www/wordpress/wp-content//fonts/poppins/pxiDyp8kv8JHgFVrJJLmy15VGdeOcEg.woff2\";s:74:\"https://fonts.gstatic.com/s/poppins/v20/pxiDyp8kv8JHgFVrJJLmy15VF9eO.woff2\";s:84:\"C:/wamp64/www/wordpress/wp-content//fonts/poppins/pxiDyp8kv8JHgFVrJJLmy15VF9eO.woff2\";s:77:\"https://fonts.gstatic.com/s/poppins/v20/pxiDyp8kv8JHgFVrJJLm111VFteOcEg.woff2\";s:87:\"C:/wamp64/www/wordpress/wp-content//fonts/poppins/pxiDyp8kv8JHgFVrJJLm111VFteOcEg.woff2\";s:77:\"https://fonts.gstatic.com/s/poppins/v20/pxiDyp8kv8JHgFVrJJLm111VGdeOcEg.woff2\";s:87:\"C:/wamp64/www/wordpress/wp-content//fonts/poppins/pxiDyp8kv8JHgFVrJJLm111VGdeOcEg.woff2\";s:74:\"https://fonts.gstatic.com/s/poppins/v20/pxiDyp8kv8JHgFVrJJLm111VF9eO.woff2\";s:84:\"C:/wamp64/www/wordpress/wp-content//fonts/poppins/pxiDyp8kv8JHgFVrJJLm111VF9eO.woff2\";s:77:\"https://fonts.gstatic.com/s/poppins/v20/pxiDyp8kv8JHgFVrJJLm81xVFteOcEg.woff2\";s:87:\"C:/wamp64/www/wordpress/wp-content//fonts/poppins/pxiDyp8kv8JHgFVrJJLm81xVFteOcEg.woff2\";s:77:\"https://fonts.gstatic.com/s/poppins/v20/pxiDyp8kv8JHgFVrJJLm81xVGdeOcEg.woff2\";s:87:\"C:/wamp64/www/wordpress/wp-content//fonts/poppins/pxiDyp8kv8JHgFVrJJLm81xVGdeOcEg.woff2\";s:74:\"https://fonts.gstatic.com/s/poppins/v20/pxiDyp8kv8JHgFVrJJLm81xVF9eO.woff2\";s:84:\"C:/wamp64/www/wordpress/wp-content//fonts/poppins/pxiDyp8kv8JHgFVrJJLm81xVF9eO.woff2\";s:73:\"https://fonts.gstatic.com/s/poppins/v20/pxiGyp8kv8JHgFVrLPTucXtAKPY.woff2\";s:83:\"C:/wamp64/www/wordpress/wp-content//fonts/poppins/pxiGyp8kv8JHgFVrLPTucXtAKPY.woff2\";s:73:\"https://fonts.gstatic.com/s/poppins/v20/pxiGyp8kv8JHgFVrLPTufntAKPY.woff2\";s:83:\"C:/wamp64/www/wordpress/wp-content//fonts/poppins/pxiGyp8kv8JHgFVrLPTufntAKPY.woff2\";s:70:\"https://fonts.gstatic.com/s/poppins/v20/pxiGyp8kv8JHgFVrLPTucHtA.woff2\";s:80:\"C:/wamp64/www/wordpress/wp-content//fonts/poppins/pxiGyp8kv8JHgFVrLPTucHtA.woff2\";s:74:\"https://fonts.gstatic.com/s/poppins/v20/pxiByp8kv8JHgFVrLFj_Z11lFc-K.woff2\";s:84:\"C:/wamp64/www/wordpress/wp-content//fonts/poppins/pxiByp8kv8JHgFVrLFj_Z11lFc-K.woff2\";s:74:\"https://fonts.gstatic.com/s/poppins/v20/pxiByp8kv8JHgFVrLFj_Z1JlFc-K.woff2\";s:84:\"C:/wamp64/www/wordpress/wp-content//fonts/poppins/pxiByp8kv8JHgFVrLFj_Z1JlFc-K.woff2\";s:72:\"https://fonts.gstatic.com/s/poppins/v20/pxiByp8kv8JHgFVrLFj_Z1xlFQ.woff2\";s:82:\"C:/wamp64/www/wordpress/wp-content//fonts/poppins/pxiByp8kv8JHgFVrLFj_Z1xlFQ.woff2\";s:74:\"https://fonts.gstatic.com/s/poppins/v20/pxiByp8kv8JHgFVrLDz8Z11lFc-K.woff2\";s:84:\"C:/wamp64/www/wordpress/wp-content//fonts/poppins/pxiByp8kv8JHgFVrLDz8Z11lFc-K.woff2\";s:74:\"https://fonts.gstatic.com/s/poppins/v20/pxiByp8kv8JHgFVrLDz8Z1JlFc-K.woff2\";s:84:\"C:/wamp64/www/wordpress/wp-content//fonts/poppins/pxiByp8kv8JHgFVrLDz8Z1JlFc-K.woff2\";s:72:\"https://fonts.gstatic.com/s/poppins/v20/pxiByp8kv8JHgFVrLDz8Z1xlFQ.woff2\";s:82:\"C:/wamp64/www/wordpress/wp-content//fonts/poppins/pxiByp8kv8JHgFVrLDz8Z1xlFQ.woff2\";s:70:\"https://fonts.gstatic.com/s/poppins/v20/pxiEyp8kv8JHgFVrJJbecmNE.woff2\";s:80:\"C:/wamp64/www/wordpress/wp-content//fonts/poppins/pxiEyp8kv8JHgFVrJJbecmNE.woff2\";s:70:\"https://fonts.gstatic.com/s/poppins/v20/pxiEyp8kv8JHgFVrJJnecmNE.woff2\";s:80:\"C:/wamp64/www/wordpress/wp-content//fonts/poppins/pxiEyp8kv8JHgFVrJJnecmNE.woff2\";s:68:\"https://fonts.gstatic.com/s/poppins/v20/pxiEyp8kv8JHgFVrJJfecg.woff2\";s:78:\"C:/wamp64/www/wordpress/wp-content//fonts/poppins/pxiEyp8kv8JHgFVrJJfecg.woff2\";s:74:\"https://fonts.gstatic.com/s/poppins/v20/pxiByp8kv8JHgFVrLGT9Z11lFc-K.woff2\";s:84:\"C:/wamp64/www/wordpress/wp-content//fonts/poppins/pxiByp8kv8JHgFVrLGT9Z11lFc-K.woff2\";s:74:\"https://fonts.gstatic.com/s/poppins/v20/pxiByp8kv8JHgFVrLGT9Z1JlFc-K.woff2\";s:84:\"C:/wamp64/www/wordpress/wp-content//fonts/poppins/pxiByp8kv8JHgFVrLGT9Z1JlFc-K.woff2\";s:72:\"https://fonts.gstatic.com/s/poppins/v20/pxiByp8kv8JHgFVrLGT9Z1xlFQ.woff2\";s:82:\"C:/wamp64/www/wordpress/wp-content//fonts/poppins/pxiByp8kv8JHgFVrLGT9Z1xlFQ.woff2\";s:74:\"https://fonts.gstatic.com/s/poppins/v20/pxiByp8kv8JHgFVrLEj6Z11lFc-K.woff2\";s:84:\"C:/wamp64/www/wordpress/wp-content//fonts/poppins/pxiByp8kv8JHgFVrLEj6Z11lFc-K.woff2\";s:74:\"https://fonts.gstatic.com/s/poppins/v20/pxiByp8kv8JHgFVrLEj6Z1JlFc-K.woff2\";s:84:\"C:/wamp64/www/wordpress/wp-content//fonts/poppins/pxiByp8kv8JHgFVrLEj6Z1JlFc-K.woff2\";s:72:\"https://fonts.gstatic.com/s/poppins/v20/pxiByp8kv8JHgFVrLEj6Z1xlFQ.woff2\";s:82:\"C:/wamp64/www/wordpress/wp-content//fonts/poppins/pxiByp8kv8JHgFVrLEj6Z1xlFQ.woff2\";s:74:\"https://fonts.gstatic.com/s/poppins/v20/pxiByp8kv8JHgFVrLCz7Z11lFc-K.woff2\";s:84:\"C:/wamp64/www/wordpress/wp-content//fonts/poppins/pxiByp8kv8JHgFVrLCz7Z11lFc-K.woff2\";s:74:\"https://fonts.gstatic.com/s/poppins/v20/pxiByp8kv8JHgFVrLCz7Z1JlFc-K.woff2\";s:84:\"C:/wamp64/www/wordpress/wp-content//fonts/poppins/pxiByp8kv8JHgFVrLCz7Z1JlFc-K.woff2\";s:72:\"https://fonts.gstatic.com/s/poppins/v20/pxiByp8kv8JHgFVrLCz7Z1xlFQ.woff2\";s:82:\"C:/wamp64/www/wordpress/wp-content//fonts/poppins/pxiByp8kv8JHgFVrLCz7Z1xlFQ.woff2\";s:74:\"https://fonts.gstatic.com/s/poppins/v20/pxiByp8kv8JHgFVrLDD4Z11lFc-K.woff2\";s:84:\"C:/wamp64/www/wordpress/wp-content//fonts/poppins/pxiByp8kv8JHgFVrLDD4Z11lFc-K.woff2\";s:74:\"https://fonts.gstatic.com/s/poppins/v20/pxiByp8kv8JHgFVrLDD4Z1JlFc-K.woff2\";s:84:\"C:/wamp64/www/wordpress/wp-content//fonts/poppins/pxiByp8kv8JHgFVrLDD4Z1JlFc-K.woff2\";s:72:\"https://fonts.gstatic.com/s/poppins/v20/pxiByp8kv8JHgFVrLDD4Z1xlFQ.woff2\";s:82:\"C:/wamp64/www/wordpress/wp-content//fonts/poppins/pxiByp8kv8JHgFVrLDD4Z1xlFQ.woff2\";s:74:\"https://fonts.gstatic.com/s/poppins/v20/pxiByp8kv8JHgFVrLBT5Z11lFc-K.woff2\";s:84:\"C:/wamp64/www/wordpress/wp-content//fonts/poppins/pxiByp8kv8JHgFVrLBT5Z11lFc-K.woff2\";s:74:\"https://fonts.gstatic.com/s/poppins/v20/pxiByp8kv8JHgFVrLBT5Z1JlFc-K.woff2\";s:84:\"C:/wamp64/www/wordpress/wp-content//fonts/poppins/pxiByp8kv8JHgFVrLBT5Z1JlFc-K.woff2\";s:72:\"https://fonts.gstatic.com/s/poppins/v20/pxiByp8kv8JHgFVrLBT5Z1xlFQ.woff2\";s:82:\"C:/wamp64/www/wordpress/wp-content//fonts/poppins/pxiByp8kv8JHgFVrLBT5Z1xlFQ.woff2\";}", "no");
INSERT INTO `wp_options` VALUES("125", "https_detection_errors", "a:1:{s:20:\"https_request_failed\";a:1:{i:0;s:28:\"La demande HTTPS a échoué.\";}}", "yes");
INSERT INTO `wp_options` VALUES("217", "cp_initialize_notifications", "1687473202", "yes");
INSERT INTO `wp_options` VALUES("218", "colibri_page_builder_demo_sites", "a:2:{s:9:\"timestamp\";i:1730676381;s:4:\"data\";a:99:{i:0;a:11:{s:16:\"import_file_name\";s:10:\"Business I\";s:4:\"slug\";s:8:\"business\";s:10:\"categories\";a:1:{i:0;s:8:\"business\";}s:15:\"import_file_url\";s:85:\"https://colibri-demo-sites.s3.us-west-2.amazonaws.com/production/business/content.xml\";s:22:\"import_widget_file_url\";s:85:\"https://colibri-demo-sites.s3.us-west-2.amazonaws.com/production/business/widgets.wie\";s:26:\"import_customizer_file_url\";s:88:\"https://colibri-demo-sites.s3.us-west-2.amazonaws.com/production/business/customizer.dat\";s:24:\"import_preview_image_url\";s:90:\"https://static.colibriwp.com/templates-screenshots/colibri_default_business/screenshot.png\";s:11:\"preview_url\";s:48:\"https://colibriwp-work.colibriwp.com/business-i/\";s:7:\"plugins\";a:1:{s:36:\"contact-form-7/wp-contact-form-7.php\";s:14:\"Contact Form 7\";}s:10:\"updated_at\";a:3:{s:4:\"date\";s:26:\"2019-08-02 14:44:04.000000\";s:13:\"timezone_type\";i:3;s:8:\"timezone\";s:3:\"UTC\";}s:6:\"is_pro\";i:0;}i:1;a:11:{s:16:\"import_file_name\";s:11:\"Business II\";s:4:\"slug\";s:11:\"business-ii\";s:10:\"categories\";a:1:{i:0;s:8:\"business\";}s:15:\"import_file_url\";s:88:\"https://colibri-demo-sites.s3.us-west-2.amazonaws.com/production/business-ii/content.xml\";s:22:\"import_widget_file_url\";s:88:\"https://colibri-demo-sites.s3.us-west-2.amazonaws.com/production/business-ii/widgets.wie\";s:26:\"import_customizer_file_url\";s:91:\"https://colibri-demo-sites.s3.us-west-2.amazonaws.com/production/business-ii/customizer.dat\";s:24:\"import_preview_image_url\";s:77:\"https://static.colibriwp.com/templates-screenshots/business-ii/screenshot.png\";s:11:\"preview_url\";s:48:\"https://colibriwp-work.colibriwp.com/business-ii\";s:7:\"plugins\";a:1:{s:36:\"contact-form-7/wp-contact-form-7.php\";s:14:\"Contact Form 7\";}s:10:\"updated_at\";a:3:{s:4:\"date\";s:26:\"2019-08-02 14:44:06.000000\";s:13:\"timezone_type\";i:3;s:8:\"timezone\";s:3:\"UTC\";}s:6:\"is_pro\";i:0;}i:2;a:11:{s:16:\"import_file_name\";s:7:\"Plumber\";s:4:\"slug\";s:7:\"plumber\";s:10:\"categories\";a:1:{i:0;s:8:\"services\";}s:15:\"import_file_url\";s:84:\"https://colibri-demo-sites.s3.us-west-2.amazonaws.com/production/plumber/content.xml\";s:22:\"import_widget_file_url\";s:84:\"https://colibri-demo-sites.s3.us-west-2.amazonaws.com/production/plumber/widgets.wie\";s:26:\"import_customizer_file_url\";s:87:\"https://colibri-demo-sites.s3.us-west-2.amazonaws.com/production/plumber/customizer.dat\";s:24:\"import_preview_image_url\";s:73:\"https://static.colibriwp.com/templates-screenshots/plumber/screenshot.jpg\";s:11:\"preview_url\";s:45:\"https://colibriwp-work.colibriwp.com/plumber/\";s:7:\"plugins\";a:1:{s:36:\"contact-form-7/wp-contact-form-7.php\";s:14:\"Contact Form 7\";}s:10:\"updated_at\";a:3:{s:4:\"date\";s:26:\"2019-08-02 14:44:07.000000\";s:13:\"timezone_type\";i:3;s:8:\"timezone\";s:3:\"UTC\";}s:6:\"is_pro\";i:0;}i:3;a:11:{s:16:\"import_file_name\";s:17:\"Creative Agency I\";s:4:\"slug\";s:11:\"advertising\";s:10:\"categories\";a:1:{i:0;s:8:\"business\";}s:15:\"import_file_url\";s:88:\"https://colibri-demo-sites.s3.us-west-2.amazonaws.com/production/advertising/content.xml\";s:22:\"import_widget_file_url\";s:88:\"https://colibri-demo-sites.s3.us-west-2.amazonaws.com/production/advertising/widgets.wie\";s:26:\"import_customizer_file_url\";s:91:\"https://colibri-demo-sites.s3.us-west-2.amazonaws.com/production/advertising/customizer.dat\";s:24:\"import_preview_image_url\";s:97:\"https://static.colibriwp.com/templates-screenshots/colibri_default_creative_agency/screenshot.png\";s:11:\"preview_url\";s:55:\"https://colibriwp-work.colibriwp.com/creative-agency-i/\";s:7:\"plugins\";a:1:{s:36:\"contact-form-7/wp-contact-form-7.php\";s:14:\"Contact Form 7\";}s:10:\"updated_at\";a:3:{s:4:\"date\";s:26:\"2019-08-02 14:44:09.000000\";s:13:\"timezone_type\";i:3;s:8:\"timezone\";s:3:\"UTC\";}s:6:\"is_pro\";i:1;}i:4;a:11:{s:16:\"import_file_name\";s:3:\"SEO\";s:4:\"slug\";s:3:\"seo\";s:10:\"categories\";a:1:{i:0;s:8:\"business\";}s:15:\"import_file_url\";s:80:\"https://colibri-demo-sites.s3.us-west-2.amazonaws.com/production/seo/content.xml\";s:22:\"import_widget_file_url\";s:80:\"https://colibri-demo-sites.s3.us-west-2.amazonaws.com/production/seo/widgets.wie\";s:26:\"import_customizer_file_url\";s:83:\"https://colibri-demo-sites.s3.us-west-2.amazonaws.com/production/seo/customizer.dat\";s:24:\"import_preview_image_url\";s:85:\"https://static.colibriwp.com/templates-screenshots/colibri_default_seo/screenshot.png\";s:11:\"preview_url\";s:46:\"https://colibriwp-work.colibriwp.com/seo-demo/\";s:7:\"plugins\";a:1:{s:36:\"contact-form-7/wp-contact-form-7.php\";s:14:\"Contact Form 7\";}s:10:\"updated_at\";a:3:{s:4:\"date\";s:26:\"2019-08-02 14:51:11.000000\";s:13:\"timezone_type\";i:3;s:8:\"timezone\";s:3:\"UTC\";}s:6:\"is_pro\";i:1;}i:5;a:11:{s:16:\"import_file_name\";s:11:\"IT Services\";s:4:\"slug\";s:11:\"it-services\";s:10:\"categories\";a:1:{i:0;s:8:\"services\";}s:15:\"import_file_url\";s:88:\"https://colibri-demo-sites.s3.us-west-2.amazonaws.com/production/it-services/content.xml\";s:22:\"import_widget_file_url\";s:88:\"https://colibri-demo-sites.s3.us-west-2.amazonaws.com/production/it-services/widgets.wie\";s:26:\"import_customizer_file_url\";s:91:\"https://colibri-demo-sites.s3.us-west-2.amazonaws.com/production/it-services/customizer.dat\";s:24:\"import_preview_image_url\";s:77:\"https://static.colibriwp.com/templates-screenshots/it-services/screenshot.png\";s:11:\"preview_url\";s:48:\"https://colibriwp-work.colibriwp.com/it-services\";s:7:\"plugins\";a:1:{s:36:\"contact-form-7/wp-contact-form-7.php\";s:14:\"Contact Form 7\";}s:10:\"updated_at\";a:3:{s:4:\"date\";s:26:\"2019-08-02 14:51:13.000000\";s:13:\"timezone_type\";i:3;s:8:\"timezone\";s:3:\"UTC\";}s:6:\"is_pro\";i:1;}i:6;a:11:{s:16:\"import_file_name\";s:20:\"Designer Portfolio I\";s:4:\"slug\";s:20:\"designer-portfolio-i\";s:10:\"categories\";a:1:{i:0;s:9:\"portfolio\";}s:15:\"import_file_url\";s:97:\"https://colibri-demo-sites.s3.us-west-2.amazonaws.com/production/designer-portfolio-i/content.xml\";s:22:\"import_widget_file_url\";s:97:\"https://colibri-demo-sites.s3.us-west-2.amazonaws.com/production/designer-portfolio-i/widgets.wie\";s:26:\"import_customizer_file_url\";s:100:\"https://colibri-demo-sites.s3.us-west-2.amazonaws.com/production/designer-portfolio-i/customizer.dat\";s:24:\"import_preview_image_url\";s:86:\"https://static.colibriwp.com/templates-screenshots/designer-portfolio-i/screenshot.png\";s:11:\"preview_url\";s:57:\"https://colibriwp-work.colibriwp.com/designer-portfolio-i\";s:7:\"plugins\";a:1:{s:36:\"contact-form-7/wp-contact-form-7.php\";s:14:\"Contact Form 7\";}s:10:\"updated_at\";a:3:{s:4:\"date\";s:26:\"2019-08-02 14:44:12.000000\";s:13:\"timezone_type\";i:3;s:8:\"timezone\";s:3:\"UTC\";}s:6:\"is_pro\";i:1;}i:7;a:11:{s:16:\"import_file_name\";s:21:\"Designer Portfolio II\";s:4:\"slug\";s:21:\"designer-portfolio-ii\";s:10:\"categories\";a:1:{i:0;s:9:\"portfolio\";}s:15:\"import_file_url\";s:98:\"https://colibri-demo-sites.s3.us-west-2.amazonaws.com/production/designer-portfolio-ii/content.xml\";s:22:\"import_widget_file_url\";s:98:\"https://colibri-demo-sites.s3.us-west-2.amazonaws.com/production/designer-portfolio-ii/widgets.wie\";s:26:\"import_customizer_file_url\";s:101:\"https://colibri-demo-sites.s3.us-west-2.amazonaws.com/production/designer-portfolio-ii/customizer.dat\";s:24:\"import_preview_image_url\";s:87:\"https://static.colibriwp.com/templates-screenshots/designer-portfolio-ii/screenshot.png\";s:11:\"preview_url\";s:58:\"https://colibriwp-work.colibriwp.com/designer-portfolio-ii\";s:7:\"plugins\";a:1:{s:36:\"contact-form-7/wp-contact-form-7.php\";s:14:\"Contact Form 7\";}s:10:\"updated_at\";a:3:{s:4:\"date\";s:26:\"2019-08-02 14:51:16.000000\";s:13:\"timezone_type\";i:3;s:8:\"timezone\";s:3:\"UTC\";}s:6:\"is_pro\";i:1;}i:8;a:11:{s:16:\"import_file_name\";s:12:\"Business III\";s:4:\"slug\";s:12:\"business-iii\";s:10:\"categories\";a:1:{i:0;s:8:\"business\";}s:15:\"import_file_url\";s:89:\"https://colibri-demo-sites.s3.us-west-2.amazonaws.com/production/business-iii/content.xml\";s:22:\"import_widget_file_url\";s:89:\"https://colibri-demo-sites.s3.us-west-2.amazonaws.com/production/business-iii/widgets.wie\";s:26:\"import_customizer_file_url\";s:92:\"https://colibri-demo-sites.s3.us-west-2.amazonaws.com/production/business-iii/customizer.dat\";s:24:\"import_preview_image_url\";s:78:\"https://static.colibriwp.com/templates-screenshots/business-iii/screenshot.png\";s:11:\"preview_url\";s:49:\"https://colibriwp-work.colibriwp.com/business-iii\";s:7:\"plugins\";a:1:{s:36:\"contact-form-7/wp-contact-form-7.php\";s:14:\"Contact Form 7\";}s:10:\"updated_at\";a:3:{s:4:\"date\";s:26:\"2019-08-02 14:44:17.000000\";s:13:\"timezone_type\";i:3;s:8:\"timezone\";s:3:\"UTC\";}s:6:\"is_pro\";i:1;}i:9;a:11:{s:16:\"import_file_name\";s:10:\"Restaurant\";s:4:\"slug\";s:10:\"restaurant\";s:10:\"categories\";a:1:{i:0;s:10:\"food-drink\";}s:15:\"import_file_url\";s:87:\"https://colibri-demo-sites.s3.us-west-2.amazonaws.com/production/restaurant/content.xml\";s:22:\"import_widget_file_url\";s:87:\"https://colibri-demo-sites.s3.us-west-2.amazonaws.com/production/restaurant/widgets.wie\";s:26:\"import_customizer_file_url\";s:90:\"https://colibri-demo-sites.s3.us-west-2.amazonaws.com/production/restaurant/customizer.dat\";s:24:\"import_preview_image_url\";s:92:\"https://static.colibriwp.com/templates-screenshots/colibri_default_restaurant/screenshot.png\";s:11:\"preview_url\";s:48:\"https://colibriwp-work.colibriwp.com/restaurant/\";s:7:\"plugins\";a:1:{s:36:\"contact-form-7/wp-contact-form-7.php\";s:14:\"Contact Form 7\";}s:10:\"updated_at\";a:3:{s:4:\"date\";s:26:\"2019-08-02 14:44:19.000000\";s:13:\"timezone_type\";i:3;s:8:\"timezone\";s:3:\"UTC\";}s:6:\"is_pro\";i:1;}i:10;a:11:{s:16:\"import_file_name\";s:10:\"Vineyard I\";s:4:\"slug\";s:8:\"vineyard\";s:10:\"categories\";a:1:{i:0;s:10:\"food-drink\";}s:15:\"import_file_url\";s:85:\"https://colibri-demo-sites.s3.us-west-2.amazonaws.com/production/vineyard/content.xml\";s:22:\"import_widget_file_url\";s:85:\"https://colibri-demo-sites.s3.us-west-2.amazonaws.com/production/vineyard/widgets.wie\";s:26:\"import_customizer_file_url\";s:88:\"https://colibri-demo-sites.s3.us-west-2.amazonaws.com/production/vineyard/customizer.dat\";s:24:\"import_preview_image_url\";s:74:\"https://static.colibriwp.com/templates-screenshots/vineyard/screenshot.png\";s:11:\"preview_url\";s:47:\"https://colibriwp-work.colibriwp.com/vineyard-i\";s:7:\"plugins\";a:1:{s:36:\"contact-form-7/wp-contact-form-7.php\";s:14:\"Contact Form 7\";}s:10:\"updated_at\";a:3:{s:4:\"date\";s:26:\"2019-08-02 14:44:22.000000\";s:13:\"timezone_type\";i:3;s:8:\"timezone\";s:3:\"UTC\";}s:6:\"is_pro\";i:1;}i:11;a:11:{s:16:\"import_file_name\";s:11:\"Vineyard II\";s:4:\"slug\";s:11:\"vineyard-ii\";s:10:\"categories\";a:1:{i:0;s:10:\"food-drink\";}s:15:\"import_file_url\";s:88:\"https://colibri-demo-sites.s3.us-west-2.amazonaws.com/production/vineyard-ii/content.xml\";s:22:\"import_widget_file_url\";s:88:\"https://colibri-demo-sites.s3.us-west-2.amazonaws.com/production/vineyard-ii/widgets.wie\";s:26:\"import_customizer_file_url\";s:91:\"https://colibri-demo-sites.s3.us-west-2.amazonaws.com/production/vineyard-ii/customizer.dat\";s:24:\"import_preview_image_url\";s:77:\"https://static.colibriwp.com/templates-screenshots/vineyard-ii/screenshot.png\";s:11:\"preview_url\";s:48:\"https://colibriwp-work.colibriwp.com/vineyard-ii\";s:7:\"plugins\";a:1:{s:36:\"contact-form-7/wp-contact-form-7.php\";s:14:\"Contact Form 7\";}s:10:\"updated_at\";a:3:{s:4:\"date\";s:26:\"2019-08-13 09:01:39.000000\";s:13:\"timezone_type\";i:3;s:8:\"timezone\";s:3:\"UTC\";}s:6:\"is_pro\";i:1;}i:12;a:11:{s:16:\"import_file_name\";s:9:\"My Resume\";s:4:\"slug\";s:9:\"my-resume\";s:10:\"categories\";a:1:{i:0;s:9:\"portfolio\";}s:15:\"import_file_url\";s:86:\"https://colibri-demo-sites.s3.us-west-2.amazonaws.com/production/my-resume/content.xml\";s:22:\"import_widget_file_url\";s:86:\"https://colibri-demo-sites.s3.us-west-2.amazonaws.com/production/my-resume/widgets.wie\";s:26:\"import_customizer_file_url\";s:89:\"https://colibri-demo-sites.s3.us-west-2.amazonaws.com/production/my-resume/customizer.dat\";s:24:\"import_preview_image_url\";s:91:\"https://static.colibriwp.com/templates-screenshots/colibri_default_my-resume/screenshot.png\";s:11:\"preview_url\";s:47:\"https://colibriwp-work.colibriwp.com/my-resume/\";s:7:\"plugins\";a:1:{s:36:\"contact-form-7/wp-contact-form-7.php\";s:14:\"Contact Form 7\";}s:10:\"updated_at\";a:3:{s:4:\"date\";s:26:\"2019-08-02 14:44:24.000000\";s:13:\"timezone_type\";i:3;s:8:\"timezone\";s:3:\"UTC\";}s:6:\"is_pro\";i:1;}i:13;a:11:{s:16:\"import_file_name\";s:7:\"Lawyers\";s:4:\"slug\";s:7:\"lawyers\";s:10:\"categories\";a:1:{i:0;s:8:\"services\";}s:15:\"import_file_url\";s:84:\"https://colibri-demo-sites.s3.us-west-2.amazonaws.com/production/lawyers/content.xml\";s:22:\"import_widget_file_url\";s:84:\"https://colibri-demo-sites.s3.us-west-2.amazonaws.com/production/lawyers/widgets.wie\";s:26:\"import_customizer_file_url\";s:87:\"https://colibri-demo-sites.s3.us-west-2.amazonaws.com/production/lawyers/customizer.dat\";s:24:\"import_preview_image_url\";s:73:\"https://static.colibriwp.com/templates-screenshots/lawyers/screenshot.png\";s:11:\"preview_url\";s:44:\"https://colibriwp-work.colibriwp.com/lawyers\";s:7:\"plugins\";a:1:{s:36:\"contact-form-7/wp-contact-form-7.php\";s:14:\"Contact Form 7\";}s:10:\"updated_at\";a:3:{s:4:\"date\";s:26:\"2019-08-02 14:51:24.000000\";s:13:\"timezone_type\";i:3;s:8:\"timezone\";s:3:\"UTC\";}s:6:\"is_pro\";i:1;}i:14;a:11:{s:16:\"import_file_name\";s:10:\"Conference\";s:4:\"slug\";s:10:\"conference\";s:10:\"categories\";a:1:{i:0;s:8:\"business\";}s:15:\"import_file_url\";s:87:\"https://colibri-demo-sites.s3.us-west-2.amazonaws.com/production/conference/content.xml\";s:22:\"import_widget_file_url\";s:87:\"https://colibri-demo-sites.s3.us-west-2.amazonaws.com/production/conference/widgets.wie\";s:26:\"import_customizer_file_url\";s:90:\"https://colibri-demo-sites.s3.us-west-2.amazonaws.com/production/conference/customizer.dat\";s:24:\"import_preview_image_url\";s:76:\"https://static.colibriwp.com/templates-screenshots/conference/screenshot.jpg\";s:11:\"preview_url\";s:47:\"https://colibriwp-work.colibriwp.com/conference\";s:7:\"plugins\";a:1:{s:36:\"contact-form-7/wp-contact-form-7.php\";s:14:\"Contact Form 7\";}s:10:\"updated_at\";a:3:{s:4:\"date\";s:26:\"2019-08-13 09:02:11.000000\";s:13:\"timezone_type\";i:3;s:8:\"timezone\";s:3:\"UTC\";}s:6:\"is_pro\";i:1;}i:15;a:11:{s:16:\"import_file_name\";s:17:\"Wedding Planner I\";s:4:\"slug\";s:17:\"wedding-planner-i\";s:10:\"categories\";a:1:{i:0;s:8:\"services\";}s:15:\"import_file_url\";s:94:\"https://colibri-demo-sites.s3.us-west-2.amazonaws.com/production/wedding-planner-i/content.xml\";s:22:\"import_widget_file_url\";s:94:\"https://colibri-demo-sites.s3.us-west-2.amazonaws.com/production/wedding-planner-i/widgets.wie\";s:26:\"import_customizer_file_url\";s:97:\"https://colibri-demo-sites.s3.us-west-2.amazonaws.com/production/wedding-planner-i/customizer.dat\";s:24:\"import_preview_image_url\";s:83:\"https://static.colibriwp.com/templates-screenshots/wedding-planner-i/screenshot.jpg\";s:11:\"preview_url\";s:54:\"https://colibriwp-work.colibriwp.com/wedding-planner-i\";s:7:\"plugins\";a:1:{s:36:\"contact-form-7/wp-contact-form-7.php\";s:14:\"Contact Form 7\";}s:10:\"updated_at\";a:3:{s:4:\"date\";s:26:\"2019-08-13 09:02:12.000000\";s:13:\"timezone_type\";i:3;s:8:\"timezone\";s:3:\"UTC\";}s:6:\"is_pro\";i:1;}i:16;a:11:{s:16:\"import_file_name\";s:18:\"Wedding Planner II\";s:4:\"slug\";s:18:\"wedding-planner-ii\";s:10:\"categories\";a:1:{i:0;s:8:\"services\";}s:15:\"import_file_url\";s:95:\"https://colibri-demo-sites.s3.us-west-2.amazonaws.com/production/wedding-planner-ii/content.xml\";s:22:\"import_widget_file_url\";s:95:\"https://colibri-demo-sites.s3.us-west-2.amazonaws.com/production/wedding-planner-ii/widgets.wie\";s:26:\"import_customizer_file_url\";s:98:\"https://colibri-demo-sites.s3.us-west-2.amazonaws.com/production/wedding-planner-ii/customizer.dat\";s:24:\"import_preview_image_url\";s:84:\"https://static.colibriwp.com/templates-screenshots/wedding-planner-ii/screenshot.png\";s:11:\"preview_url\";s:55:\"https://colibriwp-work.colibriwp.com/wedding-planner-ii\";s:7:\"plugins\";a:1:{s:36:\"contact-form-7/wp-contact-form-7.php\";s:14:\"Contact Form 7\";}s:10:\"updated_at\";a:3:{s:4:\"date\";s:26:\"2019-08-02 14:44:27.000000\";s:13:\"timezone_type\";i:3;s:8:\"timezone\";s:3:\"UTC\";}s:6:\"is_pro\";i:1;}i:17;a:11:{s:16:\"import_file_name\";s:12:\"Architecture\";s:4:\"slug\";s:12:\"architecture\";s:10:\"categories\";a:1:{i:0;s:8:\"business\";}s:15:\"import_file_url\";s:89:\"https://colibri-demo-sites.s3.us-west-2.amazonaws.com/production/architecture/content.xml\";s:22:\"import_widget_file_url\";s:89:\"https://colibri-demo-sites.s3.us-west-2.amazonaws.com/production/architecture/widgets.wie\";s:26:\"import_customizer_file_url\";s:92:\"https://colibri-demo-sites.s3.us-west-2.amazonaws.com/production/architecture/customizer.dat\";s:24:\"import_preview_image_url\";s:94:\"https://static.colibriwp.com/templates-screenshots/colibri_default_architecture/screenshot.png\";s:11:\"preview_url\";s:50:\"https://colibriwp-work.colibriwp.com/architecture/\";s:7:\"plugins\";a:1:{s:36:\"contact-form-7/wp-contact-form-7.php\";s:14:\"Contact Form 7\";}s:10:\"updated_at\";a:3:{s:4:\"date\";s:26:\"2019-08-02 14:51:27.000000\";s:13:\"timezone_type\";i:3;s:8:\"timezone\";s:3:\"UTC\";}s:6:\"is_pro\";i:1;}i:18;a:11:{s:16:\"import_file_name\";s:6:\"Barber\";s:4:\"slug\";s:6:\"barber\";s:10:\"categories\";a:1:{i:0;s:8:\"business\";}s:15:\"import_file_url\";s:83:\"https://colibri-demo-sites.s3.us-west-2.amazonaws.com/production/barber/content.xml\";s:22:\"import_widget_file_url\";s:83:\"https://colibri-demo-sites.s3.us-west-2.amazonaws.com/production/barber/widgets.wie\";s:26:\"import_customizer_file_url\";s:86:\"https://colibri-demo-sites.s3.us-west-2.amazonaws.com/production/barber/customizer.dat\";s:24:\"import_preview_image_url\";s:77:\"https://static.colibriwp.com/templates-screenshots/template-21/screenshot.jpg\";s:11:\"preview_url\";s:43:\"https://colibriwp-work.colibriwp.com/barber\";s:7:\"plugins\";a:2:{s:36:\"contact-form-7/wp-contact-form-7.php\";s:14:\"Contact Form 7\";s:37:\"mailchimp-for-wp/mailchimp-for-wp.php\";s:30:\"MC4WP: Mailchimp for WordPress\";}s:10:\"updated_at\";a:3:{s:4:\"date\";s:26:\"2021-03-22 09:05:40.000000\";s:13:\"timezone_type\";i:3;s:8:\"timezone\";s:3:\"UTC\";}s:6:\"is_pro\";i:1;}i:19;a:11:{s:16:\"import_file_name\";s:8:\"Coffee I\";s:4:\"slug\";s:8:\"coffee-i\";s:10:\"categories\";a:1:{i:0;s:10:\"food-drink\";}s:15:\"import_file_url\";s:85:\"https://colibri-demo-sites.s3.us-west-2.amazonaws.com/production/coffee-i/content.xml\";s:22:\"import_widget_file_url\";s:85:\"https://colibri-demo-sites.s3.us-west-2.amazonaws.com/production/coffee-i/widgets.wie\";s:26:\"import_customizer_file_url\";s:88:\"https://colibri-demo-sites.s3.us-west-2.amazonaws.com/production/coffee-i/customizer.dat\";s:24:\"import_preview_image_url\";s:74:\"https://static.colibriwp.com/templates-screenshots/coffee-i/screenshot.png\";s:11:\"preview_url\";s:45:\"https://colibriwp-work.colibriwp.com/coffee-i\";s:7:\"plugins\";a:1:{s:36:\"contact-form-7/wp-contact-form-7.php\";s:14:\"Contact Form 7\";}s:10:\"updated_at\";a:3:{s:4:\"date\";s:26:\"2019-08-13 09:02:18.000000\";s:13:\"timezone_type\";i:3;s:8:\"timezone\";s:3:\"UTC\";}s:6:\"is_pro\";i:1;}i:20;a:11:{s:16:\"import_file_name\";s:9:\"Coffee II\";s:4:\"slug\";s:9:\"coffee-ii\";s:10:\"categories\";a:1:{i:0;s:10:\"food-drink\";}s:15:\"import_file_url\";s:86:\"https://colibri-demo-sites.s3.us-west-2.amazonaws.com/production/coffee-ii/content.xml\";s:22:\"import_widget_file_url\";s:86:\"https://colibri-demo-sites.s3.us-west-2.amazonaws.com/production/coffee-ii/widgets.wie\";s:26:\"import_customizer_file_url\";s:89:\"https://colibri-demo-sites.s3.us-west-2.amazonaws.com/production/coffee-ii/customizer.dat\";s:24:\"import_preview_image_url\";s:75:\"https://static.colibriwp.com/templates-screenshots/coffee-ii/screenshot.png\";s:11:\"preview_url\";s:46:\"https://colibriwp-work.colibriwp.com/coffee-ii\";s:7:\"plugins\";a:1:{s:36:\"contact-form-7/wp-contact-form-7.php\";s:14:\"Contact Form 7\";}s:10:\"updated_at\";a:3:{s:4:\"date\";s:26:\"2019-08-13 09:02:20.000000\";s:13:\"timezone_type\";i:3;s:8:\"timezone\";s:3:\"UTC\";}s:6:\"is_pro\";i:1;}i:21;a:11:{s:16:\"import_file_name\";s:15:\"Interior Design\";s:4:\"slug\";s:15:\"interior-design\";s:10:\"categories\";a:1:{i:0;s:8:\"services\";}s:15:\"import_file_url\";s:92:\"https://colibri-demo-sites.s3.us-west-2.amazonaws.com/production/interior-design/content.xml\";s:22:\"import_widget_file_url\";s:92:\"https://colibri-demo-sites.s3.us-west-2.amazonaws.com/production/interior-design/widgets.wie\";s:26:\"import_customizer_file_url\";s:95:\"https://colibri-demo-sites.s3.us-west-2.amazonaws.com/production/interior-design/customizer.dat\";s:24:\"import_preview_image_url\";s:81:\"https://static.colibriwp.com/templates-screenshots/interior-design/screenshot.png\";s:11:\"preview_url\";s:52:\"https://colibriwp-work.colibriwp.com/interior-design\";s:7:\"plugins\";a:1:{s:36:\"contact-form-7/wp-contact-form-7.php\";s:14:\"Contact Form 7\";}s:10:\"updated_at\";a:3:{s:4:\"date\";s:26:\"2019-08-02 14:51:33.000000\";s:13:\"timezone_type\";i:3;s:8:\"timezone\";s:3:\"UTC\";}s:6:\"is_pro\";i:1;}i:22;a:11:{s:16:\"import_file_name\";s:4:\"Yoga\";s:4:\"slug\";s:4:\"yoga\";s:10:\"categories\";a:1:{i:0;s:12:\"sport-travel\";}s:15:\"import_file_url\";s:81:\"https://colibri-demo-sites.s3.us-west-2.amazonaws.com/production/yoga/content.xml\";s:22:\"import_widget_file_url\";s:81:\"https://colibri-demo-sites.s3.us-west-2.amazonaws.com/production/yoga/widgets.wie\";s:26:\"import_customizer_file_url\";s:84:\"https://colibri-demo-sites.s3.us-west-2.amazonaws.com/production/yoga/customizer.dat\";s:24:\"import_preview_image_url\";s:70:\"https://static.colibriwp.com/templates-screenshots/yoga/screenshot.png\";s:11:\"preview_url\";s:41:\"https://colibriwp-work.colibriwp.com/yoga\";s:7:\"plugins\";a:1:{s:36:\"contact-form-7/wp-contact-form-7.php\";s:14:\"Contact Form 7\";}s:10:\"updated_at\";a:3:{s:4:\"date\";s:26:\"2019-08-02 14:44:32.000000\";s:13:\"timezone_type\";i:3;s:8:\"timezone\";s:3:\"UTC\";}s:6:\"is_pro\";i:1;}i:23;a:11:{s:16:\"import_file_name\";s:13:\"Constructions\";s:4:\"slug\";s:13:\"constructions\";s:10:\"categories\";a:1:{i:0;s:8:\"services\";}s:15:\"import_file_url\";s:90:\"https://colibri-demo-sites.s3.us-west-2.amazonaws.com/production/constructions/content.xml\";s:22:\"import_widget_file_url\";s:90:\"https://colibri-demo-sites.s3.us-west-2.amazonaws.com/production/constructions/widgets.wie\";s:26:\"import_customizer_file_url\";s:93:\"https://colibri-demo-sites.s3.us-west-2.amazonaws.com/production/constructions/customizer.dat\";s:24:\"import_preview_image_url\";s:79:\"https://static.colibriwp.com/templates-screenshots/constructions/screenshot.png\";s:11:\"preview_url\";s:50:\"https://colibriwp-work.colibriwp.com/constructions\";s:7:\"plugins\";a:1:{s:36:\"contact-form-7/wp-contact-form-7.php\";s:14:\"Contact Form 7\";}s:10:\"updated_at\";a:3:{s:4:\"date\";s:26:\"2019-08-02 14:51:35.000000\";s:13:\"timezone_type\";i:3;s:8:\"timezone\";s:3:\"UTC\";}s:6:\"is_pro\";i:1;}i:24;a:11:{s:16:\"import_file_name\";s:11:\"Pets Clinic\";s:4:\"slug\";s:11:\"pets-clinic\";s:10:\"categories\";a:1:{i:0;s:8:\"services\";}s:15:\"import_file_url\";s:88:\"https://colibri-demo-sites.s3.us-west-2.amazonaws.com/production/pets-clinic/content.xml\";s:22:\"import_widget_file_url\";s:88:\"https://colibri-demo-sites.s3.us-west-2.amazonaws.com/production/pets-clinic/widgets.wie\";s:26:\"import_customizer_file_url\";s:91:\"https://colibri-demo-sites.s3.us-west-2.amazonaws.com/production/pets-clinic/customizer.dat\";s:24:\"import_preview_image_url\";s:77:\"https://static.colibriwp.com/templates-screenshots/pets-clinic/screenshot.png\";s:11:\"preview_url\";s:48:\"https://colibriwp-work.colibriwp.com/pets-clinic\";s:7:\"plugins\";a:1:{s:36:\"contact-form-7/wp-contact-form-7.php\";s:14:\"Contact Form 7\";}s:10:\"updated_at\";a:3:{s:4:\"date\";s:26:\"2019-08-02 14:51:37.000000\";s:13:\"timezone_type\";i:3;s:8:\"timezone\";s:3:\"UTC\";}s:6:\"is_pro\";i:1;}i:25;a:11:{s:16:\"import_file_name\";s:10:\"Ski Resort\";s:4:\"slug\";s:10:\"ski-resort\";s:10:\"categories\";a:1:{i:0;s:12:\"sport-travel\";}s:15:\"import_file_url\";s:87:\"https://colibri-demo-sites.s3.us-west-2.amazonaws.com/production/ski-resort/content.xml\";s:22:\"import_widget_file_url\";s:87:\"https://colibri-demo-sites.s3.us-west-2.amazonaws.com/production/ski-resort/widgets.wie\";s:26:\"import_customizer_file_url\";s:90:\"https://colibri-demo-sites.s3.us-west-2.amazonaws.com/production/ski-resort/customizer.dat\";s:24:\"import_preview_image_url\";s:76:\"https://static.colibriwp.com/templates-screenshots/ski-resort/screenshot.png\";s:11:\"preview_url\";s:47:\"https://colibriwp-work.colibriwp.com/ski-resort\";s:7:\"plugins\";a:1:{s:36:\"contact-form-7/wp-contact-form-7.php\";s:14:\"Contact Form 7\";}s:10:\"updated_at\";a:3:{s:4:\"date\";s:26:\"2019-08-02 14:51:39.000000\";s:13:\"timezone_type\";i:3;s:8:\"timezone\";s:3:\"UTC\";}s:6:\"is_pro\";i:1;}i:26;a:11:{s:16:\"import_file_name\";s:18:\"Creative Agency II\";s:4:\"slug\";s:18:\"creative-agency-ii\";s:10:\"categories\";a:1:{i:0;s:8:\"business\";}s:15:\"import_file_url\";s:95:\"https://colibri-demo-sites.s3.us-west-2.amazonaws.com/production/creative-agency-ii/content.xml\";s:22:\"import_widget_file_url\";s:95:\"https://colibri-demo-sites.s3.us-west-2.amazonaws.com/production/creative-agency-ii/widgets.wie\";s:26:\"import_customizer_file_url\";s:98:\"https://colibri-demo-sites.s3.us-west-2.amazonaws.com/production/creative-agency-ii/customizer.dat\";s:24:\"import_preview_image_url\";s:84:\"https://static.colibriwp.com/templates-screenshots/creative-agency-ii/screenshot.png\";s:11:\"preview_url\";s:55:\"https://colibriwp-work.colibriwp.com/creative-agency-ii\";s:7:\"plugins\";a:1:{s:36:\"contact-form-7/wp-contact-form-7.php\";s:14:\"Contact Form 7\";}s:10:\"updated_at\";a:3:{s:4:\"date\";s:26:\"2019-08-02 14:44:39.000000\";s:13:\"timezone_type\";i:3;s:8:\"timezone\";s:3:\"UTC\";}s:6:\"is_pro\";i:1;}i:27;a:11:{s:16:\"import_file_name\";s:5:\"Sushi\";s:4:\"slug\";s:5:\"sushi\";s:10:\"categories\";a:1:{i:0;s:10:\"food-drink\";}s:15:\"import_file_url\";s:82:\"https://colibri-demo-sites.s3.us-west-2.amazonaws.com/production/sushi/content.xml\";s:22:\"import_widget_file_url\";s:82:\"https://colibri-demo-sites.s3.us-west-2.amazonaws.com/production/sushi/widgets.wie\";s:26:\"import_customizer_file_url\";s:85:\"https://colibri-demo-sites.s3.us-west-2.amazonaws.com/production/sushi/customizer.dat\";s:24:\"import_preview_image_url\";s:71:\"https://static.colibriwp.com/templates-screenshots/sushi/screenshot.png\";s:11:\"preview_url\";s:42:\"https://colibriwp-work.colibriwp.com/sushi\";s:7:\"plugins\";a:1:{s:36:\"contact-form-7/wp-contact-form-7.php\";s:14:\"Contact Form 7\";}s:10:\"updated_at\";a:3:{s:4:\"date\";s:26:\"2019-08-02 14:44:42.000000\";s:13:\"timezone_type\";i:3;s:8:\"timezone\";s:3:\"UTC\";}s:6:\"is_pro\";i:1;}i:28;a:11:{s:16:\"import_file_name\";s:22:\"Designer Portfolio III\";s:4:\"slug\";s:22:\"designer-portfolio-iii\";s:10:\"categories\";a:1:{i:0;s:9:\"portfolio\";}s:15:\"import_file_url\";s:99:\"https://colibri-demo-sites.s3.us-west-2.amazonaws.com/production/designer-portfolio-iii/content.xml\";s:22:\"import_widget_file_url\";s:99:\"https://colibri-demo-sites.s3.us-west-2.amazonaws.com/production/designer-portfolio-iii/widgets.wie\";s:26:\"import_customizer_file_url\";s:102:\"https://colibri-demo-sites.s3.us-west-2.amazonaws.com/production/designer-portfolio-iii/customizer.dat\";s:24:\"import_preview_image_url\";s:88:\"https://static.colibriwp.com/templates-screenshots/designer-portfolio-iii/screenshot.png\";s:11:\"preview_url\";s:59:\"https://colibriwp-work.colibriwp.com/designer-portfolio-iii\";s:7:\"plugins\";a:1:{s:36:\"contact-form-7/wp-contact-form-7.php\";s:14:\"Contact Form 7\";}s:10:\"updated_at\";a:3:{s:4:\"date\";s:26:\"2019-08-02 14:51:44.000000\";s:13:\"timezone_type\";i:3;s:8:\"timezone\";s:3:\"UTC\";}s:6:\"is_pro\";i:1;}i:29;a:11:{s:16:\"import_file_name\";s:3:\"Gym\";s:4:\"slug\";s:3:\"gym\";s:10:\"categories\";a:1:{i:0;s:12:\"sport-travel\";}s:15:\"import_file_url\";s:80:\"https://colibri-demo-sites.s3.us-west-2.amazonaws.com/production/gym/content.xml\";s:22:\"import_widget_file_url\";s:80:\"https://colibri-demo-sites.s3.us-west-2.amazonaws.com/production/gym/widgets.wie\";s:26:\"import_customizer_file_url\";s:83:\"https://colibri-demo-sites.s3.us-west-2.amazonaws.com/production/gym/customizer.dat\";s:24:\"import_preview_image_url\";s:85:\"https://static.colibriwp.com/templates-screenshots/colibri_default_gym/screenshot.png\";s:11:\"preview_url\";s:46:\"https://colibriwp-work.colibriwp.com/gym-demo/\";s:7:\"plugins\";a:1:{s:36:\"contact-form-7/wp-contact-form-7.php\";s:14:\"Contact Form 7\";}s:10:\"updated_at\";a:3:{s:4:\"date\";s:26:\"2019-08-02 14:51:46.000000\";s:13:\"timezone_type\";i:3;s:8:\"timezone\";s:3:\"UTC\";}s:6:\"is_pro\";i:1;}i:30;a:11:{s:16:\"import_file_name\";s:9:\"Religious\";s:4:\"slug\";s:9:\"religious\";s:10:\"categories\";a:1:{i:0;s:9:\"community\";}s:15:\"import_file_url\";s:86:\"https://colibri-demo-sites.s3.us-west-2.amazonaws.com/production/religious/content.xml\";s:22:\"import_widget_file_url\";s:86:\"https://colibri-demo-sites.s3.us-west-2.amazonaws.com/production/religious/widgets.wie\";s:26:\"import_customizer_file_url\";s:89:\"https://colibri-demo-sites.s3.us-west-2.amazonaws.com/production/religious/customizer.dat\";s:24:\"import_preview_image_url\";s:75:\"https://static.colibriwp.com/templates-screenshots/religious/screenshot.jpg\";s:11:\"preview_url\";s:47:\"https://colibriwp-work.colibriwp.com/religious/\";s:7:\"plugins\";a:1:{s:36:\"contact-form-7/wp-contact-form-7.php\";s:14:\"Contact Form 7\";}s:10:\"updated_at\";a:3:{s:4:\"date\";s:26:\"2019-08-13 09:02:34.000000\";s:13:\"timezone_type\";i:3;s:8:\"timezone\";s:3:\"UTC\";}s:6:\"is_pro\";i:1;}i:31;a:11:{s:16:\"import_file_name\";s:14:\"Medical Clinic\";s:4:\"slug\";s:17:\"medical-clinic-ii\";s:10:\"categories\";a:1:{i:0;s:8:\"services\";}s:15:\"import_file_url\";s:94:\"https://colibri-demo-sites.s3.us-west-2.amazonaws.com/production/medical-clinic-ii/content.xml\";s:22:\"import_widget_file_url\";s:94:\"https://colibri-demo-sites.s3.us-west-2.amazonaws.com/production/medical-clinic-ii/widgets.wie\";s:26:\"import_customizer_file_url\";s:97:\"https://colibri-demo-sites.s3.us-west-2.amazonaws.com/production/medical-clinic-ii/customizer.dat\";s:24:\"import_preview_image_url\";s:83:\"https://static.colibriwp.com/templates-screenshots/medical-clinic-ii/screenshot.png\";s:11:\"preview_url\";s:55:\"https://colibriwp-work.colibriwp.com/medical-clinic-ii/\";s:7:\"plugins\";a:1:{s:36:\"contact-form-7/wp-contact-form-7.php\";s:14:\"Contact Form 7\";}s:10:\"updated_at\";a:3:{s:4:\"date\";s:26:\"2019-08-13 09:02:36.000000\";s:13:\"timezone_type\";i:3;s:8:\"timezone\";s:3:\"UTC\";}s:6:\"is_pro\";i:1;}i:32;a:11:{s:16:\"import_file_name\";s:5:\"Detox\";s:4:\"slug\";s:5:\"detox\";s:10:\"categories\";a:1:{i:0;s:10:\"food-drink\";}s:15:\"import_file_url\";s:82:\"https://colibri-demo-sites.s3.us-west-2.amazonaws.com/production/detox/content.xml\";s:22:\"import_widget_file_url\";s:82:\"https://colibri-demo-sites.s3.us-west-2.amazonaws.com/production/detox/widgets.wie\";s:26:\"import_customizer_file_url\";s:85:\"https://colibri-demo-sites.s3.us-west-2.amazonaws.com/production/detox/customizer.dat\";s:24:\"import_preview_image_url\";s:71:\"https://static.colibriwp.com/templates-screenshots/detox/screenshot.png\";s:11:\"preview_url\";s:43:\"https://colibriwp-work.colibriwp.com/detox/\";s:7:\"plugins\";a:1:{s:36:\"contact-form-7/wp-contact-form-7.php\";s:14:\"Contact Form 7\";}s:10:\"updated_at\";a:3:{s:4:\"date\";s:26:\"2019-08-13 09:02:37.000000\";s:13:\"timezone_type\";i:3;s:8:\"timezone\";s:3:\"UTC\";}s:6:\"is_pro\";i:1;}i:33;a:11:{s:16:\"import_file_name\";s:6:\"School\";s:4:\"slug\";s:6:\"school\";s:10:\"categories\";a:1:{i:0;s:9:\"community\";}s:15:\"import_file_url\";s:83:\"https://colibri-demo-sites.s3.us-west-2.amazonaws.com/production/school/content.xml\";s:22:\"import_widget_file_url\";s:83:\"https://colibri-demo-sites.s3.us-west-2.amazonaws.com/production/school/widgets.wie\";s:26:\"import_customizer_file_url\";s:86:\"https://colibri-demo-sites.s3.us-west-2.amazonaws.com/production/school/customizer.dat\";s:24:\"import_preview_image_url\";s:72:\"https://static.colibriwp.com/templates-screenshots/school/screenshot.png\";s:11:\"preview_url\";s:44:\"https://colibriwp-work.colibriwp.com/school/\";s:7:\"plugins\";a:1:{s:36:\"contact-form-7/wp-contact-form-7.php\";s:14:\"Contact Form 7\";}s:10:\"updated_at\";a:3:{s:4:\"date\";s:26:\"2019-08-13 09:02:39.000000\";s:13:\"timezone_type\";i:3;s:8:\"timezone\";s:3:\"UTC\";}s:6:\"is_pro\";i:1;}i:34;a:11:{s:16:\"import_file_name\";s:6:\"Movers\";s:4:\"slug\";s:6:\"movers\";s:10:\"categories\";a:1:{i:0;s:8:\"services\";}s:15:\"import_file_url\";s:83:\"https://colibri-demo-sites.s3.us-west-2.amazonaws.com/production/movers/content.xml\";s:22:\"import_widget_file_url\";s:83:\"https://colibri-demo-sites.s3.us-west-2.amazonaws.com/production/movers/widgets.wie\";s:26:\"import_customizer_file_url\";s:86:\"https://colibri-demo-sites.s3.us-west-2.amazonaws.com/production/movers/customizer.dat\";s:24:\"import_preview_image_url\";s:72:\"https://static.colibriwp.com/templates-screenshots/movers/screenshot.png\";s:11:\"preview_url\";s:44:\"https://colibriwp-work.colibriwp.com/movers/\";s:7:\"plugins\";a:1:{s:36:\"contact-form-7/wp-contact-form-7.php\";s:14:\"Contact Form 7\";}s:10:\"updated_at\";a:3:{s:4:\"date\";s:26:\"2019-08-13 09:02:40.000000\";s:13:\"timezone_type\";i:3;s:8:\"timezone\";s:3:\"UTC\";}s:6:\"is_pro\";i:1;}i:35;a:11:{s:16:\"import_file_name\";s:8:\"Aquarium\";s:4:\"slug\";s:8:\"aquarium\";s:10:\"categories\";a:1:{i:0;s:9:\"community\";}s:15:\"import_file_url\";s:85:\"https://colibri-demo-sites.s3.us-west-2.amazonaws.com/production/aquarium/content.xml\";s:22:\"import_widget_file_url\";s:85:\"https://colibri-demo-sites.s3.us-west-2.amazonaws.com/production/aquarium/widgets.wie\";s:26:\"import_customizer_file_url\";s:88:\"https://colibri-demo-sites.s3.us-west-2.amazonaws.com/production/aquarium/customizer.dat\";s:24:\"import_preview_image_url\";s:74:\"https://static.colibriwp.com/templates-screenshots/aquarium/screenshot.png\";s:11:\"preview_url\";s:46:\"https://colibriwp-work.colibriwp.com/aquarium/\";s:7:\"plugins\";a:1:{s:36:\"contact-form-7/wp-contact-form-7.php\";s:14:\"Contact Form 7\";}s:10:\"updated_at\";a:3:{s:4:\"date\";s:26:\"2019-08-13 09:02:42.000000\";s:13:\"timezone_type\";i:3;s:8:\"timezone\";s:3:\"UTC\";}s:6:\"is_pro\";i:1;}i:36;a:11:{s:16:\"import_file_name\";s:4:\"Auto\";s:4:\"slug\";s:4:\"auto\";s:10:\"categories\";a:1:{i:0;s:8:\"services\";}s:15:\"import_file_url\";s:81:\"https://colibri-demo-sites.s3.us-west-2.amazonaws.com/production/auto/content.xml\";s:22:\"import_widget_file_url\";s:81:\"https://colibri-demo-sites.s3.us-west-2.amazonaws.com/production/auto/widgets.wie\";s:26:\"import_customizer_file_url\";s:84:\"https://colibri-demo-sites.s3.us-west-2.amazonaws.com/production/auto/customizer.dat\";s:24:\"import_preview_image_url\";s:70:\"https://static.colibriwp.com/templates-screenshots/auto/screenshot.png\";s:11:\"preview_url\";s:42:\"https://colibriwp-work.colibriwp.com/auto/\";s:7:\"plugins\";a:1:{s:36:\"contact-form-7/wp-contact-form-7.php\";s:14:\"Contact Form 7\";}s:10:\"updated_at\";a:3:{s:4:\"date\";s:26:\"2019-08-13 09:02:44.000000\";s:13:\"timezone_type\";i:3;s:8:\"timezone\";s:3:\"UTC\";}s:6:\"is_pro\";i:1;}i:37;a:11:{s:16:\"import_file_name\";s:10:\"Business V\";s:4:\"slug\";s:10:\"business-v\";s:10:\"categories\";a:1:{i:0;s:8:\"business\";}s:15:\"import_file_url\";s:87:\"https://colibri-demo-sites.s3.us-west-2.amazonaws.com/production/business-v/content.xml\";s:22:\"import_widget_file_url\";s:87:\"https://colibri-demo-sites.s3.us-west-2.amazonaws.com/production/business-v/widgets.wie\";s:26:\"import_customizer_file_url\";s:90:\"https://colibri-demo-sites.s3.us-west-2.amazonaws.com/production/business-v/customizer.dat\";s:24:\"import_preview_image_url\";s:76:\"https://static.colibriwp.com/templates-screenshots/business-v/screenshot.png\";s:11:\"preview_url\";s:48:\"https://colibriwp-work.colibriwp.com/business-v/\";s:7:\"plugins\";a:1:{s:36:\"contact-form-7/wp-contact-form-7.php\";s:14:\"Contact Form 7\";}s:10:\"updated_at\";a:3:{s:4:\"date\";s:26:\"2019-08-13 09:02:47.000000\";s:13:\"timezone_type\";i:3;s:8:\"timezone\";s:3:\"UTC\";}s:6:\"is_pro\";i:1;}i:38;a:11:{s:16:\"import_file_name\";s:7:\"Charity\";s:4:\"slug\";s:7:\"charity\";s:10:\"categories\";a:1:{i:0;s:9:\"community\";}s:15:\"import_file_url\";s:84:\"https://colibri-demo-sites.s3.us-west-2.amazonaws.com/production/charity/content.xml\";s:22:\"import_widget_file_url\";s:84:\"https://colibri-demo-sites.s3.us-west-2.amazonaws.com/production/charity/widgets.wie\";s:26:\"import_customizer_file_url\";s:87:\"https://colibri-demo-sites.s3.us-west-2.amazonaws.com/production/charity/customizer.dat\";s:24:\"import_preview_image_url\";s:73:\"https://static.colibriwp.com/templates-screenshots/charity/screenshot.png\";s:11:\"preview_url\";s:45:\"https://colibriwp-work.colibriwp.com/charity/\";s:7:\"plugins\";a:1:{s:36:\"contact-form-7/wp-contact-form-7.php\";s:14:\"Contact Form 7\";}s:10:\"updated_at\";a:3:{s:4:\"date\";s:26:\"2019-08-13 09:02:48.000000\";s:13:\"timezone_type\";i:3;s:8:\"timezone\";s:3:\"UTC\";}s:6:\"is_pro\";i:1;}i:39;a:11:{s:16:\"import_file_name\";s:13:\"Makeup Artist\";s:4:\"slug\";s:13:\"makeup-artist\";s:10:\"categories\";a:1:{i:0;s:8:\"business\";}s:15:\"import_file_url\";s:90:\"https://colibri-demo-sites.s3.us-west-2.amazonaws.com/production/makeup-artist/content.xml\";s:22:\"import_widget_file_url\";s:90:\"https://colibri-demo-sites.s3.us-west-2.amazonaws.com/production/makeup-artist/widgets.wie\";s:26:\"import_customizer_file_url\";s:93:\"https://colibri-demo-sites.s3.us-west-2.amazonaws.com/production/makeup-artist/customizer.dat\";s:24:\"import_preview_image_url\";s:79:\"https://static.colibriwp.com/templates-screenshots/makeup-artist/screenshot.png\";s:11:\"preview_url\";s:51:\"https://colibriwp-work.colibriwp.com/makeup-artist/\";s:7:\"plugins\";a:1:{s:36:\"contact-form-7/wp-contact-form-7.php\";s:14:\"Contact Form 7\";}s:10:\"updated_at\";a:3:{s:4:\"date\";s:26:\"2019-08-13 09:02:50.000000\";s:13:\"timezone_type\";i:3;s:8:\"timezone\";s:3:\"UTC\";}s:6:\"is_pro\";i:1;}i:40;a:11:{s:16:\"import_file_name\";s:10:\"Mobile App\";s:4:\"slug\";s:10:\"mobile-app\";s:10:\"categories\";a:1:{i:0;s:8:\"business\";}s:15:\"import_file_url\";s:87:\"https://colibri-demo-sites.s3.us-west-2.amazonaws.com/production/mobile-app/content.xml\";s:22:\"import_widget_file_url\";s:87:\"https://colibri-demo-sites.s3.us-west-2.amazonaws.com/production/mobile-app/widgets.wie\";s:26:\"import_customizer_file_url\";s:90:\"https://colibri-demo-sites.s3.us-west-2.amazonaws.com/production/mobile-app/customizer.dat\";s:24:\"import_preview_image_url\";s:76:\"https://static.colibriwp.com/templates-screenshots/mobile-app/screenshot.png\";s:11:\"preview_url\";s:48:\"https://colibriwp-work.colibriwp.com/mobile-app/\";s:7:\"plugins\";a:1:{s:36:\"contact-form-7/wp-contact-form-7.php\";s:14:\"Contact Form 7\";}s:10:\"updated_at\";a:3:{s:4:\"date\";s:26:\"2019-08-13 09:02:51.000000\";s:13:\"timezone_type\";i:3;s:8:\"timezone\";s:3:\"UTC\";}s:6:\"is_pro\";i:1;}i:41;a:11:{s:16:\"import_file_name\";s:12:\"Music Artist\";s:4:\"slug\";s:12:\"music-artist\";s:10:\"categories\";a:1:{i:0;s:9:\"portfolio\";}s:15:\"import_file_url\";s:89:\"https://colibri-demo-sites.s3.us-west-2.amazonaws.com/production/music-artist/content.xml\";s:22:\"import_widget_file_url\";s:89:\"https://colibri-demo-sites.s3.us-west-2.amazonaws.com/production/music-artist/widgets.wie\";s:26:\"import_customizer_file_url\";s:92:\"https://colibri-demo-sites.s3.us-west-2.amazonaws.com/production/music-artist/customizer.dat\";s:24:\"import_preview_image_url\";s:78:\"https://static.colibriwp.com/templates-screenshots/music-artist/screenshot.png\";s:11:\"preview_url\";s:50:\"https://colibriwp-work.colibriwp.com/music-artist/\";s:7:\"plugins\";a:1:{s:36:\"contact-form-7/wp-contact-form-7.php\";s:14:\"Contact Form 7\";}s:10:\"updated_at\";a:3:{s:4:\"date\";s:26:\"2019-08-13 09:02:53.000000\";s:13:\"timezone_type\";i:3;s:8:\"timezone\";s:3:\"UTC\";}s:6:\"is_pro\";i:1;}i:42;a:11:{s:16:\"import_file_name\";s:22:\"Photographer Portfolio\";s:4:\"slug\";s:22:\"photographer-portfolio\";s:10:\"categories\";a:1:{i:0;s:9:\"portfolio\";}s:15:\"import_file_url\";s:99:\"https://colibri-demo-sites.s3.us-west-2.amazonaws.com/production/photographer-portfolio/content.xml\";s:22:\"import_widget_file_url\";s:99:\"https://colibri-demo-sites.s3.us-west-2.amazonaws.com/production/photographer-portfolio/widgets.wie\";s:26:\"import_customizer_file_url\";s:102:\"https://colibri-demo-sites.s3.us-west-2.amazonaws.com/production/photographer-portfolio/customizer.dat\";s:24:\"import_preview_image_url\";s:88:\"https://static.colibriwp.com/templates-screenshots/photographer-portfolio/screenshot.png\";s:11:\"preview_url\";s:60:\"https://colibriwp-work.colibriwp.com/photographer-portfolio/\";s:7:\"plugins\";a:1:{s:36:\"contact-form-7/wp-contact-form-7.php\";s:14:\"Contact Form 7\";}s:10:\"updated_at\";a:3:{s:4:\"date\";s:26:\"2019-08-13 09:02:54.000000\";s:13:\"timezone_type\";i:3;s:8:\"timezone\";s:3:\"UTC\";}s:6:\"is_pro\";i:1;}i:43;a:11:{s:16:\"import_file_name\";s:6:\"Resort\";s:4:\"slug\";s:6:\"resort\";s:10:\"categories\";a:1:{i:0;s:12:\"sport-travel\";}s:15:\"import_file_url\";s:83:\"https://colibri-demo-sites.s3.us-west-2.amazonaws.com/production/resort/content.xml\";s:22:\"import_widget_file_url\";s:83:\"https://colibri-demo-sites.s3.us-west-2.amazonaws.com/production/resort/widgets.wie\";s:26:\"import_customizer_file_url\";s:86:\"https://colibri-demo-sites.s3.us-west-2.amazonaws.com/production/resort/customizer.dat\";s:24:\"import_preview_image_url\";s:72:\"https://static.colibriwp.com/templates-screenshots/resort/screenshot.png\";s:11:\"preview_url\";s:44:\"https://colibriwp-work.colibriwp.com/resort/\";s:7:\"plugins\";a:1:{s:36:\"contact-form-7/wp-contact-form-7.php\";s:14:\"Contact Form 7\";}s:10:\"updated_at\";a:3:{s:4:\"date\";s:26:\"2019-08-13 09:02:56.000000\";s:13:\"timezone_type\";i:3;s:8:\"timezone\";s:3:\"UTC\";}s:6:\"is_pro\";i:1;}i:44;a:11:{s:16:\"import_file_name\";s:6:\"Tailor\";s:4:\"slug\";s:6:\"tailor\";s:10:\"categories\";a:1:{i:0;s:8:\"services\";}s:15:\"import_file_url\";s:83:\"https://colibri-demo-sites.s3.us-west-2.amazonaws.com/production/tailor/content.xml\";s:22:\"import_widget_file_url\";s:83:\"https://colibri-demo-sites.s3.us-west-2.amazonaws.com/production/tailor/widgets.wie\";s:26:\"import_customizer_file_url\";s:86:\"https://colibri-demo-sites.s3.us-west-2.amazonaws.com/production/tailor/customizer.dat\";s:24:\"import_preview_image_url\";s:72:\"https://static.colibriwp.com/templates-screenshots/tailor/screenshot.png\";s:11:\"preview_url\";s:44:\"https://colibriwp-work.colibriwp.com/tailor/\";s:7:\"plugins\";a:1:{s:36:\"contact-form-7/wp-contact-form-7.php\";s:14:\"Contact Form 7\";}s:10:\"updated_at\";a:3:{s:4:\"date\";s:26:\"2019-08-13 09:02:58.000000\";s:13:\"timezone_type\";i:3;s:8:\"timezone\";s:3:\"UTC\";}s:6:\"is_pro\";i:1;}i:45;a:11:{s:16:\"import_file_name\";s:7:\"Theater\";s:4:\"slug\";s:7:\"theater\";s:10:\"categories\";a:1:{i:0;s:9:\"community\";}s:15:\"import_file_url\";s:84:\"https://colibri-demo-sites.s3.us-west-2.amazonaws.com/production/theater/content.xml\";s:22:\"import_widget_file_url\";s:84:\"https://colibri-demo-sites.s3.us-west-2.amazonaws.com/production/theater/widgets.wie\";s:26:\"import_customizer_file_url\";s:87:\"https://colibri-demo-sites.s3.us-west-2.amazonaws.com/production/theater/customizer.dat\";s:24:\"import_preview_image_url\";s:73:\"https://static.colibriwp.com/templates-screenshots/theater/screenshot.png\";s:11:\"preview_url\";s:45:\"https://colibriwp-work.colibriwp.com/theater/\";s:7:\"plugins\";a:1:{s:36:\"contact-form-7/wp-contact-form-7.php\";s:14:\"Contact Form 7\";}s:10:\"updated_at\";a:3:{s:4:\"date\";s:26:\"2019-08-13 09:02:59.000000\";s:13:\"timezone_type\";i:3;s:8:\"timezone\";s:3:\"UTC\";}s:6:\"is_pro\";i:1;}i:46;a:11:{s:16:\"import_file_name\";s:13:\"Travel Agency\";s:4:\"slug\";s:13:\"travel-agency\";s:10:\"categories\";a:1:{i:0;s:12:\"sport-travel\";}s:15:\"import_file_url\";s:90:\"https://colibri-demo-sites.s3.us-west-2.amazonaws.com/production/travel-agency/content.xml\";s:22:\"import_widget_file_url\";s:90:\"https://colibri-demo-sites.s3.us-west-2.amazonaws.com/production/travel-agency/widgets.wie\";s:26:\"import_customizer_file_url\";s:93:\"https://colibri-demo-sites.s3.us-west-2.amazonaws.com/production/travel-agency/customizer.dat\";s:24:\"import_preview_image_url\";s:79:\"https://static.colibriwp.com/templates-screenshots/travel-agency/screenshot.png\";s:11:\"preview_url\";s:51:\"https://colibriwp-work.colibriwp.com/travel-agency/\";s:7:\"plugins\";a:1:{s:36:\"contact-form-7/wp-contact-form-7.php\";s:14:\"Contact Form 7\";}s:10:\"updated_at\";a:3:{s:4:\"date\";s:26:\"2019-08-13 09:03:01.000000\";s:13:\"timezone_type\";i:3;s:8:\"timezone\";s:3:\"UTC\";}s:6:\"is_pro\";i:1;}i:47;a:11:{s:16:\"import_file_name\";s:6:\"Bakery\";s:4:\"slug\";s:6:\"bakery\";s:10:\"categories\";a:1:{i:0;s:10:\"food-drink\";}s:15:\"import_file_url\";s:83:\"https://colibri-demo-sites.s3.us-west-2.amazonaws.com/production/bakery/content.xml\";s:22:\"import_widget_file_url\";s:83:\"https://colibri-demo-sites.s3.us-west-2.amazonaws.com/production/bakery/widgets.wie\";s:26:\"import_customizer_file_url\";s:86:\"https://colibri-demo-sites.s3.us-west-2.amazonaws.com/production/bakery/customizer.dat\";s:24:\"import_preview_image_url\";s:77:\"https://static.colibriwp.com/templates-screenshots/template-53/screenshot.jpg\";s:11:\"preview_url\";s:43:\"https://colibriwp-work.colibriwp.com/bakery\";s:7:\"plugins\";a:1:{s:36:\"contact-form-7/wp-contact-form-7.php\";s:14:\"Contact Form 7\";}s:10:\"updated_at\";a:3:{s:4:\"date\";s:26:\"2019-09-19 07:47:11.000000\";s:13:\"timezone_type\";i:3;s:8:\"timezone\";s:3:\"UTC\";}s:6:\"is_pro\";i:1;}i:48;a:11:{s:16:\"import_file_name\";s:16:\"Cleaning Company\";s:4:\"slug\";s:16:\"cleaning-company\";s:10:\"categories\";a:1:{i:0;s:8:\"services\";}s:15:\"import_file_url\";s:93:\"https://colibri-demo-sites.s3.us-west-2.amazonaws.com/production/cleaning-company/content.xml\";s:22:\"import_widget_file_url\";s:93:\"https://colibri-demo-sites.s3.us-west-2.amazonaws.com/production/cleaning-company/widgets.wie\";s:26:\"import_customizer_file_url\";s:96:\"https://colibri-demo-sites.s3.us-west-2.amazonaws.com/production/cleaning-company/customizer.dat\";s:24:\"import_preview_image_url\";s:77:\"https://static.colibriwp.com/templates-screenshots/template-54/screenshot.jpg\";s:11:\"preview_url\";s:53:\"https://colibriwp-work.colibriwp.com/cleaning-company\";s:7:\"plugins\";a:1:{s:36:\"contact-form-7/wp-contact-form-7.php\";s:14:\"Contact Form 7\";}s:10:\"updated_at\";a:3:{s:4:\"date\";s:26:\"2019-09-19 07:47:14.000000\";s:13:\"timezone_type\";i:3;s:8:\"timezone\";s:3:\"UTC\";}s:6:\"is_pro\";i:1;}i:49;a:11:{s:16:\"import_file_name\";s:15:\"Summer Festival\";s:4:\"slug\";s:15:\"summer-festival\";s:10:\"categories\";a:1:{i:0;s:12:\"sport-travel\";}s:15:\"import_file_url\";s:92:\"https://colibri-demo-sites.s3.us-west-2.amazonaws.com/production/summer-festival/content.xml\";s:22:\"import_widget_file_url\";s:92:\"https://colibri-demo-sites.s3.us-west-2.amazonaws.com/production/summer-festival/widgets.wie\";s:26:\"import_customizer_file_url\";s:95:\"https://colibri-demo-sites.s3.us-west-2.amazonaws.com/production/summer-festival/customizer.dat\";s:24:\"import_preview_image_url\";s:81:\"https://static.colibriwp.com/templates-screenshots/summer-festival/screenshot.jpg\";s:11:\"preview_url\";s:53:\"https://colibriwp-work.colibriwp.com/summer-festival/\";s:7:\"plugins\";a:1:{s:36:\"contact-form-7/wp-contact-form-7.php\";s:14:\"Contact Form 7\";}s:10:\"updated_at\";a:3:{s:4:\"date\";s:26:\"2019-09-19 07:47:52.000000\";s:13:\"timezone_type\";i:3;s:8:\"timezone\";s:3:\"UTC\";}s:6:\"is_pro\";i:1;}i:50;a:11:{s:16:\"import_file_name\";s:12:\"Dance Studio\";s:4:\"slug\";s:12:\"dance-studio\";s:10:\"categories\";a:1:{i:0;s:12:\"sport-travel\";}s:15:\"import_file_url\";s:89:\"https://colibri-demo-sites.s3.us-west-2.amazonaws.com/production/dance-studio/content.xml\";s:22:\"import_widget_file_url\";s:89:\"https://colibri-demo-sites.s3.us-west-2.amazonaws.com/production/dance-studio/widgets.wie\";s:26:\"import_customizer_file_url\";s:92:\"https://colibri-demo-sites.s3.us-west-2.amazonaws.com/production/dance-studio/customizer.dat\";s:24:\"import_preview_image_url\";s:78:\"https://static.colibriwp.com/templates-screenshots/dance-studio/screenshot.jpg\";s:11:\"preview_url\";s:50:\"https://colibriwp-work.colibriwp.com/dance-studio/\";s:7:\"plugins\";a:1:{s:36:\"contact-form-7/wp-contact-form-7.php\";s:14:\"Contact Form 7\";}s:10:\"updated_at\";a:3:{s:4:\"date\";s:26:\"2019-09-19 07:47:56.000000\";s:13:\"timezone_type\";i:3;s:8:\"timezone\";s:3:\"UTC\";}s:6:\"is_pro\";i:1;}i:51;a:11:{s:16:\"import_file_name\";s:9:\"Gardening\";s:4:\"slug\";s:9:\"gardening\";s:10:\"categories\";a:1:{i:0;s:8:\"services\";}s:15:\"import_file_url\";s:86:\"https://colibri-demo-sites.s3.us-west-2.amazonaws.com/production/gardening/content.xml\";s:22:\"import_widget_file_url\";s:86:\"https://colibri-demo-sites.s3.us-west-2.amazonaws.com/production/gardening/widgets.wie\";s:26:\"import_customizer_file_url\";s:89:\"https://colibri-demo-sites.s3.us-west-2.amazonaws.com/production/gardening/customizer.dat\";s:24:\"import_preview_image_url\";s:75:\"https://static.colibriwp.com/templates-screenshots/gardening/screenshot.jpg\";s:11:\"preview_url\";s:47:\"https://colibriwp-work.colibriwp.com/gardening/\";s:7:\"plugins\";a:1:{s:36:\"contact-form-7/wp-contact-form-7.php\";s:14:\"Contact Form 7\";}s:10:\"updated_at\";a:3:{s:4:\"date\";s:26:\"2019-09-19 07:48:00.000000\";s:13:\"timezone_type\";i:3;s:8:\"timezone\";s:3:\"UTC\";}s:6:\"is_pro\";i:1;}i:52;a:11:{s:16:\"import_file_name\";s:19:\"Political Candidate\";s:4:\"slug\";s:19:\"political-candidate\";s:10:\"categories\";a:1:{i:0;s:9:\"community\";}s:15:\"import_file_url\";s:96:\"https://colibri-demo-sites.s3.us-west-2.amazonaws.com/production/political-candidate/content.xml\";s:22:\"import_widget_file_url\";s:96:\"https://colibri-demo-sites.s3.us-west-2.amazonaws.com/production/political-candidate/widgets.wie\";s:26:\"import_customizer_file_url\";s:99:\"https://colibri-demo-sites.s3.us-west-2.amazonaws.com/production/political-candidate/customizer.dat\";s:24:\"import_preview_image_url\";s:85:\"https://static.colibriwp.com/templates-screenshots/political-candidate/screenshot.jpg\";s:11:\"preview_url\";s:57:\"https://colibriwp-work.colibriwp.com/political-candidate/\";s:7:\"plugins\";a:1:{s:36:\"contact-form-7/wp-contact-form-7.php\";s:14:\"Contact Form 7\";}s:10:\"updated_at\";a:3:{s:4:\"date\";s:26:\"2019-09-19 07:48:04.000000\";s:13:\"timezone_type\";i:3;s:8:\"timezone\";s:3:\"UTC\";}s:6:\"is_pro\";i:1;}i:53;a:11:{s:16:\"import_file_name\";s:19:\"Horse Riding Center\";s:4:\"slug\";s:19:\"horse-riding-center\";s:10:\"categories\";a:1:{i:0;s:12:\"sport-travel\";}s:15:\"import_file_url\";s:96:\"https://colibri-demo-sites.s3.us-west-2.amazonaws.com/production/horse-riding-center/content.xml\";s:22:\"import_widget_file_url\";s:96:\"https://colibri-demo-sites.s3.us-west-2.amazonaws.com/production/horse-riding-center/widgets.wie\";s:26:\"import_customizer_file_url\";s:99:\"https://colibri-demo-sites.s3.us-west-2.amazonaws.com/production/horse-riding-center/customizer.dat\";s:24:\"import_preview_image_url\";s:85:\"https://static.colibriwp.com/templates-screenshots/horse-riding-center/screenshot.jpg\";s:11:\"preview_url\";s:57:\"https://colibriwp-work.colibriwp.com/horse-riding-center/\";s:7:\"plugins\";a:1:{s:36:\"contact-form-7/wp-contact-form-7.php\";s:14:\"Contact Form 7\";}s:10:\"updated_at\";a:3:{s:4:\"date\";s:26:\"2019-09-19 07:48:08.000000\";s:13:\"timezone_type\";i:3;s:8:\"timezone\";s:3:\"UTC\";}s:6:\"is_pro\";i:1;}i:54;a:11:{s:16:\"import_file_name\";s:9:\"School II\";s:4:\"slug\";s:9:\"school-ii\";s:10:\"categories\";a:1:{i:0;s:9:\"community\";}s:15:\"import_file_url\";s:86:\"https://colibri-demo-sites.s3.us-west-2.amazonaws.com/production/school-ii/content.xml\";s:22:\"import_widget_file_url\";s:86:\"https://colibri-demo-sites.s3.us-west-2.amazonaws.com/production/school-ii/widgets.wie\";s:26:\"import_customizer_file_url\";s:89:\"https://colibri-demo-sites.s3.us-west-2.amazonaws.com/production/school-ii/customizer.dat\";s:24:\"import_preview_image_url\";s:75:\"https://static.colibriwp.com/templates-screenshots/school-ii/screenshot.jpg\";s:11:\"preview_url\";s:47:\"https://colibriwp-work.colibriwp.com/school-ii/\";s:7:\"plugins\";a:1:{s:36:\"contact-form-7/wp-contact-form-7.php\";s:14:\"Contact Form 7\";}s:10:\"updated_at\";a:3:{s:4:\"date\";s:26:\"2019-09-19 07:48:13.000000\";s:13:\"timezone_type\";i:3;s:8:\"timezone\";s:3:\"UTC\";}s:6:\"is_pro\";i:1;}i:55;a:11:{s:16:\"import_file_name\";s:13:\"Therapist PRO\";s:4:\"slug\";s:13:\"therapist-pro\";s:10:\"categories\";a:1:{i:0;s:8:\"services\";}s:15:\"import_file_url\";s:90:\"https://colibri-demo-sites.s3.us-west-2.amazonaws.com/production/therapist-pro/content.xml\";s:22:\"import_widget_file_url\";s:90:\"https://colibri-demo-sites.s3.us-west-2.amazonaws.com/production/therapist-pro/widgets.wie\";s:26:\"import_customizer_file_url\";s:93:\"https://colibri-demo-sites.s3.us-west-2.amazonaws.com/production/therapist-pro/customizer.dat\";s:24:\"import_preview_image_url\";s:79:\"https://static.colibriwp.com/templates-screenshots/therapist-pro/screenshot.jpg\";s:11:\"preview_url\";s:50:\"https://colibriwp-work.colibriwp.com/therapist-pro\";s:7:\"plugins\";a:1:{s:36:\"contact-form-7/wp-contact-form-7.php\";s:14:\"Contact Form 7\";}s:10:\"updated_at\";a:3:{s:4:\"date\";s:26:\"2020-06-02 13:37:59.000000\";s:13:\"timezone_type\";i:3;s:8:\"timezone\";s:3:\"UTC\";}s:6:\"is_pro\";i:1;}i:56;a:11:{s:16:\"import_file_name\";s:10:\"Museum PRO\";s:4:\"slug\";s:10:\"museum-pro\";s:10:\"categories\";a:1:{i:0;s:9:\"community\";}s:15:\"import_file_url\";s:87:\"https://colibri-demo-sites.s3.us-west-2.amazonaws.com/production/museum-pro/content.xml\";s:22:\"import_widget_file_url\";s:87:\"https://colibri-demo-sites.s3.us-west-2.amazonaws.com/production/museum-pro/widgets.wie\";s:26:\"import_customizer_file_url\";s:90:\"https://colibri-demo-sites.s3.us-west-2.amazonaws.com/production/museum-pro/customizer.dat\";s:24:\"import_preview_image_url\";s:76:\"https://static.colibriwp.com/templates-screenshots/museum-pro/screenshot.jpg\";s:11:\"preview_url\";s:47:\"https://colibriwp-work.colibriwp.com/museum-pro\";s:7:\"plugins\";a:1:{s:36:\"contact-form-7/wp-contact-form-7.php\";s:14:\"Contact Form 7\";}s:10:\"updated_at\";a:3:{s:4:\"date\";s:26:\"2020-06-02 13:37:55.000000\";s:13:\"timezone_type\";i:3;s:8:\"timezone\";s:3:\"UTC\";}s:6:\"is_pro\";i:1;}i:57;a:11:{s:16:\"import_file_name\";s:7:\"Eco PRO\";s:4:\"slug\";s:7:\"eco-pro\";s:10:\"categories\";a:1:{i:0;s:9:\"community\";}s:15:\"import_file_url\";s:84:\"https://colibri-demo-sites.s3.us-west-2.amazonaws.com/production/eco-pro/content.xml\";s:22:\"import_widget_file_url\";s:84:\"https://colibri-demo-sites.s3.us-west-2.amazonaws.com/production/eco-pro/widgets.wie\";s:26:\"import_customizer_file_url\";s:87:\"https://colibri-demo-sites.s3.us-west-2.amazonaws.com/production/eco-pro/customizer.dat\";s:24:\"import_preview_image_url\";s:73:\"https://static.colibriwp.com/templates-screenshots/eco-pro/screenshot.jpg\";s:11:\"preview_url\";s:44:\"https://colibriwp-work.colibriwp.com/eco-pro\";s:7:\"plugins\";a:1:{s:36:\"contact-form-7/wp-contact-form-7.php\";s:14:\"Contact Form 7\";}s:10:\"updated_at\";a:3:{s:4:\"date\";s:26:\"2020-06-02 13:37:53.000000\";s:13:\"timezone_type\";i:3;s:8:\"timezone\";s:3:\"UTC\";}s:6:\"is_pro\";i:1;}i:58;a:11:{s:16:\"import_file_name\";s:13:\"Carpentry PRO\";s:4:\"slug\";s:13:\"carpentry-pro\";s:10:\"categories\";a:1:{i:0;s:8:\"business\";}s:15:\"import_file_url\";s:90:\"https://colibri-demo-sites.s3.us-west-2.amazonaws.com/production/carpentry-pro/content.xml\";s:22:\"import_widget_file_url\";s:90:\"https://colibri-demo-sites.s3.us-west-2.amazonaws.com/production/carpentry-pro/widgets.wie\";s:26:\"import_customizer_file_url\";s:93:\"https://colibri-demo-sites.s3.us-west-2.amazonaws.com/production/carpentry-pro/customizer.dat\";s:24:\"import_preview_image_url\";s:77:\"https://static.colibriwp.com/templates-screenshots/template-74/screenshot.jpg\";s:11:\"preview_url\";s:50:\"https://colibriwp-work.colibriwp.com/carpentry-pro\";s:7:\"plugins\";a:1:{s:36:\"contact-form-7/wp-contact-form-7.php\";s:14:\"Contact Form 7\";}s:10:\"updated_at\";a:3:{s:4:\"date\";s:26:\"2020-06-02 13:37:51.000000\";s:13:\"timezone_type\";i:3;s:8:\"timezone\";s:3:\"UTC\";}s:6:\"is_pro\";i:1;}i:59;a:11:{s:16:\"import_file_name\";s:15:\"Babysitting PRO\";s:4:\"slug\";s:15:\"babysitting-pro\";s:10:\"categories\";a:1:{i:0;s:8:\"services\";}s:15:\"import_file_url\";s:92:\"https://colibri-demo-sites.s3.us-west-2.amazonaws.com/production/babysitting-pro/content.xml\";s:22:\"import_widget_file_url\";s:92:\"https://colibri-demo-sites.s3.us-west-2.amazonaws.com/production/babysitting-pro/widgets.wie\";s:26:\"import_customizer_file_url\";s:95:\"https://colibri-demo-sites.s3.us-west-2.amazonaws.com/production/babysitting-pro/customizer.dat\";s:24:\"import_preview_image_url\";s:81:\"https://static.colibriwp.com/templates-screenshots/babysitting-pro/screenshot.jpg\";s:11:\"preview_url\";s:52:\"https://colibriwp-work.colibriwp.com/babysitting-pro\";s:7:\"plugins\";a:1:{s:36:\"contact-form-7/wp-contact-form-7.php\";s:14:\"Contact Form 7\";}s:10:\"updated_at\";a:3:{s:4:\"date\";s:26:\"2020-06-02 13:37:50.000000\";s:13:\"timezone_type\";i:3;s:8:\"timezone\";s:3:\"UTC\";}s:6:\"is_pro\";i:1;}i:60;a:11:{s:16:\"import_file_name\";s:15:\"Bike rental PRO\";s:4:\"slug\";s:15:\"bike-rental-pro\";s:10:\"categories\";a:1:{i:0;s:8:\"business\";}s:15:\"import_file_url\";s:92:\"https://colibri-demo-sites.s3.us-west-2.amazonaws.com/production/bike-rental-pro/content.xml\";s:22:\"import_widget_file_url\";s:92:\"https://colibri-demo-sites.s3.us-west-2.amazonaws.com/production/bike-rental-pro/widgets.wie\";s:26:\"import_customizer_file_url\";s:95:\"https://colibri-demo-sites.s3.us-west-2.amazonaws.com/production/bike-rental-pro/customizer.dat\";s:24:\"import_preview_image_url\";s:81:\"https://static.colibriwp.com/templates-screenshots/bike-rental-pro/screenshot.jpg\";s:11:\"preview_url\";s:52:\"https://colibriwp-work.colibriwp.com/bike-rental-pro\";s:7:\"plugins\";a:1:{s:36:\"contact-form-7/wp-contact-form-7.php\";s:14:\"Contact Form 7\";}s:10:\"updated_at\";a:3:{s:4:\"date\";s:26:\"2020-06-02 13:37:48.000000\";s:13:\"timezone_type\";i:3;s:8:\"timezone\";s:3:\"UTC\";}s:6:\"is_pro\";i:1;}i:61;a:11:{s:16:\"import_file_name\";s:8:\"City PRO\";s:4:\"slug\";s:8:\"city-pro\";s:10:\"categories\";a:1:{i:0;s:9:\"community\";}s:15:\"import_file_url\";s:85:\"https://colibri-demo-sites.s3.us-west-2.amazonaws.com/production/city-pro/content.xml\";s:22:\"import_widget_file_url\";s:85:\"https://colibri-demo-sites.s3.us-west-2.amazonaws.com/production/city-pro/widgets.wie\";s:26:\"import_customizer_file_url\";s:88:\"https://colibri-demo-sites.s3.us-west-2.amazonaws.com/production/city-pro/customizer.dat\";s:24:\"import_preview_image_url\";s:74:\"https://static.colibriwp.com/templates-screenshots/city-pro/screenshot.jpg\";s:11:\"preview_url\";s:45:\"https://colibriwp-work.colibriwp.com/city-pro\";s:7:\"plugins\";a:1:{s:36:\"contact-form-7/wp-contact-form-7.php\";s:14:\"Contact Form 7\";}s:10:\"updated_at\";a:3:{s:4:\"date\";s:26:\"2020-06-02 13:37:47.000000\";s:13:\"timezone_type\";i:3;s:8:\"timezone\";s:3:\"UTC\";}s:6:\"is_pro\";i:1;}i:62;a:11:{s:16:\"import_file_name\";s:12:\"Handyman PRO\";s:4:\"slug\";s:12:\"handyman-pro\";s:10:\"categories\";a:1:{i:0;s:8:\"services\";}s:15:\"import_file_url\";s:89:\"https://colibri-demo-sites.s3.us-west-2.amazonaws.com/production/handyman-pro/content.xml\";s:22:\"import_widget_file_url\";s:89:\"https://colibri-demo-sites.s3.us-west-2.amazonaws.com/production/handyman-pro/widgets.wie\";s:26:\"import_customizer_file_url\";s:92:\"https://colibri-demo-sites.s3.us-west-2.amazonaws.com/production/handyman-pro/customizer.dat\";s:24:\"import_preview_image_url\";s:78:\"https://static.colibriwp.com/templates-screenshots/handyman-pro/screenshot.jpg\";s:11:\"preview_url\";s:49:\"https://colibriwp-work.colibriwp.com/handyman-pro\";s:7:\"plugins\";a:1:{s:36:\"contact-form-7/wp-contact-form-7.php\";s:14:\"Contact Form 7\";}s:10:\"updated_at\";a:3:{s:4:\"date\";s:26:\"2020-06-02 13:37:45.000000\";s:13:\"timezone_type\";i:3;s:8:\"timezone\";s:3:\"UTC\";}s:6:\"is_pro\";i:1;}i:63;a:11:{s:16:\"import_file_name\";s:13:\"Home Deco PRO\";s:4:\"slug\";s:13:\"home-deco-pro\";s:10:\"categories\";a:1:{i:0;s:8:\"business\";}s:15:\"import_file_url\";s:90:\"https://colibri-demo-sites.s3.us-west-2.amazonaws.com/production/home-deco-pro/content.xml\";s:22:\"import_widget_file_url\";s:90:\"https://colibri-demo-sites.s3.us-west-2.amazonaws.com/production/home-deco-pro/widgets.wie\";s:26:\"import_customizer_file_url\";s:93:\"https://colibri-demo-sites.s3.us-west-2.amazonaws.com/production/home-deco-pro/customizer.dat\";s:24:\"import_preview_image_url\";s:79:\"https://static.colibriwp.com/templates-screenshots/home-deco-pro/screenshot.jpg\";s:11:\"preview_url\";s:50:\"https://colibriwp-work.colibriwp.com/home-deco-pro\";s:7:\"plugins\";a:1:{s:36:\"contact-form-7/wp-contact-form-7.php\";s:14:\"Contact Form 7\";}s:10:\"updated_at\";a:3:{s:4:\"date\";s:26:\"2020-06-02 13:37:44.000000\";s:13:\"timezone_type\";i:3;s:8:\"timezone\";s:3:\"UTC\";}s:6:\"is_pro\";i:1;}i:64;a:11:{s:16:\"import_file_name\";s:12:\"Coaching PRO\";s:4:\"slug\";s:14:\"coaching-pro-1\";s:10:\"categories\";a:1:{i:0;s:9:\"portfolio\";}s:15:\"import_file_url\";s:91:\"https://colibri-demo-sites.s3.us-west-2.amazonaws.com/production/coaching-pro-1/content.xml\";s:22:\"import_widget_file_url\";s:91:\"https://colibri-demo-sites.s3.us-west-2.amazonaws.com/production/coaching-pro-1/widgets.wie\";s:26:\"import_customizer_file_url\";s:94:\"https://colibri-demo-sites.s3.us-west-2.amazonaws.com/production/coaching-pro-1/customizer.dat\";s:24:\"import_preview_image_url\";s:80:\"https://static.colibriwp.com/templates-screenshots/coaching-pro-1/screenshot.jpg\";s:11:\"preview_url\";s:51:\"https://colibriwp-work.colibriwp.com/coaching-pro-1\";s:7:\"plugins\";a:1:{s:36:\"contact-form-7/wp-contact-form-7.php\";s:14:\"Contact Form 7\";}s:10:\"updated_at\";a:3:{s:4:\"date\";s:26:\"2020-06-02 13:37:42.000000\";s:13:\"timezone_type\";i:3;s:8:\"timezone\";s:3:\"UTC\";}s:6:\"is_pro\";i:1;}i:65;a:11:{s:16:\"import_file_name\";s:13:\"Coaching Free\";s:4:\"slug\";s:15:\"coaching-free-1\";s:10:\"categories\";a:1:{i:0;s:9:\"portfolio\";}s:15:\"import_file_url\";s:92:\"https://colibri-demo-sites.s3.us-west-2.amazonaws.com/production/coaching-free-1/content.xml\";s:22:\"import_widget_file_url\";s:92:\"https://colibri-demo-sites.s3.us-west-2.amazonaws.com/production/coaching-free-1/widgets.wie\";s:26:\"import_customizer_file_url\";s:95:\"https://colibri-demo-sites.s3.us-west-2.amazonaws.com/production/coaching-free-1/customizer.dat\";s:24:\"import_preview_image_url\";s:81:\"https://static.colibriwp.com/templates-screenshots/coaching-free-1/screenshot.jpg\";s:11:\"preview_url\";s:50:\"https://colibriwp-work.colibriwp.com/coaching-free\";s:7:\"plugins\";a:1:{s:36:\"contact-form-7/wp-contact-form-7.php\";s:14:\"Contact Form 7\";}s:10:\"updated_at\";a:3:{s:4:\"date\";s:26:\"2020-09-14 08:01:48.000000\";s:13:\"timezone_type\";i:3;s:8:\"timezone\";s:3:\"UTC\";}s:6:\"is_pro\";i:0;}i:66;a:11:{s:16:\"import_file_name\";s:14:\"Designer Ui/Ux\";s:4:\"slug\";s:13:\"designer-uiux\";s:10:\"categories\";a:1:{i:0;s:9:\"portfolio\";}s:15:\"import_file_url\";s:90:\"https://colibri-demo-sites.s3.us-west-2.amazonaws.com/production/designer-uiux/content.xml\";s:22:\"import_widget_file_url\";s:90:\"https://colibri-demo-sites.s3.us-west-2.amazonaws.com/production/designer-uiux/widgets.wie\";s:26:\"import_customizer_file_url\";s:93:\"https://colibri-demo-sites.s3.us-west-2.amazonaws.com/production/designer-uiux/customizer.dat\";s:24:\"import_preview_image_url\";s:79:\"https://static.colibriwp.com/templates-screenshots/designer-uiux/screenshot.jpg\";s:11:\"preview_url\";s:50:\"https://colibriwp-work.colibriwp.com/designer-uiux\";s:7:\"plugins\";a:1:{s:36:\"contact-form-7/wp-contact-form-7.php\";s:14:\"Contact Form 7\";}s:10:\"updated_at\";a:3:{s:4:\"date\";s:26:\"2020-09-25 08:33:19.000000\";s:13:\"timezone_type\";i:3;s:8:\"timezone\";s:3:\"UTC\";}s:6:\"is_pro\";i:1;}i:67;a:11:{s:16:\"import_file_name\";s:9:\"Insurance\";s:4:\"slug\";s:11:\"insurance-1\";s:10:\"categories\";a:1:{i:0;s:8:\"services\";}s:15:\"import_file_url\";s:88:\"https://colibri-demo-sites.s3.us-west-2.amazonaws.com/production/insurance-1/content.xml\";s:22:\"import_widget_file_url\";s:88:\"https://colibri-demo-sites.s3.us-west-2.amazonaws.com/production/insurance-1/widgets.wie\";s:26:\"import_customizer_file_url\";s:91:\"https://colibri-demo-sites.s3.us-west-2.amazonaws.com/production/insurance-1/customizer.dat\";s:24:\"import_preview_image_url\";s:77:\"https://static.colibriwp.com/templates-screenshots/insurance-1/screenshot.jpg\";s:11:\"preview_url\";s:46:\"https://colibriwp-work.colibriwp.com/insurance\";s:7:\"plugins\";a:2:{s:36:\"contact-form-7/wp-contact-form-7.php\";s:14:\"Contact Form 7\";s:37:\"mailchimp-for-wp/mailchimp-for-wp.php\";s:30:\"MC4WP: Mailchimp for WordPress\";}s:10:\"updated_at\";a:3:{s:4:\"date\";s:26:\"2021-01-04 10:02:55.000000\";s:13:\"timezone_type\";i:3;s:8:\"timezone\";s:3:\"UTC\";}s:6:\"is_pro\";i:1;}i:68;a:11:{s:16:\"import_file_name\";s:10:\"Veterinary\";s:4:\"slug\";s:12:\"veterinary-1\";s:10:\"categories\";a:1:{i:0;s:8:\"services\";}s:15:\"import_file_url\";s:89:\"https://colibri-demo-sites.s3.us-west-2.amazonaws.com/production/veterinary-1/content.xml\";s:22:\"import_widget_file_url\";s:89:\"https://colibri-demo-sites.s3.us-west-2.amazonaws.com/production/veterinary-1/widgets.wie\";s:26:\"import_customizer_file_url\";s:92:\"https://colibri-demo-sites.s3.us-west-2.amazonaws.com/production/veterinary-1/customizer.dat\";s:24:\"import_preview_image_url\";s:78:\"https://static.colibriwp.com/templates-screenshots/veterinary-1/screenshot.jpg\";s:11:\"preview_url\";s:47:\"https://colibriwp-work.colibriwp.com/veterinary\";s:7:\"plugins\";a:2:{s:36:\"contact-form-7/wp-contact-form-7.php\";s:14:\"Contact Form 7\";s:37:\"mailchimp-for-wp/mailchimp-for-wp.php\";s:30:\"MC4WP: Mailchimp for WordPress\";}s:10:\"updated_at\";a:3:{s:4:\"date\";s:26:\"2021-01-19 15:56:02.000000\";s:13:\"timezone_type\";i:3;s:8:\"timezone\";s:3:\"UTC\";}s:6:\"is_pro\";i:1;}i:69;a:11:{s:16:\"import_file_name\";s:8:\"Handmade\";s:4:\"slug\";s:10:\"handmade-1\";s:10:\"categories\";a:1:{i:0;s:9:\"portfolio\";}s:15:\"import_file_url\";s:87:\"https://colibri-demo-sites.s3.us-west-2.amazonaws.com/production/handmade-1/content.xml\";s:22:\"import_widget_file_url\";s:87:\"https://colibri-demo-sites.s3.us-west-2.amazonaws.com/production/handmade-1/widgets.wie\";s:26:\"import_customizer_file_url\";s:90:\"https://colibri-demo-sites.s3.us-west-2.amazonaws.com/production/handmade-1/customizer.dat\";s:24:\"import_preview_image_url\";s:76:\"https://static.colibriwp.com/templates-screenshots/handmade-1/screenshot.jpg\";s:11:\"preview_url\";s:45:\"https://colibriwp-work.colibriwp.com/handmade\";s:7:\"plugins\";a:2:{s:36:\"contact-form-7/wp-contact-form-7.php\";s:14:\"Contact Form 7\";s:37:\"mailchimp-for-wp/mailchimp-for-wp.php\";s:30:\"MC4WP: Mailchimp for WordPress\";}s:10:\"updated_at\";a:3:{s:4:\"date\";s:26:\"2021-02-09 09:36:12.000000\";s:13:\"timezone_type\";i:3;s:8:\"timezone\";s:3:\"UTC\";}s:6:\"is_pro\";i:1;}i:70;a:11:{s:16:\"import_file_name\";s:20:\"Aesthetic clinic PRO\";s:4:\"slug\";s:22:\"aesthetic-clinic-pro-1\";s:10:\"categories\";a:1:{i:0;s:8:\"services\";}s:15:\"import_file_url\";s:99:\"https://colibri-demo-sites.s3.us-west-2.amazonaws.com/production/aesthetic-clinic-pro-1/content.xml\";s:22:\"import_widget_file_url\";s:99:\"https://colibri-demo-sites.s3.us-west-2.amazonaws.com/production/aesthetic-clinic-pro-1/widgets.wie\";s:26:\"import_customizer_file_url\";s:102:\"https://colibri-demo-sites.s3.us-west-2.amazonaws.com/production/aesthetic-clinic-pro-1/customizer.dat\";s:24:\"import_preview_image_url\";s:88:\"https://static.colibriwp.com/templates-screenshots/aesthetic-clinic-pro-1/screenshot.jpg\";s:11:\"preview_url\";s:59:\"https://colibriwp-work.colibriwp.com/aesthetic-clinic-pro-1\";s:7:\"plugins\";a:2:{s:36:\"contact-form-7/wp-contact-form-7.php\";s:14:\"Contact Form 7\";s:37:\"mailchimp-for-wp/mailchimp-for-wp.php\";s:30:\"MC4WP: Mailchimp for WordPress\";}s:10:\"updated_at\";a:3:{s:4:\"date\";s:26:\"2021-01-19 15:56:00.000000\";s:13:\"timezone_type\";i:3;s:8:\"timezone\";s:3:\"UTC\";}s:6:\"is_pro\";i:1;}i:71;a:11:{s:16:\"import_file_name\";s:10:\"Tattoo PRO\";s:4:\"slug\";s:10:\"tattoo-pro\";s:10:\"categories\";a:1:{i:0;s:8:\"business\";}s:15:\"import_file_url\";s:87:\"https://colibri-demo-sites.s3.us-west-2.amazonaws.com/production/tattoo-pro/content.xml\";s:22:\"import_widget_file_url\";s:87:\"https://colibri-demo-sites.s3.us-west-2.amazonaws.com/production/tattoo-pro/widgets.wie\";s:26:\"import_customizer_file_url\";s:90:\"https://colibri-demo-sites.s3.us-west-2.amazonaws.com/production/tattoo-pro/customizer.dat\";s:24:\"import_preview_image_url\";s:76:\"https://static.colibriwp.com/templates-screenshots/tattoo-pro/screenshot.jpg\";s:11:\"preview_url\";s:47:\"https://colibriwp-work.colibriwp.com/tattoo-pro\";s:7:\"plugins\";a:1:{s:36:\"contact-form-7/wp-contact-form-7.php\";s:14:\"Contact Form 7\";}s:10:\"updated_at\";a:3:{s:4:\"date\";s:26:\"2021-01-19 15:54:51.000000\";s:13:\"timezone_type\";i:3;s:8:\"timezone\";s:3:\"UTC\";}s:6:\"is_pro\";i:1;}i:72;a:11:{s:16:\"import_file_name\";s:14:\"Accounting PRO\";s:4:\"slug\";s:16:\"accounting-pro-1\";s:10:\"categories\";a:1:{i:0;s:8:\"business\";}s:15:\"import_file_url\";s:93:\"https://colibri-demo-sites.s3.us-west-2.amazonaws.com/production/accounting-pro-1/content.xml\";s:22:\"import_widget_file_url\";s:93:\"https://colibri-demo-sites.s3.us-west-2.amazonaws.com/production/accounting-pro-1/widgets.wie\";s:26:\"import_customizer_file_url\";s:96:\"https://colibri-demo-sites.s3.us-west-2.amazonaws.com/production/accounting-pro-1/customizer.dat\";s:24:\"import_preview_image_url\";s:82:\"https://static.colibriwp.com/templates-screenshots/accounting-pro-1/screenshot.jpg\";s:11:\"preview_url\";s:51:\"https://colibriwp-work.colibriwp.com/accounting-pro\";s:7:\"plugins\";a:1:{s:36:\"contact-form-7/wp-contact-form-7.php\";s:14:\"Contact Form 7\";}s:10:\"updated_at\";a:3:{s:4:\"date\";s:26:\"2020-11-06 07:32:11.000000\";s:13:\"timezone_type\";i:3;s:8:\"timezone\";s:3:\"UTC\";}s:6:\"is_pro\";i:1;}i:73;a:11:{s:16:\"import_file_name\";s:14:\"Web Agency PRO\";s:4:\"slug\";s:14:\"web-agency-pro\";s:10:\"categories\";a:1:{i:0;s:8:\"business\";}s:15:\"import_file_url\";s:91:\"https://colibri-demo-sites.s3.us-west-2.amazonaws.com/production/web-agency-pro/content.xml\";s:22:\"import_widget_file_url\";s:91:\"https://colibri-demo-sites.s3.us-west-2.amazonaws.com/production/web-agency-pro/widgets.wie\";s:26:\"import_customizer_file_url\";s:94:\"https://colibri-demo-sites.s3.us-west-2.amazonaws.com/production/web-agency-pro/customizer.dat\";s:24:\"import_preview_image_url\";s:80:\"https://static.colibriwp.com/templates-screenshots/web-agency-pro/screenshot.jpg\";s:11:\"preview_url\";s:51:\"https://colibriwp-work.colibriwp.com/web-agency-pro\";s:7:\"plugins\";a:1:{s:36:\"contact-form-7/wp-contact-form-7.php\";s:14:\"Contact Form 7\";}s:10:\"updated_at\";a:3:{s:4:\"date\";s:26:\"2020-10-30 09:48:41.000000\";s:13:\"timezone_type\";i:3;s:8:\"timezone\";s:3:\"UTC\";}s:6:\"is_pro\";i:1;}i:74;a:11:{s:16:\"import_file_name\";s:13:\"Eldercare PRO\";s:4:\"slug\";s:13:\"eldercare-pro\";s:10:\"categories\";a:1:{i:0;s:9:\"community\";}s:15:\"import_file_url\";s:90:\"https://colibri-demo-sites.s3.us-west-2.amazonaws.com/production/eldercare-pro/content.xml\";s:22:\"import_widget_file_url\";s:90:\"https://colibri-demo-sites.s3.us-west-2.amazonaws.com/production/eldercare-pro/widgets.wie\";s:26:\"import_customizer_file_url\";s:93:\"https://colibri-demo-sites.s3.us-west-2.amazonaws.com/production/eldercare-pro/customizer.dat\";s:24:\"import_preview_image_url\";s:79:\"https://static.colibriwp.com/templates-screenshots/eldercare-pro/screenshot.jpg\";s:11:\"preview_url\";s:50:\"https://colibriwp-work.colibriwp.com/eldercare-pro\";s:7:\"plugins\";a:1:{s:36:\"contact-form-7/wp-contact-form-7.php\";s:14:\"Contact Form 7\";}s:10:\"updated_at\";a:3:{s:4:\"date\";s:26:\"2021-01-19 15:54:49.000000\";s:13:\"timezone_type\";i:3;s:8:\"timezone\";s:3:\"UTC\";}s:6:\"is_pro\";i:1;}i:75;a:11:{s:16:\"import_file_name\";s:20:\"Personal Stylist PRO\";s:4:\"slug\";s:20:\"personal-stylist-pro\";s:10:\"categories\";a:1:{i:0;s:8:\"business\";}s:15:\"import_file_url\";s:97:\"https://colibri-demo-sites.s3.us-west-2.amazonaws.com/production/personal-stylist-pro/content.xml\";s:22:\"import_widget_file_url\";s:97:\"https://colibri-demo-sites.s3.us-west-2.amazonaws.com/production/personal-stylist-pro/widgets.wie\";s:26:\"import_customizer_file_url\";s:100:\"https://colibri-demo-sites.s3.us-west-2.amazonaws.com/production/personal-stylist-pro/customizer.dat\";s:24:\"import_preview_image_url\";s:86:\"https://static.colibriwp.com/templates-screenshots/personal-stylist-pro/screenshot.jpg\";s:11:\"preview_url\";s:57:\"https://colibriwp-work.colibriwp.com/personal-stylist-pro\";s:7:\"plugins\";a:2:{s:36:\"contact-form-7/wp-contact-form-7.php\";s:14:\"Contact Form 7\";s:37:\"mailchimp-for-wp/mailchimp-for-wp.php\";s:30:\"MC4WP: Mailchimp for WordPress\";}s:10:\"updated_at\";a:3:{s:4:\"date\";s:26:\"2020-09-24 13:40:49.000000\";s:13:\"timezone_type\";i:3;s:8:\"timezone\";s:3:\"UTC\";}s:6:\"is_pro\";i:1;}i:76;a:11:{s:16:\"import_file_name\";s:15:\"Illusionist PRO\";s:4:\"slug\";s:15:\"illusionist-pro\";s:10:\"categories\";a:1:{i:0;s:8:\"business\";}s:15:\"import_file_url\";s:92:\"https://colibri-demo-sites.s3.us-west-2.amazonaws.com/production/illusionist-pro/content.xml\";s:22:\"import_widget_file_url\";s:92:\"https://colibri-demo-sites.s3.us-west-2.amazonaws.com/production/illusionist-pro/widgets.wie\";s:26:\"import_customizer_file_url\";s:95:\"https://colibri-demo-sites.s3.us-west-2.amazonaws.com/production/illusionist-pro/customizer.dat\";s:24:\"import_preview_image_url\";s:81:\"https://static.colibriwp.com/templates-screenshots/illusionist-pro/screenshot.jpg\";s:11:\"preview_url\";s:52:\"https://colibriwp-work.colibriwp.com/illusionist-pro\";s:7:\"plugins\";a:2:{s:36:\"contact-form-7/wp-contact-form-7.php\";s:14:\"Contact Form 7\";s:37:\"mailchimp-for-wp/mailchimp-for-wp.php\";s:30:\"MC4WP: Mailchimp for WordPress\";}s:10:\"updated_at\";a:3:{s:4:\"date\";s:26:\"2021-01-19 15:54:46.000000\";s:13:\"timezone_type\";i:3;s:8:\"timezone\";s:3:\"UTC\";}s:6:\"is_pro\";i:1;}i:77;a:11:{s:16:\"import_file_name\";s:13:\"Paintball PRO\";s:4:\"slug\";s:13:\"paintball-pro\";s:10:\"categories\";a:1:{i:0;s:12:\"sport-travel\";}s:15:\"import_file_url\";s:90:\"https://colibri-demo-sites.s3.us-west-2.amazonaws.com/production/paintball-pro/content.xml\";s:22:\"import_widget_file_url\";s:90:\"https://colibri-demo-sites.s3.us-west-2.amazonaws.com/production/paintball-pro/widgets.wie\";s:26:\"import_customizer_file_url\";s:93:\"https://colibri-demo-sites.s3.us-west-2.amazonaws.com/production/paintball-pro/customizer.dat\";s:24:\"import_preview_image_url\";s:79:\"https://static.colibriwp.com/templates-screenshots/paintball-pro/screenshot.jpg\";s:11:\"preview_url\";s:50:\"https://colibriwp-work.colibriwp.com/paintball-pro\";s:7:\"plugins\";a:1:{s:36:\"contact-form-7/wp-contact-form-7.php\";s:14:\"Contact Form 7\";}s:10:\"updated_at\";a:3:{s:4:\"date\";s:26:\"2021-01-19 15:54:44.000000\";s:13:\"timezone_type\";i:3;s:8:\"timezone\";s:3:\"UTC\";}s:6:\"is_pro\";i:1;}i:78;a:11:{s:16:\"import_file_name\";s:11:\"Painter PRO\";s:4:\"slug\";s:11:\"painter-pro\";s:10:\"categories\";a:1:{i:0;s:9:\"portfolio\";}s:15:\"import_file_url\";s:88:\"https://colibri-demo-sites.s3.us-west-2.amazonaws.com/production/painter-pro/content.xml\";s:22:\"import_widget_file_url\";s:88:\"https://colibri-demo-sites.s3.us-west-2.amazonaws.com/production/painter-pro/widgets.wie\";s:26:\"import_customizer_file_url\";s:91:\"https://colibri-demo-sites.s3.us-west-2.amazonaws.com/production/painter-pro/customizer.dat\";s:24:\"import_preview_image_url\";s:77:\"https://static.colibriwp.com/templates-screenshots/painter-pro/screenshot.jpg\";s:11:\"preview_url\";s:48:\"https://colibriwp-work.colibriwp.com/painter-pro\";s:7:\"plugins\";a:2:{s:36:\"contact-form-7/wp-contact-form-7.php\";s:14:\"Contact Form 7\";s:37:\"mailchimp-for-wp/mailchimp-for-wp.php\";s:30:\"MC4WP: Mailchimp for WordPress\";}s:10:\"updated_at\";a:3:{s:4:\"date\";s:26:\"2020-10-19 08:06:59.000000\";s:13:\"timezone_type\";i:3;s:8:\"timezone\";s:3:\"UTC\";}s:6:\"is_pro\";i:1;}i:79;a:11:{s:16:\"import_file_name\";s:12:\"Football PRO\";s:4:\"slug\";s:12:\"football-pro\";s:10:\"categories\";a:1:{i:0;s:12:\"sport-travel\";}s:15:\"import_file_url\";s:89:\"https://colibri-demo-sites.s3.us-west-2.amazonaws.com/production/football-pro/content.xml\";s:22:\"import_widget_file_url\";s:89:\"https://colibri-demo-sites.s3.us-west-2.amazonaws.com/production/football-pro/widgets.wie\";s:26:\"import_customizer_file_url\";s:92:\"https://colibri-demo-sites.s3.us-west-2.amazonaws.com/production/football-pro/customizer.dat\";s:24:\"import_preview_image_url\";s:78:\"https://static.colibriwp.com/templates-screenshots/template-122/screenshot.jpg\";s:11:\"preview_url\";s:49:\"https://colibriwp-work.colibriwp.com/football-pro\";s:7:\"plugins\";a:2:{s:36:\"contact-form-7/wp-contact-form-7.php\";s:14:\"Contact Form 7\";s:37:\"mailchimp-for-wp/mailchimp-for-wp.php\";s:30:\"MC4WP: Mailchimp for WordPress\";}s:10:\"updated_at\";a:3:{s:4:\"date\";s:26:\"2021-01-19 15:54:42.000000\";s:13:\"timezone_type\";i:3;s:8:\"timezone\";s:3:\"UTC\";}s:6:\"is_pro\";i:1;}i:80;a:11:{s:16:\"import_file_name\";s:12:\"Swimming PRO\";s:4:\"slug\";s:12:\"swimming-pro\";s:10:\"categories\";a:1:{i:0;s:12:\"sport-travel\";}s:15:\"import_file_url\";s:89:\"https://colibri-demo-sites.s3.us-west-2.amazonaws.com/production/swimming-pro/content.xml\";s:22:\"import_widget_file_url\";s:89:\"https://colibri-demo-sites.s3.us-west-2.amazonaws.com/production/swimming-pro/widgets.wie\";s:26:\"import_customizer_file_url\";s:92:\"https://colibri-demo-sites.s3.us-west-2.amazonaws.com/production/swimming-pro/customizer.dat\";s:24:\"import_preview_image_url\";s:78:\"https://static.colibriwp.com/templates-screenshots/swimming-pro/screenshot.jpg\";s:11:\"preview_url\";s:49:\"https://colibriwp-work.colibriwp.com/swimming-pro\";s:7:\"plugins\";a:2:{s:36:\"contact-form-7/wp-contact-form-7.php\";s:14:\"Contact Form 7\";s:37:\"mailchimp-for-wp/mailchimp-for-wp.php\";s:30:\"MC4WP: Mailchimp for WordPress\";}s:10:\"updated_at\";a:3:{s:4:\"date\";s:26:\"2021-01-19 15:54:40.000000\";s:13:\"timezone_type\";i:3;s:8:\"timezone\";s:3:\"UTC\";}s:6:\"is_pro\";i:1;}i:81;a:11:{s:16:\"import_file_name\";s:16:\"Pest control PRO\";s:4:\"slug\";s:16:\"pest-control-pro\";s:10:\"categories\";a:1:{i:0;s:8:\"services\";}s:15:\"import_file_url\";s:93:\"https://colibri-demo-sites.s3.us-west-2.amazonaws.com/production/pest-control-pro/content.xml\";s:22:\"import_widget_file_url\";s:93:\"https://colibri-demo-sites.s3.us-west-2.amazonaws.com/production/pest-control-pro/widgets.wie\";s:26:\"import_customizer_file_url\";s:96:\"https://colibri-demo-sites.s3.us-west-2.amazonaws.com/production/pest-control-pro/customizer.dat\";s:24:\"import_preview_image_url\";s:82:\"https://static.colibriwp.com/templates-screenshots/pest-control-pro/screenshot.jpg\";s:11:\"preview_url\";s:53:\"https://colibriwp-work.colibriwp.com/pest-control-pro\";s:7:\"plugins\";a:1:{s:36:\"contact-form-7/wp-contact-form-7.php\";s:14:\"Contact Form 7\";}s:10:\"updated_at\";a:3:{s:4:\"date\";s:26:\"2021-01-19 15:54:37.000000\";s:13:\"timezone_type\";i:3;s:8:\"timezone\";s:3:\"UTC\";}s:6:\"is_pro\";i:1;}i:82;a:11:{s:16:\"import_file_name\";s:19:\"Coworking Space PRO\";s:4:\"slug\";s:19:\"coworking-space-pro\";s:10:\"categories\";a:1:{i:0;s:8:\"business\";}s:15:\"import_file_url\";s:96:\"https://colibri-demo-sites.s3.us-west-2.amazonaws.com/production/coworking-space-pro/content.xml\";s:22:\"import_widget_file_url\";s:96:\"https://colibri-demo-sites.s3.us-west-2.amazonaws.com/production/coworking-space-pro/widgets.wie\";s:26:\"import_customizer_file_url\";s:99:\"https://colibri-demo-sites.s3.us-west-2.amazonaws.com/production/coworking-space-pro/customizer.dat\";s:24:\"import_preview_image_url\";s:85:\"https://static.colibriwp.com/templates-screenshots/coworking-space-pro/screenshot.jpg\";s:11:\"preview_url\";s:56:\"https://colibriwp-work.colibriwp.com/coworking-space-pro\";s:7:\"plugins\";a:2:{s:36:\"contact-form-7/wp-contact-form-7.php\";s:14:\"Contact Form 7\";s:37:\"mailchimp-for-wp/mailchimp-for-wp.php\";s:30:\"MC4WP: Mailchimp for WordPress\";}s:10:\"updated_at\";a:3:{s:4:\"date\";s:26:\"2020-10-21 11:27:45.000000\";s:13:\"timezone_type\";i:3;s:8:\"timezone\";s:3:\"UTC\";}s:6:\"is_pro\";i:1;}i:83;a:11:{s:16:\"import_file_name\";s:9:\"Print PRO\";s:4:\"slug\";s:9:\"print-pro\";s:10:\"categories\";a:1:{i:0;s:8:\"services\";}s:15:\"import_file_url\";s:86:\"https://colibri-demo-sites.s3.us-west-2.amazonaws.com/production/print-pro/content.xml\";s:22:\"import_widget_file_url\";s:86:\"https://colibri-demo-sites.s3.us-west-2.amazonaws.com/production/print-pro/widgets.wie\";s:26:\"import_customizer_file_url\";s:89:\"https://colibri-demo-sites.s3.us-west-2.amazonaws.com/production/print-pro/customizer.dat\";s:24:\"import_preview_image_url\";s:75:\"https://static.colibriwp.com/templates-screenshots/print-pro/screenshot.jpg\";s:11:\"preview_url\";s:46:\"https://colibriwp-work.colibriwp.com/print-pro\";s:7:\"plugins\";a:1:{s:36:\"contact-form-7/wp-contact-form-7.php\";s:14:\"Contact Form 7\";}s:10:\"updated_at\";a:3:{s:4:\"date\";s:26:\"2020-09-25 08:38:43.000000\";s:13:\"timezone_type\";i:3;s:8:\"timezone\";s:3:\"UTC\";}s:6:\"is_pro\";i:1;}i:84;a:11:{s:16:\"import_file_name\";s:14:\"Accountant PRO\";s:4:\"slug\";s:14:\"accountant-pro\";s:10:\"categories\";a:1:{i:0;s:8:\"services\";}s:15:\"import_file_url\";s:91:\"https://colibri-demo-sites.s3.us-west-2.amazonaws.com/production/accountant-pro/content.xml\";s:22:\"import_widget_file_url\";s:91:\"https://colibri-demo-sites.s3.us-west-2.amazonaws.com/production/accountant-pro/widgets.wie\";s:26:\"import_customizer_file_url\";s:94:\"https://colibri-demo-sites.s3.us-west-2.amazonaws.com/production/accountant-pro/customizer.dat\";s:24:\"import_preview_image_url\";s:80:\"https://static.colibriwp.com/templates-screenshots/accountant-pro/screenshot.jpg\";s:11:\"preview_url\";s:51:\"https://colibriwp-work.colibriwp.com/accountant-pro\";s:7:\"plugins\";a:1:{s:36:\"contact-form-7/wp-contact-form-7.php\";s:14:\"Contact Form 7\";}s:10:\"updated_at\";a:3:{s:4:\"date\";s:26:\"2020-11-19 08:49:32.000000\";s:13:\"timezone_type\";i:3;s:8:\"timezone\";s:3:\"UTC\";}s:6:\"is_pro\";i:1;}i:85;a:11:{s:16:\"import_file_name\";s:22:\"Marketing services PRO\";s:4:\"slug\";s:22:\"marketing-services-pro\";s:10:\"categories\";a:1:{i:0;s:8:\"business\";}s:15:\"import_file_url\";s:99:\"https://colibri-demo-sites.s3.us-west-2.amazonaws.com/production/marketing-services-pro/content.xml\";s:22:\"import_widget_file_url\";s:99:\"https://colibri-demo-sites.s3.us-west-2.amazonaws.com/production/marketing-services-pro/widgets.wie\";s:26:\"import_customizer_file_url\";s:102:\"https://colibri-demo-sites.s3.us-west-2.amazonaws.com/production/marketing-services-pro/customizer.dat\";s:24:\"import_preview_image_url\";s:88:\"https://static.colibriwp.com/templates-screenshots/marketing-services-pro/screenshot.jpg\";s:11:\"preview_url\";s:59:\"https://colibriwp-work.colibriwp.com/marketing-services-pro\";s:7:\"plugins\";a:1:{s:36:\"contact-form-7/wp-contact-form-7.php\";s:14:\"Contact Form 7\";}s:10:\"updated_at\";a:3:{s:4:\"date\";s:26:\"2020-09-25 08:09:48.000000\";s:13:\"timezone_type\";i:3;s:8:\"timezone\";s:3:\"UTC\";}s:6:\"is_pro\";i:1;}i:86;a:11:{s:16:\"import_file_name\";s:17:\"Web Developer PRO\";s:4:\"slug\";s:17:\"web-developer-pro\";s:10:\"categories\";a:1:{i:0;s:9:\"portfolio\";}s:15:\"import_file_url\";s:94:\"https://colibri-demo-sites.s3.us-west-2.amazonaws.com/production/web-developer-pro/content.xml\";s:22:\"import_widget_file_url\";s:94:\"https://colibri-demo-sites.s3.us-west-2.amazonaws.com/production/web-developer-pro/widgets.wie\";s:26:\"import_customizer_file_url\";s:97:\"https://colibri-demo-sites.s3.us-west-2.amazonaws.com/production/web-developer-pro/customizer.dat\";s:24:\"import_preview_image_url\";s:83:\"https://static.colibriwp.com/templates-screenshots/web-developer-pro/screenshot.jpg\";s:11:\"preview_url\";s:54:\"https://colibriwp-work.colibriwp.com/web-developer-pro\";s:7:\"plugins\";a:1:{s:36:\"contact-form-7/wp-contact-form-7.php\";s:14:\"Contact Form 7\";}s:10:\"updated_at\";a:3:{s:4:\"date\";s:26:\"2020-12-15 06:17:47.000000\";s:13:\"timezone_type\";i:3;s:8:\"timezone\";s:3:\"UTC\";}s:6:\"is_pro\";i:1;}i:87;a:11:{s:16:\"import_file_name\";s:24:\"Full Stack Developer PRO\";s:4:\"slug\";s:24:\"full-stack-developer-pro\";s:10:\"categories\";a:1:{i:0;s:9:\"portfolio\";}s:15:\"import_file_url\";s:101:\"https://colibri-demo-sites.s3.us-west-2.amazonaws.com/production/full-stack-developer-pro/content.xml\";s:22:\"import_widget_file_url\";s:101:\"https://colibri-demo-sites.s3.us-west-2.amazonaws.com/production/full-stack-developer-pro/widgets.wie\";s:26:\"import_customizer_file_url\";s:104:\"https://colibri-demo-sites.s3.us-west-2.amazonaws.com/production/full-stack-developer-pro/customizer.dat\";s:24:\"import_preview_image_url\";s:90:\"https://static.colibriwp.com/templates-screenshots/full-stack-developer-pro/screenshot.jpg\";s:11:\"preview_url\";s:61:\"https://colibriwp-work.colibriwp.com/full-stack-developer-pro\";s:7:\"plugins\";a:1:{s:36:\"contact-form-7/wp-contact-form-7.php\";s:14:\"Contact Form 7\";}s:10:\"updated_at\";a:3:{s:4:\"date\";s:26:\"2020-12-15 06:17:33.000000\";s:13:\"timezone_type\";i:3;s:8:\"timezone\";s:3:\"UTC\";}s:6:\"is_pro\";i:1;}i:88;a:11:{s:16:\"import_file_name\";s:19:\"Holistic Healer PRO\";s:4:\"slug\";s:19:\"holistic-healer-pro\";s:10:\"categories\";a:1:{i:0;s:8:\"services\";}s:15:\"import_file_url\";s:96:\"https://colibri-demo-sites.s3.us-west-2.amazonaws.com/production/holistic-healer-pro/content.xml\";s:22:\"import_widget_file_url\";s:96:\"https://colibri-demo-sites.s3.us-west-2.amazonaws.com/production/holistic-healer-pro/widgets.wie\";s:26:\"import_customizer_file_url\";s:99:\"https://colibri-demo-sites.s3.us-west-2.amazonaws.com/production/holistic-healer-pro/customizer.dat\";s:24:\"import_preview_image_url\";s:85:\"https://static.colibriwp.com/templates-screenshots/holistic-healer-pro/screenshot.jpg\";s:11:\"preview_url\";s:56:\"https://colibriwp-work.colibriwp.com/holistic-healer-pro\";s:7:\"plugins\";a:1:{s:36:\"contact-form-7/wp-contact-form-7.php\";s:14:\"Contact Form 7\";}s:10:\"updated_at\";a:3:{s:4:\"date\";s:26:\"2021-01-19 15:54:19.000000\";s:13:\"timezone_type\";i:3;s:8:\"timezone\";s:3:\"UTC\";}s:6:\"is_pro\";i:1;}i:89;a:11:{s:16:\"import_file_name\";s:10:\"Rental PRO\";s:4:\"slug\";s:10:\"rental-pro\";s:10:\"categories\";a:1:{i:0;s:12:\"sport-travel\";}s:15:\"import_file_url\";s:87:\"https://colibri-demo-sites.s3.us-west-2.amazonaws.com/production/rental-pro/content.xml\";s:22:\"import_widget_file_url\";s:87:\"https://colibri-demo-sites.s3.us-west-2.amazonaws.com/production/rental-pro/widgets.wie\";s:26:\"import_customizer_file_url\";s:90:\"https://colibri-demo-sites.s3.us-west-2.amazonaws.com/production/rental-pro/customizer.dat\";s:24:\"import_preview_image_url\";s:76:\"https://static.colibriwp.com/templates-screenshots/rental-pro/screenshot.jpg\";s:11:\"preview_url\";s:47:\"https://colibriwp-work.colibriwp.com/rental-pro\";s:7:\"plugins\";a:1:{s:36:\"contact-form-7/wp-contact-form-7.php\";s:14:\"Contact Form 7\";}s:10:\"updated_at\";a:3:{s:4:\"date\";s:26:\"2020-10-05 12:12:27.000000\";s:13:\"timezone_type\";i:3;s:8:\"timezone\";s:3:\"UTC\";}s:6:\"is_pro\";i:1;}i:90;a:11:{s:16:\"import_file_name\";s:13:\"Pub / Bar PRO\";s:4:\"slug\";s:11:\"pub-bar-pro\";s:10:\"categories\";a:1:{i:0;s:10:\"food-drink\";}s:15:\"import_file_url\";s:88:\"https://colibri-demo-sites.s3.us-west-2.amazonaws.com/production/pub-bar-pro/content.xml\";s:22:\"import_widget_file_url\";s:88:\"https://colibri-demo-sites.s3.us-west-2.amazonaws.com/production/pub-bar-pro/widgets.wie\";s:26:\"import_customizer_file_url\";s:91:\"https://colibri-demo-sites.s3.us-west-2.amazonaws.com/production/pub-bar-pro/customizer.dat\";s:24:\"import_preview_image_url\";s:77:\"https://static.colibriwp.com/templates-screenshots/pub-bar-pro/screenshot.jpg\";s:11:\"preview_url\";s:48:\"https://colibriwp-work.colibriwp.com/pub-bar-pro\";s:7:\"plugins\";a:1:{s:36:\"contact-form-7/wp-contact-form-7.php\";s:14:\"Contact Form 7\";}s:10:\"updated_at\";a:3:{s:4:\"date\";s:26:\"2021-01-19 15:54:17.000000\";s:13:\"timezone_type\";i:3;s:8:\"timezone\";s:3:\"UTC\";}s:6:\"is_pro\";i:1;}i:91;a:11:{s:16:\"import_file_name\";s:14:\"Motorcycle PRO\";s:4:\"slug\";s:14:\"motorcycle-pro\";s:10:\"categories\";a:1:{i:0;s:8:\"services\";}s:15:\"import_file_url\";s:91:\"https://colibri-demo-sites.s3.us-west-2.amazonaws.com/production/motorcycle-pro/content.xml\";s:22:\"import_widget_file_url\";s:91:\"https://colibri-demo-sites.s3.us-west-2.amazonaws.com/production/motorcycle-pro/widgets.wie\";s:26:\"import_customizer_file_url\";s:94:\"https://colibri-demo-sites.s3.us-west-2.amazonaws.com/production/motorcycle-pro/customizer.dat\";s:24:\"import_preview_image_url\";s:80:\"https://static.colibriwp.com/templates-screenshots/motorcycle-pro/screenshot.jpg\";s:11:\"preview_url\";s:51:\"https://colibriwp-work.colibriwp.com/motorcycle-pro\";s:7:\"plugins\";a:1:{s:36:\"contact-form-7/wp-contact-form-7.php\";s:14:\"Contact Form 7\";}s:10:\"updated_at\";a:3:{s:4:\"date\";s:26:\"2021-01-19 15:53:53.000000\";s:13:\"timezone_type\";i:3;s:8:\"timezone\";s:3:\"UTC\";}s:6:\"is_pro\";i:1;}i:92;a:11:{s:16:\"import_file_name\";s:18:\"Transportation PRO\";s:4:\"slug\";s:18:\"transportation-pro\";s:10:\"categories\";a:1:{i:0;s:8:\"business\";}s:15:\"import_file_url\";s:95:\"https://colibri-demo-sites.s3.us-west-2.amazonaws.com/production/transportation-pro/content.xml\";s:22:\"import_widget_file_url\";s:95:\"https://colibri-demo-sites.s3.us-west-2.amazonaws.com/production/transportation-pro/widgets.wie\";s:26:\"import_customizer_file_url\";s:98:\"https://colibri-demo-sites.s3.us-west-2.amazonaws.com/production/transportation-pro/customizer.dat\";s:24:\"import_preview_image_url\";s:84:\"https://static.colibriwp.com/templates-screenshots/transportation-pro/screenshot.jpg\";s:11:\"preview_url\";s:55:\"https://colibriwp-work.colibriwp.com/transportation-pro\";s:7:\"plugins\";a:1:{s:36:\"contact-form-7/wp-contact-form-7.php\";s:14:\"Contact Form 7\";}s:10:\"updated_at\";a:3:{s:4:\"date\";s:26:\"2021-01-04 10:48:31.000000\";s:13:\"timezone_type\";i:3;s:8:\"timezone\";s:3:\"UTC\";}s:6:\"is_pro\";i:1;}i:93;a:11:{s:16:\"import_file_name\";s:20:\"Language Courses PRO\";s:4:\"slug\";s:20:\"language-courses-pro\";s:10:\"categories\";a:1:{i:0;s:8:\"services\";}s:15:\"import_file_url\";s:97:\"https://colibri-demo-sites.s3.us-west-2.amazonaws.com/production/language-courses-pro/content.xml\";s:22:\"import_widget_file_url\";s:97:\"https://colibri-demo-sites.s3.us-west-2.amazonaws.com/production/language-courses-pro/widgets.wie\";s:26:\"import_customizer_file_url\";s:100:\"https://colibri-demo-sites.s3.us-west-2.amazonaws.com/production/language-courses-pro/customizer.dat\";s:24:\"import_preview_image_url\";s:86:\"https://static.colibriwp.com/templates-screenshots/language-courses-pro/screenshot.jpg\";s:11:\"preview_url\";s:57:\"https://colibriwp-work.colibriwp.com/language-courses-pro\";s:7:\"plugins\";a:1:{s:36:\"contact-form-7/wp-contact-form-7.php\";s:14:\"Contact Form 7\";}s:10:\"updated_at\";a:3:{s:4:\"date\";s:26:\"2021-01-19 15:53:41.000000\";s:13:\"timezone_type\";i:3;s:8:\"timezone\";s:3:\"UTC\";}s:6:\"is_pro\";i:1;}i:94;a:11:{s:16:\"import_file_name\";s:8:\"Taxi PRO\";s:4:\"slug\";s:8:\"taxi-pro\";s:10:\"categories\";a:1:{i:0;s:12:\"sport-travel\";}s:15:\"import_file_url\";s:85:\"https://colibri-demo-sites.s3.us-west-2.amazonaws.com/production/taxi-pro/content.xml\";s:22:\"import_widget_file_url\";s:85:\"https://colibri-demo-sites.s3.us-west-2.amazonaws.com/production/taxi-pro/widgets.wie\";s:26:\"import_customizer_file_url\";s:88:\"https://colibri-demo-sites.s3.us-west-2.amazonaws.com/production/taxi-pro/customizer.dat\";s:24:\"import_preview_image_url\";s:74:\"https://static.colibriwp.com/templates-screenshots/taxi-pro/screenshot.jpg\";s:11:\"preview_url\";s:45:\"https://colibriwp-work.colibriwp.com/taxi-pro\";s:7:\"plugins\";a:1:{s:36:\"contact-form-7/wp-contact-form-7.php\";s:14:\"Contact Form 7\";}s:10:\"updated_at\";a:3:{s:4:\"date\";s:26:\"2021-01-19 15:53:39.000000\";s:13:\"timezone_type\";i:3;s:8:\"timezone\";s:3:\"UTC\";}s:6:\"is_pro\";i:1;}i:95;a:11:{s:16:\"import_file_name\";s:11:\"Airclub PRO\";s:4:\"slug\";s:11:\"airclub-pro\";s:10:\"categories\";a:1:{i:0;s:12:\"sport-travel\";}s:15:\"import_file_url\";s:88:\"https://colibri-demo-sites.s3.us-west-2.amazonaws.com/production/airclub-pro/content.xml\";s:22:\"import_widget_file_url\";s:88:\"https://colibri-demo-sites.s3.us-west-2.amazonaws.com/production/airclub-pro/widgets.wie\";s:26:\"import_customizer_file_url\";s:91:\"https://colibri-demo-sites.s3.us-west-2.amazonaws.com/production/airclub-pro/customizer.dat\";s:24:\"import_preview_image_url\";s:77:\"https://static.colibriwp.com/templates-screenshots/airclub-pro/screenshot.jpg\";s:11:\"preview_url\";s:48:\"https://colibriwp-work.colibriwp.com/airclub-pro\";s:7:\"plugins\";a:1:{s:36:\"contact-form-7/wp-contact-form-7.php\";s:14:\"Contact Form 7\";}s:10:\"updated_at\";a:3:{s:4:\"date\";s:26:\"2021-01-19 15:53:11.000000\";s:13:\"timezone_type\";i:3;s:8:\"timezone\";s:3:\"UTC\";}s:6:\"is_pro\";i:1;}i:96;a:11:{s:16:\"import_file_name\";s:15:\"Car service PRO\";s:4:\"slug\";s:15:\"car-service-pro\";s:10:\"categories\";a:1:{i:0;s:8:\"services\";}s:15:\"import_file_url\";s:92:\"https://colibri-demo-sites.s3.us-west-2.amazonaws.com/production/car-service-pro/content.xml\";s:22:\"import_widget_file_url\";s:92:\"https://colibri-demo-sites.s3.us-west-2.amazonaws.com/production/car-service-pro/widgets.wie\";s:26:\"import_customizer_file_url\";s:95:\"https://colibri-demo-sites.s3.us-west-2.amazonaws.com/production/car-service-pro/customizer.dat\";s:24:\"import_preview_image_url\";s:81:\"https://static.colibriwp.com/templates-screenshots/car-service-pro/screenshot.jpg\";s:11:\"preview_url\";s:52:\"https://colibriwp-work.colibriwp.com/car-service-pro\";s:7:\"plugins\";a:1:{s:36:\"contact-form-7/wp-contact-form-7.php\";s:14:\"Contact Form 7\";}s:10:\"updated_at\";a:3:{s:4:\"date\";s:26:\"2021-03-23 12:55:42.000000\";s:13:\"timezone_type\";i:3;s:8:\"timezone\";s:3:\"UTC\";}s:6:\"is_pro\";i:1;}i:97;a:11:{s:16:\"import_file_name\";s:15:\"Christmas gifts\";s:4:\"slug\";s:15:\"christmas-gifts\";s:10:\"categories\";a:1:{i:0;s:9:\"community\";}s:15:\"import_file_url\";s:92:\"https://colibri-demo-sites.s3.us-west-2.amazonaws.com/production/christmas-gifts/content.xml\";s:22:\"import_widget_file_url\";s:92:\"https://colibri-demo-sites.s3.us-west-2.amazonaws.com/production/christmas-gifts/widgets.wie\";s:26:\"import_customizer_file_url\";s:95:\"https://colibri-demo-sites.s3.us-west-2.amazonaws.com/production/christmas-gifts/customizer.dat\";s:24:\"import_preview_image_url\";s:81:\"https://static.colibriwp.com/templates-screenshots/christmas-gifts/screenshot.jpg\";s:11:\"preview_url\";s:52:\"https://colibriwp-work.colibriwp.com/christmas-gifts\";s:7:\"plugins\";a:1:{s:36:\"contact-form-7/wp-contact-form-7.php\";s:14:\"Contact Form 7\";}s:10:\"updated_at\";a:3:{s:4:\"date\";s:26:\"2020-12-17 16:25:20.000000\";s:13:\"timezone_type\";i:3;s:8:\"timezone\";s:3:\"UTC\";}s:6:\"is_pro\";i:1;}i:98;a:11:{s:16:\"import_file_name\";s:16:\"Colibri Handyman\";s:4:\"slug\";s:16:\"colibri-handyman\";s:10:\"categories\";a:1:{i:0;s:8:\"services\";}s:15:\"import_file_url\";s:93:\"https://colibri-demo-sites.s3.us-west-2.amazonaws.com/production/colibri-handyman/content.xml\";s:22:\"import_widget_file_url\";s:93:\"https://colibri-demo-sites.s3.us-west-2.amazonaws.com/production/colibri-handyman/widgets.wie\";s:26:\"import_customizer_file_url\";s:96:\"https://colibri-demo-sites.s3.us-west-2.amazonaws.com/production/colibri-handyman/customizer.dat\";s:24:\"import_preview_image_url\";s:82:\"https://static.colibriwp.com/templates-screenshots/colibri-handyman/screenshot.jpg\";s:11:\"preview_url\";s:53:\"https://colibriwp-work.colibriwp.com/colibri-handyman\";s:7:\"plugins\";a:2:{s:57:\"colibri-template-generator/colibri-template-generator.php\";N;s:36:\"contact-form-7/wp-contact-form-7.php\";s:14:\"Contact Form 7\";}s:10:\"updated_at\";a:3:{s:4:\"date\";s:26:\"2021-06-07 14:29:03.000000\";s:13:\"timezone_type\";i:3;s:8:\"timezone\";s:3:\"UTC\";}s:6:\"is_pro\";i:0;}}}", "yes");
INSERT INTO `wp_options` VALUES("214", "colibri-wp-page-info-theme-notice-dismissed", "1", "yes");
INSERT INTO `wp_options` VALUES("203", "fs_active_plugins", "O:8:\"stdClass\":3:{s:7:\"plugins\";a:1:{s:30:\"olivewp-companion/inc/freemius\";O:8:\"stdClass\":4:{s:7:\"version\";s:5:\"2.4.3\";s:4:\"type\";s:6:\"plugin\";s:9:\"timestamp\";i:1687470422;s:11:\"plugin_path\";s:39:\"olivewp-companion/olivewp-companion.php\";}}s:7:\"abspath\";s:24:\"C:\\wamp64\\www\\wordpress/\";s:6:\"newest\";O:8:\"stdClass\":5:{s:11:\"plugin_path\";s:39:\"olivewp-companion/olivewp-companion.php\";s:8:\"sdk_path\";s:30:\"olivewp-companion/inc/freemius\";s:7:\"version\";s:5:\"2.4.3\";s:13:\"in_activation\";b:0;s:9:\"timestamp\";i:1687472421;}}", "yes");
INSERT INTO `wp_options` VALUES("162", "auto_core_update_notified", "a:4:{s:4:\"type\";s:7:\"success\";s:5:\"email\";s:19:\"devoksy@outlook.com\";s:7:\"version\";s:5:\"6.6.2\";s:9:\"timestamp\";i:1726385254;}", "no");
INSERT INTO `wp_options` VALUES("3468", "_site_transient_timeout_theme_roots", "1730684106", "off");
INSERT INTO `wp_options` VALUES("3469", "_site_transient_theme_roots", "a:16:{s:9:\"appetizer\";s:7:\"/themes\";s:5:\"brite\";s:7:\"/themes\";s:10:\"colibri-wp\";s:7:\"/themes\";s:5:\"enwoo\";s:7:\"/themes\";s:5:\"flash\";s:7:\"/themes\";s:7:\"futurio\";s:7:\"/themes\";s:8:\"honeybee\";s:7:\"/themes\";s:10:\"honeypress\";s:7:\"/themes\";s:7:\"olivewp\";s:7:\"/themes\";s:5:\"rasam\";s:7:\"/themes\";s:10:\"skyline-wp\";s:7:\"/themes\";s:12:\"twentytwenty\";s:7:\"/themes\";s:16:\"twentytwentyfour\";s:7:\"/themes\";s:15:\"twentytwentyone\";s:7:\"/themes\";s:17:\"twentytwentythree\";s:7:\"/themes\";s:15:\"twentytwentytwo\";s:7:\"/themes\";}", "off");
INSERT INTO `wp_options` VALUES("165", "finished_updating_comment_type", "1", "yes");
INSERT INTO `wp_options` VALUES("390", "_site_transient_wp_plugin_dependencies_plugin_data", "a:0:{}", "off");
INSERT INTO `wp_options` VALUES("391", "recently_activated", "a:0:{}", "auto");
INSERT INTO `wp_options` VALUES("3474", "_site_transient_update_plugins", "O:8:\"stdClass\":5:{s:12:\"last_checked\";i:1730682349;s:8:\"response\";a:3:{s:45:\"colibri-page-builder/colibri-page-builder.php\";O:8:\"stdClass\":13:{s:2:\"id\";s:34:\"w.org/plugins/colibri-page-builder\";s:4:\"slug\";s:20:\"colibri-page-builder\";s:6:\"plugin\";s:45:\"colibri-page-builder/colibri-page-builder.php\";s:11:\"new_version\";s:7:\"1.0.305\";s:3:\"url\";s:51:\"https://wordpress.org/plugins/colibri-page-builder/\";s:7:\"package\";s:71:\"https://downloads.wordpress.org/plugin/colibri-page-builder.1.0.305.zip\";s:5:\"icons\";a:2:{s:2:\"2x\";s:73:\"https://ps.w.org/colibri-page-builder/assets/icon-256x256.gif?rev=2748397\";s:2:\"1x\";s:73:\"https://ps.w.org/colibri-page-builder/assets/icon-128x128.gif?rev=2748397\";}s:7:\"banners\";a:1:{s:2:\"1x\";s:75:\"https://ps.w.org/colibri-page-builder/assets/banner-772x250.jpg?rev=2748397\";}s:11:\"banners_rtl\";a:0:{}s:8:\"requires\";s:3:\"5.6\";s:6:\"tested\";s:5:\"6.6.2\";s:12:\"requires_php\";b:0;s:16:\"requires_plugins\";a:0:{}}s:25:\"forminator/forminator.php\";O:8:\"stdClass\":13:{s:2:\"id\";s:24:\"w.org/plugins/forminator\";s:4:\"slug\";s:10:\"forminator\";s:6:\"plugin\";s:25:\"forminator/forminator.php\";s:11:\"new_version\";s:6:\"1.36.3\";s:3:\"url\";s:41:\"https://wordpress.org/plugins/forminator/\";s:7:\"package\";s:60:\"https://downloads.wordpress.org/plugin/forminator.1.36.3.zip\";s:5:\"icons\";a:2:{s:2:\"2x\";s:63:\"https://ps.w.org/forminator/assets/icon-256x256.png?rev=2746202\";s:2:\"1x\";s:63:\"https://ps.w.org/forminator/assets/icon-128x128.png?rev=2746202\";}s:7:\"banners\";a:2:{s:2:\"2x\";s:66:\"https://ps.w.org/forminator/assets/banner-1544x500.png?rev=2626060\";s:2:\"1x\";s:65:\"https://ps.w.org/forminator/assets/banner-772x250.png?rev=2626060\";}s:11:\"banners_rtl\";a:0:{}s:8:\"requires\";s:3:\"6.4\";s:6:\"tested\";s:5:\"6.6.2\";s:12:\"requires_php\";s:3:\"7.4\";s:16:\"requires_plugins\";a:0:{}}s:42:\"simple-membership/simple-wp-membership.php\";O:8:\"stdClass\":13:{s:2:\"id\";s:31:\"w.org/plugins/simple-membership\";s:4:\"slug\";s:17:\"simple-membership\";s:6:\"plugin\";s:42:\"simple-membership/simple-wp-membership.php\";s:11:\"new_version\";s:5:\"4.5.5\";s:3:\"url\";s:48:\"https://wordpress.org/plugins/simple-membership/\";s:7:\"package\";s:66:\"https://downloads.wordpress.org/plugin/simple-membership.4.5.5.zip\";s:5:\"icons\";a:1:{s:2:\"1x\";s:69:\"https://ps.w.org/simple-membership/assets/icon-128x128.png?rev=974529\";}s:7:\"banners\";a:1:{s:2:\"1x\";s:71:\"https://ps.w.org/simple-membership/assets/banner-772x250.jpg?rev=923517\";}s:11:\"banners_rtl\";a:0:{}s:8:\"requires\";s:3:\"5.0\";s:6:\"tested\";s:3:\"6.7\";s:12:\"requires_php\";s:3:\"7.4\";s:16:\"requires_plugins\";a:0:{}}}s:12:\"translations\";a:0:{}s:9:\"no_update\";a:4:{s:19:\"akismet/akismet.php\";O:8:\"stdClass\":10:{s:2:\"id\";s:21:\"w.org/plugins/akismet\";s:4:\"slug\";s:7:\"akismet\";s:6:\"plugin\";s:19:\"akismet/akismet.php\";s:11:\"new_version\";s:5:\"5.3.3\";s:3:\"url\";s:38:\"https://wordpress.org/plugins/akismet/\";s:7:\"package\";s:56:\"https://downloads.wordpress.org/plugin/akismet.5.3.3.zip\";s:5:\"icons\";a:2:{s:2:\"2x\";s:60:\"https://ps.w.org/akismet/assets/icon-256x256.png?rev=2818463\";s:2:\"1x\";s:60:\"https://ps.w.org/akismet/assets/icon-128x128.png?rev=2818463\";}s:7:\"banners\";a:2:{s:2:\"2x\";s:63:\"https://ps.w.org/akismet/assets/banner-1544x500.png?rev=2900731\";s:2:\"1x\";s:62:\"https://ps.w.org/akismet/assets/banner-772x250.png?rev=2900731\";}s:11:\"banners_rtl\";a:0:{}s:8:\"requires\";s:3:\"5.8\";}s:25:\"duplicator/duplicator.php\";O:8:\"stdClass\":10:{s:2:\"id\";s:24:\"w.org/plugins/duplicator\";s:4:\"slug\";s:10:\"duplicator\";s:6:\"plugin\";s:25:\"duplicator/duplicator.php\";s:11:\"new_version\";s:8:\"1.5.11.1\";s:3:\"url\";s:41:\"https://wordpress.org/plugins/duplicator/\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/plugin/duplicator.1.5.11.1.zip\";s:5:\"icons\";a:2:{s:2:\"2x\";s:63:\"https://ps.w.org/duplicator/assets/icon-256x256.png?rev=2906985\";s:2:\"1x\";s:63:\"https://ps.w.org/duplicator/assets/icon-128x128.png?rev=2906985\";}s:7:\"banners\";a:2:{s:2:\"2x\";s:66:\"https://ps.w.org/duplicator/assets/banner-1544x500.png?rev=2906985\";s:2:\"1x\";s:65:\"https://ps.w.org/duplicator/assets/banner-772x250.png?rev=2906985\";}s:11:\"banners_rtl\";a:0:{}s:8:\"requires\";s:3:\"4.9\";}s:9:\"hello.php\";O:8:\"stdClass\":10:{s:2:\"id\";s:25:\"w.org/plugins/hello-dolly\";s:4:\"slug\";s:11:\"hello-dolly\";s:6:\"plugin\";s:9:\"hello.php\";s:11:\"new_version\";s:5:\"1.7.2\";s:3:\"url\";s:42:\"https://wordpress.org/plugins/hello-dolly/\";s:7:\"package\";s:60:\"https://downloads.wordpress.org/plugin/hello-dolly.1.7.3.zip\";s:5:\"icons\";a:2:{s:2:\"2x\";s:64:\"https://ps.w.org/hello-dolly/assets/icon-256x256.jpg?rev=2052855\";s:2:\"1x\";s:64:\"https://ps.w.org/hello-dolly/assets/icon-128x128.jpg?rev=2052855\";}s:7:\"banners\";a:2:{s:2:\"2x\";s:67:\"https://ps.w.org/hello-dolly/assets/banner-1544x500.jpg?rev=2645582\";s:2:\"1x\";s:66:\"https://ps.w.org/hello-dolly/assets/banner-772x250.jpg?rev=2052855\";}s:11:\"banners_rtl\";a:0:{}s:8:\"requires\";s:3:\"4.6\";}s:39:\"olivewp-companion/olivewp-companion.php\";O:8:\"stdClass\":10:{s:2:\"id\";s:31:\"w.org/plugins/olivewp-companion\";s:4:\"slug\";s:17:\"olivewp-companion\";s:6:\"plugin\";s:39:\"olivewp-companion/olivewp-companion.php\";s:11:\"new_version\";s:5:\"1.1.2\";s:3:\"url\";s:48:\"https://wordpress.org/plugins/olivewp-companion/\";s:7:\"package\";s:66:\"https://downloads.wordpress.org/plugin/olivewp-companion.1.1.2.zip\";s:5:\"icons\";a:1:{s:7:\"default\";s:61:\"https://s.w.org/plugins/geopattern-icon/olivewp-companion.svg\";}s:7:\"banners\";a:0:{}s:11:\"banners_rtl\";a:0:{}s:8:\"requires\";s:3:\"5.3\";}}s:7:\"checked\";a:7:{s:19:\"akismet/akismet.php\";s:5:\"5.3.3\";s:45:\"colibri-page-builder/colibri-page-builder.php\";s:7:\"1.0.288\";s:25:\"duplicator/duplicator.php\";s:8:\"1.5.11.1\";s:25:\"forminator/forminator.php\";s:6:\"1.35.0\";s:9:\"hello.php\";s:5:\"1.7.2\";s:39:\"olivewp-companion/olivewp-companion.php\";s:5:\"1.1.2\";s:42:\"simple-membership/simple-wp-membership.php\";s:5:\"4.5.4\";}}", "off");
INSERT INTO `wp_options` VALUES("3475", "_site_transient_update_themes", "O:8:\"stdClass\":5:{s:12:\"last_checked\";i:1730682349;s:7:\"checked\";a:16:{s:9:\"appetizer\";s:5:\"1.0.9\";s:5:\"brite\";s:6:\"1.0.25\";s:10:\"colibri-wp\";s:6:\"1.0.92\";s:5:\"enwoo\";s:5:\"1.3.5\";s:5:\"flash\";s:5:\"1.4.5\";s:7:\"futurio\";s:5:\"1.5.1\";s:8:\"honeybee\";s:5:\"2.2.5\";s:10:\"honeypress\";s:5:\"2.3.8\";s:7:\"olivewp\";s:5:\"1.1.3\";s:5:\"rasam\";s:5:\"1.0.6\";s:10:\"skyline-wp\";s:5:\"1.0.8\";s:12:\"twentytwenty\";s:3:\"1.9\";s:16:\"twentytwentyfour\";s:3:\"1.2\";s:15:\"twentytwentyone\";s:3:\"1.5\";s:17:\"twentytwentythree\";s:3:\"1.1\";s:15:\"twentytwentytwo\";s:3:\"1.1\";}s:8:\"response\";a:14:{s:9:\"appetizer\";a:6:{s:5:\"theme\";s:9:\"appetizer\";s:11:\"new_version\";s:6:\"1.1.10\";s:3:\"url\";s:39:\"https://wordpress.org/themes/appetizer/\";s:7:\"package\";s:58:\"https://downloads.wordpress.org/theme/appetizer.1.1.10.zip\";s:8:\"requires\";b:0;s:12:\"requires_php\";s:3:\"5.6\";}s:5:\"brite\";a:6:{s:5:\"theme\";s:5:\"brite\";s:11:\"new_version\";s:6:\"1.0.31\";s:3:\"url\";s:35:\"https://wordpress.org/themes/brite/\";s:7:\"package\";s:54:\"https://downloads.wordpress.org/theme/brite.1.0.31.zip\";s:8:\"requires\";b:0;s:12:\"requires_php\";s:3:\"5.6\";}s:10:\"colibri-wp\";a:6:{s:5:\"theme\";s:10:\"colibri-wp\";s:11:\"new_version\";s:7:\"1.0.125\";s:3:\"url\";s:40:\"https://wordpress.org/themes/colibri-wp/\";s:7:\"package\";s:60:\"https://downloads.wordpress.org/theme/colibri-wp.1.0.125.zip\";s:8:\"requires\";b:0;s:12:\"requires_php\";s:3:\"5.6\";}s:5:\"enwoo\";a:6:{s:5:\"theme\";s:5:\"enwoo\";s:11:\"new_version\";s:5:\"1.4.0\";s:3:\"url\";s:35:\"https://wordpress.org/themes/enwoo/\";s:7:\"package\";s:53:\"https://downloads.wordpress.org/theme/enwoo.1.4.0.zip\";s:8:\"requires\";b:0;s:12:\"requires_php\";s:3:\"5.6\";}s:5:\"flash\";a:6:{s:5:\"theme\";s:5:\"flash\";s:11:\"new_version\";s:5:\"1.4.7\";s:3:\"url\";s:35:\"https://wordpress.org/themes/flash/\";s:7:\"package\";s:53:\"https://downloads.wordpress.org/theme/flash.1.4.7.zip\";s:8:\"requires\";b:0;s:12:\"requires_php\";s:3:\"5.6\";}s:7:\"futurio\";a:6:{s:5:\"theme\";s:7:\"futurio\";s:11:\"new_version\";s:5:\"1.5.4\";s:3:\"url\";s:37:\"https://wordpress.org/themes/futurio/\";s:7:\"package\";s:55:\"https://downloads.wordpress.org/theme/futurio.1.5.4.zip\";s:8:\"requires\";b:0;s:12:\"requires_php\";s:3:\"5.6\";}s:8:\"honeybee\";a:6:{s:5:\"theme\";s:8:\"honeybee\";s:11:\"new_version\";s:5:\"2.2.8\";s:3:\"url\";s:38:\"https://wordpress.org/themes/honeybee/\";s:7:\"package\";s:56:\"https://downloads.wordpress.org/theme/honeybee.2.2.8.zip\";s:8:\"requires\";s:3:\"4.5\";s:12:\"requires_php\";s:3:\"5.4\";}s:10:\"honeypress\";a:6:{s:5:\"theme\";s:10:\"honeypress\";s:11:\"new_version\";s:5:\"2.4.2\";s:3:\"url\";s:40:\"https://wordpress.org/themes/honeypress/\";s:7:\"package\";s:58:\"https://downloads.wordpress.org/theme/honeypress.2.4.2.zip\";s:8:\"requires\";s:3:\"4.5\";s:12:\"requires_php\";s:3:\"5.4\";}s:5:\"rasam\";a:6:{s:5:\"theme\";s:5:\"rasam\";s:11:\"new_version\";s:6:\"1.0.17\";s:3:\"url\";s:35:\"https://wordpress.org/themes/rasam/\";s:7:\"package\";s:54:\"https://downloads.wordpress.org/theme/rasam.1.0.17.zip\";s:8:\"requires\";b:0;s:12:\"requires_php\";s:3:\"5.6\";}s:10:\"skyline-wp\";a:6:{s:5:\"theme\";s:10:\"skyline-wp\";s:11:\"new_version\";s:6:\"1.0.21\";s:3:\"url\";s:40:\"https://wordpress.org/themes/skyline-wp/\";s:7:\"package\";s:59:\"https://downloads.wordpress.org/theme/skyline-wp.1.0.21.zip\";s:8:\"requires\";b:0;s:12:\"requires_php\";s:3:\"5.6\";}s:12:\"twentytwenty\";a:6:{s:5:\"theme\";s:12:\"twentytwenty\";s:11:\"new_version\";s:3:\"2.7\";s:3:\"url\";s:42:\"https://wordpress.org/themes/twentytwenty/\";s:7:\"package\";s:58:\"https://downloads.wordpress.org/theme/twentytwenty.2.7.zip\";s:8:\"requires\";s:3:\"4.7\";s:12:\"requires_php\";s:5:\"5.2.4\";}s:15:\"twentytwentyone\";a:6:{s:5:\"theme\";s:15:\"twentytwentyone\";s:11:\"new_version\";s:3:\"2.3\";s:3:\"url\";s:45:\"https://wordpress.org/themes/twentytwentyone/\";s:7:\"package\";s:61:\"https://downloads.wordpress.org/theme/twentytwentyone.2.3.zip\";s:8:\"requires\";s:3:\"5.3\";s:12:\"requires_php\";s:3:\"5.6\";}s:17:\"twentytwentythree\";a:6:{s:5:\"theme\";s:17:\"twentytwentythree\";s:11:\"new_version\";s:3:\"1.5\";s:3:\"url\";s:47:\"https://wordpress.org/themes/twentytwentythree/\";s:7:\"package\";s:63:\"https://downloads.wordpress.org/theme/twentytwentythree.1.5.zip\";s:8:\"requires\";s:3:\"6.1\";s:12:\"requires_php\";s:3:\"5.6\";}s:15:\"twentytwentytwo\";a:6:{s:5:\"theme\";s:15:\"twentytwentytwo\";s:11:\"new_version\";s:3:\"1.8\";s:3:\"url\";s:45:\"https://wordpress.org/themes/twentytwentytwo/\";s:7:\"package\";s:61:\"https://downloads.wordpress.org/theme/twentytwentytwo.1.8.zip\";s:8:\"requires\";s:3:\"5.9\";s:12:\"requires_php\";s:3:\"5.6\";}}s:9:\"no_update\";a:2:{s:7:\"olivewp\";a:6:{s:5:\"theme\";s:7:\"olivewp\";s:11:\"new_version\";s:5:\"1.1.3\";s:3:\"url\";s:37:\"https://wordpress.org/themes/olivewp/\";s:7:\"package\";s:55:\"https://downloads.wordpress.org/theme/olivewp.1.1.3.zip\";s:8:\"requires\";s:3:\"4.5\";s:12:\"requires_php\";s:3:\"5.4\";}s:16:\"twentytwentyfour\";a:6:{s:5:\"theme\";s:16:\"twentytwentyfour\";s:11:\"new_version\";s:3:\"1.2\";s:3:\"url\";s:46:\"https://wordpress.org/themes/twentytwentyfour/\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/theme/twentytwentyfour.1.2.zip\";s:8:\"requires\";s:3:\"6.4\";s:12:\"requires_php\";s:3:\"7.0\";}}s:12:\"translations\";a:0:{}}", "off");
INSERT INTO `wp_options` VALUES("420", "forminator_free_install_date", "1726941878", "off");
INSERT INTO `wp_options` VALUES("421", "schema-ActionScheduler_StoreSchema", "7.0.1726934678", "auto");
INSERT INTO `wp_options` VALUES("422", "forminator_action_scheduler_db_updated", "1", "auto");
INSERT INTO `wp_options` VALUES("423", "wpmudev_recommended_plugins_registered", "a:1:{s:25:\"forminator/forminator.php\";a:1:{s:13:\"registered_at\";i:1726934678;}}", "off");
INSERT INTO `wp_options` VALUES("424", "forminator_default_report_entry", "1", "auto");
INSERT INTO `wp_options` VALUES("425", "forminator_version", "1.35.0", "auto");
INSERT INTO `wp_options` VALUES("426", "widget_forminator_widget", "a:1:{s:12:\"_multiwidget\";i:1;}", "auto");
INSERT INTO `wp_options` VALUES("427", "schema-ActionScheduler_LoggerSchema", "3.0.1726934679", "auto");
INSERT INTO `wp_options` VALUES("433", "action_scheduler_lock_async-request-runner", "67281e727e3c32.40141726|1730682542", "no");
INSERT INTO `wp_options` VALUES("1983", "swpm_email_activation_lvl_2", "1", "off");
INSERT INTO `wp_options` VALUES("1984", "swpm-messages", "a:0:{}", "auto");
INSERT INTO `wp_options` VALUES("1985", "swpm_plugin_activated_time", "1729202844", "auto");
INSERT INTO `wp_options` VALUES("1990", "swpm_ppcp_connect_query_args_production", "a:8:{s:9:\"partnerId\";s:13:\"3FWGC6LFTMTUG\";s:7:\"product\";s:4:\"PPCP\";s:15:\"integrationType\";s:2:\"FO\";s:8:\"features\";s:32:\"PAYMENT,REFUND,BILLING_AGREEMENT\";s:15:\"partnerClientId\";s:80:\"AWo6ovbrHzKZ3hHFJ7APISP4MDTjes-rJPrIgyFyKmbH-i8iaWQpmmaV5hyR21m-I6f_APG6n2rkZbmR\";s:18:\"returnToPartnerUrl\";s:207:\"http%3A%2F%2Flocalhost%2Fwordpress%2Fwp-admin%2Fadmin.php%3Fpage%3Dsimple_wp_membership_payments%26tab%3Dpayment_settings%26subtab%3Dps_pp_api%26swpm_ppcp_after_onboarding%3D1%26environment_mode%3Dproduction\";s:11:\"displayMode\";s:11:\"minibrowser\";s:11:\"sellerNonce\";s:64:\"31eb1d8c66aa0794bcfc8fb55a6b289e1fe24fe6c0d088437f0fbab2de2e957e\";}", "auto");
INSERT INTO `wp_options` VALUES("1991", "swpm_ppcp_connect_query_args_sandbox", "a:8:{s:9:\"partnerId\";s:13:\"47CBLN36AR4Q4\";s:7:\"product\";s:4:\"PPCP\";s:15:\"integrationType\";s:2:\"FO\";s:8:\"features\";s:32:\"PAYMENT,REFUND,BILLING_AGREEMENT\";s:15:\"partnerClientId\";s:80:\"AeO65uHbDsjjFBdx3DO6wffuH2wIHHRDNiF5jmNgXOC8o3rRKkmCJnpmuGzvURwqpyIv-CUYH9cwiuhX\";s:18:\"returnToPartnerUrl\";s:204:\"http%3A%2F%2Flocalhost%2Fwordpress%2Fwp-admin%2Fadmin.php%3Fpage%3Dsimple_wp_membership_payments%26tab%3Dpayment_settings%26subtab%3Dps_pp_api%26swpm_ppcp_after_onboarding%3D1%26environment_mode%3Dsandbox\";s:11:\"displayMode\";s:11:\"minibrowser\";s:11:\"sellerNonce\";s:64:\"4c7430afb4224842e60ee7d17361d4db361ec58637b5d4cfe3a838872d46b8ac\";}", "auto");
INSERT INTO `wp_options` VALUES("3399", "_transient_timeout_colibri_recommended_plugin_forminator_wp_org_data", "1730762662", "off");
INSERT INTO `wp_options` VALUES("3400", "_transient_colibri_recommended_plugin_forminator_wp_org_data", "a:1:{s:5:\"error\";b:1;}", "off");
INSERT INTO `wp_options` VALUES("3401", "_transient_timeout_colibri_recommended_plugin_wp-smushit_wp_org_data", "1730762662", "off");
INSERT INTO `wp_options` VALUES("3402", "_transient_colibri_recommended_plugin_wp-smushit_wp_org_data", "a:1:{s:5:\"error\";b:1;}", "off");
INSERT INTO `wp_options` VALUES("3403", "_transient_timeout_colibri_recommended_plugin_hummingbird-performance_wp_org_data", "1730762662", "off");
INSERT INTO `wp_options` VALUES("3404", "_transient_colibri_recommended_plugin_hummingbird-performance_wp_org_data", "a:1:{s:5:\"error\";b:1;}", "off");
INSERT INTO `wp_options` VALUES("3405", "_transient_timeout_colibri_recommended_plugin_defender-security_wp_org_data", "1730762662", "off");
INSERT INTO `wp_options` VALUES("3406", "_transient_colibri_recommended_plugin_defender-security_wp_org_data", "a:1:{s:5:\"error\";b:1;}", "off");
INSERT INTO `wp_options` VALUES("3407", "_transient_timeout_colibri_recommended_plugin_wordpress-popup_wp_org_data", "1730762662", "off");
INSERT INTO `wp_options` VALUES("3408", "_transient_colibri_recommended_plugin_wordpress-popup_wp_org_data", "a:1:{s:5:\"error\";b:1;}", "off");
INSERT INTO `wp_options` VALUES("864", "theme_mods_enwoo", "a:1:{s:18:\"custom_css_post_id\";i:-1;}", "auto");
INSERT INTO `wp_options` VALUES("872", "theme_mods_rasam", "a:1:{s:18:\"custom_css_post_id\";i:-1;}", "auto");
INSERT INTO `wp_options` VALUES("3470", "_site_transient_timeout_wp_theme_files_patterns-dfb0add5b199c892ab8c83bb29ca4eb4", "1730684108", "off");
INSERT INTO `wp_options` VALUES("3471", "_site_transient_wp_theme_files_patterns-dfb0add5b199c892ab8c83bb29ca4eb4", "a:2:{s:7:\"version\";s:6:\"1.0.25\";s:8:\"patterns\";a:0:{}}", "off");
INSERT INTO `wp_options` VALUES("3473", "_site_transient_update_core", "O:8:\"stdClass\":4:{s:7:\"updates\";a:1:{i:0;O:8:\"stdClass\":10:{s:8:\"response\";s:6:\"latest\";s:8:\"download\";s:65:\"https://downloads.wordpress.org/release/fr_FR/wordpress-6.6.2.zip\";s:6:\"locale\";s:5:\"fr_FR\";s:8:\"packages\";O:8:\"stdClass\":5:{s:4:\"full\";s:65:\"https://downloads.wordpress.org/release/fr_FR/wordpress-6.6.2.zip\";s:10:\"no_content\";s:0:\"\";s:11:\"new_bundled\";s:0:\"\";s:7:\"partial\";s:0:\"\";s:8:\"rollback\";s:0:\"\";}s:7:\"current\";s:5:\"6.6.2\";s:7:\"version\";s:5:\"6.6.2\";s:11:\"php_version\";s:6:\"7.2.24\";s:13:\"mysql_version\";s:5:\"5.5.5\";s:11:\"new_bundled\";s:3:\"6.4\";s:15:\"partial_version\";s:0:\"\";}}s:12:\"last_checked\";i:1730682348;s:15:\"version_checked\";s:5:\"6.6.2\";s:12:\"translations\";a:0:{}}", "off");
INSERT INTO `wp_options` VALUES("407", "colibri_page_builder_activation_time", "1687473202", "auto");
INSERT INTO `wp_options` VALUES("3476", "duplicator_version_plugin", "1.5.11.1", "auto");
INSERT INTO `wp_options` VALUES("3478", "duplicator_install_info", "a:3:{s:7:\"version\";s:8:\"1.5.11.1\";s:4:\"time\";i:1730682349;s:10:\"updateTime\";i:1730682349;}", "off");
INSERT INTO `wp_options` VALUES("3479", "duplicator_uninstall_package", "1", "auto");
INSERT INTO `wp_options` VALUES("3480", "duplicator_uninstall_settings", "1", "auto");
INSERT INTO `wp_options` VALUES("3481", "duplicator_settings", "a:20:{s:7:\"version\";s:8:\"1.5.11.1\";s:18:\"uninstall_settings\";b:1;s:15:\"uninstall_files\";b:1;s:13:\"package_debug\";b:0;s:23:\"email_summary_frequency\";s:6:\"weekly\";s:9:\"amNotices\";b:1;s:17:\"package_mysqldump\";b:1;s:22:\"package_mysqldump_path\";s:0:\"\";s:24:\"package_phpdump_qrylimit\";s:3:\"100\";s:17:\"package_zip_flush\";b:0;s:19:\"installer_name_mode\";s:6:\"simple\";s:16:\"storage_position\";s:6:\"wpcont\";s:20:\"storage_htaccess_off\";b:0;s:18:\"archive_build_mode\";i:2;s:17:\"skip_archive_scan\";b:0;s:21:\"unhook_third_party_js\";b:0;s:22:\"unhook_third_party_css\";b:0;s:17:\"active_package_id\";i:1;s:14:\"usage_tracking\";b:1;i:0;b:0;}", "auto");
INSERT INTO `wp_options` VALUES("3482", "duplicator_plugin_data_stats", "{\n    \"lastSendTime\": 0,\n    \"identifier\": \"YqM_e;hiEsw8Bet_V8=7_v=+&NzcWe;E,=8Gq-bU+f..\",\n    \"plugin\": \"dup-lite\",\n    \"pluginStatus\": \"active\",\n    \"buildCount\": 0,\n    \"buildLastDate\": 0,\n    \"buildFailedCount\": 0,\n    \"buildFailedLastDate\": 0,\n    \"siteSizeMB\": 280.01,\n    \"siteNumFiles\": 10767,\n    \"siteDbSizeMB\": 11.23,\n    \"siteDbNumTables\": 25\n}", "auto");
INSERT INTO `wp_options` VALUES("3483", "duplicator_notifications", "a:4:{s:6:\"update\";i:1730682349;s:4:\"feed\";a:0:{}s:6:\"events\";a:0:{}s:9:\"dismissed\";a:0:{}}", "auto");
INSERT INTO `wp_options` VALUES("3486", "duplicator_ui_view_state", "a:1:{s:22:\"dup-pack-storage-panel\";s:1:\"0\";}", "auto");
INSERT INTO `wp_options` VALUES("3487", "duplicator_package_active", "O:11:\"DUP_Package\":23:{s:7:\"Created\";s:19:\"2024-11-04 01:07:22\";s:7:\"Version\";s:8:\"1.5.11.1\";s:9:\"VersionWP\";s:5:\"6.6.2\";s:9:\"VersionDB\";s:6:\"8.0.27\";s:10:\"VersionPHP\";s:6:\"7.4.26\";s:9:\"VersionOS\";s:5:\"WINNT\";s:2:\"ID\";N;s:4:\"Name\";s:7:\"KARIBEA\";s:4:\"Hash\";s:35:\"70adcb0909cc471c5365_20241104010722\";s:8:\"NameHash\";s:43:\"KARIBEA_70adcb0909cc471c5365_20241104010722\";s:4:\"Type\";i:0;s:5:\"Notes\";s:0:\"\";s:8:\"ScanFile\";s:53:\"KARIBEA_70adcb0909cc471c5365_20241104010722_scan.json\";s:10:\"TimerStart\";i:-1;s:7:\"Runtime\";N;s:7:\"ExeSize\";N;s:7:\"ZipSize\";N;s:6:\"Status\";i:0;s:6:\"WPUser\";N;s:7:\"Archive\";O:11:\"DUP_Archive\":26:{s:10:\"FilterDirs\";s:0:\"\";s:11:\"FilterFiles\";s:0:\"\";s:10:\"FilterExts\";s:0:\"\";s:13:\"FilterDirsAll\";a:0:{}s:14:\"FilterFilesAll\";a:0:{}s:13:\"FilterExtsAll\";a:0:{}s:8:\"FilterOn\";i:0;s:12:\"ExportOnlyDB\";i:0;s:4:\"File\";N;s:6:\"Format\";s:3:\"ZIP\";s:7:\"PackDir\";s:23:\"C:/wamp64/www/wordpress\";s:4:\"Size\";i:0;s:4:\"Dirs\";a:0:{}s:9:\"dirsCount\";i:1504;s:5:\"Files\";a:0:{}s:10:\"filesCount\";i:9263;s:10:\"FilterInfo\";O:23:\"DUP_Archive_Filter_Info\":8:{s:4:\"Dirs\";O:34:\"DUP_Archive_Filter_Scope_Directory\":6:{s:7:\"Warning\";a:0:{}s:10:\"Unreadable\";a:0:{}s:10:\"AddonSites\";a:0:{}s:4:\"Core\";a:0:{}s:6:\"Global\";a:0:{}s:8:\"Instance\";a:0:{}}s:5:\"Files\";O:29:\"DUP_Archive_Filter_Scope_File\":7:{s:4:\"Size\";a:0:{}s:7:\"Warning\";a:0:{}s:10:\"Unreadable\";a:0:{}s:10:\"AddonSites\";a:0:{}s:4:\"Core\";a:0:{}s:6:\"Global\";a:0:{}s:8:\"Instance\";a:0:{}}s:4:\"Exts\";O:29:\"DUP_Archive_Filter_Scope_Base\":3:{s:4:\"Core\";a:0:{}s:6:\"Global\";a:0:{}s:8:\"Instance\";a:0:{}}s:9:\"UDirCount\";i:0;s:10:\"UFileCount\";i:0;s:9:\"UExtCount\";i:0;s:8:\"TreeSize\";a:0:{}s:11:\"TreeWarning\";a:0:{}}s:14:\"RecursiveLinks\";a:0:{}s:10:\"file_count\";i:-1;s:10:\"\0*\0Package\";O:11:\"DUP_Package\":23:{s:7:\"Created\";s:19:\"2024-11-04 01:07:22\";s:7:\"Version\";s:8:\"1.5.11.1\";s:9:\"VersionWP\";s:5:\"6.6.2\";s:9:\"VersionDB\";s:6:\"8.0.27\";s:10:\"VersionPHP\";s:6:\"7.4.26\";s:9:\"VersionOS\";s:5:\"WINNT\";s:2:\"ID\";N;s:4:\"Name\";s:7:\"KARIBEA\";s:4:\"Hash\";s:35:\"70adcb0909cc471c5365_20241104010722\";s:8:\"NameHash\";s:43:\"KARIBEA_70adcb0909cc471c5365_20241104010722\";s:4:\"Type\";i:0;s:5:\"Notes\";s:0:\"\";s:8:\"ScanFile\";N;s:10:\"TimerStart\";i:-1;s:7:\"Runtime\";N;s:7:\"ExeSize\";N;s:7:\"ZipSize\";N;s:6:\"Status\";i:0;s:6:\"WPUser\";N;s:7:\"Archive\";r:21;s:9:\"Installer\";O:13:\"DUP_Installer\":15:{s:4:\"File\";N;s:4:\"Size\";i:0;s:10:\"OptsDBHost\";s:0:\"\";s:10:\"OptsDBPort\";s:0:\"\";s:10:\"OptsDBName\";s:0:\"\";s:10:\"OptsDBUser\";s:0:\"\";s:13:\"OptsDBCharset\";s:0:\"\";s:15:\"OptsDBCollation\";s:0:\"\";s:12:\"OptsSecureOn\";i:0;s:14:\"OptsSecurePass\";s:0:\"\";s:13:\"numFilesAdded\";i:0;s:12:\"numDirsAdded\";i:0;s:10:\"\0*\0Package\";r:65;s:17:\"\0*\0origFileManger\";N;s:32:\"\0DUP_Installer\0configTransformer\";O:44:\"Duplicator\\Libs\\WpConfig\\WPConfigTransformer\":3:{s:17:\"\0*\0wp_config_path\";s:37:\"C:/wamp64/www/wordpress/wp-config.php\";s:16:\"\0*\0wp_config_src\";N;s:13:\"\0*\0wp_configs\";a:0:{}}}s:8:\"Database\";O:12:\"DUP_Database\":15:{s:4:\"Type\";s:5:\"MySQL\";s:4:\"Size\";N;s:4:\"File\";N;s:4:\"Path\";N;s:12:\"FilterTables\";s:0:\"\";s:8:\"FilterOn\";i:0;s:4:\"Name\";N;s:10:\"Compatible\";s:0:\"\";s:8:\"Comments\";s:28:\"MySQL Community Server - GPL\";s:19:\"sameNameTableExists\";N;s:4:\"info\";O:16:\"DUP_DatabaseInfo\":23:{s:9:\"buildMode\";s:3:\"PHP\";s:11:\"charSetList\";a:0:{}s:13:\"collationList\";a:0:{}s:10:\"engineList\";a:0:{}s:17:\"isTablesUpperCase\";b:0;s:15:\"isNameUpperCase\";b:0;s:4:\"name\";s:0:\"\";s:15:\"tablesBaseCount\";i:0;s:16:\"tablesFinalCount\";i:0;s:20:\"muFilteredTableCount\";i:0;s:14:\"tablesRowCount\";i:0;s:16:\"tablesSizeOnDisk\";i:0;s:10:\"tablesList\";a:0:{}s:19:\"lowerCaseTableNames\";i:0;s:8:\"dbEngine\";s:0:\"\";s:7:\"version\";i:0;s:14:\"versionComment\";i:0;s:9:\"viewCount\";i:0;s:9:\"procCount\";i:0;s:9:\"funcCount\";i:0;s:11:\"triggerList\";a:0:{}s:33:\"\0DUP_DatabaseInfo\0intFieldsStruct\";a:0:{}s:42:\"\0DUP_DatabaseInfo\0indexProcessedSchemaSize\";a:0:{}}s:10:\"\0*\0Package\";r:65;s:24:\"\0DUP_Database\0tempDbPath\";N;s:23:\"\0DUP_Database\0EOFMarker\";s:0:\"\";s:26:\"\0DUP_Database\0networkFlush\";b:0;}s:13:\"BuildProgress\";O:18:\"DUP_Build_Progress\":12:{s:17:\"thread_start_time\";N;s:11:\"initialized\";b:0;s:15:\"installer_built\";b:0;s:15:\"archive_started\";b:0;s:20:\"archive_has_database\";b:0;s:13:\"archive_built\";b:0;s:21:\"database_script_built\";b:0;s:6:\"failed\";b:0;s:7:\"retries\";i:0;s:14:\"build_failures\";a:0:{}s:19:\"validation_failures\";a:0:{}s:27:\"\0DUP_Build_Progress\0package\";r:65;}}s:29:\"\0DUP_Archive\0tmpFilterDirsAll\";a:0:{}s:24:\"\0DUP_Archive\0wpCorePaths\";a:3:{i:0;s:32:\"C:/wamp64/www/wordpress/wp-admin\";i:1;s:35:\"C:/wamp64/www/wordpress/wp-includes\";i:2;s:44:\"C:/wamp64/www/wordpress/wp-content/languages\";}s:29:\"\0DUP_Archive\0wpCoreExactPaths\";a:7:{i:0;s:23:\"C:/wamp64/www/wordpress\";i:1;s:23:\"C:/wamp64/www/wordpress\";i:2;s:34:\"C:/wamp64/www/wordpress/wp-content\";i:3;s:42:\"C:/wamp64/www/wordpress/wp-content/uploads\";i:4;s:42:\"C:/wamp64/www/wordpress/wp-content/plugins\";i:5;s:45:\"C:/wamp64/www/wordpress/wp-content/mu-plugins\";i:6;s:41:\"C:/wamp64/www/wordpress/wp-content/themes\";}s:31:\"\0DUP_Archive\0relativeFiltersDir\";a:2:{i:0;s:55:\"C:/wamp64/www/wordpress/wp-content/backups-dup-lite/tmp\";i:1;s:15:\"backups-dup-pro\";}s:24:\"\0DUP_Archive\0listFileObj\";N;s:23:\"\0DUP_Archive\0listDirObj\";N;}s:9:\"Installer\";r:86;s:8:\"Database\";r:105;s:13:\"BuildProgress\";r:144;}", "auto");
INSERT INTO `wp_options` VALUES("1591", "site_logo", "675", "auto");
INSERT INTO `wp_options` VALUES("290", "can_compress_scripts", "1", "on");
INSERT INTO `wp_options` VALUES("2786", "_site_transient_timeout_browser_e2dd8fac9c214f2e57aa0dea655ff030", "1731005600", "off");
INSERT INTO `wp_options` VALUES("2787", "_site_transient_browser_e2dd8fac9c214f2e57aa0dea655ff030", "a:10:{s:4:\"name\";s:6:\"Chrome\";s:7:\"version\";s:9:\"129.0.0.0\";s:8:\"platform\";s:7:\"Windows\";s:10:\"update_url\";s:29:\"https://www.google.com/chrome\";s:7:\"img_src\";s:43:\"http://s.w.org/images/browsers/chrome.png?1\";s:11:\"img_src_ssl\";s:44:\"https://s.w.org/images/browsers/chrome.png?1\";s:15:\"current_version\";s:2:\"18\";s:7:\"upgrade\";b:0;s:8:\"insecure\";b:0;s:6:\"mobile\";b:0;}", "off");
INSERT INTO `wp_options` VALUES("2788", "_site_transient_timeout_php_check_1d343e7f9aee33bb3a30d3fe7077ec03", "1731005601", "off");
INSERT INTO `wp_options` VALUES("2789", "_site_transient_php_check_1d343e7f9aee33bb3a30d3fe7077ec03", "a:5:{s:19:\"recommended_version\";s:3:\"7.4\";s:15:\"minimum_version\";s:6:\"7.2.24\";s:12:\"is_supported\";b:1;s:9:\"is_secure\";b:1;s:13:\"is_acceptable\";b:1;}", "off");
INSERT INTO `wp_options` VALUES("154", "widget_recent-posts", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("155", "widget_recent-comments", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("859", "theme_mods_skyline-wp", "a:1:{s:18:\"custom_css_post_id\";i:-1;}", "auto");
INSERT INTO `wp_options` VALUES("212", "theme_mods_brite", "a:12:{i:0;b:0;s:18:\"nav_menu_locations\";a:2:{s:11:\"header-menu\";i:2;s:12:\"content-menu\";i:2;}s:18:\"custom_css_post_id\";i:-1;s:58:\"header_front_page.hero.style.background.image.0.source.url\";s:65:\"http://localhost/wordpress/wp-content/uploads/2023/06/devoksy.png\";s:42:\"header_front_page.title.localProps.content\";s:0:\"\";s:36:\"header_front_page.button_group.value\";s:116:\"%5B%7B%22label%22%3A%22Learn%20more%22%2C%22url%22%3A%22%23%22%2C%22button_type%22%3A%221%22%2C%22index%22%3A1%7D%5D\";s:46:\"header_front_page.button_group.style.textAlign\";s:4:\"left\";s:45:\"header_front_page.navigation.props.showTopBar\";b:0;s:45:\"header_front_page.navigation.props.layoutType\";s:15:\"logo-above-menu\";s:52:\"header_front_page.navigation.style.padding.top.value\";i:22;s:12:\"page_content\";a:0:{}s:11:\"custom_logo\";i:675;}", "yes");
INSERT INTO `wp_options` VALUES("219", "brite_companion_old_show_on_front", "posts", "yes");
INSERT INTO `wp_options` VALUES("220", "brite_companion_old_page_on_front", "0", "yes");
INSERT INTO `wp_options` VALUES("221", "colibri_manual_create_pages", "1", "yes");
INSERT INTO `wp_options` VALUES("222", "extend_builder_theme", "a:16:{s:5:\"icons\";a:11:{s:17:\"brandico/facebook\";s:284:\"<svg version=\"1.1\" xmlns=\"http://www.w3.org/2000/svg\" xmlns:xlink=\"http://www.w3.org/1999/xlink\" id=\"facebook\" viewBox=\"0 0 486.037 1007\"><path d=\"M124 1005V536H0V367h124V223C124 110 197 5 366 5c68 0 119 7 119 7l-4 158s-52-1-108-1c-61 0-71 28-71 75v123h183l-8 169H302v469H123\"/></svg>\";s:17:\"font-awesome/star\";s:395:\"<svg version=\"1.1\" xmlns=\"http://www.w3.org/2000/svg\" xmlns:xlink=\"http://www.w3.org/1999/xlink\" id=\"star\" viewBox=\"0 0 1664 1896.0833\"><path d=\"M1664 647q0 22-26 48l-363 354 86 500q1 7 1 20 0 21-10.5 35.5T1321 1619q-19 0-40-12l-449-236-449 236q-22 12-40 12-21 0-31.5-14.5T301 1569q0-6 2-20l86-500L25 695Q0 668 0 647q0-37 56-46l502-73L783 73q19-41 49-41t49 41l225 455 502 73q56 9 56 46z\"/></svg>\";s:28:\"font-awesome/facebook-square\";s:410:\"<svg version=\"1.1\" xmlns=\"http://www.w3.org/2000/svg\" xmlns:xlink=\"http://www.w3.org/1999/xlink\" id=\"facebook-square\" viewBox=\"0 0 1536 1896.0833\"><path d=\"M1248 128q119 0 203.5 84.5T1536 416v960q0 119-84.5 203.5T1248 1664h-188v-595h199l30-232h-229V689q0-56 23.5-84t91.5-28l122-1V369q-63-9-178-9-136 0-217.5 80T820 666v171H620v232h200v595H288q-119 0-203.5-84.5T0 1376V416q0-119 84.5-203.5T288 128h960z\"/></svg>\";s:27:\"font-awesome/twitter-square\";s:630:\"<svg version=\"1.1\" xmlns=\"http://www.w3.org/2000/svg\" xmlns:xlink=\"http://www.w3.org/1999/xlink\" id=\"twitter-square\" viewBox=\"0 0 1536 1896.0833\"><path d=\"M1280 610q-56 25-121 34 68-40 93-117-65 38-134 51-61-66-153-66-87 0-148.5 61.5T755 722q0 29 5 48-129-7-242-65T326 550q-29 50-29 106 0 114 91 175-47-1-100-26v2q0 75 50 133.5t123 72.5q-29 8-51 8-13 0-39-4 21 63 74.5 104t121.5 42q-116 90-261 90-26 0-50-3 148 94 322 94 112 0 210-35.5t168-95 120.5-137 75-162T1176 746q0-18-1-27 63-45 105-109zm256-194v960q0 119-84.5 203.5T1248 1664H288q-119 0-203.5-84.5T0 1376V416q0-119 84.5-203.5T288 128h960q119 0 203.5 84.5T1536 416z\"/></svg>\";s:27:\"font-awesome/youtube-square\";s:1354:\"<svg version=\"1.1\" xmlns=\"http://www.w3.org/2000/svg\" xmlns:xlink=\"http://www.w3.org/1999/xlink\" id=\"youtube-square\" viewBox=\"0 0 1536 1896.0833\"><path d=\"M919 1303v-157q0-50-29-50-17 0-33 16v224q16 16 33 16 29 0 29-49zm184-122h66v-34q0-51-33-51t-33 51v34zM532 915v70h-80v423h-74V985h-78v-70h232zm201 126v367h-67v-40q-39 45-76 45-33 0-42-28-6-17-6-54v-290h66v270q0 24 1 26 1 15 15 15 20 0 42-31v-280h67zm252 111v146q0 52-7 73-12 42-53 42-35 0-68-41v36h-67V915h67v161q32-40 68-40 41 0 53 42 7 21 7 74zm251 129v9q0 29-2 43-3 22-15 40-27 40-80 40-52 0-81-38-21-27-21-86v-129q0-59 20-86 29-38 80-38t78 38q21 29 21 86v76h-133v65q0 51 34 51 24 0 30-26 0-1 .5-7t.5-16.5V1281h68zM785 457v156q0 51-32 51t-32-51V457q0-52 32-52t32 52zm533 713q0-177-19-260-10-44-43-73.5t-76-34.5q-136-15-412-15-275 0-411 15-44 5-76.5 34.5T238 910q-20 87-20 260 0 176 20 260 10 43 42.5 73t75.5 35q137 15 412 15t412-15q43-5 75.5-35t42.5-73q20-84 20-260zM563 519l90-296h-75l-51 195-53-195h-78q7 23 23 69l24 69q35 103 46 158v201h74V519zm289 81V470q0-58-21-87-29-38-78-38-51 0-78 38-21 29-21 87v130q0 58 21 87 27 38 78 38 49 0 78-38 21-27 21-87zm181 120h67V350h-67v283q-22 31-42 31-15 0-16-16-1-2-1-26V350h-67v293q0 37 6 55 11 27 43 27 36 0 77-45v40zm503-304v960q0 119-84.5 203.5T1248 1664H288q-119 0-203.5-84.5T0 1376V416q0-119 84.5-203.5T288 128h960q119 0 203.5 84.5T1536 416z\"/></svg>\";s:25:\"font-awesome/vimeo-square\";s:540:\"<svg version=\"1.1\" xmlns=\"http://www.w3.org/2000/svg\" xmlns:xlink=\"http://www.w3.org/1999/xlink\" id=\"vimeo-square\" viewBox=\"0 0 1536 1896.0833\"><path d=\"M1292 638q10-216-161-222-231-8-312 261 44-19 82-19 85 0 74 96-4 57-74 167t-105 110q-43 0-82-169-13-54-45-255-30-189-160-177-59 7-164 100l-81 72-81 72 52 67q76-52 87-52 57 0 107 179 15 55 45 164.5t45 164.5q68 179 164 179 157 0 383-294 220-283 226-444zm244-222v960q0 119-84.5 203.5T1248 1664H288q-119 0-203.5-84.5T0 1376V416q0-119 84.5-203.5T288 128h960q119 0 203.5 84.5T1536 416z\"/></svg>\";s:17:\"font-awesome/plus\";s:353:\"<svg version=\"1.1\" xmlns=\"http://www.w3.org/2000/svg\" xmlns:xlink=\"http://www.w3.org/1999/xlink\" id=\"plus\" viewBox=\"0 0 1408 1896.0833\"><path d=\"M1408 736v192q0 40-28 68t-68 28H896v416q0 40-28 68t-68 28H608q-40 0-68-28t-28-68v-416H96q-40 0-68-28T0 928V736q0-40 28-68t68-28h416V224q0-40 28-68t68-28h192q40 0 68 28t28 68v416h416q40 0 68 28t28 68z\"/></svg>\";s:18:\"font-awesome/minus\";s:251:\"<svg version=\"1.1\" xmlns=\"http://www.w3.org/2000/svg\" xmlns:xlink=\"http://www.w3.org/1999/xlink\" id=\"minus\" viewBox=\"0 0 1408 1896.0833\"><path d=\"M1408 736v192q0 40-28 68t-68 28H96q-40 0-68-28T0 928V736q0-40 28-68t68-28h1216q40 0 68 28t28 68z\"/></svg>\";s:25:\"font-awesome/chevron-left\";s:320:\"<svg version=\"1.1\" xmlns=\"http://www.w3.org/2000/svg\" xmlns:xlink=\"http://www.w3.org/1999/xlink\" id=\"chevron-left\" viewBox=\"0 0 1289.1823 1896.0833\"><path d=\"M1171 301L640 832l531 531q19 19 19 45t-19 45l-166 166q-19 19-45 19t-45-19L173 877q-19-19-19-45t19-45L915 45q19-19 45-19t45 19l166 166q19 19 19 45t-19 45z\"/></svg>\";s:26:\"font-awesome/chevron-right\";s:317:\"<svg version=\"1.1\" xmlns=\"http://www.w3.org/2000/svg\" xmlns:xlink=\"http://www.w3.org/1999/xlink\" id=\"chevron-right\" viewBox=\"0 0 1280 1896.0833\"><path d=\"M1107 877l-742 742q-19 19-45 19t-45-19l-166-166q-19-19-19-45t19-45l531-531-531-531q-19-19-19-45t19-45L275 45q19-19 45-19t45 19l742 742q19 19 19 45t-19 45z\"/></svg>\";s:17:\"font-awesome/bars\";s:439:\"<svg version=\"1.1\" xmlns=\"http://www.w3.org/2000/svg\" xmlns:xlink=\"http://www.w3.org/1999/xlink\" id=\"bars\" viewBox=\"0 0 1536 1896.0833\"><path d=\"M1536 1344v128q0 26-19 45t-45 19H64q-26 0-45-19t-19-45v-128q0-26 19-45t45-19h1408q26 0 45 19t19 45zm0-512v128q0 26-19 45t-45 19H64q-26 0-45-19T0 960V832q0-26 19-45t45-19h1408q26 0 45 19t19 45zm0-512v128q0 26-19 45t-45 19H64q-26 0-45-19T0 448V320q0-26 19-45t45-19h1408q26 0 45 19t19 45z\"/></svg>\";}s:5:\"fonts\";a:2:{s:6:\"native\";a:0:{}s:6:\"google\";a:9:{s:4:\"Muli\";a:2:{s:7:\"weights\";a:14:{i:0;s:3:\"200\";i:1;s:9:\"200italic\";i:2;s:3:\"300\";i:3;s:9:\"300italic\";i:4;s:3:\"400\";i:5;s:9:\"400italic\";i:6;s:3:\"600\";i:7;s:9:\"600italic\";i:8;s:3:\"700\";i:9;s:9:\"700italic\";i:10;s:3:\"800\";i:11;s:9:\"800italic\";i:12;s:3:\"900\";i:13;s:9:\"900italic\";}s:8:\"category\";s:10:\"sans-serif\";}s:9:\"Open Sans\";a:2:{s:7:\"weights\";a:10:{i:0;s:3:\"300\";i:1;s:9:\"300italic\";i:2;s:3:\"400\";i:3;s:9:\"400italic\";i:4;s:3:\"600\";i:5;s:9:\"600italic\";i:6;s:3:\"700\";i:7;s:9:\"700italic\";i:8;s:3:\"800\";i:9;s:9:\"800italic\";}s:8:\"category\";s:10:\"sans-serif\";}s:16:\"Playfair Display\";a:2:{s:7:\"weights\";a:6:{i:0;s:3:\"400\";i:1;s:9:\"400italic\";i:2;s:3:\"700\";i:3;s:9:\"700italic\";i:4;s:3:\"900\";i:5;s:9:\"900italic\";}s:8:\"category\";s:10:\"sans-serif\";}s:15:\"Source Sans Pro\";a:3:{s:8:\"category\";s:10:\"sans-serif\";s:7:\"subsets\";a:7:{i:0;s:8:\"cyrillic\";i:1;s:10:\"vietnamese\";i:2;s:9:\"greek-ext\";i:3;s:5:\"greek\";i:4;s:9:\"latin-ext\";i:5;s:12:\"cyrillic-ext\";i:6;s:5:\"latin\";}s:7:\"weights\";a:12:{i:0;s:3:\"200\";i:1;s:9:\"200italic\";i:2;s:3:\"300\";i:3;s:9:\"300italic\";i:4;s:3:\"400\";i:5;s:9:\"400italic\";i:6;s:3:\"600\";i:7;s:9:\"600italic\";i:8;s:3:\"700\";i:9;s:9:\"700italic\";i:10;s:3:\"900\";i:11;s:9:\"900italic\";}}s:4:\"Lato\";a:3:{s:8:\"category\";s:10:\"sans-serif\";s:7:\"subsets\";a:2:{i:0;s:9:\"latin-ext\";i:1;s:5:\"latin\";}s:7:\"weights\";a:10:{i:0;s:3:\"100\";i:1;s:9:\"100italic\";i:2;s:3:\"300\";i:3;s:9:\"300italic\";i:4;s:3:\"400\";i:5;s:9:\"400italic\";i:6;s:3:\"700\";i:7;s:9:\"700italic\";i:8;s:3:\"900\";i:9;s:9:\"900italic\";}}s:10:\"Montserrat\";a:3:{s:8:\"category\";s:10:\"sans-serif\";s:7:\"subsets\";a:3:{i:0;s:10:\"vietnamese\";i:1;s:9:\"latin-ext\";i:2;s:5:\"latin\";}s:7:\"weights\";a:18:{i:0;s:3:\"100\";i:1;s:9:\"100italic\";i:2;s:3:\"200\";i:3;s:9:\"200italic\";i:4;s:3:\"300\";i:5;s:9:\"300italic\";i:6;s:3:\"400\";i:7;s:9:\"400italic\";i:8;s:3:\"500\";i:9;s:9:\"500italic\";i:10;s:3:\"600\";i:11;s:9:\"600italic\";i:12;s:3:\"700\";i:13;s:9:\"700italic\";i:14;s:3:\"800\";i:15;s:9:\"800italic\";i:16;s:3:\"900\";i:17;s:9:\"900italic\";}}s:8:\"Rajdhani\";a:3:{s:8:\"category\";s:10:\"sans-serif\";s:7:\"subsets\";a:3:{i:0;s:10:\"devanagari\";i:1;s:9:\"latin-ext\";i:2;s:5:\"latin\";}s:7:\"weights\";a:5:{i:0;s:3:\"300\";i:1;s:3:\"400\";i:2;s:3:\"500\";i:3;s:3:\"600\";i:4;s:3:\"700\";}}s:12:\"Abhaya Libre\";a:3:{s:8:\"category\";s:5:\"serif\";s:7:\"subsets\";a:3:{i:0;s:9:\"latin-ext\";i:1;s:5:\"latin\";i:2;s:7:\"sinhala\";}s:7:\"weights\";a:5:{i:0;s:3:\"400\";i:1;s:3:\"500\";i:2;s:3:\"600\";i:3;s:3:\"700\";i:4;s:3:\"800\";}}s:13:\"Alike Angular\";a:3:{s:8:\"category\";s:5:\"serif\";s:7:\"subsets\";a:1:{i:0;s:5:\"latin\";}s:7:\"weights\";a:1:{i:0;s:3:\"400\";}}}}s:6:\"colors\";a:6:{i:0;s:7:\"#03a9f4\";i:1;s:7:\"#f79007\";i:2;s:7:\"#00bf87\";i:3;s:7:\"#6632ff\";i:4;s:7:\"#FFFFFF\";i:5;s:7:\"#000000\";}s:11:\"dummyChange\";s:0:\"\";s:10:\"typography\";a:2:{s:7:\"holders\";a:9:{s:2:\"h1\";a:4:{s:6:\"weight\";s:3:\"500\";s:6:\"family\";s:10:\"Montserrat\";s:4:\"size\";a:2:{s:4:\"unit\";s:2:\"em\";s:5:\"value\";s:3:\"3.5\";}s:9:\"transform\";s:0:\"\";}s:2:\"h2\";a:1:{s:6:\"family\";s:10:\"Montserrat\";}s:2:\"h3\";a:2:{s:6:\"family\";s:10:\"Montserrat\";s:6:\"weight\";s:3:\"400\";}s:2:\"h4\";a:2:{s:6:\"family\";s:10:\"Montserrat\";s:4:\"size\";a:2:{s:4:\"unit\";s:2:\"em\";s:5:\"value\";s:4:\"1.11\";}}s:2:\"h5\";a:2:{s:6:\"family\";s:10:\"Montserrat\";s:4:\"size\";a:2:{s:4:\"unit\";s:2:\"em\";s:5:\"value\";s:1:\"1\";}}s:2:\"h6\";a:2:{s:6:\"family\";s:10:\"Montserrat\";s:9:\"transform\";s:9:\"uppercase\";}s:4:\"lead\";a:2:{s:4:\"size\";a:2:{s:4:\"unit\";s:2:\"em\";s:5:\"value\";s:4:\"1.11\";}s:5:\"color\";s:26:\"${theme.colors.5|variant3}\";}s:1:\"p\";a:4:{s:6:\"weight\";s:3:\"400\";s:5:\"color\";s:26:\"${theme.colors.5|variant2}\";s:4:\"size\";a:2:{s:4:\"unit\";s:2:\"px\";s:5:\"value\";s:2:\"16\";}s:6:\"family\";s:9:\"Open Sans\";}s:1:\"a\";a:2:{s:5:\"color\";s:26:\"${theme.colors.0|variant3}\";s:6:\"states\";a:1:{s:5:\"hover\";a:1:{s:5:\"color\";s:17:\"${theme.colors.0}\";}}}}s:5:\"media\";a:2:{s:6:\"tablet\";a:1:{s:7:\"holders\";a:1:{s:2:\"h1\";a:1:{s:4:\"size\";a:2:{s:4:\"unit\";s:2:\"em\";s:5:\"value\";s:1:\"3\";}}}}s:6:\"mobile\";a:1:{s:7:\"holders\";a:1:{s:2:\"h1\";a:1:{s:4:\"size\";a:2:{s:4:\"unit\";s:2:\"em\";s:5:\"value\";s:3:\"2.8\";}}}}}}s:6:\"global\";a:10:{s:7:\"content\";a:2:{s:8:\"template\";s:0:\"\";s:10:\"collection\";s:0:\"\";}s:6:\"titles\";a:10:{s:16:\"normalPageFormat\";s:7:\"{TITLE}\";s:17:\"normalResultsPage\";s:27:\"Search results for: {TITLE}\";s:9:\"errorPage\";s:22:\"Sorry! Page Not Found!\";s:10:\"singlePost\";s:7:\"{TITLE}\";s:15:\"categoryArchive\";s:16:\"Posts in {TITLE}\";s:13:\"authorArchive\";s:16:\"Posts in {TITLE}\";s:10:\"tagArchive\";s:16:\"Posts in {TITLE}\";s:11:\"yearArchive\";s:16:\"Posts in {TITLE}\";s:12:\"monthArchive\";s:16:\"Posts in {TITLE}\";s:10:\"dayArchive\";s:16:\"Posts in {TITLE}\";}s:6:\"vSpace\";a:2:{s:5:\"value\";i:20;s:4:\"unit\";s:2:\"px\";}s:6:\"hSpace\";a:2:{s:5:\"value\";i:20;s:4:\"unit\";s:2:\"px\";}s:14:\"sectionSpacing\";a:2:{s:5:\"value\";s:2:\"75\";s:4:\"unit\";s:2:\"px\";}s:10:\"transition\";a:1:{s:8:\"duration\";a:2:{s:5:\"value\";s:3:\"0.5\";s:4:\"unit\";s:1:\"s\";}}s:9:\"templates\";a:2:{s:4:\"blog\";a:2:{s:5:\"style\";a:1:{s:11:\"descendants\";a:2:{s:7:\"section\";a:1:{s:7:\"padding\";a:1:{s:3:\"top\";a:1:{s:5:\"value\";s:2:\"90\";}}}s:4:\"grid\";a:1:{s:6:\"margin\";a:1:{s:3:\"top\";a:1:{s:5:\"value\";i:-115;}}}}}s:5:\"props\";a:1:{s:11:\"descendants\";a:1:{s:3:\"row\";a:2:{s:6:\"layout\";a:2:{s:13:\"horizontalGap\";i:2;s:11:\"verticalGap\";i:2;}s:14:\"layout-classes\";a:3:{s:5:\"unset\";b:1;s:11:\"outer_class\";a:1:{i:0;s:16:\"gutters-row-lg-2\";}s:11:\"inner_class\";a:1:{i:0;s:16:\"gutters-col-lg-2\";}}}}}}s:11:\"woocommerce\";a:2:{s:5:\"props\";a:1:{s:11:\"descendants\";a:1:{s:7:\"section\";a:1:{s:8:\"sidebars\";a:1:{s:4:\"left\";b:1;}}}}s:5:\"style\";a:1:{s:11:\"descendants\";a:1:{s:12:\"sidebar-left\";a:1:{s:11:\"columnWidth\";a:1:{s:6:\"custom\";a:2:{s:4:\"unit\";s:1:\"%\";s:5:\"value\";i:25;}}}}}}}s:13:\"multilanguage\";a:2:{s:5:\"props\";a:2:{s:7:\"enabled\";b:1;s:4:\"type\";s:8:\"dropdown\";}s:5:\"style\";a:1:{s:11:\"descendants\";a:2:{s:9:\"container\";a:3:{s:10:\"background\";a:1:{s:5:\"color\";s:5:\"white\";}s:3:\"top\";a:2:{s:4:\"unit\";s:2:\"px\";s:5:\"value\";i:80;}s:6:\"border\";a:2:{s:3:\"top\";a:1:{s:6:\"radius\";a:2:{s:4:\"left\";a:2:{s:4:\"unit\";s:2:\"px\";s:5:\"value\";i:4;}s:5:\"right\";a:2:{s:4:\"unit\";s:2:\"px\";s:5:\"value\";i:0;}}}s:6:\"bottom\";a:1:{s:6:\"radius\";a:2:{s:4:\"left\";a:2:{s:4:\"unit\";s:2:\"px\";s:5:\"value\";i:4;}s:5:\"right\";a:2:{s:4:\"unit\";s:2:\"px\";s:5:\"value\";i:0;}}}}}s:5:\"flags\";a:1:{s:7:\"padding\";a:4:{s:3:\"top\";a:2:{s:4:\"unit\";s:2:\"px\";s:5:\"value\";i:14;}s:5:\"right\";a:2:{s:4:\"unit\";s:2:\"px\";s:5:\"value\";i:18;}s:6:\"bottom\";a:2:{s:4:\"unit\";s:2:\"px\";s:5:\"value\";i:14;}s:4:\"left\";a:2:{s:4:\"unit\";s:2:\"px\";s:5:\"value\";i:18;}}}}}}s:5:\"media\";a:2:{s:6:\"mobile\";a:1:{s:14:\"sectionSpacing\";a:2:{s:5:\"value\";i:30;s:4:\"unit\";s:2:\"px\";}}s:6:\"tablet\";a:1:{s:14:\"sectionSpacing\";a:2:{s:5:\"value\";i:60;s:4:\"unit\";s:2:\"px\";}}}s:4:\"logo\";a:1:{s:14:\"alternateImage\";s:70:\"http://localhost/wordpress/wp-content/uploads/2024/09/karibeabande.png\";}}s:4:\"menu\";a:2:{s:16:\"defaultLocations\";a:3:{s:6:\"header\";a:2:{i:0;a:3:{s:2:\"id\";s:11:\"header-menu\";s:5:\"label\";s:19:\"Header primary menu\";s:8:\"priority\";i:1;}i:1;a:3:{s:2:\"id\";s:13:\"header-menu-1\";s:5:\"label\";s:21:\"Header secondary menu\";s:8:\"priority\";i:2;}}s:7:\"content\";a:1:{i:0;a:3:{s:2:\"id\";s:12:\"content-menu\";s:5:\"label\";s:12:\"In Page Menu\";s:8:\"priority\";i:1;}}s:6:\"footer\";a:2:{i:0;a:3:{s:2:\"id\";s:11:\"footer-menu\";s:5:\"label\";s:19:\"Footer primary menu\";s:8:\"priority\";i:1;}i:1;a:3:{s:2:\"id\";s:13:\"footer-menu-1\";s:5:\"label\";s:21:\"Footer secondary menu\";s:8:\"priority\";i:2;}}}s:9:\"locations\";a:5:{i:0;a:2:{s:2:\"id\";s:11:\"header-menu\";s:5:\"label\";s:19:\"Header primary menu\";}i:1;a:2:{s:2:\"id\";s:13:\"header-menu-1\";s:5:\"label\";s:21:\"Header secondary menu\";}i:2;a:2:{s:2:\"id\";s:12:\"content-menu\";s:5:\"label\";s:12:\"In Page Menu\";}i:3;a:2:{s:2:\"id\";s:11:\"footer-menu\";s:5:\"label\";s:19:\"Footer primary menu\";}i:4;a:2:{s:2:\"id\";s:13:\"footer-menu-1\";s:5:\"label\";s:21:\"Footer secondary menu\";}}}s:3:\"css\";s:23974:\"\r\n.h-y-container > *:not(:last-child), .h-x-container-inner > * {\n  margin-bottom: 20px;\n}\n.h-x-container-inner, .h-column__content > .h-x-container > *:last-child {\n  margin-bottom: -20px;\n}\n.h-x-container-inner > * {\n  padding-left: 10px;\n  padding-right: 10px;\n}\n.h-x-container-inner {\n  margin-left: -10px;\n  margin-right: -10px;\n}\n[class*=style-], [class*=local-style-], .h-global-transition, .h-global-transition-all, .h-global-transition-all * {\n  transition-duration: 0.5s;\n}\n.wp-block-button .wp-block-button__link:not(.has-background),.wp-block-file .wp-block-file__button {\n  background-color: #03a9f4;\n  background-image: none;\n}\n.wp-block-button .wp-block-button__link:not(.has-background):hover,.wp-block-button .wp-block-button__link:not(.has-background):focus,.wp-block-button .wp-block-button__link:not(.has-background):active,.wp-block-file .wp-block-file__button:hover,.wp-block-file .wp-block-file__button:focus,.wp-block-file .wp-block-file__button:active {\n  background-color: rgb(2, 110, 159);\n  background-image: none;\n}\n.wp-block-button.is-style-outline .wp-block-button__link:not(.has-background) {\n  color: #03a9f4;\n  background-color: transparent;\n  background-image: none;\n  border-top-width: 2px;\n  border-top-color: #03a9f4;\n  border-top-style: solid;\n  border-right-width: 2px;\n  border-right-color: #03a9f4;\n  border-right-style: solid;\n  border-bottom-width: 2px;\n  border-bottom-color: #03a9f4;\n  border-bottom-style: solid;\n  border-left-width: 2px;\n  border-left-color: #03a9f4;\n  border-left-style: solid;\n}\n.wp-block-button.is-style-outline .wp-block-button__link:not(.has-background):hover,.wp-block-button.is-style-outline .wp-block-button__link:not(.has-background):focus,.wp-block-button.is-style-outline .wp-block-button__link:not(.has-background):active {\n  color: #fff;\n  background-color: #03a9f4;\n  background-image: none;\n}\n.has-background-color,*[class^=\"wp-block-\"].is-style-solid-color {\n  background-color: #03a9f4;\n  background-image: none;\n}\n.has-colibri-color-1-background-color {\n  background-color: #03a9f4;\n  background-image: none;\n}\n.wp-block-button .wp-block-button__link.has-colibri-color-1-background-color {\n  background-color: #03a9f4;\n  background-image: none;\n}\n.wp-block-button .wp-block-button__link.has-colibri-color-1-background-color:hover,.wp-block-button .wp-block-button__link.has-colibri-color-1-background-color:focus,.wp-block-button .wp-block-button__link.has-colibri-color-1-background-color:active {\n  background-color: rgb(2, 110, 159);\n  background-image: none;\n}\n.wp-block-button.is-style-outline .wp-block-button__link.has-colibri-color-1-background-color {\n  color: #03a9f4;\n  background-color: transparent;\n  background-image: none;\n  border-top-width: 2px;\n  border-top-color: #03a9f4;\n  border-top-style: solid;\n  border-right-width: 2px;\n  border-right-color: #03a9f4;\n  border-right-style: solid;\n  border-bottom-width: 2px;\n  border-bottom-color: #03a9f4;\n  border-bottom-style: solid;\n  border-left-width: 2px;\n  border-left-color: #03a9f4;\n  border-left-style: solid;\n}\n.wp-block-button.is-style-outline .wp-block-button__link.has-colibri-color-1-background-color:hover,.wp-block-button.is-style-outline .wp-block-button__link.has-colibri-color-1-background-color:focus,.wp-block-button.is-style-outline .wp-block-button__link.has-colibri-color-1-background-color:active {\n  color: #fff;\n  background-color: #03a9f4;\n  background-image: none;\n}\n*[class^=\"wp-block-\"].has-colibri-color-1-background-color,*[class^=\"wp-block-\"] .has-colibri-color-1-background-color,*[class^=\"wp-block-\"].is-style-solid-color.has-colibri-color-1-color,*[class^=\"wp-block-\"].is-style-solid-color blockquote.has-colibri-color-1-color,*[class^=\"wp-block-\"].is-style-solid-color blockquote.has-colibri-color-1-color p {\n  background-color: #03a9f4;\n  background-image: none;\n}\n.has-colibri-color-1-color {\n  color: #03a9f4;\n}\n.has-colibri-color-2-background-color {\n  background-color: #f79007;\n  background-image: none;\n}\n.wp-block-button .wp-block-button__link.has-colibri-color-2-background-color {\n  background-color: #f79007;\n  background-image: none;\n}\n.wp-block-button .wp-block-button__link.has-colibri-color-2-background-color:hover,.wp-block-button .wp-block-button__link.has-colibri-color-2-background-color:focus,.wp-block-button .wp-block-button__link.has-colibri-color-2-background-color:active {\n  background-color: rgb(162, 94, 5);\n  background-image: none;\n}\n.wp-block-button.is-style-outline .wp-block-button__link.has-colibri-color-2-background-color {\n  color: #f79007;\n  background-color: transparent;\n  background-image: none;\n  border-top-width: 2px;\n  border-top-color: #f79007;\n  border-top-style: solid;\n  border-right-width: 2px;\n  border-right-color: #f79007;\n  border-right-style: solid;\n  border-bottom-width: 2px;\n  border-bottom-color: #f79007;\n  border-bottom-style: solid;\n  border-left-width: 2px;\n  border-left-color: #f79007;\n  border-left-style: solid;\n}\n.wp-block-button.is-style-outline .wp-block-button__link.has-colibri-color-2-background-color:hover,.wp-block-button.is-style-outline .wp-block-button__link.has-colibri-color-2-background-color:focus,.wp-block-button.is-style-outline .wp-block-button__link.has-colibri-color-2-background-color:active {\n  color: #fff;\n  background-color: #f79007;\n  background-image: none;\n}\n*[class^=\"wp-block-\"].has-colibri-color-2-background-color,*[class^=\"wp-block-\"] .has-colibri-color-2-background-color,*[class^=\"wp-block-\"].is-style-solid-color.has-colibri-color-2-color,*[class^=\"wp-block-\"].is-style-solid-color blockquote.has-colibri-color-2-color,*[class^=\"wp-block-\"].is-style-solid-color blockquote.has-colibri-color-2-color p {\n  background-color: #f79007;\n  background-image: none;\n}\n.has-colibri-color-2-color {\n  color: #f79007;\n}\n.has-colibri-color-3-background-color {\n  background-color: #00bf87;\n  background-image: none;\n}\n.wp-block-button .wp-block-button__link.has-colibri-color-3-background-color {\n  background-color: #00bf87;\n  background-image: none;\n}\n.wp-block-button .wp-block-button__link.has-colibri-color-3-background-color:hover,.wp-block-button .wp-block-button__link.has-colibri-color-3-background-color:focus,.wp-block-button .wp-block-button__link.has-colibri-color-3-background-color:active {\n  background-color: rgb(0, 106, 75);\n  background-image: none;\n}\n.wp-block-button.is-style-outline .wp-block-button__link.has-colibri-color-3-background-color {\n  color: #00bf87;\n  background-color: transparent;\n  background-image: none;\n  border-top-width: 2px;\n  border-top-color: #00bf87;\n  border-top-style: solid;\n  border-right-width: 2px;\n  border-right-color: #00bf87;\n  border-right-style: solid;\n  border-bottom-width: 2px;\n  border-bottom-color: #00bf87;\n  border-bottom-style: solid;\n  border-left-width: 2px;\n  border-left-color: #00bf87;\n  border-left-style: solid;\n}\n.wp-block-button.is-style-outline .wp-block-button__link.has-colibri-color-3-background-color:hover,.wp-block-button.is-style-outline .wp-block-button__link.has-colibri-color-3-background-color:focus,.wp-block-button.is-style-outline .wp-block-button__link.has-colibri-color-3-background-color:active {\n  color: #fff;\n  background-color: #00bf87;\n  background-image: none;\n}\n*[class^=\"wp-block-\"].has-colibri-color-3-background-color,*[class^=\"wp-block-\"] .has-colibri-color-3-background-color,*[class^=\"wp-block-\"].is-style-solid-color.has-colibri-color-3-color,*[class^=\"wp-block-\"].is-style-solid-color blockquote.has-colibri-color-3-color,*[class^=\"wp-block-\"].is-style-solid-color blockquote.has-colibri-color-3-color p {\n  background-color: #00bf87;\n  background-image: none;\n}\n.has-colibri-color-3-color {\n  color: #00bf87;\n}\n.has-colibri-color-4-background-color {\n  background-color: #6632ff;\n  background-image: none;\n}\n.wp-block-button .wp-block-button__link.has-colibri-color-4-background-color {\n  background-color: #6632ff;\n  background-image: none;\n}\n.wp-block-button .wp-block-button__link.has-colibri-color-4-background-color:hover,.wp-block-button .wp-block-button__link.has-colibri-color-4-background-color:focus,.wp-block-button .wp-block-button__link.has-colibri-color-4-background-color:active {\n  background-color: rgb(68, 33, 170);\n  background-image: none;\n}\n.wp-block-button.is-style-outline .wp-block-button__link.has-colibri-color-4-background-color {\n  color: #6632ff;\n  background-color: transparent;\n  background-image: none;\n  border-top-width: 2px;\n  border-top-color: #6632ff;\n  border-top-style: solid;\n  border-right-width: 2px;\n  border-right-color: #6632ff;\n  border-right-style: solid;\n  border-bottom-width: 2px;\n  border-bottom-color: #6632ff;\n  border-bottom-style: solid;\n  border-left-width: 2px;\n  border-left-color: #6632ff;\n  border-left-style: solid;\n}\n.wp-block-button.is-style-outline .wp-block-button__link.has-colibri-color-4-background-color:hover,.wp-block-button.is-style-outline .wp-block-button__link.has-colibri-color-4-background-color:focus,.wp-block-button.is-style-outline .wp-block-button__link.has-colibri-color-4-background-color:active {\n  color: #fff;\n  background-color: #6632ff;\n  background-image: none;\n}\n*[class^=\"wp-block-\"].has-colibri-color-4-background-color,*[class^=\"wp-block-\"] .has-colibri-color-4-background-color,*[class^=\"wp-block-\"].is-style-solid-color.has-colibri-color-4-color,*[class^=\"wp-block-\"].is-style-solid-color blockquote.has-colibri-color-4-color,*[class^=\"wp-block-\"].is-style-solid-color blockquote.has-colibri-color-4-color p {\n  background-color: #6632ff;\n  background-image: none;\n}\n.has-colibri-color-4-color {\n  color: #6632ff;\n}\n.has-colibri-color-5-background-color {\n  background-color: #FFFFFF;\n  background-image: none;\n}\n.wp-block-button .wp-block-button__link.has-colibri-color-5-background-color {\n  background-color: #FFFFFF;\n  background-image: none;\n}\n.wp-block-button .wp-block-button__link.has-colibri-color-5-background-color:hover,.wp-block-button .wp-block-button__link.has-colibri-color-5-background-color:focus,.wp-block-button .wp-block-button__link.has-colibri-color-5-background-color:active {\n  background-color: rgb(102, 102, 102);\n  background-image: none;\n}\n.wp-block-button.is-style-outline .wp-block-button__link.has-colibri-color-5-background-color {\n  color: #FFFFFF;\n  background-color: transparent;\n  background-image: none;\n  border-top-width: 2px;\n  border-top-color: #FFFFFF;\n  border-top-style: solid;\n  border-right-width: 2px;\n  border-right-color: #FFFFFF;\n  border-right-style: solid;\n  border-bottom-width: 2px;\n  border-bottom-color: #FFFFFF;\n  border-bottom-style: solid;\n  border-left-width: 2px;\n  border-left-color: #FFFFFF;\n  border-left-style: solid;\n}\n.wp-block-button.is-style-outline .wp-block-button__link.has-colibri-color-5-background-color:hover,.wp-block-button.is-style-outline .wp-block-button__link.has-colibri-color-5-background-color:focus,.wp-block-button.is-style-outline .wp-block-button__link.has-colibri-color-5-background-color:active {\n  color: #fff;\n  background-color: #FFFFFF;\n  background-image: none;\n}\n*[class^=\"wp-block-\"].has-colibri-color-5-background-color,*[class^=\"wp-block-\"] .has-colibri-color-5-background-color,*[class^=\"wp-block-\"].is-style-solid-color.has-colibri-color-5-color,*[class^=\"wp-block-\"].is-style-solid-color blockquote.has-colibri-color-5-color,*[class^=\"wp-block-\"].is-style-solid-color blockquote.has-colibri-color-5-color p {\n  background-color: #FFFFFF;\n  background-image: none;\n}\n.has-colibri-color-5-color {\n  color: #FFFFFF;\n}\n.has-colibri-color-6-background-color {\n  background-color: #000000;\n  background-image: none;\n}\n.wp-block-button .wp-block-button__link.has-colibri-color-6-background-color {\n  background-color: #000000;\n  background-image: none;\n}\n.wp-block-button .wp-block-button__link.has-colibri-color-6-background-color:hover,.wp-block-button .wp-block-button__link.has-colibri-color-6-background-color:focus,.wp-block-button .wp-block-button__link.has-colibri-color-6-background-color:active {\n  background-color: rgb(51, 51, 51);\n  background-image: none;\n}\n.wp-block-button.is-style-outline .wp-block-button__link.has-colibri-color-6-background-color {\n  color: #000000;\n  background-color: transparent;\n  background-image: none;\n  border-top-width: 2px;\n  border-top-color: #000000;\n  border-top-style: solid;\n  border-right-width: 2px;\n  border-right-color: #000000;\n  border-right-style: solid;\n  border-bottom-width: 2px;\n  border-bottom-color: #000000;\n  border-bottom-style: solid;\n  border-left-width: 2px;\n  border-left-color: #000000;\n  border-left-style: solid;\n}\n.wp-block-button.is-style-outline .wp-block-button__link.has-colibri-color-6-background-color:hover,.wp-block-button.is-style-outline .wp-block-button__link.has-colibri-color-6-background-color:focus,.wp-block-button.is-style-outline .wp-block-button__link.has-colibri-color-6-background-color:active {\n  color: #fff;\n  background-color: #000000;\n  background-image: none;\n}\n*[class^=\"wp-block-\"].has-colibri-color-6-background-color,*[class^=\"wp-block-\"] .has-colibri-color-6-background-color,*[class^=\"wp-block-\"].is-style-solid-color.has-colibri-color-6-color,*[class^=\"wp-block-\"].is-style-solid-color blockquote.has-colibri-color-6-color,*[class^=\"wp-block-\"].is-style-solid-color blockquote.has-colibri-color-6-color p {\n  background-color: #000000;\n  background-image: none;\n}\n.has-colibri-color-6-color {\n  color: #000000;\n}\n#colibri .woocommerce-store-notice,#colibri.woocommerce .content .h-section input[type=submit],#colibri.woocommerce-page  .content .h-section  input[type=button],#colibri.woocommerce .content .h-section  input[type=button],#colibri.woocommerce-page  .content .h-section .button,#colibri.woocommerce .content .h-section .button,#colibri.woocommerce-page  .content .h-section  a.button,#colibri.woocommerce .content .h-section  a.button,#colibri.woocommerce-page  .content .h-section button.button,#colibri.woocommerce .content .h-section button.button,#colibri.woocommerce-page  .content .h-section input.button,#colibri.woocommerce .content .h-section input.button,#colibri.woocommerce-page  .content .h-section input#submit,#colibri.woocommerce .content .h-section input#submit,#colibri.woocommerce-page  .content .h-section a.added_to_cart,#colibri.woocommerce .content .h-section a.added_to_cart,#colibri.woocommerce-page  .content .h-section .ui-slider-range,#colibri.woocommerce .content .h-section .ui-slider-range,#colibri.woocommerce-page  .content .h-section .ui-slider-handle,#colibri.woocommerce .content .h-section .ui-slider-handle {\n  background-color: #03a9f4;\n  background-image: none;\n  border-top-width: 0px;\n  border-top-color: #03a9f4;\n  border-top-style: solid;\n  border-right-width: 0px;\n  border-right-color: #03a9f4;\n  border-right-style: solid;\n  border-bottom-width: 0px;\n  border-bottom-color: #03a9f4;\n  border-bottom-style: solid;\n  border-left-width: 0px;\n  border-left-color: #03a9f4;\n  border-left-style: solid;\n}\n#colibri .woocommerce-store-notice:hover,#colibri .woocommerce-store-notice:focus,#colibri .woocommerce-store-notice:active,#colibri.woocommerce .content .h-section input[type=submit]:hover,#colibri.woocommerce .content .h-section input[type=submit]:focus,#colibri.woocommerce .content .h-section input[type=submit]:active,#colibri.woocommerce-page  .content .h-section  input[type=button]:hover,#colibri.woocommerce-page  .content .h-section  input[type=button]:focus,#colibri.woocommerce-page  .content .h-section  input[type=button]:active,#colibri.woocommerce .content .h-section  input[type=button]:hover,#colibri.woocommerce .content .h-section  input[type=button]:focus,#colibri.woocommerce .content .h-section  input[type=button]:active,#colibri.woocommerce-page  .content .h-section .button:hover,#colibri.woocommerce-page  .content .h-section .button:focus,#colibri.woocommerce-page  .content .h-section .button:active,#colibri.woocommerce .content .h-section .button:hover,#colibri.woocommerce .content .h-section .button:focus,#colibri.woocommerce .content .h-section .button:active,#colibri.woocommerce-page  .content .h-section  a.button:hover,#colibri.woocommerce-page  .content .h-section  a.button:focus,#colibri.woocommerce-page  .content .h-section  a.button:active,#colibri.woocommerce .content .h-section  a.button:hover,#colibri.woocommerce .content .h-section  a.button:focus,#colibri.woocommerce .content .h-section  a.button:active,#colibri.woocommerce-page  .content .h-section button.button:hover,#colibri.woocommerce-page  .content .h-section button.button:focus,#colibri.woocommerce-page  .content .h-section button.button:active,#colibri.woocommerce .content .h-section button.button:hover,#colibri.woocommerce .content .h-section button.button:focus,#colibri.woocommerce .content .h-section button.button:active,#colibri.woocommerce-page  .content .h-section input.button:hover,#colibri.woocommerce-page  .content .h-section input.button:focus,#colibri.woocommerce-page  .content .h-section input.button:active,#colibri.woocommerce .content .h-section input.button:hover,#colibri.woocommerce .content .h-section input.button:focus,#colibri.woocommerce .content .h-section input.button:active,#colibri.woocommerce-page  .content .h-section input#submit:hover,#colibri.woocommerce-page  .content .h-section input#submit:focus,#colibri.woocommerce-page  .content .h-section input#submit:active,#colibri.woocommerce .content .h-section input#submit:hover,#colibri.woocommerce .content .h-section input#submit:focus,#colibri.woocommerce .content .h-section input#submit:active,#colibri.woocommerce-page  .content .h-section a.added_to_cart:hover,#colibri.woocommerce-page  .content .h-section a.added_to_cart:focus,#colibri.woocommerce-page  .content .h-section a.added_to_cart:active,#colibri.woocommerce .content .h-section a.added_to_cart:hover,#colibri.woocommerce .content .h-section a.added_to_cart:focus,#colibri.woocommerce .content .h-section a.added_to_cart:active,#colibri.woocommerce-page  .content .h-section .ui-slider-range:hover,#colibri.woocommerce-page  .content .h-section .ui-slider-range:focus,#colibri.woocommerce-page  .content .h-section .ui-slider-range:active,#colibri.woocommerce .content .h-section .ui-slider-range:hover,#colibri.woocommerce .content .h-section .ui-slider-range:focus,#colibri.woocommerce .content .h-section .ui-slider-range:active,#colibri.woocommerce-page  .content .h-section .ui-slider-handle:hover,#colibri.woocommerce-page  .content .h-section .ui-slider-handle:focus,#colibri.woocommerce-page  .content .h-section .ui-slider-handle:active,#colibri.woocommerce .content .h-section .ui-slider-handle:hover,#colibri.woocommerce .content .h-section .ui-slider-handle:focus,#colibri.woocommerce .content .h-section .ui-slider-handle:active {\n  background-color: rgb(2, 110, 159);\n  background-image: none;\n  border-top-width: 0px;\n  border-top-color: rgb(2, 110, 159);\n  border-top-style: solid;\n  border-right-width: 0px;\n  border-right-color: rgb(2, 110, 159);\n  border-right-style: solid;\n  border-bottom-width: 0px;\n  border-bottom-color: rgb(2, 110, 159);\n  border-bottom-style: solid;\n  border-left-width: 0px;\n  border-left-color: rgb(2, 110, 159);\n  border-left-style: solid;\n}\n#colibri.woocommerce-page  .content .h-section .star-rating::before,#colibri.woocommerce .content .h-section .star-rating::before,#colibri.woocommerce-page  .content .h-section .star-rating span::before,#colibri.woocommerce .content .h-section .star-rating span::before {\n  color: #03a9f4;\n}\n#colibri.woocommerce-page  .content .h-section .price,#colibri.woocommerce .content .h-section .price {\n  color: #03a9f4;\n}\n#colibri.woocommerce-page  .content .h-section .price del,#colibri.woocommerce .content .h-section .price del {\n  color: rgb(84, 194, 244);\n}\n#colibri.woocommerce-page  .content .h-section .onsale,#colibri.woocommerce .content .h-section .onsale {\n  background-color: #03a9f4;\n  background-image: none;\n}\n#colibri.woocommerce-page  .content .h-section .onsale:hover,#colibri.woocommerce-page  .content .h-section .onsale:focus,#colibri.woocommerce-page  .content .h-section .onsale:active,#colibri.woocommerce .content .h-section .onsale:hover,#colibri.woocommerce .content .h-section .onsale:focus,#colibri.woocommerce .content .h-section .onsale:active {\n  background-color: rgb(2, 110, 159);\n  background-image: none;\n}\n#colibri.woocommerce ul.products li.product h2:hover {\n  color: #03a9f4;\n}\n#colibri.woocommerce-page  .content .h-section .woocommerce-pagination .page-numbers.current,#colibri.woocommerce .content .h-section .woocommerce-pagination .page-numbers.current,#colibri.woocommerce-page  .content .h-section .woocommerce-pagination a.page-numbers:hover,#colibri.woocommerce .content .h-section .woocommerce-pagination a.page-numbers:hover {\n  background-color: #03a9f4;\n  background-image: none;\n}\n#colibri.woocommerce-page  .content .h-section .comment-form-rating .stars a,#colibri.woocommerce .content .h-section .comment-form-rating .stars a {\n  color: #03a9f4;\n}\n.h-section-global-spacing {\n  padding-top: 75px;\n  padding-bottom: 75px;\n}\n#colibri .colibri-language-switcher {\n  background-color: white;\n  background-image: none;\n  top: 80px;\n  border-top-width: 0px;\n  border-top-style: none;\n  border-top-left-radius: 4px;\n  border-top-right-radius: 0px;\n  border-right-width: 0px;\n  border-right-style: none;\n  border-bottom-width: 0px;\n  border-bottom-style: none;\n  border-bottom-left-radius: 4px;\n  border-bottom-right-radius: 0px;\n  border-left-width: 0px;\n  border-left-style: none;\n}\n#colibri .colibri-language-switcher .lang-item {\n  padding-top: 14px;\n  padding-right: 18px;\n  padding-bottom: 14px;\n  padding-left: 18px;\n}\nbody {\n  font-family: Open Sans;\n  font-weight: 400;\n  font-size: 16px;\n  line-height: 1.6;\n  color: rgb(102, 102, 102);\n}\nbody a {\n  font-family: Open Sans;\n  font-weight: 400;\n  text-decoration: none;\n  font-size: 1em;\n  line-height: 1.5;\n  color: rgb(2, 110, 159);\n}\nbody a:hover {\n  color: #03a9f4;\n}\nbody p {\n  margin-bottom: 16px;\n  font-family: Open Sans;\n  font-weight: 400;\n  font-size: 16px;\n  line-height: 1.6;\n  color: rgb(102, 102, 102);\n}\nbody .h-lead p {\n  margin-bottom: 16px;\n  font-family: Open Sans;\n  font-weight: 300;\n  font-size: 1.11em;\n  line-height: 1.5;\n  color: rgb(51, 51, 51);\n}\nbody blockquote p {\n  margin-bottom: 16px;\n  font-family: Open Sans;\n  font-weight: 400;\n  font-size: 16px;\n  line-height: 1.6;\n  color: rgb(153, 153, 153);\n}\nbody h1 {\n  margin-bottom: 16px;\n  font-family: Montserrat;\n  font-weight: 500;\n  font-size: 3.5em;\n  line-height: 1.26;\n  color: rgb(51, 51, 51);\n}\nbody h2 {\n  margin-bottom: 16px;\n  font-family: Montserrat;\n  font-weight: 300;\n  font-size: 2.625em;\n  line-height: 1.143;\n  color: rgb(51, 51, 51);\n}\nbody h3 {\n  margin-bottom: 16px;\n  font-family: Montserrat;\n  font-weight: 400;\n  font-size: 2.25em;\n  line-height: 1.25;\n  color: rgb(51, 51, 51);\n}\nbody h4 {\n  margin-bottom: 16px;\n  font-family: Montserrat;\n  font-weight: 600;\n  font-size: 1.11em;\n  line-height: 1.6;\n  color: rgb(51, 51, 51);\n}\nbody h5 {\n  margin-bottom: 16px;\n  font-family: Montserrat;\n  font-weight: 600;\n  font-size: 1em;\n  line-height: 1.55;\n  color: rgb(51, 51, 51);\n}\nbody h6 {\n  margin-bottom: 16px;\n  font-family: Montserrat;\n  font-weight: 600;\n  font-size: 1em;\n  line-height: 1.6;\n  color: rgb(51, 51, 51);\n  text-transform: uppercase;\n}\n .content.colibri-main-content-single .main-section,.content.colibri-main-content-archive .main-section {\n  padding-top: 90px;\n}\n .content.colibri-main-content-single .main-section .main-section-inner,.content.colibri-main-content-archive .main-section .main-section-inner {\n  margin-top: -115px;\n}\n\r\n\r\n@media (min-width: 768px) and (max-width: 1023px){\r\n.h-section-global-spacing {\n  padding-top: 60px;\n  padding-bottom: 60px;\n}\nbody h1 {\n  font-size: 3em;\n}\n\r\n}\n\r\n@media (max-width: 767px){\r\n.h-section-global-spacing {\n  padding-top: 30px;\n  padding-bottom: 30px;\n}\nbody h1 {\n  font-size: 2.8em;\n}\n\r\n}\n\";s:6:\"medias\";a:3:{s:7:\"desktop\";a:6:{s:2:\"id\";s:7:\"desktop\";s:5:\"label\";s:7:\"desktop\";s:4:\"icon\";s:15:\"desktop_windows\";s:4:\"show\";b:1;s:4:\"main\";b:1;s:10:\"gridPrefix\";s:2:\"lg\";}s:6:\"tablet\";a:7:{s:2:\"id\";s:6:\"tablet\";s:5:\"label\";s:6:\"tablet\";s:4:\"icon\";s:14:\"tablet_android\";s:4:\"show\";b:0;s:5:\"width\";i:1024;s:10:\"gridPrefix\";s:2:\"md\";s:5:\"query\";s:49:\"@media (min-width: 768px) and (max-width: 1023px)\";}s:6:\"mobile\";a:6:{s:2:\"id\";s:6:\"mobile\";s:5:\"label\";s:6:\"mobile\";s:4:\"icon\";s:13:\"phone_android\";s:4:\"show\";b:0;s:5:\"width\";i:480;s:5:\"query\";s:25:\"@media (max-width: 767px)\";}}s:8:\"defaults\";a:1:{s:8:\"partials\";a:4:{s:7:\"sidebar\";a:6:{s:10:\"front_page\";i:-1;s:4:\"page\";i:-1;s:4:\"post\";i:40;s:12:\"archive_post\";i:-1;s:7:\"product\";i:43;s:15:\"archive_product\";i:-1;}s:6:\"header\";a:6:{s:10:\"front_page\";i:18;s:4:\"page\";i:-1;s:4:\"post\";i:22;s:12:\"archive_post\";i:-1;s:7:\"product\";i:-1;s:15:\"archive_product\";i:-1;}s:6:\"footer\";a:6:{s:10:\"front_page\";i:-1;s:4:\"page\";i:-1;s:4:\"post\";i:25;s:12:\"archive_post\";i:-1;s:7:\"product\";i:-1;s:15:\"archive_product\";i:-1;}s:4:\"main\";a:6:{i:404;i:34;s:4:\"post\";i:28;s:7:\"archive\";i:31;s:15:\"archive_product\";i:-1;s:7:\"product\";i:-1;s:6:\"search\";i:37;}}}s:12:\"widget_areas\";a:10:{s:20:\"header-widget-area-1\";a:3:{s:4:\"name\";s:20:\"Header widget area 1\";s:5:\"index\";i:1;s:4:\"type\";s:6:\"header\";}s:20:\"header-widget-area-2\";a:3:{s:4:\"name\";s:20:\"Header widget area 2\";s:5:\"index\";i:2;s:4:\"type\";s:6:\"header\";}s:20:\"header-widget-area-3\";a:3:{s:4:\"name\";s:20:\"Header widget area 3\";s:5:\"index\";i:3;s:4:\"type\";s:6:\"header\";}s:21:\"content-widget-area-1\";a:3:{s:4:\"name\";s:21:\"In page widget area 1\";s:5:\"index\";i:1;s:4:\"type\";s:7:\"content\";}s:21:\"content-widget-area-2\";a:3:{s:4:\"name\";s:21:\"In page widget area 2\";s:5:\"index\";i:2;s:4:\"type\";s:7:\"content\";}s:21:\"content-widget-area-3\";a:3:{s:4:\"name\";s:21:\"In page widget area 3\";s:5:\"index\";i:3;s:4:\"type\";s:7:\"content\";}s:20:\"footer-widget-area-1\";a:3:{s:4:\"name\";s:20:\"Footer widget area 1\";s:5:\"index\";i:1;s:4:\"type\";s:6:\"footer\";}s:20:\"footer-widget-area-2\";a:3:{s:4:\"name\";s:20:\"Footer widget area 2\";s:5:\"index\";i:2;s:4:\"type\";s:6:\"footer\";}s:20:\"footer-widget-area-3\";a:3:{s:4:\"name\";s:20:\"Footer widget area 3\";s:5:\"index\";i:3;s:4:\"type\";s:6:\"footer\";}s:20:\"footer-widget-area-4\";a:3:{s:4:\"name\";s:20:\"Footer widget area 4\";s:5:\"index\";i:4;s:4:\"type\";s:6:\"footer\";}}s:4:\"urls\";a:2:{s:19:\"colibri_uploads_url\";s:45:\"http://localhost/wordpress/wp-content/uploads\";s:16:\"colibri_home_url\";s:27:\"http://localhost/wordpress/\";}s:8:\"imported\";a:10:{s:18:\"theme_default_data\";b:1;s:17:\"header/front_page\";b:1;s:11:\"header/post\";b:1;s:11:\"footer/post\";b:1;s:9:\"main/post\";b:1;s:12:\"main/archive\";b:1;s:8:\"main/404\";b:1;s:11:\"main/search\";b:1;s:12:\"sidebar/post\";b:1;s:15:\"sidebar/product\";b:1;}s:14:\"cssByPartialId\";a:18:{i:18;a:4:{s:11:\"local-18-h4\";a:2:{s:7:\"desktop\";s:169:\"#colibri .h-navigation_sticky .style-local-18-h4-outer,#colibri .h-navigation_sticky.style-local-18-h4-outer {\n  width: 100% ;\n  flex: 0 0 auto;\n  -ms-flex: 0 0 auto;\n}\n\";s:6:\"mobile\";s:94:\"#colibri .style-local-18-h4-outer {\n  width: 100% ;\n  flex: 0 0 auto;\n  -ms-flex: 0 0 auto;\n}\n\";}s:12:\"local-18-h10\";a:2:{s:7:\"desktop\";s:93:\"#colibri .style-local-18-h10-outer {\n  flex: 1 1 0;\n  -ms-flex: 1 1 0%;\n  max-width: 100%;\n}\n\";s:6:\"mobile\";s:95:\"#colibri .style-local-18-h10-outer {\n  width: 100% ;\n  flex: 0 0 auto;\n  -ms-flex: 0 0 auto;\n}\n\";}s:12:\"local-18-h13\";a:2:{s:7:\"desktop\";s:93:\"#colibri .style-local-18-h13-outer {\n  flex: 1 1 0;\n  -ms-flex: 1 1 0%;\n  max-width: 100%;\n}\n\";s:6:\"mobile\";s:95:\"#colibri .style-local-18-h13-outer {\n  width: 100% ;\n  flex: 0 0 auto;\n  -ms-flex: 0 0 auto;\n}\n\";}s:12:\"local-18-h23\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:94:\"#colibri .style-local-18-h23-outer {\n  width: 50% ;\n  flex: 0 0 auto;\n  -ms-flex: 0 0 auto;\n}\n\";s:6:\"mobile\";s:95:\"#colibri .style-local-18-h23-outer {\n  width: 100% ;\n  flex: 0 0 auto;\n  -ms-flex: 0 0 auto;\n}\n\";}}i:22;a:6:{s:11:\"local-22-h4\";a:2:{s:7:\"desktop\";s:169:\"#colibri .h-navigation_sticky .style-local-22-h4-outer,#colibri .h-navigation_sticky.style-local-22-h4-outer {\n  width: 100% ;\n  flex: 0 0 auto;\n  -ms-flex: 0 0 auto;\n}\n\";s:6:\"mobile\";s:94:\"#colibri .style-local-22-h4-outer {\n  width: 100% ;\n  flex: 0 0 auto;\n  -ms-flex: 0 0 auto;\n}\n\";}s:11:\"local-22-h8\";a:1:{s:7:\"desktop\";s:166:\"#colibri .style-local-22-h8 {\n  button-align: center;\n}\n#colibri .style-local-22-h8 >  div > .colibri-menu-container > ul.colibri-menu {\n  justify-content: center;\n}\n\";}s:12:\"local-22-h13\";a:2:{s:7:\"desktop\";s:93:\"#colibri .style-local-22-h13-outer {\n  flex: 1 1 0;\n  -ms-flex: 1 1 0%;\n  max-width: 100%;\n}\n\";s:6:\"mobile\";s:95:\"#colibri .style-local-22-h13-outer {\n  width: 100% ;\n  flex: 0 0 auto;\n  -ms-flex: 0 0 auto;\n}\n\";}s:12:\"local-22-h16\";a:2:{s:7:\"desktop\";s:93:\"#colibri .style-local-22-h16-outer {\n  flex: 1 1 0;\n  -ms-flex: 1 1 0%;\n  max-width: 100%;\n}\n\";s:6:\"mobile\";s:95:\"#colibri .style-local-22-h16-outer {\n  width: 100% ;\n  flex: 0 0 auto;\n  -ms-flex: 0 0 auto;\n}\n\";}s:11:\"local-22-h7\";a:1:{s:7:\"desktop\";s:152:\"#colibri .h-navigation_sticky .style-local-22-h7-image,#colibri .h-navigation_sticky.style-local-22-h7-image {\n  max-width: 41ch;\n  max-height: 106%;\n}\n\";}s:11:\"local-22-h6\";a:2:{s:7:\"desktop\";s:0:\"\";s:6:\"mobile\";s:94:\"#colibri .style-local-22-h6-outer {\n  width: 100% ;\n  flex: 0 0 auto;\n  -ms-flex: 0 0 auto;\n}\n\";}}i:25;a:4:{s:11:\"local-25-f4\";a:1:{s:7:\"desktop\";s:94:\"#colibri .style-local-25-f4-outer {\n  width: 100% ;\n  flex: 0 0 auto;\n  -ms-flex: 0 0 auto;\n}\n\";}s:11:\"local-25-f8\";a:2:{s:7:\"desktop\";s:0:\"\";s:6:\"mobile\";s:94:\"#colibri .style-local-25-f8-outer {\n  width: 100% ;\n  flex: 0 0 auto;\n  -ms-flex: 0 0 auto;\n}\n\";}s:12:\"local-25-f12\";a:2:{s:7:\"desktop\";s:0:\"\";s:6:\"mobile\";s:95:\"#colibri .style-local-25-f12-outer {\n  width: 100% ;\n  flex: 0 0 auto;\n  -ms-flex: 0 0 auto;\n}\n\";}s:12:\"local-25-f18\";a:2:{s:7:\"desktop\";s:0:\"\";s:6:\"mobile\";s:95:\"#colibri .style-local-25-f18-outer {\n  width: 100% ;\n  flex: 0 0 auto;\n  -ms-flex: 0 0 auto;\n}\n\";}}i:28;a:11:{s:11:\"local-28-m4\";a:2:{s:7:\"desktop\";s:0:\"\";s:6:\"mobile\";s:94:\"#colibri .style-local-28-m4-outer {\n  width: 100% ;\n  flex: 0 0 auto;\n  -ms-flex: 0 0 auto;\n}\n\";}s:13:\"dynamic-28-m5\";a:1:{s:7:\"desktop\";s:59:\".site .style-dynamic-28-m5-height {\n  min-height: 300px;\n}\n\";}s:11:\"local-28-m7\";a:1:{s:7:\"desktop\";s:94:\"#colibri .style-local-28-m7-outer {\n  width: 100% ;\n  flex: 0 0 auto;\n  -ms-flex: 0 0 auto;\n}\n\";}s:11:\"local-28-m9\";a:3:{s:7:\"desktop\";s:93:\"#colibri .style-local-28-m9-outer {\n  width: 50% ;\n  flex: 0 0 auto;\n  -ms-flex: 0 0 auto;\n}\n\";s:6:\"tablet\";s:54:\"#colibri .style-local-28-m9-outer {\n  width: 100% ;\n}\n\";s:6:\"mobile\";s:54:\"#colibri .style-local-28-m9-outer {\n  width: 100% ;\n}\n\";}s:12:\"local-28-m11\";a:3:{s:7:\"desktop\";s:94:\"#colibri .style-local-28-m11-outer {\n  width: 50% ;\n  flex: 0 0 auto;\n  -ms-flex: 0 0 auto;\n}\n\";s:6:\"tablet\";s:55:\"#colibri .style-local-28-m11-outer {\n  width: 100% ;\n}\n\";s:6:\"mobile\";s:55:\"#colibri .style-local-28-m11-outer {\n  width: 100% ;\n}\n\";}s:12:\"local-28-m15\";a:1:{s:7:\"desktop\";s:0:\"\";}s:12:\"local-28-m17\";a:1:{s:7:\"desktop\";s:0:\"\";}s:12:\"local-28-m25\";a:1:{s:7:\"desktop\";s:0:\"\";}s:12:\"local-28-m27\";a:1:{s:7:\"desktop\";s:0:\"\";}s:12:\"local-28-m28\";a:1:{s:7:\"desktop\";s:0:\"\";}s:12:\"local-28-m31\";a:1:{s:7:\"desktop\";s:95:\"#colibri .style-local-28-m31-outer {\n  width: 100% ;\n  flex: 0 0 auto;\n  -ms-flex: 0 0 auto;\n}\n\";}}i:31;a:8:{s:11:\"local-31-m4\";a:2:{s:7:\"desktop\";s:0:\"\";s:6:\"mobile\";s:94:\"#colibri .style-local-31-m4-outer {\n  width: 100% ;\n  flex: 0 0 auto;\n  -ms-flex: 0 0 auto;\n}\n\";}s:13:\"dynamic-31-m5\";a:1:{s:7:\"desktop\";s:59:\".site .style-dynamic-31-m5-height {\n  min-height: 300px;\n}\n\";}s:11:\"local-31-m7\";a:1:{s:7:\"desktop\";s:94:\"#colibri .style-local-31-m7-outer {\n  width: 100% ;\n  flex: 0 0 auto;\n  -ms-flex: 0 0 auto;\n}\n\";}s:12:\"local-31-m11\";a:1:{s:7:\"desktop\";s:0:\"\";}s:12:\"local-31-m13\";a:1:{s:7:\"desktop\";s:0:\"\";}s:12:\"local-31-m17\";a:1:{s:7:\"desktop\";s:0:\"\";}s:12:\"local-31-m19\";a:1:{s:7:\"desktop\";s:0:\"\";}s:12:\"local-31-m21\";a:1:{s:7:\"desktop\";s:0:\"\";}}i:34;a:1:{s:11:\"local-34-m3\";a:2:{s:7:\"desktop\";s:0:\"\";s:6:\"mobile\";s:94:\"#colibri .style-local-34-m3-outer {\n  width: 100% ;\n  flex: 0 0 auto;\n  -ms-flex: 0 0 auto;\n}\n\";}}i:37;a:7:{s:11:\"local-37-m3\";a:2:{s:7:\"desktop\";s:0:\"\";s:6:\"mobile\";s:94:\"#colibri .style-local-37-m3-outer {\n  width: 100% ;\n  flex: 0 0 auto;\n  -ms-flex: 0 0 auto;\n}\n\";}s:11:\"local-37-m7\";a:1:{s:7:\"desktop\";s:0:\"\";}s:11:\"local-37-m9\";a:1:{s:7:\"desktop\";s:0:\"\";}s:12:\"local-37-m13\";a:1:{s:7:\"desktop\";s:0:\"\";}s:12:\"local-37-m15\";a:1:{s:7:\"desktop\";s:0:\"\";}s:12:\"local-37-m17\";a:1:{s:7:\"desktop\";s:0:\"\";}s:12:\"local-37-m20\";a:2:{s:7:\"desktop\";s:0:\"\";s:6:\"mobile\";s:95:\"#colibri .style-local-37-m20-outer {\n  width: 100% ;\n  flex: 0 0 auto;\n  -ms-flex: 0 0 auto;\n}\n\";}}i:40;a:1:{s:11:\"local-40-s4\";a:1:{s:7:\"desktop\";s:94:\"#colibri .style-local-40-s4-outer {\n  width: 100% ;\n  flex: 0 0 auto;\n  -ms-flex: 0 0 auto;\n}\n\";}}i:43;a:1:{s:11:\"local-43-s4\";a:1:{s:7:\"desktop\";s:94:\"#colibri .style-local-43-s4-outer {\n  width: 100% ;\n  flex: 0 0 auto;\n  -ms-flex: 0 0 auto;\n}\n\";}}i:16;a:8:{s:12:\"local-16-c18\";a:2:{s:7:\"desktop\";s:0:\"\";s:6:\"mobile\";s:95:\"#colibri .style-local-16-c18-outer {\n  width: 100% ;\n  flex: 0 0 auto;\n  -ms-flex: 0 0 auto;\n}\n\";}s:12:\"local-16-c22\";a:2:{s:7:\"desktop\";s:0:\"\";s:6:\"mobile\";s:95:\"#colibri .style-local-16-c22-outer {\n  width: 100% ;\n  flex: 0 0 auto;\n  -ms-flex: 0 0 auto;\n}\n\";}s:12:\"local-16-c10\";a:2:{s:7:\"desktop\";s:0:\"\";s:6:\"mobile\";s:95:\"#colibri .style-local-16-c10-outer {\n  width: 100% ;\n  flex: 0 0 auto;\n  -ms-flex: 0 0 auto;\n}\n\";}s:12:\"local-16-c14\";a:2:{s:7:\"desktop\";s:0:\"\";s:6:\"mobile\";s:95:\"#colibri .style-local-16-c14-outer {\n  width: 100% ;\n  flex: 0 0 auto;\n  -ms-flex: 0 0 auto;\n}\n\";}s:12:\"local-16-c27\";a:2:{s:7:\"desktop\";s:97:\"#colibri .style-local-16-c27-outer {\n  width: 43.88% ;\n  flex: 0 0 auto;\n  -ms-flex: 0 0 auto;\n}\n\";s:6:\"mobile\";s:55:\"#colibri .style-local-16-c27-outer {\n  width: 100% ;\n}\n\";}s:12:\"local-16-c32\";a:2:{s:7:\"desktop\";s:94:\"#colibri .style-local-16-c32-outer {\n  width: 50% ;\n  flex: 0 0 auto;\n  -ms-flex: 0 0 auto;\n}\n\";s:6:\"mobile\";s:55:\"#colibri .style-local-16-c32-outer {\n  width: 100% ;\n}\n\";}s:11:\"local-16-c7\";a:1:{s:7:\"desktop\";s:94:\"#colibri .style-local-16-c7-outer {\n  width: 100% ;\n  flex: 0 0 auto;\n  -ms-flex: 0 0 auto;\n}\n\";}s:11:\"local-16-c4\";a:1:{s:7:\"desktop\";s:94:\"#colibri .style-local-16-c4-outer {\n  width: 100% ;\n  flex: 0 0 auto;\n  -ms-flex: 0 0 auto;\n}\n\";}}i:2;a:1:{s:10:\"local-2-c4\";a:1:{s:7:\"desktop\";s:144:\"#colibri .style-local-2-c4-outer {\n  width: 100% ;\n  flex: 0 0 auto;\n  -ms-flex: 0 0 auto;\n}\n#colibri .style-local-2-c4 {\n  text-align: left;\n}\n\";}}i:220;a:6:{s:13:\"local-220-c16\";a:2:{s:7:\"desktop\";s:95:\"#colibri .style-local-220-c16-outer {\n  width: 50% ;\n  flex: 0 0 auto;\n  -ms-flex: 0 0 auto;\n}\n\";s:6:\"mobile\";s:56:\"#colibri .style-local-220-c16-outer {\n  width: 100% ;\n}\n\";}s:13:\"local-220-c20\";a:2:{s:7:\"desktop\";s:95:\"#colibri .style-local-220-c20-outer {\n  width: 50% ;\n  flex: 0 0 auto;\n  -ms-flex: 0 0 auto;\n}\n\";s:6:\"mobile\";s:56:\"#colibri .style-local-220-c20-outer {\n  width: 100% ;\n}\n\";}s:12:\"local-220-c7\";a:2:{s:7:\"desktop\";s:97:\"#colibri .style-local-220-c7-outer {\n  width: 33.33% ;\n  flex: 0 0 auto;\n  -ms-flex: 0 0 auto;\n}\n\";s:6:\"mobile\";s:55:\"#colibri .style-local-220-c7-outer {\n  width: 100% ;\n}\n\";}s:12:\"local-220-c9\";a:2:{s:7:\"desktop\";s:97:\"#colibri .style-local-220-c9-outer {\n  width: 33.33% ;\n  flex: 0 0 auto;\n  -ms-flex: 0 0 auto;\n}\n\";s:6:\"mobile\";s:55:\"#colibri .style-local-220-c9-outer {\n  width: 100% ;\n}\n\";}s:13:\"local-220-c13\";a:2:{s:7:\"desktop\";s:98:\"#colibri .style-local-220-c13-outer {\n  width: 33.33% ;\n  flex: 0 0 auto;\n  -ms-flex: 0 0 auto;\n}\n\";s:6:\"mobile\";s:56:\"#colibri .style-local-220-c13-outer {\n  width: 100% ;\n}\n\";}s:12:\"local-220-c4\";a:2:{s:7:\"desktop\";s:0:\"\";s:6:\"mobile\";s:95:\"#colibri .style-local-220-c4-outer {\n  width: 100% ;\n  flex: 0 0 auto;\n  -ms-flex: 0 0 auto;\n}\n\";}}i:236;a:22:{s:13:\"local-236-c13\";a:2:{s:7:\"desktop\";s:0:\"\";s:6:\"mobile\";s:96:\"#colibri .style-local-236-c13-outer {\n  width: 100% ;\n  flex: 0 0 auto;\n  -ms-flex: 0 0 auto;\n}\n\";}s:13:\"local-236-c16\";a:2:{s:7:\"desktop\";s:0:\"\";s:6:\"mobile\";s:96:\"#colibri .style-local-236-c16-outer {\n  width: 100% ;\n  flex: 0 0 auto;\n  -ms-flex: 0 0 auto;\n}\n\";}s:13:\"local-236-c19\";a:2:{s:7:\"desktop\";s:0:\"\";s:6:\"mobile\";s:96:\"#colibri .style-local-236-c19-outer {\n  width: 100% ;\n  flex: 0 0 auto;\n  -ms-flex: 0 0 auto;\n}\n\";}s:13:\"local-236-c22\";a:2:{s:7:\"desktop\";s:0:\"\";s:6:\"mobile\";s:96:\"#colibri .style-local-236-c22-outer {\n  width: 100% ;\n  flex: 0 0 auto;\n  -ms-flex: 0 0 auto;\n}\n\";}s:13:\"local-236-c27\";a:2:{s:7:\"desktop\";s:0:\"\";s:6:\"mobile\";s:96:\"#colibri .style-local-236-c27-outer {\n  width: 100% ;\n  flex: 0 0 auto;\n  -ms-flex: 0 0 auto;\n}\n\";}s:13:\"local-236-c30\";a:2:{s:7:\"desktop\";s:0:\"\";s:6:\"mobile\";s:96:\"#colibri .style-local-236-c30-outer {\n  width: 100% ;\n  flex: 0 0 auto;\n  -ms-flex: 0 0 auto;\n}\n\";}s:13:\"local-236-c33\";a:2:{s:7:\"desktop\";s:0:\"\";s:6:\"mobile\";s:96:\"#colibri .style-local-236-c33-outer {\n  width: 100% ;\n  flex: 0 0 auto;\n  -ms-flex: 0 0 auto;\n}\n\";}s:13:\"local-236-c36\";a:2:{s:7:\"desktop\";s:0:\"\";s:6:\"mobile\";s:96:\"#colibri .style-local-236-c36-outer {\n  width: 100% ;\n  flex: 0 0 auto;\n  -ms-flex: 0 0 auto;\n}\n\";}s:13:\"local-236-c44\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:95:\"#colibri .style-local-236-c44-outer {\n  width: 50% ;\n  flex: 0 0 auto;\n  -ms-flex: 0 0 auto;\n}\n\";s:6:\"mobile\";s:96:\"#colibri .style-local-236-c44-outer {\n  width: 100% ;\n  flex: 0 0 auto;\n  -ms-flex: 0 0 auto;\n}\n\";}s:13:\"local-236-c46\";a:2:{s:7:\"desktop\";s:0:\"\";s:6:\"mobile\";s:96:\"#colibri .style-local-236-c46-outer {\n  width: 100% ;\n  flex: 0 0 auto;\n  -ms-flex: 0 0 auto;\n}\n\";}s:13:\"local-236-c61\";a:2:{s:7:\"desktop\";s:0:\"\";s:6:\"mobile\";s:96:\"#colibri .style-local-236-c61-outer {\n  width: 100% ;\n  flex: 0 0 auto;\n  -ms-flex: 0 0 auto;\n}\n\";}s:13:\"local-236-c74\";a:2:{s:7:\"desktop\";s:0:\"\";s:6:\"mobile\";s:96:\"#colibri .style-local-236-c74-outer {\n  width: 100% ;\n  flex: 0 0 auto;\n  -ms-flex: 0 0 auto;\n}\n\";}s:13:\"local-236-c50\";a:2:{s:7:\"desktop\";s:95:\"#colibri .style-local-236-c50-outer {\n  width: 50% ;\n  flex: 0 0 auto;\n  -ms-flex: 0 0 auto;\n}\n\";s:6:\"mobile\";s:56:\"#colibri .style-local-236-c50-outer {\n  width: 100% ;\n}\n\";}s:13:\"local-236-c53\";a:3:{s:7:\"desktop\";s:98:\"#colibri .style-local-236-c53-outer {\n  width: 49.99% ;\n  flex: 0 0 auto;\n  -ms-flex: 0 0 auto;\n}\n\";s:6:\"tablet\";s:55:\"#colibri .style-local-236-c53-outer {\n  width: 50% ;\n}\n\";s:6:\"mobile\";s:56:\"#colibri .style-local-236-c53-outer {\n  width: 100% ;\n}\n\";}s:13:\"local-236-c65\";a:2:{s:7:\"desktop\";s:95:\"#colibri .style-local-236-c65-outer {\n  width: 50% ;\n  flex: 0 0 auto;\n  -ms-flex: 0 0 auto;\n}\n\";s:6:\"mobile\";s:56:\"#colibri .style-local-236-c65-outer {\n  width: 100% ;\n}\n\";}s:13:\"local-236-c67\";a:2:{s:7:\"desktop\";s:95:\"#colibri .style-local-236-c67-outer {\n  width: 50% ;\n  flex: 0 0 auto;\n  -ms-flex: 0 0 auto;\n}\n\";s:6:\"mobile\";s:56:\"#colibri .style-local-236-c67-outer {\n  width: 100% ;\n}\n\";}s:13:\"local-236-c78\";a:2:{s:7:\"desktop\";s:95:\"#colibri .style-local-236-c78-outer {\n  width: 50% ;\n  flex: 0 0 auto;\n  -ms-flex: 0 0 auto;\n}\n\";s:6:\"mobile\";s:56:\"#colibri .style-local-236-c78-outer {\n  width: 100% ;\n}\n\";}s:13:\"local-236-c80\";a:2:{s:7:\"desktop\";s:95:\"#colibri .style-local-236-c80-outer {\n  width: 50% ;\n  flex: 0 0 auto;\n  -ms-flex: 0 0 auto;\n}\n\";s:6:\"mobile\";s:56:\"#colibri .style-local-236-c80-outer {\n  width: 100% ;\n}\n\";}s:13:\"local-236-c41\";a:2:{s:7:\"desktop\";s:95:\"#colibri .style-local-236-c41-outer {\n  width: 85% ;\n  flex: 0 0 auto;\n  -ms-flex: 0 0 auto;\n}\n\";s:6:\"mobile\";s:56:\"#colibri .style-local-236-c41-outer {\n  width: 100% ;\n}\n\";}s:13:\"local-236-c11\";a:1:{s:7:\"desktop\";s:0:\"\";}s:12:\"local-236-c4\";a:2:{s:7:\"desktop\";s:94:\"#colibri .style-local-236-c4-outer {\n  width: 50% ;\n  flex: 0 0 auto;\n  -ms-flex: 0 0 auto;\n}\n\";s:6:\"mobile\";s:55:\"#colibri .style-local-236-c4-outer {\n  width: 100% ;\n}\n\";}s:13:\"local-236-c10\";a:2:{s:7:\"desktop\";s:95:\"#colibri .style-local-236-c10-outer {\n  width: 50% ;\n  flex: 0 0 auto;\n  -ms-flex: 0 0 auto;\n}\n\";s:6:\"mobile\";s:56:\"#colibri .style-local-236-c10-outer {\n  width: 100% ;\n}\n\";}}i:320;a:7:{s:12:\"local-320-c7\";a:3:{s:7:\"desktop\";s:94:\"#colibri .style-local-320-c7-outer {\n  width: 75% ;\n  flex: 0 0 auto;\n  -ms-flex: 0 0 auto;\n}\n\";s:6:\"tablet\";s:54:\"#colibri .style-local-320-c7-outer {\n  width: 90% ;\n}\n\";s:6:\"mobile\";s:55:\"#colibri .style-local-320-c7-outer {\n  width: 100% ;\n}\n\";}s:12:\"local-320-c9\";a:2:{s:7:\"desktop\";s:94:\"#colibri .style-local-320-c9-outer {\n  width: 40% ;\n  flex: 0 0 auto;\n  -ms-flex: 0 0 auto;\n}\n\";s:6:\"mobile\";s:55:\"#colibri .style-local-320-c9-outer {\n  width: 100% ;\n}\n\";}s:13:\"local-320-c14\";a:3:{s:7:\"desktop\";s:95:\"#colibri .style-local-320-c14-outer {\n  width: 70% ;\n  flex: 0 0 auto;\n  -ms-flex: 0 0 auto;\n}\n\";s:6:\"tablet\";s:55:\"#colibri .style-local-320-c14-outer {\n  width: 60% ;\n}\n\";s:6:\"mobile\";s:56:\"#colibri .style-local-320-c14-outer {\n  width: 100% ;\n}\n\";}s:13:\"local-320-c24\";a:2:{s:7:\"desktop\";s:0:\"\";s:6:\"mobile\";s:96:\"#colibri .style-local-320-c24-outer {\n  width: 100% ;\n  flex: 0 0 auto;\n  -ms-flex: 0 0 auto;\n}\n\";}s:13:\"local-320-c25\";a:2:{s:7:\"desktop\";s:0:\"\";s:6:\"mobile\";s:96:\"#colibri .style-local-320-c25-outer {\n  width: 100% ;\n  flex: 0 0 auto;\n  -ms-flex: 0 0 auto;\n}\n\";}s:13:\"local-320-c28\";a:2:{s:7:\"desktop\";s:0:\"\";s:6:\"mobile\";s:96:\"#colibri .style-local-320-c28-outer {\n  width: 100% ;\n  flex: 0 0 auto;\n  -ms-flex: 0 0 auto;\n}\n\";}s:13:\"local-320-c29\";a:2:{s:7:\"desktop\";s:0:\"\";s:6:\"mobile\";s:96:\"#colibri .style-local-320-c29-outer {\n  width: 100% ;\n  flex: 0 0 auto;\n  -ms-flex: 0 0 auto;\n}\n\";}}i:881;a:12:{s:12:\"local-881-c7\";a:2:{s:7:\"desktop\";s:94:\"#colibri .style-local-881-c7-outer {\n  width: 50% ;\n  flex: 0 0 auto;\n  -ms-flex: 0 0 auto;\n}\n\";s:6:\"mobile\";s:55:\"#colibri .style-local-881-c7-outer {\n  width: 100% ;\n}\n\";}s:12:\"local-881-c9\";a:2:{s:7:\"desktop\";s:94:\"#colibri .style-local-881-c9-outer {\n  width: 50% ;\n  flex: 0 0 auto;\n  -ms-flex: 0 0 auto;\n}\n\";s:6:\"mobile\";s:55:\"#colibri .style-local-881-c9-outer {\n  width: 100% ;\n}\n\";}s:12:\"local-881-c8\";a:1:{s:7:\"desktop\";s:0:\"\";}s:13:\"local-881-c20\";a:2:{s:7:\"desktop\";s:0:\"\";s:6:\"mobile\";s:96:\"#colibri .style-local-881-c20-outer {\n  width: 100% ;\n  flex: 0 0 auto;\n  -ms-flex: 0 0 auto;\n}\n\";}s:13:\"local-881-c23\";a:2:{s:7:\"desktop\";s:0:\"\";s:6:\"mobile\";s:96:\"#colibri .style-local-881-c23-outer {\n  width: 100% ;\n  flex: 0 0 auto;\n  -ms-flex: 0 0 auto;\n}\n\";}s:13:\"local-881-c26\";a:2:{s:7:\"desktop\";s:0:\"\";s:6:\"mobile\";s:96:\"#colibri .style-local-881-c26-outer {\n  width: 100% ;\n  flex: 0 0 auto;\n  -ms-flex: 0 0 auto;\n}\n\";}s:13:\"local-881-c29\";a:2:{s:7:\"desktop\";s:0:\"\";s:6:\"mobile\";s:96:\"#colibri .style-local-881-c29-outer {\n  width: 100% ;\n  flex: 0 0 auto;\n  -ms-flex: 0 0 auto;\n}\n\";}s:13:\"local-881-c34\";a:2:{s:7:\"desktop\";s:0:\"\";s:6:\"mobile\";s:96:\"#colibri .style-local-881-c34-outer {\n  width: 100% ;\n  flex: 0 0 auto;\n  -ms-flex: 0 0 auto;\n}\n\";}s:13:\"local-881-c37\";a:2:{s:7:\"desktop\";s:0:\"\";s:6:\"mobile\";s:96:\"#colibri .style-local-881-c37-outer {\n  width: 100% ;\n  flex: 0 0 auto;\n  -ms-flex: 0 0 auto;\n}\n\";}s:13:\"local-881-c40\";a:2:{s:7:\"desktop\";s:0:\"\";s:6:\"mobile\";s:96:\"#colibri .style-local-881-c40-outer {\n  width: 100% ;\n  flex: 0 0 auto;\n  -ms-flex: 0 0 auto;\n}\n\";}s:12:\"local-881-c4\";a:1:{s:7:\"desktop\";s:95:\"#colibri .style-local-881-c4-outer {\n  width: 100% ;\n  flex: 0 0 auto;\n  -ms-flex: 0 0 auto;\n}\n\";}s:13:\"local-881-c17\";a:1:{s:7:\"desktop\";s:96:\"#colibri .style-local-881-c17-outer {\n  width: 100% ;\n  flex: 0 0 auto;\n  -ms-flex: 0 0 auto;\n}\n\";}}i:969;a:2:{s:12:\"local-969-c4\";a:2:{s:7:\"desktop\";s:0:\"\";s:6:\"mobile\";s:95:\"#colibri .style-local-969-c4-outer {\n  width: 100% ;\n  flex: 0 0 auto;\n  -ms-flex: 0 0 auto;\n}\n\";}s:12:\"local-969-c6\";a:2:{s:7:\"desktop\";s:0:\"\";s:6:\"mobile\";s:95:\"#colibri .style-local-969-c6-outer {\n  width: 100% ;\n  flex: 0 0 auto;\n  -ms-flex: 0 0 auto;\n}\n\";}}i:1467;a:2:{s:13:\"local-1467-c7\";a:1:{s:7:\"desktop\";s:96:\"#colibri .style-local-1467-c7-outer {\n  width: 100% ;\n  flex: 0 0 auto;\n  -ms-flex: 0 0 auto;\n}\n\";}s:13:\"local-1467-c4\";a:1:{s:7:\"desktop\";s:96:\"#colibri .style-local-1467-c4-outer {\n  width: 100% ;\n  flex: 0 0 auto;\n  -ms-flex: 0 0 auto;\n}\n\";}}i:1497;a:2:{s:13:\"local-1497-c4\";a:1:{s:7:\"desktop\";s:96:\"#colibri .style-local-1497-c4-outer {\n  width: 100% ;\n  flex: 0 0 auto;\n  -ms-flex: 0 0 auto;\n}\n\";}s:13:\"local-1497-c7\";a:1:{s:7:\"desktop\";s:96:\"#colibri .style-local-1497-c7-outer {\n  width: 100% ;\n  flex: 0 0 auto;\n  -ms-flex: 0 0 auto;\n}\n\";}}}s:7:\"cssById\";a:620:{i:1;a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}i:2;a:3:{s:7:\"desktop\";s:380:\"#colibri .style-2 {\n  animation-duration: 0.5s;\n  padding-top: 3px;\n  padding-bottom: 3px;\n  background-color: #ffffff;\n  background-image: none;\n}\n#colibri .h-navigation_sticky .style-2,#colibri .h-navigation_sticky.style-2 {\n  background-color: #ffffff;\n  background-image: none;\n  padding-top: 0px;\n  padding-bottom: 0px;\n  box-shadow: 0px 5px 10px 0px rgba(0, 0, 0, 0.05) ;\n}\n\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:65:\"#colibri .style-2 {\n  padding-top: 0px;\n  padding-bottom: 0px;\n}\n\";}i:3;a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}i:4;a:3:{s:7:\"desktop\";s:81:\"#colibri .style-4 {\n  text-align: center;\n  height: auto;\n  min-height: unset;\n}\n\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}i:5;a:3:{s:7:\"desktop\";s:693:\"#colibri .style-5-image {\n  max-height: 70px;\n}\n#colibri .style-5 {\n  color: #fff;\n}\n#colibri .style-5 a,#colibri .style-5  .logo-text {\n  color: #ffffff;\n  font-family: Montserrat;\n  font-weight: 600;\n  text-decoration: none;\n  text-transform: uppercase;\n  font-size: 15px;\n  letter-spacing: 2px;\n}\n#colibri .style-5 .logo-text {\n  color: #FFFFFF;\n}\n#colibri .h-navigation_sticky .style-5-image,#colibri .h-navigation_sticky.style-5-image {\n  max-height: 70px;\n}\n#colibri .h-navigation_sticky .style-5 a,#colibri .h-navigation_sticky .style-5  .logo-text,#colibri .h-navigation_sticky.style-5 a,#colibri .h-navigation_sticky.style-5  .logo-text {\n  color: #000000;\n  text-decoration: none;\n}\n\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}i:6;a:3:{s:7:\"desktop\";s:81:\"#colibri .style-6 {\n  text-align: center;\n  height: auto;\n  min-height: unset;\n}\n\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}i:7;a:3:{s:7:\"desktop\";s:38:\"#colibri .style-7 {\n  height: 50px;\n}\n\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}i:8;a:3:{s:7:\"desktop\";s:81:\"#colibri .style-8 {\n  text-align: center;\n  height: auto;\n  min-height: unset;\n}\n\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}i:9;a:3:{s:7:\"desktop\";s:10242:\"#colibri .style-9 >  div > .colibri-menu-container > ul.colibri-menu {\n  justify-content: flex-end;\n}\n#colibri .style-9 >  div > .colibri-menu-container > ul.colibri-menu > li {\n  margin-top: 0px;\n  margin-right: 7px;\n  margin-bottom: 0px;\n  margin-left: 7px;\n  padding-top: 20px;\n  padding-right: 21px;\n  padding-bottom: 20px;\n  padding-left: 21px;\n}\n#colibri .style-9 >  div > .colibri-menu-container > ul.colibri-menu > li.current_page_item,#colibri .style-9  >  div > .colibri-menu-container > ul.colibri-menu > li.current_page_item:hover {\n  margin-top: 0px;\n  margin-right: 7px;\n  margin-bottom: 0px;\n  margin-left: 7px;\n  padding-top: 20px;\n  padding-right: 21px;\n  padding-bottom: 20px;\n  padding-left: 21px;\n}\n#colibri .style-9 >  div > .colibri-menu-container > ul.colibri-menu > li > a {\n  font-family: Montserrat;\n  font-weight: 500;\n  text-transform: uppercase;\n  font-size: 12px;\n  line-height: 1.5em;\n  letter-spacing: 1px;\n  color: #000000;\n}\n#colibri .style-9  >  div > .colibri-menu-container > ul.colibri-menu > li.current_page_item > a,#colibri .style-9  >  div > .colibri-menu-container > ul.colibri-menu > li.current_page_item > a:hover {\n  font-family: Montserrat;\n  font-weight: 500;\n  text-transform: uppercase;\n  font-size: 12px;\n  line-height: 1.5em;\n  letter-spacing: 1px;\n  color: #000000;\n}\n#colibri .style-9 >  div > .colibri-menu-container > ul.colibri-menu li > ul {\n  background-color: #ffffff;\n  background-image: none;\n  margin-right: 5px;\n  margin-left: 5px;\n  box-shadow: 0px 0px 5px 2px rgba(0, 0, 0, 0.04) ;\n}\n#colibri .style-9 >  div > .colibri-menu-container > ul.colibri-menu li > ul  li {\n  padding-top: 10px;\n  padding-right: 20px;\n  padding-bottom: 10px;\n  padding-left: 20px;\n  border-top-width: 0px;\n  border-top-style: none;\n  border-right-width: 0px;\n  border-right-style: none;\n  border-bottom-width: 1px;\n  border-bottom-color: rgba(128,128,128,.2);\n  border-bottom-style: solid;\n  border-left-width: 0px;\n  border-left-style: none;\n  background-color: rgb(255, 255, 255);\n  background-image: none;\n}\n#colibri .style-9  >  div > .colibri-menu-container > ul.colibri-menu li > ul > li.hover {\n  background-color: #f79007;\n}\n#colibri .style-9  >  div > .colibri-menu-container > ul.colibri-menu li > ul > li:hover,#colibri .style-9  >  div > .colibri-menu-container > ul.colibri-menu li > ul > li.hover {\n  background-color: #f79007;\n}\n#colibri .style-9 >  div > .colibri-menu-container > ul.colibri-menu li > ul li.current_page_item,#colibri .style-9  >  div > .colibri-menu-container > ul.colibri-menu li > ul > li.current_page_item:hover {\n  padding-top: 10px;\n  padding-right: 20px;\n  padding-bottom: 10px;\n  padding-left: 20px;\n  border-top-width: 0px;\n  border-top-style: none;\n  border-right-width: 0px;\n  border-right-style: none;\n  border-bottom-width: 1px;\n  border-bottom-color: rgba(128,128,128,.2);\n  border-bottom-style: solid;\n  border-left-width: 0px;\n  border-left-style: none;\n  background-color: #f79007;\n  background-image: none;\n}\n#colibri .style-9 >  div > .colibri-menu-container > ul.colibri-menu li > ul > li > a {\n  font-size: 14px;\n  color: #f79007;\n}\n#colibri .style-9  >  div > .colibri-menu-container > ul.colibri-menu li > ul > li.hover  > a {\n  color: rgb(255, 255, 255);\n}\n#colibri .style-9  >  div > .colibri-menu-container > ul.colibri-menu li > ul > li:hover > a,#colibri .style-9  >  div > .colibri-menu-container > ul.colibri-menu li > ul > li.hover  > a {\n  color: rgb(255, 255, 255);\n}\n#colibri .style-9 >  div > .colibri-menu-container > ul.colibri-menu li > ul > li.current_page_item > a,#colibri .style-9  >  div > .colibri-menu-container > ul.colibri-menu li > ul > li.current_page_item > a:hover {\n  font-size: 14px;\n  color: rgb(255, 255, 255);\n}\n#colibri .style-9 >  div > .colibri-menu-container > ul.colibri-menu.bordered-active-item > li::after,#colibri .style-9 \n      ul.colibri-menu.bordered-active-item > li::before {\n  background-color: #000000;\n  background-image: none;\n  height: 3px;\n}\n#colibri .style-9 >  div > .colibri-menu-container > ul.colibri-menu.solid-active-item > li::after,#colibri .style-9 \n      ul.colibri-menu.solid-active-item > li::before {\n  background-color: white;\n  background-image: none;\n  border-top-width: 0px;\n  border-top-style: none;\n  border-top-left-radius: 0%;\n  border-top-right-radius: 0%;\n  border-right-width: 0px;\n  border-right-style: none;\n  border-bottom-width: 0px;\n  border-bottom-style: none;\n  border-bottom-left-radius: 0%;\n  border-bottom-right-radius: 0%;\n  border-left-width: 0px;\n  border-left-style: none;\n}\n#colibri .style-9 >  div > .colibri-menu-container > ul.colibri-menu > li > ul {\n  margin-top: 0px;\n}\n#colibri .style-9 >  div > .colibri-menu-container > ul.colibri-menu > li > ul::before {\n  height: 0px;\n  width: 100% ;\n}\n#colibri .style-9 >  div > .colibri-menu-container > ul.colibri-menu  li > a > svg,#colibri .style-9 >  div > .colibri-menu-container > ul.colibri-menu  li > a >  .arrow-wrapper {\n  padding-right: 16px;\n  padding-left: 16px;\n  color: #000000;\n}\n#colibri .style-9 >  div > .colibri-menu-container > ul.colibri-menu li.current_page_item > a > svg,#colibri .style-9 >  div > .colibri-menu-container > ul.colibri-menu > li.current_page_item:hover > a > svg,#colibri .style-9 >  div > .colibri-menu-container > ul.colibri-menu li.current_page_item > a > .arrow-wrapper,#colibri .style-9 >  div > .colibri-menu-container > ul.colibri-menu > li.current_page_item:hover > a > .arrow-wrapper {\n  padding-right: 16px;\n  padding-left: 16px;\n  color: #000000;\n}\n#colibri .style-9 >  div > .colibri-menu-container > ul.colibri-menu li > ul  li > a > svg,#colibri .style-9 >  div > .colibri-menu-container > ul.colibri-menu li > ul  li > a >  .arrow-wrapper {\n  color: #FFFFFF;\n}\n#colibri .style-9 >  div > .colibri-menu-container > ul.colibri-menu li > ul li.current_page_item > a > svg,#colibri .style-9 >  div > .colibri-menu-container > ul.colibri-menu li > ul > li.current_page_item:hover > a > svg,#colibri .style-9 >  div > .colibri-menu-container > ul.colibri-menu li > ul li.current_page_item > a > .arrow-wrapper,#colibri .style-9 >  div > .colibri-menu-container > ul.colibri-menu li > ul > li.current_page_item:hover > a > .arrow-wrapper {\n  color: #FFFFFF;\n}\n#colibri .h-navigation_sticky .style-9 >  div > .colibri-menu-container > ul.colibri-menu > li,#colibri .h-navigation_sticky.style-9 >  div > .colibri-menu-container > ul.colibri-menu > li {\n  margin-right: 8px;\n  margin-left: 8px;\n  padding-top: 12px;\n  padding-right: 53px;\n  padding-bottom: 12px;\n  padding-left: 53px;\n}\n#colibri .h-navigation_sticky .style-9 >  div > .colibri-menu-container > ul.colibri-menu > li > a,#colibri .h-navigation_sticky.style-9 >  div > .colibri-menu-container > ul.colibri-menu > li > a {\n  color: #000000;\n}\n#colibri .h-navigation_sticky .style-9  >  div > .colibri-menu-container > ul.colibri-menu > li.current_page_item > a,#colibri .h-navigation_sticky .style-9  >  div > .colibri-menu-container > ul.colibri-menu > li.current_page_item > a:hover,#colibri .h-navigation_sticky.style-9  >  div > .colibri-menu-container > ul.colibri-menu > li.current_page_item > a,#colibri .h-navigation_sticky.style-9  >  div > .colibri-menu-container > ul.colibri-menu > li.current_page_item > a:hover {\n  color: #000000;\n}\n#colibri .h-navigation_sticky .style-9 >  div > .colibri-menu-container > ul.colibri-menu li > ul  li,#colibri .h-navigation_sticky.style-9 >  div > .colibri-menu-container > ul.colibri-menu li > ul  li {\n  background-color: #FFFFFF;\n  background-image: none;\n}\n#colibri .h-navigation_sticky .style-9  >  div > .colibri-menu-container > ul.colibri-menu li > ul > li.hover,#colibri .h-navigation_sticky.style-9  >  div > .colibri-menu-container > ul.colibri-menu li > ul > li.hover {\n  background-color: #f79007;\n}\n#colibri .h-navigation_sticky .style-9  >  div > .colibri-menu-container > ul.colibri-menu li > ul > li:hover,#colibri .h-navigation_sticky .style-9  >  div > .colibri-menu-container > ul.colibri-menu li > ul > li.hover,#colibri .h-navigation_sticky.style-9  >  div > .colibri-menu-container > ul.colibri-menu li > ul > li:hover,#colibri .h-navigation_sticky.style-9  >  div > .colibri-menu-container > ul.colibri-menu li > ul > li.hover {\n  background-color: #f79007;\n}\n#colibri .h-navigation_sticky .style-9 >  div > .colibri-menu-container > ul.colibri-menu li > ul > li > a,#colibri .h-navigation_sticky.style-9 >  div > .colibri-menu-container > ul.colibri-menu li > ul > li > a {\n  color: #f79007;\n}\n#colibri .h-navigation_sticky .style-9  >  div > .colibri-menu-container > ul.colibri-menu li > ul > li.hover  > a,#colibri .h-navigation_sticky.style-9  >  div > .colibri-menu-container > ul.colibri-menu li > ul > li.hover  > a {\n  color: #FFFFFF;\n}\n#colibri .h-navigation_sticky .style-9  >  div > .colibri-menu-container > ul.colibri-menu li > ul > li:hover > a,#colibri .h-navigation_sticky .style-9  >  div > .colibri-menu-container > ul.colibri-menu li > ul > li.hover  > a,#colibri .h-navigation_sticky.style-9  >  div > .colibri-menu-container > ul.colibri-menu li > ul > li:hover > a,#colibri .h-navigation_sticky.style-9  >  div > .colibri-menu-container > ul.colibri-menu li > ul > li.hover  > a {\n  color: #FFFFFF;\n}\n#colibri .h-navigation_sticky .style-9 >  div > .colibri-menu-container > ul.colibri-menu.bordered-active-item > li::after,#colibri .h-navigation_sticky .style-9 \n      ul.colibri-menu.bordered-active-item > li::before,#colibri .h-navigation_sticky.style-9 >  div > .colibri-menu-container > ul.colibri-menu.bordered-active-item > li::after,#colibri .h-navigation_sticky.style-9 \n      ul.colibri-menu.bordered-active-item > li::before {\n  background-color: #000000;\n  background-image: none;\n}\n#colibri .h-navigation_sticky .style-9 >  div > .colibri-menu-container > ul.colibri-menu  li > a > svg,#colibri .h-navigation_sticky .style-9 >  div > .colibri-menu-container > ul.colibri-menu  li > a >  .arrow-wrapper,#colibri .h-navigation_sticky.style-9 >  div > .colibri-menu-container > ul.colibri-menu  li > a > svg,#colibri .h-navigation_sticky.style-9 >  div > .colibri-menu-container > ul.colibri-menu  li > a >  .arrow-wrapper {\n  color: #000000;\n  padding-right: 0px;\n  padding-left: 0px;\n}\n\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:100:\"#colibri .style-9 >  div > .colibri-menu-container > ul.colibri-menu {\n  justify-content: center;\n}\n\";}i:10;a:3:{s:7:\"desktop\";s:1138:\"#colibri .style-10-offscreen {\n  background-color: #222B34;\n  background-image: none;\n  width: 300px !important;\n}\n#colibri .style-10-offscreenOverlay {\n  background-color: rgba(0,0,0,0.5);\n  background-image: none;\n}\n#colibri .style-10  .h-hamburger-icon {\n  background-color: rgba(0, 0, 0, 0.1);\n  background-image: none;\n  border-top-width: 0px;\n  border-top-color: black;\n  border-top-style: solid;\n  border-top-left-radius: 100%;\n  border-top-right-radius: 100%;\n  border-right-width: 0px;\n  border-right-color: black;\n  border-right-style: solid;\n  border-bottom-width: 0px;\n  border-bottom-color: black;\n  border-bottom-style: solid;\n  border-bottom-left-radius: 100%;\n  border-bottom-right-radius: 100%;\n  border-left-width: 0px;\n  border-left-color: black;\n  border-left-style: solid;\n  fill: white;\n  padding-top: 5px;\n  padding-right: 5px;\n  padding-bottom: 5px;\n  padding-left: 5px;\n  width: 24px;\n  height: 24px;\n}\n#colibri .h-navigation_sticky .style-10  .h-hamburger-icon,#colibri .h-navigation_sticky.style-10  .h-hamburger-icon {\n  fill: #000000;\n  background-color: rgba(255, 255, 255, 0.1);\n  background-image: none;\n}\n\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}i:11;a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}i:12;a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}i:13;a:3:{s:7:\"desktop\";s:82:\"#colibri .style-13 {\n  text-align: center;\n  height: auto;\n  min-height: unset;\n}\n\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}i:14;a:3:{s:7:\"desktop\";s:591:\"#colibri .style-14-image {\n  max-height: 70px;\n}\n#colibri .style-14 a,#colibri .style-14  .logo-text {\n  color: #ffffff;\n  font-family: Montserrat;\n  font-weight: 600;\n  text-decoration: none;\n  text-transform: uppercase;\n  font-size: 15px;\n}\n#colibri .h-navigation_sticky .style-14-image,#colibri .h-navigation_sticky.style-14-image {\n  max-height: 70px;\n}\n#colibri .h-navigation_sticky .style-14 a,#colibri .h-navigation_sticky .style-14  .logo-text,#colibri .h-navigation_sticky.style-14 a,#colibri .h-navigation_sticky.style-14  .logo-text {\n  color: #000000;\n  text-decoration: none;\n}\n\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}i:15;a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}i:16;a:3:{s:7:\"desktop\";s:82:\"#colibri .style-16 {\n  text-align: center;\n  height: auto;\n  min-height: unset;\n}\n\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}i:17;a:3:{s:7:\"desktop\";s:5361:\"#colibri .style-17 {\n  background-color: rgba(0,0,0,0);\n  background-image: none;\n}\n#colibri .style-17 >  div > .colibri-menu-container > ul.colibri-menu > li > a {\n  padding-top: 12px;\n  padding-bottom: 12px;\n  padding-left: 40px;\n  border-top-width: 0px;\n  border-top-color: #808080;\n  border-top-style: solid;\n  border-right-width: 0px;\n  border-right-color: #808080;\n  border-right-style: solid;\n  border-bottom-width: 1px;\n  border-bottom-color: rgba(255, 255, 255, 0.2);\n  border-bottom-style: solid;\n  border-left-width: 0px;\n  border-left-color: #808080;\n  border-left-style: solid;\n  font-family: Montserrat;\n  font-weight: 500;\n  text-transform: uppercase;\n  font-size: 12px;\n  letter-spacing: 1px;\n  color: white;\n}\n#colibri .style-17  >  div > .colibri-menu-container > ul.colibri-menu > li.hover  > a {\n  background-color: #03a9f4;\n  background-image: none;\n}\n#colibri .style-17  >  div > .colibri-menu-container > ul.colibri-menu > li:hover > a,#colibri .style-17  >  div > .colibri-menu-container > ul.colibri-menu > li.hover  > a {\n  background-color: #03a9f4;\n  background-image: none;\n}\n#colibri .style-17  >  div > .colibri-menu-container > ul.colibri-menu > li.current_page_item > a,#colibri .style-17  >  div > .colibri-menu-container > ul.colibri-menu > li.current_page_item > a:hover {\n  padding-top: 12px;\n  padding-bottom: 12px;\n  padding-left: 40px;\n  border-top-width: 0px;\n  border-top-color: #808080;\n  border-top-style: solid;\n  border-right-width: 0px;\n  border-right-color: #808080;\n  border-right-style: solid;\n  border-bottom-width: 1px;\n  border-bottom-color: rgba(255, 255, 255, 0.2);\n  border-bottom-style: solid;\n  border-left-width: 0px;\n  border-left-color: #808080;\n  border-left-style: solid;\n  background-color: #03a9f4;\n  background-image: none;\n  font-family: Montserrat;\n  font-weight: 500;\n  text-transform: uppercase;\n  font-size: 12px;\n  letter-spacing: 1px;\n  color: white;\n}\n#colibri .style-17 >  div > .colibri-menu-container > ul.colibri-menu li > ul {\n  background-color: rgba(0,0,0,0);\n  background-image: none;\n}\n#colibri .style-17 >  div > .colibri-menu-container > ul.colibri-menu li > ul > li > a {\n  padding-top: 12px;\n  padding-bottom: 12px;\n  padding-left: 40px;\n  border-top-width: 0px;\n  border-top-color: #808080;\n  border-top-style: solid;\n  border-right-width: 0px;\n  border-right-color: #808080;\n  border-right-style: solid;\n  border-bottom-width: 1px;\n  border-bottom-color: rgba(255, 255, 255, 0.2);\n  border-bottom-style: solid;\n  border-left-width: 0px;\n  border-left-color: #808080;\n  border-left-style: solid;\n  font-size: 14px;\n  color: white;\n}\n#colibri .style-17  >  div > .colibri-menu-container > ul.colibri-menu li > ul > li.hover  > a {\n  background-color: rgba(3, 169, 244, 0.8);\n  background-image: none;\n}\n#colibri .style-17  >  div > .colibri-menu-container > ul.colibri-menu li > ul > li:hover > a,#colibri .style-17  >  div > .colibri-menu-container > ul.colibri-menu li > ul > li.hover  > a {\n  background-color: rgba(3, 169, 244, 0.8);\n  background-image: none;\n}\n#colibri .style-17 >  div > .colibri-menu-container > ul.colibri-menu li > ul > li.current_page_item > a,#colibri .style-17  >  div > .colibri-menu-container > ul.colibri-menu li > ul > li.current_page_item > a:hover {\n  padding-top: 12px;\n  padding-bottom: 12px;\n  padding-left: 40px;\n  border-top-width: 0px;\n  border-top-color: #808080;\n  border-top-style: solid;\n  border-right-width: 0px;\n  border-right-color: #808080;\n  border-right-style: solid;\n  border-bottom-width: 1px;\n  border-bottom-color: rgba(255, 255, 255, 0.2);\n  border-bottom-style: solid;\n  border-left-width: 0px;\n  border-left-color: #808080;\n  border-left-style: solid;\n  background-color: rgba(3, 169, 244, 0.8);\n  background-image: none;\n  font-size: 14px;\n  color: white;\n}\n#colibri .style-17 >  div > .colibri-menu-container > ul.colibri-menu  li > a > svg,#colibri .style-17 >  div > .colibri-menu-container > ul.colibri-menu  li > a >  .arrow-wrapper {\n  padding-right: 20px;\n  padding-left: 20px;\n  color: #FFFFFF;\n}\n#colibri .style-17 >  div > .colibri-menu-container > ul.colibri-menu li.current_page_item > a > svg,#colibri .style-17 >  div > .colibri-menu-container > ul.colibri-menu > li.current_page_item:hover > a > svg,#colibri .style-17 >  div > .colibri-menu-container > ul.colibri-menu li.current_page_item > a > .arrow-wrapper,#colibri .style-17 >  div > .colibri-menu-container > ul.colibri-menu > li.current_page_item:hover > a > .arrow-wrapper {\n  padding-right: 20px;\n  padding-left: 20px;\n  color: #FFFFFF;\n}\n#colibri .style-17 >  div > .colibri-menu-container > ul.colibri-menu li > ul  li > a > svg,#colibri .style-17 >  div > .colibri-menu-container > ul.colibri-menu li > ul  li > a >  .arrow-wrapper {\n  color: white;\n  padding-right: 20px;\n  padding-left: 20px;\n}\n#colibri .style-17 >  div > .colibri-menu-container > ul.colibri-menu li > ul li.current_page_item > a > svg,#colibri .style-17 >  div > .colibri-menu-container > ul.colibri-menu li > ul > li.current_page_item:hover > a > svg,#colibri .style-17 >  div > .colibri-menu-container > ul.colibri-menu li > ul li.current_page_item > a > .arrow-wrapper,#colibri .style-17 >  div > .colibri-menu-container > ul.colibri-menu li > ul > li.current_page_item:hover > a > .arrow-wrapper {\n  color: white;\n  padding-right: 20px;\n  padding-left: 20px;\n}\n\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}i:18;a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}i:19;a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}i:20;a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}i:21;a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}i:22;a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}i:23;a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}i:24;a:3:{s:7:\"desktop\";s:667:\"#colibri .style-24 {\n  min-height: 100vh;\n  background-color: #FFFFFF;\n  background-position: custom;\n  background-size: 100% 100%;\n  background-image: url(\"http://localhost/wordpress/wp-content/uploads/2024/09/logoKaribea1-1.png\");\n  background-attachment: fixed;\n  background-repeat: no-repeat;\n  padding-top: 0px;\n  padding-bottom: 0px;\n  color: #FFFFFF;\n}\n#colibri .style-24 p {\n  color: #FFFFFF;\n}\n#colibri .style-24 h1 {\n  color: #FFFFFF;\n}\n#colibri .style-24 h2 {\n  color: #FFFFFF;\n}\n#colibri .style-24 h3 {\n  color: #FFFFFF;\n}\n#colibri .style-24 h4 {\n  color: #FFFFFF;\n}\n#colibri .style-24 h5 {\n  color: #FFFFFF;\n}\n#colibri .style-24 h6 {\n  color: #FFFFFF;\n}\n\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:45:\"#colibri .style-24 {\n  padding-top: 100px;\n}\n\";}i:25;a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}i:26;a:3:{s:7:\"desktop\";s:519:\"#colibri .style-26-outer {\n  width: 100% ;\n  flex: 0 0 auto;\n  -ms-flex: 0 0 auto;\n}\n#colibri .style-26 {\n  text-align: center;\n  height: auto;\n  min-height: unset;\n  border-top-width: 0px;\n  border-top-style: solid;\n  border-top-left-radius: 9px;\n  border-top-right-radius: 9px;\n  border-right-width: 0px;\n  border-right-style: solid;\n  border-bottom-width: 0px;\n  border-bottom-style: solid;\n  border-bottom-left-radius: 9px;\n  border-bottom-right-radius: 9px;\n  border-left-width: 0px;\n  border-left-style: solid;\n}\n\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}i:27;a:3:{s:7:\"desktop\";s:374:\"#colibri .style-27 p,#colibri .style-27  h1,#colibri .style-27  h2,#colibri .style-27  h3,#colibri .style-27  h4,#colibri .style-27  h5,#colibri .style-27  h6 {\n  color: #FFFFFF;\n  padding-bottom: 40px;\n  text-align: center;\n}\n#colibri .style-27 .text-wrapper-fancy svg path {\n  stroke: #000000;\n  stroke-linejoin: initial;\n  stroke-linecap: initial;\n  stroke-width: 8px;\n}\n\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}i:28;a:3:{s:7:\"desktop\";s:105:\"#colibri .style-28 ol {\n  list-style-type: decimal;\n}\n#colibri .style-28 ul {\n  list-style-type: disc;\n}\n\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}i:29;a:3:{s:7:\"desktop\";s:43:\"#colibri .style-29 {\n  text-align: left;\n}\n\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}i:30;a:3:{s:7:\"desktop\";s:1191:\"#colibri .style-30-icon {\n  width: 14px;\n  height: 14px;\n  margin-right: 10px;\n  margin-left: 0px;\n}\n#colibri .style-30 {\n  text-align: center;\n  font-family: Open Sans;\n  font-weight: 600;\n  text-transform: uppercase;\n  font-size: 14px;\n  line-height: 1;\n  letter-spacing: 1px;\n  color: #FFFFFF;\n  border-top-width: 2px;\n  border-top-color: #FFFFFF;\n  border-top-style: solid;\n  border-top-left-radius: 4px;\n  border-top-right-radius: 4px;\n  border-right-width: 2px;\n  border-right-color: #FFFFFF;\n  border-right-style: solid;\n  border-bottom-width: 2px;\n  border-bottom-color: #FFFFFF;\n  border-bottom-style: solid;\n  border-bottom-left-radius: 4px;\n  border-bottom-right-radius: 4px;\n  border-left-width: 2px;\n  border-left-color: #FFFFFF;\n  border-left-style: solid;\n  padding-top: 15px;\n  padding-right: 30px;\n  padding-bottom: 15px;\n  padding-left: 30px;\n  transition-duration: 0.5s;\n  background-color: rgba(0,0,0,0);\n  background-image: none;\n}\n#colibri .style-30:hover,#colibri .style-30:focus {\n  background-color: rgba(255, 255, 255, 0.2);\n  box-shadow: none;\n}\n#colibri .style-30:active .style-30-icon {\n  width: 14px;\n  height: 14px;\n  margin-right: 10px;\n  margin-left: 0px;\n}\n\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}i:31;a:3:{s:7:\"desktop\";s:1191:\"#colibri .style-31-icon {\n  width: 14px;\n  height: 14px;\n  margin-right: 10px;\n  margin-left: 0px;\n}\n#colibri .style-31 {\n  text-align: center;\n  font-family: Open Sans;\n  font-weight: 600;\n  text-transform: uppercase;\n  font-size: 14px;\n  line-height: 1;\n  letter-spacing: 1px;\n  color: #FFFFFF;\n  border-top-width: 2px;\n  border-top-color: #FFFFFF;\n  border-top-style: solid;\n  border-top-left-radius: 4px;\n  border-top-right-radius: 4px;\n  border-right-width: 2px;\n  border-right-color: #FFFFFF;\n  border-right-style: solid;\n  border-bottom-width: 2px;\n  border-bottom-color: #FFFFFF;\n  border-bottom-style: solid;\n  border-bottom-left-radius: 4px;\n  border-bottom-right-radius: 4px;\n  border-left-width: 2px;\n  border-left-color: #FFFFFF;\n  border-left-style: solid;\n  padding-top: 15px;\n  padding-right: 30px;\n  padding-bottom: 15px;\n  padding-left: 30px;\n  transition-duration: 0.5s;\n  background-color: rgba(0,0,0,0);\n  background-image: none;\n}\n#colibri .style-31:hover,#colibri .style-31:focus {\n  background-color: rgba(255, 255, 255, 0.2);\n  box-shadow: none;\n}\n#colibri .style-31:active .style-31-icon {\n  width: 14px;\n  height: 14px;\n  margin-right: 10px;\n  margin-left: 0px;\n}\n\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}i:32;a:3:{s:7:\"desktop\";s:82:\"#colibri .style-32 {\n  text-align: center;\n  height: auto;\n  min-height: unset;\n}\n\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}i:33;a:3:{s:7:\"desktop\";s:646:\"#colibri .style-33-image {\n  opacity: 1;\n}\n#colibri .style-33-caption {\n  margin-top: 10px;\n}\n#colibri .style-33-frameImage {\n  z-index: -1;\n  transform: translateX(10%) translateY(10%);\n  transform-origin: center center 0px;\n  background-color: rgb(0,0,0);\n  height: 100%;\n  width: 100% ;\n  border-top-width: 10px;\n  border-top-color: rgb(0,0,0);\n  border-top-style: none;\n  border-right-width: 10px;\n  border-right-color: rgb(0,0,0);\n  border-right-style: none;\n  border-bottom-width: 10px;\n  border-bottom-color: rgb(0,0,0);\n  border-bottom-style: none;\n  border-left-width: 10px;\n  border-left-color: rgb(0,0,0);\n  border-left-style: none;\n}\n\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}i:34;a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}i:35;a:3:{s:7:\"desktop\";s:391:\"#colibri .style-35 {\n  animation-duration: 0.5s;\n  padding-top: 20px;\n  padding-bottom: 20px;\n  background-color: transparent;\n  background-image: none;\n}\n#colibri .h-navigation_sticky .style-35,#colibri .h-navigation_sticky.style-35 {\n  background-color: #ffffff;\n  background-image: none;\n  padding-top: 10px;\n  padding-bottom: 10px;\n  box-shadow: 0px 5px 10px 0px rgba(0, 0, 0, 0.05) ;\n}\n\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:192:\"#colibri .style-35 {\n  padding-top: 0px;\n  padding-bottom: 0px;\n}\n#colibri .h-navigation_sticky .style-35,#colibri .h-navigation_sticky.style-35 {\n  padding-top: 0px;\n  padding-bottom: 0px;\n}\n\";}i:36;a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}i:37;a:3:{s:7:\"desktop\";s:82:\"#colibri .style-37 {\n  text-align: center;\n  height: auto;\n  min-height: unset;\n}\n\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}i:38;a:3:{s:7:\"desktop\";s:666:\"#colibri .style-38-image {\n  max-height: 70px;\n}\n#colibri .style-38 a,#colibri .style-38  .logo-text {\n  color: #ffffff;\n  font-family: Montserrat;\n  font-weight: 600;\n  text-decoration: none;\n  text-transform: uppercase;\n  font-size: 15px;\n  letter-spacing: 2px;\n}\n#colibri .style-38 .logo-text {\n  color: #FFFFFF;\n}\n#colibri .h-navigation_sticky .style-38-image,#colibri .h-navigation_sticky.style-38-image {\n  max-height: 70px;\n}\n#colibri .h-navigation_sticky .style-38 a,#colibri .h-navigation_sticky .style-38  .logo-text,#colibri .h-navigation_sticky.style-38 a,#colibri .h-navigation_sticky.style-38  .logo-text {\n  color: #000000;\n  text-decoration: none;\n}\n\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}i:39;a:3:{s:7:\"desktop\";s:82:\"#colibri .style-39 {\n  text-align: center;\n  height: auto;\n  min-height: unset;\n}\n\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}i:40;a:3:{s:7:\"desktop\";s:39:\"#colibri .style-40 {\n  height: 50px;\n}\n\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}i:41;a:3:{s:7:\"desktop\";s:82:\"#colibri .style-41 {\n  text-align: center;\n  height: auto;\n  min-height: unset;\n}\n\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}i:42;a:3:{s:7:\"desktop\";s:8722:\"#colibri .style-42 >  div > .colibri-menu-container > ul.colibri-menu {\n  justify-content: flex-start;\n}\n#colibri .style-42 >  div > .colibri-menu-container > ul.colibri-menu > li {\n  margin-top: 0px;\n  margin-right: 20px;\n  margin-bottom: 0px;\n  margin-left: 20px;\n  padding-top: 10px;\n  padding-right: 0px;\n  padding-bottom: 10px;\n  padding-left: 0px;\n}\n#colibri .style-42 >  div > .colibri-menu-container > ul.colibri-menu > li.current_page_item,#colibri .style-42  >  div > .colibri-menu-container > ul.colibri-menu > li.current_page_item:hover {\n  margin-top: 0px;\n  margin-right: 20px;\n  margin-bottom: 0px;\n  margin-left: 20px;\n  padding-top: 10px;\n  padding-right: 0px;\n  padding-bottom: 10px;\n  padding-left: 0px;\n}\n#colibri .style-42 >  div > .colibri-menu-container > ul.colibri-menu > li > a {\n  font-family: Montserrat;\n  font-weight: 500;\n  text-transform: uppercase;\n  font-size: 12px;\n  line-height: 1.5em;\n  letter-spacing: 1px;\n  color: #FFFFFF;\n}\n#colibri .style-42  >  div > .colibri-menu-container > ul.colibri-menu > li.current_page_item > a,#colibri .style-42  >  div > .colibri-menu-container > ul.colibri-menu > li.current_page_item > a:hover {\n  font-family: Montserrat;\n  font-weight: 500;\n  text-transform: uppercase;\n  font-size: 12px;\n  line-height: 1.5em;\n  letter-spacing: 1px;\n  color: #FFFFFF;\n}\n#colibri .style-42 >  div > .colibri-menu-container > ul.colibri-menu li > ul {\n  background-color: #ffffff;\n  background-image: none;\n  margin-right: 5px;\n  margin-left: 5px;\n  box-shadow: 0px 0px 5px 2px rgba(0, 0, 0, 0.04) ;\n}\n#colibri .style-42 >  div > .colibri-menu-container > ul.colibri-menu li > ul  li {\n  padding-top: 10px;\n  padding-right: 20px;\n  padding-bottom: 10px;\n  padding-left: 20px;\n  border-top-width: 0px;\n  border-top-style: none;\n  border-right-width: 0px;\n  border-right-style: none;\n  border-bottom-width: 1px;\n  border-bottom-color: rgba(128,128,128,.2);\n  border-bottom-style: solid;\n  border-left-width: 0px;\n  border-left-style: none;\n  background-color: rgb(255, 255, 255);\n  background-image: none;\n}\n#colibri .style-42  >  div > .colibri-menu-container > ul.colibri-menu li > ul > li.hover {\n  background-color: rgb(3, 169, 244);\n}\n#colibri .style-42  >  div > .colibri-menu-container > ul.colibri-menu li > ul > li:hover,#colibri .style-42  >  div > .colibri-menu-container > ul.colibri-menu li > ul > li.hover {\n  background-color: rgb(3, 169, 244);\n}\n#colibri .style-42 >  div > .colibri-menu-container > ul.colibri-menu li > ul li.current_page_item,#colibri .style-42  >  div > .colibri-menu-container > ul.colibri-menu li > ul > li.current_page_item:hover {\n  padding-top: 10px;\n  padding-right: 20px;\n  padding-bottom: 10px;\n  padding-left: 20px;\n  border-top-width: 0px;\n  border-top-style: none;\n  border-right-width: 0px;\n  border-right-style: none;\n  border-bottom-width: 1px;\n  border-bottom-color: rgba(128,128,128,.2);\n  border-bottom-style: solid;\n  border-left-width: 0px;\n  border-left-style: none;\n  background-color: rgb(3, 169, 244);\n  background-image: none;\n}\n#colibri .style-42 >  div > .colibri-menu-container > ul.colibri-menu li > ul > li > a {\n  font-size: 14px;\n  color: rgb(102, 102, 102);\n}\n#colibri .style-42  >  div > .colibri-menu-container > ul.colibri-menu li > ul > li.hover  > a {\n  color: rgb(255, 255, 255);\n}\n#colibri .style-42  >  div > .colibri-menu-container > ul.colibri-menu li > ul > li:hover > a,#colibri .style-42  >  div > .colibri-menu-container > ul.colibri-menu li > ul > li.hover  > a {\n  color: rgb(255, 255, 255);\n}\n#colibri .style-42 >  div > .colibri-menu-container > ul.colibri-menu li > ul > li.current_page_item > a,#colibri .style-42  >  div > .colibri-menu-container > ul.colibri-menu li > ul > li.current_page_item > a:hover {\n  font-size: 14px;\n  color: rgb(255, 255, 255);\n}\n#colibri .style-42 >  div > .colibri-menu-container > ul.colibri-menu.bordered-active-item > li::after,#colibri .style-42 \n      ul.colibri-menu.bordered-active-item > li::before {\n  background-color: #FFFFFF;\n  background-image: none;\n  height: 2px;\n}\n#colibri .style-42 >  div > .colibri-menu-container > ul.colibri-menu.solid-active-item > li::after,#colibri .style-42 \n      ul.colibri-menu.solid-active-item > li::before {\n  background-color: white;\n  background-image: none;\n  border-top-width: 0px;\n  border-top-style: none;\n  border-top-left-radius: 0%;\n  border-top-right-radius: 0%;\n  border-right-width: 0px;\n  border-right-style: none;\n  border-bottom-width: 0px;\n  border-bottom-style: none;\n  border-bottom-left-radius: 0%;\n  border-bottom-right-radius: 0%;\n  border-left-width: 0px;\n  border-left-style: none;\n}\n#colibri .style-42 >  div > .colibri-menu-container > ul.colibri-menu > li > ul {\n  margin-top: 0px;\n}\n#colibri .style-42 >  div > .colibri-menu-container > ul.colibri-menu > li > ul::before {\n  height: 0px;\n  width: 100% ;\n}\n#colibri .style-42 >  div > .colibri-menu-container > ul.colibri-menu  li > a > svg,#colibri .style-42 >  div > .colibri-menu-container > ul.colibri-menu  li > a >  .arrow-wrapper {\n  padding-right: 5px;\n  padding-left: 5px;\n  color: #FFFFFF;\n}\n#colibri .style-42 >  div > .colibri-menu-container > ul.colibri-menu li.current_page_item > a > svg,#colibri .style-42 >  div > .colibri-menu-container > ul.colibri-menu > li.current_page_item:hover > a > svg,#colibri .style-42 >  div > .colibri-menu-container > ul.colibri-menu li.current_page_item > a > .arrow-wrapper,#colibri .style-42 >  div > .colibri-menu-container > ul.colibri-menu > li.current_page_item:hover > a > .arrow-wrapper {\n  padding-right: 5px;\n  padding-left: 5px;\n  color: #FFFFFF;\n}\n#colibri .style-42 >  div > .colibri-menu-container > ul.colibri-menu li > ul  li > a > svg,#colibri .style-42 >  div > .colibri-menu-container > ul.colibri-menu li > ul  li > a >  .arrow-wrapper {\n  color: rgb(102, 102, 102);\n}\n#colibri .style-42 >  div > .colibri-menu-container > ul.colibri-menu li > ul > li.hover  > a > svg,#colibri .style-42 >  div > .colibri-menu-container > ul.colibri-menu li > ul > li.hover  > a > .arrow-wrapper {\n  color: #FFFFFF;\n}\n#colibri .style-42 >  div > .colibri-menu-container > ul.colibri-menu li > ul > li:hover  > a > svg,#colibri .style-42 >  div > .colibri-menu-container > ul.colibri-menu li > ul > li.hover  > a > svg,#colibri .style-42 >  div > .colibri-menu-container > ul.colibri-menu li > ul > li:hover  > a > .arrow-wrapper,#colibri .style-42 >  div > .colibri-menu-container > ul.colibri-menu li > ul > li.hover  > a > .arrow-wrapper {\n  color: #FFFFFF;\n}\n#colibri .style-42 >  div > .colibri-menu-container > ul.colibri-menu li > ul li.current_page_item > a > svg,#colibri .style-42 >  div > .colibri-menu-container > ul.colibri-menu li > ul > li.current_page_item:hover > a > svg,#colibri .style-42 >  div > .colibri-menu-container > ul.colibri-menu li > ul li.current_page_item > a > .arrow-wrapper,#colibri .style-42 >  div > .colibri-menu-container > ul.colibri-menu li > ul > li.current_page_item:hover > a > .arrow-wrapper {\n  color: #FFFFFF;\n}\n#colibri .h-navigation_sticky .style-42 >  div > .colibri-menu-container > ul.colibri-menu > li > a,#colibri .h-navigation_sticky.style-42 >  div > .colibri-menu-container > ul.colibri-menu > li > a {\n  color: rgb(0, 0, 0);\n}\n#colibri .h-navigation_sticky .style-42  >  div > .colibri-menu-container > ul.colibri-menu > li.current_page_item > a,#colibri .h-navigation_sticky .style-42  >  div > .colibri-menu-container > ul.colibri-menu > li.current_page_item > a:hover,#colibri .h-navigation_sticky.style-42  >  div > .colibri-menu-container > ul.colibri-menu > li.current_page_item > a,#colibri .h-navigation_sticky.style-42  >  div > .colibri-menu-container > ul.colibri-menu > li.current_page_item > a:hover {\n  color: rgb(0, 0, 0);\n}\n#colibri .h-navigation_sticky .style-42 >  div > .colibri-menu-container > ul.colibri-menu.bordered-active-item > li::after,#colibri .h-navigation_sticky .style-42 \n      ul.colibri-menu.bordered-active-item > li::before,#colibri .h-navigation_sticky.style-42 >  div > .colibri-menu-container > ul.colibri-menu.bordered-active-item > li::after,#colibri .h-navigation_sticky.style-42 \n      ul.colibri-menu.bordered-active-item > li::before {\n  background-color: rgb(0, 0, 0);\n  background-image: none;\n}\n#colibri .h-navigation_sticky .style-42 >  div > .colibri-menu-container > ul.colibri-menu  li > a > svg,#colibri .h-navigation_sticky .style-42 >  div > .colibri-menu-container > ul.colibri-menu  li > a >  .arrow-wrapper,#colibri .h-navigation_sticky.style-42 >  div > .colibri-menu-container > ul.colibri-menu  li > a > svg,#colibri .h-navigation_sticky.style-42 >  div > .colibri-menu-container > ul.colibri-menu  li > a >  .arrow-wrapper {\n  color: rgb(0, 0, 0);\n}\n\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}i:43;a:3:{s:7:\"desktop\";s:1143:\"#colibri .style-43-offscreen {\n  background-color: #222B34;\n  background-image: none;\n  width: 300px !important;\n}\n#colibri .style-43-offscreenOverlay {\n  background-color: rgba(0,0,0,0.5);\n  background-image: none;\n}\n#colibri .style-43  .h-hamburger-icon {\n  background-color: rgba(0, 0, 0, 0.1);\n  background-image: none;\n  border-top-width: 0px;\n  border-top-color: black;\n  border-top-style: solid;\n  border-top-left-radius: 100%;\n  border-top-right-radius: 100%;\n  border-right-width: 0px;\n  border-right-color: black;\n  border-right-style: solid;\n  border-bottom-width: 0px;\n  border-bottom-color: black;\n  border-bottom-style: solid;\n  border-bottom-left-radius: 100%;\n  border-bottom-right-radius: 100%;\n  border-left-width: 0px;\n  border-left-color: black;\n  border-left-style: solid;\n  fill: white;\n  padding-top: 5px;\n  padding-right: 5px;\n  padding-bottom: 5px;\n  padding-left: 5px;\n  width: 24px;\n  height: 24px;\n}\n#colibri .h-navigation_sticky .style-43  .h-hamburger-icon,#colibri .h-navigation_sticky.style-43  .h-hamburger-icon {\n  fill: rgb(0, 0, 0);\n  background-color: rgba(255, 255, 255, 0.1);\n  background-image: none;\n}\n\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}i:44;a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}i:45;a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}i:46;a:3:{s:7:\"desktop\";s:82:\"#colibri .style-46 {\n  text-align: center;\n  height: auto;\n  min-height: unset;\n}\n\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}i:47;a:3:{s:7:\"desktop\";s:591:\"#colibri .style-47-image {\n  max-height: 70px;\n}\n#colibri .style-47 a,#colibri .style-47  .logo-text {\n  color: #ffffff;\n  font-family: Montserrat;\n  font-weight: 600;\n  text-decoration: none;\n  text-transform: uppercase;\n  font-size: 15px;\n}\n#colibri .h-navigation_sticky .style-47-image,#colibri .h-navigation_sticky.style-47-image {\n  max-height: 70px;\n}\n#colibri .h-navigation_sticky .style-47 a,#colibri .h-navigation_sticky .style-47  .logo-text,#colibri .h-navigation_sticky.style-47 a,#colibri .h-navigation_sticky.style-47  .logo-text {\n  color: #000000;\n  text-decoration: none;\n}\n\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}i:48;a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}i:49;a:3:{s:7:\"desktop\";s:82:\"#colibri .style-49 {\n  text-align: center;\n  height: auto;\n  min-height: unset;\n}\n\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}i:50;a:3:{s:7:\"desktop\";s:5388:\"#colibri .style-50 {\n  background-color: rgba(0,0,0,0);\n  background-image: none;\n}\n#colibri .style-50 >  div > .colibri-menu-container > ul.colibri-menu > li > a {\n  padding-top: 12px;\n  padding-bottom: 12px;\n  padding-left: 40px;\n  border-top-width: 0px;\n  border-top-color: #808080;\n  border-top-style: solid;\n  border-right-width: 0px;\n  border-right-color: #808080;\n  border-right-style: solid;\n  border-bottom-width: 1px;\n  border-bottom-color: rgba(255, 255, 255, 0.2);\n  border-bottom-style: solid;\n  border-left-width: 0px;\n  border-left-color: #808080;\n  border-left-style: solid;\n  font-family: Montserrat;\n  font-weight: 500;\n  text-transform: uppercase;\n  font-size: 12px;\n  letter-spacing: 1px;\n  color: white;\n}\n#colibri .style-50  >  div > .colibri-menu-container > ul.colibri-menu > li.hover  > a {\n  background-color: rgb(3, 169, 244);\n  background-image: none;\n}\n#colibri .style-50  >  div > .colibri-menu-container > ul.colibri-menu > li:hover > a,#colibri .style-50  >  div > .colibri-menu-container > ul.colibri-menu > li.hover  > a {\n  background-color: rgb(3, 169, 244);\n  background-image: none;\n}\n#colibri .style-50  >  div > .colibri-menu-container > ul.colibri-menu > li.current_page_item > a,#colibri .style-50  >  div > .colibri-menu-container > ul.colibri-menu > li.current_page_item > a:hover {\n  padding-top: 12px;\n  padding-bottom: 12px;\n  padding-left: 40px;\n  border-top-width: 0px;\n  border-top-color: #808080;\n  border-top-style: solid;\n  border-right-width: 0px;\n  border-right-color: #808080;\n  border-right-style: solid;\n  border-bottom-width: 1px;\n  border-bottom-color: rgba(255, 255, 255, 0.2);\n  border-bottom-style: solid;\n  border-left-width: 0px;\n  border-left-color: #808080;\n  border-left-style: solid;\n  background-color: rgb(3, 169, 244);\n  background-image: none;\n  font-family: Montserrat;\n  font-weight: 500;\n  text-transform: uppercase;\n  font-size: 12px;\n  letter-spacing: 1px;\n  color: white;\n}\n#colibri .style-50 >  div > .colibri-menu-container > ul.colibri-menu li > ul {\n  background-color: rgba(0,0,0,0);\n  background-image: none;\n}\n#colibri .style-50 >  div > .colibri-menu-container > ul.colibri-menu li > ul > li > a {\n  padding-top: 12px;\n  padding-bottom: 12px;\n  padding-left: 40px;\n  border-top-width: 0px;\n  border-top-color: #808080;\n  border-top-style: solid;\n  border-right-width: 0px;\n  border-right-color: #808080;\n  border-right-style: solid;\n  border-bottom-width: 1px;\n  border-bottom-color: rgba(255, 255, 255, 0.2);\n  border-bottom-style: solid;\n  border-left-width: 0px;\n  border-left-color: #808080;\n  border-left-style: solid;\n  font-size: 14px;\n  color: white;\n}\n#colibri .style-50  >  div > .colibri-menu-container > ul.colibri-menu li > ul > li.hover  > a {\n  background-color: rgba(3, 169, 244, 0.8);\n  background-image: none;\n}\n#colibri .style-50  >  div > .colibri-menu-container > ul.colibri-menu li > ul > li:hover > a,#colibri .style-50  >  div > .colibri-menu-container > ul.colibri-menu li > ul > li.hover  > a {\n  background-color: rgba(3, 169, 244, 0.8);\n  background-image: none;\n}\n#colibri .style-50 >  div > .colibri-menu-container > ul.colibri-menu li > ul > li.current_page_item > a,#colibri .style-50  >  div > .colibri-menu-container > ul.colibri-menu li > ul > li.current_page_item > a:hover {\n  padding-top: 12px;\n  padding-bottom: 12px;\n  padding-left: 40px;\n  border-top-width: 0px;\n  border-top-color: #808080;\n  border-top-style: solid;\n  border-right-width: 0px;\n  border-right-color: #808080;\n  border-right-style: solid;\n  border-bottom-width: 1px;\n  border-bottom-color: rgba(255, 255, 255, 0.2);\n  border-bottom-style: solid;\n  border-left-width: 0px;\n  border-left-color: #808080;\n  border-left-style: solid;\n  background-color: rgba(3, 169, 244, 0.8);\n  background-image: none;\n  font-size: 14px;\n  color: white;\n}\n#colibri .style-50 >  div > .colibri-menu-container > ul.colibri-menu  li > a > svg,#colibri .style-50 >  div > .colibri-menu-container > ul.colibri-menu  li > a >  .arrow-wrapper {\n  padding-right: 20px;\n  padding-left: 20px;\n  color: #FFFFFF;\n}\n#colibri .style-50 >  div > .colibri-menu-container > ul.colibri-menu li.current_page_item > a > svg,#colibri .style-50 >  div > .colibri-menu-container > ul.colibri-menu > li.current_page_item:hover > a > svg,#colibri .style-50 >  div > .colibri-menu-container > ul.colibri-menu li.current_page_item > a > .arrow-wrapper,#colibri .style-50 >  div > .colibri-menu-container > ul.colibri-menu > li.current_page_item:hover > a > .arrow-wrapper {\n  padding-right: 20px;\n  padding-left: 20px;\n  color: #FFFFFF;\n}\n#colibri .style-50 >  div > .colibri-menu-container > ul.colibri-menu li > ul  li > a > svg,#colibri .style-50 >  div > .colibri-menu-container > ul.colibri-menu li > ul  li > a >  .arrow-wrapper {\n  color: white;\n  padding-right: 20px;\n  padding-left: 20px;\n}\n#colibri .style-50 >  div > .colibri-menu-container > ul.colibri-menu li > ul li.current_page_item > a > svg,#colibri .style-50 >  div > .colibri-menu-container > ul.colibri-menu li > ul > li.current_page_item:hover > a > svg,#colibri .style-50 >  div > .colibri-menu-container > ul.colibri-menu li > ul li.current_page_item > a > .arrow-wrapper,#colibri .style-50 >  div > .colibri-menu-container > ul.colibri-menu li > ul > li.current_page_item:hover > a > .arrow-wrapper {\n  color: white;\n  padding-right: 20px;\n  padding-left: 20px;\n}\n\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}i:51;a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}i:52;a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}i:53;a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}i:54;a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}i:55;a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}i:56;a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}i:57;a:3:{s:7:\"desktop\";s:665:\"#colibri .style-57 {\n  height: auto;\n  min-height: unset;\n  color: #FFFFFF;\n  background-position: center center;\n  background-size: cover;\n  background-image: linear-gradient(120deg,  rgba(252, 203, 144, 0.8) 0%, rgba(213, 126, 235, 0.8) 100%);\n  background-attachment: scroll;\n  background-repeat: no-repeat;\n  padding-top: 31px;\n  padding-bottom: 40px;\n}\n#colibri .style-57 h1 {\n  color: #FFFFFF;\n}\n#colibri .style-57 h2 {\n  color: #FFFFFF;\n}\n#colibri .style-57 h3 {\n  color: #FFFFFF;\n}\n#colibri .style-57 h4 {\n  color: #FFFFFF;\n}\n#colibri .style-57 h5 {\n  color: #FFFFFF;\n}\n#colibri .style-57 h6 {\n  color: #FFFFFF;\n}\n#colibri .style-57 p {\n  color: #FFFFFF;\n}\n\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}i:58;a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}i:59;a:3:{s:7:\"desktop\";s:166:\"#colibri .style-59-outer {\n  width: 50% ;\n  flex: 0 0 auto;\n  -ms-flex: 0 0 auto;\n}\n#colibri .style-59 {\n  text-align: center;\n  height: auto;\n  min-height: unset;\n}\n\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}i:60;a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}i:61;a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}i:62;a:3:{s:7:\"desktop\";s:568:\"#colibri .style-62 {\n  min-height: 92.04166412353516px;\n  padding-top: 15px;\n  padding-bottom: 94px;\n  background-color: #000000;\n  background-image: none;\n  border-top-width: 5px;\n  border-top-color: rgba(255, 255, 255, 0.5);\n  border-top-style: solid;\n  border-right-width: 0px;\n  border-right-color: rgba(255, 255, 255, 0.5);\n  border-right-style: solid;\n  border-bottom-width: 0px;\n  border-bottom-color: rgba(255, 255, 255, 0.5);\n  border-bottom-style: solid;\n  border-left-width: 0px;\n  border-left-color: rgba(255, 255, 255, 0.5);\n  border-left-style: solid;\n}\n\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}i:63;a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}i:64;a:3:{s:7:\"desktop\";s:156:\".style-64 > .h-y-container > *:not(:last-child) {\n  margin-bottom: 0px;\n}\n#colibri .style-64 {\n  text-align: center;\n  height: auto;\n  min-height: unset;\n}\n\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}i:65;a:3:{s:7:\"desktop\";s:150:\"#colibri .style-65 {\n  color: rgba(255, 255, 255, 0.7);\n}\n#colibri .style-65 a {\n  color: #FFFFFF;\n}\n#colibri .style-65 a:hover {\n  color: #03a9f4;\n}\n\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}i:66;a:3:{s:7:\"desktop\";s:261:\"#colibri .style-66 {\n  border-top-width: 0px;\n  border-top-style: none;\n  border-right-width: 0px;\n  border-right-style: none;\n  border-bottom-width: 0px;\n  border-bottom-style: none;\n  border-left-width: 0px;\n  border-left-style: none;\n  margin-top: -120px;\n}\n\";s:6:\"tablet\";s:44:\"#colibri .style-66 {\n  margin-top: -95px;\n}\n\";s:6:\"mobile\";s:0:\"\";}i:67;a:3:{s:7:\"desktop\";s:103:\"#colibri .style-67 {\n  height: auto;\n  min-height: unset;\n  padding-top: 0px;\n  padding-bottom: 0px;\n}\n\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}i:68;a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}i:69;a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}i:70;a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}i:71;a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}i:72;a:3:{s:7:\"desktop\";s:708:\"#colibri .style-72 {\n  background-position: center center;\n  background-size: cover;\n  background-image: linear-gradient(145deg,  #FFFFFF 42%, rgb(243, 243, 243) 100%);\n  background-attachment: scroll;\n  background-repeat: no-repeat;\n  box-shadow: 0px 20px 40px 2px rgba(0, 0, 0, 0.15) ;\n  margin-right: 40px;\n  margin-bottom: 40px;\n  margin-left: 40px;\n  border-top-width: 0px;\n  border-top-style: none;\n  border-top-left-radius: 27px;\n  border-top-right-radius: 27px;\n  border-right-width: 0px;\n  border-right-style: none;\n  border-bottom-width: 5px;\n  border-bottom-style: none;\n  border-bottom-left-radius: 25px;\n  border-bottom-right-radius: 25px;\n  border-left-width: 0px;\n  border-left-style: none;\n}\n\";s:6:\"tablet\";s:143:\"#colibri .style-72 {\n  box-shadow: 0px 10px 20px 2px rgba(0, 0, 0, 0.15) ;\n  margin-right: 20px;\n  margin-bottom: 20px;\n  margin-left: 20px;\n}\n\";s:6:\"mobile\";s:143:\"#colibri .style-72 {\n  box-shadow: 0px 10px 15px 2px rgba(0, 0, 0, 0.15) ;\n  margin-right: 15px;\n  margin-bottom: 20px;\n  margin-left: 15px;\n}\n\";}i:73;a:3:{s:7:\"desktop\";s:209:\".style-73 > .h-y-container > *:not(:last-child) {\n  margin-bottom: 0px;\n}\n#colibri .style-73 {\n  text-align: center;\n  height: auto;\n  min-height: unset;\n  background-color: unset;\n  background-image: none;\n}\n\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}i:74;a:3:{s:7:\"desktop\";s:526:\"#colibri .style-74 {\n  background-color: rgba(255,255,255,0);\n  background-image: none;\n  text-align: center;\n  border-top-width: 0px;\n  border-top-style: none;\n  border-top-left-radius: 25px;\n  border-top-right-radius: 25px;\n  border-right-width: 0px;\n  border-right-style: none;\n  border-bottom-width: 0px;\n  border-bottom-style: none;\n  border-left-width: 0px;\n  border-left-style: none;\n}\n#colibri .style-74 .colibri-post-thumbnail-shortcode img {\n  height: 300px;\n  object-position: center center;\n  object-fit: cover;\n}\n\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}i:75;a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}i:76;a:3:{s:7:\"desktop\";s:154:\".style-76 > .h-y-container > *:not(:last-child) {\n  margin-bottom: 0px;\n}\n#colibri .style-76 {\n  text-align: left;\n  height: auto;\n  min-height: unset;\n}\n\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}i:77;a:3:{s:7:\"desktop\";s:456:\"#colibri .style-77 {\n  margin-bottom: 15px;\n  border-top-width: 0px;\n  border-top-color: rgb(238, 238, 238);\n  border-top-style: solid;\n  border-right-width: 0px;\n  border-right-color: rgb(238, 238, 238);\n  border-right-style: solid;\n  border-bottom-width: 1px;\n  border-bottom-color: rgb(238, 238, 238);\n  border-bottom-style: solid;\n  border-left-width: 0px;\n  border-left-color: rgb(238, 238, 238);\n  border-left-style: solid;\n  padding-bottom: 15px;\n}\n\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}i:78;a:3:{s:7:\"desktop\";s:80:\"#colibri .style-78 {\n  text-align: left;\n  height: auto;\n  min-height: unset;\n}\n\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}i:79;a:3:{s:7:\"desktop\";s:778:\"#colibri .style-79 a,#colibri .style-79  .colibri-post-category {\n  margin-right: 10px;\n  font-family: Open Sans;\n  font-weight: 400;\n  text-decoration: underline;\n  text-transform: lowercase;\n  font-size: 14px;\n  color: rgb(102, 102, 102);\n  border-top-width: 0px;\n  border-top-style: solid;\n  border-right-width: 0px;\n  border-right-style: solid;\n  border-bottom-width: 0px;\n  border-bottom-style: solid;\n  border-left-width: 0px;\n  border-left-style: solid;\n}\n#colibri .style-79 a:hover,#colibri .style-79  .colibri-post-category:hover {\n  color: rgb(0, 0, 0);\n}\n#colibri .style-79 a:hover,#colibri .style-79  .colibri-post-category:hover {\n  color: rgb(0, 0, 0);\n}\n#colibri .style-79 .categories-prefix {\n  margin-right: 16px;\n  font-size: 14px;\n  color: rgb(51, 51, 51);\n}\n\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}i:80;a:3:{s:7:\"desktop\";s:81:\"#colibri .style-80 {\n  text-align: right;\n  height: auto;\n  min-height: unset;\n}\n\";s:6:\"tablet\";s:63:\"#colibri .style-80 {\n  text-align: left;\n  padding-top: 5px;\n}\n\";s:6:\"mobile\";s:63:\"#colibri .style-80 {\n  text-align: left;\n  padding-top: 5px;\n}\n\";}i:81;a:3:{s:7:\"desktop\";s:538:\"#colibri .style-81 a {\n  font-family: Open Sans;\n  font-weight: 400;\n  font-size: 14px;\n  color: rgb(102, 102, 102);\n}\n#colibri .style-81 a:hover {\n  color: rgb(0, 0, 0);\n}\n#colibri .style-81 a:hover {\n  color: rgb(0, 0, 0);\n}\n#colibri .style-81 .metadata-prefix {\n  font-size: 14px;\n  color: rgb(102, 102, 102);\n}\n#colibri .style-81 svg {\n  width: 20px ;\n  height: 20px;\n  margin-right: 5px;\n  display: none;\n}\n#colibri .style-81 .meta-separator {\n  font-size: 14px;\n  line-height: 1.6;\n  color: rgb(51, 51, 51);\n  padding-right: 5px;\n}\n\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}i:82;a:3:{s:7:\"desktop\";s:318:\"#colibri .style-82 .colibri-post-content {\n  margin-bottom: 0px;\n  font-family: Source Sans Pro;\n  font-weight: 300;\n  font-size: 18px;\n  color: rgb(51, 51, 51);\n}\n#colibri .style-82 .colibri-post-content a {\n  color: rgb(2, 110, 159);\n}\n#colibri .style-82 .colibri-post-content a:hover {\n  color: rgb(3, 169, 244);\n}\n\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}i:83;a:3:{s:7:\"desktop\";s:452:\"#colibri .style-83 {\n  border-top-width: 1px;\n  border-top-color: rgb(238, 238, 238);\n  border-top-style: solid;\n  border-right-width: 0px;\n  border-right-color: rgb(238, 238, 238);\n  border-right-style: solid;\n  border-bottom-width: 0px;\n  border-bottom-color: rgb(238, 238, 238);\n  border-bottom-style: solid;\n  border-left-width: 0px;\n  border-left-color: rgb(238, 238, 238);\n  border-left-style: solid;\n  margin-right: 30px;\n  margin-left: 30px;\n}\n\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:66:\"#colibri .style-83 {\n  margin-right: 15px;\n  margin-left: 15px;\n}\n\";}i:84;a:3:{s:7:\"desktop\";s:80:\"#colibri .style-84 {\n  text-align: left;\n  height: auto;\n  min-height: unset;\n}\n\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}i:85;a:3:{s:7:\"desktop\";s:562:\"#colibri .style-85-icon {\n  fill: rgb(3, 169, 244);\n  width: 24px ;\n  height: 24px;\n  border-top-width: 1px;\n  border-top-color: rgb(125, 79, 79);\n  border-top-style: none;\n  border-right-width: 1px;\n  border-right-color: rgb(125, 79, 79);\n  border-right-style: none;\n  border-bottom-width: 1px;\n  border-bottom-color: rgb(125, 79, 79);\n  border-bottom-style: none;\n  border-left-width: 1px;\n  border-left-color: rgb(125, 79, 79);\n  border-left-style: none;\n}\n#colibri .style-85-icon:hover {\n  background-color: rgba(45, 45, 134, 0);\n  background-image: none;\n}\n\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}i:86;a:3:{s:7:\"desktop\";s:101:\"#colibri .style-86 {\n  text-align: left;\n  height: auto;\n  min-height: unset;\n  padding-left: 5px;\n}\n\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}i:87;a:3:{s:7:\"desktop\";s:612:\"#colibri .style-87 a,#colibri .style-87  .colibri-post-tag {\n  margin-right: 10px;\n  font-family: Open Sans;\n  font-weight: 400;\n  text-transform: lowercase;\n  font-size: 14px;\n  color: rgb(3, 169, 244);\n  background-color: unset;\n  background-image: none;\n}\n#colibri .style-87 a:hover,#colibri .style-87  .colibri-post-tag:hover {\n  color: rgb(2, 110, 159);\n}\n#colibri .style-87 a:hover,#colibri .style-87  .colibri-post-tag:hover {\n  color: rgb(2, 110, 159);\n}\n#colibri .style-87 .tags-prefix {\n  margin-right: 16px;\n  font-family: Open Sans;\n  font-weight: 400;\n  font-size: 14px;\n  color: rgb(51, 51, 51);\n}\n\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}i:88;a:3:{s:7:\"desktop\";s:104:\"#colibri .style-88 {\n  height: auto;\n  min-height: unset;\n  padding-top: 0px;\n  padding-bottom: 40px;\n}\n\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}i:89;a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}i:90;a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}i:91;a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}i:92;a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}i:93;a:3:{s:7:\"desktop\";s:305:\"#colibri .style-93 {\n  border-top-width: 0px;\n  border-top-style: none;\n  border-right-width: 0px;\n  border-right-style: none;\n  border-bottom-width: 0px;\n  border-bottom-style: none;\n  border-left-width: 0px;\n  border-left-style: none;\n  margin-right: 40px;\n  margin-bottom: 40px;\n  margin-left: 40px;\n}\n\";s:6:\"tablet\";s:89:\"#colibri .style-93 {\n  margin-right: 20px;\n  margin-bottom: 20px;\n  margin-left: 20px;\n}\n\";s:6:\"mobile\";s:89:\"#colibri .style-93 {\n  margin-right: 15px;\n  margin-bottom: 15px;\n  margin-left: 15px;\n}\n\";}i:94;a:3:{s:7:\"desktop\";s:80:\"#colibri .style-94 {\n  text-align: left;\n  height: auto;\n  min-height: unset;\n}\n\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}i:95;a:3:{s:7:\"desktop\";s:1187:\"#colibri .style-95 .nav-previous a,#colibri .style-95 .nav-next a {\n  font-family: Open Sans;\n  font-weight: 400;\n  text-decoration: none;\n  font-size: 16px;\n  color: rgb(0, 0, 0);\n  border-top-width: 2px;\n  border-top-color: black;\n  border-top-style: none;\n  border-right-width: 2px;\n  border-right-color: black;\n  border-right-style: none;\n  border-bottom-width: 2px;\n  border-bottom-color: black;\n  border-bottom-style: none;\n  border-left-width: 2px;\n  border-left-color: black;\n  border-left-style: none;\n  padding-top: 16px;\n  padding-right: 10px;\n  padding-bottom: 16px;\n  padding-left: 0px;\n  transition-duration: 0.5s;\n}\n#colibri .style-95 .nav-previous a:hover,#colibri .style-95 .nav-next a:hover {\n  color: rgb(2, 110, 159);\n  border-top-color: rgb(0, 0, 0);\n  border-right-color: rgb(0, 0, 0);\n  border-bottom-color: rgb(0, 0, 0);\n  border-left-color: rgb(0, 0, 0);\n}\n#colibri .style-95 .nav-previous a:hover,#colibri .style-95 .nav-next a:hover {\n  color: rgb(2, 110, 159);\n  border-top-color: rgb(0, 0, 0);\n  border-right-color: rgb(0, 0, 0);\n  border-bottom-color: rgb(0, 0, 0);\n  border-left-color: rgb(0, 0, 0);\n}\n#colibri .style-95 .post-title {\n  max-width: 40ch;\n}\n\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}i:96;a:3:{s:7:\"desktop\";s:82:\"#colibri .style-96 {\n  text-align: center;\n  height: auto;\n  min-height: unset;\n}\n\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}i:97;a:3:{s:7:\"desktop\";s:81:\"#colibri .style-97 {\n  text-align: right;\n  height: auto;\n  min-height: unset;\n}\n\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}i:98;a:3:{s:7:\"desktop\";s:931:\"#colibri .style-98 .nav-previous a,#colibri .style-98 .nav-next a {\n  font-family: Open Sans;\n  font-weight: 400;\n  text-decoration: none;\n  font-size: 16px;\n  color: rgb(0, 0, 0);\n  border-top-width: 2px;\n  border-top-color: rgb(0, 0, 0);\n  border-top-style: none;\n  border-right-width: 2px;\n  border-right-color: rgb(0, 0, 0);\n  border-right-style: none;\n  border-bottom-width: 2px;\n  border-bottom-color: rgb(0, 0, 0);\n  border-bottom-style: none;\n  border-left-width: 2px;\n  border-left-color: rgb(0, 0, 0);\n  border-left-style: none;\n  padding-top: 16px;\n  padding-right: 0px;\n  padding-bottom: 16px;\n  padding-left: 10px;\n  transition-duration: 0.5s;\n}\n#colibri .style-98 .nav-previous a:hover,#colibri .style-98 .nav-next a:hover {\n  color: rgb(2, 110, 159);\n}\n#colibri .style-98 .nav-previous a:hover,#colibri .style-98 .nav-next a:hover {\n  color: rgb(2, 110, 159);\n}\n#colibri .style-98 .post-title {\n  max-width: 40ch;\n}\n\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}i:99;a:3:{s:7:\"desktop\";s:66:\"#colibri .style-99 {\n  margin-right: 40px;\n  margin-left: 40px;\n}\n\";s:6:\"tablet\";s:66:\"#colibri .style-99 {\n  margin-right: 20px;\n  margin-left: 20px;\n}\n\";s:6:\"mobile\";s:64:\"#colibri .style-99 {\n  margin-right: 0px;\n  margin-left: 0px;\n}\n\";}i:100;a:3:{s:7:\"desktop\";s:134:\"#colibri .style-100 {\n  text-align: left;\n  height: auto;\n  min-height: unset;\n  background-color: unset;\n  background-image: none;\n}\n\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}i:101;a:3:{s:7:\"desktop\";s:3786:\"#colibri .style-101 .blog-post-comments {\n  background-color: unset;\n  background-image: none;\n}\n#colibri .style-101 .comment.even {\n  background-image: none;\n  padding-top: 0px;\n  padding-right: 12px;\n  padding-bottom: 0px;\n  padding-left: 12px;\n  border-top-width: 0px;\n  border-top-color: rgb(230, 230, 230);\n  border-top-style: solid;\n  border-right-width: 0px;\n  border-right-color: rgb(230, 230, 230);\n  border-right-style: solid;\n  border-bottom-width: 0px;\n  border-bottom-color: rgb(230, 230, 230);\n  border-bottom-style: solid;\n  border-left-width: 5px;\n  border-left-color: rgb(230, 230, 230);\n  border-left-style: solid;\n  margin-top: 15px;\n  margin-bottom: 12px;\n}\n#colibri .style-101 .comment.odd {\n  padding-top: 0px;\n  padding-right: 12px;\n  padding-bottom: 0px;\n  padding-left: 12px;\n  border-top-width: 0px;\n  border-top-color: rgb(230, 230, 230);\n  border-top-style: solid;\n  border-right-width: 0px;\n  border-right-color: rgb(230, 230, 230);\n  border-right-style: solid;\n  border-bottom-width: 0px;\n  border-bottom-color: rgb(230, 230, 230);\n  border-bottom-style: solid;\n  border-left-width: 5px;\n  border-left-color: rgb(230, 230, 230);\n  border-left-style: solid;\n  margin-top: 15px;\n  margin-bottom: 12px;\n}\n#colibri .style-101 .comments-title {\n  font-family: Open Sans;\n  font-weight: 600;\n  text-decoration: none;\n  font-size: 1.25em;\n}\n#colibri .style-101 .comment-meta {\n  color: rgb(102, 102, 102);\n  margin-bottom: 16px;\n}\n#colibri .style-101 .comment-author img {\n  width: 30px ;\n  height: 30px;\n  background-color: unset;\n  background-image: none;\n  margin-right: 5px;\n  border-top-width: 0px;\n  border-top-style: none;\n  border-top-left-radius: 300px;\n  border-top-right-radius: 300px;\n  border-right-width: 0px;\n  border-right-style: none;\n  border-bottom-width: 0px;\n  border-bottom-style: none;\n  border-bottom-left-radius: 300px;\n  border-bottom-right-radius: 300px;\n  border-left-width: 0px;\n  border-left-style: none;\n}\n#colibri .style-101 .comment-author .url {\n  font-family: Montserrat;\n  font-weight: 300;\n  font-style: normal;\n  text-decoration: none;\n  font-size: 14px;\n  color: rgb(51, 51, 51);\n  background-color: unset;\n  background-image: none;\n  margin-left: 5px;\n}\n#colibri .style-101 .comment-metadata {\n  font-family: Montserrat;\n  font-weight: 300;\n  text-decoration: none;\n  font-size: 14px;\n  color: rgb(51, 51, 51);\n  background-color: unset;\n  background-image: none;\n  transition-duration: 0.5s;\n}\n#colibri .style-101 .comment-metadata:hover {\n  color: rgb(2, 110, 159);\n}\n#colibri .style-101 .comment-metadata:hover {\n  color: rgb(2, 110, 159);\n}\n#colibri .style-101 .edit-link {\n  font-family: Montserrat;\n  font-weight: 300;\n  font-size: 14px;\n  color: rgb(51, 51, 51);\n}\n#colibri .style-101 .edit-link:hover {\n  color: rgb(2, 110, 159);\n}\n#colibri .style-101 .edit-link:hover {\n  color: rgb(2, 110, 159);\n}\n#colibri .style-101 .comment-content {\n  text-decoration: none;\n  font-size: 16px;\n  color: rgb(51, 51, 51);\n}\n#colibri .style-101 .comment-content p {\n  color: rgb(51, 51, 51);\n}\n#colibri .style-101 .comment-content a {\n  color: rgb(2, 110, 159);\n}\n#colibri .style-101 .comment-content a:hover {\n  color: rgb(3, 169, 244);\n}\n#colibri .style-101 .comment-body .reply a {\n  margin-bottom: 0px;\n  font-weight: 400;\n  text-transform: lowercase;\n  font-size: 1em;\n  line-height: 1.5;\n  color: rgb(2, 110, 159);\n  background-color: unset;\n  background-image: none;\n}\n#colibri .style-101 .comment-body .reply a:hover {\n  color: rgb(3, 169, 244);\n}\n#colibri .style-101 .comment-body .reply a:hover {\n  color: rgb(3, 169, 244);\n}\n#colibri .style-101 .children {\n  margin-left: 12px;\n}\n#colibri .style-101 .comments-disabled {\n  text-align: center;\n  margin-bottom: 0px;\n  text-decoration: none;\n  color: rgb(51, 51, 51);\n}\n\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}i:102;a:3:{s:7:\"desktop\";s:4030:\"#colibri .comment-respond {\n  border-top-width: 0px;\n  border-top-style: none;\n  border-right-width: 0px;\n  border-right-style: none;\n  border-bottom-width: 0px;\n  border-bottom-style: none;\n  border-left-width: 0px;\n  border-left-style: none;\n}\n#colibri .comment-respond .comment-reply-title {\n  font-family: Montserrat;\n  font-weight: 600;\n  font-size: 1.25em;\n  color: rgb(51, 51, 51);\n}\n#colibri .comment-respond label {\n  font-family: Open Sans;\n  font-weight: 400;\n  font-size: 16px;\n  color: rgb(51, 51, 51);\n  border-top-width: 0px;\n  border-top-style: none;\n  border-right-width: 0px;\n  border-right-style: none;\n  border-bottom-width: 0px;\n  border-bottom-style: none;\n  border-left-width: 0px;\n  border-left-style: none;\n}\n#colibri .comment-respond input:not([type=\"submit\"]),#colibri .comment-respond textarea {\n  border-top-width: 0px;\n  border-top-color: rgba(204, 204, 204, 0.8);\n  border-top-style: solid;\n  border-top-left-radius: 0px;\n  border-top-right-radius: 0px;\n  border-right-width: 0px;\n  border-right-color: rgba(204, 204, 204, 0.8);\n  border-right-style: solid;\n  border-bottom-width: 1px;\n  border-bottom-color: rgba(204, 204, 204, 0.8);\n  border-bottom-style: solid;\n  border-bottom-left-radius: 0px;\n  border-bottom-right-radius: 0px;\n  border-left-width: 0px;\n  border-left-color: rgba(204, 204, 204, 0.8);\n  border-left-style: solid;\n  font-family: Open Sans;\n  font-weight: 300;\n  font-size: 16px;\n  color: rgb(51, 51, 51);\n  background-color: rgba(0,0,0,0);\n  background-image: none;\n  padding-top: 5px;\n  padding-right: 5px;\n  padding-bottom: 5px;\n  padding-left: 5px;\n}\n#colibri .comment-respond .comment-form [type=\"submit\"] {\n  background-color: rgb(3, 169, 244);\n  background-image: none;\n  border-top-width: 2px;\n  border-top-color: rgb(3, 169, 244);\n  border-top-style: solid;\n  border-top-left-radius: 4px;\n  border-top-right-radius: 4px;\n  border-right-width: 2px;\n  border-right-color: rgb(3, 169, 244);\n  border-right-style: solid;\n  border-bottom-width: 2px;\n  border-bottom-color: rgb(3, 169, 244);\n  border-bottom-style: solid;\n  border-bottom-left-radius: 4px;\n  border-bottom-right-radius: 4px;\n  border-left-width: 2px;\n  border-left-color: rgb(3, 169, 244);\n  border-left-style: solid;\n  padding-top: 12px;\n  padding-right: 24px;\n  padding-bottom: 12px;\n  padding-left: 24px;\n  font-family: Open Sans;\n  font-weight: 600;\n  text-transform: uppercase;\n  font-size: 12px;\n  line-height: 1;\n  letter-spacing: 1px;\n  color: #FFFFFF;\n}\n#colibri .comment-respond .comment-form [type=\"submit\"]:hover {\n  background-color: rgb(2, 110, 159);\n  border-top-color: rgb(2, 110, 159);\n  border-right-color: rgb(2, 110, 159);\n  border-bottom-color: rgb(2, 110, 159);\n  border-left-color: rgb(2, 110, 159);\n}\n#colibri .comment-respond .comment-form [type=\"submit\"]:hover {\n  background-color: rgb(2, 110, 159);\n  border-top-color: rgb(2, 110, 159);\n  border-right-color: rgb(2, 110, 159);\n  border-bottom-color: rgb(2, 110, 159);\n  border-left-color: rgb(2, 110, 159);\n}\n#colibri .comment-respond .comment-form [type=\"submit\"]:active {\n  background-color: rgb(3, 169, 244);\n  background-image: none;\n  border-top-width: 2px;\n  border-top-color: rgb(3, 169, 244);\n  border-top-style: solid;\n  border-top-left-radius: 4px;\n  border-top-right-radius: 4px;\n  border-right-width: 2px;\n  border-right-color: rgb(3, 169, 244);\n  border-right-style: solid;\n  border-bottom-width: 2px;\n  border-bottom-color: rgb(3, 169, 244);\n  border-bottom-style: solid;\n  border-bottom-left-radius: 4px;\n  border-bottom-right-radius: 4px;\n  border-left-width: 2px;\n  border-left-color: rgb(3, 169, 244);\n  border-left-style: solid;\n  padding-top: 12px;\n  padding-right: 24px;\n  padding-bottom: 12px;\n  padding-left: 24px;\n  font-family: Open Sans;\n  font-weight: 600;\n  text-transform: uppercase;\n  font-size: 12px;\n  line-height: 1;\n  letter-spacing: 1px;\n  color: #FFFFFF;\n}\n#colibri .comment-respond .comment-notes {\n  font-family: Open Sans;\n  font-weight: 400;\n  font-size: 14px;\n  color: rgb(102, 102, 102);\n}\n\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}i:103;a:3:{s:7:\"desktop\";s:46:\"#colibri .style-103 {\n  margin-top: -120px;\n}\n\";s:6:\"tablet\";s:45:\"#colibri .style-103 {\n  margin-top: -95px;\n}\n\";s:6:\"mobile\";s:0:\"\";}i:104;a:3:{s:7:\"desktop\";s:104:\"#colibri .style-104 {\n  height: auto;\n  min-height: unset;\n  padding-top: 0px;\n  padding-bottom: 0px;\n}\n\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}i:105;a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}i:106;a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}i:107;a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}i:108;a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}i:109;a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}i:110;a:3:{s:7:\"desktop\";s:869:\"#colibri .style-110 {\n  text-align: center;\n  height: auto;\n  min-height: unset;\n  background-position: center center;\n  background-size: cover;\n  background-image: linear-gradient(145deg,  #FFFFFF 42%, rgb(239, 239, 239) 100%);\n  background-attachment: scroll;\n  background-repeat: no-repeat;\n  border-top-width: 0px;\n  border-top-color: rgb(246, 246, 246);\n  border-top-style: none;\n  border-top-left-radius: 40px;\n  border-top-right-radius: 40px;\n  border-right-width: 0px;\n  border-right-color: rgb(246, 246, 246);\n  border-right-style: none;\n  border-bottom-width: 5px;\n  border-bottom-color: rgb(246, 246, 246);\n  border-bottom-style: none;\n  border-bottom-left-radius: 40px;\n  border-bottom-right-radius: 40px;\n  border-left-width: 0px;\n  border-left-color: rgb(246, 246, 246);\n  border-left-style: none;\n  box-shadow: 20px 20px 60px 2px rgba(0, 0, 0, 0.15) ;\n}\n\";s:6:\"tablet\";s:160:\"#colibri .style-110 {\n  border-top-left-radius: 20px;\n  border-top-right-radius: 20px;\n  border-bottom-left-radius: 20px;\n  border-bottom-right-radius: 20px;\n}\n\";s:6:\"mobile\";s:160:\"#colibri .style-110 {\n  border-top-left-radius: 20px;\n  border-top-right-radius: 20px;\n  border-bottom-left-radius: 20px;\n  border-bottom-right-radius: 20px;\n}\n\";}i:111;a:3:{s:7:\"desktop\";s:269:\"#colibri .style-111 {\n  background-color: rgba(255,255,255,0);\n  background-image: none;\n  text-align: center;\n  margin-bottom: 0px;\n}\n#colibri .style-111 .colibri-post-thumbnail-shortcode img {\n  height: 300px;\n  object-position: center center;\n  object-fit: cover;\n}\n\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}i:112;a:3:{s:7:\"desktop\";s:47:\"#colibri .style-112 {\n  padding-bottom: 5px;\n}\n\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}i:113;a:3:{s:7:\"desktop\";s:350:\"#colibri .style-113 {\n  text-align: left;\n  height: auto;\n  min-height: unset;\n  border-top-width: 0px;\n  border-top-style: none;\n  border-right-width: 0px;\n  border-right-style: none;\n  border-bottom-width: 0px;\n  border-bottom-style: none;\n  border-left-width: 0px;\n  border-left-style: none;\n  background-color: unset;\n  background-image: none;\n}\n\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:46:\"#colibri .style-113 {\n  text-align: center;\n}\n\";}i:114;a:3:{s:7:\"desktop\";s:589:\"#colibri .style-114 h1,#colibri .style-114  h2,#colibri .style-114  h3,#colibri .style-114  h4,#colibri .style-114  h5,#colibri .style-114  h6 {\n  margin-bottom: 0px;\n}\n#colibri .style-114 h1:hover,#colibri .style-114  h2:hover,#colibri .style-114  h3:hover,#colibri .style-114  h4:hover,#colibri .style-114  h5:hover,#colibri .style-114  h6:hover {\n  color: rgb(2, 110, 159);\n}\n#colibri .style-114 h1:hover,#colibri .style-114  h2:hover,#colibri .style-114  h3:hover,#colibri .style-114  h4:hover,#colibri .style-114  h5:hover,#colibri .style-114  h6:hover {\n  color: rgb(2, 110, 159);\n}\n\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}i:115;a:3:{s:7:\"desktop\";s:75:\"#colibri .style-115 .colibri-post-excerpt {\n  color: rgb(102, 102, 102);\n}\n\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}i:116;a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}i:117;a:3:{s:7:\"desktop\";s:81:\"#colibri .style-117 {\n  text-align: left;\n  height: auto;\n  min-height: unset;\n}\n\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}i:118;a:3:{s:7:\"desktop\";s:544:\"#colibri .style-118 a {\n  font-family: Open Sans;\n  font-weight: 400;\n  font-size: 14px;\n  color: rgb(102, 102, 102);\n}\n#colibri .style-118 a:hover {\n  color: rgb(0, 0, 0);\n}\n#colibri .style-118 a:hover {\n  color: rgb(0, 0, 0);\n}\n#colibri .style-118 .metadata-prefix {\n  font-size: 14px;\n  color: rgb(102, 102, 102);\n}\n#colibri .style-118 svg {\n  width: 20px ;\n  height: 20px;\n  margin-right: 5px;\n  display: none;\n}\n#colibri .style-118 .meta-separator {\n  font-size: 14px;\n  line-height: 1.6;\n  color: rgb(51, 51, 51);\n  padding-right: 5px;\n}\n\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}i:119;a:3:{s:7:\"desktop\";s:83:\"#colibri .style-119 {\n  text-align: center;\n  height: auto;\n  min-height: unset;\n}\n\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}i:120;a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}i:121;a:3:{s:7:\"desktop\";s:808:\"#colibri .style-121-icon {\n  margin-right: 0px;\n  margin-left: 3px;\n  width: 11px;\n  height: 11px;\n}\n#colibri .style-121 {\n  border-top-width: 2px;\n  border-top-style: none;\n  border-top-left-radius: 0px;\n  border-top-right-radius: 0px;\n  border-right-width: 2px;\n  border-right-style: none;\n  border-bottom-width: 2px;\n  border-bottom-style: none;\n  border-bottom-left-radius: 0px;\n  border-bottom-right-radius: 0px;\n  border-left-width: 2px;\n  border-left-style: none;\n  text-align: center;\n  font-family: Open Sans;\n  font-weight: 400;\n  font-size: 14px;\n  color: rgb(51, 51, 51);\n}\n#colibri .style-121:hover,#colibri .style-121:focus {\n  color: rgb(2, 110, 159);\n  box-shadow: none;\n}\n#colibri .style-121:active .style-121-icon {\n  margin-right: 0px;\n  margin-left: 3px;\n  width: 11px;\n  height: 11px;\n}\n\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}i:122;a:3:{s:7:\"desktop\";s:303:\"#colibri .style-122 {\n  border-top-width: 0px;\n  border-top-style: none;\n  border-right-width: 0px;\n  border-right-style: none;\n  border-bottom-width: 0px;\n  border-bottom-style: none;\n  border-left-width: 0px;\n  border-left-style: none;\n  margin-top: 45px;\n  margin-right: 30px;\n  margin-left: 30px;\n}\n\";s:6:\"tablet\";s:87:\"#colibri .style-122 {\n  margin-top: 30px;\n  margin-right: 10px;\n  margin-left: 10px;\n}\n\";s:6:\"mobile\";s:87:\"#colibri .style-122 {\n  margin-top: 15px;\n  margin-right: 15px;\n  margin-left: 15px;\n}\n\";}i:123;a:3:{s:7:\"desktop\";s:81:\"#colibri .style-123 {\n  text-align: left;\n  height: auto;\n  min-height: unset;\n}\n\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}i:124;a:3:{s:7:\"desktop\";s:1318:\"#colibri .style-124 .nav-links .prev-navigation a,#colibri .style-124 .nav-links .next-navigation a {\n  font-family: Open Sans;\n  font-weight: 400;\n  text-decoration: none;\n  font-size: 16px;\n  line-height: 1.6;\n  color: rgb(0, 0, 0);\n  border-top-width: 2px;\n  border-top-color: black;\n  border-top-style: none;\n  border-top-left-radius: 0px;\n  border-top-right-radius: 0px;\n  border-right-width: 2px;\n  border-right-color: black;\n  border-right-style: none;\n  border-bottom-width: 2px;\n  border-bottom-color: black;\n  border-bottom-style: none;\n  border-bottom-left-radius: 0px;\n  border-bottom-right-radius: 0px;\n  border-left-width: 2px;\n  border-left-color: black;\n  border-left-style: none;\n  padding-top: 16px;\n  padding-right: 10px;\n  padding-bottom: 16px;\n  padding-left: 0px;\n}\n#colibri .style-124 .nav-links .prev-navigation a:hover,#colibri .style-124 .nav-links .next-navigation a:hover {\n  color: rgb(2, 110, 159);\n  border-top-color: #FFFFFF;\n  border-right-color: #FFFFFF;\n  border-bottom-color: #FFFFFF;\n  border-left-color: #FFFFFF;\n}\n#colibri .style-124 .nav-links .prev-navigation a:hover,#colibri .style-124 .nav-links .next-navigation a:hover {\n  color: rgb(2, 110, 159);\n  border-top-color: #FFFFFF;\n  border-right-color: #FFFFFF;\n  border-bottom-color: #FFFFFF;\n  border-left-color: #FFFFFF;\n}\n\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}i:125;a:3:{s:7:\"desktop\";s:83:\"#colibri .style-125 {\n  text-align: center;\n  height: auto;\n  min-height: unset;\n}\n\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}i:126;a:3:{s:7:\"desktop\";s:323:\"#colibri .style-126 .page-numbers.current {\n  margin-right: 10px;\n  color: rgb(2, 110, 159);\n}\n#colibri .style-126 .page-numbers {\n  margin-right: 10px;\n  color: rgb(51, 51, 51);\n}\n#colibri .style-126 .page-numbers:hover {\n  color: rgb(2, 110, 159);\n}\n#colibri .style-126 .page-numbers:hover {\n  color: rgb(2, 110, 159);\n}\n\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}i:127;a:3:{s:7:\"desktop\";s:82:\"#colibri .style-127 {\n  text-align: right;\n  height: auto;\n  min-height: unset;\n}\n\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}i:128;a:3:{s:7:\"desktop\";s:1318:\"#colibri .style-128 .nav-links .prev-navigation a,#colibri .style-128 .nav-links .next-navigation a {\n  font-family: Open Sans;\n  font-weight: 400;\n  text-decoration: none;\n  font-size: 16px;\n  line-height: 1.6;\n  color: rgb(0, 0, 0);\n  border-top-width: 2px;\n  border-top-color: black;\n  border-top-style: none;\n  border-top-left-radius: 0px;\n  border-top-right-radius: 0px;\n  border-right-width: 2px;\n  border-right-color: black;\n  border-right-style: none;\n  border-bottom-width: 2px;\n  border-bottom-color: black;\n  border-bottom-style: none;\n  border-bottom-left-radius: 0px;\n  border-bottom-right-radius: 0px;\n  border-left-width: 2px;\n  border-left-color: black;\n  border-left-style: none;\n  padding-top: 16px;\n  padding-right: 0px;\n  padding-bottom: 16px;\n  padding-left: 10px;\n}\n#colibri .style-128 .nav-links .prev-navigation a:hover,#colibri .style-128 .nav-links .next-navigation a:hover {\n  color: rgb(2, 110, 159);\n  border-top-color: #FFFFFF;\n  border-right-color: #FFFFFF;\n  border-bottom-color: #FFFFFF;\n  border-left-color: #FFFFFF;\n}\n#colibri .style-128 .nav-links .prev-navigation a:hover,#colibri .style-128 .nav-links .next-navigation a:hover {\n  color: rgb(2, 110, 159);\n  border-top-color: #FFFFFF;\n  border-right-color: #FFFFFF;\n  border-bottom-color: #FFFFFF;\n  border-left-color: #FFFFFF;\n}\n\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}i:129;a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}i:130;a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}i:131;a:3:{s:7:\"desktop\";s:83:\"#colibri .style-131 {\n  text-align: center;\n  height: auto;\n  min-height: unset;\n}\n\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}i:132;a:3:{s:7:\"desktop\";s:363:\"#colibri .style-132 p,#colibri .style-132  h1,#colibri .style-132  h2,#colibri .style-132  h3,#colibri .style-132  h4,#colibri .style-132  h5,#colibri .style-132  h6 {\n  font-size: 10em;\n  color: rgb(51, 51, 51);\n}\n#colibri .style-132 .text-wrapper-fancy svg path {\n  stroke: #000000;\n  stroke-linejoin: initial;\n  stroke-linecap: initial;\n  stroke-width: 8px;\n}\n\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}i:133;a:3:{s:7:\"desktop\";s:107:\"#colibri .style-133 ol {\n  list-style-type: decimal;\n}\n#colibri .style-133 ul {\n  list-style-type: disc;\n}\n\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}i:134;a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}i:135;a:3:{s:7:\"desktop\";s:1345:\"#colibri .style-135-icon {\n  width: 16px;\n  height: 16px;\n  margin-right: 0px;\n  margin-left: 10px;\n}\n#colibri .style-135 {\n  background-color: rgba(3, 169, 244, 0);\n  background-image: none;\n  font-family: Open Sans;\n  font-weight: 400;\n  text-transform: none;\n  font-size: 16px;\n  line-height: 1.5em;\n  letter-spacing: 1px;\n  color: rgb(3, 169, 244);\n  border-top-width: 2px;\n  border-top-color: rgb(3, 169, 244);\n  border-top-style: none;\n  border-top-left-radius: 5px;\n  border-top-right-radius: 5px;\n  border-right-width: 2px;\n  border-right-color: rgb(3, 169, 244);\n  border-right-style: none;\n  border-bottom-width: 2px;\n  border-bottom-color: rgb(3, 169, 244);\n  border-bottom-style: none;\n  border-bottom-left-radius: 5px;\n  border-bottom-right-radius: 5px;\n  border-left-width: 2px;\n  border-left-color: rgb(3, 169, 244);\n  border-left-style: none;\n  padding-top: 0px;\n  padding-right: 0px;\n  padding-bottom: 0px;\n  padding-left: 0px;\n  text-align: center;\n}\n#colibri .style-135:hover,#colibri .style-135:focus {\n  background-color: rgba(2, 110, 159, 0);\n  border-top-color: rgb(2, 110, 159);\n  border-right-color: rgb(2, 110, 159);\n  border-bottom-color: rgb(2, 110, 159);\n  border-left-color: rgb(2, 110, 159);\n}\n#colibri .style-135:active .style-135-icon {\n  width: 16px;\n  height: 16px;\n  margin-right: 0px;\n  margin-left: 10px;\n}\n\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}i:136;a:3:{s:7:\"desktop\";s:46:\"#colibri .style-136 {\n  margin-top: -120px;\n}\n\";s:6:\"tablet\";s:45:\"#colibri .style-136 {\n  margin-top: -95px;\n}\n\";s:6:\"mobile\";s:0:\"\";}i:137;a:3:{s:7:\"desktop\";s:67:\"#colibri .style-137 {\n  padding-top: 0px;\n  padding-bottom: 0px;\n}\n\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}i:138;a:3:{s:7:\"desktop\";s:890:\"#colibri .style-138 {\n  text-align: left;\n  height: auto;\n  min-height: unset;\n  background-position: center center;\n  background-size: cover;\n  background-image: linear-gradient(162deg,  #FFFFFF 0%, rgb(239, 239, 239) 100%);\n  background-attachment: scroll;\n  background-repeat: no-repeat;\n  box-shadow: 20px 20px 60px 2px rgba(0, 0, 0, 0.15) ;\n  border-top-width: 0px;\n  border-top-color: rgb(246, 246, 246);\n  border-top-style: none;\n  border-top-left-radius: 40px;\n  border-top-right-radius: 40px;\n  border-right-width: 0px;\n  border-right-color: rgb(246, 246, 246);\n  border-right-style: none;\n  border-bottom-width: 5px;\n  border-bottom-color: rgb(246, 246, 246);\n  border-bottom-style: none;\n  border-bottom-left-radius: 40px;\n  border-bottom-right-radius: 40px;\n  border-left-width: 0px;\n  border-left-color: rgb(246, 246, 246);\n  border-left-style: none;\n  padding-bottom: 20px;\n}\n\";s:6:\"tablet\";s:160:\"#colibri .style-138 {\n  border-top-left-radius: 20px;\n  border-top-right-radius: 20px;\n  border-bottom-left-radius: 20px;\n  border-bottom-right-radius: 20px;\n}\n\";s:6:\"mobile\";s:184:\"#colibri .style-138 {\n  border-top-left-radius: 20px;\n  border-top-right-radius: 20px;\n  border-bottom-left-radius: 20px;\n  border-bottom-right-radius: 20px;\n  padding-bottom: 15px;\n}\n\";}i:139;a:3:{s:7:\"desktop\";s:589:\"#colibri .style-139 h1,#colibri .style-139  h2,#colibri .style-139  h3,#colibri .style-139  h4,#colibri .style-139  h5,#colibri .style-139  h6 {\n  margin-bottom: 0px;\n}\n#colibri .style-139 h1:hover,#colibri .style-139  h2:hover,#colibri .style-139  h3:hover,#colibri .style-139  h4:hover,#colibri .style-139  h5:hover,#colibri .style-139  h6:hover {\n  color: rgb(2, 110, 159);\n}\n#colibri .style-139 h1:hover,#colibri .style-139  h2:hover,#colibri .style-139  h3:hover,#colibri .style-139  h4:hover,#colibri .style-139  h5:hover,#colibri .style-139  h6:hover {\n  color: rgb(2, 110, 159);\n}\n\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}i:140;a:3:{s:7:\"desktop\";s:140:\"#colibri .style-140 .colibri-post-excerpt {\n  font-family: Open Sans;\n  font-weight: 400;\n  font-size: 16px;\n  color: rgb(102, 102, 102);\n}\n\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}i:141;a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}i:142;a:3:{s:7:\"desktop\";s:81:\"#colibri .style-142 {\n  text-align: left;\n  height: auto;\n  min-height: unset;\n}\n\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}i:143;a:3:{s:7:\"desktop\";s:544:\"#colibri .style-143 a {\n  font-family: Open Sans;\n  font-weight: 400;\n  font-size: 14px;\n  color: rgb(102, 102, 102);\n}\n#colibri .style-143 a:hover {\n  color: rgb(0, 0, 0);\n}\n#colibri .style-143 a:hover {\n  color: rgb(0, 0, 0);\n}\n#colibri .style-143 .metadata-prefix {\n  font-size: 14px;\n  color: rgb(102, 102, 102);\n}\n#colibri .style-143 svg {\n  width: 20px ;\n  height: 20px;\n  margin-right: 5px;\n  display: none;\n}\n#colibri .style-143 .meta-separator {\n  font-size: 14px;\n  line-height: 1.6;\n  color: rgb(51, 51, 51);\n  padding-right: 5px;\n}\n\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}i:144;a:3:{s:7:\"desktop\";s:83:\"#colibri .style-144 {\n  text-align: center;\n  height: auto;\n  min-height: unset;\n}\n\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}i:145;a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}i:146;a:3:{s:7:\"desktop\";s:808:\"#colibri .style-146-icon {\n  margin-right: 0px;\n  margin-left: 3px;\n  width: 11px;\n  height: 11px;\n}\n#colibri .style-146 {\n  border-top-width: 2px;\n  border-top-style: none;\n  border-top-left-radius: 0px;\n  border-top-right-radius: 0px;\n  border-right-width: 2px;\n  border-right-style: none;\n  border-bottom-width: 2px;\n  border-bottom-style: none;\n  border-bottom-left-radius: 0px;\n  border-bottom-right-radius: 0px;\n  border-left-width: 2px;\n  border-left-style: none;\n  text-align: center;\n  font-family: Open Sans;\n  font-weight: 400;\n  font-size: 14px;\n  color: rgb(51, 51, 51);\n}\n#colibri .style-146:hover,#colibri .style-146:focus {\n  color: rgb(2, 110, 159);\n  box-shadow: none;\n}\n#colibri .style-146:active .style-146-icon {\n  margin-right: 0px;\n  margin-left: 3px;\n  width: 11px;\n  height: 11px;\n}\n\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}i:147;a:3:{s:7:\"desktop\";s:87:\"#colibri .style-147 {\n  margin-top: 45px;\n  margin-right: 15px;\n  margin-left: 15px;\n}\n\";s:6:\"tablet\";s:87:\"#colibri .style-147 {\n  margin-top: 30px;\n  margin-right: 10px;\n  margin-left: 10px;\n}\n\";s:6:\"mobile\";s:44:\"#colibri .style-147 {\n  margin-top: 15px;\n}\n\";}i:148;a:3:{s:7:\"desktop\";s:81:\"#colibri .style-148 {\n  text-align: left;\n  height: auto;\n  min-height: unset;\n}\n\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}i:149;a:3:{s:7:\"desktop\";s:1318:\"#colibri .style-149 .nav-links .prev-navigation a,#colibri .style-149 .nav-links .next-navigation a {\n  font-family: Open Sans;\n  font-weight: 400;\n  text-decoration: none;\n  font-size: 16px;\n  line-height: 1.6;\n  color: rgb(0, 0, 0);\n  border-top-width: 2px;\n  border-top-color: black;\n  border-top-style: none;\n  border-top-left-radius: 0px;\n  border-top-right-radius: 0px;\n  border-right-width: 2px;\n  border-right-color: black;\n  border-right-style: none;\n  border-bottom-width: 2px;\n  border-bottom-color: black;\n  border-bottom-style: none;\n  border-bottom-left-radius: 0px;\n  border-bottom-right-radius: 0px;\n  border-left-width: 2px;\n  border-left-color: black;\n  border-left-style: none;\n  padding-top: 16px;\n  padding-right: 10px;\n  padding-bottom: 16px;\n  padding-left: 0px;\n}\n#colibri .style-149 .nav-links .prev-navigation a:hover,#colibri .style-149 .nav-links .next-navigation a:hover {\n  color: rgb(2, 110, 159);\n  border-top-color: #FFFFFF;\n  border-right-color: #FFFFFF;\n  border-bottom-color: #FFFFFF;\n  border-left-color: #FFFFFF;\n}\n#colibri .style-149 .nav-links .prev-navigation a:hover,#colibri .style-149 .nav-links .next-navigation a:hover {\n  color: rgb(2, 110, 159);\n  border-top-color: #FFFFFF;\n  border-right-color: #FFFFFF;\n  border-bottom-color: #FFFFFF;\n  border-left-color: #FFFFFF;\n}\n\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}i:150;a:3:{s:7:\"desktop\";s:83:\"#colibri .style-150 {\n  text-align: center;\n  height: auto;\n  min-height: unset;\n}\n\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}i:151;a:3:{s:7:\"desktop\";s:398:\"#colibri .style-151 .page-numbers.current {\n  margin-right: 10px;\n  font-size: 16px;\n  line-height: 1.6;\n  color: rgb(2, 110, 159);\n}\n#colibri .style-151 .page-numbers {\n  margin-right: 10px;\n  font-size: 16px;\n  line-height: 1.6;\n  color: rgb(0, 0, 0);\n}\n#colibri .style-151 .page-numbers:hover {\n  color: rgb(2, 110, 159);\n}\n#colibri .style-151 .page-numbers:hover {\n  color: rgb(2, 110, 159);\n}\n\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}i:152;a:3:{s:7:\"desktop\";s:83:\"#colibri .style-152 {\n  text-align: center;\n  height: auto;\n  min-height: unset;\n}\n\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}i:153;a:3:{s:7:\"desktop\";s:1318:\"#colibri .style-153 .nav-links .prev-navigation a,#colibri .style-153 .nav-links .next-navigation a {\n  font-family: Open Sans;\n  font-weight: 400;\n  text-decoration: none;\n  font-size: 16px;\n  line-height: 1.6;\n  color: rgb(0, 0, 0);\n  border-top-width: 2px;\n  border-top-color: black;\n  border-top-style: none;\n  border-top-left-radius: 0px;\n  border-top-right-radius: 0px;\n  border-right-width: 2px;\n  border-right-color: black;\n  border-right-style: none;\n  border-bottom-width: 2px;\n  border-bottom-color: black;\n  border-bottom-style: none;\n  border-bottom-left-radius: 0px;\n  border-bottom-right-radius: 0px;\n  border-left-width: 2px;\n  border-left-color: black;\n  border-left-style: none;\n  padding-top: 16px;\n  padding-right: 0px;\n  padding-bottom: 16px;\n  padding-left: 10px;\n}\n#colibri .style-153 .nav-links .prev-navigation a:hover,#colibri .style-153 .nav-links .next-navigation a:hover {\n  color: rgb(2, 110, 159);\n  border-top-color: #FFFFFF;\n  border-right-color: #FFFFFF;\n  border-bottom-color: #FFFFFF;\n  border-left-color: #FFFFFF;\n}\n#colibri .style-153 .nav-links .prev-navigation a:hover,#colibri .style-153 .nav-links .next-navigation a:hover {\n  color: rgb(2, 110, 159);\n  border-top-color: #FFFFFF;\n  border-right-color: #FFFFFF;\n  border-bottom-color: #FFFFFF;\n  border-left-color: #FFFFFF;\n}\n\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}i:154;a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}i:155;a:3:{s:7:\"desktop\";s:83:\"#colibri .style-155 {\n  text-align: center;\n  height: auto;\n  min-height: unset;\n}\n\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}i:156;a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}i:157;a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}i:158;a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}i:159;a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}i:160;a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}i:161;a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}i:162;a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}i:163;a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}i:164;a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}i:165;a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}i:166;a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}i:167;a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}i:168;a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}i:169;a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}i:170;a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}i:171;a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}i:172;a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}i:173;a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}i:174;a:3:{s:7:\"desktop\";s:104:\"#colibri .style-174 {\n  height: auto;\n  min-height: unset;\n  padding-top: 0px;\n  padding-bottom: 0px;\n}\n\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}i:175;a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}i:176;a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}i:177;a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}i:178;a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}i:179;a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}i:180;a:3:{s:7:\"desktop\";s:83:\"#colibri .style-180 {\n  text-align: center;\n  height: auto;\n  min-height: unset;\n}\n\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}i:181;a:3:{s:7:\"desktop\";s:2366:\"#colibri .style-181 {\n  border-top-width: 0px;\n  border-top-style: none;\n  border-right-width: 0px;\n  border-right-style: none;\n  border-bottom-width: 0px;\n  border-bottom-style: none;\n  border-left-width: 0px;\n  border-left-style: none;\n}\n#colibri .style-181 .widget {\n  text-align: left;\n  border-top-width: 0px;\n  border-top-style: none;\n  border-right-width: 0px;\n  border-right-style: none;\n  border-bottom-width: 0px;\n  border-bottom-style: none;\n  border-left-width: 0px;\n  border-left-style: none;\n  margin-bottom: 20px;\n}\n#colibri .style-181 .widget h1,#colibri .style-181 .widget h2,#colibri .style-181 .widget h3,#colibri .style-181 .widget h4,#colibri .style-181 .widget h5,#colibri .style-181 .widget h6 {\n  font-family: Open Sans;\n  font-weight: 600;\n  font-size: 16px;\n  line-height: 1.6;\n  color: rgb(0, 0, 0);\n  border-top-width: 0px;\n  border-top-style: none;\n  border-right-width: 0px;\n  border-right-style: none;\n  border-bottom-width: 0px;\n  border-bottom-style: none;\n  border-left-width: 0px;\n  border-left-style: none;\n  margin-bottom: 10px;\n}\n#colibri .style-181 .widget ul,#colibri .style-181 .widget ol {\n  list-style-type: none;\n}\n#colibri .style-181 .widget ul li,#colibri .style-181 .widget ol li,#colibri .style-181 .widget  .textwidget p,#colibri .style-181 .widget  .calendar_wrap td ,#colibri .style-181  .widget  .calendar_wrap th ,#colibri .style-181  .widget  .calendar_wrap caption {\n  font-family: Open Sans;\n  font-weight: 400;\n  text-decoration: none;\n  font-size: 14px;\n  color: rgb(102, 102, 102);\n  padding-top: 4px;\n  padding-bottom: 4px;\n}\n#colibri .style-181 .widget ul li a {\n  font-family: Open Sans;\n  font-weight: 400;\n  text-decoration: none;\n  font-size: 14px;\n  color: rgb(102, 102, 102);\n}\n#colibri .style-181 .widget ul li a:hover {\n  color: rgb(0, 0, 0);\n}\n#colibri .style-181 .widget ul li a:hover {\n  color: rgb(0, 0, 0);\n}\n#colibri .style-181 .widget input:not([type=\"submit\"]) {\n  font-family: Open Sans;\n  font-weight: 400;\n  font-size: 16px;\n  color: rgb(102, 102, 102);\n  border-top-width: 0px;\n  border-top-color: black;\n  border-top-style: none;\n  border-right-width: 0px;\n  border-right-color: black;\n  border-right-style: none;\n  border-bottom-width: 0px;\n  border-bottom-color: black;\n  border-bottom-style: none;\n  border-left-width: 0px;\n  border-left-color: black;\n  border-left-style: none;\n}\n\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:54:\"#colibri .style-181 .widget {\n  text-align: center;\n}\n\";}i:182;a:3:{s:7:\"desktop\";s:3609:\"#colibri .style-181 .widget.widget_search {\n  background-color: unset;\n  background-image: none;\n  border-top-width: 1px;\n  border-top-color: rgb(238, 238, 238);\n  border-top-style: solid;\n  border-top-left-radius: 5px;\n  border-top-right-radius: 5px;\n  border-right-width: 1px;\n  border-right-color: rgb(238, 238, 238);\n  border-right-style: solid;\n  border-bottom-width: 1px;\n  border-bottom-color: rgb(238, 238, 238);\n  border-bottom-style: solid;\n  border-bottom-left-radius: 5px;\n  border-bottom-right-radius: 5px;\n  border-left-width: 1px;\n  border-left-color: rgb(238, 238, 238);\n  border-left-style: solid;\n  padding-top: 0px;\n  padding-right: 0px;\n  padding-bottom: 0px;\n  padding-left: 0px;\n  margin-bottom: 15px;\n}\n#colibri .style-181 .widget.widget_search h1,#colibri .style-181 .widget.widget_search h2,#colibri .style-181 .widget.widget_search h3,#colibri .style-181 .widget.widget_search h4,#colibri .style-181 .widget.widget_search h5,#colibri .style-181 .widget.widget_search h6 {\n  border-top-width: 0px;\n  border-top-style: none;\n  border-right-width: 0px;\n  border-right-style: none;\n  border-bottom-width: 0px;\n  border-bottom-style: none;\n  border-left-width: 0px;\n  border-left-style: none;\n  font-size: 16px;\n  color: rgb(0, 0, 0);\n}\n#colibri .style-181 .widget.widget_search input:not([type=\"submit\"]) {\n  padding-top: 10px;\n  padding-right: 12px;\n  padding-bottom: 10px;\n  padding-left: 12px;\n  font-size: 16px;\n  color: rgb(102, 102, 102);\n  background-color: rgb(249, 250, 251);\n  background-image: none;\n  border-top-width: 0px;\n  border-top-color: rgb(222, 222, 222);\n  border-top-style: none;\n  border-top-left-radius: 5px;\n  border-top-right-radius: 0px;\n  border-right-width: 0px;\n  border-right-color: rgb(222, 222, 222);\n  border-right-style: none;\n  border-bottom-width: 0px;\n  border-bottom-color: rgb(222, 222, 222);\n  border-bottom-style: none;\n  border-bottom-left-radius: 5px;\n  border-bottom-right-radius: 0px;\n  border-left-width: 0px;\n  border-left-color: rgb(222, 222, 222);\n  border-left-style: none;\n  margin-top: 0px;\n  margin-right: 0px;\n  margin-bottom: 0px;\n  margin-left: 0px;\n}\n#colibri .style-181 .widget.widget_search input:not([type=\"submit\"])::placeholder {\n  color: rgb(102, 102, 102);\n}\n#colibri .style-181 .widget.widget_search input[type=\"submit\"],#colibri .style-181 .widget.widget_search button[type=\"submit\"] {\n  background-color: rgb(249, 250, 251);\n  background-image: none;\n  font-size: 16px;\n  line-height: 1;\n  color: rgb(0, 0, 0);\n  border-top-width: 0px;\n  border-top-style: none;\n  border-top-left-radius: 0px;\n  border-top-right-radius: 5px;\n  border-right-width: 0px;\n  border-right-style: none;\n  border-bottom-width: 0px;\n  border-bottom-style: none;\n  border-bottom-left-radius: 0px;\n  border-bottom-right-radius: 5px;\n  border-left-width: 0px;\n  border-left-style: none;\n  width: auto;\n  padding-top: 10px;\n  padding-right: 12px;\n  padding-bottom: 10px;\n  padding-left: 12px;\n  margin-top: 0px;\n  margin-right: 0px;\n  margin-bottom: 0px;\n  margin-left: 0px;\n  transition-duration: 0.5s;\n  display: inline-block;\n}\n#colibri .style-181 .widget.widget_search input[type=\"submit\"]:hover,#colibri .style-181 .widget.widget_search button[type=\"submit\"]:hover {\n  color: rgb(3, 169, 244);\n}\n#colibri .style-181 .widget.widget_search input[type=\"submit\"]:hover,#colibri .style-181 .widget.widget_search button[type=\"submit\"]:hover {\n  color: rgb(3, 169, 244);\n}\n#colibri .style-181 .widget.widget_search input[type=\"submit\"] {\n  display: none;\n}\n#colibri .style-181 .widget.widget_search button[type=\"submit\"] {\n  display: inline-block;\n}\n\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}i:183;a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}i:184;a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}i:185;a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}i:186;a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}i:187;a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}i:188;a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}i:189;a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}i:190;a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}i:191;a:3:{s:7:\"desktop\";s:178:\"#colibri .style-191 {\n  height: auto;\n  min-height: unset;\n  padding-top: 0px;\n  padding-bottom: 0px;\n}\n#colibri .style-191  > .h-section-grid-container {\n  margin-top: -50px;\n}\n\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:43:\"#colibri .style-191 {\n  margin-top: 0px;\n}\n\";}i:192;a:3:{s:7:\"desktop\";s:525:\"#colibri .style-192 {\n  box-shadow: 0px 4px 10px 2px rgba(74, 74, 74, 0.3) ;\n  background-color: #FFFFFF;\n  background-position: 47.23611068725586% 78.30555725097656%;\n  background-size: cover;\n  background-image: url(\"http://localhost/wordpress/wp-content/uploads/2024/11/DALL·E-2024-11-02-22.47.45-A-realistic-professional-image-depicting-a-key-handover-for-a-home.-Show-a-persons-hand-offering-a-key-with-a-small-house-shaped-keychain-to-another.webp\");\n  background-attachment: scroll;\n  background-repeat: no-repeat;\n}\n\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:110:\"#colibri .style-192 {\n  margin-top: 15px;\n  margin-right: 15px;\n  margin-bottom: 15px;\n  margin-left: 15px;\n}\n\";}i:193;a:3:{s:7:\"desktop\";s:901:\"#colibri .style-193-outer {\n  padding-top: 0px;\n  padding-right: 0px;\n  padding-bottom: 0px;\n  padding-left: 0px;\n}\n#colibri .style-193 {\n  text-align: center;\n  height: auto;\n  min-height: unset;\n  padding-top: 0px;\n  padding-right: 0px;\n  padding-bottom: 0px;\n  padding-left: 0px;\n  border-top-width: 3px;\n  border-top-color: rgba(64, 191, 154, 0.45);\n  border-top-style: solid;\n  border-top-left-radius: 22px;\n  border-top-right-radius: 22px;\n  border-right-width: 3px;\n  border-right-color: rgba(64, 191, 154, 0.45);\n  border-right-style: solid;\n  border-bottom-width: 3px;\n  border-bottom-color: rgba(64, 191, 154, 0.45);\n  border-bottom-style: solid;\n  border-bottom-left-radius: 22px;\n  border-bottom-right-radius: 22px;\n  border-left-width: 3px;\n  border-left-color: rgba(64, 191, 154, 0.45);\n  border-left-style: solid;\n  background-color: rgba(76, 175, 80, 0.7);\n  background-image: none;\n}\n\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}i:194;a:3:{s:7:\"desktop\";s:646:\"#colibri .style-194-icon {\n  fill: #FFFFFF;\n  width: 64px ;\n  height: 64px;\n  border-top-width: 2px;\n  border-top-color: #f79007;\n  border-top-style: none;\n  border-top-left-radius: 300px;\n  border-top-right-radius: 300px;\n  border-right-width: 2px;\n  border-right-color: #f79007;\n  border-right-style: none;\n  border-bottom-width: 2px;\n  border-bottom-color: #f79007;\n  border-bottom-style: none;\n  border-bottom-left-radius: 300px;\n  border-bottom-right-radius: 300px;\n  border-left-width: 2px;\n  border-left-color: #f79007;\n  border-left-style: none;\n  padding-top: 11px;\n  padding-right: 11px;\n  padding-bottom: 11px;\n  padding-left: 11px;\n}\n\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}i:195;a:3:{s:7:\"desktop\";s:388:\"#colibri .style-195 p,#colibri .style-195  h1,#colibri .style-195  h2,#colibri .style-195  h3,#colibri .style-195  h4,#colibri .style-195  h5,#colibri .style-195  h6 {\n  text-transform: uppercase;\n  letter-spacing: 1px;\n  color: #FFFFFF;\n}\n#colibri .style-195 .text-wrapper-fancy svg path {\n  stroke: #000000;\n  stroke-linejoin: initial;\n  stroke-linecap: initial;\n  stroke-width: 8px;\n}\n\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}i:196;a:3:{s:7:\"desktop\";s:193:\"#colibri .style-196 {\n  color: #000000;\n}\n#colibri .style-196 p {\n  color: #000000;\n}\n#colibri .style-196 ol {\n  list-style-type: decimal;\n}\n#colibri .style-196 ul {\n  list-style-type: disc;\n}\n\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}i:197;a:3:{s:7:\"desktop\";s:875:\"#colibri .style-197-outer {\n  padding-top: 0px;\n  padding-right: 0px;\n  padding-bottom: 0px;\n  padding-left: 0px;\n}\n#colibri .style-197 {\n  text-align: center;\n  height: auto;\n  min-height: unset;\n  padding-top: 0px;\n  padding-right: 0px;\n  padding-bottom: 0px;\n  padding-left: 0px;\n  border-top-width: 3px;\n  border-top-color: rgb(16, 201, 186);\n  border-top-style: solid;\n  border-top-left-radius: 22px;\n  border-top-right-radius: 22px;\n  border-right-width: 3px;\n  border-right-color: rgb(16, 201, 186);\n  border-right-style: solid;\n  border-bottom-width: 3px;\n  border-bottom-color: rgb(16, 201, 186);\n  border-bottom-style: solid;\n  border-bottom-left-radius: 22px;\n  border-bottom-right-radius: 22px;\n  border-left-width: 3px;\n  border-left-color: rgb(16, 201, 186);\n  border-left-style: solid;\n  background-color: rgba(12, 215, 167, 0.58);\n  background-image: none;\n}\n\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}i:202;a:3:{s:7:\"desktop\";s:347:\"#colibri .style-202 p,#colibri .style-202  h1,#colibri .style-202  h2,#colibri .style-202  h3,#colibri .style-202  h4,#colibri .style-202  h5,#colibri .style-202  h6 {\n  color: rgb(127, 191, 172);\n}\n#colibri .style-202 .text-wrapper-fancy svg path {\n  stroke: #000000;\n  stroke-linejoin: initial;\n  stroke-linecap: initial;\n  stroke-width: 8px;\n}\n\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}i:203;a:3:{s:7:\"desktop\";s:882:\"#colibri .style-203-outer {\n  padding-top: 0px;\n  padding-right: 0px;\n  padding-bottom: 0px;\n  padding-left: 0px;\n}\n#colibri .style-203 {\n  text-align: center;\n  min-height: 434px;\n  padding-top: 0px;\n  padding-right: 0px;\n  padding-bottom: 0px;\n  padding-left: 0px;\n  border-top-width: 3px;\n  border-top-color: rgba(247, 144, 7, 0.44);\n  border-top-style: solid;\n  border-top-left-radius: 22px;\n  border-top-right-radius: 22px;\n  border-right-width: 3px;\n  border-right-color: rgba(247, 144, 7, 0.44);\n  border-right-style: solid;\n  border-bottom-width: 3px;\n  border-bottom-color: rgba(247, 144, 7, 0.44);\n  border-bottom-style: solid;\n  border-bottom-left-radius: 22px;\n  border-bottom-right-radius: 22px;\n  border-left-width: 3px;\n  border-left-color: rgba(247, 144, 7, 0.44);\n  border-left-style: solid;\n  background-color: rgba(251, 192, 45, 0.7);\n  background-image: none;\n}\n\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}i:204;a:3:{s:7:\"desktop\";s:869:\"#colibri .style-204-outer {\n  padding-top: 0px;\n  padding-right: 0px;\n  padding-bottom: 0px;\n  padding-left: 0px;\n}\n#colibri .style-204 {\n  text-align: center;\n  height: auto;\n  min-height: unset;\n  padding-top: 0px;\n  padding-right: 0px;\n  padding-bottom: 0px;\n  padding-left: 0px;\n  border-top-width: 3px;\n  border-top-color: rgb(251, 230, 5);\n  border-top-style: solid;\n  border-top-left-radius: 22px;\n  border-top-right-radius: 22px;\n  border-right-width: 3px;\n  border-right-color: rgb(251, 230, 5);\n  border-right-style: solid;\n  border-bottom-width: 3px;\n  border-bottom-color: rgb(251, 230, 5);\n  border-bottom-style: solid;\n  border-bottom-left-radius: 22px;\n  border-bottom-right-radius: 22px;\n  border-left-width: 3px;\n  border-left-color: rgb(251, 230, 5);\n  border-left-style: solid;\n  background-color: rgba(209, 196, 8, 0.7);\n  background-image: none;\n}\n\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}i:205;a:3:{s:7:\"desktop\";s:715:\"#colibri .style-205-image {\n  max-height: 70px;\n}\n#colibri .style-205 {\n  color: #fff;\n}\n#colibri .style-205 a,#colibri .style-205  .logo-text {\n  color: #ffffff;\n  font-family: Montserrat;\n  font-weight: 600;\n  text-decoration: none;\n  text-transform: uppercase;\n  font-size: 34px;\n  letter-spacing: 2px;\n}\n#colibri .style-205 .logo-text {\n  color: #FFFFFF;\n}\n#colibri .h-navigation_sticky .style-205-image,#colibri .h-navigation_sticky.style-205-image {\n  max-height: 70px;\n}\n#colibri .h-navigation_sticky .style-205 a,#colibri .h-navigation_sticky .style-205  .logo-text,#colibri .h-navigation_sticky.style-205 a,#colibri .h-navigation_sticky.style-205  .logo-text {\n  color: #000000;\n  text-decoration: none;\n}\n\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}i:211;a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}i:217;a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}i:218;a:3:{s:7:\"desktop\";s:83:\"#colibri .style-218 {\n  text-align: center;\n  height: auto;\n  min-height: unset;\n}\n\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}i:219;a:3:{s:7:\"desktop\";s:336:\"#colibri .style-219 p,#colibri .style-219  h1,#colibri .style-219  h2,#colibri .style-219  h3,#colibri .style-219  h4,#colibri .style-219  h5,#colibri .style-219  h6 {\n  color: #FFFFFF;\n}\n#colibri .style-219 .text-wrapper-fancy svg path {\n  stroke: #000000;\n  stroke-linejoin: initial;\n  stroke-linecap: initial;\n  stroke-width: 8px;\n}\n\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}i:221;a:3:{s:7:\"desktop\";s:398:\"#colibri .style-221 .social-icon-container {\n  margin-right: 50px;\n  padding-top: 8px;\n  padding-right: 8px;\n  padding-bottom: 8px;\n  padding-left: 8px;\n}\n#colibri .style-221 .icon-container {\n  fill: rgb(140, 35, 159);\n  width: 85px ;\n  height: 85px;\n}\n#colibri .style-221 .icon-container:hover {\n  fill: rgb(3, 169, 244);\n}\n#colibri .style-221 .icon-container:hover {\n  fill: rgb(3, 169, 244);\n}\n\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}i:224;a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}i:225;a:3:{s:7:\"desktop\";s:83:\"#colibri .style-225 {\n  text-align: center;\n  height: auto;\n  min-height: unset;\n}\n\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}i:226;a:3:{s:7:\"desktop\";s:107:\"#colibri .style-226 ol {\n  list-style-type: decimal;\n}\n#colibri .style-226 ul {\n  list-style-type: disc;\n}\n\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}i:227;a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}i:228;a:3:{s:7:\"desktop\";s:61:\"#colibri .style-228 {\n  height: auto;\n  min-height: unset;\n}\n\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}i:229;a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}i:230;a:3:{s:7:\"desktop\";s:83:\"#colibri .style-230 {\n  text-align: center;\n  height: auto;\n  min-height: unset;\n}\n\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}i:231;a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}i:240;a:3:{s:7:\"desktop\";s:83:\"#colibri .style-240 {\n  text-align: center;\n  height: auto;\n  min-height: unset;\n}\n\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}i:241;a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}i:242;a:3:{s:7:\"desktop\";s:61:\"#colibri .style-242 {\n  height: auto;\n  min-height: unset;\n}\n\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}i:243;a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}i:244;a:3:{s:7:\"desktop\";s:83:\"#colibri .style-244 {\n  text-align: center;\n  height: auto;\n  min-height: unset;\n}\n\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}i:245;a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}i:246;a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}i:247;a:3:{s:7:\"desktop\";s:61:\"#colibri .style-247 {\n  height: auto;\n  min-height: unset;\n}\n\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}i:248;a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}i:249;a:3:{s:7:\"desktop\";s:83:\"#colibri .style-249 {\n  text-align: center;\n  height: auto;\n  min-height: unset;\n}\n\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}i:250;a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}i:251;a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}i:259;a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}i:260;a:3:{s:7:\"desktop\";s:83:\"#colibri .style-260 {\n  text-align: center;\n  height: auto;\n  min-height: unset;\n}\n\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}i:262;a:3:{s:7:\"desktop\";s:195:\"#colibri .style-262 {\n  font-size: 16px;\n}\n#colibri .style-262 p {\n  font-size: 16px;\n}\n#colibri .style-262 ol {\n  list-style-type: decimal;\n}\n#colibri .style-262 ul {\n  list-style-type: disc;\n}\n\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}i:263;a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}i:264;a:3:{s:7:\"desktop\";s:83:\"#colibri .style-264 {\n  text-align: center;\n  height: auto;\n  min-height: unset;\n}\n\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}i:266;a:3:{s:7:\"desktop\";s:148:\"#colibri .style-266 .text-wrapper-fancy svg path {\n  stroke: #000000;\n  stroke-linejoin: initial;\n  stroke-linecap: initial;\n  stroke-width: 8px;\n}\n\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}i:267;a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}i:268;a:3:{s:7:\"desktop\";s:142:\"#colibri .style-268 {\n  min-height: 100vh;\n  background-color: unset;\n  background-image: none;\n  padding-top: 0px;\n  padding-bottom: 34px;\n}\n\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}i:269;a:3:{s:7:\"desktop\";s:77:\"#colibri .style-269 {\n  background-color: unset;\n  background-image: none;\n}\n\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}i:270;a:3:{s:7:\"desktop\";s:83:\"#colibri .style-270 {\n  text-align: center;\n  height: auto;\n  min-height: unset;\n}\n\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}i:271;a:3:{s:7:\"desktop\";s:520:\"#colibri .style-271 p,#colibri .style-271  h1,#colibri .style-271  h2,#colibri .style-271  h3,#colibri .style-271  h4,#colibri .style-271  h5,#colibri .style-271  h6 {\n  font-style: normal;\n  text-decoration: overline;\n  font-size: 3em;\n  letter-spacing: 10px;\n  color: rgba(5, 127, 93, 0.56);\n  text-align: center;\n  text-shadow: 0px 0px 10px \n        rgba(0,0,0,0.5);\n}\n#colibri .style-271 .text-wrapper-fancy svg path {\n  stroke: #000000;\n  stroke-linejoin: initial;\n  stroke-linecap: initial;\n  stroke-width: 8px;\n}\n\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}i:272;a:3:{s:7:\"desktop\";s:344:\"#colibri .style-272 p,#colibri .style-272  h1,#colibri .style-272  h2,#colibri .style-272  h3,#colibri .style-272  h4,#colibri .style-272  h5,#colibri .style-272  h6 {\n  color: rgb(51, 51, 51);\n}\n#colibri .style-272 .text-wrapper-fancy svg path {\n  stroke: #000000;\n  stroke-linejoin: initial;\n  stroke-linecap: initial;\n  stroke-width: 8px;\n}\n\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}i:273;a:3:{s:7:\"desktop\";s:193:\"#colibri .style-273 {\n  color: #000000;\n}\n#colibri .style-273 p {\n  color: #000000;\n}\n#colibri .style-273 ol {\n  list-style-type: decimal;\n}\n#colibri .style-273 ul {\n  list-style-type: disc;\n}\n\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}i:274;a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}i:275;a:3:{s:7:\"desktop\";s:1289:\"#colibri .style-275-icon {\n  width: 12px;\n  height: 12px;\n  margin-right: 10px;\n  margin-left: 0px;\n}\n#colibri .style-275 {\n  text-align: center;\n  background-color: #03a9f4;\n  background-image: none;\n  font-family: Open Sans;\n  font-weight: 600;\n  text-transform: uppercase;\n  font-size: 12px;\n  line-height: 1;\n  letter-spacing: 1px;\n  color: #fff;\n  border-top-width: 2px;\n  border-top-color: #03a9f4;\n  border-top-style: solid;\n  border-top-left-radius: 0px;\n  border-top-right-radius: 0px;\n  border-right-width: 2px;\n  border-right-color: #03a9f4;\n  border-right-style: solid;\n  border-bottom-width: 2px;\n  border-bottom-color: #03a9f4;\n  border-bottom-style: solid;\n  border-bottom-left-radius: 0px;\n  border-bottom-right-radius: 0px;\n  border-left-width: 2px;\n  border-left-color: #03a9f4;\n  border-left-style: solid;\n  padding-top: 12px;\n  padding-right: 24px;\n  padding-bottom: 12px;\n  padding-left: 24px;\n}\n#colibri .style-275:hover,#colibri .style-275:focus {\n  background-color: rgb(2, 110, 159);\n  border-top-color: rgb(2, 110, 159);\n  border-right-color: rgb(2, 110, 159);\n  border-bottom-color: rgb(2, 110, 159);\n  border-left-color: rgb(2, 110, 159);\n}\n#colibri .style-275:active .style-275-icon {\n  width: 12px;\n  height: 12px;\n  margin-right: 10px;\n  margin-left: 0px;\n}\n\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}i:276;a:3:{s:7:\"desktop\";s:159:\".style-276 > .h-y-container > *:not(:last-child) {\n  margin-bottom: 42px;\n}\n#colibri .style-276 {\n  text-align: center;\n  height: auto;\n  min-height: unset;\n}\n\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}i:277;a:3:{s:7:\"desktop\";s:857:\"#colibri .style-277-image {\n  opacity: 1;\n  box-shadow: 0px 10px 30px 2px rgba(0, 0, 0, 0.1) ;\n}\n#colibri .style-277-overlay {\n  background-color: unset;\n  background-image: none;\n}\n#colibri .style-277-caption {\n  margin-top: 10px;\n}\n#colibri .style-277-frameImage {\n  z-index: 1;\n  transform: translateX(5%) translateY(5%);\n  transform-origin: center center 0px;\n  background-color: transparent;\n  height: 100%;\n  width: 100% ;\n  border-top-width: 10px;\n  border-top-color: rgb(3, 169, 244);\n  border-top-style: solid;\n  border-right-width: 10px;\n  border-right-color: rgb(3, 169, 244);\n  border-right-style: solid;\n  border-bottom-width: 10px;\n  border-bottom-color: rgb(3, 169, 244);\n  border-bottom-style: solid;\n  border-left-width: 10px;\n  border-left-color: rgb(3, 169, 244);\n  border-left-style: solid;\n}\n#colibri .style-277 {\n  text-align: left;\n}\n\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}i:278;a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}i:279;a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}i:280;a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}i:281;a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}i:283;a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}i:284;a:3:{s:7:\"desktop\";s:83:\"#colibri .style-284 {\n  text-align: center;\n  height: auto;\n  min-height: unset;\n}\n\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}i:285;a:3:{s:7:\"desktop\";s:336:\"#colibri .style-285 p,#colibri .style-285  h1,#colibri .style-285  h2,#colibri .style-285  h3,#colibri .style-285  h4,#colibri .style-285  h5,#colibri .style-285  h6 {\n  color: #FFFFFF;\n}\n#colibri .style-285 .text-wrapper-fancy svg path {\n  stroke: #000000;\n  stroke-linejoin: initial;\n  stroke-linecap: initial;\n  stroke-width: 8px;\n}\n\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}i:287;a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}i:288;a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}i:289;a:3:{s:7:\"desktop\";s:176:\"#colibri .style-289 {\n  height: auto;\n  min-height: unset;\n  padding-top: 0px;\n  padding-bottom: 0px;\n}\n#colibri .style-289  > .h-section-grid-container {\n  margin-top: 0px;\n}\n\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:43:\"#colibri .style-289 {\n  margin-top: 0px;\n}\n\";}i:290;a:3:{s:7:\"desktop\";s:79:\"#colibri .style-290 {\n  box-shadow: 0px 4px 10px 2px rgba(74, 74, 74, 0.3) ;\n}\n\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:110:\"#colibri .style-290 {\n  margin-top: 15px;\n  margin-right: 15px;\n  margin-bottom: 15px;\n  margin-left: 15px;\n}\n\";}i:291;a:3:{s:7:\"desktop\";s:469:\"#colibri .style-291 {\n  text-align: center;\n  height: auto;\n  min-height: unset;\n  border-top-width: 0px;\n  border-top-color: rgb(221, 221, 221);\n  border-top-style: solid;\n  border-right-width: 1px;\n  border-right-color: rgb(221, 221, 221);\n  border-right-style: solid;\n  border-bottom-width: 0px;\n  border-bottom-color: rgb(221, 221, 221);\n  border-bottom-style: solid;\n  border-left-width: 0px;\n  border-left-color: rgb(221, 221, 221);\n  border-left-style: solid;\n}\n\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}i:292;a:3:{s:7:\"desktop\";s:646:\"#colibri .style-292-icon {\n  fill: #000000;\n  width: 64px ;\n  height: 64px;\n  border-top-width: 2px;\n  border-top-color: #f79007;\n  border-top-style: none;\n  border-top-left-radius: 300px;\n  border-top-right-radius: 300px;\n  border-right-width: 2px;\n  border-right-color: #f79007;\n  border-right-style: none;\n  border-bottom-width: 2px;\n  border-bottom-color: #f79007;\n  border-bottom-style: none;\n  border-bottom-left-radius: 300px;\n  border-bottom-right-radius: 300px;\n  border-left-width: 2px;\n  border-left-color: #f79007;\n  border-left-style: none;\n  padding-top: 11px;\n  padding-right: 11px;\n  padding-bottom: 11px;\n  padding-left: 11px;\n}\n\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}i:293;a:3:{s:7:\"desktop\";s:370:\"#colibri .style-293 p,#colibri .style-293  h1,#colibri .style-293  h2,#colibri .style-293  h3,#colibri .style-293  h4,#colibri .style-293  h5,#colibri .style-293  h6 {\n  text-transform: uppercase;\n  letter-spacing: 1px;\n}\n#colibri .style-293 .text-wrapper-fancy svg path {\n  stroke: #000000;\n  stroke-linejoin: initial;\n  stroke-linecap: initial;\n  stroke-width: 8px;\n}\n\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}i:294;a:3:{s:7:\"desktop\";s:107:\"#colibri .style-294 ol {\n  list-style-type: decimal;\n}\n#colibri .style-294 ul {\n  list-style-type: disc;\n}\n\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}i:295;a:3:{s:7:\"desktop\";s:469:\"#colibri .style-295 {\n  text-align: center;\n  height: auto;\n  min-height: unset;\n  border-top-width: 0px;\n  border-top-color: rgb(221, 221, 221);\n  border-top-style: solid;\n  border-right-width: 0px;\n  border-right-color: rgb(221, 221, 221);\n  border-right-style: solid;\n  border-bottom-width: 0px;\n  border-bottom-color: rgb(221, 221, 221);\n  border-bottom-style: solid;\n  border-left-width: 0px;\n  border-left-color: rgb(221, 221, 221);\n  border-left-style: solid;\n}\n\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}i:296;a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}i:297;a:3:{s:7:\"desktop\";s:286:\"#colibri .style-297 {\n  height: auto;\n  min-height: unset;\n  background-position: center center;\n  background-size: cover;\n  background-image: linear-gradient(0deg,  rgba(244,59,71,0.80) 0%, rgba(69,58,148,0.80) 100%);\n  background-attachment: scroll;\n  background-repeat: no-repeat;\n}\n\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}i:298;a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}i:299;a:3:{s:7:\"desktop\";s:83:\"#colibri .style-299 {\n  text-align: center;\n  height: auto;\n  min-height: unset;\n}\n\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}i:300;a:3:{s:7:\"desktop\";s:516:\"#colibri .style-300 {\n  height: auto;\n  min-height: unset;\n  background-position: center right;\n  background-size: cover;\n  background-image: url(\"http://localhost/wordpress/wp-content/uploads/2024/11/DALL·E-2024-11-03-15.20.45-A-serene-empty-beach-in-Martinique-at-sunrise-featuring-dark-volcanic-sand-and-soft-early-morning-light.-In-the-distant-sky-an-airplane-is-descendi.webp\");\n  background-attachment: fixed;\n  background-repeat: no-repeat;\n  color: #000000;\n  padding-top: 150px;\n  padding-bottom: 150px;\n}\n\";s:6:\"tablet\";s:87:\"#colibri .style-300 {\n  background-position: 14.654890415439976% 53.48230912476723%;\n}\n\";s:6:\"mobile\";s:0:\"\";}i:301;a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}i:302;a:3:{s:7:\"desktop\";s:451:\"#colibri .style-302 {\n  text-align: center;\n  height: auto;\n  min-height: unset;\n  box-shadow: none;\n  border-top-width: 0px;\n  border-top-style: none;\n  border-top-left-radius: 5px;\n  border-top-right-radius: 5px;\n  border-right-width: 0px;\n  border-right-style: none;\n  border-bottom-width: 0px;\n  border-bottom-style: none;\n  border-bottom-left-radius: 5px;\n  border-bottom-right-radius: 5px;\n  border-left-width: 0px;\n  border-left-style: none;\n}\n\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}i:303;a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}i:304;a:3:{s:7:\"desktop\";s:600:\".style-304 > .h-y-container > *:not(:last-child) {\n  margin-bottom: 40px;\n}\n#colibri .style-304 {\n  text-align: center;\n  height: auto;\n  min-height: unset;\n  background-color: rgba(155, 90, 3, 0.33);\n  background-image: none;\n  padding-top: 25px;\n  padding-right: 25px;\n  padding-bottom: 25px;\n  padding-left: 25px;\n  border-top-width: 0px;\n  border-top-style: none;\n  border-top-left-radius: 0px;\n  border-right-width: 0px;\n  border-right-style: none;\n  border-bottom-width: 0px;\n  border-bottom-style: none;\n  border-bottom-left-radius: 0px;\n  border-left-width: 0px;\n  border-left-style: none;\n}\n\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:198:\".style-304 > .h-y-container > *:not(:last-child) {\n  margin-bottom: 20px;\n}\n#colibri .style-304 {\n  border-top-left-radius: 5px;\n  border-top-right-radius: 5px;\n  border-bottom-right-radius: 0px;\n}\n\";}i:305;a:3:{s:7:\"desktop\";s:365:\"#colibri .style-305 p,#colibri .style-305  h1,#colibri .style-305  h2,#colibri .style-305  h3,#colibri .style-305  h4,#colibri .style-305  h5,#colibri .style-305  h6 {\n  text-transform: uppercase;\n  color: #FFFFFF;\n}\n#colibri .style-305 .text-wrapper-fancy svg path {\n  stroke: #000000;\n  stroke-linejoin: initial;\n  stroke-linecap: initial;\n  stroke-width: 8px;\n}\n\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}i:306;a:3:{s:7:\"desktop\";s:650:\"#colibri .style-306-icon {\n  fill: #FFFFFF;\n  width: 40px ;\n  height: 40px;\n  padding-top: 15px;\n  padding-right: 15px;\n  padding-bottom: 15px;\n  padding-left: 15px;\n  border-top-width: 2px;\n  border-top-color: #FFFFFF;\n  border-top-style: solid;\n  border-top-left-radius: 300px;\n  border-top-right-radius: 300px;\n  border-right-width: 2px;\n  border-right-color: #FFFFFF;\n  border-right-style: solid;\n  border-bottom-width: 2px;\n  border-bottom-color: #FFFFFF;\n  border-bottom-style: solid;\n  border-bottom-left-radius: 300px;\n  border-bottom-right-radius: 300px;\n  border-left-width: 2px;\n  border-left-color: #FFFFFF;\n  border-left-style: solid;\n}\n\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}i:307;a:3:{s:7:\"desktop\";s:336:\"#colibri .style-307 p,#colibri .style-307  h1,#colibri .style-307  h2,#colibri .style-307  h3,#colibri .style-307  h4,#colibri .style-307  h5,#colibri .style-307  h6 {\n  color: #FFFFFF;\n}\n#colibri .style-307 .text-wrapper-fancy svg path {\n  stroke: #000000;\n  stroke-linejoin: initial;\n  stroke-linecap: initial;\n  stroke-width: 8px;\n}\n\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}i:308;a:3:{s:7:\"desktop\";s:1431:\"#colibri .style-308:hover {\n  transition-duration: 1s;\n}\n#colibri .style-308 .social-icon-container {\n  margin-right: 10px;\n  padding-top: 10px;\n  padding-right: 10px;\n  padding-bottom: 10px;\n  padding-left: 10px;\n  border-top-width: 1px;\n  border-top-color: #FFFFFF;\n  border-top-style: solid;\n  border-top-left-radius: 300px;\n  border-top-right-radius: 300px;\n  border-right-width: 1px;\n  border-right-color: #FFFFFF;\n  border-right-style: solid;\n  border-bottom-width: 1px;\n  border-bottom-color: #FFFFFF;\n  border-bottom-style: solid;\n  border-bottom-left-radius: 300px;\n  border-bottom-right-radius: 300px;\n  border-left-width: 1px;\n  border-left-color: #FFFFFF;\n  border-left-style: solid;\n}\n#colibri .style-308 .social-icon-container:hover {\n  border-top-color: rgb(166, 220, 244);\n  border-right-color: rgb(166, 220, 244);\n  border-bottom-color: rgb(166, 220, 244);\n  border-left-color: rgb(166, 220, 244);\n  transition-duration: 0.5s;\n}\n#colibri .style-308 .social-icon-container:hover {\n  border-top-color: rgb(166, 220, 244);\n  border-right-color: rgb(166, 220, 244);\n  border-bottom-color: rgb(166, 220, 244);\n  border-left-color: rgb(166, 220, 244);\n  transition-duration: 0.5s;\n}\n#colibri .style-308 .icon-container {\n  fill: #FFFFFF;\n  width: 20px ;\n  height: 20px;\n}\n#colibri .style-308 .icon-container:hover {\n  fill: rgb(166, 220, 244);\n}\n#colibri .style-308 .icon-container:hover {\n  fill: rgb(166, 220, 244);\n}\n\";s:6:\"tablet\";s:72:\"#colibri .style-308 .icon-container {\n  width: 15px ;\n  height: 15px;\n}\n\";s:6:\"mobile\";s:0:\"\";}i:309;a:3:{s:7:\"desktop\";s:495:\".style-309 > .h-y-container > *:not(:last-child) {\n  margin-bottom: 40px;\n}\n#colibri .style-309 {\n  text-align: left;\n  height: auto;\n  min-height: unset;\n  background-color: #FFFFFF;\n  background-image: none;\n  border-top-width: 0px;\n  border-top-style: none;\n  border-top-right-radius: 5px;\n  border-right-width: 0px;\n  border-right-style: none;\n  border-bottom-width: 0px;\n  border-bottom-style: none;\n  border-bottom-right-radius: 5px;\n  border-left-width: 0px;\n  border-left-style: none;\n}\n\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:143:\"#colibri .style-309 {\n  text-align: center;\n  border-top-left-radius: 0px;\n  border-top-right-radius: 0px;\n  border-bottom-left-radius: 5px;\n}\n\";}i:310;a:3:{s:7:\"desktop\";s:5168:\"#colibri .style-310 {\n  padding-top: 40px;\n  padding-right: 40px;\n  padding-bottom: 0px;\n  padding-left: 40px;\n}\n#colibri .style-310 .h-contact-form-shortcode label,#colibri .style-310 .h-contact-form-shortcode p label,#colibri .style-310 .h-contact-form-shortcode .wpcf7-not-valid-tip,#colibri .style-310 .h-contact-form-shortcode .forminator-row .forminator-col label {\n  color: #000000;\n}\n#colibri .style-310 .h-contact-form-shortcode  textarea,#colibri .style-310 .h-contact-form-shortcode  form.forminator-ui textarea.forminator-textarea,#colibri .style-310 .h-contact-form-shortcode  select,#colibri .style-310 .h-contact-form-shortcode  input:not([type=\"file\"]):not([type=\"radio\"]):not([type=\"checkbox\"]):not([type=\"submit\"]) {\n  margin-top: 4px;\n  margin-bottom: 16px;\n  background-color: #ffffff;\n  background-image: none;\n  border-top-width: 0px;\n  border-top-color: #000000;\n  border-top-style: solid;\n  border-right-width: 0px;\n  border-right-color: #000000;\n  border-right-style: solid;\n  border-bottom-width: 1px;\n  border-bottom-color: #000000;\n  border-bottom-style: solid;\n  border-left-width: 0px;\n  border-left-color: #000000;\n  border-left-style: solid;\n  color: #000000;\n  padding-top: 10px;\n  padding-right: 10px;\n  padding-bottom: 10px;\n  padding-left: 10px;\n}\n#colibri .style-310 .h-contact-form-shortcode [type=\"submit\"],#colibri .style-310 .h-contact-form-shortcode .forminator-row .forminator-col .forminator-button-submit {\n  background-color: #03a9f4;\n  background-image: none;\n  padding-top: 20px;\n  padding-right: 40px;\n  padding-bottom: 20px;\n  padding-left: 40px;\n  font-weight: 600;\n  text-transform: uppercase;\n  font-size: 12px;\n  letter-spacing: 2px;\n  color: #FFFFFF;\n  border-top-width: 0px;\n  border-top-style: none;\n  border-top-left-radius: 5px;\n  border-top-right-radius: 5px;\n  border-right-width: 0px;\n  border-right-style: none;\n  border-bottom-width: 0px;\n  border-bottom-style: none;\n  border-bottom-left-radius: 5px;\n  border-bottom-right-radius: 5px;\n  border-left-width: 0px;\n  border-left-style: none;\n  margin-left: auto;\n  margin-right: 0;\n}\n#colibri .style-310 .h-contact-form-shortcode [type=\"submit\"]:hover,#colibri .style-310 .h-contact-form-shortcode .forminator-row .forminator-col .forminator-button-submit:hover {\n  background-color: #f79007;\n}\n#colibri .style-310 .h-contact-form-shortcode [type=\"submit\"]:hover,#colibri .style-310 .h-contact-form-shortcode .forminator-row .forminator-col .forminator-button-submit:hover {\n  background-color: #f79007;\n}\n#colibri .style-310 .h-contact-form-shortcode .wpcf7-mail-sent-ng,#colibri .style-310 .h-contact-form-shortcode .wpcf7-aborted,#colibri .style-310 .h-contact-form-shortcode .wpcf7 form.failed .wpcf7-response-output,#colibri .style-310 .h-contact-form-shortcode .wpcf7 form.aborted .wpcf7-response-output,#colibri .style-310 .h-contact-form-shortcode form.forminator-ui  .forminator-response-message.forminator-error {\n  border-top-width: 2px;\n  border-top-color: black;\n  border-top-style: solid;\n  border-right-width: 2px;\n  border-right-color: black;\n  border-right-style: solid;\n  border-bottom-width: 2px;\n  border-bottom-color: black;\n  border-bottom-style: solid;\n  border-left-width: 2px;\n  border-left-color: black;\n  border-left-style: solid;\n  color: #000000;\n}\n#colibri .style-310 .h-contact-form-shortcode .wpcf7-validation-errors,#colibri .style-310 .h-contact-form-shortcode .wpcf7 form.invalid .wpcf7-response-output,#colibri .style-310 .h-contact-form-shortcode .wpcf7 form.unaccepted .wpcf7-response-output,#colibri .style-310 .h-contact-form-shortcode form.forminator-ui  .forminator-response-message.forminator-loading {\n  border-top-width: 2px;\n  border-top-color: black;\n  border-top-style: solid;\n  border-right-width: 2px;\n  border-right-color: black;\n  border-right-style: solid;\n  border-bottom-width: 2px;\n  border-bottom-color: black;\n  border-bottom-style: solid;\n  border-left-width: 2px;\n  border-left-color: black;\n  border-left-style: solid;\n  color: #000000;\n}\n#colibri .style-310 .h-contact-form-shortcode .wpcf7-mail-sent-ok,#colibri .style-310 .h-contact-form-shortcode .wpcf7 form.sent .wpcf7-response-output,#colibri .style-310 .h-contact-form-shortcode .wpforms-confirmation-container-full,#colibri .style-310 .h-contact-form-shortcode .wpforms-confirmation-container,#colibri .style-310 .h-contact-form-shortcode form.forminator-ui  .forminator-response-message.forminator-success {\n  border-top-width: 2px;\n  border-top-color: black;\n  border-top-style: solid;\n  border-right-width: 2px;\n  border-right-color: black;\n  border-right-style: solid;\n  border-bottom-width: 2px;\n  border-bottom-color: black;\n  border-bottom-style: solid;\n  border-left-width: 2px;\n  border-left-color: black;\n  border-left-style: solid;\n  color: #000000;\n}\n#colibri .style-310 .h-contact-form-shortcode  .forminator-row .forminator-col .forminator-error-message {\n  background-color: #F9E4E8;\n  background-image: none;\n  line-height: 2em;\n  color: #E04562;\n  padding-top: 2px;\n  padding-right: 10px;\n  padding-bottom: 2px;\n  padding-left: 10px;\n  margin-top: 5px;\n  margin-right: 0px;\n  margin-bottom: 16px;\n  margin-left: 0px;\n}\n\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:192:\"#colibri .style-310 .h-contact-form-shortcode [type=\"submit\"],#colibri .style-310 .h-contact-form-shortcode .forminator-row .forminator-col .forminator-button-submit {\n  margin-right: auto;\n}\n\";}i:311;a:3:{s:7:\"desktop\";s:77:\"#colibri .style-311 {\n  background-color: unset;\n  background-image: none;\n}\n\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}i:312;a:3:{s:7:\"desktop\";s:264:\"#colibri .style-312-outer {\n  padding-top: 48px;\n  padding-right: 48px;\n  padding-bottom: 48px;\n  padding-left: 48px;\n}\n#colibri .style-312 {\n  text-align: center;\n  height: auto;\n  min-height: unset;\n  background-color: rgba(0,0,0,0);\n  background-image: none;\n}\n\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}i:313;a:3:{s:7:\"desktop\";s:336:\"#colibri .style-313 p,#colibri .style-313  h1,#colibri .style-313  h2,#colibri .style-313  h3,#colibri .style-313  h4,#colibri .style-313  h5,#colibri .style-313  h6 {\n  color: #FFFFFF;\n}\n#colibri .style-313 .text-wrapper-fancy svg path {\n  stroke: #000000;\n  stroke-linejoin: initial;\n  stroke-linecap: initial;\n  stroke-width: 8px;\n}\n\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}i:314;a:3:{s:7:\"desktop\";s:217:\"#colibri .style-314 {\n  font-size: 22px;\n  text-align: center;\n}\n#colibri .style-314 p {\n  font-size: 22px;\n}\n#colibri .style-314 ol {\n  list-style-type: decimal;\n}\n#colibri .style-314 ul {\n  list-style-type: disc;\n}\n\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}i:315;a:3:{s:7:\"desktop\";s:40:\"#colibri .style-315 {\n  bottom: 20px;\n}\n\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}i:316;a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}i:317;a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}i:318;a:3:{s:7:\"desktop\";s:78:\"#colibri .style-318-icon {\n  fill: #FFFFFF;\n  width: 40px ;\n  height: 40px;\n}\n\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}i:320;a:3:{s:7:\"desktop\";s:138:\"#colibri .h-navigation_sticky .style-320,#colibri .h-navigation_sticky.style-320 {\n  background-color: unset;\n  background-image: none;\n}\n\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:94:\"#colibri .style-320 {\n  background-color: rgba(23, 37, 42, 0.48);\n  background-image: none;\n}\n\";}i:323;a:3:{s:7:\"desktop\";s:77:\"#colibri .style-323 {\n  background-color: unset;\n  background-image: none;\n}\n\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}i:324;a:3:{s:7:\"desktop\";s:83:\"#colibri .style-324 {\n  text-align: center;\n  height: auto;\n  min-height: unset;\n}\n\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}i:327;a:3:{s:7:\"desktop\";s:491:\"#colibri .style-327 {\n  font-style: normal;\n  text-decoration: overline;\n  font-size: 9px;\n  line-height: 5.3;\n  letter-spacing: 3px;\n  color: rgb(251, 192, 45);\n  text-shadow: 0px 0px 10px \n        rgba(0,0,0,0.5);\n}\n#colibri .style-327 p {\n  font-style: normal;\n  text-decoration: overline;\n  font-size: 9px;\n  line-height: 5.3;\n  letter-spacing: 3px;\n  color: rgb(251, 192, 45);\n}\n#colibri .style-327 ol {\n  list-style-type: decimal;\n}\n#colibri .style-327 ul {\n  list-style-type: disc;\n}\n\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}i:330;a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}i:331;a:3:{s:7:\"desktop\";s:83:\"#colibri .style-331 {\n  text-align: center;\n  height: auto;\n  min-height: unset;\n}\n\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}i:333;a:3:{s:7:\"desktop\";s:83:\"#colibri .style-333 {\n  text-align: center;\n  height: auto;\n  min-height: unset;\n}\n\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}i:341;a:3:{s:7:\"desktop\";s:107:\"#colibri .style-341 ol {\n  list-style-type: decimal;\n}\n#colibri .style-341 ul {\n  list-style-type: disc;\n}\n\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}i:348;a:3:{s:7:\"desktop\";s:116:\"#colibri .style-348 {\n  height: auto;\n  min-height: unset;\n  background-color: #F5FAFD;\n  background-image: none;\n}\n\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}i:349;a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}i:350;a:3:{s:7:\"desktop\";s:83:\"#colibri .style-350 {\n  text-align: center;\n  height: auto;\n  min-height: unset;\n}\n\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}i:351;a:3:{s:7:\"desktop\";s:83:\"#colibri .style-351 {\n  text-align: center;\n  height: auto;\n  min-height: unset;\n}\n\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}i:352;a:3:{s:7:\"desktop\";s:83:\"#colibri .style-352 {\n  text-align: center;\n  height: auto;\n  min-height: unset;\n}\n\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}i:353;a:3:{s:7:\"desktop\";s:83:\"#colibri .style-353 {\n  text-align: center;\n  height: auto;\n  min-height: unset;\n}\n\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}i:354;a:3:{s:7:\"desktop\";s:83:\"#colibri .style-354 {\n  text-align: center;\n  height: auto;\n  min-height: unset;\n}\n\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}i:355;a:3:{s:7:\"desktop\";s:83:\"#colibri .style-355 {\n  text-align: center;\n  height: auto;\n  min-height: unset;\n}\n\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}i:357;a:3:{s:7:\"desktop\";s:569:\"#colibri .style-357 {\n  font-family: Playfair Display;\n  font-weight: 400;\n  text-decoration: overline;\n  font-size: 45px;\n  line-height: 2;\n  letter-spacing: 1px;\n  color: rgb(162, 94, 5);\n  text-align: center;\n  text-shadow: 0px 0px 10px \n        rgba(0,0,0,0.5);\n}\n#colibri .style-357 p {\n  font-family: Playfair Display;\n  font-weight: 400;\n  text-decoration: overline;\n  font-size: 45px;\n  line-height: 2;\n  letter-spacing: 1px;\n  color: rgb(162, 94, 5);\n}\n#colibri .style-357 ol {\n  list-style-type: decimal;\n}\n#colibri .style-357 ul {\n  list-style-type: disc;\n}\n\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}i:360;a:3:{s:7:\"desktop\";s:193:\"#colibri .style-360 {\n  color: #000000;\n}\n#colibri .style-360 p {\n  color: #000000;\n}\n#colibri .style-360 ol {\n  list-style-type: decimal;\n}\n#colibri .style-360 ul {\n  list-style-type: disc;\n}\n\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}i:361;a:3:{s:7:\"desktop\";s:116:\"#colibri .style-361 {\n  height: auto;\n  min-height: unset;\n  background-color: #F5FAFD;\n  background-image: none;\n}\n\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}i:362;a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}i:363;a:3:{s:7:\"desktop\";s:83:\"#colibri .style-363 {\n  text-align: center;\n  height: auto;\n  min-height: unset;\n}\n\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}i:364;a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}i:365;a:3:{s:7:\"desktop\";s:159:\".style-365 > .h-y-container > *:not(:last-child) {\n  margin-bottom: 33px;\n}\n#colibri .style-365 {\n  text-align: center;\n  height: auto;\n  min-height: unset;\n}\n\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}i:366;a:3:{s:7:\"desktop\";s:389:\"#colibri .style-366 p,#colibri .style-366  h1,#colibri .style-366  h2,#colibri .style-366  h3,#colibri .style-366  h4,#colibri .style-366  h5,#colibri .style-366  h6 {\n  font-size: 4.5em;\n  color: rgb(102, 102, 102);\n  text-align: center;\n}\n#colibri .style-366 .text-wrapper-fancy svg path {\n  stroke: #000000;\n  stroke-linejoin: initial;\n  stroke-linecap: initial;\n  stroke-width: 8px;\n}\n\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}i:367;a:3:{s:7:\"desktop\";s:83:\"#colibri .style-367 {\n  text-align: center;\n  height: auto;\n  min-height: unset;\n}\n\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}i:368;a:3:{s:7:\"desktop\";s:151:\"#colibri .style-368 {\n  text-align: left;\n}\n#colibri .style-368 ol {\n  list-style-type: decimal;\n}\n#colibri .style-368 ul {\n  list-style-type: disc;\n}\n\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}i:369;a:3:{s:7:\"desktop\";s:193:\"#colibri .style-369 {\n  color: #000000;\n}\n#colibri .style-369 p {\n  color: #000000;\n}\n#colibri .style-369 ol {\n  list-style-type: decimal;\n}\n#colibri .style-369 ul {\n  list-style-type: disc;\n}\n\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}i:370;a:3:{s:7:\"desktop\";s:193:\"#colibri .style-370 {\n  color: #000000;\n}\n#colibri .style-370 p {\n  color: #000000;\n}\n#colibri .style-370 ol {\n  list-style-type: decimal;\n}\n#colibri .style-370 ul {\n  list-style-type: disc;\n}\n\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}i:371;a:3:{s:7:\"desktop\";s:388:\"#colibri .style-371 p,#colibri .style-371  h1,#colibri .style-371  h2,#colibri .style-371  h3,#colibri .style-371  h4,#colibri .style-371  h5,#colibri .style-371  h6 {\n  text-transform: uppercase;\n  letter-spacing: 1px;\n  color: #FFFFFF;\n}\n#colibri .style-371 .text-wrapper-fancy svg path {\n  stroke: #000000;\n  stroke-linejoin: initial;\n  stroke-linecap: initial;\n  stroke-width: 8px;\n}\n\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}i:372;a:3:{s:7:\"desktop\";s:388:\"#colibri .style-372 p,#colibri .style-372  h1,#colibri .style-372  h2,#colibri .style-372  h3,#colibri .style-372  h4,#colibri .style-372  h5,#colibri .style-372  h6 {\n  text-transform: uppercase;\n  letter-spacing: 1px;\n  color: #FFFFFF;\n}\n#colibri .style-372 .text-wrapper-fancy svg path {\n  stroke: #000000;\n  stroke-linejoin: initial;\n  stroke-linecap: initial;\n  stroke-width: 8px;\n}\n\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}i:373;a:3:{s:7:\"desktop\";s:388:\"#colibri .style-373 p,#colibri .style-373  h1,#colibri .style-373  h2,#colibri .style-373  h3,#colibri .style-373  h4,#colibri .style-373  h5,#colibri .style-373  h6 {\n  text-transform: uppercase;\n  letter-spacing: 1px;\n  color: #FFFFFF;\n}\n#colibri .style-373 .text-wrapper-fancy svg path {\n  stroke: #000000;\n  stroke-linejoin: initial;\n  stroke-linecap: initial;\n  stroke-width: 8px;\n}\n\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}i:374;a:3:{s:7:\"desktop\";s:646:\"#colibri .style-374-icon {\n  fill: #FFFFFF;\n  width: 64px ;\n  height: 64px;\n  border-top-width: 2px;\n  border-top-color: #f79007;\n  border-top-style: none;\n  border-top-left-radius: 300px;\n  border-top-right-radius: 300px;\n  border-right-width: 2px;\n  border-right-color: #f79007;\n  border-right-style: none;\n  border-bottom-width: 2px;\n  border-bottom-color: #f79007;\n  border-bottom-style: none;\n  border-bottom-left-radius: 300px;\n  border-bottom-right-radius: 300px;\n  border-left-width: 2px;\n  border-left-color: #f79007;\n  border-left-style: none;\n  padding-top: 11px;\n  padding-right: 11px;\n  padding-bottom: 11px;\n  padding-left: 11px;\n}\n\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}i:375;a:3:{s:7:\"desktop\";s:646:\"#colibri .style-375-icon {\n  fill: #FFFFFF;\n  width: 64px ;\n  height: 64px;\n  border-top-width: 2px;\n  border-top-color: #f79007;\n  border-top-style: none;\n  border-top-left-radius: 300px;\n  border-top-right-radius: 300px;\n  border-right-width: 2px;\n  border-right-color: #f79007;\n  border-right-style: none;\n  border-bottom-width: 2px;\n  border-bottom-color: #f79007;\n  border-bottom-style: none;\n  border-bottom-left-radius: 300px;\n  border-bottom-right-radius: 300px;\n  border-left-width: 2px;\n  border-left-color: #f79007;\n  border-left-style: none;\n  padding-top: 11px;\n  padding-right: 11px;\n  padding-bottom: 11px;\n  padding-left: 11px;\n}\n\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}i:376;a:3:{s:7:\"desktop\";s:646:\"#colibri .style-376-icon {\n  fill: #FFFFFF;\n  width: 64px ;\n  height: 64px;\n  border-top-width: 2px;\n  border-top-color: #f79007;\n  border-top-style: none;\n  border-top-left-radius: 300px;\n  border-top-right-radius: 300px;\n  border-right-width: 2px;\n  border-right-color: #f79007;\n  border-right-style: none;\n  border-bottom-width: 2px;\n  border-bottom-color: #f79007;\n  border-bottom-style: none;\n  border-bottom-left-radius: 300px;\n  border-bottom-right-radius: 300px;\n  border-left-width: 2px;\n  border-left-color: #f79007;\n  border-left-style: none;\n  padding-top: 11px;\n  padding-right: 11px;\n  padding-bottom: 11px;\n  padding-left: 11px;\n}\n\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}i:377;a:3:{s:7:\"desktop\";s:203:\"#colibri .style-377-outer {\n  padding-top: 48px;\n  padding-right: 48px;\n  padding-bottom: 48px;\n  padding-left: 48px;\n}\n#colibri .style-377 {\n  text-align: center;\n  height: auto;\n  min-height: unset;\n}\n\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}i:379;a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}i:380;a:3:{s:7:\"desktop\";s:83:\"#colibri .style-380 {\n  text-align: center;\n  height: auto;\n  min-height: unset;\n}\n\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}i:382;a:3:{s:7:\"desktop\";s:40:\"#colibri .style-382 {\n  height: 50px;\n}\n\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}i:384;a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}i:385;a:3:{s:7:\"desktop\";s:83:\"#colibri .style-385 {\n  text-align: center;\n  height: auto;\n  min-height: unset;\n}\n\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}i:387;a:3:{s:7:\"desktop\";s:422:\"#colibri .style-387 p,#colibri .style-387  h1,#colibri .style-387  h2,#colibri .style-387  h3,#colibri .style-387  h4,#colibri .style-387  h5,#colibri .style-387  h6 {\n  font-size: 1.5em;\n  color: rgb(102, 102, 102);\n  text-shadow: 0px 32px 37px \n        rgba(0,0,0,0.5);\n}\n#colibri .style-387 .text-wrapper-fancy svg path {\n  stroke: #000000;\n  stroke-linejoin: initial;\n  stroke-linecap: initial;\n  stroke-width: 8px;\n}\n\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}i:394;a:3:{s:7:\"desktop\";s:61:\"#colibri .style-394 {\n  height: auto;\n  min-height: unset;\n}\n\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}i:395;a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}i:396;a:3:{s:7:\"desktop\";s:83:\"#colibri .style-396 {\n  text-align: center;\n  height: auto;\n  min-height: unset;\n}\n\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}i:397;a:3:{s:7:\"desktop\";s:861:\"#colibri .style-397-icon {\n  fill: rgb(251, 192, 45);\n  width: 48px ;\n  height: 48px;\n  border-top-width: 2px;\n  border-top-color: rgb(251, 192, 45);\n  border-top-style: solid;\n  border-top-left-radius: 9px;\n  border-top-right-radius: 9px;\n  border-right-width: 2px;\n  border-right-color: rgb(251, 192, 45);\n  border-right-style: solid;\n  border-bottom-width: 2px;\n  border-bottom-color: rgb(251, 192, 45);\n  border-bottom-style: solid;\n  border-bottom-left-radius: 9px;\n  border-bottom-right-radius: 9px;\n  border-left-width: 2px;\n  border-left-color: rgb(251, 192, 45);\n  border-left-style: solid;\n  padding-top: 15px;\n  padding-right: 15px;\n  padding-bottom: 15px;\n  padding-left: 15px;\n}\n#colibri .style-397-icon:hover {\n  fill: #FFFFFF;\n  background-color: rgb(3, 169, 244);\n  background-image: none;\n}\n#colibri .style-397 {\n  transition-duration: 0.5s;\n}\n\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}i:398;a:3:{s:7:\"desktop\";s:346:\"#colibri .style-398 p,#colibri .style-398  h1,#colibri .style-398  h2,#colibri .style-398  h3,#colibri .style-398  h4,#colibri .style-398  h5,#colibri .style-398  h6 {\n  color: rgb(251, 192, 45);\n}\n#colibri .style-398 .text-wrapper-fancy svg path {\n  stroke: #000000;\n  stroke-linejoin: initial;\n  stroke-linecap: initial;\n  stroke-width: 8px;\n}\n\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}i:399;a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}i:400;a:3:{s:7:\"desktop\";s:83:\"#colibri .style-400 {\n  text-align: center;\n  height: auto;\n  min-height: unset;\n}\n\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}i:401;a:3:{s:7:\"desktop\";s:148:\"#colibri .style-401 .text-wrapper-fancy svg path {\n  stroke: #000000;\n  stroke-linejoin: initial;\n  stroke-linecap: initial;\n  stroke-width: 8px;\n}\n\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}i:402;a:3:{s:7:\"desktop\";s:197:\"#colibri .style-402 {\n  font-size: 1.3em;\n}\n#colibri .style-402 p {\n  font-size: 1.3em;\n}\n#colibri .style-402 ol {\n  list-style-type: decimal;\n}\n#colibri .style-402 ul {\n  list-style-type: disc;\n}\n\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}i:404;a:3:{s:7:\"desktop\";s:861:\"#colibri .style-404-icon {\n  fill: rgb(246, 231, 10);\n  width: 48px ;\n  height: 48px;\n  border-top-width: 2px;\n  border-top-color: rgb(246, 231, 10);\n  border-top-style: solid;\n  border-top-left-radius: 9px;\n  border-top-right-radius: 9px;\n  border-right-width: 2px;\n  border-right-color: rgb(246, 231, 10);\n  border-right-style: solid;\n  border-bottom-width: 2px;\n  border-bottom-color: rgb(246, 231, 10);\n  border-bottom-style: solid;\n  border-bottom-left-radius: 9px;\n  border-bottom-right-radius: 9px;\n  border-left-width: 2px;\n  border-left-color: rgb(246, 231, 10);\n  border-left-style: solid;\n  padding-top: 15px;\n  padding-right: 15px;\n  padding-bottom: 15px;\n  padding-left: 15px;\n}\n#colibri .style-404-icon:hover {\n  fill: #FFFFFF;\n  background-color: rgb(3, 169, 244);\n  background-image: none;\n}\n#colibri .style-404 {\n  transition-duration: 0.5s;\n}\n\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}i:405;a:3:{s:7:\"desktop\";s:856:\"#colibri .style-405-icon {\n  fill: rgb(76, 175, 80);\n  width: 48px ;\n  height: 48px;\n  border-top-width: 2px;\n  border-top-color: rgb(76, 175, 80);\n  border-top-style: solid;\n  border-top-left-radius: 9px;\n  border-top-right-radius: 9px;\n  border-right-width: 2px;\n  border-right-color: rgb(76, 175, 80);\n  border-right-style: solid;\n  border-bottom-width: 2px;\n  border-bottom-color: rgb(76, 175, 80);\n  border-bottom-style: solid;\n  border-bottom-left-radius: 9px;\n  border-bottom-right-radius: 9px;\n  border-left-width: 2px;\n  border-left-color: rgb(76, 175, 80);\n  border-left-style: solid;\n  padding-top: 15px;\n  padding-right: 15px;\n  padding-bottom: 15px;\n  padding-left: 15px;\n}\n#colibri .style-405-icon:hover {\n  fill: #FFFFFF;\n  background-color: rgb(3, 169, 244);\n  background-image: none;\n}\n#colibri .style-405 {\n  transition-duration: 0.5s;\n}\n\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}i:406;a:3:{s:7:\"desktop\";s:861:\"#colibri .style-406-icon {\n  fill: rgb(15, 190, 176);\n  width: 48px ;\n  height: 48px;\n  border-top-width: 2px;\n  border-top-color: rgb(15, 190, 176);\n  border-top-style: solid;\n  border-top-left-radius: 9px;\n  border-top-right-radius: 9px;\n  border-right-width: 2px;\n  border-right-color: rgb(15, 190, 176);\n  border-right-style: solid;\n  border-bottom-width: 2px;\n  border-bottom-color: rgb(15, 190, 176);\n  border-bottom-style: solid;\n  border-bottom-left-radius: 9px;\n  border-bottom-right-radius: 9px;\n  border-left-width: 2px;\n  border-left-color: rgb(15, 190, 176);\n  border-left-style: solid;\n  padding-top: 15px;\n  padding-right: 15px;\n  padding-bottom: 15px;\n  padding-left: 15px;\n}\n#colibri .style-406-icon:hover {\n  fill: #FFFFFF;\n  background-color: rgb(3, 169, 244);\n  background-image: none;\n}\n#colibri .style-406 {\n  transition-duration: 0.5s;\n}\n\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}i:407;a:3:{s:7:\"desktop\";s:346:\"#colibri .style-407 p,#colibri .style-407  h1,#colibri .style-407  h2,#colibri .style-407  h3,#colibri .style-407  h4,#colibri .style-407  h5,#colibri .style-407  h6 {\n  color: rgb(246, 231, 10);\n}\n#colibri .style-407 .text-wrapper-fancy svg path {\n  stroke: #000000;\n  stroke-linejoin: initial;\n  stroke-linecap: initial;\n  stroke-width: 8px;\n}\n\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}i:408;a:3:{s:7:\"desktop\";s:345:\"#colibri .style-408 p,#colibri .style-408  h1,#colibri .style-408  h2,#colibri .style-408  h3,#colibri .style-408  h4,#colibri .style-408  h5,#colibri .style-408  h6 {\n  color: rgb(76, 175, 80);\n}\n#colibri .style-408 .text-wrapper-fancy svg path {\n  stroke: #000000;\n  stroke-linejoin: initial;\n  stroke-linecap: initial;\n  stroke-width: 8px;\n}\n\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}i:409;a:3:{s:7:\"desktop\";s:346:\"#colibri .style-409 p,#colibri .style-409  h1,#colibri .style-409  h2,#colibri .style-409  h3,#colibri .style-409  h4,#colibri .style-409  h5,#colibri .style-409  h6 {\n  color: rgb(15, 190, 176);\n}\n#colibri .style-409 .text-wrapper-fancy svg path {\n  stroke: #000000;\n  stroke-linejoin: initial;\n  stroke-linecap: initial;\n  stroke-width: 8px;\n}\n\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}i:411;a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}i:413;a:3:{s:7:\"desktop\";s:83:\"#colibri .style-413 {\n  text-align: center;\n  height: auto;\n  min-height: unset;\n}\n\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}i:414;a:3:{s:7:\"desktop\";s:40:\"#colibri .style-414 {\n  height: 50px;\n}\n\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}i:415;a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}i:416;a:3:{s:7:\"desktop\";s:83:\"#colibri .style-416 {\n  text-align: center;\n  height: auto;\n  min-height: unset;\n}\n\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}i:417;a:3:{s:7:\"desktop\";s:133:\"#colibri .style-417 {\n  height: auto;\n  min-height: unset;\n  background-color: rgba(251, 192, 45, 0.27);\n  background-image: none;\n}\n\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}i:418;a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}i:419;a:3:{s:7:\"desktop\";s:83:\"#colibri .style-419 {\n  text-align: center;\n  height: auto;\n  min-height: unset;\n}\n\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}i:420;a:3:{s:7:\"desktop\";s:802:\"#colibri .style-420-icon {\n  fill: #000000;\n  width: 48px ;\n  height: 48px;\n  border-top-width: 2px;\n  border-top-color: #000000;\n  border-top-style: solid;\n  border-top-left-radius: 9px;\n  border-top-right-radius: 9px;\n  border-right-width: 2px;\n  border-right-color: #000000;\n  border-right-style: solid;\n  border-bottom-width: 2px;\n  border-bottom-color: #000000;\n  border-bottom-style: solid;\n  border-bottom-left-radius: 9px;\n  border-bottom-right-radius: 9px;\n  border-left-width: 2px;\n  border-left-color: #000000;\n  border-left-style: solid;\n  padding-top: 15px;\n  padding-right: 15px;\n  padding-bottom: 15px;\n  padding-left: 15px;\n}\n#colibri .style-420-icon:hover {\n  fill: #FFFFFF;\n  background-color: #03a9f4;\n  background-image: none;\n}\n#colibri .style-420 {\n  transition-duration: 0.5s;\n}\n\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}i:421;a:3:{s:7:\"desktop\";s:148:\"#colibri .style-421 .text-wrapper-fancy svg path {\n  stroke: #000000;\n  stroke-linejoin: initial;\n  stroke-linecap: initial;\n  stroke-width: 8px;\n}\n\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}i:426;a:3:{s:7:\"desktop\";s:347:\"#colibri .style-426 p,#colibri .style-426  h1,#colibri .style-426  h2,#colibri .style-426  h3,#colibri .style-426  h4,#colibri .style-426  h5,#colibri .style-426  h6 {\n  color: rgb(102, 102, 102);\n}\n#colibri .style-426 .text-wrapper-fancy svg path {\n  stroke: #000000;\n  stroke-linejoin: initial;\n  stroke-linecap: initial;\n  stroke-width: 8px;\n}\n\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}i:439;a:3:{s:7:\"desktop\";s:133:\"#colibri .style-439 {\n  height: auto;\n  min-height: unset;\n  background-color: rgba(251, 192, 45, 0.26);\n  background-image: none;\n}\n\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}i:440;a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}i:441;a:3:{s:7:\"desktop\";s:301:\"#colibri .style-441-outer {\n  padding-top: -10px;\n  padding-right: -10px;\n  padding-bottom: -10px;\n  padding-left: -10px;\n}\n#colibri .style-441 {\n  text-align: center;\n  height: auto;\n  min-height: unset;\n  padding-top: -20px;\n  padding-right: -20px;\n  padding-bottom: -20px;\n  padding-left: -20px;\n}\n\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}i:442;a:3:{s:7:\"desktop\";s:802:\"#colibri .style-442-icon {\n  fill: #000000;\n  width: 48px ;\n  height: 48px;\n  border-top-width: 2px;\n  border-top-color: #000000;\n  border-top-style: solid;\n  border-top-left-radius: 9px;\n  border-top-right-radius: 9px;\n  border-right-width: 2px;\n  border-right-color: #000000;\n  border-right-style: solid;\n  border-bottom-width: 2px;\n  border-bottom-color: #000000;\n  border-bottom-style: solid;\n  border-bottom-left-radius: 9px;\n  border-bottom-right-radius: 9px;\n  border-left-width: 2px;\n  border-left-color: #000000;\n  border-left-style: solid;\n  padding-top: 15px;\n  padding-right: 15px;\n  padding-bottom: 15px;\n  padding-left: 15px;\n}\n#colibri .style-442-icon:hover {\n  fill: #FFFFFF;\n  background-color: #03a9f4;\n  background-image: none;\n}\n#colibri .style-442 {\n  transition-duration: 0.5s;\n}\n\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}i:443;a:3:{s:7:\"desktop\";s:148:\"#colibri .style-443 .text-wrapper-fancy svg path {\n  stroke: #000000;\n  stroke-linejoin: initial;\n  stroke-linecap: initial;\n  stroke-width: 8px;\n}\n\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}i:444;a:3:{s:7:\"desktop\";s:61:\"#colibri .style-444 {\n  height: auto;\n  min-height: unset;\n}\n\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}i:445;a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}i:446;a:3:{s:7:\"desktop\";s:83:\"#colibri .style-446 {\n  text-align: center;\n  height: auto;\n  min-height: unset;\n}\n\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}i:447;a:3:{s:7:\"desktop\";s:802:\"#colibri .style-447-icon {\n  fill: #03a9f4;\n  width: 48px ;\n  height: 48px;\n  border-top-width: 2px;\n  border-top-color: #03a9f4;\n  border-top-style: solid;\n  border-top-left-radius: 9px;\n  border-top-right-radius: 9px;\n  border-right-width: 2px;\n  border-right-color: #03a9f4;\n  border-right-style: solid;\n  border-bottom-width: 2px;\n  border-bottom-color: #03a9f4;\n  border-bottom-style: solid;\n  border-bottom-left-radius: 9px;\n  border-bottom-right-radius: 9px;\n  border-left-width: 2px;\n  border-left-color: #03a9f4;\n  border-left-style: solid;\n  padding-top: 15px;\n  padding-right: 15px;\n  padding-bottom: 15px;\n  padding-left: 15px;\n}\n#colibri .style-447-icon:hover {\n  fill: #FFFFFF;\n  background-color: #03a9f4;\n  background-image: none;\n}\n#colibri .style-447 {\n  transition-duration: 0.5s;\n}\n\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}i:448;a:3:{s:7:\"desktop\";s:148:\"#colibri .style-448 .text-wrapper-fancy svg path {\n  stroke: #000000;\n  stroke-linejoin: initial;\n  stroke-linecap: initial;\n  stroke-width: 8px;\n}\n\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}i:449;a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}i:450;a:3:{s:7:\"desktop\";s:83:\"#colibri .style-450 {\n  text-align: center;\n  height: auto;\n  min-height: unset;\n}\n\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}i:463;a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}i:464;a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}i:465;a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}i:466;a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}i:467;a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}i:468;a:3:{s:7:\"desktop\";s:83:\"#colibri .style-468 {\n  text-align: center;\n  height: auto;\n  min-height: unset;\n}\n\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}i:469;a:3:{s:7:\"desktop\";s:148:\"#colibri .style-469 .text-wrapper-fancy svg path {\n  stroke: #000000;\n  stroke-linejoin: initial;\n  stroke-linecap: initial;\n  stroke-width: 8px;\n}\n\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}i:470;a:3:{s:7:\"desktop\";s:107:\"#colibri .style-470 ol {\n  list-style-type: decimal;\n}\n#colibri .style-470 ul {\n  list-style-type: disc;\n}\n\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}i:471;a:3:{s:7:\"desktop\";s:83:\"#colibri .style-471 {\n  text-align: center;\n  height: auto;\n  min-height: unset;\n}\n\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}i:472;a:3:{s:7:\"desktop\";s:176:\"#colibri .style-472 {\n  height: auto;\n  min-height: unset;\n  padding-top: 0px;\n  padding-bottom: 0px;\n}\n#colibri .style-472  > .h-section-grid-container {\n  margin-top: 0px;\n}\n\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:43:\"#colibri .style-472 {\n  margin-top: 0px;\n}\n\";}i:473;a:3:{s:7:\"desktop\";s:79:\"#colibri .style-473 {\n  box-shadow: 0px 4px 10px 2px rgba(74, 74, 74, 0.3) ;\n}\n\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:110:\"#colibri .style-473 {\n  margin-top: 15px;\n  margin-right: 15px;\n  margin-bottom: 15px;\n  margin-left: 15px;\n}\n\";}i:474;a:3:{s:7:\"desktop\";s:469:\"#colibri .style-474 {\n  text-align: center;\n  height: auto;\n  min-height: unset;\n  border-top-width: 0px;\n  border-top-color: rgb(221, 221, 221);\n  border-top-style: solid;\n  border-right-width: 1px;\n  border-right-color: rgb(221, 221, 221);\n  border-right-style: solid;\n  border-bottom-width: 0px;\n  border-bottom-color: rgb(221, 221, 221);\n  border-bottom-style: solid;\n  border-left-width: 0px;\n  border-left-color: rgb(221, 221, 221);\n  border-left-style: solid;\n}\n\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}i:475;a:3:{s:7:\"desktop\";s:654:\"#colibri .style-475-icon {\n  fill: rgb(51, 51, 51);\n  width: 64px ;\n  height: 64px;\n  border-top-width: 2px;\n  border-top-color: #f79007;\n  border-top-style: none;\n  border-top-left-radius: 300px;\n  border-top-right-radius: 300px;\n  border-right-width: 2px;\n  border-right-color: #f79007;\n  border-right-style: none;\n  border-bottom-width: 2px;\n  border-bottom-color: #f79007;\n  border-bottom-style: none;\n  border-bottom-left-radius: 300px;\n  border-bottom-right-radius: 300px;\n  border-left-width: 2px;\n  border-left-color: #f79007;\n  border-left-style: none;\n  padding-top: 11px;\n  padding-right: 11px;\n  padding-bottom: 11px;\n  padding-left: 11px;\n}\n\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}i:476;a:3:{s:7:\"desktop\";s:370:\"#colibri .style-476 p,#colibri .style-476  h1,#colibri .style-476  h2,#colibri .style-476  h3,#colibri .style-476  h4,#colibri .style-476  h5,#colibri .style-476  h6 {\n  text-transform: uppercase;\n  letter-spacing: 1px;\n}\n#colibri .style-476 .text-wrapper-fancy svg path {\n  stroke: #000000;\n  stroke-linejoin: initial;\n  stroke-linecap: initial;\n  stroke-width: 8px;\n}\n\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}i:477;a:3:{s:7:\"desktop\";s:107:\"#colibri .style-477 ol {\n  list-style-type: decimal;\n}\n#colibri .style-477 ul {\n  list-style-type: disc;\n}\n\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}i:478;a:3:{s:7:\"desktop\";s:469:\"#colibri .style-478 {\n  text-align: center;\n  height: auto;\n  min-height: unset;\n  border-top-width: 0px;\n  border-top-color: rgb(221, 221, 221);\n  border-top-style: solid;\n  border-right-width: 0px;\n  border-right-color: rgb(221, 221, 221);\n  border-right-style: solid;\n  border-bottom-width: 0px;\n  border-bottom-color: rgb(221, 221, 221);\n  border-bottom-style: solid;\n  border-left-width: 0px;\n  border-left-color: rgb(221, 221, 221);\n  border-left-style: solid;\n}\n\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}i:479;a:3:{s:7:\"desktop\";s:83:\"#colibri .style-479 {\n  text-align: center;\n  height: auto;\n  min-height: unset;\n}\n\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}i:480;a:3:{s:7:\"desktop\";s:700:\"#colibri .style-480-image {\n  opacity: 1;\n  box-shadow: -18px 17px 35px 2px rgb(0, 21, 15) ;\n}\n#colibri .style-480-caption {\n  margin-top: 10px;\n}\n#colibri .style-480-frameImage {\n  z-index: -1;\n  transform: translateX(10%) translateY(10%);\n  transform-origin: center center 0px;\n  background-color: rgb(0,0,0);\n  height: 100%;\n  width: 100% ;\n  border-top-width: 10px;\n  border-top-color: rgb(0,0,0);\n  border-top-style: none;\n  border-right-width: 10px;\n  border-right-color: rgb(0,0,0);\n  border-right-style: none;\n  border-bottom-width: 10px;\n  border-bottom-color: rgb(0,0,0);\n  border-bottom-style: none;\n  border-left-width: 10px;\n  border-left-color: rgb(0,0,0);\n  border-left-style: none;\n}\n\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}i:486;a:3:{s:7:\"desktop\";s:83:\"#colibri .style-486 {\n  text-align: center;\n  height: auto;\n  min-height: unset;\n}\n\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}i:487;a:3:{s:7:\"desktop\";s:40:\"#colibri .style-487 {\n  height: 50px;\n}\n\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}i:489;a:3:{s:7:\"desktop\";s:413:\"#colibri .style-489 p,#colibri .style-489  h1,#colibri .style-489  h2,#colibri .style-489  h3,#colibri .style-489  h4,#colibri .style-489  h5,#colibri .style-489  h6 {\n  font-weight: 500;\n  text-transform: capitalize;\n  font-size: 45px;\n  color: rgb(162, 94, 5);\n}\n#colibri .style-489 .text-wrapper-fancy svg path {\n  stroke: #000000;\n  stroke-linejoin: initial;\n  stroke-linecap: initial;\n  stroke-width: 8px;\n}\n\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}i:490;a:3:{s:7:\"desktop\";s:383:\"#colibri .style-490 p,#colibri .style-490  h1,#colibri .style-490  h2,#colibri .style-490  h3,#colibri .style-490  h4,#colibri .style-490  h5,#colibri .style-490  h6 {\n  font-weight: 500;\n  font-size: 45px;\n  color: rgb(162, 94, 5);\n}\n#colibri .style-490 .text-wrapper-fancy svg path {\n  stroke: #000000;\n  stroke-linejoin: initial;\n  stroke-linecap: initial;\n  stroke-width: 8px;\n}\n\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}i:491;a:3:{s:7:\"desktop\";s:315:\"#colibri .style-491 {\n  font-weight: 300;\n  font-size: 22px;\n  color: rgb(102, 102, 102);\n  text-align: center;\n}\n#colibri .style-491 p {\n  font-weight: 300;\n  font-size: 22px;\n  color: rgb(102, 102, 102);\n}\n#colibri .style-491 ol {\n  list-style-type: decimal;\n}\n#colibri .style-491 ul {\n  list-style-type: disc;\n}\n\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}i:492;a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}i:494;a:3:{s:7:\"desktop\";s:1176:\"#colibri .style-494-icon {\n  width: 14px;\n  height: 14px;\n  margin-right: 10px;\n  margin-left: 0px;\n}\n#colibri .style-494 {\n  text-align: center;\n  background-color: #f79007;\n  background-image: none;\n  font-family: Open Sans;\n  font-weight: 600;\n  text-transform: uppercase;\n  font-size: 14px;\n  line-height: 1;\n  letter-spacing: 1px;\n  color: #fff;\n  border-top-width: 2px;\n  border-top-style: solid;\n  border-top-left-radius: 5px;\n  border-top-right-radius: 5px;\n  border-right-width: 2px;\n  border-right-style: solid;\n  border-bottom-width: 2px;\n  border-bottom-style: solid;\n  border-bottom-left-radius: 5px;\n  border-bottom-right-radius: 5px;\n  border-left-width: 2px;\n  border-left-style: solid;\n  padding-top: 15px;\n  padding-right: 30px;\n  padding-bottom: 15px;\n  padding-left: 30px;\n}\n#colibri .style-494:hover,#colibri .style-494:focus {\n  background-position: center center;\n  background-size: cover;\n  background-image: linear-gradient(0deg,  #f79007 9%, rgb(77, 45, 2) 95%);\n  background-attachment: scroll;\n  background-repeat: no-repeat;\n}\n#colibri .style-494:active .style-494-icon {\n  width: 14px;\n  height: 14px;\n  margin-right: 10px;\n  margin-left: 0px;\n}\n\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}i:496;a:3:{s:7:\"desktop\";s:511:\"#colibri .style-496-line {\n  width: 25% ;\n  border-top-width: 0px;\n  border-top-style: solid;\n  border-right-width: 0px;\n  border-right-style: solid;\n  border-bottom-width: 3px;\n  border-bottom-color: rgb(247, 179, 89);\n  border-bottom-style: solid;\n  border-left-width: 0px;\n  border-left-style: solid;\n}\n#colibri .style-496-icon {\n  fill: rgba(162, 94, 5, 0.29);\n  width: 50px ;\n  height: 50px;\n  margin-right: 10px;\n  margin-left: 10px;\n}\n#colibri .style-496 {\n  padding-top: 10px;\n  padding-bottom: 10px;\n}\n\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}i:497;a:3:{s:7:\"desktop\";s:40:\"#colibri .style-497 {\n  height: 50px;\n}\n\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}i:498;a:3:{s:7:\"desktop\";s:159:\"#colibri .style-498 {\n  height: auto;\n  min-height: unset;\n  background-color: #F5FAFD;\n  background-image: none;\n  padding-top: 0px;\n  padding-bottom: 0px;\n}\n\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}i:499;a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}i:500;a:3:{s:7:\"desktop\";s:241:\".style-500 > .h-y-container > *:not(:last-child) {\n  margin-bottom: 0px;\n}\n#colibri .style-500 {\n  text-align: center;\n  height: auto;\n  min-height: unset;\n  transform: translateX(0%) translateY(0%);\n  transform-origin: center center 0px;\n}\n\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}i:517;a:3:{s:7:\"desktop\";s:701:\"#colibri .style-517-image {\n  opacity: 0.85;\n  box-shadow: 0px 0px 10px 2px rgba(0,0,0,0.5) ;\n}\n#colibri .style-517-caption {\n  margin-top: 10px;\n}\n#colibri .style-517-frameImage {\n  z-index: -1;\n  transform: translateX(10%) translateY(10%);\n  transform-origin: center center 0px;\n  background-color: rgb(0,0,0);\n  height: 100%;\n  width: 100% ;\n  border-top-width: 10px;\n  border-top-color: rgb(0,0,0);\n  border-top-style: none;\n  border-right-width: 10px;\n  border-right-color: rgb(0,0,0);\n  border-right-style: none;\n  border-bottom-width: 10px;\n  border-bottom-color: rgb(0,0,0);\n  border-bottom-style: none;\n  border-left-width: 10px;\n  border-left-color: rgb(0,0,0);\n  border-left-style: none;\n}\n\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}i:519;a:3:{s:7:\"desktop\";s:629:\"#colibri .style-519 {\n  background-position: center center;\n  background-size: cover;\n  background-image: url(\"http://localhost/wordpress/wp-content/uploads/2024/09/cropped-cropped-fond-logo-karibiea.png\");\n  background-attachment: scroll;\n  background-repeat: no-repeat;\n}\n#colibri .h-navigation_sticky .style-519,#colibri .h-navigation_sticky.style-519 {\n  background-position: center center;\n  background-size: cover;\n  background-image: url(\"http://localhost/wordpress/wp-content/uploads/2024/09/cropped-cropped-cropped-cropped-fond-logo-karibiea-1-1.png\");\n  background-attachment: scroll;\n  background-repeat: no-repeat;\n}\n\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}i:520;a:3:{s:7:\"desktop\";s:199:\"#colibri .style-520-outer {\n  padding-top: 9px;\n  padding-right: 9px;\n  padding-bottom: 9px;\n  padding-left: 9px;\n}\n#colibri .style-520 {\n  text-align: center;\n  height: auto;\n  min-height: unset;\n}\n\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}i:521;a:3:{s:7:\"desktop\";s:93:\"#colibri .style-521 {\n  background-color: rgba(5, 127, 93, 0.8);\n  background-image: none;\n}\n\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}i:522;a:3:{s:7:\"desktop\";s:751:\".style-522 > .h-y-container > *:not(:last-child) {\n  margin-bottom: 28px;\n}\n#colibri .style-522 {\n  text-align: center;\n  height: auto;\n  min-height: unset;\n  border-top-width: 9px;\n  border-top-color: rgb(247, 179, 89);\n  border-top-style: double;\n  border-top-left-radius: 50px;\n  border-top-right-radius: 50px;\n  border-right-width: 9px;\n  border-right-color: rgb(247, 179, 89);\n  border-right-style: double;\n  border-bottom-width: 9px;\n  border-bottom-color: rgb(247, 179, 89);\n  border-bottom-style: double;\n  border-bottom-left-radius: 50px;\n  border-bottom-right-radius: 50px;\n  border-left-width: 9px;\n  border-left-color: rgb(247, 179, 89);\n  border-left-style: double;\n  background-color: rgba(87, 87, 87, 0.46);\n  background-image: none;\n}\n\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}i:523;a:3:{s:7:\"desktop\";s:751:\".style-523 > .h-y-container > *:not(:last-child) {\n  margin-bottom: 28px;\n}\n#colibri .style-523 {\n  text-align: center;\n  height: auto;\n  min-height: unset;\n  border-top-width: 9px;\n  border-top-color: rgb(14, 255, 218);\n  border-top-style: double;\n  border-top-left-radius: 50px;\n  border-top-right-radius: 50px;\n  border-right-width: 9px;\n  border-right-color: rgb(14, 255, 218);\n  border-right-style: double;\n  border-bottom-width: 9px;\n  border-bottom-color: rgb(14, 255, 218);\n  border-bottom-style: double;\n  border-bottom-left-radius: 50px;\n  border-bottom-right-radius: 50px;\n  border-left-width: 9px;\n  border-left-color: rgb(14, 255, 218);\n  border-left-style: double;\n  background-color: rgba(87, 87, 87, 0.46);\n  background-image: none;\n}\n\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}i:524;a:3:{s:7:\"desktop\";s:336:\"#colibri .style-524 p,#colibri .style-524  h1,#colibri .style-524  h2,#colibri .style-524  h3,#colibri .style-524  h4,#colibri .style-524  h5,#colibri .style-524  h6 {\n  color: #FFFFFF;\n}\n#colibri .style-524 .text-wrapper-fancy svg path {\n  stroke: #000000;\n  stroke-linejoin: initial;\n  stroke-linecap: initial;\n  stroke-width: 8px;\n}\n\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}i:525;a:3:{s:7:\"desktop\";s:295:\"#colibri .style-525 {\n  font-style: italic;\n  text-decoration: overline;\n  color: #FFFFFF;\n}\n#colibri .style-525 p {\n  font-style: italic;\n  text-decoration: overline;\n  color: #FFFFFF;\n}\n#colibri .style-525 ol {\n  list-style-type: decimal;\n}\n#colibri .style-525 ul {\n  list-style-type: disc;\n}\n\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}i:526;a:3:{s:7:\"desktop\";s:336:\"#colibri .style-526 p,#colibri .style-526  h1,#colibri .style-526  h2,#colibri .style-526  h3,#colibri .style-526  h4,#colibri .style-526  h5,#colibri .style-526  h6 {\n  color: #FFFFFF;\n}\n#colibri .style-526 .text-wrapper-fancy svg path {\n  stroke: #000000;\n  stroke-linejoin: initial;\n  stroke-linecap: initial;\n  stroke-width: 8px;\n}\n\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}i:528;a:3:{s:7:\"desktop\";s:295:\"#colibri .style-528 {\n  font-style: italic;\n  text-decoration: overline;\n  color: #FFFFFF;\n}\n#colibri .style-528 p {\n  font-style: italic;\n  text-decoration: overline;\n  color: #FFFFFF;\n}\n#colibri .style-528 ol {\n  list-style-type: decimal;\n}\n#colibri .style-528 ul {\n  list-style-type: disc;\n}\n\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}i:536;a:3:{s:7:\"desktop\";s:193:\"#colibri .style-536 {\n  color: #000000;\n}\n#colibri .style-536 p {\n  color: #000000;\n}\n#colibri .style-536 ol {\n  list-style-type: decimal;\n}\n#colibri .style-536 ul {\n  list-style-type: disc;\n}\n\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}i:538;a:3:{s:7:\"desktop\";s:93:\"#colibri .style-538 {\n  background-color: rgba(5, 127, 93, 0.8);\n  background-image: none;\n}\n\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}i:539;a:3:{s:7:\"desktop\";s:83:\"#colibri .style-539 {\n  text-align: center;\n  height: auto;\n  min-height: unset;\n}\n\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}i:540;a:3:{s:7:\"desktop\";s:83:\"#colibri .style-540 {\n  text-align: center;\n  height: auto;\n  min-height: unset;\n}\n\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}i:542;a:3:{s:7:\"desktop\";s:83:\"#colibri .style-542 {\n  text-align: center;\n  height: auto;\n  min-height: unset;\n}\n\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}i:547;a:3:{s:7:\"desktop\";s:340:\"#colibri .style-547 p,#colibri .style-547  h1,#colibri .style-547  h2,#colibri .style-547  h3,#colibri .style-547  h4,#colibri .style-547  h5,#colibri .style-547  h6 {\n  text-align: center;\n}\n#colibri .style-547 .text-wrapper-fancy svg path {\n  stroke: #000000;\n  stroke-linejoin: initial;\n  stroke-linecap: initial;\n  stroke-width: 8px;\n}\n\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}i:548;a:3:{s:7:\"desktop\";s:1344:\"#colibri .style-548 {\n  text-align: center;\n  box-shadow: 0px 0px 10px 2px rgba(0,0,0,0.5) ;\n  border-top-width: 0px;\n  border-top-style: none;\n  border-top-left-radius: 15px;\n  border-top-right-radius: 15px;\n  border-right-width: 0px;\n  border-right-style: none;\n  border-bottom-width: 0px;\n  border-bottom-style: none;\n  border-bottom-left-radius: 15px;\n  border-bottom-right-radius: 15px;\n  border-left-width: 0px;\n  border-left-style: none;\n}\n#colibri .style-548 .h-content-swap__normal {\n  animation-duration: 10000ms;\n  width: 100% ;\n  background-color: rgba(233, 100, 100, 0);\n  background-position: 51.853555451263155% 87.47000325156965%;\n  background-size: cover;\n  background-image: url(\"http://localhost/wordpress/wp-content/uploads/2024/09/cropped-KARIBEACONCIERGERIE.png\");\n  background-attachment: scroll;\n  background-repeat: no-repeat;\n  padding-right: 42px;\n  padding-left: 42px;\n}\n#colibri .style-548 .h-content-swap__hover {\n  animation-duration: 10000ms;\n  background-color: rgba(247, 179, 89, 0.19);\n  background-position: 47.29449505422365% 100%;\n  background-size: contain;\n  background-image: url(\"http://localhost/wordpress/wp-content/uploads/2024/09/cropped-cropped-cropped-cropped-logoKaribea1-1-1-1.png\");\n  background-attachment: scroll;\n  background-repeat: no-repeat;\n  padding-right: 6px;\n  padding-left: 6px;\n}\n\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}i:549;a:3:{s:7:\"desktop\";s:67:\"#colibri .style-549 {\n  min-height: 200px;\n  text-align: center;\n}\n\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}i:551;a:3:{s:7:\"desktop\";s:101:\"#colibri .style-551 {\n  height: 100%;\n  width: 100% ;\n  top: 0%;\n  left: 0%;\n  text-align: center;\n}\n\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}i:552;a:3:{s:7:\"desktop\";s:41:\"#colibri .style-552 {\n  height: 200px;\n}\n\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}i:553;a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}i:554;a:3:{s:7:\"desktop\";s:83:\"#colibri .style-554 {\n  text-align: center;\n  height: auto;\n  min-height: unset;\n}\n\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}i:557;a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}i:558;a:3:{s:7:\"desktop\";s:1457:\"#colibri .style-558-icon {\n  width: 12px;\n  height: 12px;\n  margin-right: 10px;\n  margin-left: 0px;\n}\n#colibri .style-558 {\n  text-align: center;\n  background-color: #f79007;\n  background-image: none;\n  font-family: Open Sans;\n  font-weight: 600;\n  text-transform: uppercase;\n  font-size: 14px;\n  line-height: 1;\n  letter-spacing: 1px;\n  color: #fff;\n  border-top-width: 2px;\n  border-top-color: #03a9f4;\n  border-top-style: solid;\n  border-top-left-radius: 5px;\n  border-top-right-radius: 5px;\n  border-right-width: 2px;\n  border-right-color: #03a9f4;\n  border-right-style: solid;\n  border-bottom-width: 2px;\n  border-bottom-color: #03a9f4;\n  border-bottom-style: solid;\n  border-bottom-left-radius: 5px;\n  border-bottom-right-radius: 5px;\n  border-left-width: 2px;\n  border-left-color: #03a9f4;\n  border-left-style: solid;\n  padding-top: 12px;\n  padding-right: 24px;\n  padding-bottom: 12px;\n  padding-left: 24px;\n}\n#colibri .style-558:hover,#colibri .style-558:focus {\n  background-position: center center;\n  background-size: cover;\n  background-image: linear-gradient(0deg,  #f79007 0%, rgb(77, 45, 2) 100%);\n  background-attachment: scroll;\n  background-repeat: no-repeat;\n  border-top-color: rgb(2, 110, 159);\n  border-right-color: rgb(2, 110, 159);\n  border-bottom-color: rgb(2, 110, 159);\n  border-left-color: rgb(2, 110, 159);\n}\n#colibri .style-558:active .style-558-icon {\n  width: 12px;\n  height: 12px;\n  margin-right: 10px;\n  margin-left: 0px;\n}\n\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}i:559;a:3:{s:7:\"desktop\";s:257:\"#colibri .style-559 {\n  background-position: center center;\n  background-size: cover;\n  background-image: url(\"http://localhost/wordpress/wp-content/uploads/2024/10/colibri-image-600.png\");\n  background-attachment: scroll;\n  background-repeat: no-repeat;\n}\n\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}i:560;a:3:{s:7:\"desktop\";s:636:\"#colibri .style-560 {\n  text-align: center;\n  height: auto;\n  min-height: unset;\n  background-color: rgba(247, 144, 7, 0.75);\n  background-image: none;\n  border-top-width: 2px;\n  border-top-color: #f79007;\n  border-top-style: dotted;\n  border-top-left-radius: 20px;\n  border-top-right-radius: 20px;\n  border-right-width: 2px;\n  border-right-color: #f79007;\n  border-right-style: dotted;\n  border-bottom-width: 2px;\n  border-bottom-color: #f79007;\n  border-bottom-style: dotted;\n  border-bottom-left-radius: 20px;\n  border-bottom-right-radius: 20px;\n  border-left-width: 2px;\n  border-left-color: #f79007;\n  border-left-style: dotted;\n}\n\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}i:561;a:3:{s:7:\"desktop\";s:676:\"#colibri .style-561 {\n  text-align: center;\n  height: auto;\n  min-height: unset;\n  background-color: rgba(248, 232, 2, 0.75);\n  background-image: none;\n  border-top-width: 2px;\n  border-top-color: rgb(238, 224, 16);\n  border-top-style: dotted;\n  border-top-left-radius: 20px;\n  border-top-right-radius: 20px;\n  border-right-width: 2px;\n  border-right-color: rgb(238, 224, 16);\n  border-right-style: dotted;\n  border-bottom-width: 2px;\n  border-bottom-color: rgb(238, 224, 16);\n  border-bottom-style: dotted;\n  border-bottom-left-radius: 20px;\n  border-bottom-right-radius: 20px;\n  border-left-width: 2px;\n  border-left-color: rgb(238, 224, 16);\n  border-left-style: dotted;\n}\n\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}i:562;a:3:{s:7:\"desktop\";s:676:\"#colibri .style-562 {\n  text-align: center;\n  height: auto;\n  min-height: unset;\n  border-top-width: 2px;\n  border-top-color: rgb(13, 215, 240);\n  border-top-style: dotted;\n  border-top-left-radius: 20px;\n  border-top-right-radius: 20px;\n  border-right-width: 2px;\n  border-right-color: rgb(13, 215, 240);\n  border-right-style: dotted;\n  border-bottom-width: 2px;\n  border-bottom-color: rgb(13, 215, 240);\n  border-bottom-style: dotted;\n  border-bottom-left-radius: 20px;\n  border-bottom-right-radius: 20px;\n  border-left-width: 2px;\n  border-left-color: rgb(13, 215, 240);\n  border-left-style: dotted;\n  background-color: rgba(1, 207, 227, 0.75);\n  background-image: none;\n}\n\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}i:578;a:3:{s:7:\"desktop\";s:460:\"#colibri .style-578 p,#colibri .style-578  h1,#colibri .style-578  h2,#colibri .style-578  h3,#colibri .style-578  h4,#colibri .style-578  h5,#colibri .style-578  h6 {\n  font-family: Alike Angular;\n  font-weight: 400;\n  font-size: 3.1em;\n  color: #FFFFFF;\n  text-shadow: 0px 0px 10px \n        rgba(0,0,0,0.5);\n}\n#colibri .style-578 .text-wrapper-fancy svg path {\n  stroke: #000000;\n  stroke-linejoin: initial;\n  stroke-linecap: initial;\n  stroke-width: 8px;\n}\n\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}i:579;a:3:{s:7:\"desktop\";s:460:\"#colibri .style-579 p,#colibri .style-579  h1,#colibri .style-579  h2,#colibri .style-579  h3,#colibri .style-579  h4,#colibri .style-579  h5,#colibri .style-579  h6 {\n  text-shadow: 0px 0px 10px \n        rgba(0,0,0,0.5);\n  font-family: Alike Angular;\n  font-weight: 400;\n  font-size: 3.1em;\n  color: #FFFFFF;\n}\n#colibri .style-579 .text-wrapper-fancy svg path {\n  stroke: #000000;\n  stroke-linejoin: initial;\n  stroke-linecap: initial;\n  stroke-width: 8px;\n}\n\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}i:580;a:3:{s:7:\"desktop\";s:460:\"#colibri .style-580 p,#colibri .style-580  h1,#colibri .style-580  h2,#colibri .style-580  h3,#colibri .style-580  h4,#colibri .style-580  h5,#colibri .style-580  h6 {\n  text-shadow: 0px 0px 10px \n        rgba(0,0,0,0.5);\n  font-family: Alike Angular;\n  font-weight: 400;\n  font-size: 3.1em;\n  color: #FFFFFF;\n}\n#colibri .style-580 .text-wrapper-fancy svg path {\n  stroke: #000000;\n  stroke-linejoin: initial;\n  stroke-linecap: initial;\n  stroke-width: 8px;\n}\n\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}i:583;a:3:{s:7:\"desktop\";s:235:\"#colibri .style-583 {\n  text-align: left;\n  text-decoration: overline;\n}\n#colibri .style-583 p {\n  text-decoration: overline;\n}\n#colibri .style-583 ol {\n  list-style-type: decimal;\n}\n#colibri .style-583 ul {\n  list-style-type: disc;\n}\n\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}i:584;a:3:{s:7:\"desktop\";s:235:\"#colibri .style-584 {\n  text-align: left;\n  text-decoration: overline;\n}\n#colibri .style-584 p {\n  text-decoration: overline;\n}\n#colibri .style-584 ol {\n  list-style-type: decimal;\n}\n#colibri .style-584 ul {\n  list-style-type: disc;\n}\n\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}i:585;a:3:{s:7:\"desktop\";s:214:\"#colibri .style-585 {\n  text-align: right;\n  color: #FFFFFF;\n}\n#colibri .style-585 p {\n  color: #FFFFFF;\n}\n#colibri .style-585 ol {\n  list-style-type: decimal;\n}\n#colibri .style-585 ul {\n  list-style-type: disc;\n}\n\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}i:586;a:3:{s:7:\"desktop\";s:214:\"#colibri .style-586 {\n  text-align: right;\n  color: #FFFFFF;\n}\n#colibri .style-586 p {\n  color: #FFFFFF;\n}\n#colibri .style-586 ol {\n  list-style-type: decimal;\n}\n#colibri .style-586 ul {\n  list-style-type: disc;\n}\n\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}i:587;a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}i:588;a:3:{s:7:\"desktop\";s:83:\"#colibri .style-588 {\n  text-align: center;\n  height: auto;\n  min-height: unset;\n}\n\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}i:589;a:3:{s:7:\"desktop\";s:83:\"#colibri .style-589 {\n  text-align: center;\n  height: auto;\n  min-height: unset;\n}\n\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}i:590;a:3:{s:7:\"desktop\";s:235:\"#colibri .style-590 {\n  text-align: left;\n  text-decoration: overline;\n}\n#colibri .style-590 p {\n  text-decoration: overline;\n}\n#colibri .style-590 ol {\n  list-style-type: decimal;\n}\n#colibri .style-590 ul {\n  list-style-type: disc;\n}\n\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}i:594;a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}i:595;a:3:{s:7:\"desktop\";s:83:\"#colibri .style-595 {\n  text-align: center;\n  height: auto;\n  min-height: unset;\n}\n\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}i:596;a:3:{s:7:\"desktop\";s:83:\"#colibri .style-596 {\n  text-align: center;\n  height: auto;\n  min-height: unset;\n}\n\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}i:597;a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}i:598;a:3:{s:7:\"desktop\";s:83:\"#colibri .style-598 {\n  text-align: center;\n  height: auto;\n  min-height: unset;\n}\n\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}i:599;a:3:{s:7:\"desktop\";s:83:\"#colibri .style-599 {\n  text-align: center;\n  height: auto;\n  min-height: unset;\n}\n\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}i:604;a:3:{s:7:\"desktop\";s:214:\"#colibri .style-604 {\n  text-align: right;\n  color: #FFFFFF;\n}\n#colibri .style-604 p {\n  color: #FFFFFF;\n}\n#colibri .style-604 ol {\n  list-style-type: decimal;\n}\n#colibri .style-604 ul {\n  list-style-type: disc;\n}\n\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}i:605;a:3:{s:7:\"desktop\";s:151:\"#colibri .style-605 {\n  text-align: left;\n}\n#colibri .style-605 ol {\n  list-style-type: decimal;\n}\n#colibri .style-605 ul {\n  list-style-type: disc;\n}\n\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}i:606;a:3:{s:7:\"desktop\";s:152:\"#colibri .style-606 {\n  text-align: right;\n}\n#colibri .style-606 ol {\n  list-style-type: decimal;\n}\n#colibri .style-606 ul {\n  list-style-type: disc;\n}\n\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}i:607;a:3:{s:7:\"desktop\";s:151:\"#colibri .style-607 {\n  text-align: left;\n}\n#colibri .style-607 ol {\n  list-style-type: decimal;\n}\n#colibri .style-607 ul {\n  list-style-type: disc;\n}\n\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}i:608;a:3:{s:7:\"desktop\";s:482:\"#colibri .style-608-line {\n  width: 58% ;\n  border-top-width: 0px;\n  border-top-style: solid;\n  border-right-width: 0px;\n  border-right-style: solid;\n  border-bottom-width: 2px;\n  border-bottom-color: #FFFFFF;\n  border-bottom-style: solid;\n  border-left-width: 0px;\n  border-left-style: solid;\n}\n#colibri .style-608-icon {\n  fill: black;\n  width: 50px ;\n  height: 50px;\n  margin-right: 10px;\n  margin-left: 10px;\n}\n#colibri .style-608 {\n  padding-top: 0px;\n  padding-bottom: 0px;\n}\n\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}i:609;a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}i:610;a:3:{s:7:\"desktop\";s:83:\"#colibri .style-610 {\n  text-align: center;\n  height: auto;\n  min-height: unset;\n}\n\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}i:611;a:3:{s:7:\"desktop\";s:439:\"#colibri .style-611 p,#colibri .style-611  h1,#colibri .style-611  h2,#colibri .style-611  h3,#colibri .style-611  h4,#colibri .style-611  h5,#colibri .style-611  h6 {\n  font-family: Open Sans;\n  font-weight: 400;\n  font-style: normal;\n  text-transform: uppercase;\n  letter-spacing: 10px;\n}\n#colibri .style-611 .text-wrapper-fancy svg path {\n  stroke: #000000;\n  stroke-linejoin: initial;\n  stroke-linecap: initial;\n  stroke-width: 8px;\n}\n\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}i:612;a:3:{s:7:\"desktop\";s:482:\"#colibri .style-612-line {\n  width: 58% ;\n  border-top-width: 0px;\n  border-top-style: solid;\n  border-right-width: 0px;\n  border-right-style: solid;\n  border-bottom-width: 2px;\n  border-bottom-color: #FFFFFF;\n  border-bottom-style: solid;\n  border-left-width: 0px;\n  border-left-style: solid;\n}\n#colibri .style-612-icon {\n  fill: black;\n  width: 50px ;\n  height: 50px;\n  margin-right: 10px;\n  margin-left: 10px;\n}\n#colibri .style-612 {\n  padding-top: 0px;\n  padding-bottom: 0px;\n}\n\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}i:613;a:3:{s:7:\"desktop\";s:482:\"#colibri .style-613-line {\n  width: 58% ;\n  border-top-width: 0px;\n  border-top-style: solid;\n  border-right-width: 0px;\n  border-right-style: solid;\n  border-bottom-width: 2px;\n  border-bottom-color: #FFFFFF;\n  border-bottom-style: solid;\n  border-left-width: 0px;\n  border-left-style: solid;\n}\n#colibri .style-613-icon {\n  fill: black;\n  width: 50px ;\n  height: 50px;\n  margin-right: 10px;\n  margin-left: 10px;\n}\n#colibri .style-613 {\n  padding-top: 0px;\n  padding-bottom: 0px;\n}\n\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}i:614;a:3:{s:7:\"desktop\";s:743:\"#colibri .style-614 {\n  text-align: center;\n  border-top-width: 0px;\n  border-top-style: none;\n  border-top-left-radius: 16px;\n  border-top-right-radius: 16px;\n  border-right-width: 0px;\n  border-right-style: none;\n  border-bottom-width: 0px;\n  border-bottom-style: none;\n  border-bottom-left-radius: 16px;\n  border-bottom-right-radius: 16px;\n  border-left-width: 0px;\n  border-left-style: none;\n  box-shadow: 0px 0px 10px 2px rgba(0,0,0,0.5) ;\n}\n#colibri .style-614 .h-content-swap__normal {\n  animation-duration: 1000ms;\n  width: 100% ;\n  background-color: rgba(233, 100, 100, 0);\n  background-image: none;\n}\n#colibri .style-614 .h-content-swap__hover {\n  animation-duration: 1000ms;\n  background-color: #f79007;\n  background-image: none;\n}\n\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}i:615;a:3:{s:7:\"desktop\";s:143:\".style-615 > .h-y-container > *:not(:last-child) {\n  margin-bottom: 21px;\n}\n#colibri .style-615 {\n  min-height: 137px;\n  text-align: center;\n}\n\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}i:617;a:3:{s:7:\"desktop\";s:101:\"#colibri .style-617 {\n  height: 100%;\n  width: 100% ;\n  top: 0%;\n  left: 0%;\n  text-align: center;\n}\n\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}i:621;a:3:{s:7:\"desktop\";s:358:\"#colibri .style-621 p,#colibri .style-621  h1,#colibri .style-621  h2,#colibri .style-621  h3,#colibri .style-621  h4,#colibri .style-621  h5,#colibri .style-621  h6 {\n  text-align: center;\n  color: #FFFFFF;\n}\n#colibri .style-621 .text-wrapper-fancy svg path {\n  stroke: #000000;\n  stroke-linejoin: initial;\n  stroke-linecap: initial;\n  stroke-width: 8px;\n}\n\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}i:622;a:3:{s:7:\"desktop\";s:347:\"#colibri .style-622 p,#colibri .style-622  h1,#colibri .style-622  h2,#colibri .style-622  h3,#colibri .style-622  h4,#colibri .style-622  h5,#colibri .style-622  h6 {\n  color: rgb(102, 102, 102);\n}\n#colibri .style-622 .text-wrapper-fancy svg path {\n  stroke: #000000;\n  stroke-linejoin: initial;\n  stroke-linecap: initial;\n  stroke-width: 8px;\n}\n\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}i:639;a:3:{s:7:\"desktop\";s:1532:\"#colibri .style-639 {\n  text-align: center;\n  box-shadow: 0px 0px 10px 2px rgba(0,0,0,0.5) ;\n  border-top-width: 2px;\n  border-top-color: rgba(0, 0, 0, 0);\n  border-top-style: solid;\n  border-top-left-radius: 20px;\n  border-top-right-radius: 20px;\n  border-right-width: 2px;\n  border-right-color: rgba(0, 0, 0, 0);\n  border-right-style: solid;\n  border-bottom-width: 2px;\n  border-bottom-color: rgba(0, 0, 0, 0);\n  border-bottom-style: solid;\n  border-bottom-left-radius: 20px;\n  border-bottom-right-radius: 20px;\n  border-left-width: 2px;\n  border-left-color: rgba(0, 0, 0, 0);\n  border-left-style: solid;\n}\n#colibri .style-639 .h-content-swap__normal {\n  animation-duration: 1000ms;\n  width: 100% ;\n  background-color: rgba(3, 169, 244, 0.01);\n  background-image: none;\n  color: #FFFFFF;\n  padding-right: 2px;\n  padding-left: 2px;\n}\n#colibri .style-639 .h-content-swap__normal h1 {\n  color: rgb(102, 102, 102);\n}\n#colibri .style-639 .h-content-swap__normal h2 {\n  color: rgb(102, 102, 102);\n}\n#colibri .style-639 .h-content-swap__normal h3 {\n  color: rgb(102, 102, 102);\n}\n#colibri .style-639 .h-content-swap__normal h4 {\n  color: rgb(102, 102, 102);\n}\n#colibri .style-639 .h-content-swap__normal h5 {\n  color: rgb(102, 102, 102);\n}\n#colibri .style-639 .h-content-swap__normal h6 {\n  color: rgb(102, 102, 102);\n}\n#colibri .style-639 .h-content-swap__normal p {\n  color: #FFFFFF;\n}\n#colibri .style-639 .h-content-swap__hover {\n  animation-duration: 1000ms;\n  background-color: rgba(243, 231, 42, 0.99);\n  background-image: none;\n}\n\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}i:640;a:3:{s:7:\"desktop\";s:143:\".style-640 > .h-y-container > *:not(:last-child) {\n  margin-bottom: 21px;\n}\n#colibri .style-640 {\n  min-height: 137px;\n  text-align: center;\n}\n\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}i:643;a:3:{s:7:\"desktop\";s:177:\".style-643 > .h-y-container > *:not(:last-child) {\n  margin-bottom: 21px;\n}\n#colibri .style-643 {\n  height: 100%;\n  width: 100% ;\n  top: 0%;\n  left: 0%;\n  text-align: center;\n}\n\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}i:646;a:3:{s:7:\"desktop\";s:369:\"#colibri .style-646 p,#colibri .style-646  h1,#colibri .style-646  h2,#colibri .style-646  h3,#colibri .style-646  h4,#colibri .style-646  h5,#colibri .style-646  h6 {\n  text-align: center;\n  color: rgb(102, 102, 102);\n}\n#colibri .style-646 .text-wrapper-fancy svg path {\n  stroke: #000000;\n  stroke-linejoin: initial;\n  stroke-linecap: initial;\n  stroke-width: 8px;\n}\n\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}i:647;a:3:{s:7:\"desktop\";s:336:\"#colibri .style-647 p,#colibri .style-647  h1,#colibri .style-647  h2,#colibri .style-647  h3,#colibri .style-647  h4,#colibri .style-647  h5,#colibri .style-647  h6 {\n  color: #FFFFFF;\n}\n#colibri .style-647 .text-wrapper-fancy svg path {\n  stroke: #000000;\n  stroke-linejoin: initial;\n  stroke-linecap: initial;\n  stroke-width: 8px;\n}\n\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}i:648;a:3:{s:7:\"desktop\";s:1546:\"#colibri .style-648 {\n  text-align: center;\n  box-shadow: 0px 0px 10px 2px rgba(0,0,0,0.5) ;\n  border-top-width: 2px;\n  border-top-color: rgba(0, 0, 0, 0);\n  border-top-style: solid;\n  border-top-left-radius: 20px;\n  border-top-right-radius: 20px;\n  border-right-width: 2px;\n  border-right-color: rgba(0, 0, 0, 0);\n  border-right-style: solid;\n  border-bottom-width: 2px;\n  border-bottom-color: rgba(0, 0, 0, 0);\n  border-bottom-style: solid;\n  border-bottom-left-radius: 20px;\n  border-bottom-right-radius: 20px;\n  border-left-width: 2px;\n  border-left-color: rgba(0, 0, 0, 0);\n  border-left-style: solid;\n}\n#colibri .style-648 .h-content-swap__normal {\n  animation-duration: 1000ms;\n  width: 100% ;\n  background-color: rgba(3, 169, 244, 0);\n  background-image: none;\n  color: rgb(102, 102, 102);\n  padding-right: .0px;\n  padding-left: .0px;\n}\n#colibri .style-648 .h-content-swap__normal h1 {\n  color: rgb(102, 102, 102);\n}\n#colibri .style-648 .h-content-swap__normal h2 {\n  color: rgb(102, 102, 102);\n}\n#colibri .style-648 .h-content-swap__normal h3 {\n  color: rgb(102, 102, 102);\n}\n#colibri .style-648 .h-content-swap__normal h4 {\n  color: rgb(102, 102, 102);\n}\n#colibri .style-648 .h-content-swap__normal h5 {\n  color: rgb(102, 102, 102);\n}\n#colibri .style-648 .h-content-swap__normal h6 {\n  color: rgb(102, 102, 102);\n}\n#colibri .style-648 .h-content-swap__normal p {\n  color: rgb(102, 102, 102);\n}\n#colibri .style-648 .h-content-swap__hover {\n  animation-duration: 1000ms;\n  background-color: rgb(14, 154, 217);\n  background-image: none;\n}\n\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}i:649;a:3:{s:7:\"desktop\";s:143:\".style-649 > .h-y-container > *:not(:last-child) {\n  margin-bottom: 21px;\n}\n#colibri .style-649 {\n  min-height: 137px;\n  text-align: center;\n}\n\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}i:652;a:3:{s:7:\"desktop\";s:101:\"#colibri .style-652 {\n  height: 100%;\n  width: 100% ;\n  top: 0%;\n  left: 0%;\n  text-align: center;\n}\n\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}i:655;a:3:{s:7:\"desktop\";s:336:\"#colibri .style-655 p,#colibri .style-655  h1,#colibri .style-655  h2,#colibri .style-655  h3,#colibri .style-655  h4,#colibri .style-655  h5,#colibri .style-655  h6 {\n  color: #FFFFFF;\n}\n#colibri .style-655 .text-wrapper-fancy svg path {\n  stroke: #000000;\n  stroke-linejoin: initial;\n  stroke-linecap: initial;\n  stroke-width: 8px;\n}\n\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}i:657;a:3:{s:7:\"desktop\";s:347:\"#colibri .style-657 p,#colibri .style-657  h1,#colibri .style-657  h2,#colibri .style-657  h3,#colibri .style-657  h4,#colibri .style-657  h5,#colibri .style-657  h6 {\n  color: rgb(102, 102, 102);\n}\n#colibri .style-657 .text-wrapper-fancy svg path {\n  stroke: #000000;\n  stroke-linejoin: initial;\n  stroke-linecap: initial;\n  stroke-width: 8px;\n}\n\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}i:658;a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}i:659;a:3:{s:7:\"desktop\";s:231:\"#colibri .style-659 {\n  height: auto;\n  min-height: unset;\n  padding-top: 7px;\n  padding-bottom: 0px;\n  background-color: #F5FAFD;\n  background-image: none;\n}\n#colibri .style-659  > .h-section-grid-container {\n  margin-top: 0px;\n}\n\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:43:\"#colibri .style-659 {\n  margin-top: 0px;\n}\n\";}i:660;a:3:{s:7:\"desktop\";s:134:\"#colibri .style-660 {\n  box-shadow: 0px 4px 10px 2px rgba(74, 74, 74, 0.3) ;\n  background-color: #FFFFFF;\n  background-image: none;\n}\n\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:110:\"#colibri .style-660 {\n  margin-top: 15px;\n  margin-right: 15px;\n  margin-bottom: 15px;\n  margin-left: 15px;\n}\n\";}i:661;a:3:{s:7:\"desktop\";s:469:\"#colibri .style-661 {\n  text-align: center;\n  height: auto;\n  min-height: unset;\n  border-top-width: 0px;\n  border-top-color: rgb(221, 221, 221);\n  border-top-style: solid;\n  border-right-width: 1px;\n  border-right-color: rgb(221, 221, 221);\n  border-right-style: solid;\n  border-bottom-width: 0px;\n  border-bottom-color: rgb(221, 221, 221);\n  border-bottom-style: solid;\n  border-left-width: 1px;\n  border-left-color: rgb(221, 221, 221);\n  border-left-style: solid;\n}\n\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}i:662;a:3:{s:7:\"desktop\";s:654:\"#colibri .style-662-icon {\n  fill: rgb(51, 51, 51);\n  width: 64px ;\n  height: 64px;\n  border-top-width: 2px;\n  border-top-color: #f79007;\n  border-top-style: none;\n  border-top-left-radius: 300px;\n  border-top-right-radius: 300px;\n  border-right-width: 2px;\n  border-right-color: #f79007;\n  border-right-style: none;\n  border-bottom-width: 2px;\n  border-bottom-color: #f79007;\n  border-bottom-style: none;\n  border-bottom-left-radius: 300px;\n  border-bottom-right-radius: 300px;\n  border-left-width: 2px;\n  border-left-color: #f79007;\n  border-left-style: none;\n  padding-top: 11px;\n  padding-right: 11px;\n  padding-bottom: 11px;\n  padding-left: 11px;\n}\n\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}i:663;a:3:{s:7:\"desktop\";s:370:\"#colibri .style-663 p,#colibri .style-663  h1,#colibri .style-663  h2,#colibri .style-663  h3,#colibri .style-663  h4,#colibri .style-663  h5,#colibri .style-663  h6 {\n  text-transform: uppercase;\n  letter-spacing: 1px;\n}\n#colibri .style-663 .text-wrapper-fancy svg path {\n  stroke: #000000;\n  stroke-linejoin: initial;\n  stroke-linecap: initial;\n  stroke-width: 8px;\n}\n\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}i:664;a:3:{s:7:\"desktop\";s:107:\"#colibri .style-664 ol {\n  list-style-type: decimal;\n}\n#colibri .style-664 ul {\n  list-style-type: disc;\n}\n\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}i:665;a:3:{s:7:\"desktop\";s:469:\"#colibri .style-665 {\n  text-align: center;\n  height: auto;\n  min-height: unset;\n  border-top-width: 0px;\n  border-top-color: rgb(221, 221, 221);\n  border-top-style: solid;\n  border-right-width: 0px;\n  border-right-color: rgb(221, 221, 221);\n  border-right-style: solid;\n  border-bottom-width: 0px;\n  border-bottom-color: rgb(221, 221, 221);\n  border-bottom-style: solid;\n  border-left-width: 0px;\n  border-left-color: rgb(221, 221, 221);\n  border-left-style: solid;\n}\n\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}i:666;a:3:{s:7:\"desktop\";s:176:\"#colibri .style-666 {\n  height: auto;\n  min-height: unset;\n  padding-top: 0px;\n  padding-bottom: 0px;\n}\n#colibri .style-666  > .h-section-grid-container {\n  margin-top: 0px;\n}\n\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:43:\"#colibri .style-666 {\n  margin-top: 0px;\n}\n\";}i:667;a:3:{s:7:\"desktop\";s:134:\"#colibri .style-667 {\n  box-shadow: 0px 4px 10px 2px rgba(74, 74, 74, 0.3) ;\n  background-color: #FFFFFF;\n  background-image: none;\n}\n\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:110:\"#colibri .style-667 {\n  margin-top: 15px;\n  margin-right: 15px;\n  margin-bottom: 15px;\n  margin-left: 15px;\n}\n\";}i:668;a:3:{s:7:\"desktop\";s:469:\"#colibri .style-668 {\n  text-align: center;\n  height: auto;\n  min-height: unset;\n  border-top-width: 0px;\n  border-top-color: rgb(221, 221, 221);\n  border-top-style: solid;\n  border-right-width: 1px;\n  border-right-color: rgb(221, 221, 221);\n  border-right-style: solid;\n  border-bottom-width: 0px;\n  border-bottom-color: rgb(221, 221, 221);\n  border-bottom-style: solid;\n  border-left-width: 0px;\n  border-left-color: rgb(221, 221, 221);\n  border-left-style: solid;\n}\n\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}i:669;a:3:{s:7:\"desktop\";s:654:\"#colibri .style-669-icon {\n  fill: rgb(51, 51, 51);\n  width: 64px ;\n  height: 64px;\n  border-top-width: 2px;\n  border-top-color: #f79007;\n  border-top-style: none;\n  border-top-left-radius: 300px;\n  border-top-right-radius: 300px;\n  border-right-width: 2px;\n  border-right-color: #f79007;\n  border-right-style: none;\n  border-bottom-width: 2px;\n  border-bottom-color: #f79007;\n  border-bottom-style: none;\n  border-bottom-left-radius: 300px;\n  border-bottom-right-radius: 300px;\n  border-left-width: 2px;\n  border-left-color: #f79007;\n  border-left-style: none;\n  padding-top: 11px;\n  padding-right: 11px;\n  padding-bottom: 11px;\n  padding-left: 11px;\n}\n\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}i:670;a:3:{s:7:\"desktop\";s:370:\"#colibri .style-670 p,#colibri .style-670  h1,#colibri .style-670  h2,#colibri .style-670  h3,#colibri .style-670  h4,#colibri .style-670  h5,#colibri .style-670  h6 {\n  text-transform: uppercase;\n  letter-spacing: 1px;\n}\n#colibri .style-670 .text-wrapper-fancy svg path {\n  stroke: #000000;\n  stroke-linejoin: initial;\n  stroke-linecap: initial;\n  stroke-width: 8px;\n}\n\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}i:671;a:3:{s:7:\"desktop\";s:107:\"#colibri .style-671 ol {\n  list-style-type: decimal;\n}\n#colibri .style-671 ul {\n  list-style-type: disc;\n}\n\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}i:672;a:3:{s:7:\"desktop\";s:469:\"#colibri .style-672 {\n  text-align: center;\n  height: auto;\n  min-height: unset;\n  border-top-width: 0px;\n  border-top-color: rgb(221, 221, 221);\n  border-top-style: solid;\n  border-right-width: 0px;\n  border-right-color: rgb(221, 221, 221);\n  border-right-style: solid;\n  border-bottom-width: 0px;\n  border-bottom-color: rgb(221, 221, 221);\n  border-bottom-style: solid;\n  border-left-width: 0px;\n  border-left-color: rgb(221, 221, 221);\n  border-left-style: solid;\n}\n\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}i:673;a:3:{s:7:\"desktop\";s:61:\"#colibri .style-673 {\n  height: auto;\n  min-height: unset;\n}\n\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}i:674;a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}i:675;a:3:{s:7:\"desktop\";s:82:\"#colibri .style-675 {\n  text-align: right;\n  height: auto;\n  min-height: unset;\n}\n\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:46:\"#colibri .style-675 {\n  text-align: center;\n}\n\";}i:676;a:3:{s:7:\"desktop\";s:148:\"#colibri .style-676 .text-wrapper-fancy svg path {\n  stroke: #000000;\n  stroke-linejoin: initial;\n  stroke-linecap: initial;\n  stroke-width: 8px;\n}\n\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}i:677;a:3:{s:7:\"desktop\";s:148:\"#colibri .style-677 .text-wrapper-fancy svg path {\n  stroke: #000000;\n  stroke-linejoin: initial;\n  stroke-linecap: initial;\n  stroke-width: 8px;\n}\n\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}i:678;a:3:{s:7:\"desktop\";s:107:\"#colibri .style-678 ol {\n  list-style-type: decimal;\n}\n#colibri .style-678 ul {\n  list-style-type: disc;\n}\n\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}i:679;a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}i:680;a:3:{s:7:\"desktop\";s:1284:\"#colibri .style-680-icon {\n  width: 12px;\n  height: 12px;\n  margin-right: 10px;\n  margin-left: 0px;\n}\n#colibri .style-680 {\n  text-align: center;\n  background-color: #f79007;\n  background-image: none;\n  font-family: Open Sans;\n  font-weight: 600;\n  text-transform: uppercase;\n  font-size: 12px;\n  line-height: 1;\n  letter-spacing: 1px;\n  color: #fff;\n  border-top-width: 2px;\n  border-top-color: #f79007;\n  border-top-style: solid;\n  border-top-left-radius: 0px;\n  border-top-right-radius: 0px;\n  border-right-width: 2px;\n  border-right-color: #f79007;\n  border-right-style: solid;\n  border-bottom-width: 2px;\n  border-bottom-color: #f79007;\n  border-bottom-style: solid;\n  border-bottom-left-radius: 0px;\n  border-bottom-right-radius: 0px;\n  border-left-width: 2px;\n  border-left-color: #f79007;\n  border-left-style: solid;\n  padding-top: 12px;\n  padding-right: 24px;\n  padding-bottom: 12px;\n  padding-left: 24px;\n}\n#colibri .style-680:hover,#colibri .style-680:focus {\n  background-color: rgb(162, 94, 5);\n  border-top-color: rgb(162, 94, 5);\n  border-right-color: rgb(162, 94, 5);\n  border-bottom-color: rgb(162, 94, 5);\n  border-left-color: rgb(162, 94, 5);\n}\n#colibri .style-680:active .style-680-icon {\n  width: 12px;\n  height: 12px;\n  margin-right: 10px;\n  margin-left: 0px;\n}\n\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}i:681;a:3:{s:7:\"desktop\";s:83:\"#colibri .style-681 {\n  text-align: center;\n  height: auto;\n  min-height: unset;\n}\n\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}i:682;a:3:{s:7:\"desktop\";s:633:\"#colibri .style-682-image {\n  opacity: 1;\n}\n#colibri .style-682-caption {\n  margin-top: 10px;\n}\n#colibri .style-682-frameImage {\n  z-index: -1;\n  transform: translateX(5%) translateY(-5%);\n  transform-origin: center center 0px;\n  background-color: #f79007;\n  height: 100%;\n  width: 100% ;\n  border-top-width: 10px;\n  border-top-color: #f79007;\n  border-top-style: none;\n  border-right-width: 10px;\n  border-right-color: #f79007;\n  border-right-style: none;\n  border-bottom-width: 10px;\n  border-bottom-color: #f79007;\n  border-bottom-style: none;\n  border-left-width: 10px;\n  border-left-color: #f79007;\n  border-left-style: none;\n}\n\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}i:685;a:3:{s:7:\"desktop\";s:116:\"#colibri .style-685 {\n  height: auto;\n  min-height: unset;\n  background-color: #F5FAFD;\n  background-image: none;\n}\n\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}i:686;a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}i:687;a:3:{s:7:\"desktop\";s:83:\"#colibri .style-687 {\n  text-align: center;\n  height: auto;\n  min-height: unset;\n}\n\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}i:695;a:3:{s:7:\"desktop\";s:233:\"#colibri .style-695 {\n  height: auto;\n  min-height: unset;\n  padding-top: 0px;\n  padding-bottom: 0px;\n  background-color: #F5FAFD;\n  background-image: none;\n}\n#colibri .style-695  > .h-section-grid-container {\n  margin-top: -50px;\n}\n\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:43:\"#colibri .style-695 {\n  margin-top: 0px;\n}\n\";}i:696;a:3:{s:7:\"desktop\";s:134:\"#colibri .style-696 {\n  box-shadow: 0px 4px 10px 2px rgba(74, 74, 74, 0.3) ;\n  background-color: #FFFFFF;\n  background-image: none;\n}\n\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:110:\"#colibri .style-696 {\n  margin-top: 15px;\n  margin-right: 15px;\n  margin-bottom: 15px;\n  margin-left: 15px;\n}\n\";}i:697;a:3:{s:7:\"desktop\";s:469:\"#colibri .style-697 {\n  text-align: center;\n  height: auto;\n  min-height: unset;\n  border-top-width: 0px;\n  border-top-color: rgb(221, 221, 221);\n  border-top-style: solid;\n  border-right-width: 1px;\n  border-right-color: rgb(221, 221, 221);\n  border-right-style: solid;\n  border-bottom-width: 0px;\n  border-bottom-color: rgb(221, 221, 221);\n  border-bottom-style: solid;\n  border-left-width: 0px;\n  border-left-color: rgb(221, 221, 221);\n  border-left-style: solid;\n}\n\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}i:699;a:3:{s:7:\"desktop\";s:370:\"#colibri .style-699 p,#colibri .style-699  h1,#colibri .style-699  h2,#colibri .style-699  h3,#colibri .style-699  h4,#colibri .style-699  h5,#colibri .style-699  h6 {\n  text-transform: uppercase;\n  letter-spacing: 1px;\n}\n#colibri .style-699 .text-wrapper-fancy svg path {\n  stroke: #000000;\n  stroke-linejoin: initial;\n  stroke-linecap: initial;\n  stroke-width: 8px;\n}\n\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}i:701;a:3:{s:7:\"desktop\";s:469:\"#colibri .style-701 {\n  text-align: center;\n  height: auto;\n  min-height: unset;\n  border-top-width: 0px;\n  border-top-color: rgb(221, 221, 221);\n  border-top-style: solid;\n  border-right-width: 0px;\n  border-right-color: rgb(221, 221, 221);\n  border-right-style: solid;\n  border-bottom-width: 0px;\n  border-bottom-color: rgb(221, 221, 221);\n  border-bottom-style: solid;\n  border-left-width: 0px;\n  border-left-color: rgb(221, 221, 221);\n  border-left-style: solid;\n}\n\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}i:702;a:3:{s:7:\"desktop\";s:176:\"#colibri .style-702 {\n  height: auto;\n  min-height: unset;\n  padding-top: 0px;\n  padding-bottom: 0px;\n}\n#colibri .style-702  > .h-section-grid-container {\n  margin-top: 0px;\n}\n\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:43:\"#colibri .style-702 {\n  margin-top: 0px;\n}\n\";}i:703;a:3:{s:7:\"desktop\";s:134:\"#colibri .style-703 {\n  box-shadow: 0px 4px 10px 2px rgba(74, 74, 74, 0.3) ;\n  background-color: #FFFFFF;\n  background-image: none;\n}\n\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:110:\"#colibri .style-703 {\n  margin-top: 15px;\n  margin-right: 15px;\n  margin-bottom: 15px;\n  margin-left: 15px;\n}\n\";}i:704;a:3:{s:7:\"desktop\";s:469:\"#colibri .style-704 {\n  text-align: center;\n  height: auto;\n  min-height: unset;\n  border-top-width: 0px;\n  border-top-color: rgb(221, 221, 221);\n  border-top-style: solid;\n  border-right-width: 1px;\n  border-right-color: rgb(221, 221, 221);\n  border-right-style: solid;\n  border-bottom-width: 0px;\n  border-bottom-color: rgb(221, 221, 221);\n  border-bottom-style: solid;\n  border-left-width: 0px;\n  border-left-color: rgb(221, 221, 221);\n  border-left-style: solid;\n}\n\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}i:705;a:3:{s:7:\"desktop\";s:654:\"#colibri .style-705-icon {\n  fill: rgb(51, 51, 51);\n  width: 64px ;\n  height: 64px;\n  border-top-width: 2px;\n  border-top-color: #f79007;\n  border-top-style: none;\n  border-top-left-radius: 300px;\n  border-top-right-radius: 300px;\n  border-right-width: 2px;\n  border-right-color: #f79007;\n  border-right-style: none;\n  border-bottom-width: 2px;\n  border-bottom-color: #f79007;\n  border-bottom-style: none;\n  border-bottom-left-radius: 300px;\n  border-bottom-right-radius: 300px;\n  border-left-width: 2px;\n  border-left-color: #f79007;\n  border-left-style: none;\n  padding-top: 11px;\n  padding-right: 11px;\n  padding-bottom: 11px;\n  padding-left: 11px;\n}\n\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}i:706;a:3:{s:7:\"desktop\";s:370:\"#colibri .style-706 p,#colibri .style-706  h1,#colibri .style-706  h2,#colibri .style-706  h3,#colibri .style-706  h4,#colibri .style-706  h5,#colibri .style-706  h6 {\n  text-transform: uppercase;\n  letter-spacing: 1px;\n}\n#colibri .style-706 .text-wrapper-fancy svg path {\n  stroke: #000000;\n  stroke-linejoin: initial;\n  stroke-linecap: initial;\n  stroke-width: 8px;\n}\n\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}i:708;a:3:{s:7:\"desktop\";s:469:\"#colibri .style-708 {\n  text-align: center;\n  height: auto;\n  min-height: unset;\n  border-top-width: 0px;\n  border-top-color: rgb(221, 221, 221);\n  border-top-style: solid;\n  border-right-width: 0px;\n  border-right-color: rgb(221, 221, 221);\n  border-right-style: solid;\n  border-bottom-width: 0px;\n  border-bottom-color: rgb(221, 221, 221);\n  border-bottom-style: solid;\n  border-left-width: 0px;\n  border-left-color: rgb(221, 221, 221);\n  border-left-style: solid;\n}\n\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}i:709;a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}i:710;a:3:{s:7:\"desktop\";s:158:\".style-710 > .h-y-container > *:not(:last-child) {\n  margin-bottom: 0px;\n}\n#colibri .style-710 {\n  text-align: center;\n  height: auto;\n  min-height: unset;\n}\n\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}i:711;a:3:{s:7:\"desktop\";s:148:\"#colibri .style-711 .text-wrapper-fancy svg path {\n  stroke: #000000;\n  stroke-linejoin: initial;\n  stroke-linecap: initial;\n  stroke-width: 8px;\n}\n\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}i:712;a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}i:713;a:3:{s:7:\"desktop\";s:83:\"#colibri .style-713 {\n  text-align: center;\n  height: auto;\n  min-height: unset;\n}\n\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}i:714;a:3:{s:7:\"desktop\";s:342:\"#colibri .style-714 p,#colibri .style-714  h1,#colibri .style-714  h2,#colibri .style-714  h3,#colibri .style-714  h4,#colibri .style-714  h5,#colibri .style-714  h6 {\n  letter-spacing: 10px;\n}\n#colibri .style-714 .text-wrapper-fancy svg path {\n  stroke: #000000;\n  stroke-linejoin: initial;\n  stroke-linecap: initial;\n  stroke-width: 8px;\n}\n\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}i:718;a:3:{s:7:\"desktop\";s:148:\"#colibri .style-718 .text-wrapper-fancy svg path {\n  stroke: #000000;\n  stroke-linejoin: initial;\n  stroke-linecap: initial;\n  stroke-width: 8px;\n}\n\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}i:719;a:3:{s:7:\"desktop\";s:340:\"#colibri .style-719 p,#colibri .style-719  h1,#colibri .style-719  h2,#colibri .style-719  h3,#colibri .style-719  h4,#colibri .style-719  h5,#colibri .style-719  h6 {\n  text-align: center;\n}\n#colibri .style-719 .text-wrapper-fancy svg path {\n  stroke: #000000;\n  stroke-linejoin: initial;\n  stroke-linecap: initial;\n  stroke-width: 8px;\n}\n\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}i:720;a:3:{s:7:\"desktop\";s:107:\"#colibri .style-720 ol {\n  list-style-type: decimal;\n}\n#colibri .style-720 ul {\n  list-style-type: disc;\n}\n\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}i:721;a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}i:722;a:3:{s:7:\"desktop\";s:1284:\"#colibri .style-722-icon {\n  width: 12px;\n  height: 12px;\n  margin-right: 10px;\n  margin-left: 0px;\n}\n#colibri .style-722 {\n  text-align: center;\n  background-color: #f79007;\n  background-image: none;\n  font-family: Open Sans;\n  font-weight: 600;\n  text-transform: uppercase;\n  font-size: 12px;\n  line-height: 1;\n  letter-spacing: 1px;\n  color: #fff;\n  border-top-width: 2px;\n  border-top-color: #f79007;\n  border-top-style: solid;\n  border-top-left-radius: 0px;\n  border-top-right-radius: 0px;\n  border-right-width: 2px;\n  border-right-color: #f79007;\n  border-right-style: solid;\n  border-bottom-width: 2px;\n  border-bottom-color: #f79007;\n  border-bottom-style: solid;\n  border-bottom-left-radius: 0px;\n  border-bottom-right-radius: 0px;\n  border-left-width: 2px;\n  border-left-color: #f79007;\n  border-left-style: solid;\n  padding-top: 12px;\n  padding-right: 24px;\n  padding-bottom: 12px;\n  padding-left: 24px;\n}\n#colibri .style-722:hover,#colibri .style-722:focus {\n  background-color: rgb(162, 94, 5);\n  border-top-color: rgb(162, 94, 5);\n  border-right-color: rgb(162, 94, 5);\n  border-bottom-color: rgb(162, 94, 5);\n  border-left-color: rgb(162, 94, 5);\n}\n#colibri .style-722:active .style-722-icon {\n  width: 12px;\n  height: 12px;\n  margin-right: 10px;\n  margin-left: 0px;\n}\n\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}i:724;a:3:{s:7:\"desktop\";s:633:\"#colibri .style-724-image {\n  opacity: 1;\n}\n#colibri .style-724-caption {\n  margin-top: 10px;\n}\n#colibri .style-724-frameImage {\n  z-index: -1;\n  transform: translateX(5%) translateY(-5%);\n  transform-origin: center center 0px;\n  background-color: #f79007;\n  height: 100%;\n  width: 100% ;\n  border-top-width: 10px;\n  border-top-color: #f79007;\n  border-top-style: none;\n  border-right-width: 10px;\n  border-right-color: #f79007;\n  border-right-style: none;\n  border-bottom-width: 10px;\n  border-bottom-color: #f79007;\n  border-bottom-style: none;\n  border-left-width: 10px;\n  border-left-color: #f79007;\n  border-left-style: none;\n}\n\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}i:725;a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}i:726;a:3:{s:7:\"desktop\";s:83:\"#colibri .style-726 {\n  text-align: center;\n  height: auto;\n  min-height: unset;\n}\n\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}i:727;a:3:{s:7:\"desktop\";s:83:\"#colibri .style-727 {\n  text-align: center;\n  height: auto;\n  min-height: unset;\n}\n\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}i:728;a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}i:729;a:3:{s:7:\"desktop\";s:326:\"#colibri .style-729 {\n  animation-duration: 0.5s;\n  padding-top: 3px;\n  padding-bottom: 3px;\n}\n#colibri .h-navigation_sticky .style-729,#colibri .h-navigation_sticky.style-729 {\n  background-color: #ffffff;\n  background-image: none;\n  padding-top: 0px;\n  padding-bottom: 0px;\n  box-shadow: 0px 0px 4px 0px rgba(0,0,0,0.5) ;\n}\n\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:67:\"#colibri .style-729 {\n  padding-top: 0px;\n  padding-bottom: 0px;\n}\n\";}i:730;a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}i:731;a:3:{s:7:\"desktop\";s:83:\"#colibri .style-731 {\n  text-align: center;\n  height: auto;\n  min-height: unset;\n}\n\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}i:735;a:3:{s:7:\"desktop\";s:83:\"#colibri .style-735 {\n  text-align: center;\n  height: auto;\n  min-height: unset;\n}\n\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}i:736;a:3:{s:7:\"desktop\";s:9124:\"#colibri .style-736 >  div > .colibri-menu-container > ul.colibri-menu {\n  justify-content: flex-end;\n}\n#colibri .style-736 >  div > .colibri-menu-container > ul.colibri-menu > li {\n  margin-top: 0px;\n  margin-right: 20px;\n  margin-bottom: 0px;\n  margin-left: 20px;\n  padding-top: 10px;\n  padding-right: 0px;\n  padding-bottom: 10px;\n  padding-left: 0px;\n}\n#colibri .style-736 >  div > .colibri-menu-container > ul.colibri-menu > li.current_page_item,#colibri .style-736  >  div > .colibri-menu-container > ul.colibri-menu > li.current_page_item:hover {\n  margin-top: 0px;\n  margin-right: 20px;\n  margin-bottom: 0px;\n  margin-left: 20px;\n  padding-top: 10px;\n  padding-right: 0px;\n  padding-bottom: 10px;\n  padding-left: 0px;\n}\n#colibri .style-736 >  div > .colibri-menu-container > ul.colibri-menu > li > a {\n  font-family: Open Sans;\n  font-weight: 600;\n  text-transform: uppercase;\n  font-size: 14px;\n  line-height: 1.5em;\n  letter-spacing: 0px;\n  color: #FFFFFF;\n}\n#colibri .style-736  >  div > .colibri-menu-container > ul.colibri-menu > li.current_page_item > a,#colibri .style-736  >  div > .colibri-menu-container > ul.colibri-menu > li.current_page_item > a:hover {\n  font-family: Open Sans;\n  font-weight: 600;\n  text-transform: uppercase;\n  font-size: 14px;\n  line-height: 1.5em;\n  letter-spacing: 0px;\n  color: #FFFFFF;\n}\n#colibri .style-736 >  div > .colibri-menu-container > ul.colibri-menu li > ul {\n  background-color: #ffffff;\n  background-image: none;\n  margin-right: 5px;\n  margin-left: 5px;\n  box-shadow: 0px 0px 5px 2px rgba(0, 0, 0, 0.04) ;\n}\n#colibri .style-736 >  div > .colibri-menu-container > ul.colibri-menu li > ul  li {\n  padding-top: 10px;\n  padding-right: 20px;\n  padding-bottom: 10px;\n  padding-left: 20px;\n  border-top-width: 0px;\n  border-top-style: none;\n  border-right-width: 0px;\n  border-right-style: none;\n  border-bottom-width: 1px;\n  border-bottom-color: rgba(128,128,128,.2);\n  border-bottom-style: solid;\n  border-left-width: 0px;\n  border-left-style: none;\n  background-color: rgb(255, 255, 255);\n  background-image: none;\n}\n#colibri .style-736  >  div > .colibri-menu-container > ul.colibri-menu li > ul > li.hover {\n  background-color: #f79007;\n}\n#colibri .style-736  >  div > .colibri-menu-container > ul.colibri-menu li > ul > li:hover,#colibri .style-736  >  div > .colibri-menu-container > ul.colibri-menu li > ul > li.hover {\n  background-color: #f79007;\n}\n#colibri .style-736 >  div > .colibri-menu-container > ul.colibri-menu li > ul li.current_page_item,#colibri .style-736  >  div > .colibri-menu-container > ul.colibri-menu li > ul > li.current_page_item:hover {\n  padding-top: 10px;\n  padding-right: 20px;\n  padding-bottom: 10px;\n  padding-left: 20px;\n  border-top-width: 0px;\n  border-top-style: none;\n  border-right-width: 0px;\n  border-right-style: none;\n  border-bottom-width: 1px;\n  border-bottom-color: rgba(128,128,128,.2);\n  border-bottom-style: solid;\n  border-left-width: 0px;\n  border-left-style: none;\n  background-color: #03a9f4;\n  background-image: none;\n}\n#colibri .style-736 >  div > .colibri-menu-container > ul.colibri-menu li > ul > li > a {\n  font-size: 14px;\n  color: rgb(102, 102, 102);\n}\n#colibri .style-736  >  div > .colibri-menu-container > ul.colibri-menu li > ul > li.hover  > a {\n  color: rgb(255, 255, 255);\n}\n#colibri .style-736  >  div > .colibri-menu-container > ul.colibri-menu li > ul > li:hover > a,#colibri .style-736  >  div > .colibri-menu-container > ul.colibri-menu li > ul > li.hover  > a {\n  color: rgb(255, 255, 255);\n}\n#colibri .style-736 >  div > .colibri-menu-container > ul.colibri-menu li > ul > li.current_page_item > a,#colibri .style-736  >  div > .colibri-menu-container > ul.colibri-menu li > ul > li.current_page_item > a:hover {\n  font-size: 14px;\n  color: rgb(255, 255, 255);\n}\n#colibri .style-736 >  div > .colibri-menu-container > ul.colibri-menu.bordered-active-item > li::after,#colibri .style-736 \n      ul.colibri-menu.bordered-active-item > li::before {\n  background-color: #FFFFFF;\n  background-image: none;\n  height: 3px;\n}\n#colibri .style-736 >  div > .colibri-menu-container > ul.colibri-menu.solid-active-item > li::after,#colibri .style-736 \n      ul.colibri-menu.solid-active-item > li::before {\n  background-color: white;\n  background-image: none;\n  border-top-width: 0px;\n  border-top-style: none;\n  border-top-left-radius: 0%;\n  border-top-right-radius: 0%;\n  border-right-width: 0px;\n  border-right-style: none;\n  border-bottom-width: 0px;\n  border-bottom-style: none;\n  border-bottom-left-radius: 0%;\n  border-bottom-right-radius: 0%;\n  border-left-width: 0px;\n  border-left-style: none;\n}\n#colibri .style-736 >  div > .colibri-menu-container > ul.colibri-menu > li > ul {\n  margin-top: 0px;\n}\n#colibri .style-736 >  div > .colibri-menu-container > ul.colibri-menu > li > ul::before {\n  height: 0px;\n  width: 100% ;\n}\n#colibri .style-736 >  div > .colibri-menu-container > ul.colibri-menu  li > a > svg,#colibri .style-736 >  div > .colibri-menu-container > ul.colibri-menu  li > a >  .arrow-wrapper {\n  padding-right: 5px;\n  padding-left: 5px;\n  color: black;\n}\n#colibri .style-736 >  div > .colibri-menu-container > ul.colibri-menu li.current_page_item > a > svg,#colibri .style-736 >  div > .colibri-menu-container > ul.colibri-menu > li.current_page_item:hover > a > svg,#colibri .style-736 >  div > .colibri-menu-container > ul.colibri-menu li.current_page_item > a > .arrow-wrapper,#colibri .style-736 >  div > .colibri-menu-container > ul.colibri-menu > li.current_page_item:hover > a > .arrow-wrapper {\n  padding-right: 5px;\n  padding-left: 5px;\n  color: black;\n}\n#colibri .style-736 >  div > .colibri-menu-container > ul.colibri-menu li > ul  li > a > svg,#colibri .style-736 >  div > .colibri-menu-container > ul.colibri-menu li > ul  li > a >  .arrow-wrapper {\n  color: rgb(255, 255, 255);\n}\n#colibri .style-736 >  div > .colibri-menu-container > ul.colibri-menu li > ul li.current_page_item > a > svg,#colibri .style-736 >  div > .colibri-menu-container > ul.colibri-menu li > ul > li.current_page_item:hover > a > svg,#colibri .style-736 >  div > .colibri-menu-container > ul.colibri-menu li > ul li.current_page_item > a > .arrow-wrapper,#colibri .style-736 >  div > .colibri-menu-container > ul.colibri-menu li > ul > li.current_page_item:hover > a > .arrow-wrapper {\n  color: rgb(255, 255, 255);\n}\n#colibri .h-navigation_sticky .style-736 >  div > .colibri-menu-container > ul.colibri-menu > li > a,#colibri .h-navigation_sticky.style-736 >  div > .colibri-menu-container > ul.colibri-menu > li > a {\n  color: rgb(2, 110, 159);\n}\n#colibri .h-navigation_sticky .style-736  >  div > .colibri-menu-container > ul.colibri-menu > li.hover  > a,#colibri .h-navigation_sticky.style-736  >  div > .colibri-menu-container > ul.colibri-menu > li.hover  > a {\n  color: #03a9f4;\n}\n#colibri .h-navigation_sticky .style-736  >  div > .colibri-menu-container > ul.colibri-menu > li:hover > a,#colibri .h-navigation_sticky .style-736  >  div > .colibri-menu-container > ul.colibri-menu > li.hover  > a,#colibri .h-navigation_sticky.style-736  >  div > .colibri-menu-container > ul.colibri-menu > li:hover > a,#colibri .h-navigation_sticky.style-736  >  div > .colibri-menu-container > ul.colibri-menu > li.hover  > a {\n  color: #03a9f4;\n}\n#colibri .h-navigation_sticky .style-736  >  div > .colibri-menu-container > ul.colibri-menu > li.current_page_item > a,#colibri .h-navigation_sticky .style-736  >  div > .colibri-menu-container > ul.colibri-menu > li.current_page_item > a:hover,#colibri .h-navigation_sticky.style-736  >  div > .colibri-menu-container > ul.colibri-menu > li.current_page_item > a,#colibri .h-navigation_sticky.style-736  >  div > .colibri-menu-container > ul.colibri-menu > li.current_page_item > a:hover {\n  color: #03a9f4;\n}\n#colibri .h-navigation_sticky .style-736 >  div > .colibri-menu-container > ul.colibri-menu li > ul li.current_page_item,#colibri .h-navigation_sticky .style-736  >  div > .colibri-menu-container > ul.colibri-menu li > ul > li.current_page_item:hover,#colibri .h-navigation_sticky.style-736 >  div > .colibri-menu-container > ul.colibri-menu li > ul li.current_page_item,#colibri .h-navigation_sticky.style-736  >  div > .colibri-menu-container > ul.colibri-menu li > ul > li.current_page_item:hover {\n  background-color: #f79007;\n  background-image: none;\n}\n#colibri .h-navigation_sticky .style-736 >  div > .colibri-menu-container > ul.colibri-menu li > ul > li > a,#colibri .h-navigation_sticky.style-736 >  div > .colibri-menu-container > ul.colibri-menu li > ul > li > a {\n  color: #000000;\n}\n#colibri .h-navigation_sticky .style-736 >  div > .colibri-menu-container > ul.colibri-menu li > ul > li.current_page_item > a,#colibri .h-navigation_sticky .style-736  >  div > .colibri-menu-container > ul.colibri-menu li > ul > li.current_page_item > a:hover,#colibri .h-navigation_sticky.style-736 >  div > .colibri-menu-container > ul.colibri-menu li > ul > li.current_page_item > a,#colibri .h-navigation_sticky.style-736  >  div > .colibri-menu-container > ul.colibri-menu li > ul > li.current_page_item > a:hover {\n  color: #FFFFFF;\n}\n\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}i:737;a:3:{s:7:\"desktop\";s:931:\"#colibri .style-737-offscreen {\n  background-color: #222B34;\n  background-image: none;\n  width: 300px !important;\n}\n#colibri .style-737-offscreenOverlay {\n  background-color: rgba(0,0,0,0.5);\n  background-image: none;\n}\n#colibri .style-737  .h-hamburger-icon {\n  background-color: rgba(0, 0, 0, 0.1);\n  background-image: none;\n  border-top-width: 0px;\n  border-top-color: black;\n  border-top-style: solid;\n  border-top-left-radius: 100%;\n  border-top-right-radius: 100%;\n  border-right-width: 0px;\n  border-right-color: black;\n  border-right-style: solid;\n  border-bottom-width: 0px;\n  border-bottom-color: black;\n  border-bottom-style: solid;\n  border-bottom-left-radius: 100%;\n  border-bottom-right-radius: 100%;\n  border-left-width: 0px;\n  border-left-color: black;\n  border-left-style: solid;\n  fill: white;\n  padding-top: 5px;\n  padding-right: 5px;\n  padding-bottom: 5px;\n  padding-left: 5px;\n  width: 24px;\n  height: 24px;\n}\n\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}i:738;a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}i:739;a:3:{s:7:\"desktop\";s:3947:\"#colibri .style-739 >  div > .colibri-menu-container > ul.colibri-menu > li > a {\n  padding-top: 12px;\n  padding-bottom: 12px;\n  padding-left: 40px;\n  border-top-width: 0px;\n  border-top-color: #808080;\n  border-top-style: solid;\n  border-right-width: 0px;\n  border-right-color: #808080;\n  border-right-style: solid;\n  border-bottom-width: 1px;\n  border-bottom-color: #808080;\n  border-bottom-style: solid;\n  border-left-width: 0px;\n  border-left-color: #808080;\n  border-left-style: solid;\n  font-size: 14px;\n  color: white;\n}\n#colibri .style-739  >  div > .colibri-menu-container > ul.colibri-menu > li.current_page_item > a,#colibri .style-739  >  div > .colibri-menu-container > ul.colibri-menu > li.current_page_item > a:hover {\n  padding-top: 12px;\n  padding-bottom: 12px;\n  padding-left: 40px;\n  border-top-width: 0px;\n  border-top-color: #808080;\n  border-top-style: solid;\n  border-right-width: 0px;\n  border-right-color: #808080;\n  border-right-style: solid;\n  border-bottom-width: 1px;\n  border-bottom-color: #808080;\n  border-bottom-style: solid;\n  border-left-width: 0px;\n  border-left-color: #808080;\n  border-left-style: solid;\n  font-size: 14px;\n  color: white;\n}\n#colibri .style-739 >  div > .colibri-menu-container > ul.colibri-menu li > ul > li > a {\n  padding-top: 12px;\n  padding-bottom: 12px;\n  padding-left: 40px;\n  border-top-width: 0px;\n  border-top-color: #808080;\n  border-top-style: solid;\n  border-right-width: 0px;\n  border-right-color: #808080;\n  border-right-style: solid;\n  border-bottom-width: 1px;\n  border-bottom-color: #808080;\n  border-bottom-style: solid;\n  border-left-width: 0px;\n  border-left-color: #808080;\n  border-left-style: solid;\n  font-size: 14px;\n  color: white;\n}\n#colibri .style-739 >  div > .colibri-menu-container > ul.colibri-menu li > ul > li.current_page_item > a,#colibri .style-739  >  div > .colibri-menu-container > ul.colibri-menu li > ul > li.current_page_item > a:hover {\n  padding-top: 12px;\n  padding-bottom: 12px;\n  padding-left: 40px;\n  border-top-width: 0px;\n  border-top-color: #808080;\n  border-top-style: solid;\n  border-right-width: 0px;\n  border-right-color: #808080;\n  border-right-style: solid;\n  border-bottom-width: 1px;\n  border-bottom-color: #808080;\n  border-bottom-style: solid;\n  border-left-width: 0px;\n  border-left-color: #808080;\n  border-left-style: solid;\n  font-size: 14px;\n  color: white;\n}\n#colibri .style-739 >  div > .colibri-menu-container > ul.colibri-menu  li > a > svg,#colibri .style-739 >  div > .colibri-menu-container > ul.colibri-menu  li > a >  .arrow-wrapper {\n  padding-right: 20px;\n  padding-left: 20px;\n  color: black;\n}\n#colibri .style-739 >  div > .colibri-menu-container > ul.colibri-menu li.current_page_item > a > svg,#colibri .style-739 >  div > .colibri-menu-container > ul.colibri-menu > li.current_page_item:hover > a > svg,#colibri .style-739 >  div > .colibri-menu-container > ul.colibri-menu li.current_page_item > a > .arrow-wrapper,#colibri .style-739 >  div > .colibri-menu-container > ul.colibri-menu > li.current_page_item:hover > a > .arrow-wrapper {\n  padding-right: 20px;\n  padding-left: 20px;\n  color: black;\n}\n#colibri .style-739 >  div > .colibri-menu-container > ul.colibri-menu li > ul  li > a > svg,#colibri .style-739 >  div > .colibri-menu-container > ul.colibri-menu li > ul  li > a >  .arrow-wrapper {\n  color: white;\n  padding-right: 20px;\n  padding-left: 20px;\n}\n#colibri .style-739 >  div > .colibri-menu-container > ul.colibri-menu li > ul li.current_page_item > a > svg,#colibri .style-739 >  div > .colibri-menu-container > ul.colibri-menu li > ul > li.current_page_item:hover > a > svg,#colibri .style-739 >  div > .colibri-menu-container > ul.colibri-menu li > ul li.current_page_item > a > .arrow-wrapper,#colibri .style-739 >  div > .colibri-menu-container > ul.colibri-menu li > ul > li.current_page_item:hover > a > .arrow-wrapper {\n  color: white;\n  padding-right: 20px;\n  padding-left: 20px;\n}\n\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}i:740;a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}i:741;a:3:{s:7:\"desktop\";s:83:\"#colibri .style-741 {\n  text-align: center;\n  height: auto;\n  min-height: unset;\n}\n\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}i:742;a:3:{s:7:\"desktop\";s:505:\"#colibri .style-742-image {\n  max-height: 70px;\n}\n#colibri .style-742 a,#colibri .style-742  .logo-text {\n  color: #ffffff;\n  text-decoration: none;\n}\n#colibri .h-navigation_sticky .style-742-image,#colibri .h-navigation_sticky.style-742-image {\n  max-height: 70px;\n}\n#colibri .h-navigation_sticky .style-742 a,#colibri .h-navigation_sticky .style-742  .logo-text,#colibri .h-navigation_sticky.style-742 a,#colibri .h-navigation_sticky.style-742  .logo-text {\n  color: #000000;\n  text-decoration: none;\n}\n\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}i:743;a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}i:744;a:3:{s:7:\"desktop\";s:83:\"#colibri .style-744 {\n  text-align: center;\n  height: auto;\n  min-height: unset;\n}\n\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}i:745;a:3:{s:7:\"desktop\";s:107:\"#colibri .style-745 ol {\n  list-style-type: decimal;\n}\n#colibri .style-745 ul {\n  list-style-type: disc;\n}\n\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}i:746;a:3:{s:7:\"desktop\";s:680:\"#colibri .style-746 {\n  min-height: 100vh;\n  color: #FFFFFF;\n  background-position: 47.738937015985876% 31.418853085045424%;\n  background-size: cover;\n  background-image: url(\"http://localhost/wordpress/wp-content/uploads/2024/10/karibea-banniere-1.png\");\n  background-attachment: scroll;\n  background-repeat: no-repeat;\n  padding-top: 0px;\n  padding-bottom: 0px;\n}\n#colibri .style-746 h1 {\n  color: #FFFFFF;\n}\n#colibri .style-746 h2 {\n  color: #FFFFFF;\n}\n#colibri .style-746 h3 {\n  color: #FFFFFF;\n}\n#colibri .style-746 h4 {\n  color: #FFFFFF;\n}\n#colibri .style-746 h5 {\n  color: #FFFFFF;\n}\n#colibri .style-746 h6 {\n  color: #FFFFFF;\n}\n#colibri .style-746 p {\n  color: #FFFFFF;\n}\n\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}i:747;a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}i:748;a:3:{s:7:\"desktop\";s:433:\"#colibri .style-748 {\n  text-align: left;\n  height: auto;\n  min-height: unset;\n  border-top-width: 0px;\n  border-top-style: solid;\n  border-top-left-radius: 9px;\n  border-top-right-radius: 9px;\n  border-right-width: 0px;\n  border-right-style: solid;\n  border-bottom-width: 0px;\n  border-bottom-style: solid;\n  border-bottom-left-radius: 9px;\n  border-bottom-right-radius: 9px;\n  border-left-width: 0px;\n  border-left-style: solid;\n}\n\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:46:\"#colibri .style-748 {\n  text-align: center;\n}\n\";}i:756;a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}i:757;a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}i:758;a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}i:759;a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}i:760;a:3:{s:7:\"desktop\";s:83:\"#colibri .style-760 {\n  text-align: center;\n  height: auto;\n  min-height: unset;\n}\n\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}i:761;a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}i:762;a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}i:763;a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}i:764;a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}i:766;a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}i:767;a:3:{s:7:\"desktop\";s:83:\"#colibri .style-767 {\n  text-align: center;\n  height: auto;\n  min-height: unset;\n}\n\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}i:776;a:3:{s:7:\"desktop\";s:658:\"#colibri .style-776 {\n  min-height: 728px;\n  color: #FFFFFF;\n  background-position: center center;\n  background-size: cover;\n  background-image: url(\"http://localhost/wordpress/wp-content/uploads/2024/10/karibea-banniere-1.png\");\n  background-attachment: scroll;\n  background-repeat: no-repeat;\n  padding-top: 150px;\n  padding-bottom: 150px;\n}\n#colibri .style-776 h1 {\n  color: #FFFFFF;\n}\n#colibri .style-776 h2 {\n  color: #FFFFFF;\n}\n#colibri .style-776 h3 {\n  color: #FFFFFF;\n}\n#colibri .style-776 h4 {\n  color: #FFFFFF;\n}\n#colibri .style-776 h5 {\n  color: #FFFFFF;\n}\n#colibri .style-776 h6 {\n  color: #FFFFFF;\n}\n#colibri .style-776 p {\n  color: #FFFFFF;\n}\n\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}i:777;a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}i:778;a:3:{s:7:\"desktop\";s:83:\"#colibri .style-778 {\n  text-align: center;\n  height: auto;\n  min-height: unset;\n}\n\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}i:765;a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}i:780;a:3:{s:7:\"desktop\";s:651:\"#colibri .style-780 {\n  background-position: center center;\n  background-size: cover;\n  background-image: url(\"http://localhost/wordpress/wp-content/uploads/2024/09/cropped-cropped-cropped-cropped-fond-logo-karibiea-1-1-1.png\");\n  background-attachment: scroll;\n  background-repeat: no-repeat;\n}\n#colibri .h-navigation_sticky .style-780,#colibri .h-navigation_sticky.style-780 {\n  background-position: center center;\n  background-size: cover;\n  background-image: url(\"http://localhost/wordpress/wp-content/uploads/2024/09/cropped-cropped-cropped-cropped-fond-logo-karibiea-1-1.png\");\n  background-attachment: scroll;\n  background-repeat: no-repeat;\n}\n\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}i:781;a:3:{s:7:\"desktop\";s:199:\"#colibri .style-781-outer {\n  padding-top: 9px;\n  padding-right: 9px;\n  padding-bottom: 9px;\n  padding-left: 9px;\n}\n#colibri .style-781 {\n  text-align: center;\n  height: auto;\n  min-height: unset;\n}\n\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}i:783;a:3:{s:7:\"desktop\";s:701:\"#colibri .style-783-image {\n  opacity: 0.85;\n  box-shadow: 0px 0px 10px 2px rgba(0,0,0,0.5) ;\n}\n#colibri .style-783-caption {\n  margin-top: 10px;\n}\n#colibri .style-783-frameImage {\n  z-index: -1;\n  transform: translateX(10%) translateY(10%);\n  transform-origin: center center 0px;\n  background-color: rgb(0,0,0);\n  height: 100%;\n  width: 100% ;\n  border-top-width: 10px;\n  border-top-color: rgb(0,0,0);\n  border-top-style: none;\n  border-right-width: 10px;\n  border-right-color: rgb(0,0,0);\n  border-right-style: none;\n  border-bottom-width: 10px;\n  border-bottom-color: rgb(0,0,0);\n  border-bottom-style: none;\n  border-left-width: 10px;\n  border-left-color: rgb(0,0,0);\n  border-left-style: none;\n}\n\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}i:787;a:3:{s:7:\"desktop\";s:6277:\"#colibri .style-787 >  div > .colibri-menu-container > ul.colibri-menu {\n  justify-content: center;\n}\n#colibri .style-787 >  div > .colibri-menu-container > ul.colibri-menu > li {\n  margin-top: 0px;\n  margin-right: 7px;\n  margin-bottom: 0px;\n  margin-left: 7px;\n  padding-top: 20px;\n  padding-right: 21px;\n  padding-bottom: 20px;\n  padding-left: 21px;\n}\n#colibri .style-787 >  div > .colibri-menu-container > ul.colibri-menu > li.current_page_item,#colibri .style-787  >  div > .colibri-menu-container > ul.colibri-menu > li.current_page_item:hover {\n  margin-top: 0px;\n  margin-right: 7px;\n  margin-bottom: 0px;\n  margin-left: 7px;\n  padding-top: 20px;\n  padding-right: 21px;\n  padding-bottom: 20px;\n  padding-left: 21px;\n}\n#colibri .style-787 >  div > .colibri-menu-container > ul.colibri-menu > li > a {\n  font-size: 14px;\n  color: black;\n}\n#colibri .style-787  >  div > .colibri-menu-container > ul.colibri-menu > li.hover  > a {\n  color: #d8d8d8;\n}\n#colibri .style-787  >  div > .colibri-menu-container > ul.colibri-menu > li:hover > a,#colibri .style-787  >  div > .colibri-menu-container > ul.colibri-menu > li.hover  > a {\n  color: #d8d8d8;\n}\n#colibri .style-787  >  div > .colibri-menu-container > ul.colibri-menu > li.current_page_item > a,#colibri .style-787  >  div > .colibri-menu-container > ul.colibri-menu > li.current_page_item > a:hover {\n  font-size: 14px;\n  color: black;\n}\n#colibri .style-787 >  div > .colibri-menu-container > ul.colibri-menu li > ul {\n  background-color: #ffffff;\n  background-image: none;\n  margin-right: 5px;\n  margin-left: 5px;\n}\n#colibri .style-787 >  div > .colibri-menu-container > ul.colibri-menu li > ul  li {\n  padding-top: 10px;\n  padding-right: 20px;\n  padding-bottom: 10px;\n  padding-left: 20px;\n  border-top-width: 0px;\n  border-top-style: none;\n  border-right-width: 0px;\n  border-right-style: none;\n  border-bottom-width: 1px;\n  border-bottom-color: rgba(28, 1, 1, 0.2);\n  border-bottom-style: solid;\n  border-left-width: 0px;\n  border-left-style: none;\n  background-color: #FFFFFF;\n  background-image: none;\n}\n#colibri .style-787  >  div > .colibri-menu-container > ul.colibri-menu li > ul > li.hover {\n  background-color: #f79007;\n}\n#colibri .style-787  >  div > .colibri-menu-container > ul.colibri-menu li > ul > li:hover,#colibri .style-787  >  div > .colibri-menu-container > ul.colibri-menu li > ul > li.hover {\n  background-color: #f79007;\n}\n#colibri .style-787 >  div > .colibri-menu-container > ul.colibri-menu li > ul li.current_page_item,#colibri .style-787  >  div > .colibri-menu-container > ul.colibri-menu li > ul > li.current_page_item:hover {\n  padding-top: 10px;\n  padding-right: 20px;\n  padding-bottom: 10px;\n  padding-left: 20px;\n  border-top-width: 0px;\n  border-top-style: none;\n  border-right-width: 0px;\n  border-right-style: none;\n  border-bottom-width: 1px;\n  border-bottom-color: rgba(28, 1, 1, 0.2);\n  border-bottom-style: solid;\n  border-left-width: 0px;\n  border-left-style: none;\n  background-color: #f79007;\n  background-image: none;\n}\n#colibri .style-787 >  div > .colibri-menu-container > ul.colibri-menu li > ul > li > a {\n  font-size: 14px;\n  color: #f79007;\n}\n#colibri .style-787  >  div > .colibri-menu-container > ul.colibri-menu li > ul > li.hover  > a {\n  color: #FFFFFF;\n}\n#colibri .style-787  >  div > .colibri-menu-container > ul.colibri-menu li > ul > li:hover > a,#colibri .style-787  >  div > .colibri-menu-container > ul.colibri-menu li > ul > li.hover  > a {\n  color: #FFFFFF;\n}\n#colibri .style-787 >  div > .colibri-menu-container > ul.colibri-menu li > ul > li.current_page_item > a,#colibri .style-787  >  div > .colibri-menu-container > ul.colibri-menu li > ul > li.current_page_item > a:hover {\n  font-size: 14px;\n  color: #FFFFFF;\n}\n#colibri .style-787 >  div > .colibri-menu-container > ul.colibri-menu.bordered-active-item > li::after,#colibri .style-787 \n      ul.colibri-menu.bordered-active-item > li::before {\n  background-color: #000000;\n  background-image: none;\n  height: 3px;\n}\n#colibri .style-787 >  div > .colibri-menu-container > ul.colibri-menu.solid-active-item > li::after,#colibri .style-787 \n      ul.colibri-menu.solid-active-item > li::before {\n  background-color: white;\n  background-image: none;\n  border-top-width: 0px;\n  border-top-style: none;\n  border-top-left-radius: 0%;\n  border-top-right-radius: 0%;\n  border-right-width: 0px;\n  border-right-style: none;\n  border-bottom-width: 0px;\n  border-bottom-style: none;\n  border-bottom-left-radius: 0%;\n  border-bottom-right-radius: 0%;\n  border-left-width: 0px;\n  border-left-style: none;\n}\n#colibri .style-787 >  div > .colibri-menu-container > ul.colibri-menu > li > ul {\n  margin-top: 0px;\n}\n#colibri .style-787 >  div > .colibri-menu-container > ul.colibri-menu > li > ul::before {\n  height: 0px;\n  width: 100% ;\n}\n#colibri .style-787 >  div > .colibri-menu-container > ul.colibri-menu  li > a > svg,#colibri .style-787 >  div > .colibri-menu-container > ul.colibri-menu  li > a >  .arrow-wrapper {\n  padding-right: 15px;\n  padding-left: 15px;\n  color: black;\n}\n#colibri .style-787 >  div > .colibri-menu-container > ul.colibri-menu li.current_page_item > a > svg,#colibri .style-787 >  div > .colibri-menu-container > ul.colibri-menu > li.current_page_item:hover > a > svg,#colibri .style-787 >  div > .colibri-menu-container > ul.colibri-menu li.current_page_item > a > .arrow-wrapper,#colibri .style-787 >  div > .colibri-menu-container > ul.colibri-menu > li.current_page_item:hover > a > .arrow-wrapper {\n  padding-right: 15px;\n  padding-left: 15px;\n  color: black;\n}\n#colibri .style-787 >  div > .colibri-menu-container > ul.colibri-menu li > ul  li > a > svg,#colibri .style-787 >  div > .colibri-menu-container > ul.colibri-menu li > ul  li > a >  .arrow-wrapper {\n  color: black;\n}\n#colibri .style-787 >  div > .colibri-menu-container > ul.colibri-menu li > ul li.current_page_item > a > svg,#colibri .style-787 >  div > .colibri-menu-container > ul.colibri-menu li > ul > li.current_page_item:hover > a > svg,#colibri .style-787 >  div > .colibri-menu-container > ul.colibri-menu li > ul li.current_page_item > a > .arrow-wrapper,#colibri .style-787 >  div > .colibri-menu-container > ul.colibri-menu li > ul > li.current_page_item:hover > a > .arrow-wrapper {\n  color: black;\n}\n\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}i:788;a:3:{s:7:\"desktop\";s:931:\"#colibri .style-788-offscreen {\n  background-color: #222B34;\n  background-image: none;\n  width: 300px !important;\n}\n#colibri .style-788-offscreenOverlay {\n  background-color: rgba(0,0,0,0.5);\n  background-image: none;\n}\n#colibri .style-788  .h-hamburger-icon {\n  background-color: rgba(0, 0, 0, 0.1);\n  background-image: none;\n  border-top-width: 0px;\n  border-top-color: black;\n  border-top-style: solid;\n  border-top-left-radius: 100%;\n  border-top-right-radius: 100%;\n  border-right-width: 0px;\n  border-right-color: black;\n  border-right-style: solid;\n  border-bottom-width: 0px;\n  border-bottom-color: black;\n  border-bottom-style: solid;\n  border-bottom-left-radius: 100%;\n  border-bottom-right-radius: 100%;\n  border-left-width: 0px;\n  border-left-color: black;\n  border-left-style: solid;\n  fill: white;\n  padding-top: 5px;\n  padding-right: 5px;\n  padding-bottom: 5px;\n  padding-left: 5px;\n  width: 24px;\n  height: 24px;\n}\n\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}i:789;a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}i:790;a:3:{s:7:\"desktop\";s:3947:\"#colibri .style-790 >  div > .colibri-menu-container > ul.colibri-menu > li > a {\n  padding-top: 12px;\n  padding-bottom: 12px;\n  padding-left: 40px;\n  border-top-width: 0px;\n  border-top-color: #808080;\n  border-top-style: solid;\n  border-right-width: 0px;\n  border-right-color: #808080;\n  border-right-style: solid;\n  border-bottom-width: 1px;\n  border-bottom-color: #808080;\n  border-bottom-style: solid;\n  border-left-width: 0px;\n  border-left-color: #808080;\n  border-left-style: solid;\n  font-size: 14px;\n  color: white;\n}\n#colibri .style-790  >  div > .colibri-menu-container > ul.colibri-menu > li.current_page_item > a,#colibri .style-790  >  div > .colibri-menu-container > ul.colibri-menu > li.current_page_item > a:hover {\n  padding-top: 12px;\n  padding-bottom: 12px;\n  padding-left: 40px;\n  border-top-width: 0px;\n  border-top-color: #808080;\n  border-top-style: solid;\n  border-right-width: 0px;\n  border-right-color: #808080;\n  border-right-style: solid;\n  border-bottom-width: 1px;\n  border-bottom-color: #808080;\n  border-bottom-style: solid;\n  border-left-width: 0px;\n  border-left-color: #808080;\n  border-left-style: solid;\n  font-size: 14px;\n  color: white;\n}\n#colibri .style-790 >  div > .colibri-menu-container > ul.colibri-menu li > ul > li > a {\n  padding-top: 12px;\n  padding-bottom: 12px;\n  padding-left: 40px;\n  border-top-width: 0px;\n  border-top-color: #808080;\n  border-top-style: solid;\n  border-right-width: 0px;\n  border-right-color: #808080;\n  border-right-style: solid;\n  border-bottom-width: 1px;\n  border-bottom-color: #808080;\n  border-bottom-style: solid;\n  border-left-width: 0px;\n  border-left-color: #808080;\n  border-left-style: solid;\n  font-size: 14px;\n  color: white;\n}\n#colibri .style-790 >  div > .colibri-menu-container > ul.colibri-menu li > ul > li.current_page_item > a,#colibri .style-790  >  div > .colibri-menu-container > ul.colibri-menu li > ul > li.current_page_item > a:hover {\n  padding-top: 12px;\n  padding-bottom: 12px;\n  padding-left: 40px;\n  border-top-width: 0px;\n  border-top-color: #808080;\n  border-top-style: solid;\n  border-right-width: 0px;\n  border-right-color: #808080;\n  border-right-style: solid;\n  border-bottom-width: 1px;\n  border-bottom-color: #808080;\n  border-bottom-style: solid;\n  border-left-width: 0px;\n  border-left-color: #808080;\n  border-left-style: solid;\n  font-size: 14px;\n  color: white;\n}\n#colibri .style-790 >  div > .colibri-menu-container > ul.colibri-menu  li > a > svg,#colibri .style-790 >  div > .colibri-menu-container > ul.colibri-menu  li > a >  .arrow-wrapper {\n  padding-right: 20px;\n  padding-left: 20px;\n  color: black;\n}\n#colibri .style-790 >  div > .colibri-menu-container > ul.colibri-menu li.current_page_item > a > svg,#colibri .style-790 >  div > .colibri-menu-container > ul.colibri-menu > li.current_page_item:hover > a > svg,#colibri .style-790 >  div > .colibri-menu-container > ul.colibri-menu li.current_page_item > a > .arrow-wrapper,#colibri .style-790 >  div > .colibri-menu-container > ul.colibri-menu > li.current_page_item:hover > a > .arrow-wrapper {\n  padding-right: 20px;\n  padding-left: 20px;\n  color: black;\n}\n#colibri .style-790 >  div > .colibri-menu-container > ul.colibri-menu li > ul  li > a > svg,#colibri .style-790 >  div > .colibri-menu-container > ul.colibri-menu li > ul  li > a >  .arrow-wrapper {\n  color: white;\n  padding-right: 20px;\n  padding-left: 20px;\n}\n#colibri .style-790 >  div > .colibri-menu-container > ul.colibri-menu li > ul li.current_page_item > a > svg,#colibri .style-790 >  div > .colibri-menu-container > ul.colibri-menu li > ul > li.current_page_item:hover > a > svg,#colibri .style-790 >  div > .colibri-menu-container > ul.colibri-menu li > ul li.current_page_item > a > .arrow-wrapper,#colibri .style-790 >  div > .colibri-menu-container > ul.colibri-menu li > ul > li.current_page_item:hover > a > .arrow-wrapper {\n  color: white;\n  padding-right: 20px;\n  padding-left: 20px;\n}\n\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}i:791;a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}i:792;a:3:{s:7:\"desktop\";s:83:\"#colibri .style-792 {\n  text-align: center;\n  height: auto;\n  min-height: unset;\n}\n\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}i:793;a:3:{s:7:\"desktop\";s:505:\"#colibri .style-793-image {\n  max-height: 70px;\n}\n#colibri .style-793 a,#colibri .style-793  .logo-text {\n  color: #ffffff;\n  text-decoration: none;\n}\n#colibri .h-navigation_sticky .style-793-image,#colibri .h-navigation_sticky.style-793-image {\n  max-height: 70px;\n}\n#colibri .h-navigation_sticky .style-793 a,#colibri .h-navigation_sticky .style-793  .logo-text,#colibri .h-navigation_sticky.style-793 a,#colibri .h-navigation_sticky.style-793  .logo-text {\n  color: #000000;\n  text-decoration: none;\n}\n\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}i:794;a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}i:795;a:3:{s:7:\"desktop\";s:83:\"#colibri .style-795 {\n  text-align: center;\n  height: auto;\n  min-height: unset;\n}\n\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}i:796;a:3:{s:7:\"desktop\";s:107:\"#colibri .style-796 ol {\n  list-style-type: decimal;\n}\n#colibri .style-796 ul {\n  list-style-type: disc;\n}\n\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}i:797;a:3:{s:7:\"desktop\";s:681:\"#colibri .style-797 {\n  min-height: 100vh;\n  color: #FFFFFF;\n  background-position: 48.95233519860165% 80.23705380915509%;\n  background-size: cover;\n  background-image: url(\"http://localhost/wordpress/wp-content/uploads/2024/10/karibea-banniere-1.png\");\n  background-attachment: scroll;\n  background-repeat: no-repeat;\n  padding-top: 150px;\n  padding-bottom: 52px;\n}\n#colibri .style-797 h1 {\n  color: #FFFFFF;\n}\n#colibri .style-797 h2 {\n  color: #FFFFFF;\n}\n#colibri .style-797 h3 {\n  color: #FFFFFF;\n}\n#colibri .style-797 h4 {\n  color: #FFFFFF;\n}\n#colibri .style-797 h5 {\n  color: #FFFFFF;\n}\n#colibri .style-797 h6 {\n  color: #FFFFFF;\n}\n#colibri .style-797 p {\n  color: #FFFFFF;\n}\n\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}i:798;a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}i:799;a:3:{s:7:\"desktop\";s:83:\"#colibri .style-799 {\n  text-align: center;\n  height: auto;\n  min-height: unset;\n}\n\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}i:800;a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}i:801;a:3:{s:7:\"desktop\";s:116:\"#colibri .style-801 {\n  height: auto;\n  min-height: unset;\n  background-color: #F5FAFD;\n  background-image: none;\n}\n\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}i:802;a:3:{s:7:\"desktop\";s:86:\"#colibri .style-802 {\n  background-color: rgb(42, 25, 2);\n  background-image: none;\n}\n\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}i:803;a:3:{s:7:\"desktop\";s:568:\"#colibri .style-803 {\n  text-align: center;\n  height: auto;\n  min-height: unset;\n  background-position: center center;\n  background-size: cover;\n  background-image: url(\"http://localhost/wordpress/wp-content/uploads/2024/10/DALL·E-2024-10-31-18.11.50-A-welcoming-and-professional-image-representing-real-estate-services-in-Martinique.-Show-a-sunny-tropical-environment-with-modern-beachfront-or-hillsi.webp\");\n  background-attachment: scroll;\n  background-repeat: no-repeat;\n  padding-top: 99px;\n  padding-right: 99px;\n  padding-bottom: 99px;\n  padding-left: 99px;\n}\n\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}i:804;a:3:{s:7:\"desktop\";s:568:\"#colibri .style-804 {\n  text-align: center;\n  height: auto;\n  min-height: unset;\n  background-position: center center;\n  background-size: cover;\n  background-image: url(\"http://localhost/wordpress/wp-content/uploads/2024/10/DALL·E-2024-10-31-19.51.44-A-welcoming-and-professional-image-for-a-seasonal-rental-service-in-Martinique.-Show-a-realistic-tropical-vacation-rental-setup-with-cozy-outdoor-spac.webp\");\n  background-attachment: scroll;\n  background-repeat: no-repeat;\n  padding-top: 99px;\n  padding-right: 99px;\n  padding-bottom: 99px;\n  padding-left: 99px;\n}\n\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}i:808;a:3:{s:7:\"desktop\";s:433:\"#colibri .style-808 p,#colibri .style-808  h1,#colibri .style-808  h2,#colibri .style-808  h3,#colibri .style-808  h4,#colibri .style-808  h5,#colibri .style-808  h6 {\n  text-shadow: 0px 0px 10px \n        rgba(0,0,0,0.5);\n  font-weight: 600;\n  color: #000000;\n  text-align: center;\n}\n#colibri .style-808 .text-wrapper-fancy svg path {\n  stroke: #000000;\n  stroke-linejoin: initial;\n  stroke-linecap: initial;\n  stroke-width: 12px;\n}\n\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}i:812;a:3:{s:7:\"desktop\";s:432:\"#colibri .style-812 p,#colibri .style-812  h1,#colibri .style-812  h2,#colibri .style-812  h3,#colibri .style-812  h4,#colibri .style-812  h5,#colibri .style-812  h6 {\n  font-weight: 600;\n  color: #000000;\n  text-shadow: 0px 0px 10px \n        rgba(0,0,0,0.5);\n  text-align: center;\n}\n#colibri .style-812 .text-wrapper-fancy svg path {\n  stroke: #000000;\n  stroke-linejoin: initial;\n  stroke-linecap: initial;\n  stroke-width: 8px;\n}\n\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}i:813;a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}i:814;a:3:{s:7:\"desktop\";s:116:\"#colibri .style-814 {\n  height: auto;\n  min-height: unset;\n  background-color: #000000;\n  background-image: none;\n}\n\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}i:815;a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}i:816;a:3:{s:7:\"desktop\";s:83:\"#colibri .style-816 {\n  text-align: center;\n  height: auto;\n  min-height: unset;\n}\n\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}i:817;a:3:{s:7:\"desktop\";s:235:\"#colibri .style-817 {\n  text-align: left;\n  color: rgb(204, 204, 204);\n}\n#colibri .style-817 p {\n  color: rgb(204, 204, 204);\n}\n#colibri .style-817 ol {\n  list-style-type: decimal;\n}\n#colibri .style-817 ul {\n  list-style-type: disc;\n}\n\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}i:818;a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}i:819;a:3:{s:7:\"desktop\";s:83:\"#colibri .style-819 {\n  text-align: center;\n  height: auto;\n  min-height: unset;\n}\n\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}i:820;a:3:{s:7:\"desktop\";s:347:\"#colibri .style-820 p,#colibri .style-820  h1,#colibri .style-820  h2,#colibri .style-820  h3,#colibri .style-820  h4,#colibri .style-820  h5,#colibri .style-820  h6 {\n  color: rgb(204, 204, 204);\n}\n#colibri .style-820 .text-wrapper-fancy svg path {\n  stroke: #000000;\n  stroke-linejoin: initial;\n  stroke-linecap: initial;\n  stroke-width: 8px;\n}\n\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}i:821;a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}i:822;a:3:{s:7:\"desktop\";s:116:\"#colibri .style-822 {\n  height: auto;\n  min-height: unset;\n  background-color: #000000;\n  background-image: none;\n}\n\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}i:823;a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}i:824;a:3:{s:7:\"desktop\";s:83:\"#colibri .style-824 {\n  text-align: center;\n  height: auto;\n  min-height: unset;\n}\n\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}i:825;a:3:{s:7:\"desktop\";s:235:\"#colibri .style-825 {\n  color: rgb(204, 204, 204);\n  text-align: left;\n}\n#colibri .style-825 p {\n  color: rgb(204, 204, 204);\n}\n#colibri .style-825 ol {\n  list-style-type: decimal;\n}\n#colibri .style-825 ul {\n  list-style-type: disc;\n}\n\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}i:826;a:3:{s:7:\"desktop\";s:367:\"#colibri .style-826 p,#colibri .style-826  h1,#colibri .style-826  h2,#colibri .style-826  h3,#colibri .style-826  h4,#colibri .style-826  h5,#colibri .style-826  h6 {\n  font-size: 3.3em;\n  color: rgb(204, 204, 204);\n}\n#colibri .style-826 .text-wrapper-fancy svg path {\n  stroke: #000000;\n  stroke-linejoin: initial;\n  stroke-linecap: initial;\n  stroke-width: 8px;\n}\n\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}i:827;a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}i:828;a:3:{s:7:\"desktop\";s:83:\"#colibri .style-828 {\n  text-align: center;\n  height: auto;\n  min-height: unset;\n}\n\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}i:829;a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}i:830;a:3:{s:7:\"desktop\";s:83:\"#colibri .style-830 {\n  text-align: center;\n  height: auto;\n  min-height: unset;\n}\n\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}i:831;a:3:{s:7:\"desktop\";s:148:\"#colibri .style-831 .text-wrapper-fancy svg path {\n  stroke: #000000;\n  stroke-linejoin: initial;\n  stroke-linecap: initial;\n  stroke-width: 8px;\n}\n\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}i:832;a:3:{s:7:\"desktop\";s:107:\"#colibri .style-832 ol {\n  list-style-type: decimal;\n}\n#colibri .style-832 ul {\n  list-style-type: disc;\n}\n\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}i:840;a:3:{s:7:\"desktop\";s:79:\"#colibri .style-840 {\n  background-color: #000000;\n  background-image: none;\n}\n\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}i:841;a:3:{s:7:\"desktop\";s:90:\"#colibri .style-841 {\n  min-height: 300px;\n  padding-top: 30px;\n  padding-bottom: 30px;\n}\n\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}i:842;a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}i:843;a:3:{s:7:\"desktop\";s:158:\".style-843 > .h-y-container > *:not(:last-child) {\n  margin-bottom: 0px;\n}\n#colibri .style-843 {\n  text-align: center;\n  height: auto;\n  min-height: unset;\n}\n\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}i:844;a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}i:845;a:3:{s:7:\"desktop\";s:234:\"#colibri .style-845 {\n  height: auto;\n  min-height: unset;\n  padding-top: 0px;\n  padding-bottom: 0px;\n  background-color: #F5FAFD;\n  background-image: none;\n}\n#colibri .style-845  > .h-section-grid-container {\n  margin-top: -255px;\n}\n\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:43:\"#colibri .style-845 {\n  margin-top: 0px;\n}\n\";}i:846;a:3:{s:7:\"desktop\";s:134:\"#colibri .style-846 {\n  box-shadow: 0px 4px 10px 2px rgba(74, 74, 74, 0.3) ;\n  background-color: #FFFFFF;\n  background-image: none;\n}\n\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:110:\"#colibri .style-846 {\n  margin-top: 15px;\n  margin-right: 15px;\n  margin-bottom: 15px;\n  margin-left: 15px;\n}\n\";}i:847;a:3:{s:7:\"desktop\";s:524:\"#colibri .style-847 {\n  text-align: center;\n  height: auto;\n  min-height: unset;\n  border-top-width: 0px;\n  border-top-color: rgb(221, 221, 221);\n  border-top-style: solid;\n  border-right-width: 1px;\n  border-right-color: rgb(221, 221, 221);\n  border-right-style: solid;\n  border-bottom-width: 0px;\n  border-bottom-color: rgb(221, 221, 221);\n  border-bottom-style: solid;\n  border-left-width: 0px;\n  border-left-color: rgb(221, 221, 221);\n  border-left-style: solid;\n  background-color: #000000;\n  background-image: none;\n}\n\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}i:849;a:3:{s:7:\"desktop\";s:418:\"#colibri .style-849 p,#colibri .style-849  h1,#colibri .style-849  h2,#colibri .style-849  h3,#colibri .style-849  h4,#colibri .style-849  h5,#colibri .style-849  h6 {\n  text-transform: uppercase;\n  font-size: 11px;\n  letter-spacing: 1px;\n  color: rgb(153, 153, 153);\n}\n#colibri .style-849 .text-wrapper-fancy svg path {\n  stroke: #000000;\n  stroke-linejoin: initial;\n  stroke-linecap: initial;\n  stroke-width: 8px;\n}\n\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}i:850;a:3:{s:7:\"desktop\";s:107:\"#colibri .style-850 ol {\n  list-style-type: decimal;\n}\n#colibri .style-850 ul {\n  list-style-type: disc;\n}\n\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}i:851;a:3:{s:7:\"desktop\";s:524:\"#colibri .style-851 {\n  text-align: center;\n  height: auto;\n  min-height: unset;\n  border-top-width: 0px;\n  border-top-color: rgb(221, 221, 221);\n  border-top-style: solid;\n  border-right-width: 0px;\n  border-right-color: rgb(221, 221, 221);\n  border-right-style: solid;\n  border-bottom-width: 0px;\n  border-bottom-color: rgb(221, 221, 221);\n  border-bottom-style: solid;\n  border-left-width: 0px;\n  border-left-color: rgb(221, 221, 221);\n  border-left-style: solid;\n  background-color: #000000;\n  background-image: none;\n}\n\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}i:852;a:3:{s:7:\"desktop\";s:366:\"#colibri .style-852 p,#colibri .style-852  h1,#colibri .style-852  h2,#colibri .style-852  h3,#colibri .style-852  h4,#colibri .style-852  h5,#colibri .style-852  h6 {\n  font-size: 11px;\n  color: rgb(153, 153, 153);\n}\n#colibri .style-852 .text-wrapper-fancy svg path {\n  stroke: #000000;\n  stroke-linejoin: initial;\n  stroke-linecap: initial;\n  stroke-width: 8px;\n}\n\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}i:853;a:3:{s:7:\"desktop\";s:366:\"#colibri .style-853 p,#colibri .style-853  h1,#colibri .style-853  h2,#colibri .style-853  h3,#colibri .style-853  h4,#colibri .style-853  h5,#colibri .style-853  h6 {\n  font-size: 11px;\n  color: rgb(153, 153, 153);\n}\n#colibri .style-853 .text-wrapper-fancy svg path {\n  stroke: #000000;\n  stroke-linejoin: initial;\n  stroke-linecap: initial;\n  stroke-width: 8px;\n}\n\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}i:854;a:3:{s:7:\"desktop\";s:366:\"#colibri .style-854 p,#colibri .style-854  h1,#colibri .style-854  h2,#colibri .style-854  h3,#colibri .style-854  h4,#colibri .style-854  h5,#colibri .style-854  h6 {\n  font-size: 11px;\n  color: rgb(153, 153, 153);\n}\n#colibri .style-854 .text-wrapper-fancy svg path {\n  stroke: #000000;\n  stroke-linejoin: initial;\n  stroke-linecap: initial;\n  stroke-width: 8px;\n}\n\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}i:855;a:3:{s:7:\"desktop\";s:366:\"#colibri .style-855 p,#colibri .style-855  h1,#colibri .style-855  h2,#colibri .style-855  h3,#colibri .style-855  h4,#colibri .style-855  h5,#colibri .style-855  h6 {\n  font-size: 11px;\n  color: rgb(153, 153, 153);\n}\n#colibri .style-855 .text-wrapper-fancy svg path {\n  stroke: #000000;\n  stroke-linejoin: initial;\n  stroke-linecap: initial;\n  stroke-width: 8px;\n}\n\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}i:856;a:3:{s:7:\"desktop\";s:366:\"#colibri .style-856 p,#colibri .style-856  h1,#colibri .style-856  h2,#colibri .style-856  h3,#colibri .style-856  h4,#colibri .style-856  h5,#colibri .style-856  h6 {\n  font-size: 11px;\n  color: rgb(153, 153, 153);\n}\n#colibri .style-856 .text-wrapper-fancy svg path {\n  stroke: #000000;\n  stroke-linejoin: initial;\n  stroke-linecap: initial;\n  stroke-width: 8px;\n}\n\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}i:857;a:3:{s:7:\"desktop\";s:366:\"#colibri .style-857 p,#colibri .style-857  h1,#colibri .style-857  h2,#colibri .style-857  h3,#colibri .style-857  h4,#colibri .style-857  h5,#colibri .style-857  h6 {\n  font-size: 11px;\n  color: rgb(153, 153, 153);\n}\n#colibri .style-857 .text-wrapper-fancy svg path {\n  stroke: #000000;\n  stroke-linejoin: initial;\n  stroke-linecap: initial;\n  stroke-width: 8px;\n}\n\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}i:858;a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}i:866;a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}i:867;a:3:{s:7:\"desktop\";s:83:\"#colibri .style-867 {\n  text-align: center;\n  height: auto;\n  min-height: unset;\n}\n\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}i:868;a:3:{s:7:\"desktop\";s:83:\"#colibri .style-868 {\n  text-align: center;\n  height: auto;\n  min-height: unset;\n}\n\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}i:869;a:3:{s:7:\"desktop\";s:646:\"#colibri .style-869-icon {\n  fill: #FFFFFF;\n  width: 40px ;\n  height: 40px;\n  padding-top: 15px;\n  padding-right: 15px;\n  padding-bottom: 15px;\n  padding-left: 15px;\n  border-top-width: 2px;\n  border-top-color: #FFFFFF;\n  border-top-style: solid;\n  border-top-left-radius: 44px;\n  border-top-right-radius: 44px;\n  border-right-width: 2px;\n  border-right-color: #FFFFFF;\n  border-right-style: solid;\n  border-bottom-width: 2px;\n  border-bottom-color: #FFFFFF;\n  border-bottom-style: solid;\n  border-bottom-left-radius: 44px;\n  border-bottom-right-radius: 44px;\n  border-left-width: 2px;\n  border-left-color: #FFFFFF;\n  border-left-style: solid;\n}\n\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}i:870;a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}i:871;a:3:{s:7:\"desktop\";s:83:\"#colibri .style-871 {\n  text-align: center;\n  height: auto;\n  min-height: unset;\n}\n\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}i:872;a:3:{s:7:\"desktop\";s:83:\"#colibri .style-872 {\n  text-align: center;\n  height: auto;\n  min-height: unset;\n}\n\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}i:873;a:3:{s:7:\"desktop\";s:215:\"#colibri .style-873 {\n  text-align: center;\n  color: #FFFFFF;\n}\n#colibri .style-873 p {\n  color: #FFFFFF;\n}\n#colibri .style-873 ol {\n  list-style-type: decimal;\n}\n#colibri .style-873 ul {\n  list-style-type: disc;\n}\n\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}i:874;a:3:{s:7:\"desktop\";s:193:\"#colibri .style-874 {\n  color: #FFFFFF;\n}\n#colibri .style-874 p {\n  color: #FFFFFF;\n}\n#colibri .style-874 ol {\n  list-style-type: decimal;\n}\n#colibri .style-874 ul {\n  list-style-type: disc;\n}\n\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}i:875;a:3:{s:7:\"desktop\";s:700:\"#colibri .style-875-icon {\n  fill: #FFFFFF;\n  width: 40px ;\n  height: 40px;\n  padding-top: 15px;\n  padding-right: 15px;\n  padding-bottom: 15px;\n  padding-left: 15px;\n  border-top-width: 02px;\n  border-top-color: #FFFFFF;\n  border-top-style: solid;\n  border-top-left-radius: 145px;\n  border-top-right-radius: 145px;\n  border-right-width: 02px;\n  border-right-color: #FFFFFF;\n  border-right-style: solid;\n  border-bottom-width: 02px;\n  border-bottom-color: #FFFFFF;\n  border-bottom-style: solid;\n  border-bottom-left-radius: 145px;\n  border-bottom-right-radius: 145px;\n  border-left-width: 02px;\n  border-left-color: #FFFFFF;\n  border-left-style: solid;\n}\n#colibri .style-875 {\n  text-align: center;\n}\n\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}i:876;a:3:{s:7:\"desktop\";s:193:\"#colibri .style-876 {\n  color: #FFFFFF;\n}\n#colibri .style-876 p {\n  color: #FFFFFF;\n}\n#colibri .style-876 ol {\n  list-style-type: decimal;\n}\n#colibri .style-876 ul {\n  list-style-type: disc;\n}\n\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}}s:5:\"rules\";s:278931:\"[{\"id\":1,\"type\":\"hop-header\",\"v\":\"1.1\",\"nodes\":[\"7-h1\",\"1833-h1\",\"18-h1\"]},{\"id\":2,\"style\":{\"ancestor\":{\"sticky\":{\"background\":{\"color\":\"#ffffff\"},\"padding\":{\"top\":{\"path\":\"value\",\"value\":0},\"bottom\":{\"path\":\"value\",\"value\":0}},\"media\":{\"mobile\":{\"padding\":{\"top\":{\"path\":\"value\",\"value\":\"0\"},\"bottom\":{\"path\":\"value\",\"value\":\"0\"}}}},\"boxShadow\":{\"enabled\":true,\"layers\":[{\"spread\":\"0\",\"blur\":\"10\",\"color\":\"rgba(0, 0, 0, 0.05)\",\"x\":\"0\",\"y\":\"5\"}]}}},\"padding\":{\"top\":{\"path\":\"value\",\"value\":3,\"unit\":\"px\"},\"bottom\":{\"path\":\"value\",\"value\":3,\"unit\":\"px\"}},\"media\":{\"mobile\":{\"padding\":{\"top\":{\"path\":\"value\",\"value\":\"0\"},\"bottom\":{\"path\":\"value\",\"value\":\"0\"}}}},\"background\":{\"color\":\"#ffffff\"}},\"type\":\"hop-navigation\",\"props\":{\"overlap\":false,\"sticky\":true,\"stickyStartAt\":\"immediately\",\"showTopBar\":false,\"width\":\"full-width\",\"layoutType\":\"logo-above-menu\"},\"v\":\"1.1\",\"nodes\":[\"10-h2\",\"7-h2\",\"1833-h2\",\"1837-h2\",\"18-h2\",\"22-h2\"]},{\"id\":3,\"props\":{\"containerWidth\":\"boxed\",\"layout\":{\"equalWidth\":false,\"itemsPerRow\":1,\"horizontalGap\":0,\"verticalGap\":0,\"horizontalInnerGap\":0,\"verticalInnerGap\":0},\"media\":{\"mobile\":{\"layout\":{\"horizontalGap\":2,\"verticalGap\":2}}}},\"type\":\"hop-row\",\"v\":\"1.1\",\"nodes\":[\"10-h3\",\"7-h3\",\"1833-h3\",\"1837-h3\",\"18-h3\",\"22-h3\"]},{\"id\":4,\"props\":{\"verticalAlign\":\"center\",\"layout\":{\"horizontalInnerGap\":0,\"verticalInnerGap\":0}},\"type\":\"hop-column\",\"style\":{\"descendants\":{\"outer\":{\"padding\":{\"left\":{\"unit\":\"px\"},\"right\":{\"unit\":\"px\"},\"top\":{\"unit\":\"px\"},\"bottom\":{\"unit\":\"px\"}},\"media\":{\"mobile\":{\"padding\":{\"left\":{\"unit\":\"px\"},\"right\":{\"unit\":\"px\"},\"top\":{\"unit\":\"px\"},\"bottom\":{\"unit\":\"px\"}}}}}},\"padding\":{\"left\":{\"unit\":\"px\"},\"right\":{\"unit\":\"px\"},\"top\":{\"unit\":\"px\"},\"bottom\":{\"unit\":\"px\"}}},\"v\":\"1.1\",\"nodes\":[\"10-h4\",\"7-h4\",\"1833-h4\",\"1837-h4\",\"22-h4\",\"18-h4\"]},{\"id\":5,\"type\":\"hop-logo\",\"props\":{\"horizontalTextAlign\":\"center\",\"media\":{\"mobile\":{\"horizontalTextAlign\":\"left\"}},\"layoutType\":\"text\"},\"v\":\"1.1\",\"nodes\":[\"10-h5\",\"7-h5\",\"1833-h5\",\"1837-h5\",\"18-h5\"],\"style\":{\"descendants\":{\"logo-text\":{\"typography\":{\"color\":\"${theme.colors.4}\"}},\"text\":{\"typography\":{\"weight\":\"600\",\"size\":{\"unit\":\"px\",\"value\":\"15\"},\"transform\":\"uppercase\",\"letterSpacing\":{\"unit\":\"px\",\"value\":\"2\"},\"family\":\"Montserrat\"}}},\"color\":\"#fff\"}},{\"id\":6,\"style\":{\"padding\":{\"top\":{\"unit\":\"px\"},\"bottom\":{\"unit\":\"px\"},\"left\":{\"unit\":\"px\"},\"right\":{\"unit\":\"px\"}},\"descendants\":{\"outer\":{\"padding\":{\"top\":{\"unit\":\"px\"},\"bottom\":{\"unit\":\"px\"},\"left\":{\"unit\":\"px\"},\"right\":{\"unit\":\"px\"}}}}},\"props\":{\"verticalAlign\":\"center\",\"hide\":{\"mobile\":true}},\"type\":\"hop-column\",\"nodeId\":\"7-h66\",\"v\":\"1.1\",\"nodes\":[\"10-h6\",\"7-h6\",\"1833-h6\",\"1837-h6\"]},{\"id\":7,\"type\":\"hop-spacer\",\"nodeId\":\"7-h78\",\"v\":\"1.1\",\"nodes\":[\"10-h7\",\"7-h7\",\"1833-h7\",\"1837-h7\"]},{\"id\":8,\"props\":{\"verticalAlign\":\"center\"},\"type\":\"hop-column\",\"style\":{\"descendants\":{\"outer\":{\"padding\":{\"left\":{\"unit\":\"px\"},\"right\":{\"unit\":\"px\"},\"top\":{\"unit\":\"px\"},\"bottom\":{\"unit\":\"px\"}}}},\"textAlign\":\"center\",\"media\":{\"mobile\":{\"textAlign\":\"center\"}},\"padding\":{\"left\":{\"unit\":\"px\"},\"right\":{\"unit\":\"px\"},\"top\":{\"unit\":\"px\"},\"bottom\":{\"unit\":\"px\"}},\"ancestor\":{\"sticky\":{\"descendants\":{\"outer\":{\"padding\":{\"left\":{\"unit\":\"px\",\"value\":\"\"},\"right\":{\"unit\":\"px\",\"value\":\"\"},\"top\":{\"unit\":\"px\",\"value\":\"\"},\"bottom\":{\"unit\":\"px\",\"value\":\"\"}}}}}}},\"v\":\"1.1\",\"nodes\":[\"10-h8\",\"7-h8\",\"1833-h8\",\"1837-h8\",\"18-h4\",\"22-h4\"]},{\"id\":9,\"type\":\"hop-horizontal-menu\",\"style\":{\"descendants\":{\"item\":{\"margin\":{\"top\":{\"value\":\"0\",\"unit\":\"px\"},\"right\":{\"value\":7,\"unit\":\"px\"},\"bottom\":{\"value\":\"0\",\"unit\":\"px\"},\"left\":{\"value\":7,\"unit\":\"px\"}},\"padding\":{\"top\":{\"value\":20,\"unit\":\"px\"},\"right\":{\"value\":21,\"unit\":\"px\"},\"bottom\":{\"value\":20,\"unit\":\"px\"},\"left\":{\"value\":21,\"unit\":\"px\"}}},\"link\":{\"typography\":{\"weight\":\"500\",\"size\":{\"unit\":\"px\",\"value\":\"12\"},\"transform\":\"uppercase\",\"family\":\"Montserrat\",\"lineHeight\":{\"unit\":\"em\",\"value\":\"1.5\"},\"letterSpacing\":{\"unit\":\"px\",\"value\":\"1\"},\"color\":\"${theme.colors.5}\"},\"states\":{\"hover\":{\"typography\":{\"color\":\"${theme.colors.5}\"}},\"menuButtonActive\":{\"typography\":{\"color\":\"${theme.colors.5}\"}}}},\"submenu\":{\"boxShadow\":{\"enabled\":true,\"layers\":[{\"blur\":\"5\",\"color\":\"rgba(0, 0, 0, 0.04)\"}]}},\"submenu-item\":{\"background\":{\"color\":\"rgb(255, 255, 255)\"},\"states\":{\"hover\":{\"background\":{\"color\":\"${theme.colors.1}\"}},\"menuButtonActive\":{\"background\":{\"color\":\"${theme.colors.1}\"}}}},\"submenu-item-link\":{\"states\":{\"hover\":{\"typography\":{\"color\":\"rgb(255, 255, 255)\"}},\"menuButtonActive\":{\"typography\":{\"color\":\"rgb(255, 255, 255)\"}}},\"typography\":{\"color\":\"${theme.colors.1}\"}},\"subMenuIcon\":{\"typography\":{\"color\":\"${theme.colors.4}\"},\"states\":{\"hover\":{\"typography\":{\"color\":\"${theme.colors.4}\"}},\"menuButtonActive\":{\"typography\":{\"color\":\"${theme.colors.4}\"}}}},\"hover-effect-border\":{\"background\":{\"color\":\"${theme.colors.5}\"},\"height\":{\"path\":\"value\",\"value\":3}},\"mainMenuIcon\":{\"typography\":{\"color\":\"${theme.colors.5}\"},\"padding\":{\"left\":{\"value\":16,\"unit\":\"px\"},\"right\":{\"value\":16,\"unit\":\"px\"}}},\"innerMenu\":{\"justifyContent\":\"flex-end\",\"media\":{\"mobile\":{\"justifyContent\":\"center\"}}}},\"ancestor\":{\"sticky\":{\"descendants\":{\"link\":{\"typography\":{\"color\":\"${theme.colors.5}\"},\"states\":{\"menuButtonActive\":{\"typography\":{\"color\":\"${theme.colors.5}\"}},\"hover\":{\"typography\":{\"color\":\"${theme.colors.5}\"}}}},\"mainMenuIcon\":{\"typography\":{\"color\":\"${theme.colors.5}\"},\"padding\":{\"left\":{\"value\":0},\"right\":{\"value\":0}}},\"hover-effect-border\":{\"background\":{\"color\":\"${theme.colors.5}\"}},\"item\":{\"margin\":{\"left\":{\"value\":8},\"right\":{\"value\":8}},\"padding\":{\"left\":{\"value\":\"53\"},\"right\":{\"value\":\"53\"},\"top\":{\"value\":\"12\"},\"bottom\":{\"value\":\"12\"}}},\"submenu-item\":{\"background\":{\"color\":\"${theme.colors.4}\"},\"states\":{\"hover\":{\"background\":{\"color\":\"${theme.colors.1}\"}}}},\"submenu-item-link\":{\"typography\":{\"color\":\"${theme.colors.1}\"},\"states\":{\"hover\":{\"typography\":{\"color\":\"${theme.colors.4}\"}}}}}}}},\"props\":{\"hoverEffect\":{\"type\":\"bordered-active-item bordered-active-item--bottom\",\"activeGroup\":\"border\",\"group\":{\"border\":{\"transition\":\"effect-borders-grow grow-from-center\"}},\"enabled\":true},\"sticky\":true,\"showOffscreenMenuOn\":\"has-offcanvas-tablet\"},\"v\":\"1.1\",\"nodes\":[\"10-h9\",\"7-h9\",\"1833-h9\",\"1837-h9\",\"18-h8\",\"22-h8\"]},{\"id\":10,\"type\":\"hop-mobile-menu\",\"nodeId\":\"7-h27\",\"nodes\":[\"10-h10\",\"7-h10\",\"1833-h10\",\"1837-h10\",\"18-h9\",\"22-h9\"],\"v\":\"1.1\",\"style\":{\"descendants\":{\"offscreen\":{\"background\":{\"color\":\"#222B34\"}}},\"ancestor\":{\"sticky\":{\"descendants\":{\"hamburgerButton\":{\"fill\":\"${theme.colors.5}\",\"background\":{\"color\":\"rgba(255, 255, 255, 0.1)\"}}}}}}},{\"id\":11,\"type\":\"hop-offscreen-panel\",\"nodeId\":\"7-h28\",\"nodes\":[\"10-h11\",\"7-h11\",\"1833-h11\",\"1837-h11\",\"18-h10\",\"22-h10\"],\"v\":\"1.1\"},{\"id\":12,\"props\":{\"layout\":{\"equalWidth\":false,\"horizontalGap\":0,\"verticalGap\":0,\"horizontalInnerGap\":0,\"verticalInnerGap\":0}},\"type\":\"hop-row\",\"nodeId\":\"7-h30\",\"nodes\":[\"10-h13\",\"7-h13\",\"1833-h13\",\"1837-h13\",\"18-h12\",\"22-h12\"],\"v\":\"1.1\"},{\"id\":13,\"props\":{\"layout\":{\"horizontalInnerGap\":2,\"verticalInnerGap\":2}},\"type\":\"hop-column\",\"nodeId\":\"7-h31\",\"nodes\":[\"10-h14\",\"7-h14\",\"1833-h14\",\"1837-h14\",\"18-h13\",\"22-h13\"],\"v\":\"1.1\"},{\"id\":14,\"type\":\"hop-logo\",\"nodeId\":\"7-h32\",\"nodes\":[\"10-h15\",\"7-h15\",\"1833-h15\",\"1837-h15\",\"18-h14\",\"22-h14\"],\"v\":\"1.1\",\"style\":{\"descendants\":{\"text\":{\"typography\":{\"family\":\"Montserrat\",\"weight\":\"600\",\"size\":{\"unit\":\"px\",\"value\":\"15\"},\"transform\":\"uppercase\"}}}},\"props\":{\"layoutType\":\"text\"}},{\"id\":15,\"props\":{\"layout\":{\"equalWidth\":false,\"horizontalGap\":0,\"verticalGap\":0,\"horizontalInnerGap\":0,\"verticalInnerGap\":0}},\"type\":\"hop-row\",\"nodeId\":\"7-h33\",\"nodes\":[\"10-h16\",\"7-h16\",\"1833-h16\",\"1837-h16\",\"18-h15\",\"22-h15\"],\"v\":\"1.1\"},{\"id\":16,\"props\":{\"layout\":{\"horizontalInnerGap\":2,\"verticalInnerGap\":2}},\"type\":\"hop-column\",\"nodeId\":\"7-h34\",\"nodes\":[\"10-h17\",\"7-h17\",\"1833-h17\",\"1837-h17\",\"18-h16\",\"22-h16\"],\"v\":\"1.1\"},{\"id\":17,\"style\":{\"descendants\":{\"link\":{\"typography\":{\"color\":\"white\",\"family\":\"Montserrat\",\"weight\":\"500\",\"size\":{\"unit\":\"px\",\"value\":\"12\"},\"transform\":\"uppercase\",\"letterSpacing\":{\"unit\":\"px\",\"value\":\"1\"}}},\"submenu-item-link\":{\"typography\":{\"color\":\"white\"}},\"iconOption\":{\"typography\":{\"color\":\"white\"}},\"subMenuIcon\":{\"typography\":{\"color\":\"white\"}},\"item\":{\"border\":{\"bottom\":{\"color\":\"rgba(255, 255, 255, 0.2)\"}},\"states\":{\"hover\":{\"background\":{\"color\":\"${theme.colors.0}\"}},\"menuButtonActive\":{\"background\":{\"color\":\"${theme.colors.0}\"}}}},\"mainMenuIcon\":{\"typography\":{\"color\":\"${theme.colors.4}\"},\"states\":{\"hover\":{\"typography\":{\"color\":\"${theme.colors.4}\"}}}},\"submenu\":{\"background\":{\"color\":\"rgba(0,0,0,0)\"}},\"submenu-item\":{\"border\":{\"bottom\":{\"color\":\"rgba(255, 255, 255, 0.2)\"}},\"states\":{\"hover\":{\"background\":{\"color\":\"rgba(3, 169, 244, 0.8)\"}},\"menuButtonActive\":{\"background\":{\"color\":\"rgba(3, 169, 244, 0.8)\"}}}}},\"background\":{\"color\":\"rgba(0,0,0,0)\"}},\"props\":{\"layout\":\"accordion\"},\"type\":\"hop-accordion-menu\",\"nodeId\":\"7-h29\",\"nodes\":[\"10-h12\",\"7-h12\",\"1833-h12\",\"1837-h12\",\"18-h11\",\"22-h11\"],\"v\":\"1.1\"},{\"id\":18,\"type\":\"hop-top-bar\",\"props\":{\"width\":\"boxed\"},\"v\":\"1.1\",\"nodes\":[\"10-h18\",\"7-h18\",\"1833-h18\",\"1837-h18\",\"18-h17\",\"22-h17\"]},{\"id\":19,\"style\":{\"background\":{\"color\":\"${theme.colors.5}\"},\"padding\":{\"top\":{\"value\":\"5\",\"unit\":\"px\"},\"right\":{\"unit\":\"px\"},\"bottom\":{\"value\":\"5\",\"unit\":\"px\"},\"left\":{\"unit\":\"px\"}}},\"props\":{\"layout\":{\"equalWidth\":false,\"horizontalGap\":0,\"verticalGap\":0,\"horizontalInnerGap\":0,\"verticalInnerGap\":0},\"fullBackground\":true,\"hide\":{\"mobile\":true}},\"type\":\"hop-row\",\"v\":\"1.1\",\"nodes\":[\"10-h19\",\"7-h19\",\"1833-h19\",\"1837-h19\",\"18-h18\",\"22-h18\"]},{\"id\":20,\"props\":{\"verticalAlign\":\"center\",\"layout\":{\"horizontalInnerGap\":0,\"verticalInnerGap\":0}},\"type\":\"hop-column\",\"style\":{\"descendants\":{\"outer\":{\"padding\":{\"left\":{\"unit\":\"px\"},\"right\":{\"unit\":\"px\"},\"top\":{\"unit\":\"px\"},\"bottom\":{\"unit\":\"px\"}}}},\"padding\":{\"left\":{\"unit\":\"px\",\"value\":\"\"},\"right\":{\"unit\":\"px\",\"value\":\"\"},\"top\":{\"unit\":\"px\",\"value\":\"\"},\"bottom\":{\"unit\":\"px\",\"value\":\"\"}},\"textAlign\":\"left\"},\"v\":\"1.1\",\"nodes\":[\"10-h20\",\"7-h20\",\"1833-h20\",\"1837-h20\",\"18-h19\",\"22-h19\"]},{\"id\":21,\"type\":\"hop-icon-list\",\"style\":{\"descendants\":{\"li\":{\"padding\":{\"right\":{\"value\":0,\"unit\":\"px\"},\"bottom\":{\"value\":0,\"unit\":\"px\"}}},\"divider\":{\"border\":{\"left\":{\"width\":{\"value\":1,\"unit\":\"px\"}},\"bottom\":{\"width\":{\"value\":0,\"unit\":\"px\"}}},\"height\":{\"value\":100,\"unit\":\"%\"}},\"containerDivider\":{\"height\":{\"value\":100,\"unit\":\"%\"},\"width\":{\"value\":1,\"unit\":\"px\"},\"padding\":{\"left\":{\"value\":10,\"unit\":\"px\"},\"top\":{\"value\":0,\"unit\":\"px\"},\"right\":{\"value\":10,\"unit\":\"px\"},\"bottom\":{\"value\":0,\"unit\":\"px\"}}},\"icon\":{\"width\":{\"path\":\"value\",\"value\":\"18\"},\"states\":{\"hover\":{\"background\":{\"color\":\"rgba(3, 169, 244, 0)\"}}},\"height\":{\"path\":\"value\",\"value\":\"18\"},\"border\":{\"top\":{\"style\":\"none\",\"radius\":{\"left\":{\"unit\":\"px\"},\"right\":{\"unit\":\"px\"}},\"width\":{\"value\":\"2\",\"unit\":\"px\"},\"color\":\"${theme.colors.0}\"},\"right\":{\"style\":\"none\",\"width\":{\"value\":\"2\",\"unit\":\"px\"},\"color\":\"${theme.colors.0}\"},\"bottom\":{\"style\":\"none\",\"radius\":{\"left\":{\"unit\":\"px\"},\"right\":{\"unit\":\"px\"}},\"width\":{\"value\":\"2\",\"unit\":\"px\"},\"color\":\"${theme.colors.0}\"},\"left\":{\"style\":\"none\",\"width\":{\"value\":\"2\",\"unit\":\"px\"},\"color\":\"${theme.colors.0}\"}},\"padding\":{\"top\":{\"unit\":\"px\"},\"right\":{\"unit\":\"px\"},\"bottom\":{\"unit\":\"px\"},\"left\":{\"value\":0,\"unit\":\"px\",\"path\":\"value\"}},\"fill\":\"${theme.colors.4}\"},\"text\":{\"margin\":{\"left\":{\"path\":\"value\",\"value\":\"5\"}},\"color\":\"${theme.colors.4}\",\"typography\":{\"size\":{\"unit\":\"px\",\"value\":\"14\"}}},\"list-item\":{\"padding\":{\"right\":{\"value\":0,\"unit\":\"px\"},\"bottom\":{\"value\":0,\"unit\":\"px\"}},\"horizontalAlign\":\"start\"}}},\"props\":{\"iconList\":[{\"title\":\"List\",\"link\":{\"newWindow\":false,\"noFollow\":false},\"text\":\"List item #1\",\"allIcons\":false,\"icon\":\"font-awesome\\/check\",\"type\":\"svg\",\"id\":0.15907223444395},{\"title\":\"List\",\"link\":{\"newWindow\":false,\"noFollow\":false},\"text\":\"List item #2\",\"allIcons\":false,\"icon\":\"font-awesome\\/check\",\"type\":\"svg\",\"id\":0.34341111083052},{\"title\":\"List\",\"link\":{\"newWindow\":false,\"noFollow\":false},\"text\":\"List item #3\",\"allIcons\":false,\"icon\":\"font-awesome\\/check\",\"type\":\"svg\",\"id\":0.094166060197272},{\"title\":\"List\",\"link\":{\"newWindow\":false,\"noFollow\":false},\"text\":\"List item #4\",\"allIcons\":false,\"icon\":\"font-awesome\\/check\",\"type\":\"svg\",\"id\":0.5295691579822}],\"iconAndTextAlign\":\"center\",\"listLayout\":\"horizontal\"},\"v\":\"1.1\",\"nodes\":[\"10-h21\",\"7-h21\",\"1833-h21\",\"1837-h21\",\"18-h20\",\"22-h20\"]},{\"id\":22,\"props\":{\"verticalAlign\":\"center\",\"layout\":{\"horizontalInnerGap\":2,\"verticalInnerGap\":0}},\"type\":\"hop-column\",\"style\":{\"descendants\":{\"outer\":{\"padding\":{\"left\":{\"unit\":\"px\"},\"right\":{\"unit\":\"px\"},\"top\":{\"unit\":\"px\"},\"bottom\":{\"unit\":\"px\"}}}},\"padding\":{\"left\":{\"unit\":\"px\",\"value\":\"\"},\"right\":{\"unit\":\"px\",\"value\":\"\"},\"top\":{\"unit\":\"px\",\"value\":\"\"},\"bottom\":{\"unit\":\"px\",\"value\":\"\"}}},\"v\":\"1.1\",\"nodes\":[\"10-h22\",\"7-h22\",\"1833-h22\",\"1837-h22\",\"18-h21\",\"22-h21\"]},{\"id\":23,\"type\":\"hop-social-icons\",\"style\":{\"descendants\":{\"icon-content\":{\"fill\":\"rgba(255, 255, 255, 0.7)\",\"states\":{\"hover\":{\"fill\":\"${theme.colors.4}\"}},\"width\":{\"value\":\"16\"},\"height\":{\"value\":\"16\"}},\"icon\":{\"margin\":{\"right\":{\"value\":\"0\"}},\"padding\":{\"top\":{\"value\":\"5\",\"unit\":\"px\"},\"left\":{\"value\":\"10\",\"unit\":\"px\"},\"bottom\":{\"value\":\"5\",\"unit\":\"px\"},\"right\":{\"value\":\"10\",\"unit\":\"px\"}}}}},\"props\":{\"horizontalAlign\":\"end\",\"media\":{\"mobile\":{\"horizontalAlign\":\"center\"}},\"hide\":{\"mobile\":false}},\"v\":\"1.1\",\"nodes\":[\"10-h23\",\"7-h23\",\"1833-h23\",\"1837-h23\",\"18-h22\",\"22-h22\"]},{\"id\":24,\"style\":{\"background\":{\"type\":\"image\",\"overlay\":{\"enabled\":true,\"type\":\"color\",\"gradient\":{\"angle\":\"-20\",\"steps\":[{\"color\":\"rgba(183,33,255, 0.4)\",\"position\":\"0\"},{\"color\":\"rgba(33,212,253, 0.4)\",\"position\":\"100\"}],\"name\":\"october_silence\"},\"shape\":{\"value\":\"many-rounded-squares-blue\",\"isTile\":false,\"img\":\"data:image\\/png;base64,iVBORw0KGgoAAAANSUhEUgAAAAEAAAABCAYAAAAfFcSJAAAABHNCSVQICAgIfAhkiAAAAAlwSFlzAAALEgAACxIB0t1+\\/AAAABx0RVh0U29mdHdhcmUAQWRvYmUgRmlyZXdvcmtzIENTNui8sowAAAANSURBVAiZY\\/j\\/\\/z8DAAj8Av6Fzas0AAAAAElFTkSuQmCC\"},\"color\":{\"value\":\"rgb(0, 0, 0)\",\"opacity\":0.17,\"opacity_\":40},\"light\":52},\"image\":[{\"source\":{\"type\":\"image\",\"gradient\":{\"name\":\"october_silence\",\"angle\":0,\"steps\":[{\"position\":\"0\",\"color\":\"#b721ff\"},{\"position\":\"100\",\"color\":\"#21d4fd\"}]},\"url\":\"http:\\/\\/localhost\\/wordpress\\/wp-content\\/uploads\\/2024\\/09\\/logoKaribea1-1.png\"},\"useParallax\":false,\"attachment\":\"fixed\",\"position\":\"custom\",\"size\":\"custom\",\"repeat\":\"no-repeat\",\"sizeCustom\":{\"y\":{\"value\":100},\"x\":{\"value\":100}}}],\"slideshow\":{\"slides\":[{\"id\":1,\"url\":\"http:\\/\\/localhost\\/wordpress\\/wp-content\\/themes\\/brite\\/resources\\/images\\/beach-landscape-sea-water-nature-sand-1061655-pxhere.com.jpg\"},{\"id\":2,\"url\":\"http:\\/\\/localhost\\/wordpress\\/wp-content\\/themes\\/brite\\/resources\\/images\\/landscape-tree-water-nature-grass-outdoor-1327743-pxhere.com.jpg\"},{\"id\":3,\"url\":\"http:\\/\\/localhost\\/wordpress\\/wp-content\\/themes\\/brite\\/resources\\/images\\/leaf-nature-water-green-freshness-dew-1440543-pxhere.com.jpg\"}],\"duration\":{\"value\":1500},\"speed\":{\"value\":500}},\"color\":\"${theme.colors.4}\",\"video\":{\"videoType\":\"external\",\"externalUrl\":\"https:\\/\\/www.youtube.com\\/watch?v=y5zFszln1ao\",\"internalUrl\":false,\"poster\":{\"url\":\"https:\\/\\/static.colibriwp.com\\/assets\\/sources\\/colibri-demo-video-cover.jpg\"}}},\"separatorBottom\":{\"enabled\":true,\"height\":{\"value\":100,\"unit\":\"px\"},\"type\":\"opacity-fan\",\"color\":\"#FFF\",\"negative\":false},\"customHeight\":{\"type\":\"full-screen\"},\"padding\":{\"top\":{\"value\":0,\"unit\":\"px\"},\"right\":{\"value\":\"\",\"unit\":\"px\"},\"bottom\":{\"value\":0,\"unit\":\"px\"},\"left\":{\"value\":\"\",\"unit\":\"px\"}},\"typography\":{\"holders\":{\"p\":{\"color\":\"${theme.colors.4}\"},\"h1\":{\"color\":\"${theme.colors.4}\"},\"h2\":{\"color\":\"${theme.colors.4}\"},\"h3\":{\"color\":\"${theme.colors.4}\"},\"h4\":{\"color\":\"${theme.colors.4}\"},\"h5\":{\"color\":\"${theme.colors.4}\"},\"h6\":{\"color\":\"${theme.colors.4}\"}}},\"media\":{\"mobile\":{\"padding\":{\"top\":{\"value\":\"100\"}}}}},\"props\":{\"heroSection\":{\"layout\":\"textOnly\",\"mediaType\":\"hop-image\"},\"attrs\":{\"name\":\"hero\",\"id\":\"hero\"},\"width\":\"boxed\",\"layoutType\":\"textWithMediaOnRight\",\"downArrow\":{\"enabled\":true}},\"type\":\"hop-hero\",\"v\":\"1.1\",\"nodes\":[\"7-h24\",\"1833-h24\",\"18-h20\"]},{\"id\":25,\"props\":{\"layout\":{\"equalWidth\":false,\"horizontalGap\":0,\"verticalGap\":0,\"horizontalInnerGap\":3,\"verticalInnerGap\":3,\"horizontalAlign\":\"center\"},\"media\":{\"mobile\":{\"layout\":{\"horizontalGap\":2,\"verticalGap\":2,\"horizontalInnerGap\":2,\"verticalInnerGap\":2}}}},\"type\":\"hop-row\",\"v\":\"1.1\",\"nodes\":[\"7-h25\",\"1833-h25\",\"18-h21\"]},{\"id\":26,\"props\":{\"verticalAlign\":\"center\"},\"type\":\"hop-column\",\"style\":{\"border\":{\"top\":{\"style\":\"solid\",\"radius\":{\"left\":{\"value\":\"9\",\"unit\":\"px\"},\"right\":{\"value\":\"9\",\"unit\":\"px\"}}},\"right\":{\"style\":\"solid\"},\"bottom\":{\"style\":\"solid\",\"radius\":{\"left\":{\"value\":\"9\",\"unit\":\"px\"},\"right\":{\"value\":\"9\",\"unit\":\"px\"}}},\"left\":{\"style\":\"solid\"}},\"descendants\":{\"outer\":{\"media\":{\"mobile\":{\"padding\":{\"left\":{\"unit\":\"px\",\"value\":\"\"},\"right\":{\"unit\":\"px\",\"value\":\"\"},\"top\":{\"unit\":\"px\",\"value\":\"\"},\"bottom\":{\"unit\":\"px\",\"value\":\"\"}}}},\"columnWidth\":{\"type\":\"custom\",\"custom\":{\"value\":100,\"unit\":\"%\"}}}},\"media\":{\"mobile\":{\"padding\":{\"left\":{\"unit\":\"px\",\"value\":\"\"},\"right\":{\"unit\":\"px\",\"value\":\"\"},\"top\":{\"unit\":\"px\",\"value\":\"\"},\"bottom\":{\"unit\":\"px\",\"value\":\"\"}}}}},\"v\":\"1.1\",\"nodes\":[\"7-h26\",\"1833-h26\",\"18-h22\"]},{\"id\":27,\"props\":{\"headerType\":\"1\"},\"type\":\"hop-heading\",\"v\":\"1.1\",\"nodes\":[\"7-h27\",\"1833-h27\",\"18-h25\"],\"style\":{\"typography\":{\"color\":\"${theme.colors.4}\"},\"padding\":{\"top\":{\"value\":\"\",\"unit\":\"px\"},\"right\":{\"value\":\"\",\"unit\":\"px\"},\"bottom\":{\"value\":\"40\",\"unit\":\"px\"},\"left\":{\"value\":\"\",\"unit\":\"px\"}},\"textAlign\":\"center\"}},{\"id\":28,\"type\":\"hop-text\",\"nodeId\":\"1833-h33\",\"nodes\":[\"1833-h28\"],\"v\":\"1.1\"},{\"id\":29,\"type\":\"hop-button-group\",\"v\":\"1.1\",\"nodes\":[\"7-h29\",\"1833-h29\",\"18-h26\"],\"style\":{\"textAlign\":\"left\"}},{\"id\":30,\"type\":\"hop-button\",\"nodeId\":\"7-h25\",\"nodes\":[\"7-h30\",\"1833-h30\",\"18-h27\"],\"v\":\"1.1\",\"style\":{\"textAlign\":\"center\",\"typography\":{\"color\":\"${theme.colors.4}\",\"family\":\"Open Sans\",\"margin\":{\"top\":\"\",\"bottom\":\"2rem\"},\"size\":{\"unit\":\"px\",\"value\":\"14\"},\"weight\":\"600\",\"lineHeight\":{\"value\":\"1\",\"unit\":\"\"},\"transform\":\"uppercase\",\"letterSpacing\":{\"value\":\"1\",\"unit\":\"px\"}},\"border\":{\"top\":{\"color\":\"${theme.colors.4}\",\"style\":\"solid\",\"width\":{\"value\":\"2\",\"unit\":\"px\"},\"radius\":{\"right\":{\"value\":\"4\",\"unit\":\"px\",\"path\":\"value\"},\"left\":{\"value\":\"4\",\"unit\":\"px\",\"path\":\"value\"}}},\"bottom\":{\"color\":\"${theme.colors.4}\",\"style\":\"solid\",\"width\":{\"value\":\"2\",\"unit\":\"px\"},\"radius\":{\"right\":{\"value\":\"4\",\"unit\":\"px\",\"path\":\"value\"},\"left\":{\"value\":\"4\",\"unit\":\"px\",\"path\":\"value\"}}},\"right\":{\"color\":\"${theme.colors.4}\",\"style\":\"solid\",\"width\":{\"value\":\"2\",\"unit\":\"px\"}},\"left\":{\"color\":\"${theme.colors.4}\",\"style\":\"solid\",\"width\":{\"value\":\"2\",\"unit\":\"px\"}}},\"padding\":{\"top\":{\"unit\":\"px\",\"value\":\"15\"},\"bottom\":{\"unit\":\"px\",\"value\":\"15\"},\"left\":{\"unit\":\"px\",\"value\":\"30\"},\"right\":{\"unit\":\"px\",\"value\":\"30\"}},\"states\":{\"hover\":{\"boxShadow\":{\"layers\":[{\"blur\":\"26\",\"y\":\"14\",\"spread\":\"-12\",\"color\":\"rgba(0, 0, 0, 0.42)\"}]},\"border\":{\"top\":{\"color\":\"${theme.colors.4}\"},\"left\":{\"color\":\"${theme.colors.4}\"},\"right\":{\"color\":\"${theme.colors.4}\"},\"bottom\":{\"color\":\"${theme.colors.4}\"}},\"background\":{\"color\":\"rgba(255, 255, 255, 0.2)\"}}},\"descendants\":{\"icon\":{\"size\":{\"unit\":\"px\",\"value\":\"14\"},\"margin\":{\"left\":{\"value\":\"0\",\"unit\":\"px\"},\"right\":{\"value\":\"10\",\"unit\":\"px\"}}}},\"transition\":{\"duration\":{\"value\":\"0.5\"}},\"background\":{\"color\":\"rgba(0,0,0,0)\"}},\"props\":{\"buttonSize\":\"large\",\"buttonWidth\":\"fitToContent\"}},{\"id\":31,\"type\":\"hop-button\",\"nodeId\":\"7-h26\",\"nodes\":[\"7-h31\",\"1833-h31\"],\"v\":\"1.1\",\"style\":{\"textAlign\":\"center\",\"typography\":{\"color\":\"${theme.colors.4}\",\"family\":\"Open Sans\",\"margin\":{\"top\":\"\",\"bottom\":\"2rem\"},\"size\":{\"unit\":\"px\",\"value\":\"14\"},\"weight\":\"600\",\"lineHeight\":{\"value\":\"1\",\"unit\":\"\"},\"transform\":\"uppercase\",\"letterSpacing\":{\"value\":\"1\",\"unit\":\"px\"}},\"border\":{\"top\":{\"color\":\"${theme.colors.4}\",\"style\":\"solid\",\"width\":{\"value\":\"2\",\"unit\":\"px\"},\"radius\":{\"right\":{\"value\":\"4\",\"unit\":\"px\",\"path\":\"value\"},\"left\":{\"value\":\"4\",\"unit\":\"px\",\"path\":\"value\"}}},\"bottom\":{\"color\":\"${theme.colors.4}\",\"style\":\"solid\",\"width\":{\"value\":\"2\",\"unit\":\"px\"},\"radius\":{\"right\":{\"value\":\"4\",\"unit\":\"px\",\"path\":\"value\"},\"left\":{\"value\":\"4\",\"unit\":\"px\",\"path\":\"value\"}}},\"right\":{\"color\":\"${theme.colors.4}\",\"style\":\"solid\",\"width\":{\"value\":\"2\",\"unit\":\"px\"}},\"left\":{\"color\":\"${theme.colors.4}\",\"style\":\"solid\",\"width\":{\"value\":\"2\",\"unit\":\"px\"}}},\"padding\":{\"top\":{\"unit\":\"px\",\"value\":\"15\"},\"bottom\":{\"unit\":\"px\",\"value\":\"15\"},\"left\":{\"unit\":\"px\",\"value\":\"30\"},\"right\":{\"unit\":\"px\",\"value\":\"30\"}},\"states\":{\"hover\":{\"boxShadow\":{\"layers\":[{\"blur\":\"26\",\"y\":\"14\",\"spread\":\"-12\",\"color\":\"rgba(0, 0, 0, 0.42)\"}]},\"border\":{\"top\":{\"color\":\"${theme.colors.4}\"},\"left\":{\"color\":\"${theme.colors.4}\"},\"right\":{\"color\":\"${theme.colors.4}\"},\"bottom\":{\"color\":\"${theme.colors.4}\"}},\"background\":{\"color\":\"rgba(255, 255, 255, 0.2)\"}}},\"descendants\":{\"icon\":{\"size\":{\"unit\":\"px\",\"value\":\"14\"},\"margin\":{\"left\":{\"value\":\"0\",\"unit\":\"px\"},\"right\":{\"value\":\"10\",\"unit\":\"px\"}}}},\"transition\":{\"duration\":{\"value\":\"0.5\"}},\"background\":{\"color\":\"rgba(0,0,0,0)\"}},\"props\":{\"buttonSize\":\"large\",\"buttonWidth\":\"fitToContent\"}},{\"id\":32,\"props\":{\"verticalAlign\":\"center\"},\"type\":\"hop-column\",\"nodeId\":\"1833-h31\",\"nodes\":[\"1833-h32\"],\"v\":\"1.1\"},{\"id\":33,\"type\":\"hop-image\",\"nodeId\":\"1833-h32\",\"nodes\":[\"1833-h33\"],\"v\":\"1.1\"},{\"id\":34,\"type\":\"hop-header\",\"nodeId\":\"4443-h1\",\"v\":\"1.1\",\"nodes\":[\"10-h1\",\"1837-h1\",\"22-h1\"]},{\"id\":35,\"style\":{\"ancestor\":{\"sticky\":{\"background\":{\"color\":\"#ffffff\"},\"padding\":{\"top\":{\"path\":\"value\",\"value\":\"10\"},\"bottom\":{\"path\":\"value\",\"value\":\"10\"}},\"media\":{\"mobile\":{\"padding\":{\"top\":{\"path\":\"value\",\"value\":\"0\"},\"bottom\":{\"path\":\"value\",\"value\":\"0\"}}}},\"boxShadow\":{\"enabled\":true,\"layers\":[{\"spread\":\"0\",\"blur\":\"10\",\"color\":\"rgba(0, 0, 0, 0.05)\",\"x\":\"0\",\"y\":\"5\"}]}}},\"padding\":{\"top\":{\"path\":\"value\",\"value\":20,\"unit\":\"px\"},\"bottom\":{\"path\":\"value\",\"value\":20,\"unit\":\"px\"}},\"media\":{\"mobile\":{\"padding\":{\"top\":{\"path\":\"value\",\"value\":\"0\"},\"bottom\":{\"path\":\"value\",\"value\":\"0\"}}}},\"background\":{\"color\":\"transparent\"}},\"type\":\"hop-navigation\",\"props\":{\"overlap\":true,\"sticky\":true,\"stickyStartAt\":\"immediately\",\"showTopBar\":false,\"width\":\"full-width\",\"layoutType\":\"logo-spacing-menu\"},\"v\":\"1.1\",\"nodes\":[\"10-h2\",\"7-h2\",\"1833-h2\",\"1837-h2\",\"22-h2\"]},{\"id\":36,\"props\":{\"containerWidth\":\"boxed\",\"layout\":{\"equalWidth\":false,\"itemsPerRow\":1,\"horizontalGap\":0,\"verticalGap\":0,\"horizontalInnerGap\":0,\"verticalInnerGap\":0},\"media\":{\"mobile\":{\"layout\":{\"horizontalGap\":2,\"verticalGap\":2}}}},\"type\":\"hop-row\",\"v\":\"1.1\",\"nodes\":[\"10-h3\",\"7-h3\",\"1833-h3\",\"1837-h3\",\"22-h3\"]},{\"id\":37,\"props\":{\"verticalAlign\":\"center\",\"layout\":{\"horizontalInnerGap\":0,\"verticalInnerGap\":0}},\"type\":\"hop-column\",\"style\":{\"descendants\":{\"outer\":{\"padding\":{\"left\":{\"unit\":\"px\"},\"right\":{\"unit\":\"px\"},\"top\":{\"unit\":\"px\"},\"bottom\":{\"unit\":\"px\"}},\"media\":{\"mobile\":{\"padding\":{\"left\":{\"unit\":\"px\"},\"right\":{\"unit\":\"px\"},\"top\":{\"unit\":\"px\"},\"bottom\":{\"unit\":\"px\"}}}}}},\"padding\":{\"left\":{\"unit\":\"px\"},\"right\":{\"unit\":\"px\"},\"top\":{\"unit\":\"px\"},\"bottom\":{\"unit\":\"px\"}}},\"v\":\"1.1\",\"nodes\":[\"10-h4\",\"7-h4\",\"1833-h4\",\"1837-h4\",\"22-h4\"]},{\"id\":38,\"type\":\"hop-logo\",\"props\":{\"horizontalTextAlign\":\"center\",\"media\":{\"mobile\":{\"horizontalTextAlign\":\"left\"}},\"layoutType\":\"text\"},\"v\":\"1.1\",\"nodes\":[\"10-h5\",\"7-h5\",\"1833-h5\",\"1837-h5\",\"22-h5\"],\"style\":{\"descendants\":{\"logo-text\":{\"typography\":{\"color\":\"${theme.colors.4}\"}},\"text\":{\"typography\":{\"weight\":\"600\",\"size\":{\"unit\":\"px\",\"value\":\"15\"},\"transform\":\"uppercase\",\"letterSpacing\":{\"unit\":\"px\",\"value\":\"2\"},\"family\":\"Montserrat\"}}}}},{\"id\":39,\"style\":{\"padding\":{\"top\":{\"unit\":\"px\"},\"bottom\":{\"unit\":\"px\"},\"left\":{\"unit\":\"px\"},\"right\":{\"unit\":\"px\"}},\"descendants\":{\"outer\":{\"padding\":{\"top\":{\"unit\":\"px\"},\"bottom\":{\"unit\":\"px\"},\"left\":{\"unit\":\"px\"},\"right\":{\"unit\":\"px\"}}}}},\"props\":{\"verticalAlign\":\"center\",\"hide\":{\"mobile\":true}},\"type\":\"hop-column\",\"nodeId\":\"7-h66\",\"v\":\"1.1\",\"nodes\":[\"10-h6\",\"7-h6\",\"1833-h6\",\"1837-h6\",\"22-h6\"]},{\"id\":40,\"type\":\"hop-spacer\",\"nodeId\":\"7-h78\",\"v\":\"1.1\",\"nodes\":[\"10-h7\",\"7-h7\",\"1833-h7\",\"1837-h7\",\"22-h7\"]},{\"id\":41,\"props\":{\"verticalAlign\":\"center\"},\"type\":\"hop-column\",\"style\":{\"descendants\":{\"outer\":{\"padding\":{\"left\":{\"unit\":\"px\"},\"right\":{\"unit\":\"px\"},\"top\":{\"unit\":\"px\"},\"bottom\":{\"unit\":\"px\"}}}},\"textAlign\":\"center\",\"media\":{\"mobile\":{\"textAlign\":\"center\"}},\"padding\":{\"left\":{\"unit\":\"px\"},\"right\":{\"unit\":\"px\"},\"top\":{\"unit\":\"px\"},\"bottom\":{\"unit\":\"px\"}}},\"v\":\"1.1\",\"nodes\":[\"10-h8\",\"7-h8\",\"1833-h8\",\"1837-h8\",\"22-h8\"]},{\"id\":42,\"type\":\"hop-horizontal-menu\",\"style\":{\"descendants\":{\"item\":{\"margin\":{\"top\":{\"value\":\"0\",\"unit\":\"px\"},\"right\":{\"value\":\"20\",\"unit\":\"px\"},\"bottom\":{\"value\":\"0\",\"unit\":\"px\"},\"left\":{\"value\":\"20\",\"unit\":\"px\"}},\"padding\":{\"top\":{\"value\":\"10\",\"unit\":\"px\"},\"right\":{\"value\":0,\"unit\":\"px\"},\"bottom\":{\"value\":\"10\",\"unit\":\"px\"},\"left\":{\"value\":0,\"unit\":\"px\"}}},\"link\":{\"typography\":{\"weight\":\"500\",\"size\":{\"unit\":\"px\",\"value\":\"12\"},\"transform\":\"uppercase\",\"family\":\"Montserrat\",\"lineHeight\":{\"unit\":\"em\",\"value\":\"1.5\"},\"letterSpacing\":{\"unit\":\"px\",\"value\":\"1\"},\"color\":\"${theme.colors.4}\"},\"states\":{\"hover\":{\"typography\":{\"color\":\"${theme.colors.4}\"}},\"menuButtonActive\":{\"typography\":{\"color\":\"${theme.colors.4}\"}}}},\"submenu\":{\"boxShadow\":{\"enabled\":true,\"layers\":[{\"blur\":\"5\",\"color\":\"rgba(0, 0, 0, 0.04)\"}]}},\"submenu-item\":{\"background\":{\"color\":\"rgb(255, 255, 255)\"},\"states\":{\"hover\":{\"background\":{\"color\":\"${theme.colors.0}\"}},\"menuButtonActive\":{\"background\":{\"color\":\"${theme.colors.0}\"}}}},\"submenu-item-link\":{\"states\":{\"hover\":{\"typography\":{\"color\":\"rgb(255, 255, 255)\"}},\"menuButtonActive\":{\"typography\":{\"color\":\"rgb(255, 255, 255)\"}}},\"typography\":{\"color\":\"${theme.colors.5|variant2}\"}},\"subMenuIcon\":{\"typography\":{\"color\":\"${theme.colors.5|variant2}\"},\"states\":{\"hover\":{\"typography\":{\"color\":\"${theme.colors.4}\"}},\"menuButtonActive\":{\"typography\":{\"color\":\"${theme.colors.4}\"}}}},\"hover-effect-border\":{\"background\":{\"color\":\"${theme.colors.4}\"},\"height\":{\"path\":\"value\",\"value\":\"2\"}},\"mainMenuIcon\":{\"typography\":{\"color\":\"${theme.colors.4}\"}}},\"ancestor\":{\"sticky\":{\"descendants\":{\"link\":{\"typography\":{\"color\":\"${theme.colors.5}\"},\"states\":{\"menuButtonActive\":{\"typography\":{\"color\":\"${theme.colors.5}\"}},\"hover\":{\"typography\":{\"color\":\"${theme.colors.5}\"}}}},\"mainMenuIcon\":{\"typography\":{\"color\":\"${theme.colors.5}\"}},\"hover-effect-border\":{\"background\":{\"color\":\"${theme.colors.5}\"}}}}}},\"props\":{\"hoverEffect\":{\"type\":\"bordered-active-item bordered-active-item--bottom\",\"activeGroup\":\"border\",\"group\":{\"border\":{\"transition\":\"effect-borders-grow grow-from-center\"}},\"enabled\":true},\"sticky\":true,\"showOffscreenMenuOn\":\"has-offcanvas-tablet\"},\"v\":\"1.1\",\"nodes\":[\"10-h9\",\"7-h9\",\"1833-h9\",\"1837-h9\",\"22-h9\"]},{\"id\":43,\"type\":\"hop-mobile-menu\",\"nodeId\":\"7-h27\",\"nodes\":[\"10-h10\",\"7-h10\",\"1833-h10\",\"1837-h10\",\"22-h10\"],\"v\":\"1.1\",\"style\":{\"descendants\":{\"offscreen\":{\"background\":{\"color\":\"#222B34\"}}},\"ancestor\":{\"sticky\":{\"descendants\":{\"hamburgerButton\":{\"fill\":\"${theme.colors.5}\",\"background\":{\"color\":\"rgba(255, 255, 255, 0.1)\"}}}}}}},{\"id\":44,\"type\":\"hop-offscreen-panel\",\"nodeId\":\"7-h28\",\"nodes\":[\"10-h11\",\"7-h11\",\"1833-h11\",\"1837-h11\",\"22-h11\"],\"v\":\"1.1\"},{\"id\":45,\"props\":{\"layout\":{\"equalWidth\":false,\"horizontalGap\":0,\"verticalGap\":0,\"horizontalInnerGap\":0,\"verticalInnerGap\":0}},\"type\":\"hop-row\",\"nodeId\":\"7-h30\",\"nodes\":[\"10-h13\",\"7-h13\",\"1833-h13\",\"1837-h13\",\"22-h13\"],\"v\":\"1.1\"},{\"id\":46,\"props\":{\"layout\":{\"horizontalInnerGap\":2,\"verticalInnerGap\":2}},\"type\":\"hop-column\",\"nodeId\":\"7-h31\",\"nodes\":[\"10-h14\",\"7-h14\",\"1833-h14\",\"1837-h14\",\"22-h14\"],\"v\":\"1.1\"},{\"id\":47,\"type\":\"hop-logo\",\"nodeId\":\"7-h32\",\"nodes\":[\"10-h15\",\"7-h15\",\"1833-h15\",\"1837-h15\",\"22-h15\"],\"v\":\"1.1\",\"style\":{\"descendants\":{\"text\":{\"typography\":{\"family\":\"Montserrat\",\"weight\":\"600\",\"size\":{\"unit\":\"px\",\"value\":\"15\"},\"transform\":\"uppercase\"}}}},\"props\":{\"layoutType\":\"text\",\"horizontalTextAlign\":\"center\"}},{\"id\":48,\"props\":{\"layout\":{\"equalWidth\":false,\"horizontalGap\":0,\"verticalGap\":0,\"horizontalInnerGap\":0,\"verticalInnerGap\":0}},\"type\":\"hop-row\",\"nodeId\":\"7-h33\",\"nodes\":[\"10-h16\",\"7-h16\",\"1833-h16\",\"1837-h16\",\"22-h16\"],\"v\":\"1.1\"},{\"id\":49,\"props\":{\"layout\":{\"horizontalInnerGap\":2,\"verticalInnerGap\":2}},\"type\":\"hop-column\",\"nodeId\":\"7-h34\",\"nodes\":[\"10-h17\",\"7-h17\",\"1833-h17\",\"1837-h17\",\"22-h17\"],\"v\":\"1.1\"},{\"id\":50,\"style\":{\"descendants\":{\"link\":{\"typography\":{\"color\":\"white\",\"family\":\"Montserrat\",\"weight\":\"500\",\"size\":{\"unit\":\"px\",\"value\":\"12\"},\"transform\":\"uppercase\",\"letterSpacing\":{\"unit\":\"px\",\"value\":\"1\"}}},\"submenu-item-link\":{\"typography\":{\"color\":\"white\"}},\"iconOption\":{\"typography\":{\"color\":\"white\"}},\"subMenuIcon\":{\"typography\":{\"color\":\"white\"}},\"item\":{\"border\":{\"bottom\":{\"color\":\"rgba(255, 255, 255, 0.2)\"}},\"states\":{\"hover\":{\"background\":{\"color\":\"${theme.colors.0}\"}},\"menuButtonActive\":{\"background\":{\"color\":\"${theme.colors.0}\"}}}},\"mainMenuIcon\":{\"typography\":{\"color\":\"${theme.colors.4}\"},\"states\":{\"hover\":{\"typography\":{\"color\":\"${theme.colors.4}\"}}}},\"submenu\":{\"background\":{\"color\":\"rgba(0,0,0,0)\"}},\"submenu-item\":{\"border\":{\"bottom\":{\"color\":\"rgba(255, 255, 255, 0.2)\"}},\"states\":{\"hover\":{\"background\":{\"color\":\"rgba(3, 169, 244, 0.8)\"}},\"menuButtonActive\":{\"background\":{\"color\":\"rgba(3, 169, 244, 0.8)\"}}}}},\"background\":{\"color\":\"rgba(0,0,0,0)\"}},\"props\":{\"layout\":\"accordion\"},\"type\":\"hop-accordion-menu\",\"nodeId\":\"7-h29\",\"nodes\":[\"10-h12\",\"7-h12\",\"1833-h12\",\"1837-h12\",\"22-h12\"],\"v\":\"1.1\"},{\"id\":51,\"type\":\"hop-top-bar\",\"props\":{\"width\":\"boxed\"},\"v\":\"1.1\",\"nodes\":[\"10-h18\",\"7-h18\",\"1833-h18\",\"1837-h18\",\"22-h18\"]},{\"id\":52,\"style\":{\"background\":{\"color\":\"${theme.colors.5}\"},\"padding\":{\"top\":{\"value\":\"5\",\"unit\":\"px\"},\"right\":{\"unit\":\"px\"},\"bottom\":{\"value\":\"5\",\"unit\":\"px\"},\"left\":{\"unit\":\"px\"}}},\"props\":{\"layout\":{\"equalWidth\":false,\"horizontalGap\":0,\"verticalGap\":0,\"horizontalInnerGap\":0,\"verticalInnerGap\":0},\"fullBackground\":true,\"hide\":{\"mobile\":true}},\"type\":\"hop-row\",\"v\":\"1.1\",\"nodes\":[\"10-h19\",\"7-h19\",\"1833-h19\",\"1837-h19\",\"22-h19\"]},{\"id\":53,\"props\":{\"verticalAlign\":\"center\",\"layout\":{\"horizontalInnerGap\":0,\"verticalInnerGap\":0}},\"type\":\"hop-column\",\"style\":{\"descendants\":{\"outer\":{\"padding\":{\"left\":{\"unit\":\"px\"},\"right\":{\"unit\":\"px\"},\"top\":{\"unit\":\"px\"},\"bottom\":{\"unit\":\"px\"}}}},\"padding\":{\"left\":{\"unit\":\"px\",\"value\":\"\"},\"right\":{\"unit\":\"px\",\"value\":\"\"},\"top\":{\"unit\":\"px\",\"value\":\"\"},\"bottom\":{\"unit\":\"px\",\"value\":\"\"}},\"textAlign\":\"left\"},\"v\":\"1.1\",\"nodes\":[\"10-h20\",\"7-h20\",\"1833-h20\",\"1837-h20\",\"22-h20\"]},{\"id\":54,\"type\":\"hop-icon-list\",\"style\":{\"descendants\":{\"li\":{\"padding\":{\"right\":{\"value\":0,\"unit\":\"px\"},\"bottom\":{\"value\":0,\"unit\":\"px\"}}},\"divider\":{\"border\":{\"left\":{\"width\":{\"value\":1,\"unit\":\"px\"}},\"bottom\":{\"width\":{\"value\":0,\"unit\":\"px\"}}},\"height\":{\"value\":100,\"unit\":\"%\"}},\"containerDivider\":{\"height\":{\"value\":100,\"unit\":\"%\"},\"width\":{\"value\":1,\"unit\":\"px\"},\"padding\":{\"left\":{\"value\":10,\"unit\":\"px\"},\"top\":{\"value\":0,\"unit\":\"px\"},\"right\":{\"value\":10,\"unit\":\"px\"},\"bottom\":{\"value\":0,\"unit\":\"px\"}}},\"icon\":{\"width\":{\"path\":\"value\",\"value\":\"18\"},\"states\":{\"hover\":{\"background\":{\"color\":\"rgba(3, 169, 244, 0)\"}}},\"height\":{\"path\":\"value\",\"value\":\"18\"},\"border\":{\"top\":{\"style\":\"none\",\"radius\":{\"left\":{\"unit\":\"px\"},\"right\":{\"unit\":\"px\"}},\"width\":{\"value\":\"2\",\"unit\":\"px\"},\"color\":\"${theme.colors.0}\"},\"right\":{\"style\":\"none\",\"width\":{\"value\":\"2\",\"unit\":\"px\"},\"color\":\"${theme.colors.0}\"},\"bottom\":{\"style\":\"none\",\"radius\":{\"left\":{\"unit\":\"px\"},\"right\":{\"unit\":\"px\"}},\"width\":{\"value\":\"2\",\"unit\":\"px\"},\"color\":\"${theme.colors.0}\"},\"left\":{\"style\":\"none\",\"width\":{\"value\":\"2\",\"unit\":\"px\"},\"color\":\"${theme.colors.0}\"}},\"padding\":{\"top\":{\"unit\":\"px\"},\"right\":{\"unit\":\"px\"},\"bottom\":{\"unit\":\"px\"},\"left\":{\"value\":0,\"unit\":\"px\",\"path\":\"value\"}},\"fill\":\"${theme.colors.4}\"},\"text\":{\"margin\":{\"left\":{\"path\":\"value\",\"value\":\"5\"}},\"color\":\"${theme.colors.4}\",\"typography\":{\"size\":{\"unit\":\"px\",\"value\":\"14\"}}},\"list-item\":{\"padding\":{\"right\":{\"value\":0,\"unit\":\"px\"},\"bottom\":{\"value\":0,\"unit\":\"px\"}},\"horizontalAlign\":\"start\"}}},\"props\":{\"iconList\":[{\"title\":\"List\",\"link\":{\"newWindow\":false,\"noFollow\":false},\"text\":\"List item #1\",\"allIcons\":false,\"icon\":\"font-awesome\\/check\",\"type\":\"svg\",\"id\":0.15907223444395},{\"title\":\"List\",\"link\":{\"newWindow\":false,\"noFollow\":false},\"text\":\"List item #2\",\"allIcons\":false,\"icon\":\"font-awesome\\/check\",\"type\":\"svg\",\"id\":0.34341111083052},{\"title\":\"List\",\"link\":{\"newWindow\":false,\"noFollow\":false},\"text\":\"List item #3\",\"allIcons\":false,\"icon\":\"font-awesome\\/check\",\"type\":\"svg\",\"id\":0.094166060197272},{\"title\":\"List\",\"link\":{\"newWindow\":false,\"noFollow\":false},\"text\":\"List item #4\",\"allIcons\":false,\"icon\":\"font-awesome\\/check\",\"type\":\"svg\",\"id\":0.5295691579822}],\"iconAndTextAlign\":\"center\",\"listLayout\":\"horizontal\"},\"v\":\"1.1\",\"nodes\":[\"10-h21\",\"7-h21\",\"1833-h21\",\"1837-h21\",\"22-h21\"]},{\"id\":55,\"props\":{\"verticalAlign\":\"center\",\"layout\":{\"horizontalInnerGap\":2,\"verticalInnerGap\":0}},\"type\":\"hop-column\",\"style\":{\"descendants\":{\"outer\":{\"padding\":{\"left\":{\"unit\":\"px\"},\"right\":{\"unit\":\"px\"},\"top\":{\"unit\":\"px\"},\"bottom\":{\"unit\":\"px\"}}}},\"padding\":{\"left\":{\"unit\":\"px\",\"value\":\"\"},\"right\":{\"unit\":\"px\",\"value\":\"\"},\"top\":{\"unit\":\"px\",\"value\":\"\"},\"bottom\":{\"unit\":\"px\",\"value\":\"\"}}},\"v\":\"1.1\",\"nodes\":[\"10-h22\",\"7-h22\",\"1833-h22\",\"1837-h22\",\"22-h22\"]},{\"id\":56,\"type\":\"hop-social-icons\",\"style\":{\"descendants\":{\"icon-content\":{\"fill\":\"rgba(255, 255, 255, 0.7)\",\"states\":{\"hover\":{\"fill\":\"${theme.colors.4}\"}},\"width\":{\"value\":\"16\"},\"height\":{\"value\":\"16\"}},\"icon\":{\"margin\":{\"right\":{\"value\":\"0\"}},\"padding\":{\"top\":{\"value\":\"5\",\"unit\":\"px\"},\"left\":{\"value\":\"10\",\"unit\":\"px\"},\"bottom\":{\"value\":\"5\",\"unit\":\"px\"},\"right\":{\"value\":\"10\",\"unit\":\"px\"}}}}},\"props\":{\"horizontalAlign\":\"end\",\"media\":{\"mobile\":{\"horizontalAlign\":\"center\"}},\"hide\":{\"mobile\":false}},\"v\":\"1.1\",\"nodes\":[\"10-h23\",\"7-h23\",\"1833-h23\",\"1837-h23\",\"22-h23\"]},{\"id\":57,\"style\":{\"typography\":{\"holders\":{\"h1\":{\"color\":\"${theme.colors.4}\"},\"h2\":{\"color\":\"${theme.colors.4}\"},\"h3\":{\"color\":\"${theme.colors.4}\"},\"h4\":{\"color\":\"${theme.colors.4}\"},\"h5\":{\"color\":\"${theme.colors.4}\"},\"h6\":{\"color\":\"${theme.colors.4}\"},\"p\":{\"color\":\"${theme.colors.4}\"}}},\"background\":{\"type\":\"gradient\",\"image\":[{\"source\":{\"type\":\"gradient\",\"gradient\":{\"angle\":\"120\",\"steps\":[{\"color\":\"rgba(252, 203, 144, 0.8)\",\"position\":\"0\"},{\"color\":\"rgba(213, 126, 235, 0.8)\",\"position\":\"100\"}]},\"url\":\"http:\\/\\/localhost\\/wordpress\\/wp-content\\/uploads\\/2023\\/06\\/cropped-devoksy.png\"},\"attachment\":\"scroll\",\"position\":\"center center\",\"repeat\":\"no-repeat\",\"size\":\"cover\",\"useParallax\":false}],\"overlay\":{\"enabled\":false,\"color\":{\"value\":\"rgb(30, 31, 34)\",\"opacity\":0.5,\"opacity_\":50},\"shape\":{\"value\":\"none\",\"isTile\":false,\"img\":\"data:image\\/png;base64,iVBORw0KGgoAAAANSUhEUgAAAAEAAAABCAYAAAAfFcSJAAAABHNCSVQICAgIfAhkiAAAAAlwSFlzAAALEgAACxIB0t1+\\/AAAABx0RVh0U29mdHdhcmUAQWRvYmUgRmlyZXdvcmtzIENTNui8sowAAAANSURBVAiZY\\/j\\/\\/z8DAAj8Av6Fzas0AAAAAElFTkSuQmCC\"},\"light\":false,\"type\":\"color\",\"gradient\":{\"name\":\"october_silence\",\"angle\":0,\"steps\":[{\"position\":\"0\",\"color\":\"rgba(183,33,255, 0.5)\"},{\"position\":\"100\",\"color\":\"rgba(33,212,253, 0.5)\"}]}},\"color\":\"#03a9f4\",\"slideshow\":{\"duration\":{\"value\":1500},\"speed\":{\"value\":500},\"slides\":[{\"url\":\"http:\\/\\/localhost\\/wordpress\\/wp-content\\/themes\\/brite\\/resources\\/images\\/beach-landscape-sea-water-nature-sand-1061655-pxhere.com.jpg\"},{\"url\":\"http:\\/\\/localhost\\/wordpress\\/wp-content\\/themes\\/brite\\/resources\\/images\\/landscape-tree-water-nature-grass-outdoor-1327743-pxhere.com.jpg\"},{\"url\":\"http:\\/\\/localhost\\/wordpress\\/wp-content\\/themes\\/brite\\/resources\\/images\\/leaf-nature-water-green-freshness-dew-1440543-pxhere.com.jpg\"}]},\"video\":{\"videoType\":\"external\",\"externalUrl\":\"https:\\/\\/www.youtube.com\\/watch?v=y5zFszln1ao\",\"internalUrl\":false,\"poster\":{\"url\":\"https:\\/\\/static.colibriwp.com\\/assets\\/sources\\/colibri-demo-video-cover.jpg\"}}},\"padding\":{\"top\":{\"unit\":\"px\",\"value\":31},\"bottom\":{\"unit\":\"px\",\"value\":40}},\"separatorBottom\":{\"enabled\":false,\"height\":{\"value\":100},\"color\":\"#FFF\",\"type\":\"mountains\",\"negative\":false},\"media\":{\"mobile\":{\"customHeight\":{\"type\":\"fit-to-content\"}}}},\"props\":{\"heroSection\":{\"layout\":\"textWithMediaOnRight\",\"mediaType\":\"hop-image\"},\"attrs\":{\"name\":\"hero\",\"id\":\"hero\"},\"width\":\"boxed\",\"layoutType\":\"textWithMediaOnRight\"},\"type\":\"hop-hero\",\"nodeId\":\"7-h32\",\"v\":\"1.1\",\"nodes\":[\"10-h24\",\"1837-h24\",\"22-h24\"]},{\"id\":58,\"props\":{\"layout\":{\"equalWidth\":false},\"media\":{\"mobile\":{\"layout\":{\"horizontalGap\":2,\"verticalGap\":2}}}},\"type\":\"hop-row\",\"nodeId\":\"7-h28\",\"v\":\"1.1\",\"nodes\":[\"10-h25\",\"1837-h25\",\"22-h28\"]},{\"id\":59,\"type\":\"hop-column\",\"nodeId\":\"7-h29\",\"v\":\"1.1\",\"nodes\":[\"10-h26\",\"1837-h26\",\"22-h29\"],\"style\":{\"descendants\":{\"outer\":{\"media\":{\"mobile\":{\"padding\":{\"left\":{\"unit\":\"px\",\"value\":\"\"},\"right\":{\"unit\":\"px\",\"value\":\"\"},\"top\":{\"unit\":\"px\",\"value\":\"\"},\"bottom\":{\"unit\":\"px\",\"value\":\"\"}}}},\"columnWidth\":{\"type\":\"custom\",\"custom\":{\"value\":50,\"unit\":\"%\"}}}}}},{\"id\":60,\"type\":\"hop-page-title\",\"nodeId\":\"7-h30\",\"v\":\"1.1\",\"nodes\":[\"10-h27\",\"1837-h27\",\"22-h27\"]},{\"id\":61,\"type\":\"hop-footer\",\"props\":{\"useFooterParallax\":true},\"v\":\"1.1\",\"nodes\":[\"13-f1\",\"1840-f1\",\"25-f1\"]},{\"id\":62,\"type\":\"hop-section\",\"style\":{\"padding\":{\"top\":{\"path\":\"value\",\"value\":\"15\"},\"bottom\":{\"path\":\"value\",\"value\":94}},\"background\":{\"color\":\"${theme.colors.5}\"},\"border\":{\"top\":{\"style\":\"solid\",\"width\":{\"value\":\"5\",\"unit\":\"px\"},\"color\":\"rgba(255, 255, 255, 0.5)\"},\"right\":{\"style\":\"solid\",\"width\":{\"value\":\"0\",\"unit\":\"px\"},\"color\":\"rgba(255, 255, 255, 0.5)\"},\"bottom\":{\"style\":\"solid\",\"width\":{\"value\":\"0\",\"unit\":\"px\"},\"color\":\"rgba(255, 255, 255, 0.5)\"},\"left\":{\"style\":\"solid\",\"width\":{\"value\":\"0\",\"unit\":\"px\"},\"color\":\"rgba(255, 255, 255, 0.5)\"}},\"customHeight\":{\"min-height\":{\"unit\":\"px\",\"value\":92.04166412353516},\"type\":\"min-height\"}},\"v\":\"1.1\",\"nodes\":[\"13-f2\",\"1840-f2\",\"25-f2\"],\"props\":{\"width\":\"boxed\",\"showHeader\":true}},{\"id\":63,\"props\":{\"layout\":{\"equalWidth\":false,\"horizontalInnerGap\":1,\"verticalGap\":1,\"horizontalGap\":1},\"media\":{\"mobile\":{\"layout\":{\"verticalGap\":2,\"horizontalGap\":2}}}},\"type\":\"hop-row\",\"v\":\"1.1\",\"nodes\":[\"13-f3\",\"1840-f3\",\"25-f3\"]},{\"id\":64,\"type\":\"hop-column\",\"props\":{\"layout\":{\"vSpace\":{\"value\":\"0\"},\"horizontalInnerGap\":1,\"verticalInnerGap\":1},\"media\":{\"mobile\":{\"layout\":{\"horizontalInnerGap\":2,\"verticalInnerGap\":2}}}},\"style\":{\"padding\":{\"left\":{\"unit\":\"px\"},\"right\":{\"unit\":\"px\"},\"top\":{\"unit\":\"px\"},\"bottom\":{\"unit\":\"px\"}},\"media\":{\"mobile\":{\"padding\":{\"left\":{\"unit\":\"px\"},\"right\":{\"unit\":\"px\"},\"top\":{\"unit\":\"px\"},\"bottom\":{\"unit\":\"px\"}}}},\"descendants\":{\"outer\":{\"media\":{\"mobile\":{\"padding\":{\"top\":{\"unit\":\"px\"},\"bottom\":{\"unit\":\"px\"},\"left\":{\"unit\":\"px\"},\"right\":{\"unit\":\"px\"}}}}}}},\"v\":\"1.1\",\"nodes\":[\"13-f4\",\"1840-f4\",\"25-f4\"]},{\"id\":65,\"type\":\"hop-copyright\",\"nodeId\":\"13-f6\",\"v\":\"1.1\",\"nodes\":[\"13-f5\",\"1840-f5\",\"25-f5\"],\"style\":{\"typography\":{\"color\":\"rgba(255, 255, 255, 0.7)\",\"holders\":{\"a\":{\"color\":\"${theme.colors.4}\",\"states\":{\"hover\":{\"color\":\"${theme.colors.0}\"}}}}}}},{\"id\":66,\"type\":\"hop-main\",\"nodeId\":\"71-m1\",\"v\":\"1.1\",\"nodes\":[\"432-m1\",\"456-m1\",\"1843-m1\",\"28-m1\"],\"style\":{\"border\":{\"top\":{\"radius\":{\"left\":{\"value\":\"\",\"unit\":\"px\"},\"right\":{\"value\":\"\",\"unit\":\"px\"}}},\"bottom\":{\"radius\":{\"left\":{\"value\":\"\",\"unit\":\"px\"},\"right\":{\"value\":\"\",\"unit\":\"px\"}}}},\"media\":{\"tablet\":{\"margin\":{\"top\":{\"value\":\"-95\",\"unit\":\"px\"},\"right\":{\"value\":\"\",\"unit\":\"px\"},\"bottom\":{\"value\":\"\",\"unit\":\"px\"},\"left\":{\"value\":\"\",\"unit\":\"px\"}}}},\"margin\":{\"top\":{\"value\":\"-120\",\"unit\":\"px\"},\"right\":{\"value\":\"\",\"unit\":\"px\"},\"bottom\":{\"value\":\"\",\"unit\":\"px\"},\"left\":{\"value\":\"\",\"unit\":\"px\"}}},\"props\":{\"attrs\":{\"overflowOption\":\"hidden\"}}},{\"id\":67,\"type\":\"hop-section\",\"nodeId\":\"16-m29\",\"nodes\":[\"432-m2\",\"456-m2\",\"1843-m2\",\"28-m2\"],\"style\":{\"padding\":{\"top\":{\"value\":\"0\",\"unit\":\"px\"},\"right\":{\"value\":\"\",\"unit\":\"px\"},\"bottom\":{\"value\":\"0\",\"unit\":\"px\"},\"left\":{\"value\":\"\",\"unit\":\"px\"}}},\"v\":\"1.1\",\"props\":{\"width\":\"boxed\"}},{\"id\":68,\"props\":{\"layout\":{\"equalWidth\":false}},\"type\":\"hop-row\",\"nodeId\":\"16-m33\",\"nodes\":[\"432-m25\",\"456-m15\",\"1843-m19\",\"28-m19\"],\"v\":\"1.1\"},{\"id\":69,\"type\":\"hop-column\",\"nodeId\":\"16-m34\",\"nodes\":[\"432-m26\",\"456-m16\",\"1843-m20\",\"28-m20\"],\"v\":\"1.1\"},{\"id\":70,\"props\":{\"headerType\":\"2\"},\"type\":\"hop-heading\",\"nodeId\":\"16-m35\",\"nodes\":[\"432-m27\",\"456-m17\",\"1843-m21\",\"28-m21\"],\"v\":\"1.1\"},{\"id\":71,\"type\":\"hop-text\",\"nodeId\":\"16-m36\",\"nodes\":[\"432-m28\",\"456-m18\",\"1843-m22\",\"28-m22\"],\"v\":\"1.1\"},{\"id\":72,\"type\":\"hop-post-loop\",\"nodeId\":\"23-m35\",\"style\":{\"background\":{\"color\":\"${theme.colors.2}\",\"type\":\"gradient\",\"image\":[{\"source\":{\"type\":\"gradient\",\"gradient\":{\"angle\":\"145\",\"steps\":[{\"color\":\"${theme.colors.4}\",\"position\":\"42\"},{\"color\":\"rgb(243, 243, 243)\"}]}}}]},\"boxShadow\":{\"enabled\":true,\"layers\":[{\"y\":\"20\",\"spread\":\"2\",\"blur\":\"40\",\"color\":\"rgba(0, 0, 0, 0.15)\",\"x\":\"0\"}]},\"media\":{\"mobile\":{\"boxShadow\":{\"layers\":[{\"blur\":\"15\",\"y\":\"10\"}]},\"margin\":{\"top\":{\"value\":\"\",\"unit\":\"px\"},\"right\":{\"value\":\"15\",\"unit\":\"px\"},\"bottom\":{\"value\":\"20\",\"unit\":\"px\"},\"left\":{\"value\":\"15\",\"unit\":\"px\"}}},\"tablet\":{\"boxShadow\":{\"layers\":[{\"blur\":\"20\",\"y\":\"10\"}]},\"margin\":{\"top\":{\"value\":\"\",\"unit\":\"px\"},\"right\":{\"value\":\"20\",\"unit\":\"px\"},\"bottom\":{\"value\":\"20\",\"unit\":\"px\"},\"left\":{\"value\":\"20\",\"unit\":\"px\"}}}},\"margin\":{\"top\":{\"value\":\"\",\"unit\":\"px\"},\"right\":{\"value\":\"40\",\"unit\":\"px\"},\"bottom\":{\"value\":\"40\",\"unit\":\"px\"},\"left\":{\"value\":\"40\",\"unit\":\"px\"}},\"border\":{\"top\":{\"radius\":{\"left\":{\"value\":\"27\",\"unit\":\"px\"},\"right\":{\"value\":\"27\",\"unit\":\"px\"}},\"style\":\"none\",\"width\":{\"value\":\"0\",\"unit\":\"px\"}},\"bottom\":{\"radius\":{\"left\":{\"value\":\"25\",\"unit\":\"px\"},\"right\":{\"value\":\"25\",\"unit\":\"px\"}},\"style\":\"none\",\"width\":{\"value\":\"5\",\"unit\":\"px\"}},\"right\":{\"style\":\"none\",\"width\":{\"value\":\"0\",\"unit\":\"px\"}},\"left\":{\"style\":\"none\",\"width\":{\"value\":\"0\",\"unit\":\"px\"}}}},\"v\":\"1.1\",\"nodes\":[\"432-m3\",\"456-m3\",\"1843-m3\",\"28-m3\"],\"props\":{\"attrs\":{\"overflowOption\":\"visible\"}}},{\"id\":73,\"type\":\"hop-loop-item\",\"nodeId\":\"23-m36\",\"v\":\"1.1\",\"nodes\":[\"432-m4\",\"456-m4\",\"1843-m4\",\"28-m4\"],\"style\":{\"background\":{\"color\":\"\"},\"padding\":{\"left\":{\"unit\":\"px\",\"value\":\"\"},\"right\":{\"unit\":\"px\",\"value\":\"\"},\"top\":{\"unit\":\"px\",\"value\":\"\"},\"bottom\":{\"unit\":\"px\",\"value\":\"\"}},\"media\":{\"mobile\":{\"padding\":{\"left\":{\"unit\":\"px\",\"value\":\"\"},\"right\":{\"unit\":\"px\",\"value\":\"\"},\"top\":{\"unit\":\"px\",\"value\":\"\"},\"bottom\":{\"unit\":\"px\",\"value\":\"\"}}}}},\"props\":{\"layout\":{\"vSpace\":{\"value\":\"0\"},\"horizontalInnerGap\":0,\"verticalInnerGap\":0},\"media\":{\"mobile\":{\"layout\":{\"horizontalInnerGap\":0,\"verticalInnerGap\":0}}}}},{\"id\":74,\"type\":\"hop-post-thumbnail\",\"nodeId\":\"23-m37\",\"style\":{\"background\":{\"color\":\"rgba(255,255,255,0)\"},\"border\":{\"top\":{\"radius\":{\"left\":{\"value\":\"25\",\"unit\":\"px\"},\"right\":{\"value\":\"25\",\"unit\":\"px\"}}},\"bottom\":{\"radius\":{\"left\":{\"value\":\"\",\"unit\":\"px\"},\"right\":{\"value\":\"\",\"unit\":\"px\"}}}},\"descendants\":{\"image\":{\"object\":{\"fit\":\"cover\"}}}},\"v\":\"1.1\",\"nodes\":[\"432-m5\",\"456-m5\",\"1843-m5\",\"28-m5\"]},{\"id\":75,\"props\":{\"layout\":{\"equalWidth\":false,\"horizontalGap\":0,\"verticalGap\":0,\"itemsPerRow\":1,\"horizontalInnerGap\":0,\"verticalInnerGap\":0,\"custom\":{\"horizontalGap\":{\"unit\":\"px\",\"value\":\"\"},\"verticalGap\":{\"unit\":\"px\",\"value\":\"\"},\"horizontalInnerGap\":{\"unit\":\"px\",\"value\":\"\"},\"verticalInnerGap\":{\"unit\":\"px\",\"value\":\"\"}}}},\"type\":\"hop-row\",\"nodeId\":\"1723-m26\",\"v\":\"1.1\",\"nodes\":[\"432-m6\",\"456-m6\",\"1843-m6\",\"28-m6\"]},{\"id\":76,\"type\":\"hop-column\",\"nodeId\":\"1723-m27\",\"props\":{\"layout\":{\"horizontalInnerGap\":3,\"verticalInnerGap\":3,\"vSpace\":{\"value\":\"0\"}}},\"v\":\"1.1\",\"nodes\":[\"432-m7\",\"456-m7\",\"1843-m7\",\"28-m7\"],\"style\":{\"textAlign\":\"left\",\"padding\":{\"left\":{\"unit\":\"px\",\"value\":\"\"},\"right\":{\"unit\":\"px\",\"value\":\"\"},\"top\":{\"unit\":\"px\",\"value\":\"\"},\"bottom\":{\"unit\":\"px\",\"value\":\"\"}},\"descendants\":{\"outer\":{\"padding\":{\"left\":{\"unit\":\"px\",\"value\":\"\"},\"right\":{\"unit\":\"px\",\"value\":\"\"},\"top\":{\"unit\":\"px\",\"value\":\"\"},\"bottom\":{\"unit\":\"px\",\"value\":\"\"}}}}}},{\"id\":77,\"props\":{\"layout\":{\"equalWidth\":false,\"custom\":{\"horizontalGap\":{\"unit\":\"px\",\"value\":\"\"},\"verticalGap\":{\"unit\":\"px\",\"value\":\"\"},\"horizontalInnerGap\":{\"unit\":\"px\",\"value\":\"\"},\"verticalInnerGap\":{\"unit\":\"px\",\"value\":\"\"}},\"horizontalGap\":0,\"verticalGap\":0,\"horizontalInnerGap\":0,\"verticalInnerGap\":0}},\"type\":\"hop-post-categories-container\",\"nodeId\":\"16-m34\",\"nodes\":[\"432-m10\",\"456-m9\",\"1843-m8\",\"28-m8\"],\"v\":\"1.1\",\"style\":{\"margin\":{\"top\":{\"value\":\"\",\"unit\":\"px\"},\"right\":{\"value\":\"\",\"unit\":\"px\"},\"bottom\":{\"value\":\"15\",\"unit\":\"px\"},\"left\":{\"value\":\"\",\"unit\":\"px\"}},\"border\":{\"top\":{\"style\":\"solid\",\"width\":{\"value\":\"0\",\"unit\":\"px\"},\"color\":\"rgb(238, 238, 238)\"},\"right\":{\"style\":\"solid\",\"width\":{\"value\":\"0\",\"unit\":\"px\"},\"color\":\"rgb(238, 238, 238)\"},\"bottom\":{\"style\":\"solid\",\"width\":{\"value\":\"1\",\"unit\":\"px\"},\"color\":\"rgb(238, 238, 238)\"},\"left\":{\"style\":\"solid\",\"width\":{\"value\":\"0\",\"unit\":\"px\"},\"color\":\"rgb(238, 238, 238)\"}},\"padding\":{\"top\":{\"value\":\"\",\"unit\":\"px\"},\"right\":{\"value\":\"\",\"unit\":\"px\"},\"bottom\":{\"value\":\"15\",\"unit\":\"px\"},\"left\":{\"value\":\"\",\"unit\":\"px\"}}}},{\"id\":78,\"type\":\"hop-column\",\"nodeId\":\"16-m36\",\"nodes\":[\"432-m13\",\"456-m12\",\"1843-m9\",\"28-m9\"],\"v\":\"1.1\",\"style\":{\"textAlign\":\"left\"},\"props\":{\"verticalAlign\":\"start\"}},{\"id\":79,\"type\":\"hop-post-categories\",\"nodeId\":\"16-m37\",\"nodes\":[\"432-m14\",\"456-m13\",\"1843-m10\",\"28-m10\"],\"v\":\"1.1\",\"style\":{\"descendants\":{\"categoriesLinks\":{\"margin\":{\"top\":{\"value\":\"\",\"unit\":\"px\"},\"right\":{\"value\":\"10\",\"unit\":\"px\"},\"bottom\":{\"value\":\"\",\"unit\":\"px\"},\"left\":{\"value\":\"\",\"unit\":\"px\"}},\"states\":{\"hover\":{\"typography\":{\"color\":\"${theme.colors.5}\"}}},\"typography\":{\"family\":\"Open Sans\",\"size\":{\"unit\":\"px\",\"value\":\"14\"},\"color\":\"${theme.colors.5|variant2}\",\"weight\":\"400\",\"transform\":\"lowercase\",\"decoration\":\"underline\"},\"border\":{\"top\":{\"style\":\"solid\"},\"right\":{\"style\":\"solid\"},\"bottom\":{\"style\":\"solid\"},\"left\":{\"style\":\"solid\"}}},\"categoriesPrefix\":{\"typography\":{\"size\":{\"unit\":\"px\",\"value\":\"14\"},\"color\":\"${theme.colors.5|variant3}\"}}}}},{\"id\":80,\"type\":\"hop-column\",\"nodeId\":\"16-m38\",\"nodes\":[\"432-m11\",\"456-m10\",\"1843-m11\",\"28-m11\"],\"v\":\"1.1\",\"props\":{\"verticalAlign\":\"start\"},\"style\":{\"textAlign\":\"right\",\"media\":{\"mobile\":{\"textAlign\":\"left\",\"padding\":{\"top\":{\"value\":\"5\",\"unit\":\"px\"},\"right\":{\"value\":\"\",\"unit\":\"px\"},\"bottom\":{\"value\":\"\",\"unit\":\"px\"},\"left\":{\"value\":\"\",\"unit\":\"px\"}}},\"tablet\":{\"textAlign\":\"left\",\"padding\":{\"top\":{\"value\":\"5\",\"unit\":\"px\"},\"right\":{\"value\":\"\",\"unit\":\"px\"},\"bottom\":{\"value\":\"\",\"unit\":\"px\"},\"left\":{\"value\":\"\",\"unit\":\"px\"}}}}}},{\"id\":81,\"type\":\"hop-post-meta\",\"nodeId\":\"5-c229\",\"nodes\":[\"459-m12\",\"465-m8\",\"456-m8\",\"5-c177\",\"1843-m12\",\"1852-m8\",\"1861-c179\",\"1846-m12\",\"28-m12\"],\"v\":\"1.1\",\"style\":{\"descendants\":{\"metaDataLinks\":{\"typography\":{\"color\":\"${theme.colors.5|variant2}\",\"weight\":\"400\",\"family\":\"Open Sans\",\"size\":{\"unit\":\"px\",\"value\":\"14\"}},\"states\":{\"hover\":{\"typography\":{\"color\":\"${theme.colors.5}\"}}}},\"icons\":{\"margin\":{\"right\":{\"value\":\"5\"}},\"display\":\"none\"},\"separators\":{\"typography\":{\"color\":\"${theme.colors.5|variant3}\",\"size\":{\"unit\":\"px\",\"value\":\"14\"},\"lineHeight\":{\"unit\":\"\",\"value\":\"1.6\"}},\"padding\":{\"top\":{\"value\":\"\",\"unit\":\"px\"},\"right\":{\"value\":\"5\",\"unit\":\"px\"},\"bottom\":{\"value\":\"\",\"unit\":\"px\"},\"left\":{\"value\":\"\",\"unit\":\"px\"}}},\"metaDataPrefix\":{\"typography\":{\"size\":{\"unit\":\"px\",\"value\":\"14\"},\"color\":\"${theme.colors.5|variant2}\"}}}}},{\"id\":82,\"type\":\"hop-post-content\",\"nodeId\":\"23-m40\",\"v\":\"1.1\",\"nodes\":[\"432-m9\",\"456-m14\",\"1843-m13\",\"28-m13\"],\"style\":{\"descendants\":{\"content\":{\"typography\":{\"color\":\"${theme.colors.6|variant3}\",\"weight\":\"300\",\"family\":\"Source Sans Pro\",\"size\":{\"unit\":\"px\",\"value\":\"18\"},\"holders\":{\"a\":{\"color\":\"${theme.colors.0|variant3}\",\"states\":{\"hover\":{\"color\":\"${theme.colors.0}\"}}}}}}}}},{\"id\":83,\"props\":{\"layout\":{\"equalWidth\":false,\"horizontalGap\":0,\"verticalGap\":0,\"horizontalInnerGap\":2,\"verticalInnerGap\":2,\"horizontalAlign\":\"start\"}},\"type\":\"hop-post-tags-container\",\"nodeId\":\"456-m37\",\"nodes\":[\"456-m37\",\"1843-m14\",\"28-m14\"],\"v\":\"1.1\",\"style\":{\"border\":{\"top\":{\"style\":\"solid\",\"width\":{\"value\":\"1\",\"unit\":\"px\"},\"color\":\"rgb(238, 238, 238)\"},\"right\":{\"style\":\"solid\",\"width\":{\"value\":\"0\",\"unit\":\"px\"},\"color\":\"rgb(238, 238, 238)\"},\"bottom\":{\"style\":\"solid\",\"width\":{\"value\":\"0\",\"unit\":\"px\"},\"color\":\"rgb(238, 238, 238)\"},\"left\":{\"style\":\"solid\",\"width\":{\"value\":\"0\",\"unit\":\"px\"},\"color\":\"rgb(238, 238, 238)\"}},\"margin\":{\"top\":{\"value\":\"\",\"unit\":\"px\"},\"right\":{\"value\":\"30\",\"unit\":\"px\"},\"bottom\":{\"value\":\"\",\"unit\":\"px\"},\"left\":{\"value\":\"30\",\"unit\":\"px\"}},\"media\":{\"mobile\":{\"margin\":{\"top\":{\"value\":\"\",\"unit\":\"px\"},\"right\":{\"value\":\"15\",\"unit\":\"px\"},\"bottom\":{\"value\":\"\",\"unit\":\"px\"},\"left\":{\"value\":\"15\",\"unit\":\"px\"}}}}}},{\"id\":84,\"type\":\"hop-column\",\"nodeId\":\"456-m38\",\"nodes\":[\"456-m38\",\"1843-m15\",\"28-m15\"],\"v\":\"1.1\",\"style\":{\"descendants\":{\"outer\":{\"padding\":{\"left\":{\"unit\":\"px\",\"value\":\"\"},\"right\":{\"unit\":\"px\",\"value\":\"\"},\"top\":{\"unit\":\"px\",\"value\":\"\"},\"bottom\":{\"unit\":\"px\",\"value\":\"\"}}}},\"padding\":{\"left\":{\"unit\":\"px\",\"value\":\"\"},\"right\":{\"unit\":\"px\",\"value\":\"\"},\"top\":{\"unit\":\"px\",\"value\":\"\"},\"bottom\":{\"unit\":\"px\",\"value\":\"\"}},\"textAlign\":\"left\"},\"props\":{\"layout\":{\"horizontalInnerGap\":0,\"verticalInnerGap\":2}}},{\"id\":85,\"style\":{\"descendants\":{\"inner\":{\"background\":{\"color\":\"${theme.colors.4}\"},\"border\":{\"top\":{\"style\":\"solid\",\"width\":{\"path\":\"value\",\"value\":2},\"radius\":{\"right\":{\"path\":\"value\",\"value\":176},\"left\":{\"path\":\"value\",\"value\":176}},\"color\":\"${theme.colors.1}\"},\"left\":{\"style\":\"solid\",\"width\":{\"path\":\"value\",\"value\":2},\"color\":\"${theme.colors.1}\"},\"right\":{\"style\":\"solid\",\"width\":{\"path\":\"value\",\"value\":2},\"color\":\"${theme.colors.1}\"},\"bottom\":{\"style\":\"solid\",\"width\":{\"path\":\"value\",\"value\":2},\"radius\":{\"right\":{\"path\":\"value\",\"value\":176},\"left\":{\"path\":\"value\",\"value\":176}},\"color\":\"${theme.colors.1}\"}},\"padding\":{\"top\":{\"path\":\"value\",\"value\":25},\"left\":{\"path\":\"value\",\"value\":25},\"right\":{\"path\":\"value\",\"value\":25},\"bottom\":{\"path\":\"value\",\"value\":25}},\"width\":{\"path\":\"value\",\"value\":\"100\"},\"fill\":\"${theme.colors.0}\",\"states\":{\"hover\":{\"fill\":\"${theme.colors.3}\"}},\"transform\":{\"rotate\":{\"2d\":{\"path\":\"value\",\"value\":118}}}},\"icon\":{\"fill\":\"${theme.colors.0}\",\"states\":{\"hover\":{\"background\":{\"color\":\"rgba(45, 45, 134, 0)\"},\"fill\":\"${theme.colors.0|mediumLowLuminosity}\"}},\"border\":{\"top\":{\"width\":{\"value\":\"1\",\"unit\":\"px\"},\"color\":\"rgb(125, 79, 79)\"},\"right\":{\"width\":{\"value\":\"1\",\"unit\":\"px\"},\"color\":\"rgb(125, 79, 79)\"},\"bottom\":{\"width\":{\"value\":\"1\",\"unit\":\"px\"},\"color\":\"rgb(125, 79, 79)\"},\"left\":{\"width\":{\"value\":\"1\",\"unit\":\"px\"},\"color\":\"rgb(125, 79, 79)\"}},\"width\":{\"path\":\"value\",\"value\":\"24\"},\"height\":{\"path\":\"value\",\"value\":\"24\"}}}},\"scope\":\"local\",\"type\":\"hop-icon\",\"v\":\"1.1\",\"nodes\":[\"1843-m16\",\"28-m16\"]},{\"id\":86,\"type\":\"hop-column\",\"nodeId\":\"1843-m36\",\"nodes\":[\"1843-m17\",\"28-m17\"],\"v\":\"1.1\",\"style\":{\"textAlign\":\"left\",\"padding\":{\"top\":{\"value\":\"\",\"unit\":\"px\"},\"right\":{\"value\":\"\",\"unit\":\"px\"},\"bottom\":{\"value\":\"\",\"unit\":\"px\"},\"left\":{\"value\":\"5\",\"unit\":\"px\"}}}},{\"id\":87,\"type\":\"hop-post-tags\",\"nodeId\":\"456-m40\",\"nodes\":[\"456-m40\",\"1843-m18\",\"1852-m22\",\"28-m18\"],\"v\":\"1.1\",\"style\":{\"descendants\":{\"tagsLinks\":{\"typography\":{\"color\":\"${theme.colors.0}\",\"size\":{\"unit\":\"px\",\"value\":\"14\"},\"family\":\"Open Sans\",\"weight\":\"400\",\"transform\":\"lowercase\"},\"states\":{\"hover\":{\"typography\":{\"color\":\"${theme.colors.0|variant3}\"}}},\"margin\":{\"right\":{\"value\":\"10\"}},\"background\":{\"color\":\"\"}},\"tagsPrefix\":{\"typography\":{\"color\":\"${theme.colors.5|variant3}\",\"weight\":\"400\",\"family\":\"Open Sans\",\"size\":{\"unit\":\"px\",\"value\":\"14\"}}}}}},{\"id\":88,\"type\":\"hop-section\",\"nodeId\":\"16-m55\",\"nodes\":[\"432-m29\",\"456-m19\",\"1843-m23\",\"28-m23\"],\"style\":{\"padding\":{\"top\":{\"value\":0},\"bottom\":{\"value\":\"40\"}}},\"v\":\"1.1\"},{\"id\":89,\"props\":{\"layout\":{\"equalWidth\":false}},\"type\":\"hop-row\",\"nodeId\":\"16-m59\",\"nodes\":[\"432-m34\",\"456-m30\",\"1843-m34\",\"28-m34\"],\"v\":\"1.1\"},{\"id\":90,\"type\":\"hop-column\",\"nodeId\":\"16-m60\",\"nodes\":[\"432-m35\",\"456-m31\",\"1843-m35\",\"28-m35\"],\"v\":\"1.1\"},{\"id\":91,\"props\":{\"headerType\":\"2\"},\"type\":\"hop-heading\",\"nodeId\":\"16-m61\",\"nodes\":[\"432-m36\",\"456-m32\",\"1843-m36\",\"28-m36\"],\"v\":\"1.1\"},{\"id\":92,\"type\":\"hop-text\",\"nodeId\":\"16-m62\",\"nodes\":[\"432-m37\",\"456-m33\",\"1843-m37\",\"28-m37\"],\"v\":\"1.1\"},{\"id\":93,\"props\":{\"layout\":{\"equalWidth\":false,\"custom\":{\"horizontalGap\":{\"unit\":\"px\",\"value\":\"\"},\"verticalGap\":{\"unit\":\"px\",\"value\":\"\"},\"horizontalInnerGap\":{\"unit\":\"px\",\"value\":\"\"},\"verticalInnerGap\":{\"unit\":\"px\",\"value\":\"\"}},\"horizontalGap\":0,\"verticalGap\":0,\"horizontalInnerGap\":0,\"verticalInnerGap\":0},\"media\":{\"mobile\":{\"layout\":{\"horizontalInnerGap\":0,\"verticalInnerGap\":0,\"horizontalGap\":0,\"verticalGap\":0}}}},\"type\":\"hop-post-nav-container\",\"nodeId\":\"16-m39\",\"nodes\":[\"432-m20\",\"456-m20\",\"1843-m24\",\"28-m24\"],\"v\":\"1.1\",\"style\":{\"border\":{\"top\":{\"style\":\"none\",\"width\":{\"value\":\"0\",\"unit\":\"px\"}},\"right\":{\"style\":\"none\",\"width\":{\"value\":\"0\",\"unit\":\"px\"}},\"bottom\":{\"style\":\"none\",\"width\":{\"value\":\"0\",\"unit\":\"px\"}},\"left\":{\"style\":\"none\",\"width\":{\"value\":\"0\",\"unit\":\"px\"}}},\"margin\":{\"top\":{\"value\":\"\",\"unit\":\"px\"},\"right\":{\"value\":\"40\",\"unit\":\"px\"},\"bottom\":{\"value\":\"40\",\"unit\":\"px\"},\"left\":{\"value\":\"40\",\"unit\":\"px\"}},\"media\":{\"mobile\":{\"margin\":{\"top\":{\"value\":\"\",\"unit\":\"px\"},\"right\":{\"value\":\"15\",\"unit\":\"px\"},\"bottom\":{\"value\":\"15\",\"unit\":\"px\"},\"left\":{\"value\":\"15\",\"unit\":\"px\"}}},\"tablet\":{\"margin\":{\"top\":{\"value\":\"\",\"unit\":\"px\"},\"right\":{\"value\":\"20\",\"unit\":\"px\"},\"bottom\":{\"value\":\"20\",\"unit\":\"px\"},\"left\":{\"value\":\"20\",\"unit\":\"px\"}}}}}},{\"id\":94,\"type\":\"hop-column\",\"nodeId\":\"16-m40\",\"nodes\":[\"432-m21\",\"465-m13\",\"459-m17\",\"456-m21\",\"1843-m25\",\"28-m25\"],\"v\":\"1.1\",\"style\":{\"textAlign\":\"left\",\"padding\":{\"left\":{\"unit\":\"px\",\"value\":\"\"},\"right\":{\"unit\":\"px\",\"value\":\"\"},\"top\":{\"unit\":\"px\",\"value\":\"\"},\"bottom\":{\"unit\":\"px\",\"value\":\"\"}},\"descendants\":{\"outer\":{\"padding\":{\"left\":{\"unit\":\"px\",\"value\":\"\"},\"right\":{\"unit\":\"px\",\"value\":\"\"},\"top\":{\"unit\":\"px\",\"value\":\"\"},\"bottom\":{\"unit\":\"px\",\"value\":\"\"}},\"media\":{\"mobile\":{\"padding\":{\"left\":{\"unit\":\"px\",\"value\":\"\"},\"right\":{\"unit\":\"px\",\"value\":\"\"},\"top\":{\"unit\":\"px\",\"value\":\"\"},\"bottom\":{\"unit\":\"px\",\"value\":\"\"}}}}}},\"media\":{\"mobile\":{\"padding\":{\"left\":{\"unit\":\"px\",\"value\":\"\"},\"right\":{\"unit\":\"px\",\"value\":\"\"},\"top\":{\"unit\":\"px\",\"value\":\"\"},\"bottom\":{\"unit\":\"px\",\"value\":\"\"}}}}},\"props\":{\"layout\":{\"horizontalInnerGap\":0,\"verticalInnerGap\":0},\"verticalAlign\":\"center\"}},{\"id\":95,\"type\":\"hop-post-nav-button\",\"nodeId\":\"23-m48\",\"v\":\"1.1\",\"nodes\":[\"432-m22\",\"456-m22\",\"1843-m26\",\"28-m26\"],\"style\":{\"descendants\":{\"navigationButton\":{\"states\":{\"hover\":{\"typography\":{\"color\":\"${theme.colors.0|variant3}\"},\"border\":{\"bottom\":{\"color\":\"${theme.colors.5}\"},\"top\":{\"color\":\"${theme.colors.5}\"},\"left\":{\"color\":\"${theme.colors.5}\"},\"right\":{\"color\":\"${theme.colors.5}\"}}}},\"padding\":{\"top\":{\"value\":\"16\",\"unit\":\"px\"},\"right\":{\"value\":\"10\",\"unit\":\"px\"},\"bottom\":{\"value\":\"16\",\"unit\":\"px\"},\"left\":{\"value\":\"0\",\"unit\":\"px\"}},\"transition\":{\"duration\":{\"value\":\"0.5\"}},\"typography\":{\"decoration\":\"none\",\"color\":\"${theme.colors.5}\",\"size\":{\"unit\":\"px\",\"value\":\"16\"},\"weight\":\"400\",\"family\":\"Open Sans\"},\"border\":{\"top\":{\"radius\":{\"left\":{\"value\":\"\",\"unit\":\"px\"},\"right\":{\"value\":\"\",\"unit\":\"px\"}}},\"bottom\":{\"radius\":{\"left\":{\"value\":\"\",\"unit\":\"px\"},\"right\":{\"value\":\"\",\"unit\":\"px\"}}}},\"media\":{\"mobile\":{\"padding\":{\"top\":{\"value\":\"16\",\"unit\":\"px\"},\"right\":{\"value\":\"10\",\"unit\":\"px\"},\"bottom\":{\"value\":\"16\",\"unit\":\"px\"},\"left\":{\"value\":\"0\",\"unit\":\"px\"}}},\"tablet\":{\"padding\":{\"top\":{\"value\":\"16\",\"unit\":\"px\"},\"right\":{\"value\":\"10\",\"unit\":\"px\"},\"bottom\":{\"value\":\"16\",\"unit\":\"px\"},\"left\":{\"value\":\"0\",\"unit\":\"px\"}}}}},\"navigationTitle\":{\"maxWidth\":{\"value\":\"40\",\"unit\":\"ch\"}}}}},{\"id\":96,\"type\":\"hop-column\",\"nodeId\":\"456-m33\",\"nodes\":[\"456-m23\",\"1843-m27\",\"28-m27\"],\"v\":\"1.1\"},{\"id\":97,\"type\":\"hop-column\",\"nodeId\":\"456-m24\",\"nodes\":[\"459-m21\",\"456-m24\",\"1843-m28\",\"28-m28\"],\"v\":\"1.1\",\"style\":{\"textAlign\":\"right\",\"padding\":{\"left\":{\"unit\":\"px\",\"value\":\"\"},\"right\":{\"unit\":\"px\",\"value\":\"\"},\"top\":{\"unit\":\"px\",\"value\":\"\"},\"bottom\":{\"unit\":\"px\",\"value\":\"\"}},\"descendants\":{\"outer\":{\"padding\":{\"left\":{\"unit\":\"px\",\"value\":\"\"},\"right\":{\"unit\":\"px\",\"value\":\"\"},\"top\":{\"unit\":\"px\",\"value\":\"\"},\"bottom\":{\"unit\":\"px\",\"value\":\"\"}},\"media\":{\"mobile\":{\"padding\":{\"left\":{\"unit\":\"px\",\"value\":\"\"},\"right\":{\"unit\":\"px\",\"value\":\"\"},\"top\":{\"unit\":\"px\",\"value\":\"\"},\"bottom\":{\"unit\":\"px\",\"value\":\"\"}}}}}},\"media\":{\"mobile\":{\"padding\":{\"left\":{\"unit\":\"px\",\"value\":\"\"},\"right\":{\"unit\":\"px\",\"value\":\"\"},\"top\":{\"unit\":\"px\",\"value\":\"\"},\"bottom\":{\"unit\":\"px\",\"value\":\"\"}}}}},\"props\":{\"layout\":{\"horizontalInnerGap\":0,\"verticalInnerGap\":0},\"verticalAlign\":\"center\"}},{\"id\":98,\"type\":\"hop-post-nav-button\",\"nodeId\":\"456-m25\",\"v\":\"1.1\",\"nodes\":[\"456-m25\",\"1843-m29\",\"28-m29\"],\"style\":{\"descendants\":{\"navigationButton\":{\"padding\":{\"top\":{\"value\":\"16\",\"unit\":\"px\"},\"right\":{\"value\":\"0\",\"unit\":\"px\"},\"bottom\":{\"value\":\"16\",\"unit\":\"px\"},\"left\":{\"value\":\"10\",\"unit\":\"px\"}},\"states\":{\"hover\":{\"typography\":{\"color\":\"${theme.colors.0|variant3}\"}}},\"transition\":{\"duration\":{\"value\":\"0.5\"}},\"typography\":{\"color\":\"${theme.colors.5}\",\"decoration\":\"none\",\"family\":\"Open Sans\",\"weight\":\"400\",\"size\":{\"unit\":\"px\",\"value\":\"16\"}},\"border\":{\"top\":{\"radius\":{\"left\":{\"value\":\"\",\"unit\":\"px\"},\"right\":{\"value\":\"\",\"unit\":\"px\"}},\"color\":\"${theme.colors.5}\"},\"bottom\":{\"radius\":{\"left\":{\"value\":\"\",\"unit\":\"px\"},\"right\":{\"value\":\"\",\"unit\":\"px\"}},\"color\":\"${theme.colors.5}\"},\"left\":{\"color\":\"${theme.colors.5}\"},\"right\":{\"color\":\"${theme.colors.5}\"}},\"media\":{\"mobile\":{\"padding\":{\"top\":{\"value\":\"16\",\"unit\":\"px\"},\"right\":{\"value\":\"0\",\"unit\":\"px\"},\"bottom\":{\"value\":\"16\",\"unit\":\"px\"},\"left\":{\"value\":\"10\",\"unit\":\"px\"}}},\"tablet\":{\"padding\":{\"top\":{\"value\":\"16\",\"unit\":\"px\"},\"right\":{\"value\":\"0\",\"unit\":\"px\"},\"bottom\":{\"value\":\"16\",\"unit\":\"px\"},\"left\":{\"value\":\"10\",\"unit\":\"px\"}}}}},\"navigationTitle\":{\"maxWidth\":{\"value\":\"40\",\"unit\":\"ch\"}}}}},{\"id\":99,\"props\":{\"layout\":{\"equalWidth\":false,\"horizontalInnerGap\":0,\"verticalInnerGap\":0,\"horizontalGap\":0,\"verticalGap\":0,\"custom\":{\"horizontalGap\":{\"unit\":\"px\",\"value\":\"\"},\"verticalGap\":{\"unit\":\"px\",\"value\":\"\"},\"horizontalInnerGap\":{\"unit\":\"px\",\"value\":\"\"},\"verticalInnerGap\":{\"unit\":\"px\",\"value\":\"\"}}},\"media\":{\"mobile\":{\"layout\":{\"horizontalGap\":3,\"verticalGap\":0}}}},\"type\":\"hop-row\",\"nodeId\":\"16-m56\",\"nodes\":[\"432-m30\",\"456-m26\",\"1843-m30\",\"28-m30\"],\"v\":\"1.1\",\"style\":{\"margin\":{\"top\":{\"value\":\"\",\"unit\":\"px\"},\"right\":{\"value\":\"40\",\"unit\":\"px\"},\"bottom\":{\"value\":\"\",\"unit\":\"px\"},\"left\":{\"value\":\"40\",\"unit\":\"px\"}},\"media\":{\"tablet\":{\"margin\":{\"top\":{\"value\":\"\",\"unit\":\"px\"},\"right\":{\"value\":\"20\",\"unit\":\"px\"},\"bottom\":{\"value\":\"\",\"unit\":\"px\"},\"left\":{\"value\":\"20\",\"unit\":\"px\"}}},\"mobile\":{\"margin\":{\"top\":{\"value\":\"\",\"unit\":\"px\"},\"right\":{\"value\":\"0\",\"unit\":\"px\"},\"bottom\":{\"value\":\"\",\"unit\":\"px\"},\"left\":{\"value\":\"0\",\"unit\":\"px\"}}}}}},{\"id\":100,\"type\":\"hop-column\",\"nodeId\":\"16-m57\",\"nodes\":[\"432-m31\",\"456-m27\",\"1843-m31\",\"28-m31\"],\"v\":\"1.1\",\"style\":{\"padding\":{\"left\":{\"unit\":\"px\",\"value\":\"\"},\"right\":{\"unit\":\"px\",\"value\":\"\"},\"top\":{\"unit\":\"px\",\"value\":\"\"},\"bottom\":{\"unit\":\"px\",\"value\":\"\"}},\"textAlign\":\"left\",\"media\":{\"tablet\":{\"padding\":{\"top\":{\"value\":\"\",\"unit\":\"px\"},\"right\":{\"value\":\"\",\"unit\":\"px\"},\"bottom\":{\"value\":\"\",\"unit\":\"px\"},\"left\":{\"value\":\"\",\"unit\":\"px\"}}},\"mobile\":{\"padding\":{\"top\":{\"unit\":\"px\",\"value\":\"\"},\"bottom\":{\"unit\":\"px\",\"value\":\"\"}}}},\"background\":{\"type\":\"none\",\"image\":[{\"source\":{\"type\":\"gradient\",\"gradient\":{\"steps\":[{\"color\":\"${theme.colors.4}\",\"position\":\"42\"},{\"color\":\"rgba(230, 230, 230, 0.5)\"}],\"angle\":\"145\"}}}]},\"descendants\":{\"outer\":{\"padding\":{\"left\":{\"unit\":\"px\",\"value\":\"\"},\"right\":{\"unit\":\"px\",\"value\":\"\"},\"top\":{\"unit\":\"px\",\"value\":\"\"},\"bottom\":{\"unit\":\"px\",\"value\":\"\"}},\"media\":{\"mobile\":{\"padding\":{\"left\":{\"unit\":\"px\",\"value\":\"\"},\"right\":{\"unit\":\"px\",\"value\":\"\"},\"top\":{\"unit\":\"px\",\"value\":\"\"},\"bottom\":{\"unit\":\"px\",\"value\":\"\"}}}}}}},\"props\":{\"layout\":{\"horizontalInnerGap\":0,\"verticalInnerGap\":0},\"media\":{\"mobile\":{\"layout\":{\"verticalInnerGap\":0}},\"tablet\":{\"layout\":{\"verticalInnerGap\":0}}}}},{\"id\":101,\"type\":\"hop-post-comments\",\"nodeId\":\"1723-m26\",\"v\":\"1.1\",\"nodes\":[\"432-m32\",\"456-m28\",\"1843-m32\",\"28-m32\"],\"style\":{\"descendants\":{\"commentsTitle\":{\"typography\":{\"decoration\":\"none\",\"color\":\"${theme.colors.6}\",\"weight\":\"600\",\"family\":\"Open Sans\",\"size\":{\"unit\":\"em\",\"value\":\"1.25\"}}},\"commentInfo\":{\"typography\":{\"decoration\":\"none\",\"color\":\"${theme.colors.5|variant3}\",\"size\":{\"unit\":\"px\",\"value\":\"14\"},\"family\":\"Montserrat\",\"weight\":\"300\"},\"background\":{\"color\":\"\"},\"margin\":{\"top\":{\"value\":\"\",\"unit\":\"px\"},\"right\":{\"value\":\"\",\"unit\":\"px\"},\"bottom\":{\"value\":\"\",\"unit\":\"px\"},\"left\":{\"value\":\"\",\"unit\":\"px\"}},\"transition\":{\"duration\":{\"value\":\"0.5\"}},\"states\":{\"hover\":{\"typography\":{\"color\":\"${theme.colors.0|variant3}\"}}}},\"commentText\":{\"typography\":{\"decoration\":\"none\",\"color\":\"${theme.colors.6|variant3}\",\"size\":{\"unit\":\"px\",\"value\":\"16\"},\"holders\":{\"p\":{\"color\":\"${theme.colors.6|variant3}\"},\"a\":{\"states\":{\"hover\":{\"color\":\"${theme.colors.0}\"}},\"color\":\"${theme.colors.0|variant3}\"}}}},\"commentAuthorName\":{\"typography\":{\"decoration\":\"none\",\"style\":\"normal\",\"weight\":\"300\",\"color\":\"${theme.colors.5|variant3}\",\"family\":\"Montserrat\",\"size\":{\"unit\":\"px\",\"value\":\"14\"}},\"background\":{\"color\":\"\"},\"margin\":{\"top\":{\"value\":\"\",\"unit\":\"px\"},\"right\":{\"value\":\"\",\"unit\":\"px\"},\"bottom\":{\"value\":\"\",\"unit\":\"px\"},\"left\":{\"value\":\"5\",\"unit\":\"px\"}}},\"disabledComments\":{\"typography\":{\"decoration\":\"none\",\"color\":\"${theme.colors.6|variant3}\"}},\"comment\":{\"background\":{\"color\":\"${theme.colors.7}\"},\"padding\":{\"top\":{\"value\":\"0\",\"unit\":\"px\"},\"right\":{\"value\":\"12\",\"unit\":\"px\"},\"bottom\":{\"value\":\"0\",\"unit\":\"px\"},\"left\":{\"value\":\"12\",\"unit\":\"px\"}},\"border\":{\"top\":{\"style\":\"solid\",\"width\":{\"value\":\"0\",\"unit\":\"px\"},\"color\":\"rgb(230, 230, 230)\"},\"right\":{\"style\":\"solid\",\"width\":{\"value\":\"0\",\"unit\":\"px\"},\"color\":\"rgb(230, 230, 230)\"},\"bottom\":{\"style\":\"solid\",\"width\":{\"value\":\"0\",\"unit\":\"px\"},\"color\":\"rgb(230, 230, 230)\"},\"left\":{\"style\":\"solid\",\"width\":{\"value\":\"5\",\"unit\":\"px\"},\"color\":\"rgb(230, 230, 230)\"}},\"margin\":{\"top\":{\"value\":\"15\",\"unit\":\"px\"},\"right\":{\"value\":\"\",\"unit\":\"px\"},\"bottom\":{\"value\":\"12\",\"unit\":\"px\"},\"left\":{\"value\":\"\",\"unit\":\"px\"}}},\"commentAvatar\":{\"width\":{\"value\":30},\"height\":{\"value\":30},\"background\":{\"color\":\"\"},\"margin\":{\"top\":{\"value\":\"\",\"unit\":\"px\"},\"right\":{\"value\":\"5\",\"unit\":\"px\"},\"bottom\":{\"value\":\"\",\"unit\":\"px\"},\"left\":{\"value\":\"\",\"unit\":\"px\"}},\"border\":{\"top\":{\"radius\":{\"left\":{\"value\":\"300\",\"unit\":\"px\"},\"right\":{\"value\":\"300\",\"unit\":\"px\"}}},\"bottom\":{\"radius\":{\"left\":{\"value\":\"300\",\"unit\":\"px\"},\"right\":{\"value\":\"300\",\"unit\":\"px\"}}}}},\"commentsContainer\":{\"background\":{\"color\":\"\"}},\"commentReply\":{\"typography\":{\"color\":\"${theme.colors.0|variant3}\",\"size\":{\"unit\":\"em\",\"value\":\"1\"},\"transform\":\"lowercase\",\"weight\":\"400\",\"lineHeight\":{\"unit\":\"\",\"value\":\"1.5\"}},\"states\":{\"hover\":{\"typography\":{\"color\":\"${theme.colors.0}\"}}},\"background\":{\"color\":\"\"},\"margin\":{\"top\":{\"value\":\"\",\"unit\":\"px\"},\"right\":{\"value\":\"\",\"unit\":\"px\"},\"bottom\":{\"value\":\"0\",\"unit\":\"px\"},\"left\":{\"value\":\"\",\"unit\":\"px\"}}},\"alternateComment\":{\"padding\":{\"top\":{\"value\":\"0\",\"unit\":\"px\"},\"right\":{\"value\":\"12\",\"unit\":\"px\"},\"bottom\":{\"value\":\"0\",\"unit\":\"px\"},\"left\":{\"value\":\"12\",\"unit\":\"px\"}},\"border\":{\"top\":{\"style\":\"solid\",\"width\":{\"value\":\"0\",\"unit\":\"px\"},\"color\":\"rgb(230, 230, 230)\"},\"right\":{\"style\":\"solid\",\"width\":{\"value\":\"0\",\"unit\":\"px\"},\"color\":\"rgb(230, 230, 230)\"},\"bottom\":{\"style\":\"solid\",\"width\":{\"value\":\"0\",\"unit\":\"px\"},\"color\":\"rgb(230, 230, 230)\"},\"left\":{\"style\":\"solid\",\"width\":{\"value\":\"5\",\"unit\":\"px\"},\"color\":\"rgb(230, 230, 230)\"}},\"margin\":{\"top\":{\"value\":\"15\",\"unit\":\"px\"},\"right\":{\"value\":\"\",\"unit\":\"px\"},\"bottom\":{\"value\":\"12\",\"unit\":\"px\"},\"left\":{\"value\":\"\",\"unit\":\"px\"}}},\"commentReplies\":{\"margin\":{\"left\":{\"value\":\"12\"}}},\"commentInfoContainer\":{\"typography\":{\"color\":\"${theme.colors.6|variant2}\"},\"margin\":{\"top\":{\"value\":\"\",\"unit\":\"px\"},\"right\":{\"value\":\"\",\"unit\":\"px\"},\"bottom\":{\"value\":\"16\",\"unit\":\"px\"},\"left\":{\"value\":\"\",\"unit\":\"px\"}},\"states\":{\"hover\":{\"typography\":{\"color\":\"${theme.colors.6}\"}}}},\"commentEdit\":{\"typography\":{\"size\":{\"unit\":\"px\",\"value\":\"14\"},\"color\":\"${theme.colors.5|variant3}\",\"weight\":\"300\",\"family\":\"Montserrat\"},\"states\":{\"hover\":{\"typography\":{\"color\":\"${theme.colors.0|variant3}\"}}}}}}},{\"id\":102,\"type\":\"hop-post-comment-form\",\"nodeId\":\"23-m32\",\"v\":\"1.1\",\"nodes\":[\"432-m33\",\"456-m29\",\"1843-m33\",\"28-m33\"],\"style\":{\"descendants\":{\"commentFormTitle\":{\"typography\":{\"color\":\"${theme.colors.6|variant3}\",\"size\":{\"unit\":\"em\",\"value\":\"1.25\"},\"weight\":\"600\",\"family\":\"Montserrat\"}},\"commentFormLabels\":{\"typography\":{\"color\":\"${theme.colors.6|variant3}\",\"size\":{\"unit\":\"px\",\"value\":\"16\"},\"weight\":\"400\",\"family\":\"Open Sans\"},\"border\":{\"top\":{\"radius\":{\"left\":{\"value\":\"\",\"unit\":\"px\"},\"right\":{\"value\":\"\",\"unit\":\"px\"}}},\"bottom\":{\"radius\":{\"left\":{\"value\":\"\",\"unit\":\"px\"},\"right\":{\"value\":\"\",\"unit\":\"px\"}}}}},\"commentFormButton\":{\"background\":{\"color\":\"${theme.colors.0}\"},\"states\":{\"hover\":{\"background\":{\"color\":\"${theme.colors.0|variant3}\"},\"border\":{\"top\":{\"color\":\"${theme.colors.0|variant3}\"},\"bottom\":{\"color\":\"${theme.colors.0|variant3}\"},\"right\":{\"color\":\"${theme.colors.0|variant3}\"},\"left\":{\"color\":\"${theme.colors.0|variant3}\"}}}},\"border\":{\"top\":{\"style\":\"solid\",\"width\":{\"value\":\"2\",\"unit\":\"px\"},\"radius\":{\"left\":{\"value\":\"4\",\"unit\":\"px\"},\"right\":{\"value\":\"4\",\"unit\":\"px\"}},\"color\":\"${theme.colors.0}\"},\"right\":{\"style\":\"solid\",\"width\":{\"value\":\"2\",\"unit\":\"px\"},\"color\":\"${theme.colors.0}\"},\"bottom\":{\"style\":\"solid\",\"width\":{\"value\":\"2\",\"unit\":\"px\"},\"radius\":{\"left\":{\"value\":\"4\",\"unit\":\"px\"},\"right\":{\"value\":\"4\",\"unit\":\"px\"}},\"color\":\"${theme.colors.0}\"},\"left\":{\"style\":\"solid\",\"width\":{\"value\":\"2\",\"unit\":\"px\"},\"color\":\"${theme.colors.0}\"}},\"padding\":{\"top\":{\"value\":\"12\",\"unit\":\"px\"},\"right\":{\"value\":\"24\",\"unit\":\"px\"},\"bottom\":{\"value\":\"12\",\"unit\":\"px\"},\"left\":{\"value\":\"24\",\"unit\":\"px\"}},\"typography\":{\"color\":\"${theme.colors.4}\",\"size\":{\"unit\":\"px\",\"value\":\"12\"},\"weight\":\"600\",\"family\":\"Open Sans\",\"transform\":\"uppercase\",\"lineHeight\":{\"unit\":\"\",\"value\":\"1\"},\"letterSpacing\":{\"unit\":\"px\",\"value\":\"1\"}}},\"commentFormInputs\":{\"border\":{\"top\":{\"color\":\"rgba(204, 204, 204, 0.8)\",\"radius\":{\"left\":{\"value\":\"0\",\"unit\":\"px\"},\"right\":{\"value\":\"0\",\"unit\":\"px\"}},\"width\":{\"value\":\"0\",\"unit\":\"px\"}},\"right\":{\"color\":\"rgba(204, 204, 204, 0.8)\",\"width\":{\"value\":\"0\",\"unit\":\"px\"}},\"left\":{\"color\":\"rgba(204, 204, 204, 0.8)\",\"width\":{\"value\":\"0\",\"unit\":\"px\"}},\"bottom\":{\"color\":\"rgba(204, 204, 204, 0.8)\",\"radius\":{\"left\":{\"value\":\"0\",\"unit\":\"px\"},\"right\":{\"value\":\"0\",\"unit\":\"px\"}},\"width\":{\"value\":\"1\",\"unit\":\"px\"}}},\"typography\":{\"weight\":\"300\",\"family\":\"Open Sans\",\"size\":{\"unit\":\"px\",\"value\":\"16\"},\"color\":\"${theme.colors.6|variant3}\"},\"background\":{\"color\":\"rgba(0,0,0,0)\"},\"padding\":{\"top\":{\"value\":\"5\",\"unit\":\"px\"},\"right\":{\"value\":\"5\",\"unit\":\"px\"},\"bottom\":{\"value\":\"5\",\"unit\":\"px\"},\"left\":{\"value\":\"5\",\"unit\":\"px\"}}},\"commentFormNotes\":{\"typography\":{\"color\":\"${theme.colors.6|variant2}\",\"weight\":\"400\",\"family\":\"Open Sans\",\"size\":{\"unit\":\"px\",\"value\":\"14\"}}}},\"border\":{\"top\":{\"radius\":{\"left\":{\"value\":\"\",\"unit\":\"px\"},\"right\":{\"value\":\"\",\"unit\":\"px\"}},\"style\":\"none\",\"width\":{\"value\":\"0\",\"unit\":\"px\"}},\"bottom\":{\"radius\":{\"left\":{\"value\":\"\",\"unit\":\"px\"},\"right\":{\"value\":\"\",\"unit\":\"px\"}},\"style\":\"none\",\"width\":{\"value\":\"0\",\"unit\":\"px\"}},\"right\":{\"style\":\"none\",\"width\":{\"value\":\"0\",\"unit\":\"px\"}},\"left\":{\"style\":\"none\",\"width\":{\"value\":\"0\",\"unit\":\"px\"}}}}},{\"id\":103,\"type\":\"hop-main\",\"nodeId\":\"68-m1\",\"v\":\"1.1\",\"nodes\":[\"435-m1\",\"459-m1\",\"1846-m1\",\"31-m1\"],\"style\":{\"media\":{\"tablet\":{\"margin\":{\"top\":{\"value\":\"-95\",\"unit\":\"px\"},\"right\":{\"value\":\"\",\"unit\":\"px\"},\"bottom\":{\"value\":\"\",\"unit\":\"px\"},\"left\":{\"value\":\"\",\"unit\":\"px\"}}}},\"margin\":{\"top\":{\"value\":\"-120\",\"unit\":\"px\"},\"right\":{\"value\":\"\",\"unit\":\"px\"},\"bottom\":{\"value\":\"\",\"unit\":\"px\"},\"left\":{\"value\":\"\",\"unit\":\"px\"}}}},{\"id\":104,\"type\":\"hop-section\",\"nodeId\":\"19-m36\",\"nodes\":[\"435-m2\",\"459-m2\",\"1846-m2\",\"31-m2\"],\"style\":{\"padding\":{\"top\":{\"value\":\"0\"},\"bottom\":{\"value\":\"0\"}}},\"v\":\"1.1\"},{\"id\":105,\"props\":{\"layout\":{\"equalWidth\":false}},\"type\":\"hop-row\",\"nodeId\":\"19-m40\",\"nodes\":[\"435-m25\",\"459-m23\",\"1846-m23\",\"31-m23\"],\"v\":\"1.1\"},{\"id\":106,\"type\":\"hop-column\",\"nodeId\":\"19-m41\",\"nodes\":[\"435-m26\",\"459-m24\",\"1846-m24\",\"31-m24\"],\"v\":\"1.1\"},{\"id\":107,\"props\":{\"headerType\":\"2\"},\"type\":\"hop-heading\",\"nodeId\":\"19-m42\",\"nodes\":[\"435-m27\",\"459-m25\",\"1846-m25\",\"31-m25\"],\"v\":\"1.1\"},{\"id\":108,\"type\":\"hop-text\",\"nodeId\":\"19-m43\",\"nodes\":[\"435-m28\",\"459-m26\",\"1846-m26\",\"31-m26\"],\"v\":\"1.1\"},{\"id\":109,\"type\":\"hop-archive-loop\",\"nodeId\":\"26-m6\",\"props\":{\"layout\":{\"horizontalGap\":3,\"verticalGap\":3,\"horizontalInnerGap\":0,\"verticalInnerGap\":0,\"itemsPerRow\":2,\"horizontalAlign\":\"start\",\"custom\":{\"horizontalInnerGap\":{\"unit\":\"px\",\"value\":\"\"},\"verticalInnerGap\":{\"unit\":\"px\",\"value\":\"\"},\"horizontalGap\":{\"unit\":\"px\",\"value\":\"\"},\"verticalGap\":{\"unit\":\"px\",\"value\":\"\"}}},\"media\":{\"tablet\":{\"layout\":{\"itemsPerRow\":1,\"horizontalGap\":3,\"verticalGap\":3}},\"mobile\":{\"layout\":{\"horizontalInnerGap\":0,\"verticalInnerGap\":0,\"horizontalGap\":3}}},\"showMasonry\":true},\"v\":\"1.1\",\"nodes\":[\"435-m3\",\"459-m3\",\"1846-m3\",\"31-m3\"]},{\"id\":110,\"type\":\"hop-loop-item\",\"nodeId\":\"26-m7\",\"style\":{\"background\":{\"color\":\"${theme.colors.4}\",\"type\":\"gradient\",\"image\":[{\"source\":{\"type\":\"gradient\",\"gradient\":{\"steps\":[{\"color\":\"${theme.colors.4}\",\"position\":\"42\"},{\"color\":\"rgb(239, 239, 239)\",\"position\":100}],\"angle\":\"145\"}}}]},\"border\":{\"top\":{\"radius\":{\"left\":{\"value\":\"40\",\"unit\":\"px\"},\"right\":{\"value\":\"40\",\"unit\":\"px\"}},\"style\":\"none\",\"width\":{\"value\":\"0\",\"unit\":\"px\"},\"color\":\"rgb(246, 246, 246)\"},\"bottom\":{\"radius\":{\"left\":{\"value\":\"40\",\"unit\":\"px\"},\"right\":{\"value\":\"40\",\"unit\":\"px\"}},\"style\":\"none\",\"width\":{\"value\":\"5\",\"unit\":\"px\"},\"color\":\"rgb(246, 246, 246)\"},\"right\":{\"style\":\"none\",\"width\":{\"value\":\"0\",\"unit\":\"px\"},\"color\":\"rgb(246, 246, 246)\"},\"left\":{\"style\":\"none\",\"width\":{\"value\":\"0\",\"unit\":\"px\"},\"color\":\"rgb(246, 246, 246)\"}},\"descendants\":{\"outer\":{\"media\":{\"tablet\":{\"padding\":{\"left\":{\"unit\":\"px\",\"value\":\"\"},\"right\":{\"unit\":\"px\",\"value\":\"\"},\"top\":{\"unit\":\"px\",\"value\":\"\"},\"bottom\":{\"unit\":\"px\",\"value\":\"\"}}},\"mobile\":{\"padding\":{\"left\":{\"unit\":\"px\",\"value\":\"\"},\"right\":{\"unit\":\"px\",\"value\":\"\"}}}}}},\"boxShadow\":{\"enabled\":true,\"layers\":[{\"color\":\"rgba(0, 0, 0, 0.15)\",\"spread\":\"2\",\"y\":\"20\",\"blur\":\"60\",\"x\":\"20\"}]},\"media\":{\"tablet\":{\"border\":{\"top\":{\"radius\":{\"left\":{\"value\":\"20\",\"unit\":\"px\"},\"right\":{\"value\":\"20\",\"unit\":\"px\"}}},\"bottom\":{\"radius\":{\"left\":{\"value\":\"20\",\"unit\":\"px\"},\"right\":{\"value\":\"20\",\"unit\":\"px\"}}}}},\"mobile\":{\"border\":{\"top\":{\"radius\":{\"left\":{\"value\":\"20\",\"unit\":\"px\"},\"right\":{\"value\":\"20\",\"unit\":\"px\"}}},\"bottom\":{\"radius\":{\"left\":{\"value\":\"20\",\"unit\":\"px\"},\"right\":{\"value\":\"20\",\"unit\":\"px\"}}}}}}},\"v\":\"1.1\",\"nodes\":[\"435-m4\",\"459-m4\",\"1846-m4\",\"31-m4\"],\"props\":{\"attrs\":{\"overflowOption\":\"hidden\"}}},{\"id\":111,\"type\":\"hop-post-thumbnail\",\"nodeId\":\"26-m19\",\"style\":{\"margin\":{\"top\":{\"unit\":\"px\"},\"right\":{\"unit\":\"px\"},\"bottom\":{\"value\":\"0\",\"unit\":\"px\"},\"left\":{\"unit\":\"px\"}},\"background\":{\"color\":\"rgba(255,255,255,0)\"}},\"v\":\"1.1\",\"nodes\":[\"435-m5\",\"459-m5\",\"1846-m5\",\"31-m5\"]},{\"id\":112,\"props\":{\"layout\":{\"equalWidth\":false,\"horizontalGap\":2,\"verticalGap\":2,\"horizontalInnerGap\":2,\"verticalInnerGap\":2},\"media\":{\"mobile\":{\"layout\":{\"horizontalGap\":2}}}},\"type\":\"hop-row\",\"style\":{\"padding\":{\"top\":{\"value\":\"\",\"unit\":\"px\"},\"right\":{\"value\":\"\",\"unit\":\"px\"},\"bottom\":{\"value\":\"5\",\"unit\":\"px\"},\"left\":{\"value\":\"\",\"unit\":\"px\"}}},\"v\":\"1.1\",\"nodes\":[\"459-m6\",\"5-c171\",\"1846-m6\",\"31-m6\"]},{\"id\":113,\"type\":\"hop-column\",\"style\":{\"descendants\":{\"outer\":{\"padding\":{\"left\":{\"unit\":\"px\",\"value\":\"\"},\"right\":{\"unit\":\"px\",\"value\":\"\"},\"top\":{\"unit\":\"px\",\"value\":\"\"},\"bottom\":{\"unit\":\"px\",\"value\":\"\"}},\"media\":{\"mobile\":{\"padding\":{\"left\":{\"unit\":\"px\"},\"right\":{\"unit\":\"px\"}}}}}},\"padding\":{\"left\":{\"unit\":\"px\",\"value\":\"\"},\"right\":{\"unit\":\"px\",\"value\":\"\"},\"top\":{\"unit\":\"px\",\"value\":\"\"},\"bottom\":{\"unit\":\"px\",\"value\":\"\"}},\"textAlign\":\"left\",\"media\":{\"mobile\":{\"textAlign\":\"center\"}},\"border\":{\"top\":{\"style\":\"none\",\"width\":{\"value\":\"0\",\"unit\":\"px\"}},\"right\":{\"style\":\"none\",\"width\":{\"value\":\"0\",\"unit\":\"px\"}},\"bottom\":{\"style\":\"none\",\"width\":{\"value\":\"0\",\"unit\":\"px\"}},\"left\":{\"style\":\"none\",\"width\":{\"value\":\"0\",\"unit\":\"px\"}}},\"background\":{\"color\":\"\"}},\"props\":{\"layout\":{\"horizontalInnerGap\":2,\"verticalInnerGap\":2}},\"v\":\"1.1\",\"nodes\":[\"459-m7\",\"5-c172\",\"1846-m7\",\"31-m7\"]},{\"id\":114,\"type\":\"hop-post-title\",\"style\":{\"descendants\":{\"title\":{\"states\":{\"hover\":{\"typography\":{\"color\":\"${theme.colors.0|variant3}\"}}}}}},\"v\":\"1.1\",\"nodes\":[\"459-m8\",\"1846-m8\",\"31-m8\"],\"nodeId\":\"459-m10\"},{\"id\":115,\"type\":\"hop-post-excerpt\",\"nodeId\":\"26-m11\",\"style\":{\"descendants\":{\"excerpt\":{\"typography\":{\"color\":\"${theme.colors.5|variant2}\"}}}},\"v\":\"1.1\",\"nodes\":[\"435-m11\",\"459-m9\",\"1846-m9\",\"31-m9\"]},{\"id\":116,\"props\":{\"layout\":{\"equalWidth\":false,\"horizontalGap\":0,\"verticalGap\":0,\"horizontalInnerGap\":0,\"verticalInnerGap\":0}},\"type\":\"hop-row\",\"nodeId\":\"459-m24\",\"nodes\":[\"459-m10\",\"1846-m10\",\"31-m10\"],\"v\":\"1.1\"},{\"id\":117,\"type\":\"hop-column\",\"nodeId\":\"5-c194\",\"nodes\":[\"459-m11\",\"465-m7\",\"5-c176\",\"1846-m11\",\"31-m11\"],\"v\":\"1.1\",\"style\":{\"descendants\":{\"outer\":{\"padding\":{\"left\":{\"unit\":\"px\",\"value\":\"\"},\"right\":{\"unit\":\"px\",\"value\":\"\"},\"top\":{\"unit\":\"px\",\"value\":\"\"},\"bottom\":{\"unit\":\"px\",\"value\":\"\"}}}},\"padding\":{\"left\":{\"unit\":\"px\",\"value\":\"\"},\"right\":{\"unit\":\"px\",\"value\":\"\"},\"top\":{\"unit\":\"px\",\"value\":\"\"},\"bottom\":{\"unit\":\"px\",\"value\":\"\"}},\"textAlign\":\"left\"},\"props\":{\"verticalAlign\":\"center\"}},{\"id\":118,\"type\":\"hop-post-meta\",\"nodeId\":\"5-c229\",\"nodes\":[\"459-m12\",\"465-m8\",\"456-m8\",\"5-c177\",\"1843-m12\",\"1852-m8\",\"1861-c179\",\"1846-m12\",\"31-m12\"],\"v\":\"1.1\",\"style\":{\"descendants\":{\"metaDataLinks\":{\"typography\":{\"color\":\"${theme.colors.5|variant2}\",\"weight\":\"400\",\"family\":\"Open Sans\",\"size\":{\"unit\":\"px\",\"value\":\"14\"}},\"states\":{\"hover\":{\"typography\":{\"color\":\"${theme.colors.5}\"}}}},\"icons\":{\"margin\":{\"right\":{\"value\":\"5\"}},\"display\":\"none\"},\"separators\":{\"typography\":{\"color\":\"${theme.colors.5|variant3}\",\"size\":{\"unit\":\"px\",\"value\":\"14\"},\"lineHeight\":{\"unit\":\"\",\"value\":\"1.6\"}},\"padding\":{\"top\":{\"value\":\"\",\"unit\":\"px\"},\"right\":{\"value\":\"5\",\"unit\":\"px\"},\"bottom\":{\"value\":\"\",\"unit\":\"px\"},\"left\":{\"value\":\"\",\"unit\":\"px\"}}},\"metaDataPrefix\":{\"typography\":{\"size\":{\"unit\":\"px\",\"value\":\"14\"},\"color\":\"${theme.colors.5|variant2}\"}}}}},{\"id\":119,\"type\":\"hop-column\",\"nodeId\":\"5-c195\",\"nodes\":[\"459-m13\",\"465-m9\",\"5-c178\",\"1846-m13\",\"31-m13\"],\"v\":\"1.1\",\"style\":{\"descendants\":{\"outer\":{\"padding\":{\"left\":{\"unit\":\"px\",\"value\":\"\"},\"right\":{\"unit\":\"px\",\"value\":\"\"},\"top\":{\"unit\":\"px\",\"value\":\"\"},\"bottom\":{\"unit\":\"px\",\"value\":\"\"}}}},\"padding\":{\"left\":{\"unit\":\"px\",\"value\":\"\"},\"right\":{\"unit\":\"px\",\"value\":\"\"},\"top\":{\"unit\":\"px\",\"value\":\"\"},\"bottom\":{\"unit\":\"px\",\"value\":\"\"}}},\"props\":{\"verticalAlign\":\"center\"}},{\"id\":120,\"type\":\"hop-post-read-more-group\",\"nodeId\":\"459-m22\",\"nodes\":[\"459-m14\",\"1846-m14\",\"31-m14\"],\"v\":\"1.1\"},{\"id\":121,\"type\":\"hop-post-read-more\",\"style\":{\"descendants\":{\"icon\":{\"margin\":{\"right\":{\"value\":0,\"unit\":\"px\"},\"left\":{\"value\":\"3\",\"unit\":\"px\",\"path\":\"value\"}},\"size\":{\"value\":\"11\",\"unit\":\"px\"}}},\"border\":{\"top\":{\"style\":\"none\",\"width\":{\"value\":\"2\",\"unit\":\"px\"},\"radius\":{\"right\":{\"value\":0,\"unit\":\"px\",\"path\":\"value\"},\"left\":{\"value\":0,\"unit\":\"px\",\"path\":\"value\"}}},\"left\":{\"style\":\"none\",\"width\":{\"value\":\"2\",\"unit\":\"px\"}},\"right\":{\"style\":\"none\",\"width\":{\"value\":\"2\",\"unit\":\"px\"}},\"bottom\":{\"style\":\"none\",\"width\":{\"value\":\"2\",\"unit\":\"px\"},\"radius\":{\"right\":{\"value\":0,\"unit\":\"px\",\"path\":\"value\"},\"left\":{\"value\":0,\"unit\":\"px\",\"path\":\"value\"}}}},\"states\":{\"hover\":{\"boxShadow\":{\"layers\":[{\"y\":\"14\",\"spread\":\"-12\",\"blur\":\"26\",\"color\":\"rgba(0, 0, 0, 0.42)\"}]},\"typography\":{\"color\":\"${theme.colors.0|variant3}\"}}},\"textAlign\":\"center\",\"typography\":{\"color\":\"${theme.colors.6|variant3}\",\"size\":{\"unit\":\"px\",\"value\":\"14\"},\"family\":\"Open Sans\",\"weight\":\"400\"}},\"props\":{\"showIcon\":false,\"iconPosition\":\"after\",\"buttonSize\":\"small\",\"buttonWidth\":\"fitToContent\"},\"v\":\"1.1\",\"nodes\":[\"459-m15\",\"465-m11\",\"5-c180\",\"1852-m11\",\"1861-c182\",\"1846-m15\",\"31-m15\"]},{\"id\":122,\"props\":{\"layout\":{\"equalWidth\":false,\"custom\":{\"horizontalGap\":{\"unit\":\"px\",\"value\":\"\"},\"verticalGap\":{\"unit\":\"px\",\"value\":\"\"},\"horizontalInnerGap\":{\"unit\":\"px\",\"value\":\"\"},\"verticalInnerGap\":{\"unit\":\"px\",\"value\":\"\"}},\"horizontalGap\":0,\"verticalGap\":0,\"horizontalInnerGap\":0,\"verticalInnerGap\":0,\"horizontalAlign\":\"center\"},\"media\":{\"mobile\":{\"layout\":{\"horizontalAlign\":\"center\"}}}},\"type\":\"hop-post-nav-container\",\"nodeId\":\"19-m36\",\"nodes\":[\"435-m18\",\"459-m16\",\"1846-m16\",\"31-m16\"],\"v\":\"1.1\",\"style\":{\"border\":{\"top\":{\"style\":\"none\",\"width\":{\"value\":\"0\",\"unit\":\"px\"}},\"right\":{\"style\":\"none\",\"width\":{\"value\":\"0\",\"unit\":\"px\"}},\"bottom\":{\"style\":\"none\",\"width\":{\"value\":\"0\",\"unit\":\"px\"}},\"left\":{\"style\":\"none\",\"width\":{\"value\":\"0\",\"unit\":\"px\"}}},\"margin\":{\"top\":{\"value\":\"45\",\"unit\":\"px\"},\"right\":{\"value\":\"30\",\"unit\":\"px\"},\"bottom\":{\"value\":\"\",\"unit\":\"px\"},\"left\":{\"value\":\"30\",\"unit\":\"px\"}},\"media\":{\"tablet\":{\"margin\":{\"top\":{\"value\":\"30\",\"unit\":\"px\"},\"right\":{\"value\":\"10\",\"unit\":\"px\"},\"bottom\":{\"value\":\"\",\"unit\":\"px\"},\"left\":{\"value\":\"10\",\"unit\":\"px\"}}},\"mobile\":{\"margin\":{\"top\":{\"value\":\"15\",\"unit\":\"px\"},\"right\":{\"value\":\"15\",\"unit\":\"px\"},\"bottom\":{\"value\":\"\",\"unit\":\"px\"},\"left\":{\"value\":\"15\",\"unit\":\"px\"}}}}}},{\"id\":123,\"type\":\"hop-column\",\"nodeId\":\"459-m17\",\"nodes\":[\"459-m17\",\"1846-m17\",\"31-m17\"],\"v\":\"1.1\",\"style\":{\"textAlign\":\"left\",\"padding\":{\"left\":{\"unit\":\"px\",\"value\":\"\"},\"right\":{\"unit\":\"px\",\"value\":\"\"},\"top\":{\"unit\":\"px\",\"value\":\"\"},\"bottom\":{\"unit\":\"px\",\"value\":\"\"}},\"descendants\":{\"outer\":{\"padding\":{\"left\":{\"unit\":\"px\",\"value\":\"\"},\"right\":{\"unit\":\"px\",\"value\":\"\"},\"top\":{\"unit\":\"px\",\"value\":\"\"},\"bottom\":{\"unit\":\"px\",\"value\":\"\"}},\"media\":{\"mobile\":{\"padding\":{\"left\":{\"unit\":\"px\",\"value\":\"\"},\"right\":{\"unit\":\"px\",\"value\":\"\"},\"top\":{\"unit\":\"px\",\"value\":\"\"},\"bottom\":{\"unit\":\"px\",\"value\":\"\"}}}}}},\"media\":{\"mobile\":{\"padding\":{\"left\":{\"unit\":\"px\",\"value\":\"\"},\"right\":{\"unit\":\"px\",\"value\":\"\"},\"top\":{\"unit\":\"px\",\"value\":\"\"},\"bottom\":{\"unit\":\"px\",\"value\":\"\"}}}}},\"props\":{\"layout\":{\"horizontalInnerGap\":0,\"verticalInnerGap\":0},\"verticalAlign\":\"center\"}},{\"id\":124,\"type\":\"hop-archive-nav-button\",\"nodeId\":\"459-m18\",\"v\":\"1.1\",\"nodes\":[\"459-m18\",\"1846-m18\",\"31-m18\"],\"style\":{\"descendants\":{\"paginationNavigationButton\":{\"typography\":{\"decoration\":\"none\",\"lineHeight\":{\"unit\":\"\",\"value\":\"1.6\"},\"weight\":\"400\",\"family\":\"Open Sans\",\"size\":{\"unit\":\"px\",\"value\":\"16\"},\"transform\":\"\",\"color\":\"${theme.colors.5}\"},\"border\":{\"top\":{\"radius\":{\"left\":{\"value\":0,\"unit\":\"px\"},\"right\":{\"value\":0,\"unit\":\"px\"}}},\"bottom\":{\"radius\":{\"left\":{\"value\":0,\"unit\":\"px\"},\"right\":{\"value\":0,\"unit\":\"px\"}}}},\"padding\":{\"top\":{\"value\":\"16\",\"unit\":\"px\"},\"right\":{\"value\":\"10\",\"unit\":\"px\"},\"bottom\":{\"value\":\"16\",\"unit\":\"px\"},\"left\":{\"value\":\"0\",\"unit\":\"px\"}},\"states\":{\"hover\":{\"border\":{\"bottom\":{\"color\":\"${theme.colors.4}\"},\"top\":{\"color\":\"${theme.colors.4}\"},\"left\":{\"color\":\"${theme.colors.4}\"},\"right\":{\"color\":\"${theme.colors.4}\"}},\"typography\":{\"color\":\"${theme.colors.0|variant3}\"}}}}}}},{\"id\":125,\"type\":\"hop-column\",\"nodeId\":\"19-m39\",\"nodes\":[\"435-m21\",\"465-m12\",\"459-m19\",\"1846-m19\",\"31-m19\"],\"v\":\"1.1\",\"style\":{\"padding\":{\"left\":{\"unit\":\"px\",\"value\":\"\"},\"right\":{\"unit\":\"px\",\"value\":\"\"},\"top\":{\"unit\":\"px\",\"value\":\"\"},\"bottom\":{\"unit\":\"px\",\"value\":\"\"}},\"descendants\":{\"outer\":{\"padding\":{\"left\":{\"unit\":\"px\",\"value\":\"\"},\"right\":{\"unit\":\"px\",\"value\":\"\"}}}}},\"props\":{\"layout\":{\"horizontalInnerGap\":0,\"verticalInnerGap\":2},\"verticalAlign\":\"center\"}},{\"id\":126,\"type\":\"hop-archive-pagination\",\"nodeId\":\"26-m14\",\"style\":{\"descendants\":{\"paginationNumbers\":{\"typography\":{\"color\":\"${theme.colors.5|variant3}\"},\"states\":{\"hover\":{\"typography\":{\"color\":\"${theme.colors.0|variant3}\"}}}},\"paginationActiveNumber\":{\"states\":{\"hover\":{\"typography\":{\"color\":\"${theme.colors.0|variant3}\"}}},\"typography\":{\"color\":\"${theme.colors.0|variant3}\"}}}},\"v\":\"1.1\",\"nodes\":[\"435-m22\",\"459-m20\",\"1846-m20\",\"31-m20\"]},{\"id\":127,\"type\":\"hop-column\",\"nodeId\":\"459-m21\",\"nodes\":[\"459-m21\",\"1846-m21\",\"31-m21\"],\"v\":\"1.1\",\"style\":{\"textAlign\":\"right\",\"padding\":{\"left\":{\"unit\":\"px\",\"value\":\"\"},\"right\":{\"unit\":\"px\",\"value\":\"\"},\"top\":{\"unit\":\"px\",\"value\":\"\"},\"bottom\":{\"unit\":\"px\",\"value\":\"\"}},\"descendants\":{\"outer\":{\"padding\":{\"left\":{\"unit\":\"px\",\"value\":\"\"},\"right\":{\"unit\":\"px\",\"value\":\"\"},\"top\":{\"unit\":\"px\",\"value\":\"\"},\"bottom\":{\"unit\":\"px\",\"value\":\"\"}},\"media\":{\"mobile\":{\"padding\":{\"left\":{\"unit\":\"px\",\"value\":\"\"},\"right\":{\"unit\":\"px\",\"value\":\"\"},\"top\":{\"unit\":\"px\",\"value\":\"\"},\"bottom\":{\"unit\":\"px\",\"value\":\"\"}}}}}},\"media\":{\"mobile\":{\"padding\":{\"left\":{\"unit\":\"px\",\"value\":\"\"},\"right\":{\"unit\":\"px\",\"value\":\"\"},\"top\":{\"unit\":\"px\",\"value\":\"\"},\"bottom\":{\"unit\":\"px\",\"value\":\"\"}}}}},\"props\":{\"layout\":{\"horizontalInnerGap\":0,\"verticalInnerGap\":0},\"verticalAlign\":\"center\"}},{\"id\":128,\"type\":\"hop-archive-nav-button\",\"nodeId\":\"459-m18\",\"v\":\"1.1\",\"nodes\":[\"465-m18\",\"459-m22\",\"1846-m22\",\"31-m22\"],\"style\":{\"descendants\":{\"paginationNavigationButton\":{\"typography\":{\"decoration\":\"none\",\"lineHeight\":{\"unit\":\"\",\"value\":\"1.6\"},\"weight\":\"400\",\"family\":\"Open Sans\",\"size\":{\"unit\":\"px\",\"value\":\"16\"},\"transform\":\"\",\"color\":\"${theme.colors.5}\"},\"border\":{\"top\":{\"radius\":{\"left\":{\"value\":0,\"unit\":\"px\"},\"right\":{\"value\":0,\"unit\":\"px\"}}},\"bottom\":{\"radius\":{\"left\":{\"value\":0,\"unit\":\"px\"},\"right\":{\"value\":0,\"unit\":\"px\"}}}},\"padding\":{\"top\":{\"value\":\"16\",\"unit\":\"px\"},\"right\":{\"value\":\"0\",\"unit\":\"px\"},\"bottom\":{\"value\":\"16\",\"unit\":\"px\"},\"left\":{\"value\":\"10\",\"unit\":\"px\"}},\"states\":{\"hover\":{\"border\":{\"bottom\":{\"color\":\"${theme.colors.4}\"},\"top\":{\"color\":\"${theme.colors.4}\"},\"left\":{\"color\":\"${theme.colors.4}\"},\"right\":{\"color\":\"${theme.colors.4}\"}},\"typography\":{\"color\":\"${theme.colors.0|variant3}\"}}}}}}},{\"id\":129,\"type\":\"hop-main\",\"nodeId\":\"35-m1\",\"v\":\"1.1\",\"nodes\":[\"636-m1\",\"462-m1\",\"34-m1\"]},{\"id\":130,\"type\":\"hop-row\",\"nodeId\":\"1735-m2\",\"props\":{\"layout\":{\"itemsPerRow\":2,\"equalWidth\":false,\"horizontalGap\":0,\"verticalGap\":0,\"horizontalInnerGap\":0,\"verticalInnerGap\":0}},\"v\":\"1.1\",\"nodes\":[\"636-m2\",\"462-m2\",\"34-m2\"]},{\"id\":131,\"type\":\"hop-column\",\"nodeId\":\"35-m3\",\"style\":{\"descendants\":{\"outer\":{\"padding\":{\"left\":{\"unit\":\"px\"},\"right\":{\"unit\":\"px\"},\"top\":{\"unit\":\"px\"},\"bottom\":{\"unit\":\"px\"}}}},\"padding\":{\"left\":{\"unit\":\"px\"},\"right\":{\"unit\":\"px\"},\"top\":{\"unit\":\"px\"},\"bottom\":{\"unit\":\"px\"}}},\"v\":\"1.1\",\"nodes\":[\"636-m3\",\"462-m3\",\"34-m3\"]},{\"id\":132,\"type\":\"hop-heading\",\"nodeId\":\"1735-m11\",\"style\":{\"typography\":{\"color\":\"${theme.colors.5|variant3}\",\"size\":{\"unit\":\"em\",\"value\":\"10\"}}},\"props\":{\"headerType\":\"2\"},\"v\":\"1.1\",\"nodes\":[\"636-m4\",\"462-m4\",\"34-m4\"]},{\"id\":133,\"type\":\"hop-text\",\"nodeId\":\"1735-m12\",\"v\":\"1.1\",\"nodes\":[\"636-m5\",\"462-m5\",\"34-m5\"]},{\"id\":134,\"type\":\"hop-home-button-group\",\"nodeId\":\"22-m8\",\"v\":\"1.1\",\"nodes\":[\"636-m6\",\"462-m6\",\"34-m6\"]},{\"id\":135,\"type\":\"hop-home-button\",\"nodeId\":\"22-m9\",\"style\":{\"background\":{\"color\":\"rgba(3, 169, 244, 0)\"},\"states\":{\"hover\":{\"background\":{\"color\":\"rgba(2, 110, 159, 0)\"},\"border\":{\"top\":{\"color\":\"${theme.colors.0|variant3}\"},\"right\":{\"color\":\"${theme.colors.0|variant3}\"},\"bottom\":{\"color\":\"${theme.colors.0|variant3}\"},\"left\":{\"color\":\"${theme.colors.0|variant3}\"}}}},\"typography\":{\"color\":\"${theme.colors.0}\",\"transform\":\"none\",\"size\":{\"unit\":\"px\",\"value\":\"16\"},\"weight\":\"400\",\"lineHeight\":{\"value\":\"1.5\"},\"family\":\"Open Sans\",\"margin\":{\"bottom\":\"2rem\"},\"letterSpacing\":{\"value\":\"1\",\"unit\":\"px\"}},\"border\":{\"top\":{\"style\":\"none\",\"color\":\"${theme.colors.0}\",\"width\":{\"value\":\"2\",\"unit\":\"px\"},\"radius\":{\"right\":{\"value\":5,\"unit\":\"px\"},\"left\":{\"value\":5,\"unit\":\"px\"}}},\"left\":{\"style\":\"none\",\"color\":\"${theme.colors.0}\",\"width\":{\"value\":\"2\",\"unit\":\"px\"}},\"right\":{\"style\":\"none\",\"color\":\"${theme.colors.0}\",\"width\":{\"value\":\"2\",\"unit\":\"px\"}},\"bottom\":{\"style\":\"none\",\"color\":\"${theme.colors.0}\",\"width\":{\"value\":\"2\",\"unit\":\"px\"},\"radius\":{\"right\":{\"value\":5,\"unit\":\"px\"},\"left\":{\"value\":5,\"unit\":\"px\"}}}},\"padding\":{\"top\":{\"value\":\"0\",\"unit\":\"px\"},\"right\":{\"value\":\"0\",\"unit\":\"px\"},\"bottom\":{\"value\":\"0\",\"unit\":\"px\"},\"left\":{\"value\":\"0\",\"unit\":\"px\"}},\"descendants\":{\"icon\":{\"size\":{\"value\":\"16\",\"unit\":\"px\"},\"margin\":{\"right\":{\"value\":0,\"unit\":\"px\"},\"left\":{\"value\":\"10\",\"unit\":\"px\"}}}},\"textAlign\":\"center\"},\"props\":{\"showIcon\":true,\"iconPosition\":\"after\"},\"v\":\"1.1\",\"nodes\":[\"636-m7\",\"462-m7\",\"34-m7\"]},{\"id\":136,\"type\":\"hop-main\",\"nodeId\":\"38-m1\",\"v\":\"1.1\",\"nodes\":[\"639-m1\",\"465-m1\",\"1852-m1\",\"37-m1\"],\"style\":{\"margin\":{\"top\":{\"value\":\"-120\",\"unit\":\"px\"},\"right\":{\"value\":\"\",\"unit\":\"px\"},\"bottom\":{\"value\":\"\",\"unit\":\"px\"},\"left\":{\"value\":\"\",\"unit\":\"px\"}},\"media\":{\"tablet\":{\"margin\":{\"top\":{\"value\":\"-95\",\"unit\":\"px\"},\"right\":{\"value\":\"\",\"unit\":\"px\"},\"bottom\":{\"value\":\"\",\"unit\":\"px\"},\"left\":{\"value\":\"\",\"unit\":\"px\"}}}}}},{\"id\":137,\"type\":\"hop-archive-loop\",\"nodeId\":\"1738-m4\",\"props\":{\"layout\":{\"horizontalGap\":2,\"verticalGap\":3,\"horizontalInnerGap\":0,\"verticalInnerGap\":0,\"itemsPerRow\":2,\"horizontalAlign\":\"start\",\"custom\":{\"horizontalGap\":{\"unit\":\"px\",\"value\":\"\"},\"verticalGap\":{\"unit\":\"px\",\"value\":\"\"}}},\"showMasonry\":true,\"media\":{\"mobile\":{\"layout\":{\"custom\":{\"horizontalGap\":{\"unit\":\"px\",\"value\":\"\"}},\"horizontalGap\":3,\"verticalGap\":3}},\"tablet\":{\"layout\":{\"verticalGap\":2,\"itemsPerRow\":1}}}},\"v\":\"1.1\",\"nodes\":[\"639-m2\",\"465-m2\",\"1852-m2\",\"37-m2\"],\"style\":{\"padding\":{\"top\":{\"value\":\"0\",\"unit\":\"px\"},\"right\":{\"value\":\"\",\"unit\":\"px\"},\"bottom\":{\"value\":\"0\",\"unit\":\"px\"},\"left\":{\"value\":\"\",\"unit\":\"px\"}}}},{\"id\":138,\"type\":\"hop-loop-item\",\"nodeId\":\"1706-c10\",\"style\":{\"background\":{\"color\":\"${theme.colors.4}\",\"type\":\"gradient\",\"image\":[{\"source\":{\"type\":\"gradient\",\"gradient\":{\"steps\":[{\"color\":\"${theme.colors.4}\"},{\"color\":\"rgb(239, 239, 239)\"}],\"angle\":162}}}]},\"boxShadow\":{\"enabled\":true,\"layers\":[{\"y\":\"20\",\"spread\":\"2\",\"blur\":\"60\",\"color\":\"rgba(0, 0, 0, 0.15)\",\"x\":\"20\"}]},\"border\":{\"top\":{\"radius\":{\"left\":{\"value\":\"40\",\"unit\":\"px\"},\"right\":{\"value\":\"40\",\"unit\":\"px\"}},\"style\":\"none\",\"width\":{\"value\":\"0\",\"unit\":\"px\"},\"color\":\"rgb(246, 246, 246)\"},\"bottom\":{\"radius\":{\"left\":{\"value\":\"40\",\"unit\":\"px\"},\"right\":{\"value\":\"40\",\"unit\":\"px\"}},\"style\":\"none\",\"width\":{\"value\":\"5\",\"unit\":\"px\"},\"color\":\"rgb(246, 246, 246)\"},\"right\":{\"style\":\"none\",\"width\":{\"value\":\"0\",\"unit\":\"px\"},\"color\":\"rgb(246, 246, 246)\"},\"left\":{\"style\":\"none\",\"width\":{\"value\":\"0\",\"unit\":\"px\"},\"color\":\"rgb(246, 246, 246)\"}},\"descendants\":{\"outer\":{\"padding\":{\"left\":{\"unit\":\"px\",\"value\":\"\"},\"right\":{\"unit\":\"px\",\"value\":\"\"},\"top\":{\"unit\":\"px\",\"value\":\"\"},\"bottom\":{\"unit\":\"px\",\"value\":\"\"}},\"media\":{\"tablet\":{\"padding\":{\"top\":{\"unit\":\"px\",\"value\":\"\"},\"bottom\":{\"unit\":\"px\",\"value\":\"\"}}},\"mobile\":{\"padding\":{\"left\":{\"unit\":\"px\",\"value\":\"\"},\"right\":{\"unit\":\"px\",\"value\":\"\"},\"top\":{\"unit\":\"px\",\"value\":\"\"},\"bottom\":{\"unit\":\"px\",\"value\":\"\"}}}}}},\"media\":{\"tablet\":{\"padding\":{\"left\":{\"unit\":\"px\",\"value\":\"\"},\"right\":{\"unit\":\"px\",\"value\":\"\"},\"top\":{\"unit\":\"px\",\"value\":\"\"},\"bottom\":{\"unit\":\"px\",\"value\":\"\"}},\"border\":{\"top\":{\"radius\":{\"left\":{\"value\":\"20\",\"unit\":\"px\"},\"right\":{\"value\":\"20\",\"unit\":\"px\"}}},\"bottom\":{\"radius\":{\"left\":{\"value\":\"20\",\"unit\":\"px\"},\"right\":{\"value\":\"20\",\"unit\":\"px\"}}}}},\"mobile\":{\"padding\":{\"top\":{\"value\":\"\",\"unit\":\"px\"},\"right\":{\"value\":\"\",\"unit\":\"px\"},\"bottom\":{\"value\":\"15\",\"unit\":\"px\"},\"left\":{\"value\":\"\",\"unit\":\"px\"}},\"border\":{\"top\":{\"radius\":{\"left\":{\"value\":\"20\",\"unit\":\"px\"},\"right\":{\"value\":\"20\",\"unit\":\"px\"}}},\"bottom\":{\"radius\":{\"left\":{\"value\":\"20\",\"unit\":\"px\"},\"right\":{\"value\":\"20\",\"unit\":\"px\"}}}}}},\"padding\":{\"left\":{\"unit\":\"px\",\"value\":\"\"},\"right\":{\"unit\":\"px\",\"value\":\"\"},\"top\":{\"unit\":\"px\",\"value\":\"\"},\"bottom\":{\"unit\":\"px\",\"value\":\"20\"}},\"textAlign\":\"left\"},\"v\":\"1.1\",\"nodes\":[\"639-m3\",\"465-m3\",\"1852-m3\",\"37-m3\"],\"props\":{\"layout\":{\"horizontalInnerGap\":3,\"verticalInnerGap\":3},\"media\":{\"tablet\":{\"layout\":{\"horizontalInnerGap\":3,\"verticalInnerGap\":3}},\"mobile\":{\"layout\":{\"horizontalInnerGap\":3,\"verticalInnerGap\":3}}}}},{\"id\":139,\"type\":\"hop-post-title\",\"nodeId\":\"38-m7\",\"v\":\"1.1\",\"nodes\":[\"639-m7\",\"465-m4\",\"1852-m4\",\"37-m4\"],\"style\":{\"descendants\":{\"title\":{\"states\":{\"hover\":{\"typography\":{\"color\":\"${theme.colors.0|variant3}\"}}}}}}},{\"id\":140,\"type\":\"hop-post-excerpt\",\"nodeId\":\"38-m8\",\"v\":\"1.1\",\"nodes\":[\"639-m9\",\"465-m5\",\"1852-m5\",\"37-m5\"],\"style\":{\"descendants\":{\"excerpt\":{\"typography\":{\"color\":\"${theme.colors.5|variant2}\",\"weight\":\"400\",\"family\":\"Open Sans\",\"size\":{\"unit\":\"px\",\"value\":\"16\"}}}}}},{\"id\":141,\"props\":{\"layout\":{\"equalWidth\":false,\"horizontalGap\":0,\"verticalGap\":0,\"horizontalInnerGap\":0,\"verticalInnerGap\":0}},\"type\":\"hop-row\",\"nodeId\":\"465-m17\",\"nodes\":[\"465-m6\",\"1852-m6\",\"37-m6\"],\"v\":\"1.1\"},{\"id\":142,\"type\":\"hop-column\",\"nodeId\":\"5-c194\",\"nodes\":[\"459-m11\",\"465-m7\",\"5-c176\",\"1852-m7\",\"37-m7\"],\"v\":\"1.1\",\"style\":{\"descendants\":{\"outer\":{\"padding\":{\"left\":{\"unit\":\"px\",\"value\":\"\"},\"right\":{\"unit\":\"px\",\"value\":\"\"},\"top\":{\"unit\":\"px\",\"value\":\"\"},\"bottom\":{\"unit\":\"px\",\"value\":\"\"}}}},\"padding\":{\"left\":{\"unit\":\"px\",\"value\":\"\"},\"right\":{\"unit\":\"px\",\"value\":\"\"},\"top\":{\"unit\":\"px\",\"value\":\"\"},\"bottom\":{\"unit\":\"px\",\"value\":\"\"}},\"textAlign\":\"left\"},\"props\":{\"verticalAlign\":\"center\"}},{\"id\":143,\"type\":\"hop-post-meta\",\"nodeId\":\"5-c229\",\"nodes\":[\"459-m12\",\"465-m8\",\"456-m8\",\"5-c177\",\"1843-m12\",\"1852-m8\",\"1861-c179\",\"1846-m12\",\"37-m8\"],\"v\":\"1.1\",\"style\":{\"descendants\":{\"metaDataLinks\":{\"typography\":{\"color\":\"${theme.colors.5|variant2}\",\"weight\":\"400\",\"family\":\"Open Sans\",\"size\":{\"unit\":\"px\",\"value\":\"14\"}},\"states\":{\"hover\":{\"typography\":{\"color\":\"${theme.colors.5}\"}}}},\"icons\":{\"margin\":{\"right\":{\"value\":\"5\"}},\"display\":\"none\"},\"separators\":{\"typography\":{\"color\":\"${theme.colors.5|variant3}\",\"size\":{\"unit\":\"px\",\"value\":\"14\"},\"lineHeight\":{\"unit\":\"\",\"value\":\"1.6\"}},\"padding\":{\"top\":{\"value\":\"\",\"unit\":\"px\"},\"right\":{\"value\":\"5\",\"unit\":\"px\"},\"bottom\":{\"value\":\"\",\"unit\":\"px\"},\"left\":{\"value\":\"\",\"unit\":\"px\"}}},\"metaDataPrefix\":{\"typography\":{\"size\":{\"unit\":\"px\",\"value\":\"14\"},\"color\":\"${theme.colors.5|variant2}\"}}}}},{\"id\":144,\"type\":\"hop-column\",\"nodeId\":\"5-c195\",\"nodes\":[\"459-m13\",\"465-m9\",\"5-c178\",\"1852-m9\",\"37-m9\"],\"v\":\"1.1\",\"style\":{\"descendants\":{\"outer\":{\"padding\":{\"left\":{\"unit\":\"px\",\"value\":\"\"},\"right\":{\"unit\":\"px\",\"value\":\"\"},\"top\":{\"unit\":\"px\",\"value\":\"\"},\"bottom\":{\"unit\":\"px\",\"value\":\"\"}}}},\"padding\":{\"left\":{\"unit\":\"px\",\"value\":\"\"},\"right\":{\"unit\":\"px\",\"value\":\"\"},\"top\":{\"unit\":\"px\",\"value\":\"\"},\"bottom\":{\"unit\":\"px\",\"value\":\"\"}}},\"props\":{\"verticalAlign\":\"center\"}},{\"id\":145,\"type\":\"hop-post-read-more-group\",\"nodeId\":\"465-m20\",\"nodes\":[\"465-m10\",\"1852-m10\",\"37-m10\"],\"v\":\"1.1\"},{\"id\":146,\"type\":\"hop-post-read-more\",\"style\":{\"descendants\":{\"icon\":{\"margin\":{\"right\":{\"value\":0,\"unit\":\"px\"},\"left\":{\"value\":\"3\",\"unit\":\"px\",\"path\":\"value\"}},\"size\":{\"value\":\"11\",\"unit\":\"px\"}}},\"border\":{\"top\":{\"style\":\"none\",\"width\":{\"value\":\"2\",\"unit\":\"px\"},\"radius\":{\"right\":{\"value\":0,\"unit\":\"px\",\"path\":\"value\"},\"left\":{\"value\":0,\"unit\":\"px\",\"path\":\"value\"}}},\"left\":{\"style\":\"none\",\"width\":{\"value\":\"2\",\"unit\":\"px\"}},\"right\":{\"style\":\"none\",\"width\":{\"value\":\"2\",\"unit\":\"px\"}},\"bottom\":{\"style\":\"none\",\"width\":{\"value\":\"2\",\"unit\":\"px\"},\"radius\":{\"right\":{\"value\":0,\"unit\":\"px\",\"path\":\"value\"},\"left\":{\"value\":0,\"unit\":\"px\",\"path\":\"value\"}}}},\"states\":{\"hover\":{\"boxShadow\":{\"layers\":[{\"y\":\"14\",\"spread\":\"-12\",\"blur\":\"26\",\"color\":\"rgba(0, 0, 0, 0.42)\"}]},\"typography\":{\"color\":\"${theme.colors.0|variant3}\"}}},\"textAlign\":\"center\",\"typography\":{\"color\":\"${theme.colors.6|variant3}\",\"size\":{\"unit\":\"px\",\"value\":\"14\"},\"family\":\"Open Sans\",\"weight\":\"400\"}},\"props\":{\"showIcon\":false,\"iconPosition\":\"after\",\"buttonSize\":\"small\",\"buttonWidth\":\"fitToContent\"},\"v\":\"1.1\",\"nodes\":[\"459-m15\",\"465-m11\",\"5-c180\",\"1852-m11\",\"1861-c182\",\"1846-m15\",\"37-m11\"]},{\"id\":147,\"props\":{\"layout\":{\"equalWidth\":false,\"custom\":{\"horizontalGap\":{\"unit\":\"px\",\"value\":\"\"},\"verticalGap\":{\"unit\":\"px\",\"value\":\"\"},\"horizontalInnerGap\":{\"unit\":\"px\",\"value\":\"\"},\"verticalInnerGap\":{\"unit\":\"px\",\"value\":\"\"}},\"horizontalGap\":0,\"verticalGap\":0,\"horizontalInnerGap\":0,\"verticalInnerGap\":0}},\"type\":\"hop-post-nav-container\",\"nodeId\":\"25-m22\",\"nodes\":[\"639-m12\",\"465-m12\",\"1852-m12\",\"37-m12\"],\"v\":\"1.1\",\"style\":{\"media\":{\"tablet\":{\"margin\":{\"top\":{\"value\":\"30\",\"unit\":\"px\"},\"right\":{\"value\":\"10\",\"unit\":\"px\"},\"bottom\":{\"value\":\"\",\"unit\":\"px\"},\"left\":{\"value\":\"10\",\"unit\":\"px\"}}},\"mobile\":{\"margin\":{\"top\":{\"value\":\"15\",\"unit\":\"px\"},\"right\":{\"value\":\"15\",\"unit\":\"px\"},\"bottom\":{\"value\":\"\",\"unit\":\"px\"},\"left\":{\"value\":\"15\",\"unit\":\"px\"}}}},\"margin\":{\"top\":{\"value\":\"45\",\"unit\":\"px\"},\"right\":{\"value\":\"15\",\"unit\":\"px\"},\"bottom\":{\"value\":\"\",\"unit\":\"px\"},\"left\":{\"value\":\"15\",\"unit\":\"px\"}}}},{\"id\":148,\"type\":\"hop-column\",\"nodeId\":\"465-m13\",\"nodes\":[\"465-m13\",\"1852-m13\",\"37-m13\"],\"v\":\"1.1\",\"style\":{\"textAlign\":\"left\",\"padding\":{\"left\":{\"unit\":\"px\",\"value\":\"\"},\"right\":{\"unit\":\"px\",\"value\":\"\"},\"top\":{\"unit\":\"px\",\"value\":\"\"},\"bottom\":{\"unit\":\"px\",\"value\":\"\"}},\"descendants\":{\"outer\":{\"padding\":{\"left\":{\"unit\":\"px\",\"value\":\"\"},\"right\":{\"unit\":\"px\",\"value\":\"\"},\"top\":{\"unit\":\"px\",\"value\":\"\"},\"bottom\":{\"unit\":\"px\",\"value\":\"\"}},\"media\":{\"mobile\":{\"padding\":{\"left\":{\"unit\":\"px\",\"value\":\"\"},\"right\":{\"unit\":\"px\",\"value\":\"\"},\"top\":{\"unit\":\"px\",\"value\":\"\"},\"bottom\":{\"unit\":\"px\",\"value\":\"\"}}}}}},\"media\":{\"mobile\":{\"padding\":{\"left\":{\"unit\":\"px\",\"value\":\"\"},\"right\":{\"unit\":\"px\",\"value\":\"\"},\"top\":{\"unit\":\"px\",\"value\":\"\"},\"bottom\":{\"unit\":\"px\",\"value\":\"\"}}}}},\"props\":{\"layout\":{\"horizontalInnerGap\":0,\"verticalInnerGap\":0},\"verticalAlign\":\"center\"}},{\"id\":149,\"type\":\"hop-archive-nav-button\",\"nodeId\":\"465-m14\",\"v\":\"1.1\",\"nodes\":[\"465-m14\",\"1852-m14\",\"37-m14\"],\"style\":{\"descendants\":{\"paginationNavigationButton\":{\"typography\":{\"decoration\":\"none\",\"lineHeight\":{\"unit\":\"\",\"value\":\"1.6\"},\"weight\":\"400\",\"family\":\"Open Sans\",\"size\":{\"unit\":\"px\",\"value\":\"16\"},\"transform\":\"\",\"color\":\"${theme.colors.5}\"},\"border\":{\"top\":{\"radius\":{\"left\":{\"value\":0,\"unit\":\"px\"},\"right\":{\"value\":0,\"unit\":\"px\"}}},\"bottom\":{\"radius\":{\"left\":{\"value\":0,\"unit\":\"px\"},\"right\":{\"value\":0,\"unit\":\"px\"}}}},\"padding\":{\"top\":{\"value\":\"16\",\"unit\":\"px\"},\"right\":{\"value\":\"10\",\"unit\":\"px\"},\"bottom\":{\"value\":\"16\",\"unit\":\"px\"},\"left\":{\"value\":\"0\",\"unit\":\"px\"}},\"states\":{\"hover\":{\"border\":{\"bottom\":{\"color\":\"${theme.colors.4}\"},\"top\":{\"color\":\"${theme.colors.4}\"},\"left\":{\"color\":\"${theme.colors.4}\"},\"right\":{\"color\":\"${theme.colors.4}\"}},\"typography\":{\"color\":\"${theme.colors.0|variant3}\"}}}}}}},{\"id\":150,\"type\":\"hop-column\",\"nodeId\":\"465-m12\",\"nodes\":[\"465-m15\",\"1852-m15\",\"37-m15\"],\"v\":\"1.1\",\"style\":{\"padding\":{\"left\":{\"unit\":\"px\",\"value\":\"\"},\"right\":{\"unit\":\"px\",\"value\":\"\"},\"top\":{\"unit\":\"px\",\"value\":\"\"},\"bottom\":{\"unit\":\"px\",\"value\":\"\"}},\"descendants\":{\"outer\":{\"padding\":{\"left\":{\"unit\":\"px\",\"value\":\"\"},\"right\":{\"unit\":\"px\",\"value\":\"\"},\"top\":{\"unit\":\"px\",\"value\":\"\"},\"bottom\":{\"unit\":\"px\",\"value\":\"\"}}}}},\"props\":{\"layout\":{\"horizontalInnerGap\":0,\"verticalInnerGap\":2},\"verticalAlign\":\"center\"}},{\"id\":151,\"type\":\"hop-archive-pagination\",\"nodeId\":\"26-m14\",\"style\":{\"descendants\":{\"paginationNumbers\":{\"typography\":{\"color\":\"${theme.colors.5}\",\"lineHeight\":{\"unit\":\"\",\"value\":\"1.6\"},\"size\":{\"unit\":\"px\",\"value\":\"16\"}},\"states\":{\"hover\":{\"typography\":{\"color\":\"${theme.colors.0|variant3}\"}}}},\"paginationActiveNumber\":{\"states\":{\"hover\":{\"typography\":{\"color\":\"${theme.colors.0|variant3}\"}}},\"typography\":{\"color\":\"${theme.colors.0|variant3}\",\"lineHeight\":{\"unit\":\"\",\"value\":\"1.6\"},\"size\":{\"unit\":\"px\",\"value\":\"16\"}}}}},\"v\":\"1.1\",\"nodes\":[\"639-m17\",\"465-m16\",\"1852-m16\",\"37-m16\"]},{\"id\":152,\"type\":\"hop-column\",\"nodeId\":\"465-m14\",\"nodes\":[\"465-m17\",\"1852-m17\",\"37-m17\"],\"v\":\"1.1\",\"props\":{\"layout\":{\"horizontalInnerGap\":0,\"verticalInnerGap\":0},\"verticalAlign\":\"center\"},\"style\":{\"padding\":{\"top\":{\"unit\":\"px\",\"value\":\"\"},\"bottom\":{\"unit\":\"px\",\"value\":\"\"},\"left\":{\"unit\":\"px\",\"value\":\"\"},\"right\":{\"unit\":\"px\",\"value\":\"\"}},\"descendants\":{\"outer\":{\"padding\":{\"left\":{\"unit\":\"px\",\"value\":\"\"},\"right\":{\"unit\":\"px\",\"value\":\"\"},\"top\":{\"unit\":\"px\",\"value\":\"\"},\"bottom\":{\"unit\":\"px\",\"value\":\"\"}}}}}},{\"id\":153,\"type\":\"hop-archive-nav-button\",\"nodeId\":\"465-m18\",\"v\":\"1.1\",\"nodes\":[\"465-m18\",\"1852-m18\",\"37-m18\"],\"style\":{\"descendants\":{\"paginationNavigationButton\":{\"typography\":{\"decoration\":\"none\",\"lineHeight\":{\"unit\":\"\",\"value\":\"1.6\"},\"weight\":\"400\",\"family\":\"Open Sans\",\"size\":{\"unit\":\"px\",\"value\":\"16\"},\"transform\":\"\",\"color\":\"${theme.colors.5}\"},\"border\":{\"top\":{\"radius\":{\"left\":{\"value\":0,\"unit\":\"px\"},\"right\":{\"value\":0,\"unit\":\"px\"}}},\"bottom\":{\"radius\":{\"left\":{\"value\":0,\"unit\":\"px\"},\"right\":{\"value\":0,\"unit\":\"px\"}}}},\"padding\":{\"top\":{\"value\":\"16\",\"unit\":\"px\"},\"right\":{\"value\":\"0\",\"unit\":\"px\"},\"bottom\":{\"value\":\"16\",\"unit\":\"px\"},\"left\":{\"value\":\"10\",\"unit\":\"px\"}},\"states\":{\"hover\":{\"border\":{\"bottom\":{\"color\":\"${theme.colors.4}\"},\"top\":{\"color\":\"${theme.colors.4}\"},\"left\":{\"color\":\"${theme.colors.4}\"},\"right\":{\"color\":\"${theme.colors.4}\"}},\"typography\":{\"color\":\"${theme.colors.0|variant3}\"}}}}}}},{\"id\":154,\"type\":\"hop-row\",\"nodeId\":\"38-m2\",\"props\":{\"layout\":{\"itemsPerRow\":1,\"horizontalGap\":0,\"verticalGap\":0,\"horizontalInnerGap\":1,\"verticalInnerGap\":0,\"custom\":{\"horizontalGap\":{\"unit\":\"px\"},\"verticalGap\":{\"unit\":\"px\"},\"horizontalInnerGap\":{\"unit\":\"px\",\"value\":\"\"},\"verticalInnerGap\":{\"unit\":\"px\",\"value\":\"\"}}}},\"v\":\"1.1\",\"nodes\":[\"639-m20\",\"465-m19\",\"1852-m19\",\"37-m19\"]},{\"id\":155,\"type\":\"hop-column\",\"nodeId\":\"38-m3\",\"style\":{\"padding\":{\"left\":{\"unit\":\"px\",\"value\":\"\"},\"right\":{\"unit\":\"px\",\"value\":\"\"},\"top\":{\"unit\":\"px\",\"value\":\"\"},\"bottom\":{\"unit\":\"px\",\"value\":\"\"}}},\"v\":\"1.1\",\"nodes\":[\"639-m21\",\"465-m20\",\"1852-m20\",\"37-m20\"],\"props\":{\"layout\":{\"horizontalInnerGap\":0,\"verticalInnerGap\":0}}},{\"id\":156,\"type\":\"hop-archive-navigation\",\"nodeId\":\"38-m9\",\"v\":\"1.1\",\"nodes\":[\"639-m22\",\"465-m21\",\"1852-m21\",\"37-m21\"]},{\"id\":157,\"type\":\"hop-sidebar\",\"nodeId\":\"4455-s1\",\"props\":{\"attrs\":{\"overflowOption\":\"visible\"}},\"v\":\"1.1\",\"nodes\":[\"438-s1\",\"468-s1\",\"1855-s1\",\"40-s1\"]},{\"id\":158,\"type\":\"hop-section\",\"nodeId\":\"28-s9\",\"nodes\":[\"438-s2\",\"468-s2\",\"1855-s2\",\"40-s2\"],\"style\":{\"media\":{\"mobile\":{\"padding\":{\"top\":{\"value\":\"0\"}}}},\"padding\":{\"top\":{\"value\":\"\",\"unit\":\"px\"},\"right\":{\"value\":\"\",\"unit\":\"px\"},\"bottom\":{\"value\":\"0\",\"unit\":\"px\"},\"left\":{\"value\":\"\",\"unit\":\"px\"}}},\"v\":\"1.1\"},{\"id\":159,\"props\":{\"layout\":{\"equalWidth\":false}},\"type\":\"hop-row\",\"nodeId\":\"28-s13\",\"nodes\":[\"438-s13\",\"468-s13\",\"1855-s13\",\"40-s13\"],\"v\":\"1.1\"},{\"id\":160,\"type\":\"hop-column\",\"nodeId\":\"28-s14\",\"nodes\":[\"438-s14\",\"468-s14\",\"1855-s14\",\"40-s14\"],\"v\":\"1.1\"},{\"id\":161,\"props\":{\"headerType\":\"2\"},\"type\":\"hop-heading\",\"nodeId\":\"28-s15\",\"nodes\":[\"438-s15\",\"468-s15\",\"1855-s15\",\"40-s15\"],\"v\":\"1.1\"},{\"id\":162,\"type\":\"hop-text\",\"nodeId\":\"28-s16\",\"nodes\":[\"438-s16\",\"468-s16\",\"1855-s16\",\"40-s16\"],\"v\":\"1.1\"},{\"id\":163,\"props\":{\"layout\":{\"equalWidth\":false,\"custom\":{\"horizontalGap\":{\"unit\":\"px\",\"value\":\"\"},\"verticalGap\":{\"unit\":\"px\",\"value\":\"\"},\"horizontalInnerGap\":{\"unit\":\"px\",\"value\":\"\"},\"verticalInnerGap\":{\"unit\":\"px\",\"value\":\"\"}},\"horizontalGap\":0,\"verticalGap\":0,\"horizontalInnerGap\":0,\"verticalInnerGap\":0,\"itemsPerRow\":1},\"media\":{\"mobile\":{\"layout\":{\"custom\":{\"horizontalGap\":{\"unit\":\"px\",\"value\":\"\"},\"verticalGap\":{\"unit\":\"px\",\"value\":\"\"}},\"horizontalGap\":3,\"verticalGap\":3}}}},\"type\":\"hop-row\",\"nodeId\":\"28-s10\",\"nodes\":[\"438-s3\",\"468-s3\",\"1855-s3\",\"40-s3\"],\"v\":\"1.1\"},{\"id\":164,\"type\":\"hop-column\",\"nodeId\":\"28-s12\",\"nodes\":[\"438-s4\",\"468-s4\",\"1855-s4\",\"40-s4\"],\"style\":{\"padding\":{\"left\":{\"unit\":\"px\",\"value\":\"\"},\"right\":{\"unit\":\"px\",\"value\":\"\"},\"top\":{\"unit\":\"px\",\"value\":\"\"},\"bottom\":{\"unit\":\"px\",\"value\":\"\"}},\"descendants\":{\"outer\":{\"media\":{\"mobile\":{\"padding\":{\"left\":{\"unit\":\"px\",\"value\":\"\"},\"right\":{\"unit\":\"px\",\"value\":\"\"},\"top\":{\"unit\":\"px\",\"value\":\"\"},\"bottom\":{\"unit\":\"px\",\"value\":\"\"}}}}}}},\"v\":\"1.1\",\"props\":{\"layout\":{\"horizontalInnerGap\":0,\"verticalInnerGap\":0}}},{\"id\":165,\"type\":\"hop-widget-area\",\"nodeId\":\"1719-s2\",\"style\":{\"descendants\":{\"widgetBox\":{\"border\":{\"top\":{\"style\":\"solid\",\"width\":{\"value\":\"0\",\"unit\":\"px\"},\"radius\":{\"left\":{\"value\":\"\",\"unit\":\"px\"},\"right\":{\"value\":\"\",\"unit\":\"px\"}},\"color\":\"rgb(230, 230, 230)\"},\"right\":{\"style\":\"solid\",\"width\":{\"value\":\"0\",\"unit\":\"px\"},\"color\":\"rgb(230, 230, 230)\"},\"bottom\":{\"style\":\"solid\",\"width\":{\"value\":\"1\",\"unit\":\"px\"},\"radius\":{\"left\":{\"value\":\"\",\"unit\":\"px\"},\"right\":{\"value\":\"\",\"unit\":\"px\"}},\"color\":\"rgb(230, 230, 230)\"},\"left\":{\"style\":\"solid\",\"width\":{\"value\":\"0\",\"unit\":\"px\"},\"color\":\"rgb(230, 230, 230)\"}},\"margin\":{\"top\":{\"value\":\"\",\"unit\":\"px\"},\"right\":{\"value\":\"\",\"unit\":\"px\"},\"bottom\":{\"value\":\"8\",\"unit\":\"px\"},\"left\":{\"value\":\"\",\"unit\":\"px\"}}},\"widgetListItemLink\":{\"typography\":{\"color\":\"${theme.colors.5|variant2}\",\"decoration\":\"none\",\"weight\":\"400\",\"size\":{\"unit\":\"px\",\"value\":\"14\"},\"family\":\"Open Sans\"},\"states\":{\"hover\":{\"typography\":{\"color\":\"${theme.colors.5}\"}}}},\"widgetListItem\":{\"padding\":{\"top\":{\"value\":\"4\",\"unit\":\"px\"},\"right\":{\"value\":\"\",\"unit\":\"px\"},\"bottom\":{\"value\":\"4\",\"unit\":\"px\"},\"left\":{\"value\":\"\",\"unit\":\"px\"}},\"states\":{\"hover\":{\"typography\":{\"color\":\"${theme.colors.5|variant2}\"}}},\"typography\":{\"family\":\"Open Sans\",\"weight\":\"300\",\"color\":\"black\"}},\"widgetTitle\":{\"margin\":{\"top\":{\"value\":\"8\",\"unit\":\"px\"},\"right\":{\"value\":\"\",\"unit\":\"px\"},\"bottom\":{\"value\":\"0\",\"unit\":\"px\"},\"left\":{\"value\":\"\",\"unit\":\"px\"}},\"padding\":{\"top\":{\"value\":\"\",\"unit\":\"px\"},\"right\":{\"value\":\"\",\"unit\":\"px\"},\"bottom\":{\"value\":\"\",\"unit\":\"px\"},\"left\":{\"value\":\"10\",\"unit\":\"px\"}},\"typography\":{\"color\":\"${theme.colors.0}\",\"size\":{\"unit\":\"px\",\"value\":\"16\"},\"weight\":\"600\",\"family\":\"Open Sans\",\"lineHeight\":{\"unit\":\"\",\"value\":\"1.6\"}}},\"widgetList\":{\"listStyleType\":\"none\",\"border\":{\"top\":{\"style\":\"solid\",\"width\":{\"value\":\"1\",\"unit\":\"px\"},\"color\":\"${theme.colors.4}\"},\"right\":{\"style\":\"solid\",\"width\":{\"value\":\"0\",\"unit\":\"px\"},\"color\":\"${theme.colors.4}\"},\"bottom\":{\"style\":\"solid\",\"width\":{\"value\":\"0\",\"unit\":\"px\"},\"color\":\"${theme.colors.4}\"},\"left\":{\"style\":\"solid\",\"width\":{\"value\":\"0\",\"unit\":\"px\"},\"color\":\"${theme.colors.4}\"}},\"padding\":{\"top\":{\"value\":\"10\",\"unit\":\"px\"},\"right\":{\"value\":\"10\",\"unit\":\"px\"},\"bottom\":{\"value\":\"10\",\"unit\":\"px\"},\"left\":{\"value\":\"10\",\"unit\":\"px\"}},\"typography\":{\"color\":\"${theme.colors.5|variant2}\"}},\"widgetInput\":{\"typography\":{\"color\":\"${theme.colors.5|variant2}\",\"weight\":\"400\",\"family\":\"Open Sans\",\"size\":{\"unit\":\"px\",\"value\":\"16\"}},\"states\":{\"focus\":{\"typography\":{\"color\":\"${theme.colors.5|variant2}\"}}},\"border\":{\"top\":{\"width\":{\"value\":\"0\",\"unit\":\"px\"},\"style\":\"none\"},\"bottom\":{\"width\":{\"value\":\"0\",\"unit\":\"px\"},\"style\":\"none\"},\"right\":{\"width\":{\"value\":\"0\",\"unit\":\"px\"},\"style\":\"none\"},\"left\":{\"width\":{\"value\":\"0\",\"unit\":\"px\"},\"style\":\"none\"}},\"background\":{\"color\":\"\"}},\"widgetContentContainer\":{\"border\":{\"top\":{\"style\":\"none\",\"width\":{\"value\":\"1\",\"unit\":\"px\"},\"color\":\"\"},\"right\":{\"style\":\"none\",\"width\":{\"value\":\"0\",\"unit\":\"px\"},\"color\":\"\"},\"bottom\":{\"style\":\"none\",\"width\":{\"value\":\"0\",\"unit\":\"px\"},\"color\":\"\"},\"left\":{\"style\":\"none\",\"width\":{\"value\":\"0\",\"unit\":\"px\"},\"color\":\"\"}}}},\"border\":{\"top\":{\"style\":\"none\",\"width\":{\"value\":\"0\",\"unit\":\"px\"},\"radius\":{\"left\":{\"value\":\"\",\"unit\":\"px\"},\"right\":{\"value\":\"\",\"unit\":\"px\"}}},\"right\":{\"style\":\"none\",\"width\":{\"value\":\"0\",\"unit\":\"px\"}},\"bottom\":{\"style\":\"none\",\"width\":{\"value\":\"0\",\"unit\":\"px\"},\"radius\":{\"left\":{\"value\":\"\",\"unit\":\"px\"},\"right\":{\"value\":\"\",\"unit\":\"px\"}}},\"left\":{\"style\":\"none\",\"width\":{\"value\":\"0\",\"unit\":\"px\"}}},\"margin\":{\"top\":{\"value\":\"4\",\"unit\":\"px\"},\"right\":{\"value\":\"\",\"unit\":\"px\"},\"bottom\":{\"value\":\"\",\"unit\":\"px\"},\"left\":{\"value\":\"\",\"unit\":\"px\"}},\"background\":{\"type\":\"none\",\"image\":[{\"source\":{\"type\":\"gradient\",\"gradient\":{\"steps\":[{\"color\":\"${theme.colors.4}\"},{\"color\":\"rgb(230, 230, 230)\"}],\"angle\":\"145\"}}}]}},\"v\":\"1.1\",\"nodes\":[\"438-s5\",\"468-s5\",\"1855-s5\",\"40-s5\"]},{\"id\":166,\"type\":\"hop-search-widget\",\"nodeId\":\"1719-s3\",\"style\":{\"descendants\":{\"widget-box\":{\"padding\":{\"top\":{\"value\":\"0\",\"unit\":\"px\"},\"right\":{\"value\":\"0\",\"unit\":\"px\"},\"bottom\":{\"value\":\"0\",\"unit\":\"px\"},\"left\":{\"value\":\"0\",\"unit\":\"px\"}},\"media\":{\"tablet\":{\"margin\":{\"top\":{\"value\":\"\",\"unit\":\"px\"},\"right\":{\"value\":\"\",\"unit\":\"px\"},\"bottom\":{\"value\":\"15\",\"unit\":\"px\"},\"left\":{\"value\":\"\",\"unit\":\"px\"}}},\"mobile\":{\"margin\":{\"top\":{\"value\":\"\",\"unit\":\"px\"},\"right\":{\"value\":\"\",\"unit\":\"px\"},\"bottom\":{\"value\":\"15\",\"unit\":\"px\"},\"left\":{\"value\":\"\",\"unit\":\"px\"}}}},\"background\":{\"color\":\"\"},\"border\":{\"top\":{\"radius\":{\"left\":{\"value\":\"\",\"unit\":\"px\"},\"right\":{\"value\":\"\",\"unit\":\"px\"}},\"style\":\"none\",\"width\":{\"value\":\"0\",\"unit\":\"px\"}},\"bottom\":{\"radius\":{\"left\":{\"value\":\"\",\"unit\":\"px\"},\"right\":{\"value\":\"\",\"unit\":\"px\"}},\"style\":\"none\",\"width\":{\"value\":\"0\",\"unit\":\"px\"}},\"right\":{\"style\":\"none\",\"width\":{\"value\":\"0\",\"unit\":\"px\"}},\"left\":{\"style\":\"none\",\"width\":{\"value\":\"0\",\"unit\":\"px\"}}},\"transition\":{\"duration\":{\"value\":\"0.5\"}}},\"widget-title\":{\"border\":{\"top\":{\"radius\":{\"left\":{\"unit\":\"px\",\"value\":\"\"},\"right\":{\"unit\":\"px\",\"value\":\"\"}},\"width\":{\"value\":\"0\",\"unit\":\"px\"}},\"bottom\":{\"radius\":{\"left\":{\"unit\":\"px\",\"value\":\"\"},\"right\":{\"unit\":\"px\",\"value\":\"\"}},\"width\":{\"value\":\"0\",\"unit\":\"px\"}},\"right\":{\"width\":{\"value\":\"0\",\"unit\":\"px\"}},\"left\":{\"width\":{\"value\":\"0\",\"unit\":\"px\"}}},\"typography\":{\"color\":\"${theme.colors.5}\"}},\"widget-input\":{\"border\":{\"top\":{\"width\":{\"value\":\"0\",\"unit\":\"px\"},\"radius\":{\"left\":{\"value\":\"\",\"unit\":\"px\"},\"right\":{\"value\":\"\",\"unit\":\"px\"}},\"style\":\"none\"},\"bottom\":{\"width\":{\"value\":\"0\",\"unit\":\"px\"},\"radius\":{\"left\":{\"value\":\"\",\"unit\":\"px\"},\"right\":{\"value\":\"\",\"unit\":\"px\"}},\"style\":\"none\"},\"right\":{\"width\":{\"value\":\"0\",\"unit\":\"px\"},\"style\":\"none\"},\"left\":{\"width\":{\"value\":\"0\",\"unit\":\"px\"},\"style\":\"none\"}},\"padding\":{\"top\":{\"value\":\"10\",\"unit\":\"px\"},\"right\":{\"value\":\"12\",\"unit\":\"px\"},\"bottom\":{\"value\":\"10\",\"unit\":\"px\"},\"left\":{\"value\":\"12\",\"unit\":\"px\"}},\"background\":{\"color\":\"rgba(230, 230, 230, 0.5)\"},\"typography\":{\"color\":\"${theme.colors.4|variant4}\"},\"transition\":{\"duration\":{\"value\":\"0.5\"}}},\"widget-button\":{\"border\":{\"top\":{\"radius\":{\"left\":{\"value\":\"\",\"unit\":\"px\"},\"right\":{\"value\":\"\",\"unit\":\"px\"}},\"style\":\"none\",\"width\":{\"value\":\"0\",\"unit\":\"px\"}},\"bottom\":{\"radius\":{\"left\":{\"value\":\"\",\"unit\":\"px\"},\"right\":{\"value\":\"\",\"unit\":\"px\"}},\"style\":\"none\",\"width\":{\"value\":\"0\",\"unit\":\"px\"}},\"right\":{\"style\":\"none\",\"width\":{\"value\":\"0\",\"unit\":\"px\"}},\"left\":{\"style\":\"none\",\"width\":{\"value\":\"0\",\"unit\":\"px\"}}},\"states\":{\"hover\":{\"typography\":{\"color\":\"${theme.colors.0}\"}}},\"transition\":{\"duration\":{\"value\":\"0.5\"}},\"typography\":{\"color\":\"${theme.colors.0|variant3}\"},\"display\":\"inline-block\",\"background\":{\"color\":\"rgba(230, 230, 230, 0.5)\"}},\"widget-button-icon\":{\"display\":\"inline-block\"},\"widget-button-text\":{\"display\":\"none\"},\"widget-input-placeholder\":{\"color\":\"${theme.colors.5|variant3}\"}}},\"v\":\"1.1\",\"nodes\":[\"438-s6\",\"468-s6\",\"1855-s6\",\"40-s6\"],\"props\":{\"attrs\":{\"overflowOption\":\"visible\"}}},{\"id\":167,\"type\":\"hop-recent-post-widget\",\"nodeId\":\"1719-s4\",\"v\":\"1.1\",\"nodes\":[\"438-s7\",\"468-s7\",\"1855-s7\",\"40-s7\"]},{\"id\":168,\"type\":\"hop-recent-comments-widget\",\"nodeId\":\"1719-s5\",\"v\":\"1.1\",\"nodes\":[\"438-s8\",\"468-s8\",\"1855-s8\",\"40-s8\"]},{\"id\":169,\"type\":\"hop-archives-widget\",\"nodeId\":\"1719-s6\",\"v\":\"1.1\",\"props\":{\"frame\":{\"type\":\"border\"},\"enabledFrameOption\":false,\"showFrameOverImage\":false,\"showFrameShadow\":false},\"nodes\":[\"438-s9\",\"468-s9\",\"1855-s9\",\"40-s9\"]},{\"id\":170,\"type\":\"hop-categories-widget\",\"nodeId\":\"1719-s7\",\"v\":\"1.1\",\"nodes\":[\"438-s10\",\"468-s10\",\"1855-s10\",\"40-s10\"]},{\"id\":171,\"type\":\"hop-meta-widget\",\"nodeId\":\"1719-s8\",\"v\":\"1.1\",\"nodes\":[\"438-s11\",\"468-s11\",\"1855-s11\",\"40-s11\"]},{\"id\":172,\"type\":\"hop-text-widget\",\"nodeId\":\"28-s16\",\"nodes\":[\"438-s12\",\"468-s12\",\"1855-s12\",\"40-s12\"],\"v\":\"1.1\"},{\"id\":173,\"type\":\"hop-sidebar\",\"nodeId\":\"4455-s1\",\"props\":{\"attrs\":{\"overflowOption\":\"visible\"}},\"v\":\"1.1\",\"nodes\":[\"438-s1\",\"43-s1\"]},{\"id\":174,\"type\":\"hop-section\",\"nodeId\":\"28-s9\",\"nodes\":[\"438-s2\",\"43-s2\"],\"style\":{\"padding\":{\"top\":{\"value\":\"0\"},\"bottom\":{\"value\":\"0\"}},\"media\":{\"mobile\":{\"padding\":{\"top\":{\"value\":\"0\"}}}}},\"v\":\"1.1\"},{\"id\":175,\"props\":{\"layout\":{\"equalWidth\":false}},\"type\":\"hop-row\",\"nodeId\":\"28-s13\",\"nodes\":[\"438-s13\",\"43-s13\"],\"v\":\"1.1\"},{\"id\":176,\"type\":\"hop-column\",\"nodeId\":\"28-s14\",\"nodes\":[\"438-s14\",\"43-s14\"],\"v\":\"1.1\"},{\"id\":177,\"props\":{\"headerType\":\"2\"},\"type\":\"hop-heading\",\"nodeId\":\"28-s15\",\"nodes\":[\"438-s15\",\"43-s15\"],\"v\":\"1.1\"},{\"id\":178,\"type\":\"hop-text\",\"nodeId\":\"28-s16\",\"nodes\":[\"438-s16\",\"43-s16\"],\"v\":\"1.1\"},{\"id\":179,\"props\":{\"layout\":{\"equalWidth\":false,\"custom\":{\"horizontalGap\":{\"unit\":\"px\",\"value\":\"\"},\"verticalGap\":{\"unit\":\"px\",\"value\":\"\"},\"horizontalInnerGap\":{\"unit\":\"px\",\"value\":\"\"},\"verticalInnerGap\":{\"unit\":\"px\",\"value\":\"\"}},\"horizontalGap\":0,\"verticalGap\":0,\"horizontalInnerGap\":0,\"verticalInnerGap\":0,\"itemsPerRow\":1},\"media\":{\"mobile\":{\"layout\":{\"custom\":{\"horizontalGap\":{\"unit\":\"px\",\"value\":\"\"},\"verticalGap\":{\"unit\":\"px\",\"value\":\"\"}},\"horizontalGap\":2,\"verticalGap\":2}}}},\"type\":\"hop-row\",\"nodeId\":\"28-s10\",\"nodes\":[\"438-s3\",\"43-s3\"],\"v\":\"1.1\"},{\"id\":180,\"type\":\"hop-column\",\"nodeId\":\"28-s12\",\"nodes\":[\"438-s4\",\"43-s4\"],\"style\":{\"padding\":{\"left\":{\"unit\":\"px\",\"value\":\"\"},\"right\":{\"unit\":\"px\",\"value\":\"\"},\"top\":{\"unit\":\"px\",\"value\":\"\"},\"bottom\":{\"unit\":\"px\",\"value\":\"\"}}},\"v\":\"1.1\",\"props\":{\"layout\":{\"horizontalInnerGap\":0,\"verticalInnerGap\":0}}},{\"id\":181,\"type\":\"hop-widget-area\",\"nodeId\":\"1719-s2\",\"style\":{\"descendants\":{\"widgetBox\":{\"border\":{\"top\":{\"style\":\"none\",\"width\":{\"value\":\"0\",\"unit\":\"px\"},\"radius\":{\"left\":{\"value\":\"\",\"unit\":\"px\"},\"right\":{\"value\":\"\",\"unit\":\"px\"}}},\"right\":{\"style\":\"none\",\"width\":{\"value\":\"0\",\"unit\":\"px\"}},\"bottom\":{\"style\":\"none\",\"width\":{\"value\":\"0\",\"unit\":\"px\"},\"radius\":{\"left\":{\"value\":\"\",\"unit\":\"px\"},\"right\":{\"value\":\"\",\"unit\":\"px\"}}},\"left\":{\"style\":\"none\",\"width\":{\"value\":\"0\",\"unit\":\"px\"}}},\"margin\":{\"top\":{\"value\":\"\",\"unit\":\"px\"},\"right\":{\"value\":\"\",\"unit\":\"px\"},\"bottom\":{\"value\":\"20\",\"unit\":\"px\"},\"left\":{\"value\":\"\",\"unit\":\"px\"}},\"media\":{\"mobile\":{\"textAlign\":\"center\"}}},\"widgetListItemLink\":{\"typography\":{\"color\":\"${theme.colors.4|variant3}\",\"decoration\":\"none\",\"weight\":\"400\",\"size\":{\"unit\":\"px\",\"value\":\"14\"},\"family\":\"Open Sans\"},\"states\":{\"hover\":{\"typography\":{\"color\":\"rgb(0, 0, 0)\"}}}},\"widgetListItem\":{\"typography\":{\"color\":\"${theme.colors.5|variant2}\",\"decoration\":\"none\",\"weight\":\"400\",\"size\":{\"unit\":\"px\",\"value\":\"14\"},\"family\":\"Open Sans\"},\"padding\":{\"top\":{\"value\":\"4\",\"unit\":\"px\"},\"right\":{\"value\":\"\",\"unit\":\"px\"},\"bottom\":{\"value\":\"4\",\"unit\":\"px\"},\"left\":{\"value\":\"\",\"unit\":\"px\"}},\"states\":{\"hover\":{\"typography\":{\"color\":\"${theme.colors.5|variant2}\"}}}},\"widgetTitle\":{\"typography\":{\"color\":\"${theme.colors.5}\",\"size\":{\"unit\":\"px\",\"value\":\"16\"},\"weight\":\"600\",\"family\":\"Open Sans\",\"lineHeight\":{\"unit\":\"\",\"value\":\"1.6\"}},\"border\":{\"top\":{\"style\":\"none\",\"width\":{\"value\":\"0\",\"unit\":\"px\"}},\"right\":{\"style\":\"none\",\"width\":{\"value\":\"0\",\"unit\":\"px\"}},\"bottom\":{\"style\":\"none\",\"width\":{\"value\":\"0\",\"unit\":\"px\"}},\"left\":{\"style\":\"none\",\"width\":{\"value\":\"0\",\"unit\":\"px\"}}},\"margin\":{\"top\":{\"value\":\"\",\"unit\":\"px\"},\"right\":{\"value\":\"\",\"unit\":\"px\"},\"bottom\":{\"value\":\"10\",\"unit\":\"px\"},\"left\":{\"value\":\"\",\"unit\":\"px\"}}},\"widgetList\":{\"listStyleType\":\"none\"},\"widgetInput\":{\"typography\":{\"color\":\"${theme.colors.5|variant2}\",\"weight\":\"400\",\"family\":\"Open Sans\",\"size\":{\"unit\":\"px\",\"value\":\"16\"}},\"states\":{\"focus\":{\"typography\":{\"color\":\"${theme.colors.5|variant2}\"}}},\"border\":{\"top\":{\"width\":{\"value\":\"0\",\"unit\":\"px\"},\"style\":\"none\"},\"bottom\":{\"width\":{\"value\":\"0\",\"unit\":\"px\"},\"style\":\"none\"},\"right\":{\"width\":{\"value\":\"0\",\"unit\":\"px\"},\"style\":\"none\"},\"left\":{\"width\":{\"value\":\"0\",\"unit\":\"px\"},\"style\":\"none\"}}}},\"border\":{\"top\":{\"style\":\"none\",\"width\":{\"value\":\"0\",\"unit\":\"px\"}},\"right\":{\"style\":\"none\",\"width\":{\"value\":\"0\",\"unit\":\"px\"}},\"bottom\":{\"style\":\"none\",\"width\":{\"value\":\"0\",\"unit\":\"px\"}},\"left\":{\"style\":\"none\",\"width\":{\"value\":\"0\",\"unit\":\"px\"}}}},\"v\":\"1.1\",\"nodes\":[\"438-s5\",\"43-s5\"]},{\"id\":182,\"type\":\"hop-search-widget\",\"nodeId\":\"1719-s3\",\"style\":{\"descendants\":{\"widget-box\":{\"border\":{\"top\":{\"radius\":{\"left\":{\"value\":\"5\",\"unit\":\"px\"},\"right\":{\"value\":\"5\",\"unit\":\"px\"}},\"color\":\"rgb(238, 238, 238)\",\"style\":\"solid\",\"width\":{\"value\":\"1\",\"unit\":\"px\"}},\"bottom\":{\"radius\":{\"left\":{\"value\":\"5\",\"unit\":\"px\"},\"right\":{\"value\":\"5\",\"unit\":\"px\"}},\"color\":\"rgb(238, 238, 238)\",\"style\":\"solid\",\"width\":{\"value\":\"1\",\"unit\":\"px\"}},\"right\":{\"color\":\"rgb(238, 238, 238)\",\"style\":\"solid\",\"width\":{\"value\":\"1\",\"unit\":\"px\"}},\"left\":{\"color\":\"rgb(238, 238, 238)\",\"style\":\"solid\",\"width\":{\"value\":\"1\",\"unit\":\"px\"}}},\"padding\":{\"top\":{\"value\":\"0\",\"unit\":\"px\"},\"right\":{\"value\":\"0\",\"unit\":\"px\"},\"bottom\":{\"value\":\"0\",\"unit\":\"px\"},\"left\":{\"value\":\"0\",\"unit\":\"px\"}},\"margin\":{\"top\":{\"value\":\"\",\"unit\":\"px\"},\"right\":{\"value\":\"\",\"unit\":\"px\"},\"bottom\":{\"value\":\"15\",\"unit\":\"px\"},\"left\":{\"value\":\"\",\"unit\":\"px\"}},\"media\":{\"tablet\":{\"margin\":{\"top\":{\"value\":\"\",\"unit\":\"px\"},\"right\":{\"value\":\"\",\"unit\":\"px\"},\"bottom\":{\"value\":\"15\",\"unit\":\"px\"},\"left\":{\"value\":\"\",\"unit\":\"px\"}}},\"mobile\":{\"margin\":{\"top\":{\"value\":\"\",\"unit\":\"px\"},\"right\":{\"value\":\"\",\"unit\":\"px\"},\"bottom\":{\"value\":\"15\",\"unit\":\"px\"},\"left\":{\"value\":\"\",\"unit\":\"px\"}}}},\"background\":{\"color\":\"\"}},\"widget-title\":{\"border\":{\"top\":{\"radius\":{\"left\":{\"unit\":\"px\",\"value\":\"\"},\"right\":{\"unit\":\"px\",\"value\":\"\"}}},\"bottom\":{\"radius\":{\"left\":{\"unit\":\"px\",\"value\":\"\"},\"right\":{\"unit\":\"px\",\"value\":\"\"}}}},\"typography\":{\"color\":\"${theme.colors.5}\",\"size\":{\"unit\":\"px\",\"value\":\"16\"}}},\"widget-input\":{\"border\":{\"top\":{\"width\":{\"value\":\"0\",\"unit\":\"px\"},\"radius\":{\"left\":{\"value\":\"5\",\"unit\":\"px\"},\"right\":{\"value\":\"0\",\"unit\":\"px\"}},\"style\":\"none\"},\"bottom\":{\"width\":{\"value\":\"0\",\"unit\":\"px\"},\"radius\":{\"left\":{\"value\":\"5\",\"unit\":\"px\"},\"right\":{\"value\":\"0\",\"unit\":\"px\"}},\"style\":\"none\"},\"right\":{\"width\":{\"value\":\"0\",\"unit\":\"px\"},\"style\":\"none\"},\"left\":{\"width\":{\"value\":\"0\",\"unit\":\"px\"},\"style\":\"none\"}},\"padding\":{\"top\":{\"value\":\"10\",\"unit\":\"px\"},\"right\":{\"value\":\"12\",\"unit\":\"px\"},\"bottom\":{\"value\":\"10\",\"unit\":\"px\"},\"left\":{\"value\":\"12\",\"unit\":\"px\"}},\"background\":{\"color\":\"rgb(249, 250, 251)\"},\"typography\":{\"color\":\"${theme.colors.5|variant2}\"}},\"widget-button\":{\"border\":{\"top\":{\"radius\":{\"left\":{\"value\":\"0\",\"unit\":\"px\"},\"right\":{\"value\":\"5\",\"unit\":\"px\"}},\"style\":\"none\",\"width\":{\"value\":\"0\",\"unit\":\"px\"}},\"bottom\":{\"radius\":{\"left\":{\"value\":\"0\",\"unit\":\"px\"},\"right\":{\"value\":\"5\",\"unit\":\"px\"}},\"style\":\"none\",\"width\":{\"value\":\"0\",\"unit\":\"px\"}},\"right\":{\"style\":\"none\",\"width\":{\"value\":\"0\",\"unit\":\"px\"}},\"left\":{\"style\":\"none\",\"width\":{\"value\":\"0\",\"unit\":\"px\"}}},\"states\":{\"hover\":{\"background\":{\"color\":\"rgb(249, 250, 251)\"},\"typography\":{\"color\":\"${theme.colors.0}\"}}},\"transition\":{\"duration\":{\"value\":\"0.5\"}},\"typography\":{\"color\":\"${theme.colors.5}\"},\"display\":\"inline-block\",\"background\":{\"color\":\"rgb(249, 250, 251)\"}},\"widget-button-icon\":{\"display\":\"inline-block\"},\"widget-button-text\":{\"display\":\"none\"},\"widget-input-placeholder\":{\"color\":\"${theme.colors.5|variant2}\"}}},\"v\":\"1.1\",\"nodes\":[\"438-s6\",\"43-s6\"],\"props\":{\"attrs\":{\"overflowOption\":\"visible\"}}},{\"id\":183,\"type\":\"hop-recent-post-widget\",\"nodeId\":\"1719-s4\",\"v\":\"1.1\",\"nodes\":[\"438-s7\",\"43-s7\"]},{\"id\":184,\"type\":\"hop-recent-comments-widget\",\"nodeId\":\"1719-s5\",\"v\":\"1.1\",\"nodes\":[\"438-s8\",\"43-s8\"]},{\"id\":185,\"type\":\"hop-archives-widget\",\"nodeId\":\"1719-s6\",\"v\":\"1.1\",\"props\":{\"frame\":{\"type\":\"border\"},\"enabledFrameOption\":false,\"showFrameOverImage\":false,\"showFrameShadow\":false},\"nodes\":[\"438-s9\",\"43-s9\"]},{\"id\":186,\"type\":\"hop-categories-widget\",\"nodeId\":\"1719-s7\",\"v\":\"1.1\",\"nodes\":[\"438-s10\",\"43-s10\"]},{\"id\":187,\"type\":\"hop-meta-widget\",\"nodeId\":\"1719-s8\",\"v\":\"1.1\",\"nodes\":[\"438-s11\",\"43-s11\"]},{\"id\":188,\"type\":\"hop-text-widget\",\"nodeId\":\"28-s16\",\"nodes\":[\"438-s12\",\"43-s12\"],\"v\":\"1.1\"},{\"id\":189,\"nodeId\":\"22-h28\",\"nodes\":[\"22-h28\"],\"style\":[],\"v\":\"1.1\"},{\"id\":190,\"type\":\"hop-content\",\"nodeId\":\"16-c1\",\"nodes\":[\"16-c1\"],\"v\":\"1.1\"},{\"id\":191,\"type\":\"hop-section\",\"style\":{\"padding\":{\"top\":{\"path\":\"value\",\"value\":\"0\"},\"bottom\":{\"value\":\"0\"}},\"media\":{\"mobile\":{\"margin\":{\"top\":{\"value\":\"0\",\"unit\":\"px\"},\"right\":{\"unit\":\"px\"},\"bottom\":{\"unit\":\"px\"},\"left\":{\"unit\":\"px\"}}}},\"descendants\":{\"inner\":{\"margin\":{\"top\":{\"value\":-50,\"unit\":\"px\",\"path\":\"value\"}}}}},\"v\":\"1.1\",\"nodes\":[\"16-c2\"],\"props\":{\"width\":\"full-width\",\"showHeader\":true}},{\"id\":192,\"props\":{\"layout\":{\"equalWidth\":true,\"itemsPerRow\":4,\"horizontalGap\":0,\"verticalGap\":0,\"equalHeight\":true},\"media\":{\"mobile\":{\"layout\":{\"horizontalGap\":2,\"verticalGap\":2}}}},\"type\":\"hop-row\",\"style\":{\"boxShadow\":{\"enabled\":true,\"layers\":[{\"color\":\"rgba(74, 74, 74, 0.3)\",\"y\":\"4\"}]},\"background\":{\"color\":\"${theme.colors.4}\",\"type\":\"image\",\"image\":[{\"source\":{\"type\":\"image\",\"gradient\":{\"angle\":\"120\",\"steps\":[{\"color\":\"rgba(255, 236, 210, 0.8)\",\"position\":\"0\"},{\"color\":\"rgba(252, 182, 159, 0.8)\",\"position\":\"100\"}]},\"url\":\"http:\\/\\/localhost\\/wordpress\\/wp-content\\/uploads\\/2024\\/11\\/DALL\\u00b7E-2024-11-02-22.47.45-A-realistic-professional-image-depicting-a-key-handover-for-a-home.-Show-a-persons-hand-offering-a-key-with-a-small-house-shaped-keychain-to-another.webp\"},\"size\":\"cover\",\"position\":{\"x\":47.23611068725586,\"y\":78.30555725097656}}]},\"media\":{\"mobile\":{\"margin\":{\"top\":{\"value\":\"15\",\"unit\":\"px\"},\"right\":{\"value\":\"15\",\"unit\":\"px\"},\"bottom\":{\"value\":\"15\",\"unit\":\"px\"},\"left\":{\"value\":\"15\",\"unit\":\"px\"}}}}},\"v\":\"1.1\",\"nodes\":[\"16-c9\"]},{\"id\":193,\"type\":\"hop-column\",\"style\":{\"textAlign\":\"center\",\"media\":{\"mobile\":{\"textAlign\":\"center\",\"padding\":{\"left\":{\"unit\":\"px\"},\"right\":{\"unit\":\"px\"},\"top\":{\"unit\":\"px\"},\"bottom\":{\"unit\":\"px\"}}},\"tablet\":{\"padding\":{\"left\":{\"unit\":\"px\"},\"right\":{\"unit\":\"px\"},\"top\":{\"unit\":\"px\"},\"bottom\":{\"unit\":\"px\"}}}},\"descendants\":{\"outer\":{\"media\":{\"mobile\":{\"padding\":{\"left\":{\"unit\":\"px\"},\"right\":{\"unit\":\"px\"},\"top\":{\"unit\":\"px\"},\"bottom\":{\"unit\":\"px\"}}}},\"padding\":{\"left\":{\"unit\":\"px\",\"value\":0},\"right\":{\"unit\":\"px\",\"value\":0},\"top\":{\"unit\":\"px\",\"value\":0},\"bottom\":{\"unit\":\"px\",\"value\":0}}}},\"padding\":{\"left\":{\"unit\":\"px\",\"value\":0},\"right\":{\"unit\":\"px\",\"value\":0},\"top\":{\"unit\":\"px\",\"value\":0},\"bottom\":{\"unit\":\"px\",\"value\":0}},\"border\":{\"top\":{\"radius\":{\"left\":{\"unit\":\"px\",\"value\":\"22\"},\"right\":{\"unit\":\"px\",\"value\":\"22\"}},\"style\":\"solid\",\"width\":{\"value\":\"3\",\"unit\":\"px\"},\"color\":\"rgba(64, 191, 154, 0.45)\"},\"bottom\":{\"radius\":{\"left\":{\"unit\":\"px\",\"value\":\"22\"},\"right\":{\"unit\":\"px\",\"value\":\"22\"}},\"style\":\"solid\",\"width\":{\"value\":\"3\",\"unit\":\"px\"},\"color\":\"rgba(64, 191, 154, 0.45)\"},\"right\":{\"style\":\"solid\",\"width\":{\"value\":\"3\",\"unit\":\"px\"},\"color\":\"rgba(64, 191, 154, 0.45)\"},\"left\":{\"style\":\"solid\",\"width\":{\"value\":\"3\",\"unit\":\"px\"},\"color\":\"rgba(64, 191, 154, 0.45)\"}},\"background\":{\"color\":\"rgba(76, 175, 80, 0.7)\"}},\"props\":{\"layout\":{\"verticalInnerGap\":3,\"horizontalInnerGap\":3},\"media\":{\"mobile\":{\"layout\":{\"horizontalInnerGap\":2,\"verticalInnerGap\":2}},\"tablet\":{\"layout\":{\"horizontalInnerGap\":3,\"verticalInnerGap\":3}}},\"verticalAlign\":\"center\"},\"v\":\"1.1\",\"nodes\":[\"16-c18\"]},{\"id\":194,\"type\":\"hop-icon\",\"style\":{\"descendants\":{\"icon\":{\"fill\":\"${theme.colors.4}\",\"width\":{\"path\":\"value\",\"value\":\"64\"},\"height\":{\"path\":\"value\",\"value\":\"64\"},\"border\":{\"top\":{\"style\":\"none\",\"width\":{\"value\":\"2\",\"unit\":\"px\"},\"color\":\"${theme.colors.1}\",\"radius\":{\"left\":{\"value\":\"300\",\"unit\":\"px\"},\"right\":{\"value\":\"300\",\"unit\":\"px\"}}},\"right\":{\"style\":\"none\",\"width\":{\"value\":\"2\",\"unit\":\"px\"},\"color\":\"${theme.colors.1}\"},\"bottom\":{\"style\":\"none\",\"width\":{\"value\":\"2\",\"unit\":\"px\"},\"color\":\"${theme.colors.1}\",\"radius\":{\"left\":{\"value\":\"300\",\"unit\":\"px\"},\"right\":{\"value\":\"300\",\"unit\":\"px\"}}},\"left\":{\"style\":\"none\",\"width\":{\"value\":\"2\",\"unit\":\"px\"},\"color\":\"${theme.colors.1}\"}},\"padding\":{\"top\":{\"path\":\"value\",\"value\":\"11\"},\"left\":{\"path\":\"value\",\"value\":\"11\"},\"right\":{\"path\":\"value\",\"value\":\"11\"},\"bottom\":{\"path\":\"value\",\"value\":\"11\"}}}}},\"v\":\"1.1\",\"nodes\":[\"16-c11\"]},{\"id\":195,\"type\":\"hop-heading\",\"style\":{\"typography\":{\"transform\":\"uppercase\",\"letterSpacing\":{\"unit\":\"px\",\"value\":\"1\"},\"color\":\"${theme.colors.4}\"}},\"props\":{\"headerType\":\"5\"},\"v\":\"1.1\",\"nodes\":[\"16-c24\"]},{\"id\":196,\"type\":\"hop-text\",\"v\":\"1.1\",\"nodes\":[\"16-c21\"],\"style\":{\"typography\":{\"holders\":{\"p\":{\"color\":\"${theme.colors.5}\"}}}}},{\"id\":197,\"type\":\"hop-column\",\"style\":{\"textAlign\":\"center\",\"media\":{\"mobile\":{\"textAlign\":\"center\",\"padding\":{\"left\":{\"unit\":\"px\"},\"right\":{\"unit\":\"px\"},\"top\":{\"unit\":\"px\"},\"bottom\":{\"unit\":\"px\"}}},\"tablet\":{\"padding\":{\"left\":{\"unit\":\"px\"},\"right\":{\"unit\":\"px\"},\"top\":{\"unit\":\"px\"},\"bottom\":{\"unit\":\"px\"}}}},\"descendants\":{\"outer\":{\"media\":{\"mobile\":{\"padding\":{\"left\":{\"unit\":\"px\"},\"right\":{\"unit\":\"px\"},\"top\":{\"unit\":\"px\"},\"bottom\":{\"unit\":\"px\"}}}},\"padding\":{\"left\":{\"unit\":\"px\",\"value\":0},\"right\":{\"unit\":\"px\",\"value\":0},\"top\":{\"unit\":\"px\",\"value\":0},\"bottom\":{\"unit\":\"px\",\"value\":0}}}},\"padding\":{\"left\":{\"unit\":\"px\",\"value\":0},\"right\":{\"unit\":\"px\",\"value\":0},\"top\":{\"unit\":\"px\",\"value\":0},\"bottom\":{\"unit\":\"px\",\"value\":0}},\"border\":{\"top\":{\"radius\":{\"left\":{\"unit\":\"px\",\"value\":\"22\"},\"right\":{\"unit\":\"px\",\"value\":\"22\"}},\"style\":\"solid\",\"width\":{\"value\":\"3\",\"unit\":\"px\"},\"color\":\"rgb(16, 201, 186)\"},\"bottom\":{\"radius\":{\"left\":{\"unit\":\"px\",\"value\":\"22\"},\"right\":{\"unit\":\"px\",\"value\":\"22\"}},\"style\":\"solid\",\"width\":{\"value\":\"3\",\"unit\":\"px\"},\"color\":\"rgb(16, 201, 186)\"},\"right\":{\"style\":\"solid\",\"width\":{\"value\":\"3\",\"unit\":\"px\"},\"color\":\"rgb(16, 201, 186)\"},\"left\":{\"style\":\"solid\",\"width\":{\"value\":\"3\",\"unit\":\"px\"},\"color\":\"rgb(16, 201, 186)\"}},\"background\":{\"color\":\"rgba(12, 215, 167, 0.58)\"}},\"props\":{\"layout\":{\"verticalInnerGap\":3,\"horizontalInnerGap\":3},\"media\":{\"mobile\":{\"layout\":{\"horizontalInnerGap\":2,\"verticalInnerGap\":2}},\"tablet\":{\"layout\":{\"horizontalInnerGap\":3,\"verticalInnerGap\":3}}},\"verticalAlign\":\"center\"},\"v\":\"1.1\",\"nodes\":[\"16-c22\"]},{\"id\":202,\"type\":\"hop-heading\",\"nodeId\":\"18-h32\",\"nodes\":[\"18-h23\"],\"v\":\"1.1\",\"style\":{\"typography\":{\"color\":\"${theme.colors.2|variant0}\"}}},{\"id\":203,\"type\":\"hop-column\",\"style\":{\"textAlign\":\"center\",\"media\":{\"mobile\":{\"textAlign\":\"center\",\"padding\":{\"left\":{\"unit\":\"px\"},\"right\":{\"unit\":\"px\"},\"top\":{\"unit\":\"px\"},\"bottom\":{\"unit\":\"px\"}}},\"tablet\":{\"padding\":{\"left\":{\"unit\":\"px\"},\"right\":{\"unit\":\"px\"},\"top\":{\"unit\":\"px\"},\"bottom\":{\"unit\":\"px\"}}}},\"descendants\":{\"outer\":{\"media\":{\"mobile\":{\"padding\":{\"left\":{\"unit\":\"px\"},\"right\":{\"unit\":\"px\"},\"top\":{\"unit\":\"px\"},\"bottom\":{\"unit\":\"px\"}}}},\"padding\":{\"left\":{\"unit\":\"px\",\"value\":0},\"right\":{\"unit\":\"px\",\"value\":0},\"top\":{\"unit\":\"px\",\"value\":0},\"bottom\":{\"unit\":\"px\",\"value\":0}}}},\"padding\":{\"left\":{\"unit\":\"px\",\"value\":0},\"right\":{\"unit\":\"px\",\"value\":0},\"top\":{\"unit\":\"px\",\"value\":0},\"bottom\":{\"unit\":\"px\",\"value\":0}},\"border\":{\"top\":{\"radius\":{\"left\":{\"unit\":\"px\",\"value\":\"22\"},\"right\":{\"unit\":\"px\",\"value\":\"22\"}},\"style\":\"solid\",\"width\":{\"value\":\"3\",\"unit\":\"px\"},\"color\":\"rgba(247, 144, 7, 0.44)\"},\"bottom\":{\"radius\":{\"left\":{\"unit\":\"px\",\"value\":\"22\"},\"right\":{\"unit\":\"px\",\"value\":\"22\"}},\"style\":\"solid\",\"width\":{\"value\":\"3\",\"unit\":\"px\"},\"color\":\"rgba(247, 144, 7, 0.44)\"},\"right\":{\"style\":\"solid\",\"width\":{\"value\":\"3\",\"unit\":\"px\"},\"color\":\"rgba(247, 144, 7, 0.44)\"},\"left\":{\"style\":\"solid\",\"width\":{\"value\":\"3\",\"unit\":\"px\"},\"color\":\"rgba(247, 144, 7, 0.44)\"}},\"background\":{\"color\":\"rgba(251, 192, 45, 0.7)\"},\"customHeight\":{\"min-height\":{\"unit\":\"px\",\"value\":434},\"type\":\"min-height\"}},\"props\":{\"layout\":{\"verticalInnerGap\":3,\"horizontalInnerGap\":3},\"media\":{\"mobile\":{\"layout\":{\"horizontalInnerGap\":2,\"verticalInnerGap\":2}},\"tablet\":{\"layout\":{\"horizontalInnerGap\":3,\"verticalInnerGap\":3}}},\"verticalAlign\":\"center\"},\"v\":\"1.1\",\"nodes\":[\"16-c10\"],\"nodeId\":\"16-c4\"},{\"id\":204,\"type\":\"hop-column\",\"style\":{\"textAlign\":\"center\",\"media\":{\"mobile\":{\"textAlign\":\"center\",\"padding\":{\"left\":{\"unit\":\"px\"},\"right\":{\"unit\":\"px\"},\"top\":{\"unit\":\"px\"},\"bottom\":{\"unit\":\"px\"}}},\"tablet\":{\"padding\":{\"left\":{\"unit\":\"px\"},\"right\":{\"unit\":\"px\"},\"top\":{\"unit\":\"px\"},\"bottom\":{\"unit\":\"px\"}}}},\"descendants\":{\"outer\":{\"media\":{\"mobile\":{\"padding\":{\"left\":{\"unit\":\"px\"},\"right\":{\"unit\":\"px\"},\"top\":{\"unit\":\"px\"},\"bottom\":{\"unit\":\"px\"}}}},\"padding\":{\"left\":{\"unit\":\"px\",\"value\":0},\"right\":{\"unit\":\"px\",\"value\":0},\"top\":{\"unit\":\"px\",\"value\":0},\"bottom\":{\"unit\":\"px\",\"value\":0}}}},\"padding\":{\"left\":{\"unit\":\"px\",\"value\":0},\"right\":{\"unit\":\"px\",\"value\":0},\"top\":{\"unit\":\"px\",\"value\":0},\"bottom\":{\"unit\":\"px\",\"value\":0}},\"border\":{\"top\":{\"radius\":{\"left\":{\"unit\":\"px\",\"value\":\"22\"},\"right\":{\"unit\":\"px\",\"value\":\"22\"}},\"style\":\"solid\",\"width\":{\"value\":\"3\",\"unit\":\"px\"},\"color\":\"rgb(251, 230, 5)\"},\"bottom\":{\"radius\":{\"left\":{\"unit\":\"px\",\"value\":\"22\"},\"right\":{\"unit\":\"px\",\"value\":\"22\"}},\"style\":\"solid\",\"width\":{\"value\":\"3\",\"unit\":\"px\"},\"color\":\"rgb(251, 230, 5)\"},\"right\":{\"style\":\"solid\",\"width\":{\"value\":\"3\",\"unit\":\"px\"},\"color\":\"rgb(251, 230, 5)\"},\"left\":{\"style\":\"solid\",\"width\":{\"value\":\"3\",\"unit\":\"px\"},\"color\":\"rgb(251, 230, 5)\"}},\"background\":{\"color\":\"rgba(209, 196, 8, 0.7)\"}},\"props\":{\"layout\":{\"verticalInnerGap\":3,\"horizontalInnerGap\":3},\"media\":{\"mobile\":{\"layout\":{\"horizontalInnerGap\":2,\"verticalInnerGap\":2}},\"tablet\":{\"layout\":{\"horizontalInnerGap\":3,\"verticalInnerGap\":3}}},\"verticalAlign\":\"center\"},\"v\":\"1.1\",\"nodes\":[\"16-c14\"],\"nodeId\":\"16-c8\"},{\"id\":205,\"type\":\"hop-logo\",\"props\":{\"horizontalTextAlign\":\"left\",\"media\":{\"mobile\":{\"horizontalTextAlign\":\"left\"}},\"layoutType\":\"text\",\"spaceText\":{\"path\":\"value\",\"value\":13}},\"v\":\"1.1\",\"nodes\":[\"22-h5\",\"18-h5\"],\"style\":{\"descendants\":{\"logo-text\":{\"typography\":{\"color\":\"${theme.colors.4}\"}},\"text\":{\"typography\":{\"weight\":\"600\",\"size\":{\"unit\":\"px\",\"value\":34},\"transform\":\"uppercase\",\"letterSpacing\":{\"unit\":\"px\",\"value\":\"2\"},\"family\":\"Montserrat\"}}},\"color\":\"#fff\"},\"nodeId\":\"18-h5\"},{\"id\":211,\"nodeId\":\"22-h28\",\"nodes\":[\"22-h31\"],\"v\":\"1.1\"},{\"id\":217,\"props\":{\"layout\":{\"equalWidth\":false}},\"type\":\"hop-row\",\"nodeId\":\"22-h29\",\"nodes\":[\"22-h25\"],\"v\":\"1.1\"},{\"id\":218,\"type\":\"hop-column\",\"nodeId\":\"22-h30\",\"nodes\":[\"22-h26\"],\"v\":\"1.1\"},{\"id\":219,\"type\":\"hop-heading\",\"nodeId\":\"22-h31\",\"nodes\":[\"22-h27\"],\"v\":\"1.1\",\"style\":{\"typography\":{\"color\":\"${theme.colors.4}\"}},\"props\":{\"headerType\":\"1\"}},{\"id\":221,\"type\":\"hop-social-icons\",\"style\":{\"descendants\":{\"icon-content\":{\"states\":{\"hover\":{\"fill\":\"${theme.colors.0}\"}},\"width\":{\"value\":85},\"height\":{\"value\":85},\"fill\":\"${theme.colors.3}\"},\"icon\":{\"margin\":{\"right\":{\"value\":50}},\"padding\":{\"top\":{\"value\":8},\"left\":{\"value\":8},\"bottom\":{\"value\":8},\"right\":{\"value\":8}}}}},\"v\":\"1.1\",\"nodes\":[\"22-h30\"]},{\"id\":224,\"props\":{\"layout\":{\"equalWidth\":false}},\"type\":\"hop-row\",\"nodeId\":\"22-h33\",\"nodes\":[\"22-h32\"],\"v\":\"1.1\"},{\"id\":225,\"type\":\"hop-column\",\"nodeId\":\"22-h34\",\"nodes\":[\"22-h33\"],\"v\":\"1.1\"},{\"id\":226,\"type\":\"hop-text\",\"nodeId\":\"22-h36\",\"nodes\":[\"22-h34\"],\"v\":\"1.1\"},{\"id\":227,\"type\":\"hop-content\",\"nodeId\":\"2-c1\",\"nodes\":[\"2-c1\"],\"style\":[],\"v\":\"1.1\"},{\"id\":228,\"type\":\"hop-section\",\"nodeId\":\"2-c2\",\"nodes\":[\"2-c2\"],\"style\":{\"media\":{\"mobile\":[],\"tablet\":[]}},\"v\":\"1.1\"},{\"id\":229,\"props\":{\"layout\":{\"equalWidth\":false}},\"type\":\"hop-row\",\"nodeId\":\"2-c3\",\"nodes\":[\"2-c3\"],\"style\":{\"media\":{\"mobile\":[],\"tablet\":[]}},\"v\":\"1.1\"},{\"id\":230,\"type\":\"hop-column\",\"nodeId\":\"2-c4\",\"nodes\":[\"2-c4\"],\"style\":{\"media\":{\"mobile\":[],\"tablet\":[]}},\"v\":\"1.1\"},{\"id\":231,\"type\":\"hop-external\",\"nodeId\":\"2-c5\",\"nodes\":[\"2-c5\"],\"style\":[],\"v\":\"1.1\"},{\"id\":240,\"style\":{\"padding\":{\"top\":{\"unit\":\"px\",\"value\":\"\"},\"bottom\":{\"unit\":\"px\",\"value\":\"\"},\"left\":{\"unit\":\"px\",\"value\":\"\"},\"right\":{\"unit\":\"px\",\"value\":\"\"}},\"descendants\":{\"outer\":{\"padding\":{\"top\":{\"unit\":\"px\",\"value\":\"\"},\"bottom\":{\"unit\":\"px\",\"value\":\"\"},\"left\":{\"unit\":\"px\",\"value\":\"\"},\"right\":{\"unit\":\"px\",\"value\":\"\"}}}}},\"props\":{\"verticalAlign\":\"center\",\"hide\":{\"mobile\":true}},\"type\":\"hop-column\",\"nodeId\":\"18-h56\",\"nodes\":[\"22-h6\",\"18-h5\"],\"v\":\"1.1\"},{\"id\":241,\"type\":\"hop-content\",\"nodeId\":\"2-c1\",\"nodes\":[\"2-c1\"],\"style\":[],\"v\":\"1.1\"},{\"id\":242,\"type\":\"hop-section\",\"nodeId\":\"2-c2\",\"nodes\":[\"2-c2\"],\"style\":{\"media\":{\"mobile\":[],\"tablet\":[]}},\"v\":\"1.1\"},{\"id\":243,\"props\":{\"layout\":{\"equalWidth\":false}},\"type\":\"hop-row\",\"nodeId\":\"2-c3\",\"nodes\":[\"2-c3\"],\"style\":{\"media\":{\"mobile\":[],\"tablet\":[]}},\"v\":\"1.1\"},{\"id\":244,\"type\":\"hop-column\",\"nodeId\":\"2-c4\",\"nodes\":[\"2-c4\"],\"style\":{\"media\":{\"mobile\":[],\"tablet\":[]}},\"v\":\"1.1\"},{\"id\":245,\"type\":\"hop-external\",\"nodeId\":\"2-c5\",\"nodes\":[\"2-c5\"],\"style\":[],\"v\":\"1.1\"},{\"id\":246,\"type\":\"hop-content\",\"nodeId\":\"2-c1\",\"nodes\":[\"2-c1\"],\"style\":[],\"v\":\"1.1\"},{\"id\":247,\"type\":\"hop-section\",\"nodeId\":\"2-c2\",\"nodes\":[\"2-c2\"],\"style\":{\"media\":{\"mobile\":[],\"tablet\":[]}},\"v\":\"1.1\"},{\"id\":248,\"props\":{\"layout\":{\"equalWidth\":false}},\"type\":\"hop-row\",\"nodeId\":\"2-c3\",\"nodes\":[\"2-c3\"],\"style\":{\"media\":{\"mobile\":[],\"tablet\":[]}},\"v\":\"1.1\"},{\"id\":249,\"type\":\"hop-column\",\"nodeId\":\"2-c4\",\"nodes\":[\"2-c4\"],\"style\":{\"media\":{\"mobile\":[],\"tablet\":[]}},\"v\":\"1.1\"},{\"id\":250,\"type\":\"hop-external\",\"nodeId\":\"2-c5\",\"nodes\":[\"2-c5\"],\"style\":[],\"v\":\"1.1\"},{\"id\":251,\"type\":\"hop-content\",\"nodeId\":\"2-c1\",\"nodes\":[\"2-c1\"],\"v\":\"1.1\"},{\"id\":259,\"props\":{\"layout\":{\"equalWidth\":false}},\"type\":\"hop-row\",\"nodeId\":\"22-h35\",\"nodes\":[\"22-h32\"],\"v\":\"1.1\"},{\"id\":260,\"type\":\"hop-column\",\"nodeId\":\"22-h36\",\"nodes\":[\"22-h33\"],\"v\":\"1.1\"},{\"id\":262,\"type\":\"hop-text\",\"nodeId\":\"22-h38\",\"nodes\":[\"22-h34\"],\"v\":\"1.1\",\"style\":{\"typography\":{\"holders\":{\"p\":{\"size\":{\"unit\":\"px\",\"value\":16}}}}}},{\"id\":263,\"props\":{\"layout\":{\"equalWidth\":false}},\"type\":\"hop-row\",\"nodeId\":\"22-h35\",\"nodes\":[\"22-h35\"],\"v\":\"1.1\",\"style\":{\"media\":{\"mobile\":[],\"tablet\":[]}}},{\"id\":264,\"type\":\"hop-column\",\"nodeId\":\"22-h36\",\"nodes\":[\"22-h36\"],\"v\":\"1.1\",\"style\":{\"media\":{\"mobile\":[],\"tablet\":[]}}},{\"id\":266,\"type\":\"hop-heading\",\"nodeId\":\"22-h38\",\"nodes\":[\"22-h38\"],\"v\":\"1.1\",\"style\":{\"media\":{\"mobile\":[],\"tablet\":[]}},\"props\":{\"headerType\":\"3\"}},{\"id\":267,\"type\":\"hop-content\",\"nodeId\":\"220-c1\",\"nodes\":[\"220-c1\"],\"v\":\"1.1\"},{\"id\":268,\"type\":\"hop-section\",\"v\":\"1.1\",\"nodes\":[\"220-c2\"],\"style\":{\"background\":{\"type\":\"none\",\"image\":[{\"source\":{\"type\":\"gradient\",\"gradient\":{\"angle\":\"120\",\"steps\":[{\"color\":\"rgba(252, 203, 144, 0.8)\",\"position\":\"0\"},{\"color\":\"rgba(213, 126, 235, 0.8)\",\"position\":\"100\"}]}}}]},\"customHeight\":{\"type\":\"full-screen\",\"min-height\":{\"unit\":\"px\",\"value\":968.0416870117188}},\"padding\":{\"bottom\":{\"value\":34},\"top\":{\"value\":0}}},\"props\":{\"width\":\"full-width\",\"showHeader\":false}},{\"id\":269,\"props\":{\"layout\":{\"equalWidth\":true,\"horizontalGap\":2},\"media\":{\"mobile\":{\"layout\":{\"horizontalGap\":2,\"verticalGap\":2}}}},\"type\":\"hop-row\",\"v\":\"1.1\",\"nodes\":[\"220-c6\"],\"style\":{\"background\":{\"type\":\"none\",\"image\":[{\"source\":{\"type\":\"image\"},\"position\":\"center center\"}]}}},{\"id\":270,\"type\":\"hop-column\",\"style\":{\"textAlign\":\"center\",\"descendants\":{\"outer\":{\"media\":{\"mobile\":{\"padding\":{\"left\":{\"unit\":\"px\"},\"right\":{\"unit\":\"px\"},\"top\":{\"unit\":\"px\"},\"bottom\":{\"unit\":\"px\"}}}}}},\"media\":{\"mobile\":{\"padding\":{\"left\":{\"unit\":\"px\"},\"right\":{\"unit\":\"px\"},\"top\":{\"unit\":\"px\"},\"bottom\":{\"unit\":\"px\"}}}},\"padding\":{\"left\":{\"unit\":\"px\"},\"right\":{\"unit\":\"px\"},\"top\":{\"unit\":\"px\"},\"bottom\":{\"unit\":\"px\"}}},\"props\":{\"verticalAlign\":\"center\",\"media\":{\"mobile\":{\"layout\":{\"horizontalInnerGap\":2,\"verticalInnerGap\":2}}},\"layout\":{\"horizontalInnerGap\":2,\"verticalInnerGap\":2}},\"v\":\"1.1\",\"nodes\":[\"220-c7\"]},{\"id\":271,\"type\":\"hop-heading\",\"props\":{\"headerType\":\"5\",\"fancy\":{\"fancyWord\":\"Yanis\",\"typeStyle\":\"none\"}},\"v\":\"1.1\",\"nodes\":[\"220-c5\"],\"style\":{\"typography\":{\"color\":\"rgba(5, 127, 93, 0.56)\",\"size\":{\"unit\":\"em\",\"value\":3},\"style\":\"normal\",\"decoration\":\"overline\",\"letterSpacing\":{\"unit\":\"px\",\"value\":\"10\"}},\"textAlign\":\"center\",\"textShadow\":{\"enabled\":true}}},{\"id\":272,\"type\":\"hop-heading\",\"props\":{\"headerType\":\"2\"},\"v\":\"1.1\",\"nodes\":[\"220-c8\"],\"style\":{\"typography\":{\"color\":\"${theme.colors.5|variant3}\"}}},{\"id\":273,\"type\":\"hop-text\",\"props\":{\"type\":\"lead\"},\"v\":\"1.1\",\"nodes\":[\"220-c19\"],\"style\":{\"typography\":{\"holders\":{\"p\":{\"color\":\"${theme.colors.5}\"}}}}},{\"id\":274,\"type\":\"hop-button-group\",\"v\":\"1.1\",\"nodes\":[\"220-c10\"]},{\"id\":275,\"type\":\"hop-button\",\"style\":{\"textAlign\":\"center\",\"background\":{\"color\":\"${theme.colors.0}\"},\"typography\":{\"color\":\"#fff\",\"family\":\"Open Sans\",\"margin\":{\"top\":\"\",\"bottom\":\"2rem\"},\"size\":{\"unit\":\"px\",\"value\":\"12\"},\"weight\":\"600\",\"lineHeight\":{\"value\":\"1\",\"unit\":\"\"},\"transform\":\"uppercase\",\"letterSpacing\":{\"value\":\"1\",\"unit\":\"px\"}},\"border\":{\"top\":{\"color\":\"${theme.colors.0}\",\"style\":\"solid\",\"width\":{\"value\":\"2\",\"unit\":\"px\"},\"radius\":{\"right\":{\"value\":0,\"unit\":\"px\",\"path\":\"value\"},\"left\":{\"value\":0,\"unit\":\"px\",\"path\":\"value\"}}},\"bottom\":{\"color\":\"${theme.colors.0}\",\"style\":\"solid\",\"width\":{\"value\":\"2\",\"unit\":\"px\"},\"radius\":{\"right\":{\"value\":0,\"unit\":\"px\",\"path\":\"value\"},\"left\":{\"value\":0,\"unit\":\"px\",\"path\":\"value\"}}},\"right\":{\"color\":\"${theme.colors.0}\",\"style\":\"solid\",\"width\":{\"value\":\"2\",\"unit\":\"px\"}},\"left\":{\"color\":\"${theme.colors.0}\",\"style\":\"solid\",\"width\":{\"value\":\"2\",\"unit\":\"px\"}}},\"padding\":{\"top\":{\"unit\":\"px\",\"value\":\"12\"},\"bottom\":{\"unit\":\"px\",\"value\":\"12\"},\"left\":{\"unit\":\"px\",\"value\":\"24\"},\"right\":{\"unit\":\"px\",\"value\":\"24\"}},\"states\":{\"hover\":{\"background\":{\"color\":\"${theme.colors.0|variant3}\"},\"border\":{\"top\":{\"color\":\"${theme.colors.0|variant3}\"},\"right\":{\"color\":\"${theme.colors.0|variant3}\"},\"bottom\":{\"color\":\"${theme.colors.0|variant3}\"},\"left\":{\"color\":\"${theme.colors.0|variant3}\"}}}},\"descendants\":{\"icon\":{\"size\":{\"unit\":\"px\",\"value\":\"12\"},\"margin\":{\"left\":{\"value\":\"0\",\"unit\":\"px\"},\"right\":{\"value\":\"10\",\"unit\":\"px\"}}}}},\"v\":\"1.1\",\"nodes\":[\"220-c11\"]},{\"id\":276,\"type\":\"hop-column\",\"props\":{\"layout\":{\"horizontalInnerGap\":2,\"verticalInnerGap\":2,\"vSpace\":{\"value\":42}},\"media\":{\"mobile\":{\"layout\":{\"horizontalInnerGap\":2,\"verticalInnerGap\":2}}},\"verticalAlign\":\"center\"},\"style\":{\"media\":{\"mobile\":{\"padding\":{\"left\":{\"unit\":\"px\"},\"right\":{\"unit\":\"px\"},\"top\":{\"unit\":\"px\"},\"bottom\":{\"unit\":\"px\"}}}},\"padding\":{\"left\":{\"unit\":\"px\"},\"right\":{\"unit\":\"px\"},\"top\":{\"unit\":\"px\"},\"bottom\":{\"unit\":\"px\"}}},\"v\":\"1.1\",\"nodes\":[\"220-c13\"]},{\"id\":277,\"type\":\"hop-image\",\"style\":{\"descendants\":{\"frameImage\":{\"zIndex\":1,\"backgroundColor\":\"transparent\",\"border\":{\"top\":{\"style\":\"solid\",\"color\":\"${theme.colors.0}\"},\"bottom\":{\"style\":\"solid\",\"color\":\"${theme.colors.0}\"},\"left\":{\"style\":\"solid\",\"color\":\"${theme.colors.0}\"},\"right\":{\"style\":\"solid\",\"color\":\"${theme.colors.0}\"}},\"transform\":{\"translate\":{\"x\":{\"path\":\"value\",\"value\":\"5\"},\"y\":{\"path\":\"value\",\"value\":\"5\"}}},\"media\":{\"tablet\":{\"transform\":{\"translate\":{\"x\":{\"path\":\"value\",\"value\":\"5\"}}}}},\"height\":{\"path\":\"value\",\"value\":100},\"width\":{\"path\":\"value\",\"value\":100}},\"image\":{\"boxShadow\":{\"enabled\":true,\"layers\":[{\"color\":\"rgba(0, 0, 0, 0.1)\",\"spread\":\"2\",\"blur\":\"30\",\"y\":\"10\",\"x\":\"0\"}]}},\"overlay\":{\"background\":{\"overlay\":{\"enabled\":false}}}},\"textAlign\":\"left\"},\"props\":{\"enabledFrameOption\":true,\"showFrameOverImage\":true,\"frame\":{\"type\":\"border\"},\"showFrameShadow\":false,\"media\":{\"mobile\":{\"enabledFrameOption\":false}}},\"v\":\"1.1\",\"nodes\":[\"220-c14\"]},{\"id\":278,\"type\":\"hop-content\",\"nodeId\":\"236-c1\",\"nodes\":[\"236-c1\"],\"style\":[],\"v\":\"1.1\"},{\"id\":279,\"type\":\"hop-content\",\"nodeId\":\"236-c1\",\"nodes\":[\"236-c1\"],\"style\":[],\"v\":\"1.1\"},{\"id\":280,\"type\":\"hop-content\",\"nodeId\":\"236-c1\",\"nodes\":[\"236-c1\"],\"style\":[],\"v\":\"1.1\"},{\"id\":281,\"type\":\"hop-content\",\"nodeId\":\"236-c1\",\"nodes\":[\"236-c1\"],\"style\":[],\"v\":\"1.1\"},{\"id\":283,\"props\":{\"layout\":{\"equalWidth\":false}},\"type\":\"hop-row\",\"nodeId\":\"220-c12\",\"nodes\":[\"220-c3\"],\"v\":\"1.1\"},{\"id\":284,\"type\":\"hop-column\",\"nodeId\":\"220-c13\",\"nodes\":[\"220-c4\"],\"v\":\"1.1\"},{\"id\":285,\"type\":\"hop-heading\",\"nodeId\":\"220-c14\",\"nodes\":[\"220-c5\"],\"v\":\"1.1\",\"style\":{\"typography\":{\"color\":\"${theme.colors.4}\"}}},{\"id\":287,\"type\":\"hop-content\",\"nodeId\":\"236-c1\",\"nodes\":[\"236-c1\"],\"style\":[],\"v\":\"1.1\"},{\"id\":288,\"type\":\"hop-content\",\"nodeId\":\"236-c1\",\"nodes\":[\"236-c1\"],\"v\":\"1.1\"},{\"id\":289,\"type\":\"hop-section\",\"style\":{\"padding\":{\"top\":{\"path\":\"value\",\"value\":\"0\"},\"bottom\":{\"value\":\"0\"}},\"media\":{\"mobile\":{\"margin\":{\"top\":{\"value\":\"0\",\"unit\":\"px\"},\"right\":{\"unit\":\"px\"},\"bottom\":{\"unit\":\"px\"},\"left\":{\"unit\":\"px\"}}}},\"descendants\":{\"inner\":{\"margin\":{\"top\":{\"value\":0,\"unit\":\"px\",\"path\":\"value\"}}}}},\"v\":\"1.1\",\"nodes\":[\"236-c2\"],\"props\":{\"width\":\"full-width\"}},{\"id\":290,\"props\":{\"layout\":{\"equalWidth\":true,\"itemsPerRow\":4,\"horizontalGap\":0,\"verticalGap\":0},\"media\":{\"mobile\":{\"layout\":{\"horizontalGap\":2,\"verticalGap\":2}}}},\"type\":\"hop-row\",\"style\":{\"boxShadow\":{\"enabled\":true,\"layers\":[{\"color\":\"rgba(74, 74, 74, 0.3)\",\"y\":\"4\"}]},\"media\":{\"mobile\":{\"margin\":{\"top\":{\"value\":\"15\",\"unit\":\"px\"},\"right\":{\"value\":\"15\",\"unit\":\"px\"},\"bottom\":{\"value\":\"15\",\"unit\":\"px\"},\"left\":{\"value\":\"15\",\"unit\":\"px\"}}}}},\"v\":\"1.1\",\"nodes\":[\"236-c12\"]},{\"id\":291,\"type\":\"hop-column\",\"style\":{\"textAlign\":\"center\",\"media\":{\"mobile\":{\"textAlign\":\"center\",\"padding\":{\"left\":{\"unit\":\"px\"},\"right\":{\"unit\":\"px\"},\"top\":{\"unit\":\"px\"},\"bottom\":{\"unit\":\"px\"}}},\"tablet\":{\"padding\":{\"left\":{\"unit\":\"px\"},\"right\":{\"unit\":\"px\"},\"top\":{\"unit\":\"px\"},\"bottom\":{\"unit\":\"px\"}}}},\"descendants\":{\"outer\":{\"media\":{\"mobile\":{\"padding\":{\"left\":{\"unit\":\"px\"},\"right\":{\"unit\":\"px\"},\"top\":{\"unit\":\"px\"},\"bottom\":{\"unit\":\"px\"}}}},\"padding\":{\"left\":{\"unit\":\"px\"},\"right\":{\"unit\":\"px\"},\"top\":{\"unit\":\"px\"},\"bottom\":{\"unit\":\"px\"}}}},\"padding\":{\"left\":{\"unit\":\"px\"},\"right\":{\"unit\":\"px\"},\"top\":{\"unit\":\"px\"},\"bottom\":{\"unit\":\"px\"}},\"border\":{\"top\":{\"radius\":{\"left\":{\"unit\":\"px\"},\"right\":{\"unit\":\"px\"}},\"style\":\"solid\",\"width\":{\"value\":\"0\",\"unit\":\"px\"},\"color\":\"rgb(221, 221, 221)\"},\"bottom\":{\"radius\":{\"left\":{\"unit\":\"px\"},\"right\":{\"unit\":\"px\"}},\"style\":\"solid\",\"width\":{\"value\":\"0\",\"unit\":\"px\"},\"color\":\"rgb(221, 221, 221)\"},\"right\":{\"style\":\"solid\",\"width\":{\"value\":\"1\",\"unit\":\"px\"},\"color\":\"rgb(221, 221, 221)\"},\"left\":{\"style\":\"solid\",\"width\":{\"value\":\"0\",\"unit\":\"px\"},\"color\":\"rgb(221, 221, 221)\"}}},\"props\":{\"layout\":{\"verticalInnerGap\":3,\"horizontalInnerGap\":3},\"media\":{\"mobile\":{\"layout\":{\"horizontalInnerGap\":2,\"verticalInnerGap\":2}},\"tablet\":{\"layout\":{\"horizontalInnerGap\":3,\"verticalInnerGap\":3}}},\"verticalAlign\":\"center\"},\"v\":\"1.1\",\"nodes\":[\"236-c13\",\"236-c16\",\"236-c19\"]},{\"id\":292,\"type\":\"hop-icon\",\"style\":{\"descendants\":{\"icon\":{\"width\":{\"path\":\"value\",\"value\":\"64\"},\"height\":{\"path\":\"value\",\"value\":\"64\"},\"border\":{\"top\":{\"style\":\"none\",\"width\":{\"value\":\"2\",\"unit\":\"px\"},\"color\":\"${theme.colors.1}\",\"radius\":{\"left\":{\"value\":\"300\",\"unit\":\"px\"},\"right\":{\"value\":\"300\",\"unit\":\"px\"}}},\"right\":{\"style\":\"none\",\"width\":{\"value\":\"2\",\"unit\":\"px\"},\"color\":\"${theme.colors.1}\"},\"bottom\":{\"style\":\"none\",\"width\":{\"value\":\"2\",\"unit\":\"px\"},\"color\":\"${theme.colors.1}\",\"radius\":{\"left\":{\"value\":\"300\",\"unit\":\"px\"},\"right\":{\"value\":\"300\",\"unit\":\"px\"}}},\"left\":{\"style\":\"none\",\"width\":{\"value\":\"2\",\"unit\":\"px\"},\"color\":\"${theme.colors.1}\"}},\"padding\":{\"top\":{\"path\":\"value\",\"value\":\"11\"},\"left\":{\"path\":\"value\",\"value\":\"11\"},\"right\":{\"path\":\"value\",\"value\":\"11\"},\"bottom\":{\"path\":\"value\",\"value\":\"11\"}}}}},\"v\":\"1.1\",\"nodes\":[\"236-c14\",\"236-c17\",\"236-c20\",\"236-c23\"]},{\"id\":293,\"type\":\"hop-heading\",\"style\":{\"typography\":{\"transform\":\"uppercase\",\"letterSpacing\":{\"unit\":\"px\",\"value\":\"1\"}}},\"props\":{\"headerType\":\"5\"},\"v\":\"1.1\",\"nodes\":[\"236-c15\",\"236-c18\",\"236-c21\",\"236-c24\"]},{\"id\":294,\"type\":\"hop-text\",\"v\":\"1.1\",\"nodes\":[\"236-c7\",\"236-c11\",\"236-c15\",\"236-c19\"]},{\"id\":295,\"type\":\"hop-column\",\"style\":{\"textAlign\":\"center\",\"media\":{\"mobile\":{\"textAlign\":\"center\",\"padding\":{\"left\":{\"unit\":\"px\"},\"right\":{\"unit\":\"px\"},\"top\":{\"unit\":\"px\"},\"bottom\":{\"unit\":\"px\"}}},\"tablet\":{\"padding\":{\"left\":{\"unit\":\"px\"},\"right\":{\"unit\":\"px\"},\"top\":{\"unit\":\"px\"},\"bottom\":{\"unit\":\"px\"}}}},\"descendants\":{\"outer\":{\"media\":{\"mobile\":{\"padding\":{\"left\":{\"unit\":\"px\"},\"right\":{\"unit\":\"px\"},\"top\":{\"unit\":\"px\"},\"bottom\":{\"unit\":\"px\"}}}},\"padding\":{\"left\":{\"unit\":\"px\"},\"right\":{\"unit\":\"px\"},\"top\":{\"unit\":\"px\"},\"bottom\":{\"unit\":\"px\"}}}},\"padding\":{\"left\":{\"unit\":\"px\"},\"right\":{\"unit\":\"px\"},\"top\":{\"unit\":\"px\"},\"bottom\":{\"unit\":\"px\"}},\"border\":{\"top\":{\"radius\":{\"left\":{\"unit\":\"px\"},\"right\":{\"unit\":\"px\"}},\"style\":\"solid\",\"width\":{\"value\":\"0\",\"unit\":\"px\"},\"color\":\"rgb(221, 221, 221)\"},\"bottom\":{\"radius\":{\"left\":{\"unit\":\"px\"},\"right\":{\"unit\":\"px\"}},\"style\":\"solid\",\"width\":{\"value\":\"0\",\"unit\":\"px\"},\"color\":\"rgb(221, 221, 221)\"},\"right\":{\"style\":\"solid\",\"width\":{\"value\":\"0\",\"unit\":\"px\"},\"color\":\"rgb(221, 221, 221)\"},\"left\":{\"style\":\"solid\",\"width\":{\"value\":\"0\",\"unit\":\"px\"},\"color\":\"rgb(221, 221, 221)\"}}},\"props\":{\"layout\":{\"verticalInnerGap\":3,\"horizontalInnerGap\":3},\"media\":{\"mobile\":{\"layout\":{\"horizontalInnerGap\":2,\"verticalInnerGap\":2}},\"tablet\":{\"layout\":{\"horizontalInnerGap\":3,\"verticalInnerGap\":3}}},\"verticalAlign\":\"center\"},\"v\":\"1.1\",\"nodes\":[\"236-c22\"]},{\"id\":296,\"type\":\"hop-content\",\"nodeId\":\"320-c1\",\"nodes\":[\"320-c1\"],\"v\":\"1.1\"},{\"id\":297,\"type\":\"hop-section\",\"nodeId\":\"320-c2\",\"nodes\":[\"320-c2\"],\"v\":\"1.1\",\"style\":{\"media\":{\"mobile\":[],\"tablet\":[]},\"background\":{\"color\":\"#F5FAFD\",\"type\":\"gradient\",\"image\":[{\"source\":{\"type\":\"gradient\"}}]}}},{\"id\":298,\"props\":{\"layout\":{\"equalWidth\":false}},\"type\":\"hop-row\",\"nodeId\":\"320-c3\",\"nodes\":[\"320-c3\"],\"v\":\"1.1\",\"style\":{\"media\":{\"mobile\":[],\"tablet\":[]}}},{\"id\":299,\"type\":\"hop-column\",\"nodeId\":\"320-c4\",\"nodes\":[\"320-c4\"],\"v\":\"1.1\",\"style\":{\"media\":{\"mobile\":[],\"tablet\":[]}}},{\"id\":300,\"type\":\"hop-section\",\"style\":{\"background\":{\"type\":\"image\",\"image\":[{\"source\":{\"type\":\"image\",\"url\":\"http:\\/\\/localhost\\/wordpress\\/wp-content\\/uploads\\/2024\\/11\\/DALL\\u00b7E-2024-11-03-15.20.45-A-serene-empty-beach-in-Martinique-at-sunrise-featuring-dark-volcanic-sand-and-soft-early-morning-light.-In-the-distant-sky-an-airplane-is-descendi.webp\"},\"position\":\"center right\",\"attachment\":\"fixed\"}],\"overlay\":{\"enabled\":true,\"color\":{\"value\":\"${theme.colors.5|variantGray1}\",\"opacity\":\"0.5\"},\"type\":\"color\",\"shape\":{\"value\":\"none\",\"isTile\":false},\"light\":0}},\"typography\":{\"color\":\"${theme.colors.5}\"},\"padding\":{\"top\":{\"path\":\"value\",\"value\":\"150\"},\"bottom\":{\"path\":\"value\",\"value\":\"150\"}},\"media\":{\"tablet\":{\"background\":{\"image\":[{\"position\":{\"x\":14.654890415439976,\"y\":53.48230912476723}}]}}}},\"v\":\"1.1\",\"nodes\":[\"320-c5\"]},{\"id\":301,\"props\":{\"layout\":{\"equalWidth\":false},\"media\":{\"mobile\":{\"layout\":{\"horizontalGap\":2,\"verticalGap\":2,\"horizontalInnerGap\":2,\"verticalInnerGap\":2}}}},\"type\":\"hop-row\",\"v\":\"1.1\",\"nodes\":[\"320-c6\"]},{\"id\":302,\"type\":\"hop-column\",\"style\":{\"boxShadow\":{\"enabled\":false,\"layers\":[{\"color\":\"rgba(189, 189, 189, 0.5)\",\"y\":\"2\"}]},\"border\":{\"top\":{\"radius\":{\"left\":{\"value\":\"5\",\"unit\":\"px\"},\"right\":{\"value\":\"5\",\"unit\":\"px\"}}},\"bottom\":{\"radius\":{\"left\":{\"value\":\"5\",\"unit\":\"px\"},\"right\":{\"value\":\"5\",\"unit\":\"px\"}}}},\"descendants\":{\"outer\":{\"media\":{\"mobile\":{\"padding\":{\"left\":{\"unit\":\"px\"},\"right\":{\"unit\":\"px\"},\"top\":{\"unit\":\"px\"},\"bottom\":{\"unit\":\"px\"}}}}}},\"media\":{\"mobile\":{\"padding\":{\"left\":{\"unit\":\"px\"},\"right\":{\"unit\":\"px\"},\"top\":{\"unit\":\"px\"},\"bottom\":{\"unit\":\"px\"}}}}},\"props\":{\"layout\":{\"horizontalInnerGap\":0,\"verticalInnerGap\":0}},\"v\":\"1.1\",\"nodes\":[\"320-c7\"]},{\"id\":303,\"props\":{\"layout\":{\"equalWidth\":false,\"verticalGap\":0,\"horizontalGap\":0}},\"type\":\"hop-row\",\"v\":\"1.1\",\"nodes\":[\"320-c8\"]},{\"id\":304,\"type\":\"hop-column\",\"style\":{\"background\":{\"color\":\"rgba(155, 90, 3, 0.33)\"},\"padding\":{\"top\":{\"value\":\"25\",\"unit\":\"px\"},\"right\":{\"value\":\"25\",\"unit\":\"px\"},\"bottom\":{\"value\":\"25\",\"unit\":\"px\"},\"left\":{\"value\":\"25\",\"unit\":\"px\"}},\"border\":{\"top\":{\"radius\":{\"left\":{\"value\":\"0\",\"unit\":\"px\"},\"right\":{\"unit\":\"px\",\"value\":\"\"}}},\"bottom\":{\"radius\":{\"left\":{\"value\":\"0\",\"unit\":\"px\"},\"right\":{\"unit\":\"px\",\"value\":\"\"}}}},\"media\":{\"mobile\":{\"border\":{\"top\":{\"radius\":{\"left\":{\"value\":\"5\",\"unit\":\"px\"},\"right\":{\"value\":\"5\",\"unit\":\"px\"}}},\"bottom\":{\"radius\":{\"left\":{\"value\":\"0\",\"unit\":\"px\"},\"right\":{\"value\":\"0\",\"unit\":\"px\"}}}}}}},\"props\":{\"layout\":{\"horizontalInnerGap\":0,\"verticalInnerGap\":0,\"vSpace\":{\"path\":\"value\",\"value\":\"40\"}},\"verticalAlign\":\"center\",\"media\":{\"mobile\":{\"layout\":{\"vSpace\":{\"path\":\"value\",\"value\":\"20\"}}}}},\"v\":\"1.1\",\"nodes\":[\"320-c9\"]},{\"id\":305,\"type\":\"hop-heading\",\"style\":{\"typography\":{\"transform\":\"uppercase\",\"color\":\"${theme.colors.4}\"}},\"props\":{\"headerType\":\"4\"},\"v\":\"1.1\",\"nodes\":[\"320-c10\"]},{\"id\":306,\"type\":\"hop-icon\",\"style\":{\"descendants\":{\"icon\":{\"fill\":\"${theme.colors.4}\",\"width\":{\"path\":\"value\",\"value\":\"40\"},\"height\":{\"path\":\"value\",\"value\":\"40\"},\"padding\":{\"top\":{\"path\":\"value\",\"value\":\"15\"},\"left\":{\"path\":\"value\",\"value\":\"15\"},\"right\":{\"path\":\"value\",\"value\":\"15\"},\"bottom\":{\"path\":\"value\",\"value\":\"15\"}},\"border\":{\"top\":{\"radius\":{\"left\":{\"value\":\"300\",\"unit\":\"px\"},\"right\":{\"value\":\"300\",\"unit\":\"px\"}},\"style\":\"solid\",\"width\":{\"value\":\"2\",\"unit\":\"px\"},\"color\":\"${theme.colors.4}\"},\"bottom\":{\"radius\":{\"left\":{\"value\":\"300\",\"unit\":\"px\"},\"right\":{\"value\":\"300\",\"unit\":\"px\"}},\"style\":\"solid\",\"width\":{\"value\":\"2\",\"unit\":\"px\"},\"color\":\"${theme.colors.4}\"},\"right\":{\"style\":\"solid\",\"width\":{\"value\":\"2\",\"unit\":\"px\"},\"color\":\"${theme.colors.4}\"},\"left\":{\"style\":\"solid\",\"width\":{\"value\":\"2\",\"unit\":\"px\"},\"color\":\"${theme.colors.4}\"}}}}},\"v\":\"1.1\",\"nodes\":[\"320-c11\"]},{\"id\":307,\"type\":\"hop-heading\",\"style\":{\"color\":\"${theme.colors.4}\"},\"props\":{\"headerType\":\"5\"},\"v\":\"1.1\",\"nodes\":[\"320-c12\"]},{\"id\":308,\"type\":\"hop-social-icons\",\"style\":{\"descendants\":{\"icon\":{\"padding\":{\"top\":{\"value\":\"10\"},\"left\":{\"value\":\"10\"},\"bottom\":{\"value\":\"10\"},\"right\":{\"value\":\"10\"}},\"border\":{\"top\":{\"radius\":{\"left\":{\"value\":\"300\",\"unit\":\"px\"},\"right\":{\"value\":\"300\",\"unit\":\"px\"}},\"style\":\"solid\",\"width\":{\"value\":\"1\",\"unit\":\"px\"},\"color\":\"${theme.colors.4}\"},\"bottom\":{\"radius\":{\"left\":{\"value\":\"300\",\"unit\":\"px\"},\"right\":{\"value\":\"300\",\"unit\":\"px\"}},\"style\":\"solid\",\"width\":{\"value\":\"1\",\"unit\":\"px\"},\"color\":\"${theme.colors.4}\"},\"right\":{\"style\":\"solid\",\"width\":{\"value\":\"1\",\"unit\":\"px\"},\"color\":\"${theme.colors.4}\"},\"left\":{\"style\":\"solid\",\"width\":{\"value\":\"1\",\"unit\":\"px\"},\"color\":\"${theme.colors.4}\"}},\"states\":{\"hover\":{\"border\":{\"top\":{\"color\":\"${theme.colors.0|variant0}\"},\"bottom\":{\"color\":\"${theme.colors.0|variant0}\"},\"right\":{\"color\":\"${theme.colors.0|variant0}\"},\"left\":{\"color\":\"${theme.colors.0|variant0}\"}},\"transition\":{\"duration\":{\"value\":\"0.5\"}}}}},\"icon-content\":{\"fill\":\"${theme.colors.4}\",\"width\":{\"value\":\"20\"},\"height\":{\"value\":\"20\"},\"media\":{\"tablet\":{\"width\":{\"value\":\"15\"},\"height\":{\"value\":\"15\"}}},\"states\":{\"hover\":{\"fill\":\"${theme.colors.0|variant0}\"}}}},\"margin\":{\"top\":{\"unit\":\"px\"},\"right\":{\"unit\":\"px\"},\"bottom\":{\"unit\":\"px\"},\"left\":{\"unit\":\"px\"}},\"states\":{\"hover\":{\"transition\":{\"duration\":{\"value\":\"1\"}}}}},\"v\":\"1.1\",\"nodes\":[\"320-c13\"]},{\"id\":309,\"type\":\"hop-column\",\"style\":{\"background\":{\"color\":\"${theme.colors.4}\"},\"border\":{\"top\":{\"radius\":{\"left\":{\"unit\":\"px\"},\"right\":{\"value\":\"5\",\"unit\":\"px\"}}},\"bottom\":{\"radius\":{\"left\":{\"unit\":\"px\"},\"right\":{\"value\":\"5\",\"unit\":\"px\"}}}},\"textAlign\":\"left\",\"media\":{\"mobile\":{\"textAlign\":\"center\",\"border\":{\"top\":{\"radius\":{\"left\":{\"value\":\"0\",\"unit\":\"px\"},\"right\":{\"value\":\"0\",\"unit\":\"px\"}}},\"bottom\":{\"radius\":{\"left\":{\"value\":\"5\",\"unit\":\"px\"},\"right\":{\"value\":\"5\",\"unit\":\"px\"}}}}}}},\"props\":{\"verticalAlign\":\"center\",\"layout\":{\"horizontalInnerGap\":0,\"verticalInnerGap\":0,\"vSpace\":{\"path\":\"value\",\"value\":\"40\"}}},\"v\":\"1.1\",\"nodes\":[\"320-c14\"]},{\"id\":310,\"type\":\"hop-contact-form\",\"style\":{\"padding\":{\"top\":{\"value\":\"40\",\"unit\":\"px\"},\"right\":{\"value\":\"40\",\"unit\":\"px\"},\"bottom\":{\"value\":\"0\",\"unit\":\"px\"},\"left\":{\"value\":\"40\",\"unit\":\"px\"}},\"descendants\":{\"labels\":{\"typography\":{\"color\":\"${theme.colors.5|variantGray2}\"}},\"inputs\":{\"typography\":{\"color\":\"${theme.colors.5|variantGray2}\"},\"padding\":{\"top\":{\"value\":\"10\",\"unit\":\"px\"},\"right\":{\"value\":\"10\",\"unit\":\"px\"},\"bottom\":{\"value\":\"10\",\"unit\":\"px\"},\"left\":{\"value\":\"10\",\"unit\":\"px\"}},\"border\":{\"top\":{\"style\":\"solid\",\"width\":{\"value\":\"0\",\"unit\":\"px\"},\"color\":\"${theme.colors.5|variantGray4}\"},\"right\":{\"style\":\"solid\",\"width\":{\"value\":\"0\",\"unit\":\"px\"},\"color\":\"${theme.colors.5|variantGray4}\"},\"bottom\":{\"style\":\"solid\",\"width\":{\"value\":\"1\",\"unit\":\"px\"},\"color\":\"${theme.colors.5|variantGray4}\"},\"left\":{\"style\":\"solid\",\"width\":{\"value\":\"0\",\"unit\":\"px\"},\"color\":\"${theme.colors.5|variantGray4}\"}}},\"submit-button\":{\"background\":{\"color\":\"${theme.colors.0}\"},\"padding\":{\"top\":{\"value\":\"20\",\"unit\":\"px\"},\"right\":{\"value\":\"40\",\"unit\":\"px\"},\"bottom\":{\"value\":\"20\",\"unit\":\"px\"},\"left\":{\"value\":\"40\",\"unit\":\"px\"}},\"typography\":{\"color\":\"${theme.colors.4}\",\"size\":{\"unit\":\"px\",\"value\":\"12\"},\"transform\":\"uppercase\",\"letterSpacing\":{\"unit\":\"px\",\"value\":\"2\"},\"weight\":\"600\"},\"border\":{\"top\":{\"radius\":{\"left\":{\"value\":\"5\",\"unit\":\"px\"},\"right\":{\"value\":\"5\",\"unit\":\"px\"}}},\"bottom\":{\"radius\":{\"left\":{\"value\":\"5\",\"unit\":\"px\"},\"right\":{\"value\":\"5\",\"unit\":\"px\"}}}},\"margin-left\":\"auto\",\"margin-right\":\"0\",\"media\":{\"mobile\":{\"margin-left\":\"auto\",\"margin-right\":\"auto\"}},\"states\":{\"hover\":{\"background\":{\"color\":\"${theme.colors.1}\"}}}},\"error-notice\":{\"typography\":{\"color\":\"${theme.colors.5|variantGray2}\"}},\"info-notice\":{\"typography\":{\"color\":\"${theme.colors.5|variantGray2}\"}},\"success-notice\":{\"typography\":{\"color\":\"${theme.colors.5|variantGray2}\"}},\"validationErrors\":{\"background\":{\"color\":\"#F9E4E8\"},\"typography\":{\"color\":\"#E04562\",\"fontSize\":{\"unit\":\"px\",\"value\":12},\"fontWeight\":500,\"lineHeight\":{\"unit\":\"em\",\"value\":2}},\"padding\":{\"top\":{\"unit\":\"px\",\"value\":2},\"right\":{\"unit\":\"px\",\"value\":10},\"bottom\":{\"unit\":\"px\",\"value\":2},\"left\":{\"unit\":\"px\",\"value\":10}},\"margin\":{\"top\":{\"unit\":\"px\",\"value\":5},\"right\":{\"unit\":\"px\",\"value\":0},\"bottom\":{\"unit\":\"px\",\"value\":16},\"left\":{\"unit\":\"px\",\"value\":0}}}}},\"v\":\"1.1\",\"nodes\":[\"320-c15\"],\"props\":{\"compliedStyleFlags\":{\"forminator\":{\"validationError\":true}}}},{\"id\":311,\"props\":{\"layout\":{\"equalWidth\":false,\"horizontalGap\":3,\"verticalGap\":3}},\"type\":\"hop-row\",\"nodeId\":\"16-c20\",\"nodes\":[\"16-c26\"],\"v\":\"1.1\",\"style\":{\"background\":{\"type\":\"none\",\"image\":[{\"source\":{\"type\":\"image\",\"url\":\"http:\\/\\/localhost\\/wordpress\\/wp-content\\/uploads\\/2024\\/09\\/cropped-cropped-logoKaribea1-1-1.png\"}}]}}},{\"id\":312,\"type\":\"hop-column\",\"nodeId\":\"16-c21\",\"nodes\":[\"16-c27\"],\"style\":{\"background\":{\"color\":\"rgba(0,0,0,0)\"},\"padding\":{\"left\":{\"unit\":\"px\",\"value\":\"\"},\"right\":{\"unit\":\"px\",\"value\":\"\"},\"top\":{\"unit\":\"px\",\"value\":\"\"},\"bottom\":{\"unit\":\"px\",\"value\":\"\"}},\"descendants\":{\"outer\":{\"padding\":{\"left\":{\"unit\":\"px\",\"value\":\"48\"},\"right\":{\"unit\":\"px\",\"value\":\"48\"},\"top\":{\"unit\":\"px\",\"value\":\"48\"},\"bottom\":{\"unit\":\"px\",\"value\":\"48\"}}}},\"textAlign\":\"center\"},\"v\":\"1.1\",\"props\":{\"verticalAlign\":\"center\"}},{\"id\":313,\"props\":{\"headerType\":\"2\"},\"type\":\"hop-heading\",\"nodeId\":\"16-c22\",\"nodes\":[\"16-c25\"],\"style\":{\"typography\":{\"color\":\"${theme.colors.4}\"}},\"v\":\"1.1\"},{\"id\":314,\"type\":\"hop-text\",\"nodeId\":\"16-c23\",\"nodes\":[\"16-c29\"],\"style\":{\"typography\":{\"holders\":{\"p\":{\"size\":{\"unit\":\"px\",\"value\":\"22\"}}}},\"textAlign\":\"center\"},\"v\":\"1.1\",\"props\":{\"type\":\"lead\"}},{\"id\":315,\"type\":\"hop-down-arrow\",\"v\":\"1.1\",\"props\":{\"type\":\"icon\"},\"style\":{\"bottom\":{\"value\":\"20\"}},\"nodes\":[\"18-h24\"]},{\"id\":316,\"type\":\"hop-down-arrow-scroll-button-group\",\"v\":\"1.1\",\"nodes\":[\"18-h25\"]},{\"id\":317,\"type\":\"hop-down-arrow-scroll-button\",\"style\":{\"textAlign\":\"center\",\"background\":{\"color\":\"${theme.colors.0}\"},\"typography\":{\"color\":\"#fff\",\"family\":\"Open Sans\",\"margin\":{\"top\":\"\",\"bottom\":\"2rem\"},\"size\":{\"unit\":\"px\",\"value\":\"12\"},\"weight\":\"600\",\"lineHeight\":{\"value\":\"1\",\"unit\":\"\"},\"transform\":\"uppercase\",\"letterSpacing\":{\"value\":\"1\",\"unit\":\"px\"}},\"border\":{\"top\":{\"color\":\"${theme.colors.0}\",\"style\":\"solid\",\"width\":{\"value\":\"2\",\"unit\":\"px\"},\"radius\":{\"right\":{\"value\":5,\"unit\":\"px\"},\"left\":{\"value\":5,\"unit\":\"px\"}}},\"bottom\":{\"color\":\"${theme.colors.0}\",\"style\":\"solid\",\"width\":{\"value\":\"2\",\"unit\":\"px\"},\"radius\":{\"right\":{\"value\":5,\"unit\":\"px\"},\"left\":{\"value\":5,\"unit\":\"px\"}}},\"right\":{\"color\":\"${theme.colors.0}\",\"style\":\"solid\",\"width\":{\"value\":\"2\",\"unit\":\"px\"}},\"left\":{\"color\":\"${theme.colors.0}\",\"style\":\"solid\",\"width\":{\"value\":\"2\",\"unit\":\"px\"}}},\"padding\":{\"top\":{\"unit\":\"px\",\"value\":\"12\"},\"bottom\":{\"unit\":\"px\",\"value\":\"12\"},\"left\":{\"unit\":\"px\",\"value\":\"24\"},\"right\":{\"unit\":\"px\",\"value\":\"24\"}},\"states\":{\"hover\":{\"background\":{\"color\":\"${theme.colors.0|variant3}\"},\"border\":{\"top\":{\"color\":\"${theme.colors.0|variant3}\"},\"right\":{\"color\":\"${theme.colors.0|variant3}\"},\"bottom\":{\"color\":\"${theme.colors.0|variant3}\"},\"left\":{\"color\":\"${theme.colors.0|variant3}\"}}}},\"descendants\":{\"icon\":{\"size\":{\"unit\":\"px\",\"value\":\"12\"},\"margin\":{\"left\":{\"value\":\"0\",\"unit\":\"px\"},\"right\":{\"value\":\"10\",\"unit\":\"px\"}}}}},\"v\":\"1.1\",\"props\":{\"buttonSize\":\"medium\",\"buttonWidth\":\"fitToContent\"},\"nodes\":[\"18-h26\"]},{\"id\":318,\"type\":\"hop-down-arrow-scroll-icon\",\"style\":{\"descendants\":{\"icon\":{\"width\":{\"path\":\"value\",\"value\":\"40\"},\"height\":{\"path\":\"value\",\"value\":\"40\"},\"fill\":\"${theme.colors.4}\"}}},\"v\":\"1.1\",\"nodes\":[\"18-h27\"]},{\"id\":320,\"style\":{\"padding\":{\"top\":{\"unit\":\"px\",\"value\":\"\"},\"bottom\":{\"unit\":\"px\",\"value\":\"\"},\"left\":{\"unit\":\"px\",\"value\":\"\"},\"right\":{\"unit\":\"px\",\"value\":\"\"}},\"descendants\":{\"outer\":{\"padding\":{\"top\":{\"unit\":\"px\",\"value\":\"\"},\"bottom\":{\"unit\":\"px\",\"value\":\"\"},\"left\":{\"unit\":\"px\",\"value\":\"\"},\"right\":{\"unit\":\"px\",\"value\":\"\"}}}},\"media\":{\"mobile\":{\"background\":{\"color\":\"rgba(23, 37, 42, 0.48)\"}}},\"ancestor\":{\"sticky\":{\"background\":{\"type\":\"none\",\"image\":[{\"source\":{\"type\":\"image\",\"url\":\"http:\\/\\/localhost\\/wordpress\\/wp-content\\/uploads\\/2024\\/09\\/cropped-cropped-cropped-fond-logo-karibiea.png\"},\"position\":{\"x\":49.271520979229585,\"y\":52.531418120612315}}]}}}},\"props\":{\"fullBackground\":false,\"layout\":{\"equalWidth\":true,\"itemsPerRow\":1,\"horizontalGap\":0,\"verticalGap\":0,\"horizontalInnerGap\":0,\"verticalInnerGap\":0},\"media\":{\"mobile\":{\"layout\":{\"horizontalGap\":2,\"verticalGap\":2,\"horizontalInnerGap\":0,\"verticalInnerGap\":0}}}},\"type\":\"hop-row\",\"nodeId\":\"18-h33\",\"nodes\":[\"18-h3\",\"22-h3\"],\"v\":\"1.1\"},{\"id\":323,\"props\":{\"layout\":{\"equalWidth\":false,\"equalHeight\":false,\"verticalAlign\":\"center\",\"horizontalGap\":2,\"verticalGap\":2}},\"type\":\"hop-row\",\"nodeId\":\"16-c26\",\"nodes\":[\"16-c27\"],\"v\":\"1.1\",\"style\":{\"background\":{\"type\":\"none\",\"image\":[{\"source\":{\"type\":\"gradient\",\"gradient\":{\"angle\":\"120\",\"steps\":[{\"color\":\"rgba(255, 236, 210, 0.8)\",\"position\":\"0\"},{\"color\":\"rgba(252, 182, 159, 0.8)\",\"position\":\"100\"}]}},\"attachment\":\"fixed\"}]}}},{\"id\":324,\"type\":\"hop-column\",\"nodeId\":\"16-c27\",\"nodes\":[\"16-c28\"],\"v\":\"1.1\",\"style\":{\"descendants\":{\"outer\":{\"padding\":{\"left\":{\"value\":\"\",\"unit\":\"px\"},\"right\":{\"value\":\"\",\"unit\":\"px\"},\"top\":{\"value\":\"\",\"unit\":\"px\"},\"bottom\":{\"value\":\"\",\"unit\":\"px\"}}}}}},{\"id\":327,\"type\":\"hop-text\",\"nodeId\":\"16-c30\",\"nodes\":[\"16-c29\"],\"v\":\"1.1\",\"style\":{\"typography\":{\"holders\":{\"p\":{\"size\":{\"unit\":\"px\",\"value\":9},\"style\":\"normal\",\"decoration\":\"overline\",\"lineHeight\":{\"unit\":\"\",\"value\":5.3},\"letterSpacing\":{\"unit\":\"px\",\"value\":3},\"color\":\"${theme.colors.2}\"}}},\"textShadow\":{\"enabled\":true}}},{\"id\":330,\"props\":{\"layout\":{\"equalWidth\":false}},\"type\":\"hop-row\",\"nodeId\":\"16-c30\",\"nodes\":[\"16-c3\"],\"v\":\"1.1\"},{\"id\":331,\"type\":\"hop-column\",\"nodeId\":\"16-c31\",\"nodes\":[\"16-c4\"],\"v\":\"1.1\"},{\"id\":333,\"type\":\"hop-column\",\"nodeId\":\"16-c34\",\"nodes\":[\"16-c30\"],\"v\":\"1.1\"},{\"id\":341,\"type\":\"hop-text\",\"nodeId\":\"16-c42\",\"nodes\":[\"16-c5\"],\"v\":\"1.1\"},{\"id\":348,\"type\":\"hop-section\",\"nodeId\":\"16-c49\",\"nodes\":[\"16-c31\"],\"v\":\"1.1\",\"style\":{\"background\":{\"color\":\"#F5FAFD\"}}},{\"id\":349,\"props\":{\"layout\":{\"equalWidth\":false}},\"type\":\"hop-row\",\"nodeId\":\"16-c50\",\"nodes\":[\"16-c32\"],\"v\":\"1.1\"},{\"id\":350,\"type\":\"hop-column\",\"nodeId\":\"16-c51\",\"nodes\":[\"16-c33\"],\"v\":\"1.1\"},{\"id\":351,\"type\":\"hop-column\",\"nodeId\":\"16-c52\",\"nodes\":[\"16-c34\"],\"v\":\"1.1\"},{\"id\":352,\"type\":\"hop-column\",\"nodeId\":\"16-c53\",\"nodes\":[\"16-c35\"],\"v\":\"1.1\"},{\"id\":353,\"type\":\"hop-column\",\"nodeId\":\"16-c54\",\"nodes\":[\"16-c36\"],\"v\":\"1.1\"},{\"id\":354,\"type\":\"hop-column\",\"nodeId\":\"16-c55\",\"nodes\":[\"16-c37\"],\"v\":\"1.1\"},{\"id\":355,\"type\":\"hop-column\",\"nodeId\":\"16-c56\",\"nodes\":[\"16-c38\"],\"v\":\"1.1\"},{\"id\":357,\"type\":\"hop-text\",\"nodeId\":\"16-c40\",\"nodes\":[\"16-c5\"],\"v\":\"1.1\",\"style\":{\"typography\":{\"holders\":{\"p\":{\"color\":\"${theme.colors.1|variant3}\",\"decoration\":\"overline\",\"lineHeight\":{\"unit\":\"\",\"value\":\"2\"},\"letterSpacing\":{\"unit\":\"px\",\"value\":\"1\"},\"weight\":\"400\",\"size\":{\"unit\":\"px\",\"value\":\"45\"},\"family\":\"Playfair Display\"}}},\"textAlign\":\"center\",\"textShadow\":{\"enabled\":true}},\"props\":{\"type\":\"normal\"}},{\"id\":360,\"type\":\"hop-text\",\"nodeId\":\"16-c43\",\"nodes\":[\"16-c13\"],\"v\":\"1.1\",\"style\":{\"typography\":{\"holders\":{\"p\":{\"color\":\"${theme.colors.5}\"}}}}},{\"id\":361,\"type\":\"hop-section\",\"nodeId\":\"16-c44\",\"nodes\":[\"16-c38\"],\"v\":\"1.1\",\"style\":{\"background\":{\"color\":\"#F5FAFD\"}}},{\"id\":362,\"props\":{\"layout\":{\"equalWidth\":false}},\"type\":\"hop-row\",\"nodeId\":\"16-c45\",\"nodes\":[\"16-c36\"],\"v\":\"1.1\"},{\"id\":363,\"type\":\"hop-column\",\"nodeId\":\"16-c46\",\"nodes\":[\"16-c37\"],\"v\":\"1.1\"},{\"id\":364,\"props\":{\"layout\":{\"equalWidth\":false,\"horizontalGap\":0,\"verticalGap\":0}},\"type\":\"hop-row\",\"nodeId\":\"16-c47\",\"nodes\":[\"16-c39\"],\"v\":\"1.1\"},{\"id\":365,\"type\":\"hop-column\",\"nodeId\":\"16-c48\",\"nodes\":[\"16-c46\"],\"v\":\"1.1\",\"style\":{\"descendants\":{\"outer\":{\"padding\":{\"left\":{\"unit\":\"px\",\"value\":\"\"},\"right\":{\"unit\":\"px\",\"value\":\"\"},\"top\":{\"unit\":\"px\",\"value\":\"\"},\"bottom\":{\"unit\":\"px\",\"value\":\"\"}}}},\"padding\":{\"left\":{\"unit\":\"px\",\"value\":\"\"},\"right\":{\"unit\":\"px\",\"value\":\"\"},\"top\":{\"unit\":\"px\",\"value\":\"\"},\"bottom\":{\"unit\":\"px\",\"value\":\"\"}}},\"props\":{\"verticalAlign\":\"center\",\"layout\":{\"horizontalInnerGap\":0,\"verticalInnerGap\":0,\"vSpace\":{\"value\":33}}}},{\"id\":366,\"type\":\"hop-heading\",\"nodeId\":\"16-c49\",\"nodes\":[\"16-c47\"],\"v\":\"1.1\",\"style\":{\"typography\":{\"color\":\"${theme.colors.5|variant2}\",\"size\":{\"unit\":\"em\",\"value\":4.5}},\"textAlign\":\"center\"},\"props\":{\"headerType\":\"1\",\"fancy\":{\"fancyWord\":\"99\\u20ac TTC\",\"typeStyle\":\"rotating\",\"fancyRotatingWords\":\"seulement !!!\",\"animationDuration\":{\"value\":1.6}}}},{\"id\":367,\"type\":\"hop-column\",\"nodeId\":\"16-c50\",\"nodes\":[\"16-c40\"],\"v\":\"1.1\",\"props\":{\"verticalAlign\":\"center\"}},{\"id\":368,\"type\":\"hop-text\",\"nodeId\":\"16-c51\",\"nodes\":[\"16-c41\"],\"v\":\"1.1\",\"style\":{\"textAlign\":\"left\"}},{\"id\":369,\"type\":\"hop-text\",\"v\":\"1.1\",\"nodes\":[\"16-c17\"],\"style\":{\"typography\":{\"holders\":{\"p\":{\"color\":\"${theme.colors.5}\"}}}},\"nodeId\":\"16-c14\"},{\"id\":370,\"type\":\"hop-text\",\"v\":\"1.1\",\"nodes\":[\"16-c25\"],\"style\":{\"typography\":{\"holders\":{\"p\":{\"color\":\"${theme.colors.5}\"}}}},\"nodeId\":\"16-c22\"},{\"id\":371,\"type\":\"hop-heading\",\"style\":{\"typography\":{\"transform\":\"uppercase\",\"letterSpacing\":{\"unit\":\"px\",\"value\":\"1\"},\"color\":\"${theme.colors.4}\"}},\"props\":{\"headerType\":\"5\"},\"v\":\"1.1\",\"nodes\":[\"16-c16\"],\"nodeId\":\"16-c13\"},{\"id\":372,\"type\":\"hop-heading\",\"style\":{\"typography\":{\"transform\":\"uppercase\",\"letterSpacing\":{\"unit\":\"px\",\"value\":\"1\"},\"color\":\"${theme.colors.4}\"}},\"props\":{\"headerType\":\"5\"},\"v\":\"1.1\",\"nodes\":[\"16-c20\"],\"nodeId\":\"16-c17\"},{\"id\":373,\"type\":\"hop-heading\",\"style\":{\"typography\":{\"transform\":\"uppercase\",\"letterSpacing\":{\"unit\":\"px\",\"value\":\"1\"},\"color\":\"${theme.colors.4}\"}},\"props\":{\"headerType\":\"5\"},\"v\":\"1.1\",\"nodes\":[\"16-c12\"],\"nodeId\":\"16-c9\"},{\"id\":374,\"type\":\"hop-icon\",\"style\":{\"descendants\":{\"icon\":{\"fill\":\"${theme.colors.4}\",\"width\":{\"path\":\"value\",\"value\":\"64\"},\"height\":{\"path\":\"value\",\"value\":\"64\"},\"border\":{\"top\":{\"style\":\"none\",\"width\":{\"value\":\"2\",\"unit\":\"px\"},\"color\":\"${theme.colors.1}\",\"radius\":{\"left\":{\"value\":\"300\",\"unit\":\"px\"},\"right\":{\"value\":\"300\",\"unit\":\"px\"}}},\"right\":{\"style\":\"none\",\"width\":{\"value\":\"2\",\"unit\":\"px\"},\"color\":\"${theme.colors.1}\"},\"bottom\":{\"style\":\"none\",\"width\":{\"value\":\"2\",\"unit\":\"px\"},\"color\":\"${theme.colors.1}\",\"radius\":{\"left\":{\"value\":\"300\",\"unit\":\"px\"},\"right\":{\"value\":\"300\",\"unit\":\"px\"}}},\"left\":{\"style\":\"none\",\"width\":{\"value\":\"2\",\"unit\":\"px\"},\"color\":\"${theme.colors.1}\"}},\"padding\":{\"top\":{\"path\":\"value\",\"value\":\"11\"},\"left\":{\"path\":\"value\",\"value\":\"11\"},\"right\":{\"path\":\"value\",\"value\":\"11\"},\"bottom\":{\"path\":\"value\",\"value\":\"11\"}}}}},\"v\":\"1.1\",\"nodes\":[\"16-c15\"],\"nodeId\":\"16-c12\"},{\"id\":375,\"type\":\"hop-icon\",\"style\":{\"descendants\":{\"icon\":{\"fill\":\"${theme.colors.4}\",\"width\":{\"path\":\"value\",\"value\":\"64\"},\"height\":{\"path\":\"value\",\"value\":\"64\"},\"border\":{\"top\":{\"style\":\"none\",\"width\":{\"value\":\"2\",\"unit\":\"px\"},\"color\":\"${theme.colors.1}\",\"radius\":{\"left\":{\"value\":\"300\",\"unit\":\"px\"},\"right\":{\"value\":\"300\",\"unit\":\"px\"}}},\"right\":{\"style\":\"none\",\"width\":{\"value\":\"2\",\"unit\":\"px\"},\"color\":\"${theme.colors.1}\"},\"bottom\":{\"style\":\"none\",\"width\":{\"value\":\"2\",\"unit\":\"px\"},\"color\":\"${theme.colors.1}\",\"radius\":{\"left\":{\"value\":\"300\",\"unit\":\"px\"},\"right\":{\"value\":\"300\",\"unit\":\"px\"}}},\"left\":{\"style\":\"none\",\"width\":{\"value\":\"2\",\"unit\":\"px\"},\"color\":\"${theme.colors.1}\"}},\"padding\":{\"top\":{\"path\":\"value\",\"value\":\"11\"},\"left\":{\"path\":\"value\",\"value\":\"11\"},\"right\":{\"path\":\"value\",\"value\":\"11\"},\"bottom\":{\"path\":\"value\",\"value\":\"11\"}}}}},\"v\":\"1.1\",\"nodes\":[\"16-c19\"],\"nodeId\":\"16-c16\"},{\"id\":376,\"type\":\"hop-icon\",\"style\":{\"descendants\":{\"icon\":{\"fill\":\"${theme.colors.4}\",\"width\":{\"path\":\"value\",\"value\":\"64\"},\"height\":{\"path\":\"value\",\"value\":\"64\"},\"border\":{\"top\":{\"style\":\"none\",\"width\":{\"value\":\"2\",\"unit\":\"px\"},\"color\":\"${theme.colors.1}\",\"radius\":{\"left\":{\"value\":\"300\",\"unit\":\"px\"},\"right\":{\"value\":\"300\",\"unit\":\"px\"}}},\"right\":{\"style\":\"none\",\"width\":{\"value\":\"2\",\"unit\":\"px\"},\"color\":\"${theme.colors.1}\"},\"bottom\":{\"style\":\"none\",\"width\":{\"value\":\"2\",\"unit\":\"px\"},\"color\":\"${theme.colors.1}\",\"radius\":{\"left\":{\"value\":\"300\",\"unit\":\"px\"},\"right\":{\"value\":\"300\",\"unit\":\"px\"}}},\"left\":{\"style\":\"none\",\"width\":{\"value\":\"2\",\"unit\":\"px\"},\"color\":\"${theme.colors.1}\"}},\"padding\":{\"top\":{\"path\":\"value\",\"value\":\"11\"},\"left\":{\"path\":\"value\",\"value\":\"11\"},\"right\":{\"path\":\"value\",\"value\":\"11\"},\"bottom\":{\"path\":\"value\",\"value\":\"11\"}}}}},\"v\":\"1.1\",\"nodes\":[\"16-c23\"],\"nodeId\":\"16-c20\"},{\"id\":377,\"type\":\"hop-column\",\"nodeId\":\"16-c38\",\"nodes\":[\"16-c32\"],\"v\":\"1.1\",\"props\":{\"verticalAlign\":\"center\"},\"style\":{\"descendants\":{\"outer\":{\"padding\":{\"left\":{\"unit\":\"px\",\"value\":\"48\"},\"right\":{\"unit\":\"px\",\"value\":\"48\"},\"top\":{\"unit\":\"px\",\"value\":\"48\"},\"bottom\":{\"unit\":\"px\",\"value\":\"48\"}}}}}},{\"id\":379,\"props\":{\"layout\":{\"equalWidth\":false}},\"type\":\"hop-row\",\"nodeId\":\"16-c40\",\"nodes\":[\"16-c29\"],\"v\":\"1.1\"},{\"id\":380,\"type\":\"hop-column\",\"nodeId\":\"16-c41\",\"nodes\":[\"16-c30\"],\"v\":\"1.1\"},{\"id\":382,\"type\":\"hop-spacer\",\"nodeId\":\"16-c43\",\"nodes\":[\"16-c31\"],\"v\":\"1.1\"},{\"id\":384,\"props\":{\"layout\":{\"equalWidth\":false}},\"type\":\"hop-row\",\"nodeId\":\"16-c45\",\"nodes\":[\"16-c3\"],\"v\":\"1.1\"},{\"id\":385,\"type\":\"hop-column\",\"nodeId\":\"16-c46\",\"nodes\":[\"16-c4\"],\"v\":\"1.1\"},{\"id\":387,\"type\":\"hop-heading\",\"nodeId\":\"16-c48\",\"nodes\":[\"16-c5\"],\"v\":\"1.1\",\"style\":{\"typography\":{\"size\":{\"unit\":\"em\",\"value\":1.5},\"color\":\"${theme.colors.5|variant2}\"},\"textShadow\":{\"enabled\":true,\"x\":\"0\",\"y\":32,\"blur\":37}}},{\"id\":394,\"type\":\"hop-section\",\"props\":{\"showHeader\":true},\"v\":\"1.1\",\"nodes\":[\"16-c43\"]},{\"id\":395,\"props\":{\"layout\":{\"equalWidth\":true,\"itemsPerRow\":4},\"media\":{\"mobile\":{\"layout\":{\"horizontalGap\":2,\"itemsPerRow\":2}}}},\"type\":\"hop-row\",\"v\":\"1.1\",\"nodes\":[\"16-c44\"]},{\"id\":396,\"type\":\"hop-column\",\"props\":{\"horizontalTextAlign\":\"center\",\"height\":{\"type\":\"fit-to-content\"},\"verticalAlign\":\"start\",\"layout\":{\"horizontalInnerGap\":0,\"verticalInnerGap\":0},\"media\":{\"mobile\":{\"layout\":{\"horizontalInnerGap\":0,\"verticalInnerGap\":2}}}},\"style\":{\"descendants\":{\"outer\":{\"media\":{\"mobile\":{\"padding\":{\"left\":{\"unit\":\"px\",\"value\":\"\"},\"right\":{\"unit\":\"px\",\"value\":\"\"}}}}}}},\"v\":\"1.1\",\"nodes\":[\"16-c45\",\"16-c48\",\"16-c51\",\"16-c54\"]},{\"id\":397,\"style\":{\"descendants\":{\"inner\":{\"background\":{\"color\":\"${theme.colors.4}\"},\"border\":{\"top\":{\"style\":\"solid\",\"width\":{\"path\":\"value\",\"value\":2},\"radius\":{\"right\":{\"path\":\"value\",\"value\":176},\"left\":{\"path\":\"value\",\"value\":176}},\"color\":\"${theme.colors.1}\"},\"left\":{\"style\":\"solid\",\"width\":{\"path\":\"value\",\"value\":2},\"color\":\"${theme.colors.1}\"},\"right\":{\"style\":\"solid\",\"width\":{\"path\":\"value\",\"value\":2},\"color\":\"${theme.colors.1}\"},\"bottom\":{\"style\":\"solid\",\"width\":{\"path\":\"value\",\"value\":2},\"radius\":{\"right\":{\"path\":\"value\",\"value\":176},\"left\":{\"path\":\"value\",\"value\":176}},\"color\":\"${theme.colors.1}\"}},\"padding\":{\"top\":{\"path\":\"value\",\"value\":25},\"left\":{\"path\":\"value\",\"value\":25},\"right\":{\"path\":\"value\",\"value\":25},\"bottom\":{\"path\":\"value\",\"value\":25}},\"width\":{\"path\":\"value\",\"value\":\"100\"},\"fill\":\"${theme.colors.0}\",\"states\":{\"hover\":{\"fill\":\"${theme.colors.3}\"}},\"transform\":{\"rotate\":{\"2d\":{\"path\":\"value\",\"value\":118}}}},\"icon\":{\"border\":{\"top\":{\"radius\":{\"right\":{\"path\":\"value\",\"value\":\"9\"},\"left\":{\"path\":\"value\",\"value\":\"9\"}},\"style\":\"solid\",\"color\":\"${theme.colors.2}\",\"width\":{\"path\":\"value\",\"value\":\"2\"}},\"bottom\":{\"radius\":{\"right\":{\"path\":\"value\",\"value\":\"9\"},\"left\":{\"path\":\"value\",\"value\":\"9\"}},\"style\":\"solid\",\"color\":\"${theme.colors.2}\",\"width\":{\"path\":\"value\",\"value\":\"2\"}},\"left\":{\"style\":\"solid\",\"color\":\"${theme.colors.2}\",\"width\":{\"path\":\"value\",\"value\":\"2\"}},\"right\":{\"style\":\"solid\",\"color\":\"${theme.colors.2}\",\"width\":{\"path\":\"value\",\"value\":\"2\"}}},\"width\":{\"path\":\"value\",\"value\":\"48\"},\"height\":{\"path\":\"value\",\"value\":\"48\"},\"fill\":\"${theme.colors.2}\",\"states\":{\"hover\":{\"background\":{\"color\":\"${theme.colors.0}\"},\"fill\":\"${theme.colors.4}\"}},\"padding\":{\"top\":{\"path\":\"value\",\"value\":\"15\"},\"left\":{\"path\":\"value\",\"value\":\"15\"},\"right\":{\"path\":\"value\",\"value\":\"15\"},\"bottom\":{\"path\":\"value\",\"value\":\"15\"}}}},\"transition\":{\"duration\":{\"value\":\"0.5\"}}},\"scope\":\"local\",\"type\":\"hop-icon\",\"v\":\"1.1\",\"nodes\":[\"16-c46\"]},{\"id\":398,\"type\":\"hop-heading\",\"props\":{\"headerType\":\"4\",\"horizontalTextAlign\":\"center\"},\"v\":\"1.1\",\"nodes\":[\"16-c47\"],\"style\":{\"typography\":{\"color\":\"${theme.colors.2}\"}}},{\"id\":399,\"props\":{\"layout\":{\"equalWidth\":false}},\"type\":\"hop-row\",\"v\":\"1.1\",\"nodes\":[\"16-c57\"]},{\"id\":400,\"type\":\"hop-column\",\"v\":\"1.1\",\"nodes\":[\"16-c58\"]},{\"id\":401,\"props\":{\"headerType\":\"2\"},\"type\":\"hop-heading\",\"v\":\"1.1\",\"nodes\":[\"16-c5\"]},{\"id\":402,\"type\":\"hop-text\",\"props\":{\"type\":\"lead\"},\"v\":\"1.1\",\"nodes\":[\"16-c8\"],\"style\":{\"typography\":{\"holders\":{\"p\":{\"size\":{\"unit\":\"em\",\"value\":\"1.3\"}}}}}},{\"id\":404,\"style\":{\"descendants\":{\"inner\":{\"background\":{\"color\":\"${theme.colors.4}\"},\"border\":{\"top\":{\"style\":\"solid\",\"width\":{\"path\":\"value\",\"value\":2},\"radius\":{\"right\":{\"path\":\"value\",\"value\":176},\"left\":{\"path\":\"value\",\"value\":176}},\"color\":\"${theme.colors.1}\"},\"left\":{\"style\":\"solid\",\"width\":{\"path\":\"value\",\"value\":2},\"color\":\"${theme.colors.1}\"},\"right\":{\"style\":\"solid\",\"width\":{\"path\":\"value\",\"value\":2},\"color\":\"${theme.colors.1}\"},\"bottom\":{\"style\":\"solid\",\"width\":{\"path\":\"value\",\"value\":2},\"radius\":{\"right\":{\"path\":\"value\",\"value\":176},\"left\":{\"path\":\"value\",\"value\":176}},\"color\":\"${theme.colors.1}\"}},\"padding\":{\"top\":{\"path\":\"value\",\"value\":25},\"left\":{\"path\":\"value\",\"value\":25},\"right\":{\"path\":\"value\",\"value\":25},\"bottom\":{\"path\":\"value\",\"value\":25}},\"width\":{\"path\":\"value\",\"value\":\"100\"},\"fill\":\"${theme.colors.0}\",\"states\":{\"hover\":{\"fill\":\"${theme.colors.3}\"}},\"transform\":{\"rotate\":{\"2d\":{\"path\":\"value\",\"value\":118}}}},\"icon\":{\"border\":{\"top\":{\"radius\":{\"right\":{\"path\":\"value\",\"value\":\"9\"},\"left\":{\"path\":\"value\",\"value\":\"9\"}},\"style\":\"solid\",\"color\":\"rgb(246, 231, 10)\",\"width\":{\"path\":\"value\",\"value\":\"2\"}},\"bottom\":{\"radius\":{\"right\":{\"path\":\"value\",\"value\":\"9\"},\"left\":{\"path\":\"value\",\"value\":\"9\"}},\"style\":\"solid\",\"color\":\"rgb(246, 231, 10)\",\"width\":{\"path\":\"value\",\"value\":\"2\"}},\"left\":{\"style\":\"solid\",\"color\":\"rgb(246, 231, 10)\",\"width\":{\"path\":\"value\",\"value\":\"2\"}},\"right\":{\"style\":\"solid\",\"color\":\"rgb(246, 231, 10)\",\"width\":{\"path\":\"value\",\"value\":\"2\"}}},\"width\":{\"path\":\"value\",\"value\":\"48\"},\"height\":{\"path\":\"value\",\"value\":\"48\"},\"fill\":\"rgb(246, 231, 10)\",\"states\":{\"hover\":{\"background\":{\"color\":\"${theme.colors.0}\"},\"fill\":\"${theme.colors.4}\"}},\"padding\":{\"top\":{\"path\":\"value\",\"value\":\"15\"},\"left\":{\"path\":\"value\",\"value\":\"15\"},\"right\":{\"path\":\"value\",\"value\":\"15\"},\"bottom\":{\"path\":\"value\",\"value\":\"15\"}}}},\"transition\":{\"duration\":{\"value\":\"0.5\"}}},\"scope\":\"local\",\"type\":\"hop-icon\",\"v\":\"1.1\",\"nodes\":[\"16-c49\"],\"nodeId\":\"16-c49\"},{\"id\":405,\"style\":{\"descendants\":{\"inner\":{\"background\":{\"color\":\"${theme.colors.4}\"},\"border\":{\"top\":{\"style\":\"solid\",\"width\":{\"path\":\"value\",\"value\":2},\"radius\":{\"right\":{\"path\":\"value\",\"value\":176},\"left\":{\"path\":\"value\",\"value\":176}},\"color\":\"${theme.colors.1}\"},\"left\":{\"style\":\"solid\",\"width\":{\"path\":\"value\",\"value\":2},\"color\":\"${theme.colors.1}\"},\"right\":{\"style\":\"solid\",\"width\":{\"path\":\"value\",\"value\":2},\"color\":\"${theme.colors.1}\"},\"bottom\":{\"style\":\"solid\",\"width\":{\"path\":\"value\",\"value\":2},\"radius\":{\"right\":{\"path\":\"value\",\"value\":176},\"left\":{\"path\":\"value\",\"value\":176}},\"color\":\"${theme.colors.1}\"}},\"padding\":{\"top\":{\"path\":\"value\",\"value\":25},\"left\":{\"path\":\"value\",\"value\":25},\"right\":{\"path\":\"value\",\"value\":25},\"bottom\":{\"path\":\"value\",\"value\":25}},\"width\":{\"path\":\"value\",\"value\":\"100\"},\"fill\":\"${theme.colors.0}\",\"states\":{\"hover\":{\"fill\":\"${theme.colors.3}\"}},\"transform\":{\"rotate\":{\"2d\":{\"path\":\"value\",\"value\":118}}}},\"icon\":{\"border\":{\"top\":{\"radius\":{\"right\":{\"path\":\"value\",\"value\":\"9\"},\"left\":{\"path\":\"value\",\"value\":\"9\"}},\"style\":\"solid\",\"color\":\"${theme.colors.1}\",\"width\":{\"path\":\"value\",\"value\":\"2\"}},\"bottom\":{\"radius\":{\"right\":{\"path\":\"value\",\"value\":\"9\"},\"left\":{\"path\":\"value\",\"value\":\"9\"}},\"style\":\"solid\",\"color\":\"${theme.colors.1}\",\"width\":{\"path\":\"value\",\"value\":\"2\"}},\"left\":{\"style\":\"solid\",\"color\":\"${theme.colors.1}\",\"width\":{\"path\":\"value\",\"value\":\"2\"}},\"right\":{\"style\":\"solid\",\"color\":\"${theme.colors.1}\",\"width\":{\"path\":\"value\",\"value\":\"2\"}}},\"width\":{\"path\":\"value\",\"value\":\"48\"},\"height\":{\"path\":\"value\",\"value\":\"48\"},\"fill\":\"${theme.colors.1}\",\"states\":{\"hover\":{\"background\":{\"color\":\"${theme.colors.0}\"},\"fill\":\"${theme.colors.4}\"}},\"padding\":{\"top\":{\"path\":\"value\",\"value\":\"15\"},\"left\":{\"path\":\"value\",\"value\":\"15\"},\"right\":{\"path\":\"value\",\"value\":\"15\"},\"bottom\":{\"path\":\"value\",\"value\":\"15\"}}}},\"transition\":{\"duration\":{\"value\":\"0.5\"}}},\"scope\":\"local\",\"type\":\"hop-icon\",\"v\":\"1.1\",\"nodes\":[\"16-c52\"],\"nodeId\":\"16-c52\"},{\"id\":406,\"style\":{\"descendants\":{\"inner\":{\"background\":{\"color\":\"${theme.colors.4}\"},\"border\":{\"top\":{\"style\":\"solid\",\"width\":{\"path\":\"value\",\"value\":2},\"radius\":{\"right\":{\"path\":\"value\",\"value\":176},\"left\":{\"path\":\"value\",\"value\":176}},\"color\":\"${theme.colors.1}\"},\"left\":{\"style\":\"solid\",\"width\":{\"path\":\"value\",\"value\":2},\"color\":\"${theme.colors.1}\"},\"right\":{\"style\":\"solid\",\"width\":{\"path\":\"value\",\"value\":2},\"color\":\"${theme.colors.1}\"},\"bottom\":{\"style\":\"solid\",\"width\":{\"path\":\"value\",\"value\":2},\"radius\":{\"right\":{\"path\":\"value\",\"value\":176},\"left\":{\"path\":\"value\",\"value\":176}},\"color\":\"${theme.colors.1}\"}},\"padding\":{\"top\":{\"path\":\"value\",\"value\":25},\"left\":{\"path\":\"value\",\"value\":25},\"right\":{\"path\":\"value\",\"value\":25},\"bottom\":{\"path\":\"value\",\"value\":25}},\"width\":{\"path\":\"value\",\"value\":\"100\"},\"fill\":\"${theme.colors.0}\",\"states\":{\"hover\":{\"fill\":\"${theme.colors.3}\"}},\"transform\":{\"rotate\":{\"2d\":{\"path\":\"value\",\"value\":118}}}},\"icon\":{\"border\":{\"top\":{\"radius\":{\"right\":{\"path\":\"value\",\"value\":\"9\"},\"left\":{\"path\":\"value\",\"value\":\"9\"}},\"style\":\"solid\",\"color\":\"rgb(15, 190, 176)\",\"width\":{\"path\":\"value\",\"value\":\"2\"}},\"bottom\":{\"radius\":{\"right\":{\"path\":\"value\",\"value\":\"9\"},\"left\":{\"path\":\"value\",\"value\":\"9\"}},\"style\":\"solid\",\"color\":\"rgb(15, 190, 176)\",\"width\":{\"path\":\"value\",\"value\":\"2\"}},\"left\":{\"style\":\"solid\",\"color\":\"rgb(15, 190, 176)\",\"width\":{\"path\":\"value\",\"value\":\"2\"}},\"right\":{\"style\":\"solid\",\"color\":\"rgb(15, 190, 176)\",\"width\":{\"path\":\"value\",\"value\":\"2\"}}},\"width\":{\"path\":\"value\",\"value\":\"48\"},\"height\":{\"path\":\"value\",\"value\":\"48\"},\"fill\":\"rgb(15, 190, 176)\",\"states\":{\"hover\":{\"background\":{\"color\":\"${theme.colors.0}\"},\"fill\":\"${theme.colors.4}\"}},\"padding\":{\"top\":{\"path\":\"value\",\"value\":\"15\"},\"left\":{\"path\":\"value\",\"value\":\"15\"},\"right\":{\"path\":\"value\",\"value\":\"15\"},\"bottom\":{\"path\":\"value\",\"value\":\"15\"}}}},\"transition\":{\"duration\":{\"value\":\"0.5\"}}},\"scope\":\"local\",\"type\":\"hop-icon\",\"v\":\"1.1\",\"nodes\":[\"16-c55\"],\"nodeId\":\"16-c55\"},{\"id\":407,\"type\":\"hop-heading\",\"props\":{\"headerType\":\"4\",\"horizontalTextAlign\":\"center\"},\"v\":\"1.1\",\"nodes\":[\"16-c50\"],\"style\":{\"typography\":{\"color\":\"rgb(246, 231, 10)\"}},\"nodeId\":\"16-c50\"},{\"id\":408,\"type\":\"hop-heading\",\"props\":{\"headerType\":\"4\",\"horizontalTextAlign\":\"center\"},\"v\":\"1.1\",\"nodes\":[\"16-c53\"],\"style\":{\"typography\":{\"color\":\"${theme.colors.1}\"}},\"nodeId\":\"16-c53\"},{\"id\":409,\"type\":\"hop-heading\",\"props\":{\"headerType\":\"4\",\"horizontalTextAlign\":\"center\"},\"v\":\"1.1\",\"nodes\":[\"16-c56\"],\"style\":{\"typography\":{\"color\":\"rgb(15, 190, 176)\"}},\"nodeId\":\"16-c56\"},{\"id\":411,\"props\":{\"layout\":{\"equalWidth\":false}},\"type\":\"hop-row\",\"nodeId\":\"16-c63\",\"nodes\":[\"16-c3\"],\"v\":\"1.1\"},{\"id\":413,\"type\":\"hop-column\",\"nodeId\":\"16-c65\",\"nodes\":[\"16-c4\"],\"v\":\"1.1\"},{\"id\":414,\"type\":\"hop-spacer\",\"nodeId\":\"16-c66\",\"nodes\":[\"16-c5\"],\"v\":\"1.1\"},{\"id\":415,\"props\":{\"layout\":{\"equalWidth\":false}},\"type\":\"hop-row\",\"nodeId\":\"16-c67\",\"nodes\":[\"16-c6\"],\"v\":\"1.1\"},{\"id\":416,\"type\":\"hop-column\",\"nodeId\":\"16-c68\",\"nodes\":[\"16-c7\"],\"v\":\"1.1\"},{\"id\":417,\"type\":\"hop-section\",\"props\":{\"showHeader\":true},\"v\":\"1.1\",\"nodes\":[\"16-c50\"],\"style\":{\"background\":{\"color\":\"rgba(251, 192, 45, 0.27)\"}}},{\"id\":418,\"props\":{\"layout\":{\"equalWidth\":true,\"itemsPerRow\":4,\"horizontalInnerGap\":0,\"verticalInnerGap\":0,\"horizontalGap\":0,\"verticalGap\":0},\"media\":{\"mobile\":{\"layout\":{\"horizontalGap\":2,\"itemsPerRow\":2}}}},\"type\":\"hop-row\",\"v\":\"1.1\",\"nodes\":[\"16-c51\"]},{\"id\":419,\"type\":\"hop-column\",\"props\":{\"horizontalTextAlign\":\"center\",\"height\":{\"type\":\"fit-to-content\"},\"verticalAlign\":\"start\",\"layout\":{\"horizontalInnerGap\":0,\"verticalInnerGap\":0},\"media\":{\"mobile\":{\"layout\":{\"horizontalInnerGap\":0,\"verticalInnerGap\":2}}}},\"style\":{\"descendants\":{\"outer\":{\"media\":{\"mobile\":{\"padding\":{\"left\":{\"unit\":\"px\",\"value\":\"\"},\"right\":{\"unit\":\"px\",\"value\":\"\"}}}},\"padding\":{\"left\":{\"unit\":\"px\",\"value\":\"\"},\"right\":{\"unit\":\"px\",\"value\":\"\"},\"top\":{\"unit\":\"px\",\"value\":\"\"},\"bottom\":{\"unit\":\"px\",\"value\":\"\"}}}},\"padding\":{\"left\":{\"unit\":\"px\",\"value\":\"\"},\"right\":{\"unit\":\"px\",\"value\":\"\"},\"top\":{\"unit\":\"px\",\"value\":\"\"},\"bottom\":{\"unit\":\"px\",\"value\":\"\"}}},\"v\":\"1.1\",\"nodes\":[\"16-c52\",\"16-c55\",\"16-c58\",\"16-c61\"]},{\"id\":420,\"style\":{\"descendants\":{\"inner\":{\"background\":{\"color\":\"${theme.colors.4}\"},\"border\":{\"top\":{\"style\":\"solid\",\"width\":{\"path\":\"value\",\"value\":2},\"radius\":{\"right\":{\"path\":\"value\",\"value\":176},\"left\":{\"path\":\"value\",\"value\":176}},\"color\":\"${theme.colors.1}\"},\"left\":{\"style\":\"solid\",\"width\":{\"path\":\"value\",\"value\":2},\"color\":\"${theme.colors.1}\"},\"right\":{\"style\":\"solid\",\"width\":{\"path\":\"value\",\"value\":2},\"color\":\"${theme.colors.1}\"},\"bottom\":{\"style\":\"solid\",\"width\":{\"path\":\"value\",\"value\":2},\"radius\":{\"right\":{\"path\":\"value\",\"value\":176},\"left\":{\"path\":\"value\",\"value\":176}},\"color\":\"${theme.colors.1}\"}},\"padding\":{\"top\":{\"path\":\"value\",\"value\":25},\"left\":{\"path\":\"value\",\"value\":25},\"right\":{\"path\":\"value\",\"value\":25},\"bottom\":{\"path\":\"value\",\"value\":25}},\"width\":{\"path\":\"value\",\"value\":\"100\"},\"fill\":\"${theme.colors.0}\",\"states\":{\"hover\":{\"fill\":\"${theme.colors.3}\"}},\"transform\":{\"rotate\":{\"2d\":{\"path\":\"value\",\"value\":118}}}},\"icon\":{\"border\":{\"top\":{\"radius\":{\"right\":{\"path\":\"value\",\"value\":\"9\"},\"left\":{\"path\":\"value\",\"value\":\"9\"}},\"style\":\"solid\",\"color\":\"${theme.colors.5}\",\"width\":{\"path\":\"value\",\"value\":\"2\"}},\"bottom\":{\"radius\":{\"right\":{\"path\":\"value\",\"value\":\"9\"},\"left\":{\"path\":\"value\",\"value\":\"9\"}},\"style\":\"solid\",\"color\":\"${theme.colors.5}\",\"width\":{\"path\":\"value\",\"value\":\"2\"}},\"left\":{\"style\":\"solid\",\"color\":\"${theme.colors.5}\",\"width\":{\"path\":\"value\",\"value\":\"2\"}},\"right\":{\"style\":\"solid\",\"color\":\"${theme.colors.5}\",\"width\":{\"path\":\"value\",\"value\":\"2\"}}},\"width\":{\"path\":\"value\",\"value\":\"48\"},\"height\":{\"path\":\"value\",\"value\":\"48\"},\"fill\":\"${theme.colors.5}\",\"states\":{\"hover\":{\"background\":{\"color\":\"${theme.colors.0}\"},\"fill\":\"${theme.colors.4}\"}},\"padding\":{\"top\":{\"path\":\"value\",\"value\":\"15\"},\"left\":{\"path\":\"value\",\"value\":\"15\"},\"right\":{\"path\":\"value\",\"value\":\"15\"},\"bottom\":{\"path\":\"value\",\"value\":\"15\"}}}},\"transition\":{\"duration\":{\"value\":\"0.5\"}}},\"scope\":\"local\",\"type\":\"hop-icon\",\"v\":\"1.1\",\"nodes\":[\"16-c53\",\"16-c56\",\"16-c59\",\"16-c62\"]},{\"id\":421,\"type\":\"hop-heading\",\"props\":{\"headerType\":\"4\",\"horizontalTextAlign\":\"center\"},\"v\":\"1.1\",\"nodes\":[\"16-c54\",\"16-c57\",\"16-c60\",\"16-c63\"]},{\"id\":426,\"type\":\"hop-heading\",\"nodeId\":\"16-c88\",\"nodes\":[\"16-c88\"],\"v\":\"1.1\",\"style\":{\"media\":{\"mobile\":[],\"tablet\":[]},\"typography\":{\"color\":\"${theme.colors.5|variant2}\"}}},{\"id\":439,\"type\":\"hop-section\",\"props\":{\"showHeader\":false},\"v\":\"1.1\",\"nodes\":[\"16-c68\"],\"style\":{\"background\":{\"color\":\"rgba(251, 192, 45, 0.26)\"}}},{\"id\":440,\"props\":{\"layout\":{\"equalWidth\":true,\"itemsPerRow\":4,\"horizontalInnerGap\":0,\"verticalInnerGap\":0,\"horizontalGap\":0,\"verticalGap\":\"custom\"},\"media\":{\"mobile\":{\"layout\":{\"horizontalGap\":2,\"itemsPerRow\":2}}}},\"type\":\"hop-row\",\"v\":\"1.1\",\"nodes\":[\"16-c69\"]},{\"id\":441,\"type\":\"hop-column\",\"props\":{\"horizontalTextAlign\":\"center\",\"height\":{\"type\":\"fit-to-content\"},\"verticalAlign\":\"start\",\"layout\":{\"horizontalInnerGap\":0,\"verticalInnerGap\":0},\"media\":{\"mobile\":{\"layout\":{\"horizontalInnerGap\":0,\"verticalInnerGap\":2}}}},\"style\":{\"descendants\":{\"outer\":{\"media\":{\"mobile\":{\"padding\":{\"left\":{\"unit\":\"px\",\"value\":\"\"},\"right\":{\"unit\":\"px\",\"value\":\"\"}}}},\"padding\":{\"left\":{\"unit\":\"px\",\"value\":\"-10\"},\"right\":{\"unit\":\"px\",\"value\":\"-10\"},\"top\":{\"unit\":\"px\",\"value\":\"-10\"},\"bottom\":{\"unit\":\"px\",\"value\":\"-10\"}}}},\"padding\":{\"left\":{\"unit\":\"px\",\"value\":\"-20\"},\"right\":{\"unit\":\"px\",\"value\":\"-20\"},\"top\":{\"unit\":\"px\",\"value\":\"-20\"},\"bottom\":{\"unit\":\"px\",\"value\":\"-20\"}}},\"v\":\"1.1\",\"nodes\":[\"16-c70\",\"16-c73\",\"16-c76\",\"16-c79\"]},{\"id\":442,\"style\":{\"descendants\":{\"inner\":{\"background\":{\"color\":\"${theme.colors.4}\"},\"border\":{\"top\":{\"style\":\"solid\",\"width\":{\"path\":\"value\",\"value\":2},\"radius\":{\"right\":{\"path\":\"value\",\"value\":176},\"left\":{\"path\":\"value\",\"value\":176}},\"color\":\"${theme.colors.1}\"},\"left\":{\"style\":\"solid\",\"width\":{\"path\":\"value\",\"value\":2},\"color\":\"${theme.colors.1}\"},\"right\":{\"style\":\"solid\",\"width\":{\"path\":\"value\",\"value\":2},\"color\":\"${theme.colors.1}\"},\"bottom\":{\"style\":\"solid\",\"width\":{\"path\":\"value\",\"value\":2},\"radius\":{\"right\":{\"path\":\"value\",\"value\":176},\"left\":{\"path\":\"value\",\"value\":176}},\"color\":\"${theme.colors.1}\"}},\"padding\":{\"top\":{\"path\":\"value\",\"value\":25},\"left\":{\"path\":\"value\",\"value\":25},\"right\":{\"path\":\"value\",\"value\":25},\"bottom\":{\"path\":\"value\",\"value\":25}},\"width\":{\"path\":\"value\",\"value\":\"100\"},\"fill\":\"${theme.colors.0}\",\"states\":{\"hover\":{\"fill\":\"${theme.colors.3}\"}},\"transform\":{\"rotate\":{\"2d\":{\"path\":\"value\",\"value\":118}}}},\"icon\":{\"border\":{\"top\":{\"radius\":{\"right\":{\"path\":\"value\",\"value\":\"9\"},\"left\":{\"path\":\"value\",\"value\":\"9\"}},\"style\":\"solid\",\"color\":\"${theme.colors.5}\",\"width\":{\"path\":\"value\",\"value\":\"2\"}},\"bottom\":{\"radius\":{\"right\":{\"path\":\"value\",\"value\":\"9\"},\"left\":{\"path\":\"value\",\"value\":\"9\"}},\"style\":\"solid\",\"color\":\"${theme.colors.5}\",\"width\":{\"path\":\"value\",\"value\":\"2\"}},\"left\":{\"style\":\"solid\",\"color\":\"${theme.colors.5}\",\"width\":{\"path\":\"value\",\"value\":\"2\"}},\"right\":{\"style\":\"solid\",\"color\":\"${theme.colors.5}\",\"width\":{\"path\":\"value\",\"value\":\"2\"}}},\"width\":{\"path\":\"value\",\"value\":\"48\"},\"height\":{\"path\":\"value\",\"value\":\"48\"},\"fill\":\"${theme.colors.5}\",\"states\":{\"hover\":{\"background\":{\"color\":\"${theme.colors.0}\"},\"fill\":\"${theme.colors.4}\"}},\"padding\":{\"top\":{\"path\":\"value\",\"value\":\"15\"},\"left\":{\"path\":\"value\",\"value\":\"15\"},\"right\":{\"path\":\"value\",\"value\":\"15\"},\"bottom\":{\"path\":\"value\",\"value\":\"15\"}}}},\"transition\":{\"duration\":{\"value\":\"0.5\"}}},\"scope\":\"local\",\"type\":\"hop-icon\",\"v\":\"1.1\",\"nodes\":[\"16-c71\",\"16-c74\",\"16-c77\",\"16-c80\"]},{\"id\":443,\"type\":\"hop-heading\",\"props\":{\"headerType\":\"4\",\"horizontalTextAlign\":\"center\"},\"v\":\"1.1\",\"nodes\":[\"16-c72\",\"16-c75\",\"16-c78\",\"16-c81\"]},{\"id\":444,\"type\":\"hop-section\",\"props\":{\"showHeader\":true},\"v\":\"1.1\",\"nodes\":[\"16-c86\"]},{\"id\":445,\"props\":{\"layout\":{\"equalWidth\":true,\"itemsPerRow\":4},\"media\":{\"mobile\":{\"layout\":{\"horizontalGap\":2,\"itemsPerRow\":2}}}},\"type\":\"hop-row\",\"v\":\"1.1\",\"nodes\":[\"16-c87\"]},{\"id\":446,\"type\":\"hop-column\",\"props\":{\"horizontalTextAlign\":\"center\",\"height\":{\"type\":\"fit-to-content\"},\"verticalAlign\":\"start\",\"layout\":{\"horizontalInnerGap\":0,\"verticalInnerGap\":0},\"media\":{\"mobile\":{\"layout\":{\"horizontalInnerGap\":0,\"verticalInnerGap\":2}}}},\"style\":{\"descendants\":{\"outer\":{\"media\":{\"mobile\":{\"padding\":{\"left\":{\"unit\":\"px\",\"value\":\"\"},\"right\":{\"unit\":\"px\",\"value\":\"\"}}}}}}},\"v\":\"1.1\",\"nodes\":[\"16-c88\",\"16-c91\",\"16-c94\",\"16-c97\"]},{\"id\":447,\"style\":{\"descendants\":{\"inner\":{\"background\":{\"color\":\"${theme.colors.4}\"},\"border\":{\"top\":{\"style\":\"solid\",\"width\":{\"path\":\"value\",\"value\":2},\"radius\":{\"right\":{\"path\":\"value\",\"value\":176},\"left\":{\"path\":\"value\",\"value\":176}},\"color\":\"${theme.colors.1}\"},\"left\":{\"style\":\"solid\",\"width\":{\"path\":\"value\",\"value\":2},\"color\":\"${theme.colors.1}\"},\"right\":{\"style\":\"solid\",\"width\":{\"path\":\"value\",\"value\":2},\"color\":\"${theme.colors.1}\"},\"bottom\":{\"style\":\"solid\",\"width\":{\"path\":\"value\",\"value\":2},\"radius\":{\"right\":{\"path\":\"value\",\"value\":176},\"left\":{\"path\":\"value\",\"value\":176}},\"color\":\"${theme.colors.1}\"}},\"padding\":{\"top\":{\"path\":\"value\",\"value\":25},\"left\":{\"path\":\"value\",\"value\":25},\"right\":{\"path\":\"value\",\"value\":25},\"bottom\":{\"path\":\"value\",\"value\":25}},\"width\":{\"path\":\"value\",\"value\":\"100\"},\"fill\":\"${theme.colors.0}\",\"states\":{\"hover\":{\"fill\":\"${theme.colors.3}\"}},\"transform\":{\"rotate\":{\"2d\":{\"path\":\"value\",\"value\":118}}}},\"icon\":{\"border\":{\"top\":{\"radius\":{\"right\":{\"path\":\"value\",\"value\":\"9\"},\"left\":{\"path\":\"value\",\"value\":\"9\"}},\"style\":\"solid\",\"color\":\"${theme.colors.0}\",\"width\":{\"path\":\"value\",\"value\":\"2\"}},\"bottom\":{\"radius\":{\"right\":{\"path\":\"value\",\"value\":\"9\"},\"left\":{\"path\":\"value\",\"value\":\"9\"}},\"style\":\"solid\",\"color\":\"${theme.colors.0}\",\"width\":{\"path\":\"value\",\"value\":\"2\"}},\"left\":{\"style\":\"solid\",\"color\":\"${theme.colors.0}\",\"width\":{\"path\":\"value\",\"value\":\"2\"}},\"right\":{\"style\":\"solid\",\"color\":\"${theme.colors.0}\",\"width\":{\"path\":\"value\",\"value\":\"2\"}}},\"width\":{\"path\":\"value\",\"value\":\"48\"},\"height\":{\"path\":\"value\",\"value\":\"48\"},\"fill\":\"${theme.colors.0}\",\"states\":{\"hover\":{\"background\":{\"color\":\"${theme.colors.0}\"},\"fill\":\"${theme.colors.4}\"}},\"padding\":{\"top\":{\"path\":\"value\",\"value\":\"15\"},\"left\":{\"path\":\"value\",\"value\":\"15\"},\"right\":{\"path\":\"value\",\"value\":\"15\"},\"bottom\":{\"path\":\"value\",\"value\":\"15\"}}}},\"transition\":{\"duration\":{\"value\":\"0.5\"}}},\"scope\":\"local\",\"type\":\"hop-icon\",\"v\":\"1.1\",\"nodes\":[\"16-c89\",\"16-c92\",\"16-c95\",\"16-c98\"]},{\"id\":448,\"type\":\"hop-heading\",\"props\":{\"headerType\":\"4\",\"horizontalTextAlign\":\"center\"},\"v\":\"1.1\",\"nodes\":[\"16-c90\",\"16-c93\",\"16-c96\",\"16-c99\"]},{\"id\":449,\"props\":{\"layout\":{\"equalWidth\":false}},\"type\":\"hop-row\",\"v\":\"1.1\",\"nodes\":[\"16-c100\"]},{\"id\":450,\"type\":\"hop-column\",\"v\":\"1.1\",\"nodes\":[\"16-c101\"]},{\"id\":463,\"props\":{\"layout\":{\"equalWidth\":false}},\"type\":\"hop-row\",\"nodeId\":\"16-c104\",\"nodes\":[\"16-c82\"],\"v\":\"1.1\"},{\"id\":464,\"type\":\"hop-column\",\"nodeId\":\"16-c105\",\"nodes\":[\"16-c83\"],\"v\":\"1.1\"},{\"id\":465,\"props\":{\"headerType\":\"2\"},\"type\":\"hop-heading\",\"nodeId\":\"16-c106\",\"nodes\":[\"16-c84\"],\"v\":\"1.1\"},{\"id\":466,\"type\":\"hop-text\",\"nodeId\":\"16-c107\",\"nodes\":[\"16-c85\"],\"v\":\"1.1\"},{\"id\":467,\"props\":{\"layout\":{\"equalWidth\":false}},\"type\":\"hop-row\",\"nodeId\":\"16-c108\",\"nodes\":[\"16-c64\"],\"v\":\"1.1\"},{\"id\":468,\"type\":\"hop-column\",\"nodeId\":\"16-c109\",\"nodes\":[\"16-c65\"],\"v\":\"1.1\"},{\"id\":469,\"props\":{\"headerType\":\"2\"},\"type\":\"hop-heading\",\"nodeId\":\"16-c110\",\"nodes\":[\"16-c66\"],\"v\":\"1.1\"},{\"id\":470,\"type\":\"hop-text\",\"nodeId\":\"16-c111\",\"nodes\":[\"16-c67\"],\"v\":\"1.1\"},{\"id\":471,\"type\":\"hop-column\",\"nodeId\":\"236-c20\",\"nodes\":[\"236-c20\"],\"v\":\"1.1\"},{\"id\":472,\"type\":\"hop-section\",\"style\":{\"padding\":{\"top\":{\"path\":\"value\",\"value\":\"0\"},\"bottom\":{\"value\":\"0\"}},\"media\":{\"mobile\":{\"margin\":{\"top\":{\"value\":\"0\",\"unit\":\"px\"},\"right\":{\"unit\":\"px\"},\"bottom\":{\"unit\":\"px\"},\"left\":{\"unit\":\"px\"}}}},\"descendants\":{\"inner\":{\"margin\":{\"top\":{\"value\":0,\"unit\":\"px\",\"path\":\"value\"}}}}},\"v\":\"1.1\",\"nodes\":[\"236-c25\"],\"props\":{\"width\":\"full-width\"}},{\"id\":473,\"props\":{\"layout\":{\"equalWidth\":true,\"itemsPerRow\":4,\"horizontalGap\":0,\"verticalGap\":0},\"media\":{\"mobile\":{\"layout\":{\"horizontalGap\":2,\"verticalGap\":2}}}},\"type\":\"hop-row\",\"style\":{\"boxShadow\":{\"enabled\":true,\"layers\":[{\"color\":\"rgba(74, 74, 74, 0.3)\",\"y\":\"4\"}]},\"media\":{\"mobile\":{\"margin\":{\"top\":{\"value\":\"15\",\"unit\":\"px\"},\"right\":{\"value\":\"15\",\"unit\":\"px\"},\"bottom\":{\"value\":\"15\",\"unit\":\"px\"},\"left\":{\"value\":\"15\",\"unit\":\"px\"}}}}},\"v\":\"1.1\",\"nodes\":[\"236-c26\"]},{\"id\":474,\"type\":\"hop-column\",\"style\":{\"textAlign\":\"center\",\"media\":{\"mobile\":{\"textAlign\":\"center\",\"padding\":{\"left\":{\"unit\":\"px\"},\"right\":{\"unit\":\"px\"},\"top\":{\"unit\":\"px\"},\"bottom\":{\"unit\":\"px\"}}},\"tablet\":{\"padding\":{\"left\":{\"unit\":\"px\"},\"right\":{\"unit\":\"px\"},\"top\":{\"unit\":\"px\"},\"bottom\":{\"unit\":\"px\"}}}},\"descendants\":{\"outer\":{\"media\":{\"mobile\":{\"padding\":{\"left\":{\"unit\":\"px\"},\"right\":{\"unit\":\"px\"},\"top\":{\"unit\":\"px\"},\"bottom\":{\"unit\":\"px\"}}}},\"padding\":{\"left\":{\"unit\":\"px\"},\"right\":{\"unit\":\"px\"},\"top\":{\"unit\":\"px\"},\"bottom\":{\"unit\":\"px\"}}}},\"padding\":{\"left\":{\"unit\":\"px\"},\"right\":{\"unit\":\"px\"},\"top\":{\"unit\":\"px\"},\"bottom\":{\"unit\":\"px\"}},\"border\":{\"top\":{\"radius\":{\"left\":{\"unit\":\"px\"},\"right\":{\"unit\":\"px\"}},\"style\":\"solid\",\"width\":{\"value\":\"0\",\"unit\":\"px\"},\"color\":\"rgb(221, 221, 221)\"},\"bottom\":{\"radius\":{\"left\":{\"unit\":\"px\"},\"right\":{\"unit\":\"px\"}},\"style\":\"solid\",\"width\":{\"value\":\"0\",\"unit\":\"px\"},\"color\":\"rgb(221, 221, 221)\"},\"right\":{\"style\":\"solid\",\"width\":{\"value\":\"1\",\"unit\":\"px\"},\"color\":\"rgb(221, 221, 221)\"},\"left\":{\"style\":\"solid\",\"width\":{\"value\":\"0\",\"unit\":\"px\"},\"color\":\"rgb(221, 221, 221)\"}}},\"props\":{\"layout\":{\"verticalInnerGap\":3,\"horizontalInnerGap\":3},\"media\":{\"mobile\":{\"layout\":{\"horizontalInnerGap\":2,\"verticalInnerGap\":2}},\"tablet\":{\"layout\":{\"horizontalInnerGap\":3,\"verticalInnerGap\":3}}},\"verticalAlign\":\"center\"},\"v\":\"1.1\",\"nodes\":[\"236-c27\",\"236-c30\",\"236-c33\"]},{\"id\":475,\"type\":\"hop-icon\",\"style\":{\"descendants\":{\"icon\":{\"fill\":\"${theme.colors.4|variant4}\",\"width\":{\"path\":\"value\",\"value\":\"64\"},\"height\":{\"path\":\"value\",\"value\":\"64\"},\"border\":{\"top\":{\"style\":\"none\",\"width\":{\"value\":\"2\",\"unit\":\"px\"},\"color\":\"${theme.colors.1}\",\"radius\":{\"left\":{\"value\":\"300\",\"unit\":\"px\"},\"right\":{\"value\":\"300\",\"unit\":\"px\"}}},\"right\":{\"style\":\"none\",\"width\":{\"value\":\"2\",\"unit\":\"px\"},\"color\":\"${theme.colors.1}\"},\"bottom\":{\"style\":\"none\",\"width\":{\"value\":\"2\",\"unit\":\"px\"},\"color\":\"${theme.colors.1}\",\"radius\":{\"left\":{\"value\":\"300\",\"unit\":\"px\"},\"right\":{\"value\":\"300\",\"unit\":\"px\"}}},\"left\":{\"style\":\"none\",\"width\":{\"value\":\"2\",\"unit\":\"px\"},\"color\":\"${theme.colors.1}\"}},\"padding\":{\"top\":{\"path\":\"value\",\"value\":\"11\"},\"left\":{\"path\":\"value\",\"value\":\"11\"},\"right\":{\"path\":\"value\",\"value\":\"11\"},\"bottom\":{\"path\":\"value\",\"value\":\"11\"}}}}},\"v\":\"1.1\",\"nodes\":[\"236-c28\",\"236-c31\",\"236-c34\",\"236-c37\"]},{\"id\":476,\"type\":\"hop-heading\",\"style\":{\"typography\":{\"transform\":\"uppercase\",\"letterSpacing\":{\"unit\":\"px\",\"value\":\"1\"}}},\"props\":{\"headerType\":\"5\"},\"v\":\"1.1\",\"nodes\":[\"236-c29\",\"236-c32\",\"236-c35\",\"236-c38\"]},{\"id\":477,\"type\":\"hop-text\",\"v\":\"1.1\",\"nodes\":[\"236-c26\",\"236-c30\",\"236-c34\",\"236-c38\"]},{\"id\":478,\"type\":\"hop-column\",\"style\":{\"textAlign\":\"center\",\"media\":{\"mobile\":{\"textAlign\":\"center\",\"padding\":{\"left\":{\"unit\":\"px\"},\"right\":{\"unit\":\"px\"},\"top\":{\"unit\":\"px\"},\"bottom\":{\"unit\":\"px\"}}},\"tablet\":{\"padding\":{\"left\":{\"unit\":\"px\"},\"right\":{\"unit\":\"px\"},\"top\":{\"unit\":\"px\"},\"bottom\":{\"unit\":\"px\"}}}},\"descendants\":{\"outer\":{\"media\":{\"mobile\":{\"padding\":{\"left\":{\"unit\":\"px\"},\"right\":{\"unit\":\"px\"},\"top\":{\"unit\":\"px\"},\"bottom\":{\"unit\":\"px\"}}}},\"padding\":{\"left\":{\"unit\":\"px\"},\"right\":{\"unit\":\"px\"},\"top\":{\"unit\":\"px\"},\"bottom\":{\"unit\":\"px\"}}}},\"padding\":{\"left\":{\"unit\":\"px\"},\"right\":{\"unit\":\"px\"},\"top\":{\"unit\":\"px\"},\"bottom\":{\"unit\":\"px\"}},\"border\":{\"top\":{\"radius\":{\"left\":{\"unit\":\"px\"},\"right\":{\"unit\":\"px\"}},\"style\":\"solid\",\"width\":{\"value\":\"0\",\"unit\":\"px\"},\"color\":\"rgb(221, 221, 221)\"},\"bottom\":{\"radius\":{\"left\":{\"unit\":\"px\"},\"right\":{\"unit\":\"px\"}},\"style\":\"solid\",\"width\":{\"value\":\"0\",\"unit\":\"px\"},\"color\":\"rgb(221, 221, 221)\"},\"right\":{\"style\":\"solid\",\"width\":{\"value\":\"0\",\"unit\":\"px\"},\"color\":\"rgb(221, 221, 221)\"},\"left\":{\"style\":\"solid\",\"width\":{\"value\":\"0\",\"unit\":\"px\"},\"color\":\"rgb(221, 221, 221)\"}}},\"props\":{\"layout\":{\"verticalInnerGap\":3,\"horizontalInnerGap\":3},\"media\":{\"mobile\":{\"layout\":{\"horizontalInnerGap\":2,\"verticalInnerGap\":2}},\"tablet\":{\"layout\":{\"horizontalInnerGap\":3,\"verticalInnerGap\":3}}},\"verticalAlign\":\"center\"},\"v\":\"1.1\",\"nodes\":[\"236-c36\"]},{\"id\":479,\"type\":\"hop-column\",\"nodeId\":\"220-c15\",\"nodes\":[\"220-c12\"],\"v\":\"1.1\"},{\"id\":480,\"type\":\"hop-image\",\"nodeId\":\"220-c16\",\"nodes\":[\"220-c13\"],\"v\":\"1.1\",\"style\":{\"descendants\":{\"image\":{\"boxShadow\":{\"enabled\":true,\"layers\":[{\"x\":\"-18\",\"y\":17,\"blur\":35,\"color\":\"${theme.colors.2|variant4}\"}]}}}}},{\"id\":486,\"type\":\"hop-column\",\"nodeId\":\"16-c102\",\"nodes\":[\"16-c30\"],\"v\":\"1.1\"},{\"id\":487,\"type\":\"hop-spacer\",\"nodeId\":\"16-c103\",\"nodes\":[\"16-c31\"],\"v\":\"1.1\"},{\"id\":489,\"type\":\"hop-heading\",\"nodeId\":\"16-c105\",\"nodes\":[\"16-c28\"],\"v\":\"1.1\",\"style\":{\"typography\":{\"color\":\"${theme.colors.1|variant3}\",\"transform\":\"capitalize\",\"weight\":\"500\",\"size\":{\"unit\":\"px\",\"value\":\"45\"}}},\"props\":{\"headerType\":\"3\"}},{\"id\":490,\"type\":\"hop-heading\",\"nodeId\":\"16-c106\",\"nodes\":[\"16-c33\"],\"v\":\"1.1\",\"style\":{\"typography\":{\"color\":\"${theme.colors.1|variant3}\",\"weight\":\"500\",\"size\":{\"unit\":\"px\",\"value\":\"45\"}}},\"props\":{\"headerType\":\"3\"}},{\"id\":491,\"type\":\"hop-text\",\"nodeId\":\"16-c107\",\"nodes\":[\"16-c34\"],\"v\":\"1.1\",\"style\":{\"typography\":{\"holders\":{\"p\":{\"size\":{\"unit\":\"px\",\"value\":\"22\"},\"color\":\"${theme.colors.5|variant2}\",\"weight\":\"300\"}}},\"textAlign\":\"center\"}},{\"id\":492,\"type\":\"hop-button-group\",\"nodeId\":\"16-c108\",\"nodes\":[\"16-c35\"],\"v\":\"1.1\"},{\"id\":494,\"type\":\"hop-button\",\"nodeId\":\"16-c110\",\"nodes\":[\"16-c36\"],\"style\":{\"textAlign\":\"center\",\"background\":{\"color\":\"${theme.colors.1}\"},\"typography\":{\"color\":\"#fff\",\"family\":\"Open Sans\",\"margin\":{\"top\":\"\",\"bottom\":\"2rem\"},\"size\":{\"unit\":\"px\",\"value\":\"14\"},\"weight\":\"600\",\"lineHeight\":{\"value\":\"1\",\"unit\":\"\"},\"transform\":\"uppercase\",\"letterSpacing\":{\"value\":\"1\",\"unit\":\"px\"}},\"border\":{\"top\":{\"style\":\"solid\",\"width\":{\"value\":\"2\",\"unit\":\"px\"},\"radius\":{\"right\":{\"value\":5,\"unit\":\"px\"},\"left\":{\"value\":5,\"unit\":\"px\"}}},\"bottom\":{\"style\":\"solid\",\"width\":{\"value\":\"2\",\"unit\":\"px\"},\"radius\":{\"right\":{\"value\":5,\"unit\":\"px\"},\"left\":{\"value\":5,\"unit\":\"px\"}}},\"right\":{\"style\":\"solid\",\"width\":{\"value\":\"2\",\"unit\":\"px\"}},\"left\":{\"style\":\"solid\",\"width\":{\"value\":\"2\",\"unit\":\"px\"}}},\"padding\":{\"top\":{\"unit\":\"px\",\"value\":\"15\"},\"bottom\":{\"unit\":\"px\",\"value\":\"15\"},\"left\":{\"unit\":\"px\",\"value\":\"30\"},\"right\":{\"unit\":\"px\",\"value\":\"30\"}},\"states\":{\"hover\":{\"background\":{\"color\":\"${theme.colors.2|variant4}\",\"type\":\"gradient\",\"image\":[{\"source\":{\"type\":\"gradient\",\"gradient\":{\"steps\":[{\"color\":\"${theme.colors.1}\",\"position\":9},{\"position\":95,\"color\":\"${theme.colors.1|variant4}\"}],\"angle\":0}}}]}}},\"descendants\":{\"icon\":{\"size\":{\"unit\":\"px\",\"value\":\"14\"},\"margin\":{\"left\":{\"value\":\"0\",\"unit\":\"px\"},\"right\":{\"value\":\"10\",\"unit\":\"px\"}}}}},\"v\":\"1.1\",\"props\":{\"buttonSize\":\"large\",\"buttonWidth\":\"fitToContent\"}},{\"id\":496,\"type\":\"hop-divider\",\"style\":{\"descendants\":{\"line\":{\"border\":{\"bottom\":{\"color\":\"${theme.colors.1|variant1}\"}}},\"icon\":{\"fill\":\"rgba(162, 94, 5, 0.29)\"}}},\"props\":{\"type\":\"icon\"},\"v\":\"1.1\",\"nodes\":[\"16-c30\"]},{\"id\":497,\"type\":\"hop-spacer\",\"nodeId\":\"16-c112\",\"nodes\":[\"16-c32\"],\"v\":\"1.1\"},{\"id\":498,\"type\":\"hop-section\",\"nodeId\":\"236-c39\",\"nodes\":[\"236-c39\"],\"v\":\"1.1\",\"style\":{\"background\":{\"color\":\"#F5FAFD\"},\"padding\":{\"top\":{\"value\":0},\"bottom\":{\"value\":0}}},\"props\":{\"width\":\"full-width\"}},{\"id\":499,\"props\":{\"layout\":{\"equalWidth\":false,\"horizontalGap\":0,\"verticalGap\":0}},\"type\":\"hop-row\",\"nodeId\":\"236-c40\",\"nodes\":[\"236-c43\"],\"v\":\"1.1\"},{\"id\":500,\"type\":\"hop-column\",\"nodeId\":\"236-c41\",\"nodes\":[\"236-c44\"],\"v\":\"1.1\",\"style\":{\"descendants\":{\"outer\":{\"padding\":{\"left\":{\"unit\":\"px\",\"value\":\"\"},\"right\":{\"unit\":\"px\",\"value\":\"\"},\"top\":{\"unit\":\"px\",\"value\":\"\"},\"bottom\":{\"unit\":\"px\",\"value\":\"\"}}}},\"customHeight\":{\"min-height\":{\"unit\":\"px\",\"value\":755.9166870117188},\"type\":\"fit-to-content\"},\"padding\":{\"left\":{\"unit\":\"px\",\"value\":\"\"},\"right\":{\"unit\":\"px\",\"value\":\"\"},\"top\":{\"unit\":\"px\",\"value\":\"\"},\"bottom\":{\"unit\":\"px\",\"value\":\"\"}},\"transform\":{\"translate\":{\"x\":{\"value\":\"0\",\"unit\":\"%\"},\"y\":{\"value\":0,\"unit\":\"%\"}}}},\"props\":{\"layout\":{\"horizontalInnerGap\":0,\"verticalInnerGap\":0,\"vSpace\":{\"value\":0}}}},{\"id\":517,\"type\":\"hop-image\",\"nodeId\":\"18-h64\",\"nodes\":[\"18-h7\",\"22-h7\"],\"v\":\"1.1\",\"style\":{\"descendants\":{\"image\":{\"opacity\":{\"value\":0.85},\"boxShadow\":{\"enabled\":true}}}}},{\"id\":519,\"props\":{\"layout\":{\"equalWidth\":true,\"equalHeight\":false,\"horizontalInnerGap\":0,\"verticalInnerGap\":0,\"horizontalGap\":0,\"verticalGap\":0,\"verticalAlign\":\"center\",\"itemsPerRow\":1}},\"type\":\"hop-row\",\"nodeId\":\"18-h66\",\"nodes\":[\"18-h5\",\"22-h5\"],\"v\":\"1.1\",\"style\":{\"background\":{\"type\":\"image\",\"image\":[{\"source\":{\"type\":\"image\",\"url\":\"http:\\/\\/localhost\\/wordpress\\/wp-content\\/uploads\\/2024\\/09\\/cropped-cropped-fond-logo-karibiea.png\"}}]},\"ancestor\":{\"sticky\":{\"background\":{\"type\":\"image\",\"image\":[{\"source\":{\"type\":\"image\",\"url\":\"http:\\/\\/localhost\\/wordpress\\/wp-content\\/uploads\\/2024\\/09\\/cropped-cropped-cropped-cropped-fond-logo-karibiea-1-1.png\"},\"position\":\"center center\"}]}}}}},{\"id\":520,\"type\":\"hop-column\",\"nodeId\":\"18-h67\",\"nodes\":[\"18-h6\",\"22-h6\"],\"v\":\"1.1\",\"style\":{\"padding\":{\"left\":{\"unit\":\"px\",\"value\":\"\"},\"right\":{\"unit\":\"px\",\"value\":\"\"},\"top\":{\"unit\":\"px\",\"value\":\"\"},\"bottom\":{\"unit\":\"px\",\"value\":\"\"}},\"descendants\":{\"outer\":{\"padding\":{\"left\":{\"unit\":\"px\",\"value\":\"9\"},\"right\":{\"unit\":\"px\",\"value\":\"9\"},\"top\":{\"unit\":\"px\",\"value\":\"9\"},\"bottom\":{\"unit\":\"px\",\"value\":\"9\"}}}}}},{\"id\":521,\"props\":{\"layout\":{\"equalWidth\":false}},\"type\":\"hop-row\",\"nodeId\":\"220-c15\",\"nodes\":[\"220-c15\"],\"v\":\"1.1\",\"style\":{\"background\":{\"color\":\"rgba(5, 127, 93, 0.8)\"}}},{\"id\":522,\"type\":\"hop-column\",\"nodeId\":\"220-c16\",\"nodes\":[\"220-c16\"],\"v\":\"1.1\",\"style\":{\"border\":{\"top\":{\"style\":\"double\",\"width\":{\"value\":\"9\",\"unit\":\"px\"},\"color\":\"${theme.colors.1|variant1}\",\"radius\":{\"left\":{\"value\":\"50\",\"unit\":\"px\"},\"right\":{\"value\":\"50\",\"unit\":\"px\"}}},\"right\":{\"style\":\"double\",\"width\":{\"value\":\"9\",\"unit\":\"px\"},\"color\":\"${theme.colors.1|variant1}\"},\"bottom\":{\"style\":\"double\",\"width\":{\"value\":\"9\",\"unit\":\"px\"},\"color\":\"${theme.colors.1|variant1}\",\"radius\":{\"left\":{\"value\":\"50\",\"unit\":\"px\"},\"right\":{\"value\":\"50\",\"unit\":\"px\"}}},\"left\":{\"style\":\"double\",\"width\":{\"value\":\"9\",\"unit\":\"px\"},\"color\":\"${theme.colors.1|variant1}\"}},\"background\":{\"color\":\"rgba(87, 87, 87, 0.46)\"}},\"props\":{\"verticalAlign\":\"start\",\"layout\":{\"vSpace\":{\"value\":28}}}},{\"id\":523,\"type\":\"hop-column\",\"nodeId\":\"220-c17\",\"nodes\":[\"220-c20\"],\"v\":\"1.1\",\"style\":{\"border\":{\"top\":{\"style\":\"double\",\"width\":{\"value\":\"9\",\"unit\":\"px\"},\"color\":\"rgb(14, 255, 218)\",\"radius\":{\"left\":{\"value\":\"50\",\"unit\":\"px\"},\"right\":{\"value\":\"50\",\"unit\":\"px\"}}},\"right\":{\"style\":\"double\",\"width\":{\"value\":\"9\",\"unit\":\"px\"},\"color\":\"rgb(14, 255, 218)\"},\"bottom\":{\"style\":\"double\",\"width\":{\"value\":\"9\",\"unit\":\"px\"},\"color\":\"rgb(14, 255, 218)\",\"radius\":{\"left\":{\"value\":\"50\",\"unit\":\"px\"},\"right\":{\"value\":\"50\",\"unit\":\"px\"}}},\"left\":{\"style\":\"double\",\"width\":{\"value\":\"9\",\"unit\":\"px\"},\"color\":\"rgb(14, 255, 218)\"}},\"background\":{\"color\":\"rgba(87, 87, 87, 0.46)\"}},\"props\":{\"layout\":{\"vSpace\":{\"value\":\"28\"}}}},{\"id\":524,\"type\":\"hop-heading\",\"nodeId\":\"220-c18\",\"nodes\":[\"220-c17\"],\"v\":\"1.1\",\"props\":{\"headerType\":\"4\"},\"style\":{\"textShadow\":{\"enabled\":false},\"typography\":{\"color\":\"${theme.colors.4}\"}}},{\"id\":525,\"type\":\"hop-text\",\"nodeId\":\"220-c19\",\"nodes\":[\"220-c18\"],\"v\":\"1.1\",\"style\":{\"typography\":{\"holders\":{\"p\":{\"style\":\"italic\",\"decoration\":\"overline\",\"color\":\"${theme.colors.4}\"}}}}},{\"id\":526,\"type\":\"hop-heading\",\"nodeId\":\"220-c20\",\"nodes\":[\"220-c21\"],\"v\":\"1.1\",\"style\":{\"typography\":{\"color\":\"${theme.colors.4}\"}},\"props\":{\"headerType\":\"4\"}},{\"id\":528,\"type\":\"hop-text\",\"nodeId\":\"220-c22\",\"nodes\":[\"220-c22\"],\"v\":\"1.1\",\"style\":{\"typography\":{\"holders\":{\"p\":{\"style\":\"italic\",\"decoration\":\"overline\",\"color\":\"${theme.colors.4}\"}}}}},{\"id\":536,\"type\":\"hop-text\",\"props\":{\"type\":\"lead\"},\"v\":\"1.1\",\"nodes\":[\"220-c23\"],\"style\":{\"typography\":{\"holders\":{\"p\":{\"color\":\"${theme.colors.5}\"}}}}},{\"id\":538,\"props\":{\"layout\":{\"equalWidth\":false}},\"type\":\"hop-row\",\"nodeId\":\"220-c24\",\"nodes\":[\"220-c6\"],\"v\":\"1.1\",\"style\":{\"background\":{\"color\":\"rgba(5, 127, 93, 0.8)\"}}},{\"id\":539,\"type\":\"hop-column\",\"nodeId\":\"220-c25\",\"nodes\":[\"220-c7\"],\"v\":\"1.1\",\"props\":{\"verticalAlign\":\"center\"}},{\"id\":540,\"type\":\"hop-column\",\"nodeId\":\"220-c26\",\"nodes\":[\"220-c9\"],\"v\":\"1.1\"},{\"id\":542,\"type\":\"hop-column\",\"nodeId\":\"220-c28\",\"nodes\":[\"220-c13\"],\"v\":\"1.1\",\"props\":{\"verticalAlign\":\"center\"}},{\"id\":547,\"type\":\"hop-heading\",\"props\":{\"headerType\":\"2\"},\"v\":\"1.1\",\"nodes\":[\"220-c14\"],\"style\":{\"textAlign\":\"center\"}},{\"id\":548,\"type\":\"hop-content-swap\",\"nodeId\":\"220-c22\",\"nodes\":[\"220-c10\"],\"v\":\"1.1\",\"style\":{\"descendants\":{\"hover\":{\"animation\":{\"duration\":{\"value\":\"10000\"}},\"background\":{\"color\":\"rgba(247, 179, 89, 0.19)\",\"type\":\"image\",\"image\":[{\"source\":{\"type\":\"image\",\"url\":\"http:\\/\\/localhost\\/wordpress\\/wp-content\\/uploads\\/2024\\/09\\/cropped-cropped-cropped-cropped-logoKaribea1-1-1-1.png\"},\"position\":{\"x\":47.29449505422365,\"y\":100},\"size\":\"contain\",\"sizeCustom\":{\"x\":{\"value\":68},\"y\":{\"value\":100}},\"repeat\":\"no-repeat\"}]},\"padding\":{\"left\":{\"value\":6},\"right\":{\"value\":6}}},\"normal\":{\"animation\":{\"duration\":{\"value\":\"10000\"}},\"background\":{\"color\":\"rgba(233, 100, 100, 0)\",\"type\":\"image\",\"image\":[{\"source\":{\"type\":\"image\",\"url\":\"http:\\/\\/localhost\\/wordpress\\/wp-content\\/uploads\\/2024\\/09\\/cropped-KARIBEACONCIERGERIE.png\"},\"position\":{\"x\":51.853555451263155,\"y\":87.47000325156965}}]},\"padding\":{\"left\":{\"value\":42},\"right\":{\"value\":42}}}},\"boxShadow\":{\"enabled\":true},\"border\":{\"top\":{\"radius\":{\"left\":{\"value\":\"15\",\"unit\":\"px\"},\"right\":{\"value\":\"15\",\"unit\":\"px\"}}},\"bottom\":{\"radius\":{\"left\":{\"value\":\"15\",\"unit\":\"px\"},\"right\":{\"value\":\"15\",\"unit\":\"px\"}}}}},\"props\":{\"hover\":{\"effect\":{\"type\":\"zoomIn\",\"direction\":\"\"}}}},{\"id\":549,\"style\":{\"textAlign\":\"center\"},\"type\":\"hop-content-swap-default\",\"nodeId\":\"220-c23\",\"nodes\":[\"220-c11\"],\"v\":\"1.1\"},{\"id\":551,\"style\":{\"textAlign\":\"center\"},\"type\":\"hop-content-swap-hover\",\"nodeId\":\"220-c25\",\"nodes\":[\"220-c12\"],\"v\":\"1.1\"},{\"id\":552,\"type\":\"hop-spacer\",\"nodeId\":\"16-c42\",\"nodes\":[\"16-c42\"],\"v\":\"1.1\",\"style\":{\"media\":{\"mobile\":[],\"tablet\":[]},\"height\":{\"value\":\"200\"}}},{\"id\":553,\"props\":{\"layout\":{\"equalWidth\":false}},\"type\":\"hop-row\",\"nodeId\":\"16-c43\",\"nodes\":[\"16-c3\"],\"v\":\"1.1\"},{\"id\":554,\"type\":\"hop-column\",\"nodeId\":\"16-c44\",\"nodes\":[\"16-c4\"],\"v\":\"1.1\"},{\"id\":557,\"type\":\"hop-button-group\",\"nodeId\":\"16-c49\",\"nodes\":[\"16-c30\"],\"v\":\"1.1\"},{\"id\":558,\"type\":\"hop-button\",\"nodeId\":\"16-c50\",\"nodes\":[\"16-c31\"],\"v\":\"1.1\",\"style\":{\"textAlign\":\"center\",\"background\":{\"color\":\"${theme.colors.1}\"},\"typography\":{\"color\":\"#fff\",\"family\":\"Open Sans\",\"margin\":{\"top\":\"\",\"bottom\":\"2rem\"},\"size\":{\"unit\":\"px\",\"value\":\"14\"},\"weight\":\"600\",\"lineHeight\":{\"value\":\"1\",\"unit\":\"\"},\"transform\":\"uppercase\",\"letterSpacing\":{\"value\":\"1\",\"unit\":\"px\"}},\"border\":{\"top\":{\"color\":\"${theme.colors.0}\",\"style\":\"solid\",\"width\":{\"value\":\"2\",\"unit\":\"px\"},\"radius\":{\"right\":{\"value\":5,\"unit\":\"px\"},\"left\":{\"value\":5,\"unit\":\"px\"}}},\"bottom\":{\"color\":\"${theme.colors.0}\",\"style\":\"solid\",\"width\":{\"value\":\"2\",\"unit\":\"px\"},\"radius\":{\"right\":{\"value\":5,\"unit\":\"px\"},\"left\":{\"value\":5,\"unit\":\"px\"}}},\"right\":{\"color\":\"${theme.colors.0}\",\"style\":\"solid\",\"width\":{\"value\":\"2\",\"unit\":\"px\"}},\"left\":{\"color\":\"${theme.colors.0}\",\"style\":\"solid\",\"width\":{\"value\":\"2\",\"unit\":\"px\"}}},\"padding\":{\"top\":{\"unit\":\"px\",\"value\":\"12\"},\"bottom\":{\"unit\":\"px\",\"value\":\"12\"},\"left\":{\"unit\":\"px\",\"value\":\"24\"},\"right\":{\"unit\":\"px\",\"value\":\"24\"}},\"states\":{\"hover\":{\"background\":{\"color\":\"${theme.colors.0|variant3}\",\"type\":\"gradient\",\"image\":[{\"source\":{\"type\":\"gradient\",\"gradient\":{\"steps\":[{\"color\":\"${theme.colors.1}\"},{\"color\":\"${theme.colors.1|variant4}\"}]}}}]},\"border\":{\"top\":{\"color\":\"${theme.colors.0|variant3}\"},\"right\":{\"color\":\"${theme.colors.0|variant3}\"},\"bottom\":{\"color\":\"${theme.colors.0|variant3}\"},\"left\":{\"color\":\"${theme.colors.0|variant3}\"}}}},\"descendants\":{\"icon\":{\"size\":{\"unit\":\"px\",\"value\":\"12\"},\"margin\":{\"left\":{\"value\":\"0\",\"unit\":\"px\"},\"right\":{\"value\":\"10\",\"unit\":\"px\"}}}}}},{\"id\":559,\"props\":{\"layout\":{\"equalWidth\":true,\"itemsPerRow\":3,\"equalHeight\":true,\"horizontalGap\":0,\"verticalGap\":0}},\"type\":\"hop-row\",\"nodeId\":\"236-c33\",\"nodes\":[\"236-c45\"],\"v\":\"1.1\",\"style\":{\"background\":{\"type\":\"image\",\"image\":[{\"source\":{\"type\":\"image\",\"url\":\"http:\\/\\/localhost\\/wordpress\\/wp-content\\/uploads\\/2024\\/10\\/colibri-image-600.png\"}}]}}},{\"id\":560,\"type\":\"hop-column\",\"nodeId\":\"236-c34\",\"nodes\":[\"236-c46\"],\"v\":\"1.1\",\"style\":{\"background\":{\"color\":\"rgba(247, 144, 7, 0.75)\",\"type\":\"none\",\"image\":[{\"source\":{\"type\":\"image\"},\"size\":\"auto\"}]},\"border\":{\"top\":{\"radius\":{\"left\":{\"value\":\"20\",\"unit\":\"px\"},\"right\":{\"value\":\"20\",\"unit\":\"px\"}},\"style\":\"dotted\",\"width\":{\"value\":\"2\",\"unit\":\"px\"},\"color\":\"${theme.colors.1}\"},\"bottom\":{\"radius\":{\"left\":{\"value\":\"20\",\"unit\":\"px\"},\"right\":{\"value\":\"20\",\"unit\":\"px\"}},\"style\":\"dotted\",\"width\":{\"value\":\"2\",\"unit\":\"px\"},\"color\":\"${theme.colors.1}\"},\"right\":{\"style\":\"dotted\",\"width\":{\"value\":\"2\",\"unit\":\"px\"},\"color\":\"${theme.colors.1}\"},\"left\":{\"style\":\"dotted\",\"width\":{\"value\":\"2\",\"unit\":\"px\"},\"color\":\"${theme.colors.1}\"}},\"descendants\":{\"outer\":{\"padding\":{\"left\":{\"unit\":\"px\",\"value\":\"\"},\"right\":{\"unit\":\"px\",\"value\":\"\"},\"top\":{\"unit\":\"px\",\"value\":\"\"},\"bottom\":{\"unit\":\"px\",\"value\":\"\"}}}}}},{\"id\":561,\"type\":\"hop-column\",\"nodeId\":\"236-c35\",\"nodes\":[\"236-c61\"],\"v\":\"1.1\",\"style\":{\"background\":{\"color\":\"rgba(248, 232, 2, 0.75)\"},\"border\":{\"top\":{\"radius\":{\"left\":{\"value\":\"20\",\"unit\":\"px\"},\"right\":{\"value\":\"20\",\"unit\":\"px\"}},\"style\":\"dotted\",\"width\":{\"value\":\"2\",\"unit\":\"px\"},\"color\":\"rgb(238, 224, 16)\"},\"bottom\":{\"radius\":{\"left\":{\"value\":\"20\",\"unit\":\"px\"},\"right\":{\"value\":\"20\",\"unit\":\"px\"}},\"style\":\"dotted\",\"width\":{\"value\":\"2\",\"unit\":\"px\"},\"color\":\"rgb(238, 224, 16)\"},\"right\":{\"style\":\"dotted\",\"width\":{\"value\":\"2\",\"unit\":\"px\"},\"color\":\"rgb(238, 224, 16)\"},\"left\":{\"style\":\"dotted\",\"width\":{\"value\":\"2\",\"unit\":\"px\"},\"color\":\"rgb(238, 224, 16)\"}},\"descendants\":{\"outer\":{\"padding\":{\"left\":{\"unit\":\"px\",\"value\":\"\"},\"right\":{\"unit\":\"px\",\"value\":\"\"},\"top\":{\"unit\":\"px\",\"value\":\"\"},\"bottom\":{\"unit\":\"px\",\"value\":\"\"}}}}}},{\"id\":562,\"type\":\"hop-column\",\"nodeId\":\"236-c36\",\"nodes\":[\"236-c74\"],\"v\":\"1.1\",\"style\":{\"border\":{\"top\":{\"radius\":{\"left\":{\"value\":\"20\",\"unit\":\"px\"},\"right\":{\"value\":\"20\",\"unit\":\"px\"}},\"style\":\"dotted\",\"width\":{\"value\":\"2\",\"unit\":\"px\"},\"color\":\"rgb(13, 215, 240)\"},\"bottom\":{\"radius\":{\"left\":{\"value\":\"20\",\"unit\":\"px\"},\"right\":{\"value\":\"20\",\"unit\":\"px\"}},\"style\":\"dotted\",\"width\":{\"value\":\"2\",\"unit\":\"px\"},\"color\":\"rgb(13, 215, 240)\"},\"right\":{\"style\":\"dotted\",\"width\":{\"value\":\"2\",\"unit\":\"px\"},\"color\":\"rgb(13, 215, 240)\"},\"left\":{\"style\":\"dotted\",\"width\":{\"value\":\"2\",\"unit\":\"px\"},\"color\":\"rgb(13, 215, 240)\"}},\"background\":{\"color\":\"rgba(1, 207, 227, 0.75)\"},\"descendants\":{\"outer\":{\"padding\":{\"left\":{\"unit\":\"px\",\"value\":\"\"},\"right\":{\"unit\":\"px\",\"value\":\"\"},\"top\":{\"unit\":\"px\",\"value\":\"\"},\"bottom\":{\"unit\":\"px\",\"value\":\"\"}}}}}},{\"id\":578,\"type\":\"hop-heading\",\"nodeId\":\"236-c52\",\"nodes\":[\"236-c47\"],\"v\":\"1.1\",\"style\":{\"typography\":{\"family\":\"Alike Angular\",\"weight\":\"400\",\"color\":\"${theme.colors.4}\",\"size\":{\"unit\":\"em\",\"value\":\"3.1\"}},\"textShadow\":{\"enabled\":true}},\"props\":{\"headerType\":\"1\"}},{\"id\":579,\"type\":\"hop-heading\",\"nodeId\":\"236-c53\",\"nodes\":[\"236-c62\"],\"v\":\"1.1\",\"style\":{\"textShadow\":{\"enabled\":true},\"typography\":{\"color\":\"${theme.colors.4}\",\"weight\":\"400\",\"family\":\"Alike Angular\",\"size\":{\"unit\":\"em\",\"value\":\"3.1\"}}}},{\"id\":580,\"type\":\"hop-heading\",\"nodeId\":\"236-c54\",\"nodes\":[\"236-c75\"],\"v\":\"1.1\",\"style\":{\"textShadow\":{\"enabled\":true},\"typography\":{\"color\":\"${theme.colors.4}\",\"weight\":\"400\",\"family\":\"Alike Angular\",\"size\":{\"unit\":\"em\",\"value\":\"3.1\"}}}},{\"id\":583,\"type\":\"hop-text\",\"nodeId\":\"236-c57\",\"nodes\":[\"236-c79\"],\"v\":\"1.1\",\"style\":{\"textAlign\":\"left\",\"typography\":{\"holders\":{\"p\":{\"decoration\":\"overline\"}}}}},{\"id\":584,\"type\":\"hop-text\",\"nodeId\":\"236-c58\",\"nodes\":[\"236-c66\"],\"v\":\"1.1\",\"style\":{\"textAlign\":\"left\",\"typography\":{\"holders\":{\"p\":{\"decoration\":\"overline\"}}}}},{\"id\":585,\"type\":\"hop-text\",\"nodeId\":\"236-c59\",\"nodes\":[\"236-c68\"],\"v\":\"1.1\",\"style\":{\"textAlign\":\"right\",\"typography\":{\"holders\":{\"p\":{\"color\":\"${theme.colors.4}\"}}}}},{\"id\":586,\"type\":\"hop-text\",\"nodeId\":\"236-c60\",\"nodes\":[\"236-c81\"],\"v\":\"1.1\",\"style\":{\"textAlign\":\"right\",\"typography\":{\"holders\":{\"p\":{\"color\":\"${theme.colors.4}\"}}}}},{\"id\":587,\"props\":{\"layout\":{\"equalWidth\":false,\"equalHeight\":false,\"horizontalGap\":0,\"verticalGap\":0,\"horizontalInnerGap\":0,\"verticalInnerGap\":0}},\"type\":\"hop-row\",\"nodeId\":\"236-c61\",\"nodes\":[\"236-c49\"],\"v\":\"1.1\"},{\"id\":588,\"type\":\"hop-column\",\"nodeId\":\"236-c62\",\"nodes\":[\"236-c50\"],\"v\":\"1.1\",\"style\":{\"descendants\":{\"outer\":{\"padding\":{\"left\":{\"unit\":\"px\",\"value\":\"\"},\"right\":{\"unit\":\"px\",\"value\":\"\"},\"top\":{\"unit\":\"px\",\"value\":\"\"},\"bottom\":{\"unit\":\"px\",\"value\":\"\"}}}},\"padding\":{\"left\":{\"unit\":\"px\",\"value\":\"\"},\"right\":{\"unit\":\"px\",\"value\":\"\"},\"top\":{\"unit\":\"px\",\"value\":\"\"},\"bottom\":{\"unit\":\"px\",\"value\":\"\"}}}},{\"id\":589,\"type\":\"hop-column\",\"nodeId\":\"236-c63\",\"nodes\":[\"236-c53\"],\"v\":\"1.1\",\"style\":{\"descendants\":{\"outer\":{\"padding\":{\"left\":{\"unit\":\"px\",\"value\":\"\"},\"right\":{\"unit\":\"px\",\"value\":\"\"},\"top\":{\"unit\":\"px\",\"value\":\"\"},\"bottom\":{\"unit\":\"px\",\"value\":\"\"}}}},\"padding\":{\"left\":{\"unit\":\"px\",\"value\":\"\"},\"right\":{\"unit\":\"px\",\"value\":\"\"},\"top\":{\"unit\":\"px\",\"value\":\"\"},\"bottom\":{\"unit\":\"px\",\"value\":\"\"}}}},{\"id\":590,\"type\":\"hop-text\",\"nodeId\":\"236-c64\",\"nodes\":[\"236-c51\"],\"v\":\"1.1\",\"style\":{\"textAlign\":\"left\",\"typography\":{\"holders\":{\"p\":{\"decoration\":\"overline\"}}}}},{\"id\":594,\"props\":{\"layout\":{\"equalWidth\":false,\"horizontalGap\":0,\"verticalGap\":0,\"horizontalInnerGap\":0,\"verticalInnerGap\":0}},\"type\":\"hop-row\",\"nodeId\":\"236-c68\",\"nodes\":[\"236-c64\"],\"v\":\"1.1\"},{\"id\":595,\"type\":\"hop-column\",\"nodeId\":\"236-c69\",\"nodes\":[\"236-c65\"],\"v\":\"1.1\",\"style\":{\"descendants\":{\"outer\":{\"padding\":{\"left\":{\"unit\":\"px\",\"value\":\"\"},\"right\":{\"unit\":\"px\",\"value\":\"\"},\"top\":{\"unit\":\"px\",\"value\":\"\"},\"bottom\":{\"unit\":\"px\",\"value\":\"\"}}}},\"padding\":{\"left\":{\"unit\":\"px\",\"value\":\"\"},\"right\":{\"unit\":\"px\",\"value\":\"\"},\"top\":{\"unit\":\"px\",\"value\":\"\"},\"bottom\":{\"unit\":\"px\",\"value\":\"\"}}}},{\"id\":596,\"type\":\"hop-column\",\"nodeId\":\"236-c70\",\"nodes\":[\"236-c67\"],\"v\":\"1.1\",\"style\":{\"descendants\":{\"outer\":{\"padding\":{\"left\":{\"unit\":\"px\",\"value\":\"\"},\"right\":{\"unit\":\"px\",\"value\":\"\"},\"top\":{\"unit\":\"px\",\"value\":\"\"},\"bottom\":{\"unit\":\"px\",\"value\":\"\"}}}},\"padding\":{\"left\":{\"unit\":\"px\",\"value\":\"\"},\"right\":{\"unit\":\"px\",\"value\":\"\"},\"top\":{\"unit\":\"px\",\"value\":\"\"},\"bottom\":{\"unit\":\"px\",\"value\":\"\"}}}},{\"id\":597,\"props\":{\"layout\":{\"equalWidth\":false,\"horizontalGap\":0,\"verticalGap\":0,\"horizontalInnerGap\":0,\"verticalInnerGap\":0}},\"type\":\"hop-row\",\"nodeId\":\"236-c71\",\"nodes\":[\"236-c77\"],\"v\":\"1.1\"},{\"id\":598,\"type\":\"hop-column\",\"nodeId\":\"236-c72\",\"nodes\":[\"236-c78\"],\"v\":\"1.1\",\"style\":{\"descendants\":{\"outer\":{\"padding\":{\"left\":{\"unit\":\"px\",\"value\":\"\"},\"right\":{\"unit\":\"px\",\"value\":\"\"},\"top\":{\"unit\":\"px\",\"value\":\"\"},\"bottom\":{\"unit\":\"px\",\"value\":\"\"}}}},\"padding\":{\"left\":{\"unit\":\"px\",\"value\":\"\"},\"right\":{\"unit\":\"px\",\"value\":\"\"},\"top\":{\"unit\":\"px\",\"value\":\"\"},\"bottom\":{\"unit\":\"px\",\"value\":\"\"}}}},{\"id\":599,\"type\":\"hop-column\",\"nodeId\":\"236-c73\",\"nodes\":[\"236-c80\"],\"v\":\"1.1\",\"style\":{\"descendants\":{\"outer\":{\"padding\":{\"left\":{\"unit\":\"px\",\"value\":\"\"},\"right\":{\"unit\":\"px\",\"value\":\"\"},\"top\":{\"unit\":\"px\",\"value\":\"\"},\"bottom\":{\"unit\":\"px\",\"value\":\"\"}}}},\"padding\":{\"left\":{\"unit\":\"px\",\"value\":\"\"},\"right\":{\"unit\":\"px\",\"value\":\"\"},\"top\":{\"unit\":\"px\",\"value\":\"\"},\"bottom\":{\"unit\":\"px\",\"value\":\"\"}}}},{\"id\":604,\"type\":\"hop-text\",\"nodeId\":\"236-c78\",\"nodes\":[\"236-c54\"],\"v\":\"1.1\",\"style\":{\"textAlign\":\"right\",\"typography\":{\"holders\":{\"p\":{\"color\":\"${theme.colors.4}\"}}}}},{\"id\":605,\"type\":\"hop-text\",\"nodeId\":\"236-c79\",\"nodes\":[\"236-c52\"],\"v\":\"1.1\",\"style\":{\"textAlign\":\"left\"}},{\"id\":606,\"type\":\"hop-text\",\"nodeId\":\"236-c80\",\"nodes\":[\"236-c55\"],\"v\":\"1.1\",\"style\":{\"textAlign\":\"right\"}},{\"id\":607,\"type\":\"hop-text\",\"nodeId\":\"236-c81\",\"nodes\":[\"236-c87\"],\"v\":\"1.1\",\"style\":{\"textAlign\":\"left\"}},{\"id\":608,\"type\":\"hop-divider\",\"nodeId\":\"236-c82\",\"nodes\":[\"236-c48\"],\"v\":\"1.1\",\"style\":{\"descendants\":{\"line\":{\"border\":{\"bottom\":{\"color\":\"${theme.colors.4}\",\"style\":\"solid\",\"width\":{\"value\":2}}},\"width\":{\"value\":58}}},\"padding\":{\"top\":{\"value\":0},\"bottom\":{\"value\":0}}}},{\"id\":609,\"props\":{\"layout\":{\"equalWidth\":false,\"horizontalGap\":3,\"verticalGap\":3}},\"type\":\"hop-row\",\"nodeId\":\"236-c83\",\"nodes\":[\"236-c40\"],\"v\":\"1.1\"},{\"id\":610,\"type\":\"hop-column\",\"nodeId\":\"236-c84\",\"nodes\":[\"236-c41\"],\"v\":\"1.1\",\"style\":{\"descendants\":{\"outer\":{\"padding\":{\"left\":{\"unit\":\"px\",\"value\":\"\"},\"right\":{\"unit\":\"px\",\"value\":\"\"},\"top\":{\"unit\":\"px\",\"value\":\"\"},\"bottom\":{\"unit\":\"px\",\"value\":\"\"}}}},\"padding\":{\"left\":{\"unit\":\"px\",\"value\":\"\"},\"right\":{\"unit\":\"px\",\"value\":\"\"},\"top\":{\"unit\":\"px\",\"value\":\"\"},\"bottom\":{\"unit\":\"px\",\"value\":\"\"}}},\"props\":{\"layout\":{\"horizontalInnerGap\":0,\"verticalInnerGap\":0}}},{\"id\":611,\"type\":\"hop-heading\",\"nodeId\":\"236-c85\",\"nodes\":[\"236-c42\"],\"v\":\"1.1\",\"style\":{\"typography\":{\"transform\":\"uppercase\",\"style\":\"normal\",\"letterSpacing\":{\"unit\":\"px\",\"value\":\"10\"},\"weight\":\"400\",\"family\":\"Open Sans\"}}},{\"id\":612,\"type\":\"hop-divider\",\"nodeId\":\"236-c86\",\"nodes\":[\"236-c63\"],\"v\":\"1.1\",\"style\":{\"descendants\":{\"line\":{\"border\":{\"bottom\":{\"width\":{\"value\":\"2\"},\"color\":\"${theme.colors.4}\"}},\"width\":{\"value\":\"58\"}}},\"padding\":{\"top\":{\"value\":0},\"bottom\":{\"value\":0}}}},{\"id\":613,\"type\":\"hop-divider\",\"nodeId\":\"236-c87\",\"nodes\":[\"236-c76\"],\"v\":\"1.1\",\"style\":{\"descendants\":{\"line\":{\"border\":{\"bottom\":{\"width\":{\"value\":\"2\"},\"color\":\"${theme.colors.4}\"}},\"width\":{\"value\":\"58\"}}},\"padding\":{\"top\":{\"value\":\"0\"},\"bottom\":{\"value\":\"0\"}}}},{\"id\":614,\"type\":\"hop-content-swap\",\"nodeId\":\"236-c88\",\"nodes\":[\"236-c56\"],\"v\":\"1.1\",\"style\":{\"descendants\":{\"normal\":{\"background\":{\"color\":\"rgba(233, 100, 100, 0)\"}},\"hover\":{\"background\":{\"color\":\"${theme.colors.1}\"}}},\"border\":{\"top\":{\"radius\":{\"left\":{\"value\":\"16\",\"unit\":\"px\"},\"right\":{\"value\":\"16\",\"unit\":\"px\"}}},\"bottom\":{\"radius\":{\"left\":{\"value\":\"16\",\"unit\":\"px\"},\"right\":{\"value\":\"16\",\"unit\":\"px\"}}}},\"boxShadow\":{\"enabled\":true}},\"props\":{\"hover\":{\"effect\":{\"type\":\"zoomIn\",\"direction\":\"\"}}}},{\"id\":615,\"style\":{\"textAlign\":\"center\",\"minHeight\":{\"value\":137}},\"type\":\"hop-content-swap-default\",\"nodeId\":\"236-c89\",\"nodes\":[\"236-c57\"],\"v\":\"1.1\",\"props\":{\"vSpace\":{\"value\":21}}},{\"id\":617,\"style\":{\"textAlign\":\"center\"},\"type\":\"hop-content-swap-hover\",\"nodeId\":\"236-c91\",\"nodes\":[\"236-c59\"],\"v\":\"1.1\"},{\"id\":621,\"type\":\"hop-heading\",\"nodeId\":\"236-c95\",\"nodes\":[\"236-c60\"],\"v\":\"1.1\",\"style\":{\"textAlign\":\"center\",\"typography\":{\"color\":\"${theme.colors.4}\"}},\"props\":{\"headerType\":\"1\"}},{\"id\":622,\"type\":\"hop-heading\",\"nodeId\":\"236-c96\",\"nodes\":[\"236-c58\"],\"v\":\"1.1\",\"props\":{\"headerType\":\"3\"},\"style\":{\"typography\":{\"color\":\"${theme.colors.5|variant2}\"}}},{\"id\":639,\"type\":\"hop-content-swap\",\"style\":{\"descendants\":{\"normal\":{\"typography\":{\"holders\":{\"h1\":{\"color\":\"${theme.colors.4|variant3}\"},\"h2\":{\"color\":\"${theme.colors.4|variant3}\"},\"h3\":{\"color\":\"${theme.colors.4|variant3}\"},\"h4\":{\"color\":\"${theme.colors.4|variant3}\"},\"h5\":{\"color\":\"${theme.colors.4|variant3}\"},\"h6\":{\"color\":\"${theme.colors.4|variant3}\"},\"p\":{\"color\":\"${theme.colors.4}\"}}},\"background\":{\"color\":\"rgba(3, 169, 244, 0.01)\"},\"padding\":{\"left\":{\"value\":2},\"right\":{\"value\":2}}},\"hover\":{\"background\":{\"color\":\"rgba(243, 231, 42, 0.99)\"}}},\"boxShadow\":{\"enabled\":true},\"border\":{\"top\":{\"radius\":{\"left\":{\"value\":\"20\",\"unit\":\"px\"},\"right\":{\"value\":\"20\",\"unit\":\"px\"}},\"style\":\"solid\",\"width\":{\"value\":\"2\",\"unit\":\"px\"},\"color\":\"rgba(0, 0, 0, 0)\"},\"bottom\":{\"radius\":{\"left\":{\"value\":\"20\",\"unit\":\"px\"},\"right\":{\"value\":\"20\",\"unit\":\"px\"}},\"style\":\"solid\",\"width\":{\"value\":\"2\",\"unit\":\"px\"},\"color\":\"rgba(0, 0, 0, 0)\"},\"right\":{\"style\":\"solid\",\"width\":{\"value\":\"2\",\"unit\":\"px\"},\"color\":\"rgba(0, 0, 0, 0)\"},\"left\":{\"style\":\"solid\",\"width\":{\"value\":\"2\",\"unit\":\"px\"},\"color\":\"rgba(0, 0, 0, 0)\"}}},\"v\":\"1.1\",\"nodes\":[\"236-c69\"]},{\"id\":640,\"style\":{\"textAlign\":\"center\",\"minHeight\":{\"value\":\"137\"}},\"type\":\"hop-content-swap-default\",\"props\":{\"horizontalGap\":3,\"vSpace\":{\"value\":\"21\"}},\"v\":\"1.1\",\"nodes\":[\"236-c70\"]},{\"id\":643,\"style\":{\"textAlign\":\"center\",\"height\":{\"value\":\"100\"},\"top\":{\"value\":0,\"unit\":\"%\"},\"left\":{\"value\":0,\"unit\":\"%\"},\"width\":{\"value\":\"100\"}},\"type\":\"hop-content-swap-hover\",\"props\":{\"verticalAlign\":\"center\",\"position\":\"topCenter\",\"vSpace\":{\"value\":\"21\"}},\"v\":\"1.1\",\"nodes\":[\"236-c72\"]},{\"id\":646,\"type\":\"hop-heading\",\"nodeId\":\"236-c92\",\"nodes\":[\"236-c71\"],\"v\":\"1.1\",\"style\":{\"textAlign\":\"center\",\"typography\":{\"color\":\"${theme.colors.5|variant2}\"}},\"props\":{\"headerType\":\"3\"}},{\"id\":647,\"type\":\"hop-heading\",\"nodeId\":\"236-c93\",\"nodes\":[\"236-c73\"],\"v\":\"1.1\",\"style\":{\"typography\":{\"color\":\"${theme.colors.4}\"}}},{\"id\":648,\"type\":\"hop-content-swap\",\"style\":{\"descendants\":{\"normal\":{\"typography\":{\"holders\":{\"h1\":{\"color\":\"${theme.colors.4|variant3}\"},\"h2\":{\"color\":\"${theme.colors.4|variant3}\"},\"h3\":{\"color\":\"${theme.colors.4|variant3}\"},\"h4\":{\"color\":\"${theme.colors.4|variant3}\"},\"h5\":{\"color\":\"${theme.colors.4|variant3}\"},\"h6\":{\"color\":\"${theme.colors.4|variant3}\"},\"p\":{\"color\":\"${theme.colors.4|variant3}\"}}},\"background\":{\"color\":\"rgba(3, 169, 244, 0)\"},\"padding\":{\"left\":{\"value\":\".0\"},\"right\":{\"value\":\".0\"}}},\"hover\":{\"background\":{\"color\":\"rgb(14, 154, 217)\"}}},\"boxShadow\":{\"enabled\":true},\"border\":{\"top\":{\"radius\":{\"left\":{\"value\":\"20\",\"unit\":\"px\"},\"right\":{\"value\":\"20\",\"unit\":\"px\"}},\"style\":\"solid\",\"width\":{\"value\":\"2\",\"unit\":\"px\"},\"color\":\"rgba(0, 0, 0, 0)\"},\"bottom\":{\"radius\":{\"left\":{\"value\":\"20\",\"unit\":\"px\"},\"right\":{\"value\":\"20\",\"unit\":\"px\"}},\"style\":\"solid\",\"width\":{\"value\":\"2\",\"unit\":\"px\"},\"color\":\"rgba(0, 0, 0, 0)\"},\"right\":{\"style\":\"solid\",\"width\":{\"value\":\"2\",\"unit\":\"px\"},\"color\":\"rgba(0, 0, 0, 0)\"},\"left\":{\"style\":\"solid\",\"width\":{\"value\":\"2\",\"unit\":\"px\"},\"color\":\"rgba(0, 0, 0, 0)\"}}},\"v\":\"1.1\",\"nodes\":[\"236-c82\"]},{\"id\":649,\"style\":{\"textAlign\":\"center\",\"minHeight\":{\"value\":\"137\"}},\"type\":\"hop-content-swap-default\",\"props\":{\"horizontalGap\":3,\"vSpace\":{\"value\":\"21\"}},\"v\":\"1.1\",\"nodes\":[\"236-c83\"]},{\"id\":652,\"style\":{\"textAlign\":\"center\",\"height\":{\"value\":100},\"top\":{\"value\":0,\"unit\":\"%\"},\"left\":{\"value\":0,\"unit\":\"%\"},\"width\":{\"value\":100}},\"type\":\"hop-content-swap-hover\",\"props\":{\"verticalAlign\":\"center\",\"position\":\"topRight\"},\"v\":\"1.1\",\"nodes\":[\"236-c85\"]},{\"id\":655,\"type\":\"hop-heading\",\"nodeId\":\"236-c101\",\"nodes\":[\"236-c86\"],\"v\":\"1.1\",\"style\":{\"typography\":{\"color\":\"${theme.colors.4}\"}},\"props\":{\"headerType\":\"1\"}},{\"id\":657,\"type\":\"hop-heading\",\"nodeId\":\"236-c103\",\"nodes\":[\"236-c84\"],\"v\":\"1.1\",\"style\":{\"typography\":{\"color\":\"${theme.colors.5|variant2}\"}},\"props\":{\"headerType\":\"3\"}},{\"id\":658,\"type\":\"hop-content\",\"nodeId\":\"881-c1\",\"nodes\":[\"881-c1\"],\"v\":\"1.1\"},{\"id\":659,\"type\":\"hop-section\",\"style\":{\"padding\":{\"top\":{\"path\":\"value\",\"value\":\"7\"},\"bottom\":{\"value\":\"0\"}},\"media\":{\"mobile\":{\"margin\":{\"top\":{\"value\":\"0\",\"unit\":\"px\"},\"right\":{\"unit\":\"px\"},\"bottom\":{\"unit\":\"px\"},\"left\":{\"unit\":\"px\"}}}},\"descendants\":{\"inner\":{\"margin\":{\"top\":{\"value\":0,\"unit\":\"px\",\"path\":\"value\"}}}},\"background\":{\"color\":\"#F5FAFD\"},\"customHeight\":{\"type\":\"fit-to-content\",\"min-height\":{\"unit\":\"px\",\"value\":211.98611450195312}}},\"v\":\"1.1\",\"nodes\":[\"881-c2\"],\"props\":{\"width\":\"full-width\"}},{\"id\":660,\"props\":{\"layout\":{\"equalWidth\":true,\"itemsPerRow\":3,\"horizontalGap\":0,\"verticalGap\":0},\"media\":{\"mobile\":{\"layout\":{\"horizontalGap\":2,\"verticalGap\":2}}}},\"type\":\"hop-row\",\"style\":{\"boxShadow\":{\"enabled\":true,\"layers\":[{\"color\":\"rgba(74, 74, 74, 0.3)\",\"y\":\"4\"}]},\"background\":{\"color\":\"${theme.colors.4}\"},\"media\":{\"mobile\":{\"margin\":{\"top\":{\"value\":\"15\",\"unit\":\"px\"},\"right\":{\"value\":\"15\",\"unit\":\"px\"},\"bottom\":{\"value\":\"15\",\"unit\":\"px\"},\"left\":{\"value\":\"15\",\"unit\":\"px\"}}}}},\"v\":\"1.1\",\"nodes\":[\"881-c3\"]},{\"id\":661,\"type\":\"hop-column\",\"style\":{\"textAlign\":\"center\",\"media\":{\"mobile\":{\"textAlign\":\"center\",\"padding\":{\"left\":{\"unit\":\"px\"},\"right\":{\"unit\":\"px\"},\"top\":{\"unit\":\"px\"},\"bottom\":{\"unit\":\"px\"}}},\"tablet\":{\"padding\":{\"left\":{\"unit\":\"px\"},\"right\":{\"unit\":\"px\"},\"top\":{\"unit\":\"px\"},\"bottom\":{\"unit\":\"px\"}}}},\"descendants\":{\"outer\":{\"media\":{\"mobile\":{\"padding\":{\"left\":{\"unit\":\"px\"},\"right\":{\"unit\":\"px\"},\"top\":{\"unit\":\"px\"},\"bottom\":{\"unit\":\"px\"}}}},\"padding\":{\"left\":{\"unit\":\"px\"},\"right\":{\"unit\":\"px\"},\"top\":{\"unit\":\"px\"},\"bottom\":{\"unit\":\"px\"}}}},\"padding\":{\"left\":{\"unit\":\"px\"},\"right\":{\"unit\":\"px\"},\"top\":{\"unit\":\"px\"},\"bottom\":{\"unit\":\"px\"}},\"border\":{\"top\":{\"radius\":{\"left\":{\"unit\":\"px\"},\"right\":{\"unit\":\"px\"}},\"style\":\"solid\",\"width\":{\"value\":\"0\",\"unit\":\"px\"},\"color\":\"rgb(221, 221, 221)\"},\"bottom\":{\"radius\":{\"left\":{\"unit\":\"px\"},\"right\":{\"unit\":\"px\"}},\"style\":\"solid\",\"width\":{\"value\":\"0\",\"unit\":\"px\"},\"color\":\"rgb(221, 221, 221)\"},\"right\":{\"style\":\"solid\",\"width\":{\"value\":\"1\",\"unit\":\"px\"},\"color\":\"rgb(221, 221, 221)\"},\"left\":{\"style\":\"solid\",\"width\":{\"value\":\"1\",\"unit\":\"px\"},\"color\":\"rgb(221, 221, 221)\"}}},\"props\":{\"layout\":{\"verticalInnerGap\":3,\"horizontalInnerGap\":3},\"media\":{\"mobile\":{\"layout\":{\"horizontalInnerGap\":2,\"verticalInnerGap\":2}},\"tablet\":{\"layout\":{\"horizontalInnerGap\":3,\"verticalInnerGap\":3}}},\"verticalAlign\":\"center\"},\"v\":\"1.1\",\"nodes\":[\"881-c4\",\"881-c8\",\"881-c12\"]},{\"id\":662,\"type\":\"hop-icon\",\"style\":{\"descendants\":{\"icon\":{\"fill\":\"${theme.colors.4|variant4}\",\"width\":{\"path\":\"value\",\"value\":\"64\"},\"height\":{\"path\":\"value\",\"value\":\"64\"},\"border\":{\"top\":{\"style\":\"none\",\"width\":{\"value\":\"2\",\"unit\":\"px\"},\"color\":\"${theme.colors.1}\",\"radius\":{\"left\":{\"value\":\"300\",\"unit\":\"px\"},\"right\":{\"value\":\"300\",\"unit\":\"px\"}}},\"right\":{\"style\":\"none\",\"width\":{\"value\":\"2\",\"unit\":\"px\"},\"color\":\"${theme.colors.1}\"},\"bottom\":{\"style\":\"none\",\"width\":{\"value\":\"2\",\"unit\":\"px\"},\"color\":\"${theme.colors.1}\",\"radius\":{\"left\":{\"value\":\"300\",\"unit\":\"px\"},\"right\":{\"value\":\"300\",\"unit\":\"px\"}}},\"left\":{\"style\":\"none\",\"width\":{\"value\":\"2\",\"unit\":\"px\"},\"color\":\"${theme.colors.1}\"}},\"padding\":{\"top\":{\"path\":\"value\",\"value\":\"11\"},\"left\":{\"path\":\"value\",\"value\":\"11\"},\"right\":{\"path\":\"value\",\"value\":\"11\"},\"bottom\":{\"path\":\"value\",\"value\":\"11\"}}}}},\"v\":\"1.1\",\"nodes\":[\"881-c5\",\"881-c9\",\"881-c13\"]},{\"id\":663,\"type\":\"hop-heading\",\"style\":{\"typography\":{\"transform\":\"uppercase\",\"letterSpacing\":{\"unit\":\"px\",\"value\":\"1\"}}},\"props\":{\"headerType\":\"5\"},\"v\":\"1.1\",\"nodes\":[\"881-c6\",\"881-c10\",\"881-c14\"]},{\"id\":664,\"type\":\"hop-text\",\"v\":\"1.1\",\"nodes\":[\"881-c7\",\"881-c11\",\"881-c15\",\"881-c19\"]},{\"id\":665,\"type\":\"hop-column\",\"style\":{\"textAlign\":\"center\",\"media\":{\"mobile\":{\"textAlign\":\"center\",\"padding\":{\"left\":{\"unit\":\"px\"},\"right\":{\"unit\":\"px\"},\"top\":{\"unit\":\"px\"},\"bottom\":{\"unit\":\"px\"}}},\"tablet\":{\"padding\":{\"left\":{\"unit\":\"px\"},\"right\":{\"unit\":\"px\"},\"top\":{\"unit\":\"px\"},\"bottom\":{\"unit\":\"px\"}}}},\"descendants\":{\"outer\":{\"media\":{\"mobile\":{\"padding\":{\"left\":{\"unit\":\"px\"},\"right\":{\"unit\":\"px\"},\"top\":{\"unit\":\"px\"},\"bottom\":{\"unit\":\"px\"}}}},\"padding\":{\"left\":{\"unit\":\"px\"},\"right\":{\"unit\":\"px\"},\"top\":{\"unit\":\"px\"},\"bottom\":{\"unit\":\"px\"}}}},\"padding\":{\"left\":{\"unit\":\"px\"},\"right\":{\"unit\":\"px\"},\"top\":{\"unit\":\"px\"},\"bottom\":{\"unit\":\"px\"}},\"border\":{\"top\":{\"radius\":{\"left\":{\"unit\":\"px\"},\"right\":{\"unit\":\"px\"}},\"style\":\"solid\",\"width\":{\"value\":\"0\",\"unit\":\"px\"},\"color\":\"rgb(221, 221, 221)\"},\"bottom\":{\"radius\":{\"left\":{\"unit\":\"px\"},\"right\":{\"unit\":\"px\"}},\"style\":\"solid\",\"width\":{\"value\":\"0\",\"unit\":\"px\"},\"color\":\"rgb(221, 221, 221)\"},\"right\":{\"style\":\"solid\",\"width\":{\"value\":\"0\",\"unit\":\"px\"},\"color\":\"rgb(221, 221, 221)\"},\"left\":{\"style\":\"solid\",\"width\":{\"value\":\"0\",\"unit\":\"px\"},\"color\":\"rgb(221, 221, 221)\"}}},\"props\":{\"layout\":{\"verticalInnerGap\":3,\"horizontalInnerGap\":3},\"media\":{\"mobile\":{\"layout\":{\"horizontalInnerGap\":2,\"verticalInnerGap\":2}},\"tablet\":{\"layout\":{\"horizontalInnerGap\":3,\"verticalInnerGap\":3}}},\"verticalAlign\":\"center\"},\"v\":\"1.1\",\"nodes\":[\"881-c16\"]},{\"id\":666,\"type\":\"hop-section\",\"style\":{\"padding\":{\"top\":{\"path\":\"value\",\"value\":\"0\"},\"bottom\":{\"value\":0}},\"media\":{\"mobile\":{\"margin\":{\"top\":{\"value\":\"0\",\"unit\":\"px\"},\"right\":{\"unit\":\"px\"},\"bottom\":{\"unit\":\"px\"},\"left\":{\"unit\":\"px\"}}}},\"descendants\":{\"inner\":{\"margin\":{\"top\":{\"value\":0,\"unit\":\"px\",\"path\":\"value\"}}}}},\"v\":\"1.1\",\"nodes\":[\"881-c20\"],\"props\":{\"width\":\"full-width\"}},{\"id\":667,\"props\":{\"layout\":{\"equalWidth\":true,\"itemsPerRow\":4,\"horizontalGap\":0,\"verticalGap\":0},\"media\":{\"mobile\":{\"layout\":{\"horizontalGap\":2,\"verticalGap\":2}}}},\"type\":\"hop-row\",\"style\":{\"boxShadow\":{\"enabled\":true,\"layers\":[{\"color\":\"rgba(74, 74, 74, 0.3)\",\"y\":\"4\"}]},\"background\":{\"color\":\"${theme.colors.4}\"},\"media\":{\"mobile\":{\"margin\":{\"top\":{\"value\":\"15\",\"unit\":\"px\"},\"right\":{\"value\":\"15\",\"unit\":\"px\"},\"bottom\":{\"value\":\"15\",\"unit\":\"px\"},\"left\":{\"value\":\"15\",\"unit\":\"px\"}}}}},\"v\":\"1.1\",\"nodes\":[\"881-c21\"]},{\"id\":668,\"type\":\"hop-column\",\"style\":{\"textAlign\":\"center\",\"media\":{\"mobile\":{\"textAlign\":\"center\",\"padding\":{\"left\":{\"unit\":\"px\"},\"right\":{\"unit\":\"px\"},\"top\":{\"unit\":\"px\"},\"bottom\":{\"unit\":\"px\"}}},\"tablet\":{\"padding\":{\"left\":{\"unit\":\"px\"},\"right\":{\"unit\":\"px\"},\"top\":{\"unit\":\"px\"},\"bottom\":{\"unit\":\"px\"}}}},\"descendants\":{\"outer\":{\"media\":{\"mobile\":{\"padding\":{\"left\":{\"unit\":\"px\"},\"right\":{\"unit\":\"px\"},\"top\":{\"unit\":\"px\"},\"bottom\":{\"unit\":\"px\"}}}},\"padding\":{\"left\":{\"unit\":\"px\"},\"right\":{\"unit\":\"px\"},\"top\":{\"unit\":\"px\"},\"bottom\":{\"unit\":\"px\"}}}},\"padding\":{\"left\":{\"unit\":\"px\"},\"right\":{\"unit\":\"px\"},\"top\":{\"unit\":\"px\"},\"bottom\":{\"unit\":\"px\"}},\"border\":{\"top\":{\"radius\":{\"left\":{\"unit\":\"px\"},\"right\":{\"unit\":\"px\"}},\"style\":\"solid\",\"width\":{\"value\":\"0\",\"unit\":\"px\"},\"color\":\"rgb(221, 221, 221)\"},\"bottom\":{\"radius\":{\"left\":{\"unit\":\"px\"},\"right\":{\"unit\":\"px\"}},\"style\":\"solid\",\"width\":{\"value\":\"0\",\"unit\":\"px\"},\"color\":\"rgb(221, 221, 221)\"},\"right\":{\"style\":\"solid\",\"width\":{\"value\":\"1\",\"unit\":\"px\"},\"color\":\"rgb(221, 221, 221)\"},\"left\":{\"style\":\"solid\",\"width\":{\"value\":\"0\",\"unit\":\"px\"},\"color\":\"rgb(221, 221, 221)\"}}},\"props\":{\"layout\":{\"verticalInnerGap\":3,\"horizontalInnerGap\":3},\"media\":{\"mobile\":{\"layout\":{\"horizontalInnerGap\":2,\"verticalInnerGap\":2}},\"tablet\":{\"layout\":{\"horizontalInnerGap\":3,\"verticalInnerGap\":3}}},\"verticalAlign\":\"center\"},\"v\":\"1.1\",\"nodes\":[\"881-c22\",\"881-c26\",\"881-c30\"]},{\"id\":669,\"type\":\"hop-icon\",\"style\":{\"descendants\":{\"icon\":{\"fill\":\"${theme.colors.4|variant4}\",\"width\":{\"path\":\"value\",\"value\":\"64\"},\"height\":{\"path\":\"value\",\"value\":\"64\"},\"border\":{\"top\":{\"style\":\"none\",\"width\":{\"value\":\"2\",\"unit\":\"px\"},\"color\":\"${theme.colors.1}\",\"radius\":{\"left\":{\"value\":\"300\",\"unit\":\"px\"},\"right\":{\"value\":\"300\",\"unit\":\"px\"}}},\"right\":{\"style\":\"none\",\"width\":{\"value\":\"2\",\"unit\":\"px\"},\"color\":\"${theme.colors.1}\"},\"bottom\":{\"style\":\"none\",\"width\":{\"value\":\"2\",\"unit\":\"px\"},\"color\":\"${theme.colors.1}\",\"radius\":{\"left\":{\"value\":\"300\",\"unit\":\"px\"},\"right\":{\"value\":\"300\",\"unit\":\"px\"}}},\"left\":{\"style\":\"none\",\"width\":{\"value\":\"2\",\"unit\":\"px\"},\"color\":\"${theme.colors.1}\"}},\"padding\":{\"top\":{\"path\":\"value\",\"value\":\"11\"},\"left\":{\"path\":\"value\",\"value\":\"11\"},\"right\":{\"path\":\"value\",\"value\":\"11\"},\"bottom\":{\"path\":\"value\",\"value\":\"11\"}}}}},\"v\":\"1.1\",\"nodes\":[\"881-c21\",\"881-c24\",\"881-c27\",\"881-c30\"]},{\"id\":670,\"type\":\"hop-heading\",\"style\":{\"typography\":{\"transform\":\"uppercase\",\"letterSpacing\":{\"unit\":\"px\",\"value\":\"1\"}}},\"props\":{\"headerType\":\"5\"},\"v\":\"1.1\",\"nodes\":[\"881-c28\"]},{\"id\":671,\"type\":\"hop-text\",\"v\":\"1.1\",\"nodes\":[\"881-c25\",\"881-c29\",\"881-c33\",\"881-c37\"]},{\"id\":672,\"type\":\"hop-column\",\"style\":{\"textAlign\":\"center\",\"media\":{\"mobile\":{\"textAlign\":\"center\",\"padding\":{\"left\":{\"unit\":\"px\"},\"right\":{\"unit\":\"px\"},\"top\":{\"unit\":\"px\"},\"bottom\":{\"unit\":\"px\"}}},\"tablet\":{\"padding\":{\"left\":{\"unit\":\"px\"},\"right\":{\"unit\":\"px\"},\"top\":{\"unit\":\"px\"},\"bottom\":{\"unit\":\"px\"}}}},\"descendants\":{\"outer\":{\"media\":{\"mobile\":{\"padding\":{\"left\":{\"unit\":\"px\"},\"right\":{\"unit\":\"px\"},\"top\":{\"unit\":\"px\"},\"bottom\":{\"unit\":\"px\"}}}},\"padding\":{\"left\":{\"unit\":\"px\"},\"right\":{\"unit\":\"px\"},\"top\":{\"unit\":\"px\"},\"bottom\":{\"unit\":\"px\"}}}},\"padding\":{\"left\":{\"unit\":\"px\"},\"right\":{\"unit\":\"px\"},\"top\":{\"unit\":\"px\"},\"bottom\":{\"unit\":\"px\"}},\"border\":{\"top\":{\"radius\":{\"left\":{\"unit\":\"px\"},\"right\":{\"unit\":\"px\"}},\"style\":\"solid\",\"width\":{\"value\":\"0\",\"unit\":\"px\"},\"color\":\"rgb(221, 221, 221)\"},\"bottom\":{\"radius\":{\"left\":{\"unit\":\"px\"},\"right\":{\"unit\":\"px\"}},\"style\":\"solid\",\"width\":{\"value\":\"0\",\"unit\":\"px\"},\"color\":\"rgb(221, 221, 221)\"},\"right\":{\"style\":\"solid\",\"width\":{\"value\":\"0\",\"unit\":\"px\"},\"color\":\"rgb(221, 221, 221)\"},\"left\":{\"style\":\"solid\",\"width\":{\"value\":\"0\",\"unit\":\"px\"},\"color\":\"rgb(221, 221, 221)\"}}},\"props\":{\"layout\":{\"verticalInnerGap\":3,\"horizontalInnerGap\":3},\"media\":{\"mobile\":{\"layout\":{\"horizontalInnerGap\":2,\"verticalInnerGap\":2}},\"tablet\":{\"layout\":{\"horizontalInnerGap\":3,\"verticalInnerGap\":3}}},\"verticalAlign\":\"center\"},\"v\":\"1.1\",\"nodes\":[\"881-c34\"]},{\"id\":673,\"type\":\"hop-section\",\"v\":\"1.1\",\"nodes\":[\"881-c2\"],\"props\":{\"width\":\"full-width\"}},{\"id\":674,\"props\":{\"layout\":{\"equalWidth\":false},\"media\":{\"mobile\":{\"layout\":{\"horizontalGap\":2}}}},\"type\":\"hop-row\",\"v\":\"1.1\",\"nodes\":[\"881-c6\"]},{\"id\":675,\"type\":\"hop-column\",\"style\":{\"textAlign\":\"right\",\"media\":{\"mobile\":{\"textAlign\":\"center\",\"padding\":{\"left\":{\"unit\":\"px\"},\"right\":{\"unit\":\"px\"},\"top\":{\"unit\":\"px\"},\"bottom\":{\"unit\":\"px\"}}}},\"descendants\":{\"outer\":{\"media\":{\"mobile\":{\"padding\":{\"left\":{\"unit\":\"px\"},\"right\":{\"unit\":\"px\"}}}}}},\"padding\":{\"left\":{\"unit\":\"px\",\"value\":\"\"},\"right\":{\"unit\":\"px\",\"value\":\"\"},\"top\":{\"unit\":\"px\",\"value\":\"\"},\"bottom\":{\"unit\":\"px\",\"value\":\"\"}}},\"props\":{\"verticalAlign\":\"center\",\"layout\":{\"horizontalInnerGap\":2,\"verticalInnerGap\":2},\"media\":{\"mobile\":{\"layout\":{\"horizontalInnerGap\":2,\"verticalInnerGap\":2}}}},\"v\":\"1.1\",\"nodes\":[\"881-c7\"]},{\"id\":676,\"type\":\"hop-heading\",\"props\":{\"headerType\":\"5\"},\"v\":\"1.1\",\"nodes\":[\"881-c10\"]},{\"id\":677,\"type\":\"hop-heading\",\"props\":{\"headerType\":\"2\"},\"v\":\"1.1\",\"nodes\":[\"881-c11\"]},{\"id\":678,\"type\":\"hop-text\",\"v\":\"1.1\",\"nodes\":[\"881-c12\"]},{\"id\":679,\"type\":\"hop-button-group\",\"v\":\"1.1\",\"nodes\":[\"881-c13\"]},{\"id\":680,\"type\":\"hop-button\",\"style\":{\"textAlign\":\"center\",\"background\":{\"color\":\"${theme.colors.1}\"},\"typography\":{\"color\":\"#fff\",\"family\":\"Open Sans\",\"margin\":{\"top\":\"\",\"bottom\":\"2rem\"},\"size\":{\"unit\":\"px\",\"value\":\"12\"},\"weight\":\"600\",\"lineHeight\":{\"value\":\"1\",\"unit\":\"\"},\"transform\":\"uppercase\",\"letterSpacing\":{\"value\":\"1\",\"unit\":\"px\"}},\"border\":{\"top\":{\"color\":\"${theme.colors.1}\",\"style\":\"solid\",\"width\":{\"value\":\"2\",\"unit\":\"px\"},\"radius\":{\"right\":{\"value\":0,\"unit\":\"px\",\"path\":\"value\"},\"left\":{\"value\":0,\"unit\":\"px\",\"path\":\"value\"}}},\"bottom\":{\"color\":\"${theme.colors.1}\",\"style\":\"solid\",\"width\":{\"value\":\"2\",\"unit\":\"px\"},\"radius\":{\"right\":{\"value\":0,\"unit\":\"px\",\"path\":\"value\"},\"left\":{\"value\":0,\"unit\":\"px\",\"path\":\"value\"}}},\"right\":{\"color\":\"${theme.colors.1}\",\"style\":\"solid\",\"width\":{\"value\":\"2\",\"unit\":\"px\"}},\"left\":{\"color\":\"${theme.colors.1}\",\"style\":\"solid\",\"width\":{\"value\":\"2\",\"unit\":\"px\"}}},\"padding\":{\"top\":{\"unit\":\"px\",\"value\":\"12\"},\"bottom\":{\"unit\":\"px\",\"value\":\"12\"},\"left\":{\"unit\":\"px\",\"value\":\"24\"},\"right\":{\"unit\":\"px\",\"value\":\"24\"}},\"states\":{\"hover\":{\"background\":{\"color\":\"${theme.colors.1|variant3}\"},\"border\":{\"top\":{\"color\":\"${theme.colors.1|variant3}\"},\"right\":{\"color\":\"${theme.colors.1|variant3}\"},\"bottom\":{\"color\":\"${theme.colors.1|variant3}\"},\"left\":{\"color\":\"${theme.colors.1|variant3}\"}}}},\"descendants\":{\"icon\":{\"size\":{\"unit\":\"px\",\"value\":\"12\"},\"margin\":{\"left\":{\"value\":\"0\",\"unit\":\"px\"},\"right\":{\"value\":\"10\",\"unit\":\"px\"}}}}},\"v\":\"1.1\",\"nodes\":[\"881-c14\"]},{\"id\":681,\"type\":\"hop-column\",\"props\":{\"verticalAlign\":\"center\",\"media\":{\"mobile\":{\"layout\":{\"horizontalInnerGap\":2,\"verticalInnerGap\":2}}},\"layout\":{\"horizontalInnerGap\":2,\"verticalInnerGap\":2}},\"style\":{\"media\":{\"mobile\":{\"padding\":{\"left\":{\"unit\":\"px\"},\"right\":{\"unit\":\"px\"},\"top\":{\"unit\":\"px\"},\"bottom\":{\"unit\":\"px\"}}}},\"padding\":{\"left\":{\"unit\":\"px\",\"value\":\"\"},\"right\":{\"unit\":\"px\",\"value\":\"\"},\"top\":{\"unit\":\"px\",\"value\":\"\"},\"bottom\":{\"unit\":\"px\",\"value\":\"\"}}},\"v\":\"1.1\",\"nodes\":[\"881-c9\"]},{\"id\":682,\"type\":\"hop-image\",\"style\":{\"descendants\":{\"frameImage\":{\"border\":{\"top\":{\"color\":\"${theme.colors.1}\"},\"left\":{\"color\":\"${theme.colors.1}\"},\"right\":{\"color\":\"${theme.colors.1}\"},\"bottom\":{\"color\":\"${theme.colors.1}\"}},\"backgroundColor\":\"${theme.colors.1}\",\"height\":{\"path\":\"value\",\"value\":\"100\"},\"transform\":{\"translate\":{\"y\":{\"path\":\"value\",\"value\":\"-5\"},\"x\":{\"path\":\"value\",\"value\":\"5\"}}},\"width\":{\"path\":\"value\",\"value\":\"100\"},\"media\":{\"tablet\":{\"transform\":{\"translate\":{\"x\":{\"path\":\"value\",\"value\":\"5\"}}}}}}}},\"props\":{\"enabledFrameOption\":true,\"media\":{\"mobile\":{\"enabledFrameOption\":false}}},\"v\":\"1.1\",\"nodes\":[\"881-c8\"]},{\"id\":685,\"type\":\"hop-section\",\"nodeId\":\"881-c51\",\"nodes\":[\"881-c51\"],\"v\":\"1.1\",\"style\":{\"media\":{\"mobile\":[],\"tablet\":[]},\"background\":{\"color\":\"#F5FAFD\"}}},{\"id\":686,\"props\":{\"layout\":{\"equalWidth\":false}},\"type\":\"hop-row\",\"nodeId\":\"881-c52\",\"nodes\":[\"881-c52\"],\"v\":\"1.1\",\"style\":{\"media\":{\"mobile\":[],\"tablet\":[]}}},{\"id\":687,\"type\":\"hop-column\",\"nodeId\":\"881-c53\",\"nodes\":[\"881-c53\"],\"v\":\"1.1\",\"style\":{\"media\":{\"mobile\":[],\"tablet\":[]}}},{\"id\":695,\"type\":\"hop-section\",\"style\":{\"padding\":{\"top\":{\"path\":\"value\",\"value\":\"0\"},\"bottom\":{\"value\":\"0\"}},\"media\":{\"mobile\":{\"margin\":{\"top\":{\"value\":\"0\",\"unit\":\"px\"},\"right\":{\"unit\":\"px\"},\"bottom\":{\"unit\":\"px\"},\"left\":{\"unit\":\"px\"}}}},\"descendants\":{\"inner\":{\"margin\":{\"top\":{\"value\":-50,\"unit\":\"px\",\"path\":\"value\"}}}},\"background\":{\"color\":\"#F5FAFD\"}},\"v\":\"1.1\",\"nodes\":[\"881-c15\"],\"props\":{\"width\":\"full-width\"}},{\"id\":696,\"props\":{\"layout\":{\"equalWidth\":true,\"itemsPerRow\":4,\"horizontalGap\":0,\"verticalGap\":0},\"media\":{\"mobile\":{\"layout\":{\"horizontalGap\":2,\"verticalGap\":2}}}},\"type\":\"hop-row\",\"style\":{\"boxShadow\":{\"enabled\":true,\"layers\":[{\"color\":\"rgba(74, 74, 74, 0.3)\",\"y\":\"4\"}]},\"background\":{\"color\":\"${theme.colors.4}\"},\"media\":{\"mobile\":{\"margin\":{\"top\":{\"value\":\"15\",\"unit\":\"px\"},\"right\":{\"value\":\"15\",\"unit\":\"px\"},\"bottom\":{\"value\":\"15\",\"unit\":\"px\"},\"left\":{\"value\":\"15\",\"unit\":\"px\"}}}}},\"v\":\"1.1\",\"nodes\":[\"881-c19\"]},{\"id\":697,\"type\":\"hop-column\",\"style\":{\"textAlign\":\"center\",\"media\":{\"mobile\":{\"textAlign\":\"center\",\"padding\":{\"left\":{\"unit\":\"px\"},\"right\":{\"unit\":\"px\"},\"top\":{\"unit\":\"px\"},\"bottom\":{\"unit\":\"px\"}}},\"tablet\":{\"padding\":{\"left\":{\"unit\":\"px\"},\"right\":{\"unit\":\"px\"},\"top\":{\"unit\":\"px\"},\"bottom\":{\"unit\":\"px\"}}}},\"descendants\":{\"outer\":{\"media\":{\"mobile\":{\"padding\":{\"left\":{\"unit\":\"px\"},\"right\":{\"unit\":\"px\"},\"top\":{\"unit\":\"px\"},\"bottom\":{\"unit\":\"px\"}}}},\"padding\":{\"left\":{\"unit\":\"px\"},\"right\":{\"unit\":\"px\"},\"top\":{\"unit\":\"px\"},\"bottom\":{\"unit\":\"px\"}}}},\"padding\":{\"left\":{\"unit\":\"px\"},\"right\":{\"unit\":\"px\"},\"top\":{\"unit\":\"px\"},\"bottom\":{\"unit\":\"px\"}},\"border\":{\"top\":{\"radius\":{\"left\":{\"unit\":\"px\"},\"right\":{\"unit\":\"px\"}},\"style\":\"solid\",\"width\":{\"value\":\"0\",\"unit\":\"px\"},\"color\":\"rgb(221, 221, 221)\"},\"bottom\":{\"radius\":{\"left\":{\"unit\":\"px\"},\"right\":{\"unit\":\"px\"}},\"style\":\"solid\",\"width\":{\"value\":\"0\",\"unit\":\"px\"},\"color\":\"rgb(221, 221, 221)\"},\"right\":{\"style\":\"solid\",\"width\":{\"value\":\"1\",\"unit\":\"px\"},\"color\":\"rgb(221, 221, 221)\"},\"left\":{\"style\":\"solid\",\"width\":{\"value\":\"0\",\"unit\":\"px\"},\"color\":\"rgb(221, 221, 221)\"}}},\"props\":{\"layout\":{\"verticalInnerGap\":3,\"horizontalInnerGap\":3},\"media\":{\"mobile\":{\"layout\":{\"horizontalInnerGap\":2,\"verticalInnerGap\":2}},\"tablet\":{\"layout\":{\"horizontalInnerGap\":3,\"verticalInnerGap\":3}}},\"verticalAlign\":\"center\"},\"v\":\"1.1\",\"nodes\":[\"881-c20\",\"881-c23\",\"881-c26\"]},{\"id\":699,\"type\":\"hop-heading\",\"style\":{\"typography\":{\"transform\":\"uppercase\",\"letterSpacing\":{\"unit\":\"px\",\"value\":\"1\"}}},\"props\":{\"headerType\":\"5\"},\"v\":\"1.1\",\"nodes\":[\"881-c22\",\"881-c25\",\"881-c31\"]},{\"id\":701,\"type\":\"hop-column\",\"style\":{\"textAlign\":\"center\",\"media\":{\"mobile\":{\"textAlign\":\"center\",\"padding\":{\"left\":{\"unit\":\"px\"},\"right\":{\"unit\":\"px\"},\"top\":{\"unit\":\"px\"},\"bottom\":{\"unit\":\"px\"}}},\"tablet\":{\"padding\":{\"left\":{\"unit\":\"px\"},\"right\":{\"unit\":\"px\"},\"top\":{\"unit\":\"px\"},\"bottom\":{\"unit\":\"px\"}}}},\"descendants\":{\"outer\":{\"media\":{\"mobile\":{\"padding\":{\"left\":{\"unit\":\"px\"},\"right\":{\"unit\":\"px\"},\"top\":{\"unit\":\"px\"},\"bottom\":{\"unit\":\"px\"}}}},\"padding\":{\"left\":{\"unit\":\"px\"},\"right\":{\"unit\":\"px\"},\"top\":{\"unit\":\"px\"},\"bottom\":{\"unit\":\"px\"}}}},\"padding\":{\"left\":{\"unit\":\"px\"},\"right\":{\"unit\":\"px\"},\"top\":{\"unit\":\"px\"},\"bottom\":{\"unit\":\"px\"}},\"border\":{\"top\":{\"radius\":{\"left\":{\"unit\":\"px\"},\"right\":{\"unit\":\"px\"}},\"style\":\"solid\",\"width\":{\"value\":\"0\",\"unit\":\"px\"},\"color\":\"rgb(221, 221, 221)\"},\"bottom\":{\"radius\":{\"left\":{\"unit\":\"px\"},\"right\":{\"unit\":\"px\"}},\"style\":\"solid\",\"width\":{\"value\":\"0\",\"unit\":\"px\"},\"color\":\"rgb(221, 221, 221)\"},\"right\":{\"style\":\"solid\",\"width\":{\"value\":\"0\",\"unit\":\"px\"},\"color\":\"rgb(221, 221, 221)\"},\"left\":{\"style\":\"solid\",\"width\":{\"value\":\"0\",\"unit\":\"px\"},\"color\":\"rgb(221, 221, 221)\"}}},\"props\":{\"layout\":{\"verticalInnerGap\":3,\"horizontalInnerGap\":3},\"media\":{\"mobile\":{\"layout\":{\"horizontalInnerGap\":2,\"verticalInnerGap\":2}},\"tablet\":{\"layout\":{\"horizontalInnerGap\":3,\"verticalInnerGap\":3}}},\"verticalAlign\":\"center\"},\"v\":\"1.1\",\"nodes\":[\"881-c29\"]},{\"id\":702,\"type\":\"hop-section\",\"style\":{\"padding\":{\"top\":{\"path\":\"value\",\"value\":\"0\"},\"bottom\":{\"value\":\"0\"}},\"media\":{\"mobile\":{\"margin\":{\"top\":{\"value\":\"0\",\"unit\":\"px\"},\"right\":{\"unit\":\"px\"},\"bottom\":{\"unit\":\"px\"},\"left\":{\"unit\":\"px\"}}}},\"descendants\":{\"inner\":{\"margin\":{\"top\":{\"value\":0,\"unit\":\"px\",\"path\":\"value\"}}}}},\"v\":\"1.1\",\"nodes\":[\"881-c32\"],\"props\":{\"width\":\"full-width\"}},{\"id\":703,\"props\":{\"layout\":{\"equalWidth\":true,\"itemsPerRow\":3,\"horizontalGap\":0,\"verticalGap\":0},\"media\":{\"mobile\":{\"layout\":{\"horizontalGap\":2,\"verticalGap\":2}}}},\"type\":\"hop-row\",\"style\":{\"boxShadow\":{\"enabled\":true,\"layers\":[{\"color\":\"rgba(74, 74, 74, 0.3)\",\"y\":\"4\"}]},\"background\":{\"color\":\"${theme.colors.4}\"},\"media\":{\"mobile\":{\"margin\":{\"top\":{\"value\":\"15\",\"unit\":\"px\"},\"right\":{\"value\":\"15\",\"unit\":\"px\"},\"bottom\":{\"value\":\"15\",\"unit\":\"px\"},\"left\":{\"value\":\"15\",\"unit\":\"px\"}}}}},\"v\":\"1.1\",\"nodes\":[\"881-c33\"]},{\"id\":704,\"type\":\"hop-column\",\"style\":{\"textAlign\":\"center\",\"media\":{\"mobile\":{\"textAlign\":\"center\",\"padding\":{\"left\":{\"unit\":\"px\"},\"right\":{\"unit\":\"px\"},\"top\":{\"unit\":\"px\"},\"bottom\":{\"unit\":\"px\"}}},\"tablet\":{\"padding\":{\"left\":{\"unit\":\"px\"},\"right\":{\"unit\":\"px\"},\"top\":{\"unit\":\"px\"},\"bottom\":{\"unit\":\"px\"}}}},\"descendants\":{\"outer\":{\"media\":{\"mobile\":{\"padding\":{\"left\":{\"unit\":\"px\"},\"right\":{\"unit\":\"px\"},\"top\":{\"unit\":\"px\"},\"bottom\":{\"unit\":\"px\"}}}},\"padding\":{\"left\":{\"unit\":\"px\"},\"right\":{\"unit\":\"px\"},\"top\":{\"unit\":\"px\"},\"bottom\":{\"unit\":\"px\"}}}},\"padding\":{\"left\":{\"unit\":\"px\"},\"right\":{\"unit\":\"px\"},\"top\":{\"unit\":\"px\"},\"bottom\":{\"unit\":\"px\"}},\"border\":{\"top\":{\"radius\":{\"left\":{\"unit\":\"px\"},\"right\":{\"unit\":\"px\"}},\"style\":\"solid\",\"width\":{\"value\":\"0\",\"unit\":\"px\"},\"color\":\"rgb(221, 221, 221)\"},\"bottom\":{\"radius\":{\"left\":{\"unit\":\"px\"},\"right\":{\"unit\":\"px\"}},\"style\":\"solid\",\"width\":{\"value\":\"0\",\"unit\":\"px\"},\"color\":\"rgb(221, 221, 221)\"},\"right\":{\"style\":\"solid\",\"width\":{\"value\":\"1\",\"unit\":\"px\"},\"color\":\"rgb(221, 221, 221)\"},\"left\":{\"style\":\"solid\",\"width\":{\"value\":\"0\",\"unit\":\"px\"},\"color\":\"rgb(221, 221, 221)\"}}},\"props\":{\"layout\":{\"verticalInnerGap\":3,\"horizontalInnerGap\":3},\"media\":{\"mobile\":{\"layout\":{\"horizontalInnerGap\":2,\"verticalInnerGap\":2}},\"tablet\":{\"layout\":{\"horizontalInnerGap\":3,\"verticalInnerGap\":3}}},\"verticalAlign\":\"center\"},\"v\":\"1.1\",\"nodes\":[\"881-c34\",\"881-c37\"]},{\"id\":705,\"type\":\"hop-icon\",\"style\":{\"descendants\":{\"icon\":{\"fill\":\"${theme.colors.4|variant4}\",\"width\":{\"path\":\"value\",\"value\":\"64\"},\"height\":{\"path\":\"value\",\"value\":\"64\"},\"border\":{\"top\":{\"style\":\"none\",\"width\":{\"value\":\"2\",\"unit\":\"px\"},\"color\":\"${theme.colors.1}\",\"radius\":{\"left\":{\"value\":\"300\",\"unit\":\"px\"},\"right\":{\"value\":\"300\",\"unit\":\"px\"}}},\"right\":{\"style\":\"none\",\"width\":{\"value\":\"2\",\"unit\":\"px\"},\"color\":\"${theme.colors.1}\"},\"bottom\":{\"style\":\"none\",\"width\":{\"value\":\"2\",\"unit\":\"px\"},\"color\":\"${theme.colors.1}\",\"radius\":{\"left\":{\"value\":\"300\",\"unit\":\"px\"},\"right\":{\"value\":\"300\",\"unit\":\"px\"}}},\"left\":{\"style\":\"none\",\"width\":{\"value\":\"2\",\"unit\":\"px\"},\"color\":\"${theme.colors.1}\"}},\"padding\":{\"top\":{\"path\":\"value\",\"value\":\"11\"},\"left\":{\"path\":\"value\",\"value\":\"11\"},\"right\":{\"path\":\"value\",\"value\":\"11\"},\"bottom\":{\"path\":\"value\",\"value\":\"11\"}}}}},\"v\":\"1.1\",\"nodes\":[\"881-c35\",\"881-c38\",\"881-c41\"]},{\"id\":706,\"type\":\"hop-heading\",\"style\":{\"typography\":{\"transform\":\"uppercase\",\"letterSpacing\":{\"unit\":\"px\",\"value\":\"1\"}}},\"props\":{\"headerType\":\"5\"},\"v\":\"1.1\",\"nodes\":[\"881-c36\",\"881-c39\",\"881-c42\"]},{\"id\":708,\"type\":\"hop-column\",\"style\":{\"textAlign\":\"center\",\"media\":{\"mobile\":{\"textAlign\":\"center\",\"padding\":{\"left\":{\"unit\":\"px\"},\"right\":{\"unit\":\"px\"},\"top\":{\"unit\":\"px\"},\"bottom\":{\"unit\":\"px\"}}},\"tablet\":{\"padding\":{\"left\":{\"unit\":\"px\"},\"right\":{\"unit\":\"px\"},\"top\":{\"unit\":\"px\"},\"bottom\":{\"unit\":\"px\"}}}},\"descendants\":{\"outer\":{\"media\":{\"mobile\":{\"padding\":{\"left\":{\"unit\":\"px\"},\"right\":{\"unit\":\"px\"},\"top\":{\"unit\":\"px\"},\"bottom\":{\"unit\":\"px\"}}}},\"padding\":{\"left\":{\"unit\":\"px\"},\"right\":{\"unit\":\"px\"},\"top\":{\"unit\":\"px\"},\"bottom\":{\"unit\":\"px\"}}}},\"padding\":{\"left\":{\"unit\":\"px\"},\"right\":{\"unit\":\"px\"},\"top\":{\"unit\":\"px\"},\"bottom\":{\"unit\":\"px\"}},\"border\":{\"top\":{\"radius\":{\"left\":{\"unit\":\"px\"},\"right\":{\"unit\":\"px\"}},\"style\":\"solid\",\"width\":{\"value\":\"0\",\"unit\":\"px\"},\"color\":\"rgb(221, 221, 221)\"},\"bottom\":{\"radius\":{\"left\":{\"unit\":\"px\"},\"right\":{\"unit\":\"px\"}},\"style\":\"solid\",\"width\":{\"value\":\"0\",\"unit\":\"px\"},\"color\":\"rgb(221, 221, 221)\"},\"right\":{\"style\":\"solid\",\"width\":{\"value\":\"0\",\"unit\":\"px\"},\"color\":\"rgb(221, 221, 221)\"},\"left\":{\"style\":\"solid\",\"width\":{\"value\":\"0\",\"unit\":\"px\"},\"color\":\"rgb(221, 221, 221)\"}}},\"props\":{\"layout\":{\"verticalInnerGap\":3,\"horizontalInnerGap\":3},\"media\":{\"mobile\":{\"layout\":{\"horizontalInnerGap\":2,\"verticalInnerGap\":2}},\"tablet\":{\"layout\":{\"horizontalInnerGap\":3,\"verticalInnerGap\":3}}},\"verticalAlign\":\"center\"},\"v\":\"1.1\",\"nodes\":[\"881-c40\"]},{\"id\":709,\"props\":{\"layout\":{\"equalWidth\":false,\"horizontalGap\":0,\"verticalGap\":0}},\"type\":\"hop-row\",\"nodeId\":\"881-c108\",\"nodes\":[\"881-c3\"],\"v\":\"1.1\"},{\"id\":710,\"type\":\"hop-column\",\"nodeId\":\"881-c109\",\"nodes\":[\"881-c4\"],\"v\":\"1.1\",\"style\":{\"descendants\":{\"outer\":{\"padding\":{\"left\":{\"unit\":\"px\",\"value\":\"\"},\"right\":{\"unit\":\"px\",\"value\":\"\"},\"top\":{\"unit\":\"px\",\"value\":\"\"},\"bottom\":{\"unit\":\"px\",\"value\":\"\"}}}},\"padding\":{\"left\":{\"unit\":\"px\",\"value\":\"\"},\"right\":{\"unit\":\"px\",\"value\":\"\"},\"top\":{\"unit\":\"px\",\"value\":\"\"},\"bottom\":{\"unit\":\"px\",\"value\":\"\"}}},\"props\":{\"layout\":{\"horizontalInnerGap\":0,\"verticalInnerGap\":0,\"vSpace\":{\"value\":\"0\"}}}},{\"id\":711,\"type\":\"hop-heading\",\"nodeId\":\"881-c110\",\"nodes\":[\"881-c5\"],\"v\":\"1.1\",\"props\":{\"headerType\":\"3\"}},{\"id\":712,\"props\":{\"layout\":{\"equalWidth\":false}},\"type\":\"hop-row\",\"nodeId\":\"881-c111\",\"nodes\":[\"881-c16\"],\"v\":\"1.1\"},{\"id\":713,\"type\":\"hop-column\",\"nodeId\":\"881-c112\",\"nodes\":[\"881-c17\"],\"v\":\"1.1\"},{\"id\":714,\"type\":\"hop-heading\",\"nodeId\":\"881-c113\",\"nodes\":[\"881-c18\"],\"v\":\"1.1\",\"style\":{\"typography\":{\"letterSpacing\":{\"unit\":\"px\",\"value\":\"10\"}}}},{\"id\":718,\"type\":\"hop-heading\",\"props\":{\"headerType\":\"5\"},\"v\":\"1.1\",\"nodes\":[\"236-c5\"]},{\"id\":719,\"type\":\"hop-heading\",\"props\":{\"headerType\":\"2\"},\"v\":\"1.1\",\"nodes\":[\"236-c6\"],\"style\":{\"textAlign\":\"center\"}},{\"id\":720,\"type\":\"hop-text\",\"v\":\"1.1\",\"nodes\":[\"236-c7\"]},{\"id\":721,\"type\":\"hop-button-group\",\"v\":\"1.1\",\"nodes\":[\"236-c8\"]},{\"id\":722,\"type\":\"hop-button\",\"style\":{\"textAlign\":\"center\",\"background\":{\"color\":\"${theme.colors.1}\"},\"typography\":{\"color\":\"#fff\",\"family\":\"Open Sans\",\"margin\":{\"top\":\"\",\"bottom\":\"2rem\"},\"size\":{\"unit\":\"px\",\"value\":\"12\"},\"weight\":\"600\",\"lineHeight\":{\"value\":\"1\",\"unit\":\"\"},\"transform\":\"uppercase\",\"letterSpacing\":{\"value\":\"1\",\"unit\":\"px\"}},\"border\":{\"top\":{\"color\":\"${theme.colors.1}\",\"style\":\"solid\",\"width\":{\"value\":\"2\",\"unit\":\"px\"},\"radius\":{\"right\":{\"value\":0,\"unit\":\"px\",\"path\":\"value\"},\"left\":{\"value\":0,\"unit\":\"px\",\"path\":\"value\"}}},\"bottom\":{\"color\":\"${theme.colors.1}\",\"style\":\"solid\",\"width\":{\"value\":\"2\",\"unit\":\"px\"},\"radius\":{\"right\":{\"value\":0,\"unit\":\"px\",\"path\":\"value\"},\"left\":{\"value\":0,\"unit\":\"px\",\"path\":\"value\"}}},\"right\":{\"color\":\"${theme.colors.1}\",\"style\":\"solid\",\"width\":{\"value\":\"2\",\"unit\":\"px\"}},\"left\":{\"color\":\"${theme.colors.1}\",\"style\":\"solid\",\"width\":{\"value\":\"2\",\"unit\":\"px\"}}},\"padding\":{\"top\":{\"unit\":\"px\",\"value\":\"12\"},\"bottom\":{\"unit\":\"px\",\"value\":\"12\"},\"left\":{\"unit\":\"px\",\"value\":\"24\"},\"right\":{\"unit\":\"px\",\"value\":\"24\"}},\"states\":{\"hover\":{\"background\":{\"color\":\"${theme.colors.1|variant3}\"},\"border\":{\"top\":{\"color\":\"${theme.colors.1|variant3}\"},\"right\":{\"color\":\"${theme.colors.1|variant3}\"},\"bottom\":{\"color\":\"${theme.colors.1|variant3}\"},\"left\":{\"color\":\"${theme.colors.1|variant3}\"}}}},\"descendants\":{\"icon\":{\"size\":{\"unit\":\"px\",\"value\":\"12\"},\"margin\":{\"left\":{\"value\":\"0\",\"unit\":\"px\"},\"right\":{\"value\":\"10\",\"unit\":\"px\"}}}}},\"v\":\"1.1\",\"nodes\":[\"236-c9\"]},{\"id\":724,\"type\":\"hop-image\",\"style\":{\"descendants\":{\"frameImage\":{\"border\":{\"top\":{\"color\":\"${theme.colors.1}\"},\"left\":{\"color\":\"${theme.colors.1}\"},\"right\":{\"color\":\"${theme.colors.1}\"},\"bottom\":{\"color\":\"${theme.colors.1}\"}},\"backgroundColor\":\"${theme.colors.1}\",\"height\":{\"path\":\"value\",\"value\":\"100\"},\"transform\":{\"translate\":{\"y\":{\"path\":\"value\",\"value\":\"-5\"},\"x\":{\"path\":\"value\",\"value\":\"5\"}}},\"width\":{\"path\":\"value\",\"value\":\"100\"},\"media\":{\"tablet\":{\"transform\":{\"translate\":{\"x\":{\"path\":\"value\",\"value\":\"5\"}}}}}}}},\"props\":{\"enabledFrameOption\":true,\"media\":{\"mobile\":{\"enabledFrameOption\":false}}},\"v\":\"1.1\",\"nodes\":[\"236-c11\"]},{\"id\":725,\"props\":{\"layout\":{\"equalWidth\":false,\"horizontalGap\":0,\"verticalGap\":0,\"horizontalInnerGap\":2,\"verticalInnerGap\":2}},\"type\":\"hop-row\",\"nodeId\":\"236-c89\",\"nodes\":[\"236-c3\"],\"v\":\"1.1\"},{\"id\":726,\"type\":\"hop-column\",\"nodeId\":\"236-c90\",\"nodes\":[\"236-c4\"],\"v\":\"1.1\",\"props\":{\"verticalAlign\":\"center\"},\"style\":{\"descendants\":{\"outer\":{\"padding\":{\"left\":{\"unit\":\"px\",\"value\":\"\"},\"right\":{\"unit\":\"px\",\"value\":\"\"},\"top\":{\"unit\":\"px\",\"value\":\"\"},\"bottom\":{\"unit\":\"px\",\"value\":\"\"}}}},\"padding\":{\"left\":{\"unit\":\"px\",\"value\":\"\"},\"right\":{\"unit\":\"px\",\"value\":\"\"},\"top\":{\"unit\":\"px\",\"value\":\"\"},\"bottom\":{\"unit\":\"px\",\"value\":\"\"}}}},{\"id\":727,\"type\":\"hop-column\",\"nodeId\":\"236-c91\",\"nodes\":[\"236-c10\"],\"v\":\"1.1\",\"style\":{\"descendants\":{\"outer\":{\"padding\":{\"left\":{\"unit\":\"px\",\"value\":\"\"},\"right\":{\"unit\":\"px\",\"value\":\"\"},\"top\":{\"unit\":\"px\",\"value\":\"\"},\"bottom\":{\"unit\":\"px\",\"value\":\"\"}}}},\"padding\":{\"left\":{\"unit\":\"px\",\"value\":\"\"},\"right\":{\"unit\":\"px\",\"value\":\"\"},\"top\":{\"unit\":\"px\",\"value\":\"\"},\"bottom\":{\"unit\":\"px\",\"value\":\"\"}}}},{\"id\":728,\"type\":\"hop-header\",\"v\":\"1.1\",\"nodes\":[\"18-h1\"]},{\"id\":729,\"style\":{\"ancestor\":{\"sticky\":{\"background\":{\"color\":\"#ffffff\"},\"padding\":{\"top\":{\"path\":\"value\",\"value\":\"0\"},\"bottom\":{\"path\":\"value\",\"value\":\"0\"}},\"media\":{\"mobile\":{\"padding\":{\"top\":{\"path\":\"value\",\"value\":\"0\"},\"bottom\":{\"path\":\"value\",\"value\":\"0\"}}}},\"boxShadow\":{\"enabled\":true,\"layers\":[{\"spread\":\"0\",\"blur\":\"4\"}]}}},\"padding\":{\"top\":{\"path\":\"value\",\"value\":\"3\"},\"bottom\":{\"path\":\"value\",\"value\":\"3\"}},\"media\":{\"mobile\":{\"padding\":{\"top\":{\"path\":\"value\",\"value\":\"0\"},\"bottom\":{\"path\":\"value\",\"value\":\"0\"}}}}},\"type\":\"hop-navigation\",\"props\":{\"overlap\":true,\"sticky\":true,\"stickyStartAt\":\"immediately\",\"showTopBar\":false,\"width\":\"full-width\"},\"v\":\"1.1\",\"nodes\":[\"18-h2\"]},{\"id\":730,\"props\":{\"containerWidth\":\"boxed\",\"layout\":{\"equalWidth\":true,\"itemsPerRow\":1,\"horizontalGap\":0,\"verticalGap\":0,\"horizontalInnerGap\":0,\"verticalInnerGap\":0,\"equalHeight\":true},\"media\":{\"mobile\":{\"layout\":{\"horizontalGap\":2,\"verticalGap\":2}}},\"fullBackground\":true},\"type\":\"hop-row\",\"v\":\"1.1\",\"nodes\":[\"18-h3\"]},{\"id\":731,\"props\":{\"verticalAlign\":\"center\",\"layout\":{\"horizontalInnerGap\":0,\"verticalInnerGap\":0}},\"type\":\"hop-column\",\"style\":{\"descendants\":{\"outer\":{\"padding\":{\"left\":{\"unit\":\"px\"},\"right\":{\"unit\":\"px\"},\"top\":{\"unit\":\"px\"},\"bottom\":{\"unit\":\"px\"}},\"media\":{\"mobile\":{\"padding\":{\"left\":{\"unit\":\"px\"},\"right\":{\"unit\":\"px\"},\"top\":{\"unit\":\"px\"},\"bottom\":{\"unit\":\"px\"}}}}}},\"padding\":{\"left\":{\"unit\":\"px\"},\"right\":{\"unit\":\"px\"},\"top\":{\"unit\":\"px\"},\"bottom\":{\"unit\":\"px\"}}},\"v\":\"1.1\",\"nodes\":[\"18-h4\"]},{\"id\":735,\"props\":{\"verticalAlign\":\"center\"},\"type\":\"hop-column\",\"style\":{\"descendants\":{\"outer\":{\"padding\":{\"left\":{\"unit\":\"px\"},\"right\":{\"unit\":\"px\"},\"top\":{\"unit\":\"px\"},\"bottom\":{\"unit\":\"px\"}}}},\"textAlign\":\"center\",\"media\":{\"mobile\":{\"textAlign\":\"center\"}},\"padding\":{\"left\":{\"unit\":\"px\"},\"right\":{\"unit\":\"px\"},\"top\":{\"unit\":\"px\"},\"bottom\":{\"unit\":\"px\"}}},\"v\":\"1.1\",\"nodes\":[\"18-h4\"]},{\"id\":736,\"type\":\"hop-horizontal-menu\",\"style\":{\"descendants\":{\"item\":{\"margin\":{\"top\":{\"value\":\"0\",\"unit\":\"px\"},\"right\":{\"value\":\"20\",\"unit\":\"px\"},\"bottom\":{\"value\":\"0\",\"unit\":\"px\"},\"left\":{\"value\":\"20\",\"unit\":\"px\"}},\"padding\":{\"top\":{\"value\":\"10\",\"unit\":\"px\"},\"right\":{\"value\":0,\"unit\":\"px\"},\"bottom\":{\"value\":\"10\",\"unit\":\"px\"},\"left\":{\"value\":0,\"unit\":\"px\"}}},\"link\":{\"typography\":{\"weight\":\"600\",\"size\":{\"unit\":\"px\",\"value\":\"14\"},\"transform\":\"uppercase\",\"family\":\"Open Sans\",\"lineHeight\":{\"unit\":\"em\",\"value\":\"1.5\"},\"letterSpacing\":{\"unit\":\"px\",\"value\":\"0\"},\"color\":\"${theme.colors.4}\"},\"states\":{\"hover\":{\"typography\":{\"color\":\"${theme.colors.4}\"}},\"menuButtonActive\":{\"typography\":{\"color\":\"${theme.colors.4}\"}}}},\"submenu\":{\"boxShadow\":{\"enabled\":true,\"layers\":[{\"blur\":\"5\",\"color\":\"rgba(0, 0, 0, 0.04)\"}]}},\"submenu-item\":{\"background\":{\"color\":\"rgb(255, 255, 255)\"},\"states\":{\"hover\":{\"background\":{\"color\":\"${theme.colors.1}\"}},\"menuButtonActive\":{\"background\":{\"color\":\"${theme.colors.0}\"}}}},\"submenu-item-link\":{\"states\":{\"hover\":{\"typography\":{\"color\":\"rgb(255, 255, 255)\"}},\"menuButtonActive\":{\"typography\":{\"color\":\"rgb(255, 255, 255)\"}}},\"typography\":{\"color\":\"${theme.colors.5|variant2}\"}},\"subMenuIcon\":{\"typography\":{\"color\":\"rgb(255, 255, 255)\"}},\"hover-effect-border\":{\"background\":{\"color\":\"${theme.colors.4}\"}},\"innerMenu\":{\"justifyContent\":\"flex-end\"}},\"ancestor\":{\"sticky\":{\"descendants\":{\"link\":{\"states\":{\"menuButtonActive\":{\"typography\":{\"color\":\"${theme.colors.0}\"}},\"hover\":{\"typography\":{\"color\":\"${theme.colors.0}\"}}},\"typography\":{\"color\":\"${theme.colors.0|variant3}\"}},\"submenu-item-link\":{\"typography\":{\"color\":\"${theme.colors.5}\"},\"states\":{\"menuButtonActive\":{\"typography\":{\"color\":\"${theme.colors.4}\"}}}},\"submenu-item\":{\"states\":{\"menuButtonActive\":{\"background\":{\"color\":\"${theme.colors.1}\"}}}}}}}},\"props\":{\"hoverEffect\":{\"type\":\"bordered-active-item bordered-active-item--bottom\",\"activeGroup\":\"border\"}},\"v\":\"1.1\",\"nodes\":[\"18-h5\"]},{\"id\":737,\"type\":\"hop-mobile-menu\",\"v\":\"1.1\",\"nodes\":[\"18-h6\"]},{\"id\":738,\"type\":\"hop-offscreen-panel\",\"v\":\"1.1\",\"nodes\":[\"18-h7\"]},{\"id\":739,\"style\":{\"descendants\":{\"link\":{\"typography\":{\"color\":\"white\"}},\"submenu-item-link\":{\"typography\":{\"color\":\"white\"}},\"iconOption\":{\"typography\":{\"color\":\"white\"}},\"subMenuIcon\":{\"typography\":{\"color\":\"white\"}}}},\"props\":{\"layout\":\"accordion\"},\"type\":\"hop-accordion-menu\",\"v\":\"1.1\",\"nodes\":[\"18-h8\"]},{\"id\":740,\"type\":\"hop-row\",\"v\":\"1.1\",\"nodes\":[\"18-h9\"]},{\"id\":741,\"type\":\"hop-column\",\"v\":\"1.1\",\"nodes\":[\"18-h10\"]},{\"id\":742,\"type\":\"hop-logo\",\"v\":\"1.1\",\"nodes\":[\"18-h11\"]},{\"id\":743,\"type\":\"hop-row\",\"v\":\"1.1\",\"nodes\":[\"18-h12\"]},{\"id\":744,\"type\":\"hop-column\",\"v\":\"1.1\",\"nodes\":[\"18-h13\"]},{\"id\":745,\"type\":\"hop-text\",\"v\":\"1.1\",\"nodes\":[\"18-h14\"]},{\"id\":746,\"style\":{\"typography\":{\"holders\":{\"h1\":{\"color\":\"${theme.colors.4}\"},\"h2\":{\"color\":\"${theme.colors.4}\"},\"h3\":{\"color\":\"${theme.colors.4}\"},\"h4\":{\"color\":\"${theme.colors.4}\"},\"h5\":{\"color\":\"${theme.colors.4}\"},\"h6\":{\"color\":\"${theme.colors.4}\"},\"p\":{\"color\":\"${theme.colors.4}\"}}},\"background\":{\"type\":\"image\",\"overlay\":{\"enabled\":true,\"type\":\"color\",\"gradient\":{\"angle\":\"180\",\"steps\":[{\"color\":\"rgba(42, 245, 152, 0.8)\",\"position\":\"0\"},{\"color\":\"rgba(0, 158, 253, 0.8)\",\"position\":\"100\"}]},\"shape\":{\"value\":\"none\",\"isTile\":false},\"color\":{\"opacity\":0.31,\"value\":\"rgb(114, 83, 2)\"}},\"image\":[{\"source\":{\"type\":\"image\",\"url\":\"http:\\/\\/localhost\\/wordpress\\/wp-content\\/uploads\\/2024\\/10\\/karibea-banniere-1.png\"},\"position\":{\"x\":47.738937015985876,\"y\":31.418853085045424}}],\"slideshow\":{\"slides\":[{\"id\":1,\"url\":\"http:\\/\\/localhost\\/wordpress\\/wp-content\\/uploads\\/2024\\/09\\/cropped-cropped-cropped-cropped-logoKaribea1-1-1.png\"},{\"id\":2,\"url\":\"http:\\/\\/localhost\\/wordpress\\/wp-content\\/uploads\\/2024\\/10\\/colibri-image-600.png\"},{\"id\":3,\"url\":\"http:\\/\\/localhost\\/wordpress\\/wp-content\\/uploads\\/2024\\/10\\/colibri-image-601.png\"}]}},\"padding\":{\"top\":{\"unit\":\"px\",\"value\":\"0\",\"path\":\"value\"},\"bottom\":{\"unit\":\"px\",\"value\":0,\"path\":\"value\"}},\"separatorBottom\":{\"enabled\":true,\"type\":\"wave-brush\",\"negative\":false,\"height\":{\"value\":133}},\"customHeight\":{\"min-height\":{\"unit\":\"vh\",\"value\":53},\"type\":\"full-screen\"},\"separatorTop\":{\"enabled\":false}},\"props\":{\"heroSection\":{\"layout\":\"textWithMediaOnRight\",\"mediaType\":\"hop-image\"},\"attrs\":{\"name\":\"hero\",\"id\":\"hero\"},\"width\":\"boxed\",\"downArrow\":{\"enabled\":false}},\"type\":\"hop-hero\",\"v\":\"1.1\",\"nodes\":[\"18-h21\"]},{\"id\":747,\"props\":{\"layout\":{\"equalWidth\":true,\"horizontalGap\":3,\"verticalGap\":3,\"horizontalInnerGap\":3,\"verticalInnerGap\":3}},\"type\":\"hop-row\",\"v\":\"1.1\",\"nodes\":[\"18-h22\"]},{\"id\":748,\"props\":{\"verticalAlign\":\"center\"},\"type\":\"hop-column\",\"style\":{\"border\":{\"top\":{\"style\":\"solid\",\"radius\":{\"left\":{\"value\":\"9\",\"unit\":\"px\"},\"right\":{\"value\":\"9\",\"unit\":\"px\"}}},\"right\":{\"style\":\"solid\"},\"bottom\":{\"style\":\"solid\",\"radius\":{\"left\":{\"value\":\"9\",\"unit\":\"px\"},\"right\":{\"value\":\"9\",\"unit\":\"px\"}}},\"left\":{\"style\":\"solid\"}},\"textAlign\":\"left\",\"media\":{\"mobile\":{\"textAlign\":\"center\"}},\"padding\":{\"left\":{\"unit\":\"px\",\"value\":\"\"},\"right\":{\"unit\":\"px\",\"value\":\"\"},\"top\":{\"unit\":\"px\",\"value\":\"\"},\"bottom\":{\"unit\":\"px\",\"value\":\"\"}},\"descendants\":{\"outer\":{\"padding\":{\"left\":{\"unit\":\"px\",\"value\":\"\"},\"right\":{\"unit\":\"px\",\"value\":\"\"},\"top\":{\"unit\":\"px\",\"value\":\"\"},\"bottom\":{\"unit\":\"px\",\"value\":\"\"}}}}},\"v\":\"1.1\",\"nodes\":[\"18-h23\"]},{\"id\":756,\"type\":\"hop-down-arrow\",\"v\":\"1.1\",\"props\":{\"type\":\"icon\"},\"style\":{\"bottom\":{\"value\":\"20\"}},\"nodes\":[\"18-h25\"]},{\"id\":757,\"type\":\"hop-down-arrow-scroll-button-group\",\"v\":\"1.1\",\"nodes\":[\"18-h26\"]},{\"id\":758,\"type\":\"hop-down-arrow-scroll-button\",\"style\":{\"textAlign\":\"center\",\"background\":{\"color\":\"${theme.colors.0}\"},\"typography\":{\"color\":\"#fff\",\"family\":\"Open Sans\",\"margin\":{\"top\":\"\",\"bottom\":\"2rem\"},\"size\":{\"unit\":\"px\",\"value\":\"12\"},\"weight\":\"600\",\"lineHeight\":{\"value\":\"1\",\"unit\":\"\"},\"transform\":\"uppercase\",\"letterSpacing\":{\"value\":\"1\",\"unit\":\"px\"}},\"border\":{\"top\":{\"color\":\"${theme.colors.0}\",\"style\":\"solid\",\"width\":{\"value\":\"2\",\"unit\":\"px\"},\"radius\":{\"right\":{\"value\":5,\"unit\":\"px\"},\"left\":{\"value\":5,\"unit\":\"px\"}}},\"bottom\":{\"color\":\"${theme.colors.0}\",\"style\":\"solid\",\"width\":{\"value\":\"2\",\"unit\":\"px\"},\"radius\":{\"right\":{\"value\":5,\"unit\":\"px\"},\"left\":{\"value\":5,\"unit\":\"px\"}}},\"right\":{\"color\":\"${theme.colors.0}\",\"style\":\"solid\",\"width\":{\"value\":\"2\",\"unit\":\"px\"}},\"left\":{\"color\":\"${theme.colors.0}\",\"style\":\"solid\",\"width\":{\"value\":\"2\",\"unit\":\"px\"}}},\"padding\":{\"top\":{\"unit\":\"px\",\"value\":\"12\"},\"bottom\":{\"unit\":\"px\",\"value\":\"12\"},\"left\":{\"unit\":\"px\",\"value\":\"24\"},\"right\":{\"unit\":\"px\",\"value\":\"24\"}},\"states\":{\"hover\":{\"background\":{\"color\":\"${theme.colors.0|variant3}\"},\"border\":{\"top\":{\"color\":\"${theme.colors.0|variant3}\"},\"right\":{\"color\":\"${theme.colors.0|variant3}\"},\"bottom\":{\"color\":\"${theme.colors.0|variant3}\"},\"left\":{\"color\":\"${theme.colors.0|variant3}\"}}}},\"descendants\":{\"icon\":{\"size\":{\"unit\":\"px\",\"value\":\"12\"},\"margin\":{\"left\":{\"value\":\"0\",\"unit\":\"px\"},\"right\":{\"value\":\"10\",\"unit\":\"px\"}}}}},\"v\":\"1.1\",\"props\":{\"buttonSize\":\"medium\",\"buttonWidth\":\"fitToContent\"},\"nodes\":[\"18-h27\"]},{\"id\":759,\"type\":\"hop-down-arrow-scroll-icon\",\"style\":{\"descendants\":{\"icon\":{\"width\":{\"path\":\"value\",\"value\":\"40\"},\"height\":{\"path\":\"value\",\"value\":\"40\"},\"fill\":\"${theme.colors.4}\"}}},\"v\":\"1.1\",\"nodes\":[\"18-h28\"]},{\"id\":760,\"type\":\"hop-column\",\"nodeId\":\"18-h55\",\"nodes\":[\"18-h24\"],\"v\":\"1.1\"},{\"id\":761,\"type\":\"hop-top-bar\",\"props\":{\"width\":\"boxed\"},\"v\":\"1.1\",\"nodes\":[\"220-c24\",\"18-h15\"]},{\"id\":762,\"style\":{\"background\":{\"color\":\"black\"},\"padding\":{\"top\":{\"value\":\"5\",\"unit\":\"px\"},\"right\":{\"unit\":\"px\"},\"bottom\":{\"value\":\"5\",\"unit\":\"px\"},\"left\":{\"unit\":\"px\"}}},\"props\":{\"layout\":{\"equalWidth\":false,\"horizontalGap\":0,\"verticalGap\":0,\"horizontalInnerGap\":0,\"verticalInnerGap\":0},\"fullBackground\":true,\"hide\":{\"mobile\":true}},\"type\":\"hop-row\",\"v\":\"1.1\",\"nodes\":[\"220-c25\",\"18-h16\"]},{\"id\":763,\"props\":{\"verticalAlign\":\"center\"},\"type\":\"hop-column\",\"style\":{\"descendants\":{\"outer\":{\"padding\":{\"left\":{\"unit\":\"px\"},\"right\":{\"unit\":\"px\"},\"top\":{\"unit\":\"px\"},\"bottom\":{\"unit\":\"px\"}}}},\"padding\":{\"left\":{\"unit\":\"px\"},\"right\":{\"unit\":\"px\"},\"top\":{\"unit\":\"px\"},\"bottom\":{\"unit\":\"px\"}},\"textAlign\":\"left\"},\"v\":\"1.1\",\"nodes\":[\"220-c26\",\"18-h17\"]},{\"id\":764,\"type\":\"hop-icon-list\",\"style\":{\"descendants\":{\"li\":{\"padding\":{\"right\":{\"value\":0,\"unit\":\"px\"},\"bottom\":{\"value\":0,\"unit\":\"px\"}}},\"divider\":{\"border\":{\"left\":{\"width\":{\"value\":1,\"unit\":\"px\"}},\"bottom\":{\"width\":{\"value\":0,\"unit\":\"px\"}}},\"height\":{\"value\":100,\"unit\":\"%\"}},\"containerDivider\":{\"height\":{\"value\":100,\"unit\":\"%\"},\"width\":{\"value\":1,\"unit\":\"px\"},\"padding\":{\"left\":{\"value\":10,\"unit\":\"px\"},\"top\":{\"value\":0,\"unit\":\"px\"},\"right\":{\"value\":10,\"unit\":\"px\"},\"bottom\":{\"value\":0,\"unit\":\"px\"}}},\"icon\":{\"width\":{\"path\":\"value\",\"value\":\"18\"},\"fill\":\"${theme.colors.4}\",\"states\":{\"hover\":{\"fill\":\"${theme.colors.4}\",\"background\":{\"color\":\"rgba(3, 169, 244, 0)\"}}},\"height\":{\"path\":\"value\",\"value\":\"18\"},\"border\":{\"top\":{\"style\":\"none\",\"radius\":{\"left\":{\"unit\":\"px\"},\"right\":{\"unit\":\"px\"}},\"width\":{\"value\":\"2\",\"unit\":\"px\"},\"color\":\"${theme.colors.0}\"},\"right\":{\"style\":\"none\",\"width\":{\"value\":\"2\",\"unit\":\"px\"},\"color\":\"${theme.colors.0}\"},\"bottom\":{\"style\":\"none\",\"radius\":{\"left\":{\"unit\":\"px\"},\"right\":{\"unit\":\"px\"}},\"width\":{\"value\":\"2\",\"unit\":\"px\"},\"color\":\"${theme.colors.0}\"},\"left\":{\"style\":\"none\",\"width\":{\"value\":\"2\",\"unit\":\"px\"},\"color\":\"${theme.colors.0}\"}},\"padding\":{\"top\":{\"unit\":\"px\"},\"right\":{\"unit\":\"px\"},\"bottom\":{\"unit\":\"px\"},\"left\":{\"value\":\"0\",\"unit\":\"px\",\"path\":\"value\"}}},\"text\":{\"margin\":{\"left\":{\"path\":\"value\",\"value\":\"5\"}},\"color\":\"${theme.colors.4}\",\"typography\":{\"size\":{\"unit\":\"px\",\"value\":\"14\"}}},\"list-item\":{\"padding\":{\"right\":{\"value\":0,\"unit\":\"px\"},\"bottom\":{\"value\":0,\"unit\":\"px\"}},\"horizontalAlign\":\"start\"}}},\"props\":{\"iconList\":[{\"title\":\"List\",\"link\":{\"newWindow\":false,\"noFollow\":false},\"text\":\"List item #1\",\"allIcons\":false,\"icon\":\"font-awesome\\/check\",\"type\":\"svg\",\"id\":0.15907223444395013},{\"title\":\"List\",\"link\":{\"newWindow\":false,\"noFollow\":false},\"text\":\"List item #2\",\"allIcons\":false,\"icon\":\"font-awesome\\/check\",\"type\":\"svg\",\"id\":0.34341111083051734},{\"title\":\"List\",\"link\":{\"newWindow\":false,\"noFollow\":false},\"text\":\"List item #3\",\"allIcons\":false,\"icon\":\"font-awesome\\/check\",\"type\":\"svg\",\"id\":0.0941660601972718},{\"title\":\"List\",\"link\":{\"newWindow\":false,\"noFollow\":false},\"text\":\"List item #4\",\"allIcons\":false,\"icon\":\"font-awesome\\/check\",\"type\":\"svg\",\"id\":0.5295691579821964}],\"iconAndTextAlign\":\"center\",\"listLayout\":\"horizontal\"},\"v\":\"1.1\",\"nodes\":[\"220-c27\",\"18-h18\"]},{\"id\":766,\"type\":\"hop-social-icons\",\"style\":{\"descendants\":{\"icon-content\":{\"fill\":\"${theme.colors.4|variant1}\",\"states\":{\"hover\":{\"fill\":\"${theme.colors.4}\"}},\"width\":{\"value\":\"20\"},\"height\":{\"value\":\"20\"}},\"icon\":{\"margin\":{\"right\":{\"value\":\"0\"}},\"padding\":{\"top\":{\"value\":\"5\"},\"left\":{\"value\":\"5\"},\"bottom\":{\"value\":\"5\"},\"right\":{\"value\":\"5\"}}}}},\"props\":{\"horizontalAlign\":\"end\",\"media\":{\"mobile\":{\"horizontalAlign\":\"center\"}},\"hide\":{\"mobile\":false}},\"v\":\"1.1\",\"nodes\":[\"220-c3\",\"18-h20\"]},{\"id\":767,\"type\":\"hop-column\",\"nodeId\":\"220-c29\",\"nodes\":[\"220-c4\"],\"v\":\"1.1\"},{\"id\":776,\"style\":{\"typography\":{\"holders\":{\"h1\":{\"color\":\"${theme.colors.4}\"},\"h2\":{\"color\":\"${theme.colors.4}\"},\"h3\":{\"color\":\"${theme.colors.4}\"},\"h4\":{\"color\":\"${theme.colors.4}\"},\"h5\":{\"color\":\"${theme.colors.4}\"},\"h6\":{\"color\":\"${theme.colors.4}\"},\"p\":{\"color\":\"${theme.colors.4}\"}}},\"background\":{\"type\":\"image\",\"image\":[{\"source\":{\"url\":\"http:\\/\\/localhost\\/wordpress\\/wp-content\\/uploads\\/2024\\/10\\/karibea-banniere-1.png\"}}],\"overlay\":{\"enabled\":true}},\"padding\":{\"top\":{\"unit\":\"px\",\"value\":\"150\"},\"bottom\":{\"unit\":\"px\",\"value\":\"150\"}},\"media\":{\"mobile\":[],\"tablet\":[]},\"separatorBottom\":{\"enabled\":true,\"negative\":false,\"height\":{\"unit\":\"px\",\"value\":98},\"type\":\"wave-brush\",\"color\":\"white\"},\"customHeight\":{\"type\":\"min-height\",\"min-height\":{\"unit\":\"px\",\"value\":728}}},\"props\":{\"heroSection\":{\"layout\":\"textWithMediaOnRight\",\"mediaType\":\"hop-image\"},\"attrs\":{\"name\":\"hero\",\"id\":\"hero\"},\"width\":\"full-width\"},\"type\":\"hop-hero\",\"nodeId\":\"18-h24\",\"nodes\":[\"18-h24\"],\"v\":\"1.1\"},{\"id\":777,\"props\":{\"layout\":{\"equalWidth\":false}},\"type\":\"hop-row\",\"nodeId\":\"18-h25\",\"nodes\":[\"18-h25\"],\"style\":{\"media\":{\"mobile\":[],\"tablet\":[]}},\"v\":\"1.1\"},{\"id\":778,\"props\":{\"verticalAlign\":\"center\"},\"type\":\"hop-column\",\"node